import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { ChimeSDKVoiceClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ChimeSDKVoiceClient";
import { GetSipRuleRequest, GetSipRuleResponse } from "../models/models_0";
/**
 * The input for {@link GetSipRuleCommand}.
 */
export interface GetSipRuleCommandInput extends GetSipRuleRequest {
}
/**
 * The output of {@link GetSipRuleCommand}.
 */
export interface GetSipRuleCommandOutput extends GetSipRuleResponse, __MetadataBearer {
}
export declare class GetSipRuleCommand extends $Command<GetSipRuleCommandInput, GetSipRuleCommandOutput, ChimeSDKVoiceClientResolvedConfig> {
    readonly input: GetSipRuleCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: GetSipRuleCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: ChimeSDKVoiceClientResolvedConfig, options?: __HttpHandlerOptions): Handler<GetSipRuleCommandInput, GetSipRuleCommandOutput>;
    private serialize;
    private deserialize;
}
