import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { ChimeSDKVoiceClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ChimeSDKVoiceClient";
import { RestorePhoneNumberRequest, RestorePhoneNumberResponse } from "../models/models_0";
/**
 * The input for {@link RestorePhoneNumberCommand}.
 */
export interface RestorePhoneNumberCommandInput extends RestorePhoneNumberRequest {
}
/**
 * The output of {@link RestorePhoneNumberCommand}.
 */
export interface RestorePhoneNumberCommandOutput extends RestorePhoneNumberResponse, __MetadataBearer {
}
export declare class RestorePhoneNumberCommand extends $Command<RestorePhoneNumberCommandInput, RestorePhoneNumberCommandOutput, ChimeSDKVoiceClientResolvedConfig> {
    readonly input: RestorePhoneNumberCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: RestorePhoneNumberCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: ChimeSDKVoiceClientResolvedConfig, options?: __HttpHandlerOptions): Handler<RestorePhoneNumberCommandInput, RestorePhoneNumberCommandOutput>;
    private serialize;
    private deserialize;
}
