import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { ChimeSDKVoiceClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ChimeSDKVoiceClient";
import { ValidateE911AddressRequest, ValidateE911AddressResponse } from "../models/models_0";
/**
 * The input for {@link ValidateE911AddressCommand}.
 */
export interface ValidateE911AddressCommandInput extends ValidateE911AddressRequest {
}
/**
 * The output of {@link ValidateE911AddressCommand}.
 */
export interface ValidateE911AddressCommandOutput extends ValidateE911AddressResponse, __MetadataBearer {
}
export declare class ValidateE911AddressCommand extends $Command<ValidateE911AddressCommandInput, ValidateE911AddressCommandOutput, ChimeSDKVoiceClientResolvedConfig> {
    readonly input: ValidateE911AddressCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    constructor(input: ValidateE911AddressCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: ChimeSDKVoiceClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ValidateE911AddressCommandInput, ValidateE911AddressCommandOutput>;
    private serialize;
    private deserialize;
}
