import { ExceptionOptionType as __ExceptionOptionType } from "@aws-sdk/smithy-client";
import { ChimeSDKVoiceServiceException as __BaseException } from "./ChimeSDKVoiceServiceException";
export declare enum ErrorCode {
    AccessDenied = "AccessDenied",
    BadRequest = "BadRequest",
    Conflict = "Conflict",
    Forbidden = "Forbidden",
    Gone = "Gone",
    NotFound = "NotFound",
    PhoneNumberAssociationsExist = "PhoneNumberAssociationsExist",
    PreconditionFailed = "PreconditionFailed",
    ResourceLimitExceeded = "ResourceLimitExceeded",
    ServiceFailure = "ServiceFailure",
    ServiceUnavailable = "ServiceUnavailable",
    Throttled = "Throttled",
    Throttling = "Throttling",
    Unauthorized = "Unauthorized",
    Unprocessable = "Unprocessable",
    VoiceConnectorGroupAssociationsExist = "VoiceConnectorGroupAssociationsExist"
}
export declare class AccessDeniedException extends __BaseException {
    readonly name: "AccessDeniedException";
    readonly $fault: "client";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<AccessDeniedException, __BaseException>);
}
export interface Address {
    streetName?: string;
    streetSuffix?: string;
    postDirectional?: string;
    preDirectional?: string;
    streetNumber?: string;
    city?: string;
    state?: string;
    postalCode?: string;
    postalCodePlus4?: string;
    country?: string;
}
export declare enum AlexaSkillStatus {
    ACTIVE = "ACTIVE",
    INACTIVE = "INACTIVE"
}
export interface AssociatePhoneNumbersWithVoiceConnectorRequest {
    VoiceConnectorId: string | undefined;
    E164PhoneNumbers: string[] | undefined;
    ForceAssociate?: boolean;
}
export interface PhoneNumberError {
    PhoneNumberId?: string;
    ErrorCode?: ErrorCode | string;
    ErrorMessage?: string;
}
export interface AssociatePhoneNumbersWithVoiceConnectorResponse {
    PhoneNumberErrors?: PhoneNumberError[];
}
export declare class BadRequestException extends __BaseException {
    readonly name: "BadRequestException";
    readonly $fault: "client";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<BadRequestException, __BaseException>);
}
export declare class ForbiddenException extends __BaseException {
    readonly name: "ForbiddenException";
    readonly $fault: "client";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ForbiddenException, __BaseException>);
}
export declare class NotFoundException extends __BaseException {
    readonly name: "NotFoundException";
    readonly $fault: "client";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<NotFoundException, __BaseException>);
}
export declare class ServiceFailureException extends __BaseException {
    readonly name: "ServiceFailureException";
    readonly $fault: "server";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ServiceFailureException, __BaseException>);
}
export declare class ServiceUnavailableException extends __BaseException {
    readonly name: "ServiceUnavailableException";
    readonly $fault: "server";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ServiceUnavailableException, __BaseException>);
}
export declare class ThrottledClientException extends __BaseException {
    readonly name: "ThrottledClientException";
    readonly $fault: "client";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ThrottledClientException, __BaseException>);
}
export declare class UnauthorizedClientException extends __BaseException {
    readonly name: "UnauthorizedClientException";
    readonly $fault: "client";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<UnauthorizedClientException, __BaseException>);
}
export interface AssociatePhoneNumbersWithVoiceConnectorGroupRequest {
    VoiceConnectorGroupId: string | undefined;
    E164PhoneNumbers: string[] | undefined;
    ForceAssociate?: boolean;
}
export interface AssociatePhoneNumbersWithVoiceConnectorGroupResponse {
    PhoneNumberErrors?: PhoneNumberError[];
}
export interface BatchDeletePhoneNumberRequest {
    PhoneNumberIds: string[] | undefined;
}
export interface BatchDeletePhoneNumberResponse {
    PhoneNumberErrors?: PhoneNumberError[];
}
export declare enum PhoneNumberProductType {
    SipMediaApplicationDialIn = "SipMediaApplicationDialIn",
    VoiceConnector = "VoiceConnector"
}
export interface UpdatePhoneNumberRequestItem {
    PhoneNumberId: string | undefined;
    ProductType?: PhoneNumberProductType | string;
    CallingName?: string;
}
export interface BatchUpdatePhoneNumberRequest {
    UpdatePhoneNumberRequestItems: UpdatePhoneNumberRequestItem[] | undefined;
}
export interface BatchUpdatePhoneNumberResponse {
    PhoneNumberErrors?: PhoneNumberError[];
}
export declare enum CallingNameStatus {
    Unassigned = "Unassigned",
    UpdateFailed = "UpdateFailed",
    UpdateInProgress = "UpdateInProgress",
    UpdateSucceeded = "UpdateSucceeded"
}
export interface CandidateAddress {
    streetInfo?: string;
    streetNumber?: string;
    city?: string;
    state?: string;
    postalCode?: string;
    postalCodePlus4?: string;
    country?: string;
}
export declare enum Capability {
    SMS = "SMS",
    Voice = "Voice"
}
export interface CreatePhoneNumberOrderRequest {
    ProductType: PhoneNumberProductType | string | undefined;
    E164PhoneNumbers: string[] | undefined;
}
export declare enum OrderedPhoneNumberStatus {
    Acquired = "Acquired",
    Failed = "Failed",
    Processing = "Processing"
}
export interface OrderedPhoneNumber {
    E164PhoneNumber?: string;
    Status?: OrderedPhoneNumberStatus | string;
}
export declare enum PhoneNumberOrderType {
    New = "New",
    Porting = "Porting"
}
export declare enum PhoneNumberOrderStatus {
    CancelRequested = "CancelRequested",
    Cancelled = "Cancelled",
    ChangeRequested = "ChangeRequested",
    Exception = "Exception",
    FOC = "FOC",
    Failed = "Failed",
    Partial = "Partial",
    PendingDocuments = "PendingDocuments",
    Processing = "Processing",
    Submitted = "Submitted",
    Successful = "Successful"
}
export interface PhoneNumberOrder {
    PhoneNumberOrderId?: string;
    ProductType?: PhoneNumberProductType | string;
    Status?: PhoneNumberOrderStatus | string;
    OrderType?: PhoneNumberOrderType | string;
    OrderedPhoneNumbers?: OrderedPhoneNumber[];
    CreatedTimestamp?: Date;
    UpdatedTimestamp?: Date;
}
export interface CreatePhoneNumberOrderResponse {
    PhoneNumberOrder?: PhoneNumberOrder;
}
export declare class ResourceLimitExceededException extends __BaseException {
    readonly name: "ResourceLimitExceededException";
    readonly $fault: "client";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ResourceLimitExceededException, __BaseException>);
}
export declare enum GeoMatchLevel {
    AreaCode = "AreaCode",
    Country = "Country"
}
export interface GeoMatchParams {
    Country: string | undefined;
    AreaCode: string | undefined;
}
export declare enum NumberSelectionBehavior {
    AvoidSticky = "AvoidSticky",
    PreferSticky = "PreferSticky"
}
export interface CreateProxySessionRequest {
    VoiceConnectorId: string | undefined;
    ParticipantPhoneNumbers: string[] | undefined;
    Name?: string;
    ExpiryMinutes?: number;
    Capabilities: (Capability | string)[] | undefined;
    NumberSelectionBehavior?: NumberSelectionBehavior | string;
    GeoMatchLevel?: GeoMatchLevel | string;
    GeoMatchParams?: GeoMatchParams;
}
export interface Participant {
    PhoneNumber?: string;
    ProxyPhoneNumber?: string;
}
export declare enum ProxySessionStatus {
    Closed = "Closed",
    InProgress = "InProgress",
    Open = "Open"
}
export interface ProxySession {
    VoiceConnectorId?: string;
    ProxySessionId?: string;
    Name?: string;
    Status?: ProxySessionStatus | string;
    ExpiryMinutes?: number;
    Capabilities?: (Capability | string)[];
    CreatedTimestamp?: Date;
    UpdatedTimestamp?: Date;
    EndedTimestamp?: Date;
    Participants?: Participant[];
    NumberSelectionBehavior?: NumberSelectionBehavior | string;
    GeoMatchLevel?: GeoMatchLevel | string;
    GeoMatchParams?: GeoMatchParams;
}
export interface CreateProxySessionResponse {
    ProxySession?: ProxySession;
}
export declare class ConflictException extends __BaseException {
    readonly name: "ConflictException";
    readonly $fault: "client";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ConflictException, __BaseException>);
}
export interface SipMediaApplicationEndpoint {
    LambdaArn?: string;
}
export interface CreateSipMediaApplicationRequest {
    AwsRegion: string | undefined;
    Name: string | undefined;
    Endpoints: SipMediaApplicationEndpoint[] | undefined;
}
export interface SipMediaApplication {
    SipMediaApplicationId?: string;
    AwsRegion?: string;
    Name?: string;
    Endpoints?: SipMediaApplicationEndpoint[];
    CreatedTimestamp?: Date;
    UpdatedTimestamp?: Date;
}
export interface CreateSipMediaApplicationResponse {
    SipMediaApplication?: SipMediaApplication;
}
export interface CreateSipMediaApplicationCallRequest {
    FromPhoneNumber: string | undefined;
    ToPhoneNumber: string | undefined;
    SipMediaApplicationId: string | undefined;
    SipHeaders?: Record<string, string>;
    ArgumentsMap?: Record<string, string>;
}
export interface SipMediaApplicationCall {
    TransactionId?: string;
}
export interface CreateSipMediaApplicationCallResponse {
    SipMediaApplicationCall?: SipMediaApplicationCall;
}
export interface SipRuleTargetApplication {
    SipMediaApplicationId?: string;
    Priority?: number;
    AwsRegion?: string;
}
export declare enum SipRuleTriggerType {
    RequestUriHostname = "RequestUriHostname",
    ToPhoneNumber = "ToPhoneNumber"
}
export interface CreateSipRuleRequest {
    Name: string | undefined;
    TriggerType: SipRuleTriggerType | string | undefined;
    TriggerValue: string | undefined;
    Disabled?: boolean;
    TargetApplications?: SipRuleTargetApplication[];
}
export interface SipRule {
    SipRuleId?: string;
    Name?: string;
    Disabled?: boolean;
    TriggerType?: SipRuleTriggerType | string;
    TriggerValue?: string;
    TargetApplications?: SipRuleTargetApplication[];
    CreatedTimestamp?: Date;
    UpdatedTimestamp?: Date;
}
export interface CreateSipRuleResponse {
    SipRule?: SipRule;
}
export declare enum VoiceConnectorAwsRegion {
    AP_NORTHEAST_1 = "ap-northeast-1",
    AP_NORTHEAST_2 = "ap-northeast-2",
    AP_SOUTHEAST_1 = "ap-southeast-1",
    AP_SOUTHEAST_2 = "ap-southeast-2",
    CA_CENTRAL_1 = "ca-central-1",
    EU_CENTRAL_1 = "eu-central-1",
    EU_WEST_1 = "eu-west-1",
    EU_WEST_2 = "eu-west-2",
    US_EAST_1 = "us-east-1",
    US_WEST_2 = "us-west-2"
}
export interface CreateVoiceConnectorRequest {
    Name: string | undefined;
    AwsRegion?: VoiceConnectorAwsRegion | string;
    RequireEncryption: boolean | undefined;
}
export interface VoiceConnector {
    VoiceConnectorId?: string;
    AwsRegion?: VoiceConnectorAwsRegion | string;
    Name?: string;
    OutboundHostName?: string;
    RequireEncryption?: boolean;
    CreatedTimestamp?: Date;
    UpdatedTimestamp?: Date;
    VoiceConnectorArn?: string;
}
export interface CreateVoiceConnectorResponse {
    VoiceConnector?: VoiceConnector;
}
export interface VoiceConnectorItem {
    VoiceConnectorId: string | undefined;
    Priority: number | undefined;
}
export interface CreateVoiceConnectorGroupRequest {
    Name: string | undefined;
    VoiceConnectorItems?: VoiceConnectorItem[];
}
export interface VoiceConnectorGroup {
    VoiceConnectorGroupId?: string;
    Name?: string;
    VoiceConnectorItems?: VoiceConnectorItem[];
    CreatedTimestamp?: Date;
    UpdatedTimestamp?: Date;
    VoiceConnectorGroupArn?: string;
}
export interface CreateVoiceConnectorGroupResponse {
    VoiceConnectorGroup?: VoiceConnectorGroup;
}
export interface DeletePhoneNumberRequest {
    PhoneNumberId: string | undefined;
}
export interface DeleteProxySessionRequest {
    VoiceConnectorId: string | undefined;
    ProxySessionId: string | undefined;
}
export interface DeleteSipMediaApplicationRequest {
    SipMediaApplicationId: string | undefined;
}
export interface DeleteSipRuleRequest {
    SipRuleId: string | undefined;
}
export interface DeleteVoiceConnectorRequest {
    VoiceConnectorId: string | undefined;
}
export interface DeleteVoiceConnectorEmergencyCallingConfigurationRequest {
    VoiceConnectorId: string | undefined;
}
export interface DeleteVoiceConnectorGroupRequest {
    VoiceConnectorGroupId: string | undefined;
}
export interface DeleteVoiceConnectorOriginationRequest {
    VoiceConnectorId: string | undefined;
}
export interface DeleteVoiceConnectorProxyRequest {
    VoiceConnectorId: string | undefined;
}
export interface DeleteVoiceConnectorStreamingConfigurationRequest {
    VoiceConnectorId: string | undefined;
}
export interface DeleteVoiceConnectorTerminationRequest {
    VoiceConnectorId: string | undefined;
}
export interface DeleteVoiceConnectorTerminationCredentialsRequest {
    VoiceConnectorId: string | undefined;
    Usernames: string[] | undefined;
}
export interface DisassociatePhoneNumbersFromVoiceConnectorRequest {
    VoiceConnectorId: string | undefined;
    E164PhoneNumbers: string[] | undefined;
}
export interface DisassociatePhoneNumbersFromVoiceConnectorResponse {
    PhoneNumberErrors?: PhoneNumberError[];
}
export interface DisassociatePhoneNumbersFromVoiceConnectorGroupRequest {
    VoiceConnectorGroupId: string | undefined;
    E164PhoneNumbers: string[] | undefined;
}
export interface DisassociatePhoneNumbersFromVoiceConnectorGroupResponse {
    PhoneNumberErrors?: PhoneNumberError[];
}
export interface VoiceConnectorSettings {
    CdrBucket?: string;
}
export interface GetGlobalSettingsResponse {
    VoiceConnector?: VoiceConnectorSettings;
}
export interface GetPhoneNumberRequest {
    PhoneNumberId: string | undefined;
}
export declare enum PhoneNumberAssociationName {
    SipRuleId = "SipRuleId",
    VoiceConnectorGroupId = "VoiceConnectorGroupId",
    VoiceConnectorId = "VoiceConnectorId"
}
export interface PhoneNumberAssociation {
    Value?: string;
    Name?: PhoneNumberAssociationName | string;
    AssociatedTimestamp?: Date;
}
export interface PhoneNumberCapabilities {
    InboundCall?: boolean;
    OutboundCall?: boolean;
    InboundSMS?: boolean;
    OutboundSMS?: boolean;
    InboundMMS?: boolean;
    OutboundMMS?: boolean;
}
export declare enum PhoneNumberStatus {
    AcquireFailed = "AcquireFailed",
    AcquireInProgress = "AcquireInProgress",
    Assigned = "Assigned",
    Cancelled = "Cancelled",
    DeleteFailed = "DeleteFailed",
    DeleteInProgress = "DeleteInProgress",
    PortinCancelRequested = "PortinCancelRequested",
    PortinInProgress = "PortinInProgress",
    ReleaseFailed = "ReleaseFailed",
    ReleaseInProgress = "ReleaseInProgress",
    Unassigned = "Unassigned"
}
export declare enum PhoneNumberType {
    Local = "Local",
    TollFree = "TollFree"
}
export interface PhoneNumber {
    PhoneNumberId?: string;
    E164PhoneNumber?: string;
    Country?: string;
    Type?: PhoneNumberType | string;
    ProductType?: PhoneNumberProductType | string;
    Status?: PhoneNumberStatus | string;
    Capabilities?: PhoneNumberCapabilities;
    Associations?: PhoneNumberAssociation[];
    CallingName?: string;
    CallingNameStatus?: CallingNameStatus | string;
    CreatedTimestamp?: Date;
    UpdatedTimestamp?: Date;
    DeletionTimestamp?: Date;
    OrderId?: string;
}
export interface GetPhoneNumberResponse {
    PhoneNumber?: PhoneNumber;
}
export interface GetPhoneNumberOrderRequest {
    PhoneNumberOrderId: string | undefined;
}
export interface GetPhoneNumberOrderResponse {
    PhoneNumberOrder?: PhoneNumberOrder;
}
export interface GetPhoneNumberSettingsResponse {
    CallingName?: string;
    CallingNameUpdatedTimestamp?: Date;
}
export interface GetProxySessionRequest {
    VoiceConnectorId: string | undefined;
    ProxySessionId: string | undefined;
}
export interface GetProxySessionResponse {
    ProxySession?: ProxySession;
}
export interface GetSipMediaApplicationRequest {
    SipMediaApplicationId: string | undefined;
}
export interface GetSipMediaApplicationResponse {
    SipMediaApplication?: SipMediaApplication;
}
export interface GetSipMediaApplicationAlexaSkillConfigurationRequest {
    SipMediaApplicationId: string | undefined;
}
export interface SipMediaApplicationAlexaSkillConfiguration {
    AlexaSkillStatus: AlexaSkillStatus | string | undefined;
    AlexaSkillIds: string[] | undefined;
}
export interface GetSipMediaApplicationAlexaSkillConfigurationResponse {
    SipMediaApplicationAlexaSkillConfiguration?: SipMediaApplicationAlexaSkillConfiguration;
}
export interface GetSipMediaApplicationLoggingConfigurationRequest {
    SipMediaApplicationId: string | undefined;
}
export interface SipMediaApplicationLoggingConfiguration {
    EnableSipMediaApplicationMessageLogs?: boolean;
}
export interface GetSipMediaApplicationLoggingConfigurationResponse {
    SipMediaApplicationLoggingConfiguration?: SipMediaApplicationLoggingConfiguration;
}
export interface GetSipRuleRequest {
    SipRuleId: string | undefined;
}
export interface GetSipRuleResponse {
    SipRule?: SipRule;
}
export interface GetVoiceConnectorRequest {
    VoiceConnectorId: string | undefined;
}
export interface GetVoiceConnectorResponse {
    VoiceConnector?: VoiceConnector;
}
export interface GetVoiceConnectorEmergencyCallingConfigurationRequest {
    VoiceConnectorId: string | undefined;
}
export interface DNISEmergencyCallingConfiguration {
    EmergencyPhoneNumber: string | undefined;
    TestPhoneNumber?: string;
    CallingCountry: string | undefined;
}
export interface EmergencyCallingConfiguration {
    DNIS?: DNISEmergencyCallingConfiguration[];
}
export interface GetVoiceConnectorEmergencyCallingConfigurationResponse {
    EmergencyCallingConfiguration?: EmergencyCallingConfiguration;
}
export interface GetVoiceConnectorGroupRequest {
    VoiceConnectorGroupId: string | undefined;
}
export interface GetVoiceConnectorGroupResponse {
    VoiceConnectorGroup?: VoiceConnectorGroup;
}
export interface GetVoiceConnectorLoggingConfigurationRequest {
    VoiceConnectorId: string | undefined;
}
export interface LoggingConfiguration {
    EnableSIPLogs?: boolean;
    EnableMediaMetricLogs?: boolean;
}
export interface GetVoiceConnectorLoggingConfigurationResponse {
    LoggingConfiguration?: LoggingConfiguration;
}
export interface GetVoiceConnectorOriginationRequest {
    VoiceConnectorId: string | undefined;
}
export declare enum OriginationRouteProtocol {
    TCP = "TCP",
    UDP = "UDP"
}
export interface OriginationRoute {
    Host?: string;
    Port?: number;
    Protocol?: OriginationRouteProtocol | string;
    Priority?: number;
    Weight?: number;
}
export interface Origination {
    Routes?: OriginationRoute[];
    Disabled?: boolean;
}
export interface GetVoiceConnectorOriginationResponse {
    Origination?: Origination;
}
export interface GetVoiceConnectorProxyRequest {
    VoiceConnectorId: string | undefined;
}
export interface Proxy {
    DefaultSessionExpiryMinutes?: number;
    Disabled?: boolean;
    FallBackPhoneNumber?: string;
    PhoneNumberCountries?: string[];
}
export interface GetVoiceConnectorProxyResponse {
    Proxy?: Proxy;
}
export interface GetVoiceConnectorStreamingConfigurationRequest {
    VoiceConnectorId: string | undefined;
}
export declare enum NotificationTarget {
    EventBridge = "EventBridge",
    SNS = "SNS",
    SQS = "SQS"
}
export interface StreamingNotificationTarget {
    NotificationTarget?: NotificationTarget | string;
}
export interface StreamingConfiguration {
    DataRetentionInHours: number | undefined;
    Disabled: boolean | undefined;
    StreamingNotificationTargets?: StreamingNotificationTarget[];
}
export interface GetVoiceConnectorStreamingConfigurationResponse {
    StreamingConfiguration?: StreamingConfiguration;
}
export interface GetVoiceConnectorTerminationRequest {
    VoiceConnectorId: string | undefined;
}
export interface Termination {
    CpsLimit?: number;
    DefaultPhoneNumber?: string;
    CallingRegions?: string[];
    CidrAllowedList?: string[];
    Disabled?: boolean;
}
export interface GetVoiceConnectorTerminationResponse {
    Termination?: Termination;
}
export interface GetVoiceConnectorTerminationHealthRequest {
    VoiceConnectorId: string | undefined;
}
export interface TerminationHealth {
    Timestamp?: Date;
    Source?: string;
}
export interface GetVoiceConnectorTerminationHealthResponse {
    TerminationHealth?: TerminationHealth;
}
export interface ListAvailableVoiceConnectorRegionsResponse {
    VoiceConnectorRegions?: (VoiceConnectorAwsRegion | string)[];
}
export interface ListPhoneNumberOrdersRequest {
    NextToken?: string;
    MaxResults?: number;
}
export interface ListPhoneNumberOrdersResponse {
    PhoneNumberOrders?: PhoneNumberOrder[];
    NextToken?: string;
}
export interface ListPhoneNumbersRequest {
    Status?: string;
    ProductType?: PhoneNumberProductType | string;
    FilterName?: PhoneNumberAssociationName | string;
    FilterValue?: string;
    MaxResults?: number;
    NextToken?: string;
}
export interface ListPhoneNumbersResponse {
    PhoneNumbers?: PhoneNumber[];
    NextToken?: string;
}
export interface ListProxySessionsRequest {
    VoiceConnectorId: string | undefined;
    Status?: ProxySessionStatus | string;
    NextToken?: string;
    MaxResults?: number;
}
export interface ListProxySessionsResponse {
    ProxySessions?: ProxySession[];
    NextToken?: string;
}
export interface ListSipMediaApplicationsRequest {
    MaxResults?: number;
    NextToken?: string;
}
export interface ListSipMediaApplicationsResponse {
    SipMediaApplications?: SipMediaApplication[];
    NextToken?: string;
}
export interface ListSipRulesRequest {
    SipMediaApplicationId?: string;
    MaxResults?: number;
    NextToken?: string;
}
export interface ListSipRulesResponse {
    SipRules?: SipRule[];
    NextToken?: string;
}
export interface ListSupportedPhoneNumberCountriesRequest {
    ProductType: PhoneNumberProductType | string | undefined;
}
export interface PhoneNumberCountry {
    CountryCode?: string;
    SupportedPhoneNumberTypes?: (PhoneNumberType | string)[];
}
export interface ListSupportedPhoneNumberCountriesResponse {
    PhoneNumberCountries?: PhoneNumberCountry[];
}
export interface ListVoiceConnectorGroupsRequest {
    NextToken?: string;
    MaxResults?: number;
}
export interface ListVoiceConnectorGroupsResponse {
    VoiceConnectorGroups?: VoiceConnectorGroup[];
    NextToken?: string;
}
export interface ListVoiceConnectorsRequest {
    NextToken?: string;
    MaxResults?: number;
}
export interface ListVoiceConnectorsResponse {
    VoiceConnectors?: VoiceConnector[];
    NextToken?: string;
}
export interface ListVoiceConnectorTerminationCredentialsRequest {
    VoiceConnectorId: string | undefined;
}
export interface ListVoiceConnectorTerminationCredentialsResponse {
    Usernames?: string[];
}
export interface PutSipMediaApplicationAlexaSkillConfigurationRequest {
    SipMediaApplicationId: string | undefined;
    SipMediaApplicationAlexaSkillConfiguration?: SipMediaApplicationAlexaSkillConfiguration;
}
export interface PutSipMediaApplicationAlexaSkillConfigurationResponse {
    SipMediaApplicationAlexaSkillConfiguration?: SipMediaApplicationAlexaSkillConfiguration;
}
export interface PutSipMediaApplicationLoggingConfigurationRequest {
    SipMediaApplicationId: string | undefined;
    SipMediaApplicationLoggingConfiguration?: SipMediaApplicationLoggingConfiguration;
}
export interface PutSipMediaApplicationLoggingConfigurationResponse {
    SipMediaApplicationLoggingConfiguration?: SipMediaApplicationLoggingConfiguration;
}
export interface PutVoiceConnectorEmergencyCallingConfigurationRequest {
    VoiceConnectorId: string | undefined;
    EmergencyCallingConfiguration: EmergencyCallingConfiguration | undefined;
}
export interface PutVoiceConnectorEmergencyCallingConfigurationResponse {
    EmergencyCallingConfiguration?: EmergencyCallingConfiguration;
}
export interface PutVoiceConnectorLoggingConfigurationRequest {
    VoiceConnectorId: string | undefined;
    LoggingConfiguration: LoggingConfiguration | undefined;
}
export interface PutVoiceConnectorLoggingConfigurationResponse {
    LoggingConfiguration?: LoggingConfiguration;
}
export interface PutVoiceConnectorOriginationRequest {
    VoiceConnectorId: string | undefined;
    Origination: Origination | undefined;
}
export interface PutVoiceConnectorOriginationResponse {
    Origination?: Origination;
}
export interface PutVoiceConnectorProxyRequest {
    VoiceConnectorId: string | undefined;
    DefaultSessionExpiryMinutes: number | undefined;
    PhoneNumberPoolCountries: string[] | undefined;
    FallBackPhoneNumber?: string;
    Disabled?: boolean;
}
export interface PutVoiceConnectorProxyResponse {
    Proxy?: Proxy;
}
export interface PutVoiceConnectorStreamingConfigurationRequest {
    VoiceConnectorId: string | undefined;
    StreamingConfiguration: StreamingConfiguration | undefined;
}
export interface PutVoiceConnectorStreamingConfigurationResponse {
    StreamingConfiguration?: StreamingConfiguration;
}
export interface PutVoiceConnectorTerminationRequest {
    VoiceConnectorId: string | undefined;
    Termination: Termination | undefined;
}
export interface PutVoiceConnectorTerminationResponse {
    Termination?: Termination;
}
export interface Credential {
    Username?: string;
    Password?: string;
}
export interface PutVoiceConnectorTerminationCredentialsRequest {
    VoiceConnectorId: string | undefined;
    Credentials?: Credential[];
}
export interface RestorePhoneNumberRequest {
    PhoneNumberId: string | undefined;
}
export interface RestorePhoneNumberResponse {
    PhoneNumber?: PhoneNumber;
}
export interface SearchAvailablePhoneNumbersRequest {
    AreaCode?: string;
    City?: string;
    Country?: string;
    State?: string;
    TollFreePrefix?: string;
    PhoneNumberType?: PhoneNumberType | string;
    MaxResults?: number;
    NextToken?: string;
}
export interface SearchAvailablePhoneNumbersResponse {
    E164PhoneNumbers?: string[];
    NextToken?: string;
}
export interface UpdateGlobalSettingsRequest {
    VoiceConnector?: VoiceConnectorSettings;
}
export interface UpdatePhoneNumberRequest {
    PhoneNumberId: string | undefined;
    ProductType?: PhoneNumberProductType | string;
    CallingName?: string;
}
export interface UpdatePhoneNumberResponse {
    PhoneNumber?: PhoneNumber;
}
export interface UpdatePhoneNumberSettingsRequest {
    CallingName: string | undefined;
}
export interface UpdateProxySessionRequest {
    VoiceConnectorId: string | undefined;
    ProxySessionId: string | undefined;
    Capabilities: (Capability | string)[] | undefined;
    ExpiryMinutes?: number;
}
export interface UpdateProxySessionResponse {
    ProxySession?: ProxySession;
}
export interface UpdateSipMediaApplicationRequest {
    SipMediaApplicationId: string | undefined;
    Name?: string;
    Endpoints?: SipMediaApplicationEndpoint[];
}
export interface UpdateSipMediaApplicationResponse {
    SipMediaApplication?: SipMediaApplication;
}
export interface UpdateSipMediaApplicationCallRequest {
    SipMediaApplicationId: string | undefined;
    TransactionId: string | undefined;
    Arguments: Record<string, string> | undefined;
}
export interface UpdateSipMediaApplicationCallResponse {
    SipMediaApplicationCall?: SipMediaApplicationCall;
}
export interface UpdateSipRuleRequest {
    SipRuleId: string | undefined;
    Name: string | undefined;
    Disabled?: boolean;
    TargetApplications?: SipRuleTargetApplication[];
}
export interface UpdateSipRuleResponse {
    SipRule?: SipRule;
}
export interface UpdateVoiceConnectorRequest {
    VoiceConnectorId: string | undefined;
    Name: string | undefined;
    RequireEncryption: boolean | undefined;
}
export interface UpdateVoiceConnectorResponse {
    VoiceConnector?: VoiceConnector;
}
export interface UpdateVoiceConnectorGroupRequest {
    VoiceConnectorGroupId: string | undefined;
    Name: string | undefined;
    VoiceConnectorItems: VoiceConnectorItem[] | undefined;
}
export interface UpdateVoiceConnectorGroupResponse {
    VoiceConnectorGroup?: VoiceConnectorGroup;
}
export interface ValidateE911AddressRequest {
    AwsAccountId: string | undefined;
    StreetNumber: string | undefined;
    StreetInfo: string | undefined;
    City: string | undefined;
    State: string | undefined;
    Country: string | undefined;
    PostalCode: string | undefined;
}
export interface ValidateE911AddressResponse {
    ValidationResult?: number;
    AddressExternalId?: string;
    Address?: Address;
    CandidateAddressList?: CandidateAddress[];
}
/**
 * @internal
 */
export declare const AddressFilterSensitiveLog: (obj: Address) => any;
/**
 * @internal
 */
export declare const AssociatePhoneNumbersWithVoiceConnectorRequestFilterSensitiveLog: (obj: AssociatePhoneNumbersWithVoiceConnectorRequest) => any;
/**
 * @internal
 */
export declare const PhoneNumberErrorFilterSensitiveLog: (obj: PhoneNumberError) => any;
/**
 * @internal
 */
export declare const AssociatePhoneNumbersWithVoiceConnectorResponseFilterSensitiveLog: (obj: AssociatePhoneNumbersWithVoiceConnectorResponse) => any;
/**
 * @internal
 */
export declare const AssociatePhoneNumbersWithVoiceConnectorGroupRequestFilterSensitiveLog: (obj: AssociatePhoneNumbersWithVoiceConnectorGroupRequest) => any;
/**
 * @internal
 */
export declare const AssociatePhoneNumbersWithVoiceConnectorGroupResponseFilterSensitiveLog: (obj: AssociatePhoneNumbersWithVoiceConnectorGroupResponse) => any;
/**
 * @internal
 */
export declare const BatchDeletePhoneNumberRequestFilterSensitiveLog: (obj: BatchDeletePhoneNumberRequest) => any;
/**
 * @internal
 */
export declare const BatchDeletePhoneNumberResponseFilterSensitiveLog: (obj: BatchDeletePhoneNumberResponse) => any;
/**
 * @internal
 */
export declare const UpdatePhoneNumberRequestItemFilterSensitiveLog: (obj: UpdatePhoneNumberRequestItem) => any;
/**
 * @internal
 */
export declare const BatchUpdatePhoneNumberRequestFilterSensitiveLog: (obj: BatchUpdatePhoneNumberRequest) => any;
/**
 * @internal
 */
export declare const BatchUpdatePhoneNumberResponseFilterSensitiveLog: (obj: BatchUpdatePhoneNumberResponse) => any;
/**
 * @internal
 */
export declare const CandidateAddressFilterSensitiveLog: (obj: CandidateAddress) => any;
/**
 * @internal
 */
export declare const CreatePhoneNumberOrderRequestFilterSensitiveLog: (obj: CreatePhoneNumberOrderRequest) => any;
/**
 * @internal
 */
export declare const OrderedPhoneNumberFilterSensitiveLog: (obj: OrderedPhoneNumber) => any;
/**
 * @internal
 */
export declare const PhoneNumberOrderFilterSensitiveLog: (obj: PhoneNumberOrder) => any;
/**
 * @internal
 */
export declare const CreatePhoneNumberOrderResponseFilterSensitiveLog: (obj: CreatePhoneNumberOrderResponse) => any;
/**
 * @internal
 */
export declare const GeoMatchParamsFilterSensitiveLog: (obj: GeoMatchParams) => any;
/**
 * @internal
 */
export declare const CreateProxySessionRequestFilterSensitiveLog: (obj: CreateProxySessionRequest) => any;
/**
 * @internal
 */
export declare const ParticipantFilterSensitiveLog: (obj: Participant) => any;
/**
 * @internal
 */
export declare const ProxySessionFilterSensitiveLog: (obj: ProxySession) => any;
/**
 * @internal
 */
export declare const CreateProxySessionResponseFilterSensitiveLog: (obj: CreateProxySessionResponse) => any;
/**
 * @internal
 */
export declare const SipMediaApplicationEndpointFilterSensitiveLog: (obj: SipMediaApplicationEndpoint) => any;
/**
 * @internal
 */
export declare const CreateSipMediaApplicationRequestFilterSensitiveLog: (obj: CreateSipMediaApplicationRequest) => any;
/**
 * @internal
 */
export declare const SipMediaApplicationFilterSensitiveLog: (obj: SipMediaApplication) => any;
/**
 * @internal
 */
export declare const CreateSipMediaApplicationResponseFilterSensitiveLog: (obj: CreateSipMediaApplicationResponse) => any;
/**
 * @internal
 */
export declare const CreateSipMediaApplicationCallRequestFilterSensitiveLog: (obj: CreateSipMediaApplicationCallRequest) => any;
/**
 * @internal
 */
export declare const SipMediaApplicationCallFilterSensitiveLog: (obj: SipMediaApplicationCall) => any;
/**
 * @internal
 */
export declare const CreateSipMediaApplicationCallResponseFilterSensitiveLog: (obj: CreateSipMediaApplicationCallResponse) => any;
/**
 * @internal
 */
export declare const SipRuleTargetApplicationFilterSensitiveLog: (obj: SipRuleTargetApplication) => any;
/**
 * @internal
 */
export declare const CreateSipRuleRequestFilterSensitiveLog: (obj: CreateSipRuleRequest) => any;
/**
 * @internal
 */
export declare const SipRuleFilterSensitiveLog: (obj: SipRule) => any;
/**
 * @internal
 */
export declare const CreateSipRuleResponseFilterSensitiveLog: (obj: CreateSipRuleResponse) => any;
/**
 * @internal
 */
export declare const CreateVoiceConnectorRequestFilterSensitiveLog: (obj: CreateVoiceConnectorRequest) => any;
/**
 * @internal
 */
export declare const VoiceConnectorFilterSensitiveLog: (obj: VoiceConnector) => any;
/**
 * @internal
 */
export declare const CreateVoiceConnectorResponseFilterSensitiveLog: (obj: CreateVoiceConnectorResponse) => any;
/**
 * @internal
 */
export declare const VoiceConnectorItemFilterSensitiveLog: (obj: VoiceConnectorItem) => any;
/**
 * @internal
 */
export declare const CreateVoiceConnectorGroupRequestFilterSensitiveLog: (obj: CreateVoiceConnectorGroupRequest) => any;
/**
 * @internal
 */
export declare const VoiceConnectorGroupFilterSensitiveLog: (obj: VoiceConnectorGroup) => any;
/**
 * @internal
 */
export declare const CreateVoiceConnectorGroupResponseFilterSensitiveLog: (obj: CreateVoiceConnectorGroupResponse) => any;
/**
 * @internal
 */
export declare const DeletePhoneNumberRequestFilterSensitiveLog: (obj: DeletePhoneNumberRequest) => any;
/**
 * @internal
 */
export declare const DeleteProxySessionRequestFilterSensitiveLog: (obj: DeleteProxySessionRequest) => any;
/**
 * @internal
 */
export declare const DeleteSipMediaApplicationRequestFilterSensitiveLog: (obj: DeleteSipMediaApplicationRequest) => any;
/**
 * @internal
 */
export declare const DeleteSipRuleRequestFilterSensitiveLog: (obj: DeleteSipRuleRequest) => any;
/**
 * @internal
 */
export declare const DeleteVoiceConnectorRequestFilterSensitiveLog: (obj: DeleteVoiceConnectorRequest) => any;
/**
 * @internal
 */
export declare const DeleteVoiceConnectorEmergencyCallingConfigurationRequestFilterSensitiveLog: (obj: DeleteVoiceConnectorEmergencyCallingConfigurationRequest) => any;
/**
 * @internal
 */
export declare const DeleteVoiceConnectorGroupRequestFilterSensitiveLog: (obj: DeleteVoiceConnectorGroupRequest) => any;
/**
 * @internal
 */
export declare const DeleteVoiceConnectorOriginationRequestFilterSensitiveLog: (obj: DeleteVoiceConnectorOriginationRequest) => any;
/**
 * @internal
 */
export declare const DeleteVoiceConnectorProxyRequestFilterSensitiveLog: (obj: DeleteVoiceConnectorProxyRequest) => any;
/**
 * @internal
 */
export declare const DeleteVoiceConnectorStreamingConfigurationRequestFilterSensitiveLog: (obj: DeleteVoiceConnectorStreamingConfigurationRequest) => any;
/**
 * @internal
 */
export declare const DeleteVoiceConnectorTerminationRequestFilterSensitiveLog: (obj: DeleteVoiceConnectorTerminationRequest) => any;
/**
 * @internal
 */
export declare const DeleteVoiceConnectorTerminationCredentialsRequestFilterSensitiveLog: (obj: DeleteVoiceConnectorTerminationCredentialsRequest) => any;
/**
 * @internal
 */
export declare const DisassociatePhoneNumbersFromVoiceConnectorRequestFilterSensitiveLog: (obj: DisassociatePhoneNumbersFromVoiceConnectorRequest) => any;
/**
 * @internal
 */
export declare const DisassociatePhoneNumbersFromVoiceConnectorResponseFilterSensitiveLog: (obj: DisassociatePhoneNumbersFromVoiceConnectorResponse) => any;
/**
 * @internal
 */
export declare const DisassociatePhoneNumbersFromVoiceConnectorGroupRequestFilterSensitiveLog: (obj: DisassociatePhoneNumbersFromVoiceConnectorGroupRequest) => any;
/**
 * @internal
 */
export declare const DisassociatePhoneNumbersFromVoiceConnectorGroupResponseFilterSensitiveLog: (obj: DisassociatePhoneNumbersFromVoiceConnectorGroupResponse) => any;
/**
 * @internal
 */
export declare const VoiceConnectorSettingsFilterSensitiveLog: (obj: VoiceConnectorSettings) => any;
/**
 * @internal
 */
export declare const GetGlobalSettingsResponseFilterSensitiveLog: (obj: GetGlobalSettingsResponse) => any;
/**
 * @internal
 */
export declare const GetPhoneNumberRequestFilterSensitiveLog: (obj: GetPhoneNumberRequest) => any;
/**
 * @internal
 */
export declare const PhoneNumberAssociationFilterSensitiveLog: (obj: PhoneNumberAssociation) => any;
/**
 * @internal
 */
export declare const PhoneNumberCapabilitiesFilterSensitiveLog: (obj: PhoneNumberCapabilities) => any;
/**
 * @internal
 */
export declare const PhoneNumberFilterSensitiveLog: (obj: PhoneNumber) => any;
/**
 * @internal
 */
export declare const GetPhoneNumberResponseFilterSensitiveLog: (obj: GetPhoneNumberResponse) => any;
/**
 * @internal
 */
export declare const GetPhoneNumberOrderRequestFilterSensitiveLog: (obj: GetPhoneNumberOrderRequest) => any;
/**
 * @internal
 */
export declare const GetPhoneNumberOrderResponseFilterSensitiveLog: (obj: GetPhoneNumberOrderResponse) => any;
/**
 * @internal
 */
export declare const GetPhoneNumberSettingsResponseFilterSensitiveLog: (obj: GetPhoneNumberSettingsResponse) => any;
/**
 * @internal
 */
export declare const GetProxySessionRequestFilterSensitiveLog: (obj: GetProxySessionRequest) => any;
/**
 * @internal
 */
export declare const GetProxySessionResponseFilterSensitiveLog: (obj: GetProxySessionResponse) => any;
/**
 * @internal
 */
export declare const GetSipMediaApplicationRequestFilterSensitiveLog: (obj: GetSipMediaApplicationRequest) => any;
/**
 * @internal
 */
export declare const GetSipMediaApplicationResponseFilterSensitiveLog: (obj: GetSipMediaApplicationResponse) => any;
/**
 * @internal
 */
export declare const GetSipMediaApplicationAlexaSkillConfigurationRequestFilterSensitiveLog: (obj: GetSipMediaApplicationAlexaSkillConfigurationRequest) => any;
/**
 * @internal
 */
export declare const SipMediaApplicationAlexaSkillConfigurationFilterSensitiveLog: (obj: SipMediaApplicationAlexaSkillConfiguration) => any;
/**
 * @internal
 */
export declare const GetSipMediaApplicationAlexaSkillConfigurationResponseFilterSensitiveLog: (obj: GetSipMediaApplicationAlexaSkillConfigurationResponse) => any;
/**
 * @internal
 */
export declare const GetSipMediaApplicationLoggingConfigurationRequestFilterSensitiveLog: (obj: GetSipMediaApplicationLoggingConfigurationRequest) => any;
/**
 * @internal
 */
export declare const SipMediaApplicationLoggingConfigurationFilterSensitiveLog: (obj: SipMediaApplicationLoggingConfiguration) => any;
/**
 * @internal
 */
export declare const GetSipMediaApplicationLoggingConfigurationResponseFilterSensitiveLog: (obj: GetSipMediaApplicationLoggingConfigurationResponse) => any;
/**
 * @internal
 */
export declare const GetSipRuleRequestFilterSensitiveLog: (obj: GetSipRuleRequest) => any;
/**
 * @internal
 */
export declare const GetSipRuleResponseFilterSensitiveLog: (obj: GetSipRuleResponse) => any;
/**
 * @internal
 */
export declare const GetVoiceConnectorRequestFilterSensitiveLog: (obj: GetVoiceConnectorRequest) => any;
/**
 * @internal
 */
export declare const GetVoiceConnectorResponseFilterSensitiveLog: (obj: GetVoiceConnectorResponse) => any;
/**
 * @internal
 */
export declare const GetVoiceConnectorEmergencyCallingConfigurationRequestFilterSensitiveLog: (obj: GetVoiceConnectorEmergencyCallingConfigurationRequest) => any;
/**
 * @internal
 */
export declare const DNISEmergencyCallingConfigurationFilterSensitiveLog: (obj: DNISEmergencyCallingConfiguration) => any;
/**
 * @internal
 */
export declare const EmergencyCallingConfigurationFilterSensitiveLog: (obj: EmergencyCallingConfiguration) => any;
/**
 * @internal
 */
export declare const GetVoiceConnectorEmergencyCallingConfigurationResponseFilterSensitiveLog: (obj: GetVoiceConnectorEmergencyCallingConfigurationResponse) => any;
/**
 * @internal
 */
export declare const GetVoiceConnectorGroupRequestFilterSensitiveLog: (obj: GetVoiceConnectorGroupRequest) => any;
/**
 * @internal
 */
export declare const GetVoiceConnectorGroupResponseFilterSensitiveLog: (obj: GetVoiceConnectorGroupResponse) => any;
/**
 * @internal
 */
export declare const GetVoiceConnectorLoggingConfigurationRequestFilterSensitiveLog: (obj: GetVoiceConnectorLoggingConfigurationRequest) => any;
/**
 * @internal
 */
export declare const LoggingConfigurationFilterSensitiveLog: (obj: LoggingConfiguration) => any;
/**
 * @internal
 */
export declare const GetVoiceConnectorLoggingConfigurationResponseFilterSensitiveLog: (obj: GetVoiceConnectorLoggingConfigurationResponse) => any;
/**
 * @internal
 */
export declare const GetVoiceConnectorOriginationRequestFilterSensitiveLog: (obj: GetVoiceConnectorOriginationRequest) => any;
/**
 * @internal
 */
export declare const OriginationRouteFilterSensitiveLog: (obj: OriginationRoute) => any;
/**
 * @internal
 */
export declare const OriginationFilterSensitiveLog: (obj: Origination) => any;
/**
 * @internal
 */
export declare const GetVoiceConnectorOriginationResponseFilterSensitiveLog: (obj: GetVoiceConnectorOriginationResponse) => any;
/**
 * @internal
 */
export declare const GetVoiceConnectorProxyRequestFilterSensitiveLog: (obj: GetVoiceConnectorProxyRequest) => any;
/**
 * @internal
 */
export declare const ProxyFilterSensitiveLog: (obj: Proxy) => any;
/**
 * @internal
 */
export declare const GetVoiceConnectorProxyResponseFilterSensitiveLog: (obj: GetVoiceConnectorProxyResponse) => any;
/**
 * @internal
 */
export declare const GetVoiceConnectorStreamingConfigurationRequestFilterSensitiveLog: (obj: GetVoiceConnectorStreamingConfigurationRequest) => any;
/**
 * @internal
 */
export declare const StreamingNotificationTargetFilterSensitiveLog: (obj: StreamingNotificationTarget) => any;
/**
 * @internal
 */
export declare const StreamingConfigurationFilterSensitiveLog: (obj: StreamingConfiguration) => any;
/**
 * @internal
 */
export declare const GetVoiceConnectorStreamingConfigurationResponseFilterSensitiveLog: (obj: GetVoiceConnectorStreamingConfigurationResponse) => any;
/**
 * @internal
 */
export declare const GetVoiceConnectorTerminationRequestFilterSensitiveLog: (obj: GetVoiceConnectorTerminationRequest) => any;
/**
 * @internal
 */
export declare const TerminationFilterSensitiveLog: (obj: Termination) => any;
/**
 * @internal
 */
export declare const GetVoiceConnectorTerminationResponseFilterSensitiveLog: (obj: GetVoiceConnectorTerminationResponse) => any;
/**
 * @internal
 */
export declare const GetVoiceConnectorTerminationHealthRequestFilterSensitiveLog: (obj: GetVoiceConnectorTerminationHealthRequest) => any;
/**
 * @internal
 */
export declare const TerminationHealthFilterSensitiveLog: (obj: TerminationHealth) => any;
/**
 * @internal
 */
export declare const GetVoiceConnectorTerminationHealthResponseFilterSensitiveLog: (obj: GetVoiceConnectorTerminationHealthResponse) => any;
/**
 * @internal
 */
export declare const ListAvailableVoiceConnectorRegionsResponseFilterSensitiveLog: (obj: ListAvailableVoiceConnectorRegionsResponse) => any;
/**
 * @internal
 */
export declare const ListPhoneNumberOrdersRequestFilterSensitiveLog: (obj: ListPhoneNumberOrdersRequest) => any;
/**
 * @internal
 */
export declare const ListPhoneNumberOrdersResponseFilterSensitiveLog: (obj: ListPhoneNumberOrdersResponse) => any;
/**
 * @internal
 */
export declare const ListPhoneNumbersRequestFilterSensitiveLog: (obj: ListPhoneNumbersRequest) => any;
/**
 * @internal
 */
export declare const ListPhoneNumbersResponseFilterSensitiveLog: (obj: ListPhoneNumbersResponse) => any;
/**
 * @internal
 */
export declare const ListProxySessionsRequestFilterSensitiveLog: (obj: ListProxySessionsRequest) => any;
/**
 * @internal
 */
export declare const ListProxySessionsResponseFilterSensitiveLog: (obj: ListProxySessionsResponse) => any;
/**
 * @internal
 */
export declare const ListSipMediaApplicationsRequestFilterSensitiveLog: (obj: ListSipMediaApplicationsRequest) => any;
/**
 * @internal
 */
export declare const ListSipMediaApplicationsResponseFilterSensitiveLog: (obj: ListSipMediaApplicationsResponse) => any;
/**
 * @internal
 */
export declare const ListSipRulesRequestFilterSensitiveLog: (obj: ListSipRulesRequest) => any;
/**
 * @internal
 */
export declare const ListSipRulesResponseFilterSensitiveLog: (obj: ListSipRulesResponse) => any;
/**
 * @internal
 */
export declare const ListSupportedPhoneNumberCountriesRequestFilterSensitiveLog: (obj: ListSupportedPhoneNumberCountriesRequest) => any;
/**
 * @internal
 */
export declare const PhoneNumberCountryFilterSensitiveLog: (obj: PhoneNumberCountry) => any;
/**
 * @internal
 */
export declare const ListSupportedPhoneNumberCountriesResponseFilterSensitiveLog: (obj: ListSupportedPhoneNumberCountriesResponse) => any;
/**
 * @internal
 */
export declare const ListVoiceConnectorGroupsRequestFilterSensitiveLog: (obj: ListVoiceConnectorGroupsRequest) => any;
/**
 * @internal
 */
export declare const ListVoiceConnectorGroupsResponseFilterSensitiveLog: (obj: ListVoiceConnectorGroupsResponse) => any;
/**
 * @internal
 */
export declare const ListVoiceConnectorsRequestFilterSensitiveLog: (obj: ListVoiceConnectorsRequest) => any;
/**
 * @internal
 */
export declare const ListVoiceConnectorsResponseFilterSensitiveLog: (obj: ListVoiceConnectorsResponse) => any;
/**
 * @internal
 */
export declare const ListVoiceConnectorTerminationCredentialsRequestFilterSensitiveLog: (obj: ListVoiceConnectorTerminationCredentialsRequest) => any;
/**
 * @internal
 */
export declare const ListVoiceConnectorTerminationCredentialsResponseFilterSensitiveLog: (obj: ListVoiceConnectorTerminationCredentialsResponse) => any;
/**
 * @internal
 */
export declare const PutSipMediaApplicationAlexaSkillConfigurationRequestFilterSensitiveLog: (obj: PutSipMediaApplicationAlexaSkillConfigurationRequest) => any;
/**
 * @internal
 */
export declare const PutSipMediaApplicationAlexaSkillConfigurationResponseFilterSensitiveLog: (obj: PutSipMediaApplicationAlexaSkillConfigurationResponse) => any;
/**
 * @internal
 */
export declare const PutSipMediaApplicationLoggingConfigurationRequestFilterSensitiveLog: (obj: PutSipMediaApplicationLoggingConfigurationRequest) => any;
/**
 * @internal
 */
export declare const PutSipMediaApplicationLoggingConfigurationResponseFilterSensitiveLog: (obj: PutSipMediaApplicationLoggingConfigurationResponse) => any;
/**
 * @internal
 */
export declare const PutVoiceConnectorEmergencyCallingConfigurationRequestFilterSensitiveLog: (obj: PutVoiceConnectorEmergencyCallingConfigurationRequest) => any;
/**
 * @internal
 */
export declare const PutVoiceConnectorEmergencyCallingConfigurationResponseFilterSensitiveLog: (obj: PutVoiceConnectorEmergencyCallingConfigurationResponse) => any;
/**
 * @internal
 */
export declare const PutVoiceConnectorLoggingConfigurationRequestFilterSensitiveLog: (obj: PutVoiceConnectorLoggingConfigurationRequest) => any;
/**
 * @internal
 */
export declare const PutVoiceConnectorLoggingConfigurationResponseFilterSensitiveLog: (obj: PutVoiceConnectorLoggingConfigurationResponse) => any;
/**
 * @internal
 */
export declare const PutVoiceConnectorOriginationRequestFilterSensitiveLog: (obj: PutVoiceConnectorOriginationRequest) => any;
/**
 * @internal
 */
export declare const PutVoiceConnectorOriginationResponseFilterSensitiveLog: (obj: PutVoiceConnectorOriginationResponse) => any;
/**
 * @internal
 */
export declare const PutVoiceConnectorProxyRequestFilterSensitiveLog: (obj: PutVoiceConnectorProxyRequest) => any;
/**
 * @internal
 */
export declare const PutVoiceConnectorProxyResponseFilterSensitiveLog: (obj: PutVoiceConnectorProxyResponse) => any;
/**
 * @internal
 */
export declare const PutVoiceConnectorStreamingConfigurationRequestFilterSensitiveLog: (obj: PutVoiceConnectorStreamingConfigurationRequest) => any;
/**
 * @internal
 */
export declare const PutVoiceConnectorStreamingConfigurationResponseFilterSensitiveLog: (obj: PutVoiceConnectorStreamingConfigurationResponse) => any;
/**
 * @internal
 */
export declare const PutVoiceConnectorTerminationRequestFilterSensitiveLog: (obj: PutVoiceConnectorTerminationRequest) => any;
/**
 * @internal
 */
export declare const PutVoiceConnectorTerminationResponseFilterSensitiveLog: (obj: PutVoiceConnectorTerminationResponse) => any;
/**
 * @internal
 */
export declare const CredentialFilterSensitiveLog: (obj: Credential) => any;
/**
 * @internal
 */
export declare const PutVoiceConnectorTerminationCredentialsRequestFilterSensitiveLog: (obj: PutVoiceConnectorTerminationCredentialsRequest) => any;
/**
 * @internal
 */
export declare const RestorePhoneNumberRequestFilterSensitiveLog: (obj: RestorePhoneNumberRequest) => any;
/**
 * @internal
 */
export declare const RestorePhoneNumberResponseFilterSensitiveLog: (obj: RestorePhoneNumberResponse) => any;
/**
 * @internal
 */
export declare const SearchAvailablePhoneNumbersRequestFilterSensitiveLog: (obj: SearchAvailablePhoneNumbersRequest) => any;
/**
 * @internal
 */
export declare const SearchAvailablePhoneNumbersResponseFilterSensitiveLog: (obj: SearchAvailablePhoneNumbersResponse) => any;
/**
 * @internal
 */
export declare const UpdateGlobalSettingsRequestFilterSensitiveLog: (obj: UpdateGlobalSettingsRequest) => any;
/**
 * @internal
 */
export declare const UpdatePhoneNumberRequestFilterSensitiveLog: (obj: UpdatePhoneNumberRequest) => any;
/**
 * @internal
 */
export declare const UpdatePhoneNumberResponseFilterSensitiveLog: (obj: UpdatePhoneNumberResponse) => any;
/**
 * @internal
 */
export declare const UpdatePhoneNumberSettingsRequestFilterSensitiveLog: (obj: UpdatePhoneNumberSettingsRequest) => any;
/**
 * @internal
 */
export declare const UpdateProxySessionRequestFilterSensitiveLog: (obj: UpdateProxySessionRequest) => any;
/**
 * @internal
 */
export declare const UpdateProxySessionResponseFilterSensitiveLog: (obj: UpdateProxySessionResponse) => any;
/**
 * @internal
 */
export declare const UpdateSipMediaApplicationRequestFilterSensitiveLog: (obj: UpdateSipMediaApplicationRequest) => any;
/**
 * @internal
 */
export declare const UpdateSipMediaApplicationResponseFilterSensitiveLog: (obj: UpdateSipMediaApplicationResponse) => any;
/**
 * @internal
 */
export declare const UpdateSipMediaApplicationCallRequestFilterSensitiveLog: (obj: UpdateSipMediaApplicationCallRequest) => any;
/**
 * @internal
 */
export declare const UpdateSipMediaApplicationCallResponseFilterSensitiveLog: (obj: UpdateSipMediaApplicationCallResponse) => any;
/**
 * @internal
 */
export declare const UpdateSipRuleRequestFilterSensitiveLog: (obj: UpdateSipRuleRequest) => any;
/**
 * @internal
 */
export declare const UpdateSipRuleResponseFilterSensitiveLog: (obj: UpdateSipRuleResponse) => any;
/**
 * @internal
 */
export declare const UpdateVoiceConnectorRequestFilterSensitiveLog: (obj: UpdateVoiceConnectorRequest) => any;
/**
 * @internal
 */
export declare const UpdateVoiceConnectorResponseFilterSensitiveLog: (obj: UpdateVoiceConnectorResponse) => any;
/**
 * @internal
 */
export declare const UpdateVoiceConnectorGroupRequestFilterSensitiveLog: (obj: UpdateVoiceConnectorGroupRequest) => any;
/**
 * @internal
 */
export declare const UpdateVoiceConnectorGroupResponseFilterSensitiveLog: (obj: UpdateVoiceConnectorGroupResponse) => any;
/**
 * @internal
 */
export declare const ValidateE911AddressRequestFilterSensitiveLog: (obj: ValidateE911AddressRequest) => any;
/**
 * @internal
 */
export declare const ValidateE911AddressResponseFilterSensitiveLog: (obj: ValidateE911AddressResponse) => any;
