import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { AssociateSigninDelegateGroupsWithAccountRequestFilterSensitiveLog, AssociateSigninDelegateGroupsWithAccountResponseFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_restJson1AssociateSigninDelegateGroupsWithAccountCommand, serializeAws_restJson1AssociateSigninDelegateGroupsWithAccountCommand, } from "../protocols/Aws_restJson1";
export class AssociateSigninDelegateGroupsWithAccountCommand extends $Command {
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    constructor(input) {
        super();
        this.input = input;
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, AssociateSigninDelegateGroupsWithAccountCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "ChimeClient";
        const commandName = "AssociateSigninDelegateGroupsWithAccountCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: AssociateSigninDelegateGroupsWithAccountRequestFilterSensitiveLog,
            outputFilterSensitiveLog: AssociateSigninDelegateGroupsWithAccountResponseFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_restJson1AssociateSigninDelegateGroupsWithAccountCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_restJson1AssociateSigninDelegateGroupsWithAccountCommand(output, context);
    }
}
