import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetSipMediaApplicationLoggingConfigurationRequestFilterSensitiveLog, GetSipMediaApplicationLoggingConfigurationResponseFilterSensitiveLog, } from "../models/models_1";
import { deserializeAws_restJson1GetSipMediaApplicationLoggingConfigurationCommand, serializeAws_restJson1GetSipMediaApplicationLoggingConfigurationCommand, } from "../protocols/Aws_restJson1";
export class GetSipMediaApplicationLoggingConfigurationCommand extends $Command {
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    constructor(input) {
        super();
        this.input = input;
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, GetSipMediaApplicationLoggingConfigurationCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "ChimeClient";
        const commandName = "GetSipMediaApplicationLoggingConfigurationCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: GetSipMediaApplicationLoggingConfigurationRequestFilterSensitiveLog,
            outputFilterSensitiveLog: GetSipMediaApplicationLoggingConfigurationResponseFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_restJson1GetSipMediaApplicationLoggingConfigurationCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_restJson1GetSipMediaApplicationLoggingConfigurationCommand(output, context);
    }
}
