import { SENSITIVE_STRING } from "@aws-sdk/smithy-client";
import { ChimeServiceException as __BaseException } from "./ChimeServiceException";
export var ErrorCode;
(function (ErrorCode) {
    ErrorCode["AccessDenied"] = "AccessDenied";
    ErrorCode["BadRequest"] = "BadRequest";
    ErrorCode["Conflict"] = "Conflict";
    ErrorCode["Forbidden"] = "Forbidden";
    ErrorCode["NotFound"] = "NotFound";
    ErrorCode["PhoneNumberAssociationsExist"] = "PhoneNumberAssociationsExist";
    ErrorCode["PreconditionFailed"] = "PreconditionFailed";
    ErrorCode["ResourceLimitExceeded"] = "ResourceLimitExceeded";
    ErrorCode["ServiceFailure"] = "ServiceFailure";
    ErrorCode["ServiceUnavailable"] = "ServiceUnavailable";
    ErrorCode["Throttled"] = "Throttled";
    ErrorCode["Throttling"] = "Throttling";
    ErrorCode["Unauthorized"] = "Unauthorized";
    ErrorCode["Unprocessable"] = "Unprocessable";
    ErrorCode["VoiceConnectorGroupAssociationsExist"] = "VoiceConnectorGroupAssociationsExist";
})(ErrorCode || (ErrorCode = {}));
export class AccessDeniedException extends __BaseException {
    constructor(opts) {
        super({
            name: "AccessDeniedException",
            $fault: "client",
            ...opts,
        });
        this.name = "AccessDeniedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AccessDeniedException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export var AccountStatus;
(function (AccountStatus) {
    AccountStatus["Active"] = "Active";
    AccountStatus["Suspended"] = "Suspended";
})(AccountStatus || (AccountStatus = {}));
export var AccountType;
(function (AccountType) {
    AccountType["EnterpriseDirectory"] = "EnterpriseDirectory";
    AccountType["EnterpriseLWA"] = "EnterpriseLWA";
    AccountType["EnterpriseOIDC"] = "EnterpriseOIDC";
    AccountType["Team"] = "Team";
})(AccountType || (AccountType = {}));
export var License;
(function (License) {
    License["Basic"] = "Basic";
    License["Plus"] = "Plus";
    License["Pro"] = "Pro";
    License["ProTrial"] = "ProTrial";
})(License || (License = {}));
export var AppInstanceDataType;
(function (AppInstanceDataType) {
    AppInstanceDataType["Channel"] = "Channel";
    AppInstanceDataType["ChannelMessage"] = "ChannelMessage";
})(AppInstanceDataType || (AppInstanceDataType = {}));
export var ChannelMembershipType;
(function (ChannelMembershipType) {
    ChannelMembershipType["DEFAULT"] = "DEFAULT";
    ChannelMembershipType["HIDDEN"] = "HIDDEN";
})(ChannelMembershipType || (ChannelMembershipType = {}));
export var AudioMuxType;
(function (AudioMuxType) {
    AudioMuxType["AudioOnly"] = "AudioOnly";
    AudioMuxType["AudioWithActiveSpeakerVideo"] = "AudioWithActiveSpeakerVideo";
})(AudioMuxType || (AudioMuxType = {}));
export var ContentMuxType;
(function (ContentMuxType) {
    ContentMuxType["ContentOnly"] = "ContentOnly";
})(ContentMuxType || (ContentMuxType = {}));
export var ArtifactsState;
(function (ArtifactsState) {
    ArtifactsState["Disabled"] = "Disabled";
    ArtifactsState["Enabled"] = "Enabled";
})(ArtifactsState || (ArtifactsState = {}));
export var VideoMuxType;
(function (VideoMuxType) {
    VideoMuxType["VideoOnly"] = "VideoOnly";
})(VideoMuxType || (VideoMuxType = {}));
export class BadRequestException extends __BaseException {
    constructor(opts) {
        super({
            name: "BadRequestException",
            $fault: "client",
            ...opts,
        });
        this.name = "BadRequestException";
        this.$fault = "client";
        Object.setPrototypeOf(this, BadRequestException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export class ForbiddenException extends __BaseException {
    constructor(opts) {
        super({
            name: "ForbiddenException",
            $fault: "client",
            ...opts,
        });
        this.name = "ForbiddenException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ForbiddenException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export class NotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "NotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "NotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, NotFoundException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export class ServiceFailureException extends __BaseException {
    constructor(opts) {
        super({
            name: "ServiceFailureException",
            $fault: "server",
            ...opts,
        });
        this.name = "ServiceFailureException";
        this.$fault = "server";
        Object.setPrototypeOf(this, ServiceFailureException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export class ServiceUnavailableException extends __BaseException {
    constructor(opts) {
        super({
            name: "ServiceUnavailableException",
            $fault: "server",
            ...opts,
        });
        this.name = "ServiceUnavailableException";
        this.$fault = "server";
        Object.setPrototypeOf(this, ServiceUnavailableException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export class ThrottledClientException extends __BaseException {
    constructor(opts) {
        super({
            name: "ThrottledClientException",
            $fault: "client",
            ...opts,
        });
        this.name = "ThrottledClientException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ThrottledClientException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export class UnauthorizedClientException extends __BaseException {
    constructor(opts) {
        super({
            name: "UnauthorizedClientException",
            $fault: "client",
            ...opts,
        });
        this.name = "UnauthorizedClientException";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnauthorizedClientException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export class ResourceLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourceLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceLimitExceededException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export var RoomMembershipRole;
(function (RoomMembershipRole) {
    RoomMembershipRole["Administrator"] = "Administrator";
    RoomMembershipRole["Member"] = "Member";
})(RoomMembershipRole || (RoomMembershipRole = {}));
export var PhoneNumberProductType;
(function (PhoneNumberProductType) {
    PhoneNumberProductType["BusinessCalling"] = "BusinessCalling";
    PhoneNumberProductType["SipMediaApplicationDialIn"] = "SipMediaApplicationDialIn";
    PhoneNumberProductType["VoiceConnector"] = "VoiceConnector";
})(PhoneNumberProductType || (PhoneNumberProductType = {}));
export var UserType;
(function (UserType) {
    UserType["PrivateUser"] = "PrivateUser";
    UserType["SharedDevice"] = "SharedDevice";
})(UserType || (UserType = {}));
export var BotType;
(function (BotType) {
    BotType["ChatBot"] = "ChatBot";
})(BotType || (BotType = {}));
export var CallingNameStatus;
(function (CallingNameStatus) {
    CallingNameStatus["Unassigned"] = "Unassigned";
    CallingNameStatus["UpdateFailed"] = "UpdateFailed";
    CallingNameStatus["UpdateInProgress"] = "UpdateInProgress";
    CallingNameStatus["UpdateSucceeded"] = "UpdateSucceeded";
})(CallingNameStatus || (CallingNameStatus = {}));
export var Capability;
(function (Capability) {
    Capability["SMS"] = "SMS";
    Capability["Voice"] = "Voice";
})(Capability || (Capability = {}));
export var ChannelMode;
(function (ChannelMode) {
    ChannelMode["RESTRICTED"] = "RESTRICTED";
    ChannelMode["UNRESTRICTED"] = "UNRESTRICTED";
})(ChannelMode || (ChannelMode = {}));
export var ChannelPrivacy;
(function (ChannelPrivacy) {
    ChannelPrivacy["PRIVATE"] = "PRIVATE";
    ChannelPrivacy["PUBLIC"] = "PUBLIC";
})(ChannelPrivacy || (ChannelPrivacy = {}));
export var ChannelMessagePersistenceType;
(function (ChannelMessagePersistenceType) {
    ChannelMessagePersistenceType["NON_PERSISTENT"] = "NON_PERSISTENT";
    ChannelMessagePersistenceType["PERSISTENT"] = "PERSISTENT";
})(ChannelMessagePersistenceType || (ChannelMessagePersistenceType = {}));
export var ChannelMessageType;
(function (ChannelMessageType) {
    ChannelMessageType["CONTROL"] = "CONTROL";
    ChannelMessageType["STANDARD"] = "STANDARD";
})(ChannelMessageType || (ChannelMessageType = {}));
export class ConflictException extends __BaseException {
    constructor(opts) {
        super({
            name: "ConflictException",
            $fault: "client",
            ...opts,
        });
        this.name = "ConflictException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ConflictException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export var MediaPipelineSinkType;
(function (MediaPipelineSinkType) {
    MediaPipelineSinkType["S3Bucket"] = "S3Bucket";
})(MediaPipelineSinkType || (MediaPipelineSinkType = {}));
export var MediaPipelineSourceType;
(function (MediaPipelineSourceType) {
    MediaPipelineSourceType["ChimeSdkMeeting"] = "ChimeSdkMeeting";
})(MediaPipelineSourceType || (MediaPipelineSourceType = {}));
export var MediaPipelineStatus;
(function (MediaPipelineStatus) {
    MediaPipelineStatus["Failed"] = "Failed";
    MediaPipelineStatus["InProgress"] = "InProgress";
    MediaPipelineStatus["Initializing"] = "Initializing";
    MediaPipelineStatus["Stopped"] = "Stopped";
    MediaPipelineStatus["Stopping"] = "Stopping";
})(MediaPipelineStatus || (MediaPipelineStatus = {}));
export var OrderedPhoneNumberStatus;
(function (OrderedPhoneNumberStatus) {
    OrderedPhoneNumberStatus["Acquired"] = "Acquired";
    OrderedPhoneNumberStatus["Failed"] = "Failed";
    OrderedPhoneNumberStatus["Processing"] = "Processing";
})(OrderedPhoneNumberStatus || (OrderedPhoneNumberStatus = {}));
export var PhoneNumberOrderStatus;
(function (PhoneNumberOrderStatus) {
    PhoneNumberOrderStatus["Failed"] = "Failed";
    PhoneNumberOrderStatus["Partial"] = "Partial";
    PhoneNumberOrderStatus["Processing"] = "Processing";
    PhoneNumberOrderStatus["Successful"] = "Successful";
})(PhoneNumberOrderStatus || (PhoneNumberOrderStatus = {}));
export var GeoMatchLevel;
(function (GeoMatchLevel) {
    GeoMatchLevel["AreaCode"] = "AreaCode";
    GeoMatchLevel["Country"] = "Country";
})(GeoMatchLevel || (GeoMatchLevel = {}));
export var NumberSelectionBehavior;
(function (NumberSelectionBehavior) {
    NumberSelectionBehavior["AvoidSticky"] = "AvoidSticky";
    NumberSelectionBehavior["PreferSticky"] = "PreferSticky";
})(NumberSelectionBehavior || (NumberSelectionBehavior = {}));
export var ProxySessionStatus;
(function (ProxySessionStatus) {
    ProxySessionStatus["Closed"] = "Closed";
    ProxySessionStatus["InProgress"] = "InProgress";
    ProxySessionStatus["Open"] = "Open";
})(ProxySessionStatus || (ProxySessionStatus = {}));
export var MemberType;
(function (MemberType) {
    MemberType["Bot"] = "Bot";
    MemberType["User"] = "User";
    MemberType["Webhook"] = "Webhook";
})(MemberType || (MemberType = {}));
export var SipRuleTriggerType;
(function (SipRuleTriggerType) {
    SipRuleTriggerType["RequestUriHostname"] = "RequestUriHostname";
    SipRuleTriggerType["ToPhoneNumber"] = "ToPhoneNumber";
})(SipRuleTriggerType || (SipRuleTriggerType = {}));
export var InviteStatus;
(function (InviteStatus) {
    InviteStatus["Accepted"] = "Accepted";
    InviteStatus["Failed"] = "Failed";
    InviteStatus["Pending"] = "Pending";
})(InviteStatus || (InviteStatus = {}));
export var RegistrationStatus;
(function (RegistrationStatus) {
    RegistrationStatus["Registered"] = "Registered";
    RegistrationStatus["Suspended"] = "Suspended";
    RegistrationStatus["Unregistered"] = "Unregistered";
})(RegistrationStatus || (RegistrationStatus = {}));
export var VoiceConnectorAwsRegion;
(function (VoiceConnectorAwsRegion) {
    VoiceConnectorAwsRegion["US_EAST_1"] = "us-east-1";
    VoiceConnectorAwsRegion["US_WEST_2"] = "us-west-2";
})(VoiceConnectorAwsRegion || (VoiceConnectorAwsRegion = {}));
export class UnprocessableEntityException extends __BaseException {
    constructor(opts) {
        super({
            name: "UnprocessableEntityException",
            $fault: "client",
            ...opts,
        });
        this.name = "UnprocessableEntityException";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnprocessableEntityException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export var EmailStatus;
(function (EmailStatus) {
    EmailStatus["Failed"] = "Failed";
    EmailStatus["NotSent"] = "NotSent";
    EmailStatus["Sent"] = "Sent";
})(EmailStatus || (EmailStatus = {}));
export var TranscribeMedicalContentIdentificationType;
(function (TranscribeMedicalContentIdentificationType) {
    TranscribeMedicalContentIdentificationType["PHI"] = "PHI";
})(TranscribeMedicalContentIdentificationType || (TranscribeMedicalContentIdentificationType = {}));
export var TranscribeMedicalLanguageCode;
(function (TranscribeMedicalLanguageCode) {
    TranscribeMedicalLanguageCode["EN_US"] = "en-US";
})(TranscribeMedicalLanguageCode || (TranscribeMedicalLanguageCode = {}));
export var TranscribeMedicalRegion;
(function (TranscribeMedicalRegion) {
    TranscribeMedicalRegion["AP_SOUTHEAST_2"] = "ap-southeast-2";
    TranscribeMedicalRegion["AUTO"] = "auto";
    TranscribeMedicalRegion["CA_CENTRAL_1"] = "ca-central-1";
    TranscribeMedicalRegion["EU_WEST_1"] = "eu-west-1";
    TranscribeMedicalRegion["US_EAST_1"] = "us-east-1";
    TranscribeMedicalRegion["US_EAST_2"] = "us-east-2";
    TranscribeMedicalRegion["US_WEST_2"] = "us-west-2";
})(TranscribeMedicalRegion || (TranscribeMedicalRegion = {}));
export var TranscribeMedicalSpecialty;
(function (TranscribeMedicalSpecialty) {
    TranscribeMedicalSpecialty["Cardiology"] = "CARDIOLOGY";
    TranscribeMedicalSpecialty["Neurology"] = "NEUROLOGY";
    TranscribeMedicalSpecialty["Oncology"] = "ONCOLOGY";
    TranscribeMedicalSpecialty["PrimaryCare"] = "PRIMARYCARE";
    TranscribeMedicalSpecialty["Radiology"] = "RADIOLOGY";
    TranscribeMedicalSpecialty["Urology"] = "UROLOGY";
})(TranscribeMedicalSpecialty || (TranscribeMedicalSpecialty = {}));
export var TranscribeMedicalType;
(function (TranscribeMedicalType) {
    TranscribeMedicalType["Conversation"] = "CONVERSATION";
    TranscribeMedicalType["Dictation"] = "DICTATION";
})(TranscribeMedicalType || (TranscribeMedicalType = {}));
export var TranscribeContentIdentificationType;
(function (TranscribeContentIdentificationType) {
    TranscribeContentIdentificationType["PII"] = "PII";
})(TranscribeContentIdentificationType || (TranscribeContentIdentificationType = {}));
export var TranscribeContentRedactionType;
(function (TranscribeContentRedactionType) {
    TranscribeContentRedactionType["PII"] = "PII";
})(TranscribeContentRedactionType || (TranscribeContentRedactionType = {}));
export var TranscribeLanguageCode;
(function (TranscribeLanguageCode) {
    TranscribeLanguageCode["DE_DE"] = "de-DE";
    TranscribeLanguageCode["EN_AU"] = "en-AU";
    TranscribeLanguageCode["EN_GB"] = "en-GB";
    TranscribeLanguageCode["EN_US"] = "en-US";
    TranscribeLanguageCode["ES_US"] = "es-US";
    TranscribeLanguageCode["FR_CA"] = "fr-CA";
    TranscribeLanguageCode["FR_FR"] = "fr-FR";
    TranscribeLanguageCode["IT_IT"] = "it-IT";
    TranscribeLanguageCode["JA_JP"] = "ja-JP";
    TranscribeLanguageCode["KO_KR"] = "ko-KR";
    TranscribeLanguageCode["PT_BR"] = "pt-BR";
    TranscribeLanguageCode["ZH_CN"] = "zh-CN";
})(TranscribeLanguageCode || (TranscribeLanguageCode = {}));
export var TranscribePartialResultsStability;
(function (TranscribePartialResultsStability) {
    TranscribePartialResultsStability["HIGH"] = "high";
    TranscribePartialResultsStability["LOW"] = "low";
    TranscribePartialResultsStability["MEDIUM"] = "medium";
})(TranscribePartialResultsStability || (TranscribePartialResultsStability = {}));
export var TranscribeRegion;
(function (TranscribeRegion) {
    TranscribeRegion["AP_NORTHEAST_1"] = "ap-northeast-1";
    TranscribeRegion["AP_NORTHEAST_2"] = "ap-northeast-2";
    TranscribeRegion["AP_SOUTHEAST_2"] = "ap-southeast-2";
    TranscribeRegion["AUTO"] = "auto";
    TranscribeRegion["CA_CENTRAL_1"] = "ca-central-1";
    TranscribeRegion["EU_CENTRAL_1"] = "eu-central-1";
    TranscribeRegion["EU_WEST_1"] = "eu-west-1";
    TranscribeRegion["EU_WEST_2"] = "eu-west-2";
    TranscribeRegion["SA_EAST_1"] = "sa-east-1";
    TranscribeRegion["US_EAST_1"] = "us-east-1";
    TranscribeRegion["US_EAST_2"] = "us-east-2";
    TranscribeRegion["US_WEST_2"] = "us-west-2";
})(TranscribeRegion || (TranscribeRegion = {}));
export var TranscribeVocabularyFilterMethod;
(function (TranscribeVocabularyFilterMethod) {
    TranscribeVocabularyFilterMethod["Mask"] = "mask";
    TranscribeVocabularyFilterMethod["Remove"] = "remove";
    TranscribeVocabularyFilterMethod["Tag"] = "tag";
})(TranscribeVocabularyFilterMethod || (TranscribeVocabularyFilterMethod = {}));
export var PhoneNumberAssociationName;
(function (PhoneNumberAssociationName) {
    PhoneNumberAssociationName["AccountId"] = "AccountId";
    PhoneNumberAssociationName["SipRuleId"] = "SipRuleId";
    PhoneNumberAssociationName["UserId"] = "UserId";
    PhoneNumberAssociationName["VoiceConnectorGroupId"] = "VoiceConnectorGroupId";
    PhoneNumberAssociationName["VoiceConnectorId"] = "VoiceConnectorId";
})(PhoneNumberAssociationName || (PhoneNumberAssociationName = {}));
export var PhoneNumberStatus;
(function (PhoneNumberStatus) {
    PhoneNumberStatus["AcquireFailed"] = "AcquireFailed";
    PhoneNumberStatus["AcquireInProgress"] = "AcquireInProgress";
    PhoneNumberStatus["Assigned"] = "Assigned";
    PhoneNumberStatus["DeleteFailed"] = "DeleteFailed";
    PhoneNumberStatus["DeleteInProgress"] = "DeleteInProgress";
    PhoneNumberStatus["ReleaseFailed"] = "ReleaseFailed";
    PhoneNumberStatus["ReleaseInProgress"] = "ReleaseInProgress";
    PhoneNumberStatus["Unassigned"] = "Unassigned";
})(PhoneNumberStatus || (PhoneNumberStatus = {}));
export var PhoneNumberType;
(function (PhoneNumberType) {
    PhoneNumberType["Local"] = "Local";
    PhoneNumberType["TollFree"] = "TollFree";
})(PhoneNumberType || (PhoneNumberType = {}));
export const SigninDelegateGroupFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AccountFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AccountSettingsFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AddressFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.streetName && { streetName: SENSITIVE_STRING }),
    ...(obj.streetSuffix && { streetSuffix: SENSITIVE_STRING }),
    ...(obj.postDirectional && { postDirectional: SENSITIVE_STRING }),
    ...(obj.preDirectional && { preDirectional: SENSITIVE_STRING }),
    ...(obj.streetNumber && { streetNumber: SENSITIVE_STRING }),
    ...(obj.city && { city: SENSITIVE_STRING }),
    ...(obj.state && { state: SENSITIVE_STRING }),
    ...(obj.postalCode && { postalCode: SENSITIVE_STRING }),
    ...(obj.postalCodePlus4 && { postalCodePlus4: SENSITIVE_STRING }),
    ...(obj.country && { country: SENSITIVE_STRING }),
});
export const AlexaForBusinessMetadataFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AlexaForBusinessRoomArn && { AlexaForBusinessRoomArn: SENSITIVE_STRING }),
});
export const AppInstanceFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
});
export const IdentityFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
});
export const AppInstanceAdminFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Admin && { Admin: IdentityFilterSensitiveLog(obj.Admin) }),
});
export const AppInstanceAdminSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Admin && { Admin: IdentityFilterSensitiveLog(obj.Admin) }),
});
export const AppInstanceSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
});
export const ChannelRetentionSettingsFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AppInstanceRetentionSettingsFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AppInstanceStreamingConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ResourceArn && { ResourceArn: SENSITIVE_STRING }),
});
export const AppInstanceUserFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
});
export const AppInstanceUserSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
});
export const AppInstanceUserMembershipSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AudioArtifactsConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ContentArtifactsConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const VideoArtifactsConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ArtifactsConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AssociatePhoneNumbersWithVoiceConnectorRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumbers && { E164PhoneNumbers: SENSITIVE_STRING }),
});
export const PhoneNumberErrorFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AssociatePhoneNumbersWithVoiceConnectorResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AssociatePhoneNumbersWithVoiceConnectorGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumbers && { E164PhoneNumbers: SENSITIVE_STRING }),
});
export const AssociatePhoneNumbersWithVoiceConnectorGroupResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AssociatePhoneNumberWithUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumber && { E164PhoneNumber: SENSITIVE_STRING }),
});
export const AssociatePhoneNumberWithUserResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AssociateSigninDelegateGroupsWithAccountRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AssociateSigninDelegateGroupsWithAccountResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AttendeeFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ExternalUserId && { ExternalUserId: SENSITIVE_STRING }),
    ...(obj.JoinToken && { JoinToken: SENSITIVE_STRING }),
});
export const TagFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Key && { Key: SENSITIVE_STRING }),
    ...(obj.Value && { Value: SENSITIVE_STRING }),
});
export const BatchChannelMembershipsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.InvitedBy && { InvitedBy: IdentityFilterSensitiveLog(obj.InvitedBy) }),
    ...(obj.Members && { Members: obj.Members.map((item) => IdentityFilterSensitiveLog(item)) }),
});
export const CreateAttendeeRequestItemFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ExternalUserId && { ExternalUserId: SENSITIVE_STRING }),
    ...(obj.Tags && { Tags: obj.Tags.map((item) => TagFilterSensitiveLog(item)) }),
});
export const BatchCreateAttendeeRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Attendees && { Attendees: obj.Attendees.map((item) => CreateAttendeeRequestItemFilterSensitiveLog(item)) }),
});
export const CreateAttendeeErrorFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ExternalUserId && { ExternalUserId: SENSITIVE_STRING }),
});
export const BatchCreateAttendeeResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Attendees && { Attendees: obj.Attendees.map((item) => AttendeeFilterSensitiveLog(item)) }),
    ...(obj.Errors && { Errors: obj.Errors.map((item) => CreateAttendeeErrorFilterSensitiveLog(item)) }),
});
export const BatchCreateChannelMembershipRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const BatchCreateChannelMembershipErrorFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const BatchCreateChannelMembershipResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.BatchChannelMemberships && {
        BatchChannelMemberships: BatchChannelMembershipsFilterSensitiveLog(obj.BatchChannelMemberships),
    }),
});
export const MembershipItemFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const BatchCreateRoomMembershipRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const MemberErrorFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const BatchCreateRoomMembershipResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const BatchDeletePhoneNumberRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const BatchDeletePhoneNumberResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const BatchSuspendUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UserErrorFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const BatchSuspendUserResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const BatchUnsuspendUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const BatchUnsuspendUserResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdatePhoneNumberRequestItemFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.CallingName && { CallingName: SENSITIVE_STRING }),
});
export const BatchUpdatePhoneNumberRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.UpdatePhoneNumberRequestItems && {
        UpdatePhoneNumberRequestItems: obj.UpdatePhoneNumberRequestItems.map((item) => UpdatePhoneNumberRequestItemFilterSensitiveLog(item)),
    }),
});
export const BatchUpdatePhoneNumberResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UpdateUserRequestItemFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AlexaForBusinessMetadata && {
        AlexaForBusinessMetadata: AlexaForBusinessMetadataFilterSensitiveLog(obj.AlexaForBusinessMetadata),
    }),
});
export const BatchUpdateUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.UpdateUserRequestItems && {
        UpdateUserRequestItems: obj.UpdateUserRequestItems.map((item) => UpdateUserRequestItemFilterSensitiveLog(item)),
    }),
});
export const BatchUpdateUserResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const BotFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.DisplayName && { DisplayName: SENSITIVE_STRING }),
    ...(obj.BotEmail && { BotEmail: SENSITIVE_STRING }),
    ...(obj.SecurityToken && { SecurityToken: SENSITIVE_STRING }),
});
export const BusinessCallingSettingsFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CandidateAddressFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.streetInfo && { streetInfo: SENSITIVE_STRING }),
    ...(obj.streetNumber && { streetNumber: SENSITIVE_STRING }),
    ...(obj.city && { city: SENSITIVE_STRING }),
    ...(obj.state && { state: SENSITIVE_STRING }),
    ...(obj.postalCode && { postalCode: SENSITIVE_STRING }),
    ...(obj.postalCodePlus4 && { postalCodePlus4: SENSITIVE_STRING }),
    ...(obj.country && { country: SENSITIVE_STRING }),
});
export const ChannelFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
    ...(obj.CreatedBy && { CreatedBy: IdentityFilterSensitiveLog(obj.CreatedBy) }),
});
export const ChannelBanFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Member && { Member: IdentityFilterSensitiveLog(obj.Member) }),
    ...(obj.CreatedBy && { CreatedBy: IdentityFilterSensitiveLog(obj.CreatedBy) }),
});
export const ChannelBanSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Member && { Member: IdentityFilterSensitiveLog(obj.Member) }),
});
export const ChannelMembershipFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.InvitedBy && { InvitedBy: IdentityFilterSensitiveLog(obj.InvitedBy) }),
    ...(obj.Member && { Member: IdentityFilterSensitiveLog(obj.Member) }),
});
export const ChannelSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
});
export const ChannelMembershipForAppInstanceUserSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ChannelSummary && { ChannelSummary: ChannelSummaryFilterSensitiveLog(obj.ChannelSummary) }),
});
export const ChannelMembershipSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Member && { Member: IdentityFilterSensitiveLog(obj.Member) }),
});
export const ChannelMessageFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Content && { Content: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
    ...(obj.Sender && { Sender: IdentityFilterSensitiveLog(obj.Sender) }),
});
export const ChannelMessageSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Content && { Content: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
    ...(obj.Sender && { Sender: IdentityFilterSensitiveLog(obj.Sender) }),
});
export const ChannelModeratedByAppInstanceUserSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ChannelSummary && { ChannelSummary: ChannelSummaryFilterSensitiveLog(obj.ChannelSummary) }),
});
export const ChannelModeratorFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Moderator && { Moderator: IdentityFilterSensitiveLog(obj.Moderator) }),
    ...(obj.CreatedBy && { CreatedBy: IdentityFilterSensitiveLog(obj.CreatedBy) }),
});
export const ChannelModeratorSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Moderator && { Moderator: IdentityFilterSensitiveLog(obj.Moderator) }),
});
export const SelectedVideoStreamsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ExternalUserIds && { ExternalUserIds: SENSITIVE_STRING }),
});
export const SourceConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SelectedVideoStreams && {
        SelectedVideoStreams: SelectedVideoStreamsFilterSensitiveLog(obj.SelectedVideoStreams),
    }),
});
export const ChimeSdkMeetingConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SourceConfiguration && {
        SourceConfiguration: SourceConfigurationFilterSensitiveLog(obj.SourceConfiguration),
    }),
});
export const ConversationRetentionSettingsFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateAccountRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateAccountResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateAppInstanceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
    ...(obj.ClientRequestToken && { ClientRequestToken: SENSITIVE_STRING }),
    ...(obj.Tags && { Tags: obj.Tags.map((item) => TagFilterSensitiveLog(item)) }),
});
export const CreateAppInstanceResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateAppInstanceAdminRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateAppInstanceAdminResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceAdmin && { AppInstanceAdmin: IdentityFilterSensitiveLog(obj.AppInstanceAdmin) }),
});
export const CreateAppInstanceUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceUserId && { AppInstanceUserId: SENSITIVE_STRING }),
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
    ...(obj.ClientRequestToken && { ClientRequestToken: SENSITIVE_STRING }),
    ...(obj.Tags && { Tags: obj.Tags.map((item) => TagFilterSensitiveLog(item)) }),
});
export const CreateAppInstanceUserResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateAttendeeRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ExternalUserId && { ExternalUserId: SENSITIVE_STRING }),
    ...(obj.Tags && { Tags: obj.Tags.map((item) => TagFilterSensitiveLog(item)) }),
});
export const CreateAttendeeResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Attendee && { Attendee: AttendeeFilterSensitiveLog(obj.Attendee) }),
});
export const CreateBotRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.DisplayName && { DisplayName: SENSITIVE_STRING }),
});
export const CreateBotResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Bot && { Bot: BotFilterSensitiveLog(obj.Bot) }),
});
export const CreateChannelRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
    ...(obj.ClientRequestToken && { ClientRequestToken: SENSITIVE_STRING }),
    ...(obj.Tags && { Tags: obj.Tags.map((item) => TagFilterSensitiveLog(item)) }),
});
export const CreateChannelResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateChannelBanRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateChannelBanResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Member && { Member: IdentityFilterSensitiveLog(obj.Member) }),
});
export const CreateChannelMembershipRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateChannelMembershipResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Member && { Member: IdentityFilterSensitiveLog(obj.Member) }),
});
export const CreateChannelModeratorRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateChannelModeratorResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ChannelModerator && { ChannelModerator: IdentityFilterSensitiveLog(obj.ChannelModerator) }),
});
export const CreateMediaCapturePipelineRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SourceArn && { SourceArn: SENSITIVE_STRING }),
    ...(obj.SinkArn && { SinkArn: SENSITIVE_STRING }),
    ...(obj.ClientRequestToken && { ClientRequestToken: SENSITIVE_STRING }),
    ...(obj.ChimeSdkMeetingConfiguration && {
        ChimeSdkMeetingConfiguration: ChimeSdkMeetingConfigurationFilterSensitiveLog(obj.ChimeSdkMeetingConfiguration),
    }),
});
export const MediaCapturePipelineFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SourceArn && { SourceArn: SENSITIVE_STRING }),
    ...(obj.SinkArn && { SinkArn: SENSITIVE_STRING }),
    ...(obj.ChimeSdkMeetingConfiguration && {
        ChimeSdkMeetingConfiguration: ChimeSdkMeetingConfigurationFilterSensitiveLog(obj.ChimeSdkMeetingConfiguration),
    }),
});
export const CreateMediaCapturePipelineResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaCapturePipeline && {
        MediaCapturePipeline: MediaCapturePipelineFilterSensitiveLog(obj.MediaCapturePipeline),
    }),
});
export const MeetingNotificationConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SnsTopicArn && { SnsTopicArn: SENSITIVE_STRING }),
    ...(obj.SqsQueueArn && { SqsQueueArn: SENSITIVE_STRING }),
});
export const CreateMeetingRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ClientRequestToken && { ClientRequestToken: SENSITIVE_STRING }),
    ...(obj.ExternalMeetingId && { ExternalMeetingId: SENSITIVE_STRING }),
    ...(obj.MeetingHostId && { MeetingHostId: SENSITIVE_STRING }),
    ...(obj.Tags && { Tags: obj.Tags.map((item) => TagFilterSensitiveLog(item)) }),
    ...(obj.NotificationsConfiguration && {
        NotificationsConfiguration: MeetingNotificationConfigurationFilterSensitiveLog(obj.NotificationsConfiguration),
    }),
});
export const MediaPlacementFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const MeetingFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ExternalMeetingId && { ExternalMeetingId: SENSITIVE_STRING }),
});
export const CreateMeetingResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Meeting && { Meeting: MeetingFilterSensitiveLog(obj.Meeting) }),
});
export const CreateMeetingDialOutRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.FromPhoneNumber && { FromPhoneNumber: SENSITIVE_STRING }),
    ...(obj.ToPhoneNumber && { ToPhoneNumber: SENSITIVE_STRING }),
    ...(obj.JoinToken && { JoinToken: SENSITIVE_STRING }),
});
export const CreateMeetingDialOutResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateMeetingWithAttendeesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ClientRequestToken && { ClientRequestToken: SENSITIVE_STRING }),
    ...(obj.ExternalMeetingId && { ExternalMeetingId: SENSITIVE_STRING }),
    ...(obj.MeetingHostId && { MeetingHostId: SENSITIVE_STRING }),
    ...(obj.Tags && { Tags: obj.Tags.map((item) => TagFilterSensitiveLog(item)) }),
    ...(obj.NotificationsConfiguration && {
        NotificationsConfiguration: MeetingNotificationConfigurationFilterSensitiveLog(obj.NotificationsConfiguration),
    }),
    ...(obj.Attendees && { Attendees: obj.Attendees.map((item) => CreateAttendeeRequestItemFilterSensitiveLog(item)) }),
});
export const CreateMeetingWithAttendeesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Meeting && { Meeting: MeetingFilterSensitiveLog(obj.Meeting) }),
    ...(obj.Attendees && { Attendees: obj.Attendees.map((item) => AttendeeFilterSensitiveLog(item)) }),
    ...(obj.Errors && { Errors: obj.Errors.map((item) => CreateAttendeeErrorFilterSensitiveLog(item)) }),
});
export const CreatePhoneNumberOrderRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumbers && { E164PhoneNumbers: SENSITIVE_STRING }),
});
export const OrderedPhoneNumberFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumber && { E164PhoneNumber: SENSITIVE_STRING }),
});
export const PhoneNumberOrderFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.OrderedPhoneNumbers && {
        OrderedPhoneNumbers: obj.OrderedPhoneNumbers.map((item) => OrderedPhoneNumberFilterSensitiveLog(item)),
    }),
});
export const CreatePhoneNumberOrderResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumberOrder && { PhoneNumberOrder: PhoneNumberOrderFilterSensitiveLog(obj.PhoneNumberOrder) }),
});
export const GeoMatchParamsFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateProxySessionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ParticipantPhoneNumbers && { ParticipantPhoneNumbers: SENSITIVE_STRING }),
    ...(obj.Name && { Name: SENSITIVE_STRING }),
});
export const ParticipantFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumber && { PhoneNumber: SENSITIVE_STRING }),
    ...(obj.ProxyPhoneNumber && { ProxyPhoneNumber: SENSITIVE_STRING }),
});
export const ProxySessionFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Participants && { Participants: obj.Participants.map((item) => ParticipantFilterSensitiveLog(item)) }),
});
export const CreateProxySessionResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ProxySession && { ProxySession: ProxySessionFilterSensitiveLog(obj.ProxySession) }),
});
export const CreateRoomRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.ClientRequestToken && { ClientRequestToken: SENSITIVE_STRING }),
});
export const RoomFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
});
export const CreateRoomResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Room && { Room: RoomFilterSensitiveLog(obj.Room) }),
});
export const CreateRoomMembershipRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const MemberFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Email && { Email: SENSITIVE_STRING }),
    ...(obj.FullName && { FullName: SENSITIVE_STRING }),
});
export const RoomMembershipFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Member && { Member: MemberFilterSensitiveLog(obj.Member) }),
});
export const CreateRoomMembershipResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.RoomMembership && { RoomMembership: RoomMembershipFilterSensitiveLog(obj.RoomMembership) }),
});
export const SipMediaApplicationEndpointFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.LambdaArn && { LambdaArn: SENSITIVE_STRING }),
});
export const CreateSipMediaApplicationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Endpoints && { Endpoints: obj.Endpoints.map((item) => SipMediaApplicationEndpointFilterSensitiveLog(item)) }),
});
export const SipMediaApplicationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Endpoints && { Endpoints: obj.Endpoints.map((item) => SipMediaApplicationEndpointFilterSensitiveLog(item)) }),
});
export const CreateSipMediaApplicationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SipMediaApplication && {
        SipMediaApplication: SipMediaApplicationFilterSensitiveLog(obj.SipMediaApplication),
    }),
});
export const CreateSipMediaApplicationCallRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.FromPhoneNumber && { FromPhoneNumber: SENSITIVE_STRING }),
    ...(obj.ToPhoneNumber && { ToPhoneNumber: SENSITIVE_STRING }),
    ...(obj.SipHeaders && { SipHeaders: SENSITIVE_STRING }),
});
export const SipMediaApplicationCallFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateSipMediaApplicationCallResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SipRuleTargetApplicationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateSipRuleRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SipRuleFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateSipRuleResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Email && { Email: SENSITIVE_STRING }),
});
export const UserFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PrimaryEmail && { PrimaryEmail: SENSITIVE_STRING }),
    ...(obj.PrimaryProvisionedNumber && { PrimaryProvisionedNumber: SENSITIVE_STRING }),
    ...(obj.DisplayName && { DisplayName: SENSITIVE_STRING }),
    ...(obj.AlexaForBusinessMetadata && {
        AlexaForBusinessMetadata: AlexaForBusinessMetadataFilterSensitiveLog(obj.AlexaForBusinessMetadata),
    }),
});
export const CreateUserResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.User && { User: UserFilterSensitiveLog(obj.User) }),
});
export const CreateVoiceConnectorRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const VoiceConnectorFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateVoiceConnectorResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const VoiceConnectorItemFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateVoiceConnectorGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const VoiceConnectorGroupFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CreateVoiceConnectorGroupResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CredentialFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Username && { Username: SENSITIVE_STRING }),
    ...(obj.Password && { Password: SENSITIVE_STRING }),
});
export const DeleteAccountRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteAccountResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteAppInstanceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteAppInstanceAdminRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteAppInstanceStreamingConfigurationsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteAppInstanceUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteAttendeeRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteChannelRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteChannelBanRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteChannelMembershipRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteChannelMessageRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteChannelModeratorRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteEventsConfigurationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteMediaCapturePipelineRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteMeetingRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeletePhoneNumberRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteProxySessionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteRoomRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteRoomMembershipRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteSipMediaApplicationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteSipRuleRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteVoiceConnectorRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteVoiceConnectorEmergencyCallingConfigurationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteVoiceConnectorGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteVoiceConnectorOriginationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteVoiceConnectorProxyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteVoiceConnectorStreamingConfigurationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteVoiceConnectorTerminationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DeleteVoiceConnectorTerminationCredentialsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Usernames && { Usernames: SENSITIVE_STRING }),
});
export const DescribeAppInstanceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeAppInstanceResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstance && { AppInstance: AppInstanceFilterSensitiveLog(obj.AppInstance) }),
});
export const DescribeAppInstanceAdminRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeAppInstanceAdminResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceAdmin && { AppInstanceAdmin: AppInstanceAdminFilterSensitiveLog(obj.AppInstanceAdmin) }),
});
export const DescribeAppInstanceUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeAppInstanceUserResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceUser && { AppInstanceUser: AppInstanceUserFilterSensitiveLog(obj.AppInstanceUser) }),
});
export const DescribeChannelRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeChannelResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Channel && { Channel: ChannelFilterSensitiveLog(obj.Channel) }),
});
export const DescribeChannelBanRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeChannelBanResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ChannelBan && { ChannelBan: ChannelBanFilterSensitiveLog(obj.ChannelBan) }),
});
export const DescribeChannelMembershipRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeChannelMembershipResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ChannelMembership && { ChannelMembership: ChannelMembershipFilterSensitiveLog(obj.ChannelMembership) }),
});
export const DescribeChannelMembershipForAppInstanceUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeChannelMembershipForAppInstanceUserResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ChannelMembership && {
        ChannelMembership: ChannelMembershipForAppInstanceUserSummaryFilterSensitiveLog(obj.ChannelMembership),
    }),
});
export const DescribeChannelModeratedByAppInstanceUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeChannelModeratedByAppInstanceUserResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Channel && { Channel: ChannelModeratedByAppInstanceUserSummaryFilterSensitiveLog(obj.Channel) }),
});
export const DescribeChannelModeratorRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeChannelModeratorResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ChannelModerator && { ChannelModerator: ChannelModeratorFilterSensitiveLog(obj.ChannelModerator) }),
});
export const DisassociatePhoneNumberFromUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DisassociatePhoneNumberFromUserResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DisassociatePhoneNumbersFromVoiceConnectorRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumbers && { E164PhoneNumbers: SENSITIVE_STRING }),
});
export const DisassociatePhoneNumbersFromVoiceConnectorResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DisassociatePhoneNumbersFromVoiceConnectorGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumbers && { E164PhoneNumbers: SENSITIVE_STRING }),
});
export const DisassociatePhoneNumbersFromVoiceConnectorGroupResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DisassociateSigninDelegateGroupsFromAccountRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DisassociateSigninDelegateGroupsFromAccountResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DNISEmergencyCallingConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.EmergencyPhoneNumber && { EmergencyPhoneNumber: SENSITIVE_STRING }),
    ...(obj.TestPhoneNumber && { TestPhoneNumber: SENSITIVE_STRING }),
});
export const EmergencyCallingConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.DNIS && { DNIS: obj.DNIS.map((item) => DNISEmergencyCallingConfigurationFilterSensitiveLog(item)) }),
});
export const EngineTranscribeMedicalSettingsFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const EngineTranscribeSettingsFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const EventsConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.OutboundEventsHTTPSEndpoint && { OutboundEventsHTTPSEndpoint: SENSITIVE_STRING }),
    ...(obj.LambdaFunctionArn && { LambdaFunctionArn: SENSITIVE_STRING }),
});
export const GetAccountRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetAccountResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetAccountSettingsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetAccountSettingsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetAppInstanceRetentionSettingsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetAppInstanceRetentionSettingsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetAppInstanceStreamingConfigurationsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetAppInstanceStreamingConfigurationsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceStreamingConfigurations && {
        AppInstanceStreamingConfigurations: obj.AppInstanceStreamingConfigurations.map((item) => AppInstanceStreamingConfigurationFilterSensitiveLog(item)),
    }),
});
export const GetAttendeeRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetAttendeeResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Attendee && { Attendee: AttendeeFilterSensitiveLog(obj.Attendee) }),
});
export const GetBotRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetBotResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Bot && { Bot: BotFilterSensitiveLog(obj.Bot) }),
});
export const GetChannelMessageRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetChannelMessageResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ChannelMessage && { ChannelMessage: ChannelMessageFilterSensitiveLog(obj.ChannelMessage) }),
});
export const GetEventsConfigurationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetEventsConfigurationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.EventsConfiguration && {
        EventsConfiguration: EventsConfigurationFilterSensitiveLog(obj.EventsConfiguration),
    }),
});
export const VoiceConnectorSettingsFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetGlobalSettingsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetMediaCapturePipelineRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetMediaCapturePipelineResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaCapturePipeline && {
        MediaCapturePipeline: MediaCapturePipelineFilterSensitiveLog(obj.MediaCapturePipeline),
    }),
});
export const GetMeetingRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetMeetingResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Meeting && { Meeting: MeetingFilterSensitiveLog(obj.Meeting) }),
});
export const GetMessagingSessionEndpointRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const MessagingSessionEndpointFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetMessagingSessionEndpointResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetPhoneNumberRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PhoneNumberAssociationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PhoneNumberCapabilitiesFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PhoneNumberFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumber && { E164PhoneNumber: SENSITIVE_STRING }),
    ...(obj.CallingName && { CallingName: SENSITIVE_STRING }),
});
export const GetPhoneNumberResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumber && { PhoneNumber: PhoneNumberFilterSensitiveLog(obj.PhoneNumber) }),
});
export const GetPhoneNumberOrderRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetPhoneNumberOrderResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumberOrder && { PhoneNumberOrder: PhoneNumberOrderFilterSensitiveLog(obj.PhoneNumberOrder) }),
});
export const GetPhoneNumberSettingsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.CallingName && { CallingName: SENSITIVE_STRING }),
});
export const GetProxySessionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetProxySessionResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ProxySession && { ProxySession: ProxySessionFilterSensitiveLog(obj.ProxySession) }),
});
export const GetRetentionSettingsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
