import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  ChimeClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../ChimeClient";
import {
  ListChannelMessagesRequest,
  ListChannelMessagesResponse,
} from "../models/models_1";
export interface ListChannelMessagesCommandInput
  extends ListChannelMessagesRequest {}
export interface ListChannelMessagesCommandOutput
  extends ListChannelMessagesResponse,
    __MetadataBearer {}
export declare class ListChannelMessagesCommand extends $Command<
  ListChannelMessagesCommandInput,
  ListChannelMessagesCommandOutput,
  ChimeClientResolvedConfig
> {
  readonly input: ListChannelMessagesCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: ListChannelMessagesCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: ChimeClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<ListChannelMessagesCommandInput, ListChannelMessagesCommandOutput>;
  private serialize;
  private deserialize;
}
