import { ExceptionOptionType as __ExceptionOptionType } from "@aws-sdk/smithy-client";
import { ChimeServiceException as __BaseException } from "./ChimeServiceException";
export declare enum ErrorCode {
  AccessDenied = "AccessDenied",
  BadRequest = "BadRequest",
  Conflict = "Conflict",
  Forbidden = "Forbidden",
  NotFound = "NotFound",
  PhoneNumberAssociationsExist = "PhoneNumberAssociationsExist",
  PreconditionFailed = "PreconditionFailed",
  ResourceLimitExceeded = "ResourceLimitExceeded",
  ServiceFailure = "ServiceFailure",
  ServiceUnavailable = "ServiceUnavailable",
  Throttled = "Throttled",
  Throttling = "Throttling",
  Unauthorized = "Unauthorized",
  Unprocessable = "Unprocessable",
  VoiceConnectorGroupAssociationsExist = "VoiceConnectorGroupAssociationsExist",
}
export declare class AccessDeniedException extends __BaseException {
  readonly name: "AccessDeniedException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<AccessDeniedException, __BaseException>
  );
}
export declare enum AccountStatus {
  Active = "Active",
  Suspended = "Suspended",
}
export declare enum AccountType {
  EnterpriseDirectory = "EnterpriseDirectory",
  EnterpriseLWA = "EnterpriseLWA",
  EnterpriseOIDC = "EnterpriseOIDC",
  Team = "Team",
}
export declare enum License {
  Basic = "Basic",
  Plus = "Plus",
  Pro = "Pro",
  ProTrial = "ProTrial",
}
export interface SigninDelegateGroup {
  GroupName?: string;
}
export interface Account {
  AwsAccountId: string | undefined;
  AccountId: string | undefined;
  Name: string | undefined;
  AccountType?: AccountType | string;
  CreatedTimestamp?: Date;
  DefaultLicense?: License | string;
  SupportedLicenses?: (License | string)[];
  AccountStatus?: AccountStatus | string;
  SigninDelegateGroups?: SigninDelegateGroup[];
}
export interface AccountSettings {
  DisableRemoteControl?: boolean;
  EnableDialOut?: boolean;
}
export interface Address {
  streetName?: string;
  streetSuffix?: string;
  postDirectional?: string;
  preDirectional?: string;
  streetNumber?: string;
  city?: string;
  state?: string;
  postalCode?: string;
  postalCodePlus4?: string;
  country?: string;
}
export interface AlexaForBusinessMetadata {
  IsAlexaForBusinessEnabled?: boolean;
  AlexaForBusinessRoomArn?: string;
}
export interface AppInstance {
  AppInstanceArn?: string;
  Name?: string;
  Metadata?: string;
  CreatedTimestamp?: Date;
  LastUpdatedTimestamp?: Date;
}
export interface Identity {
  Arn?: string;
  Name?: string;
}
export interface AppInstanceAdmin {
  Admin?: Identity;
  AppInstanceArn?: string;
  CreatedTimestamp?: Date;
}
export interface AppInstanceAdminSummary {
  Admin?: Identity;
}
export declare enum AppInstanceDataType {
  Channel = "Channel",
  ChannelMessage = "ChannelMessage",
}
export interface AppInstanceSummary {
  AppInstanceArn?: string;
  Name?: string;
  Metadata?: string;
}
export interface ChannelRetentionSettings {
  RetentionDays?: number;
}
export interface AppInstanceRetentionSettings {
  ChannelRetentionSettings?: ChannelRetentionSettings;
}
export interface AppInstanceStreamingConfiguration {
  AppInstanceDataType: AppInstanceDataType | string | undefined;
  ResourceArn: string | undefined;
}
export interface AppInstanceUser {
  AppInstanceUserArn?: string;
  Name?: string;
  CreatedTimestamp?: Date;
  Metadata?: string;
  LastUpdatedTimestamp?: Date;
}
export interface AppInstanceUserSummary {
  AppInstanceUserArn?: string;
  Name?: string;
  Metadata?: string;
}
export declare enum ChannelMembershipType {
  DEFAULT = "DEFAULT",
  HIDDEN = "HIDDEN",
}
export interface AppInstanceUserMembershipSummary {
  Type?: ChannelMembershipType | string;
  ReadMarkerTimestamp?: Date;
}
export declare enum AudioMuxType {
  AudioOnly = "AudioOnly",
  AudioWithActiveSpeakerVideo = "AudioWithActiveSpeakerVideo",
}
export interface AudioArtifactsConfiguration {
  MuxType: AudioMuxType | string | undefined;
}
export declare enum ContentMuxType {
  ContentOnly = "ContentOnly",
}
export declare enum ArtifactsState {
  Disabled = "Disabled",
  Enabled = "Enabled",
}
export interface ContentArtifactsConfiguration {
  State: ArtifactsState | string | undefined;
  MuxType?: ContentMuxType | string;
}
export declare enum VideoMuxType {
  VideoOnly = "VideoOnly",
}
export interface VideoArtifactsConfiguration {
  State: ArtifactsState | string | undefined;
  MuxType?: VideoMuxType | string;
}
export interface ArtifactsConfiguration {
  Audio: AudioArtifactsConfiguration | undefined;
  Video: VideoArtifactsConfiguration | undefined;
  Content: ContentArtifactsConfiguration | undefined;
}
export interface AssociatePhoneNumbersWithVoiceConnectorRequest {
  VoiceConnectorId: string | undefined;
  E164PhoneNumbers: string[] | undefined;
  ForceAssociate?: boolean;
}
export interface PhoneNumberError {
  PhoneNumberId?: string;
  ErrorCode?: ErrorCode | string;
  ErrorMessage?: string;
}
export interface AssociatePhoneNumbersWithVoiceConnectorResponse {
  PhoneNumberErrors?: PhoneNumberError[];
}
export declare class BadRequestException extends __BaseException {
  readonly name: "BadRequestException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<BadRequestException, __BaseException>
  );
}
export declare class ForbiddenException extends __BaseException {
  readonly name: "ForbiddenException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(opts: __ExceptionOptionType<ForbiddenException, __BaseException>);
}
export declare class NotFoundException extends __BaseException {
  readonly name: "NotFoundException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(opts: __ExceptionOptionType<NotFoundException, __BaseException>);
}
export declare class ServiceFailureException extends __BaseException {
  readonly name: "ServiceFailureException";
  readonly $fault: "server";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ServiceFailureException, __BaseException>
  );
}
export declare class ServiceUnavailableException extends __BaseException {
  readonly name: "ServiceUnavailableException";
  readonly $fault: "server";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ServiceUnavailableException, __BaseException>
  );
}
export declare class ThrottledClientException extends __BaseException {
  readonly name: "ThrottledClientException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ThrottledClientException, __BaseException>
  );
}
export declare class UnauthorizedClientException extends __BaseException {
  readonly name: "UnauthorizedClientException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<UnauthorizedClientException, __BaseException>
  );
}
export interface AssociatePhoneNumbersWithVoiceConnectorGroupRequest {
  VoiceConnectorGroupId: string | undefined;
  E164PhoneNumbers: string[] | undefined;
  ForceAssociate?: boolean;
}
export interface AssociatePhoneNumbersWithVoiceConnectorGroupResponse {
  PhoneNumberErrors?: PhoneNumberError[];
}
export interface AssociatePhoneNumberWithUserRequest {
  AccountId: string | undefined;
  UserId: string | undefined;
  E164PhoneNumber: string | undefined;
}
export interface AssociatePhoneNumberWithUserResponse {}
export interface AssociateSigninDelegateGroupsWithAccountRequest {
  AccountId: string | undefined;
  SigninDelegateGroups: SigninDelegateGroup[] | undefined;
}
export interface AssociateSigninDelegateGroupsWithAccountResponse {}
export interface Attendee {
  ExternalUserId?: string;
  AttendeeId?: string;
  JoinToken?: string;
}
export interface Tag {
  Key: string | undefined;
  Value: string | undefined;
}
export interface BatchChannelMemberships {
  InvitedBy?: Identity;
  Type?: ChannelMembershipType | string;
  Members?: Identity[];
  ChannelArn?: string;
}
export interface CreateAttendeeRequestItem {
  ExternalUserId: string | undefined;
  Tags?: Tag[];
}
export interface BatchCreateAttendeeRequest {
  MeetingId: string | undefined;
  Attendees: CreateAttendeeRequestItem[] | undefined;
}
export interface CreateAttendeeError {
  ExternalUserId?: string;
  ErrorCode?: string;
  ErrorMessage?: string;
}
export interface BatchCreateAttendeeResponse {
  Attendees?: Attendee[];
  Errors?: CreateAttendeeError[];
}
export declare class ResourceLimitExceededException extends __BaseException {
  readonly name: "ResourceLimitExceededException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ResourceLimitExceededException, __BaseException>
  );
}
export interface BatchCreateChannelMembershipRequest {
  ChannelArn: string | undefined;
  Type?: ChannelMembershipType | string;
  MemberArns: string[] | undefined;
  ChimeBearer?: string;
}
export interface BatchCreateChannelMembershipError {
  MemberArn?: string;
  ErrorCode?: ErrorCode | string;
  ErrorMessage?: string;
}
export interface BatchCreateChannelMembershipResponse {
  BatchChannelMemberships?: BatchChannelMemberships;
  Errors?: BatchCreateChannelMembershipError[];
}
export declare enum RoomMembershipRole {
  Administrator = "Administrator",
  Member = "Member",
}
export interface MembershipItem {
  MemberId?: string;
  Role?: RoomMembershipRole | string;
}
export interface BatchCreateRoomMembershipRequest {
  AccountId: string | undefined;
  RoomId: string | undefined;
  MembershipItemList: MembershipItem[] | undefined;
}
export interface MemberError {
  MemberId?: string;
  ErrorCode?: ErrorCode | string;
  ErrorMessage?: string;
}
export interface BatchCreateRoomMembershipResponse {
  Errors?: MemberError[];
}
export interface BatchDeletePhoneNumberRequest {
  PhoneNumberIds: string[] | undefined;
}
export interface BatchDeletePhoneNumberResponse {
  PhoneNumberErrors?: PhoneNumberError[];
}
export interface BatchSuspendUserRequest {
  AccountId: string | undefined;
  UserIdList: string[] | undefined;
}
export interface UserError {
  UserId?: string;
  ErrorCode?: ErrorCode | string;
  ErrorMessage?: string;
}
export interface BatchSuspendUserResponse {
  UserErrors?: UserError[];
}
export interface BatchUnsuspendUserRequest {
  AccountId: string | undefined;
  UserIdList: string[] | undefined;
}
export interface BatchUnsuspendUserResponse {
  UserErrors?: UserError[];
}
export declare enum PhoneNumberProductType {
  BusinessCalling = "BusinessCalling",
  SipMediaApplicationDialIn = "SipMediaApplicationDialIn",
  VoiceConnector = "VoiceConnector",
}
export interface UpdatePhoneNumberRequestItem {
  PhoneNumberId: string | undefined;
  ProductType?: PhoneNumberProductType | string;
  CallingName?: string;
}
export interface BatchUpdatePhoneNumberRequest {
  UpdatePhoneNumberRequestItems: UpdatePhoneNumberRequestItem[] | undefined;
}
export interface BatchUpdatePhoneNumberResponse {
  PhoneNumberErrors?: PhoneNumberError[];
}
export declare enum UserType {
  PrivateUser = "PrivateUser",
  SharedDevice = "SharedDevice",
}
export interface UpdateUserRequestItem {
  UserId: string | undefined;
  LicenseType?: License | string;
  UserType?: UserType | string;
  AlexaForBusinessMetadata?: AlexaForBusinessMetadata;
}
export interface BatchUpdateUserRequest {
  AccountId: string | undefined;
  UpdateUserRequestItems: UpdateUserRequestItem[] | undefined;
}
export interface BatchUpdateUserResponse {
  UserErrors?: UserError[];
}
export declare enum BotType {
  ChatBot = "ChatBot",
}
export interface Bot {
  BotId?: string;
  UserId?: string;
  DisplayName?: string;
  BotType?: BotType | string;
  Disabled?: boolean;
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
  BotEmail?: string;
  SecurityToken?: string;
}
export interface BusinessCallingSettings {
  CdrBucket?: string;
}
export declare enum CallingNameStatus {
  Unassigned = "Unassigned",
  UpdateFailed = "UpdateFailed",
  UpdateInProgress = "UpdateInProgress",
  UpdateSucceeded = "UpdateSucceeded",
}
export interface CandidateAddress {
  streetInfo?: string;
  streetNumber?: string;
  city?: string;
  state?: string;
  postalCode?: string;
  postalCodePlus4?: string;
  country?: string;
}
export declare enum Capability {
  SMS = "SMS",
  Voice = "Voice",
}
export declare enum ChannelMode {
  RESTRICTED = "RESTRICTED",
  UNRESTRICTED = "UNRESTRICTED",
}
export declare enum ChannelPrivacy {
  PRIVATE = "PRIVATE",
  PUBLIC = "PUBLIC",
}
export interface Channel {
  Name?: string;
  ChannelArn?: string;
  Mode?: ChannelMode | string;
  Privacy?: ChannelPrivacy | string;
  Metadata?: string;
  CreatedBy?: Identity;
  CreatedTimestamp?: Date;
  LastMessageTimestamp?: Date;
  LastUpdatedTimestamp?: Date;
}
export interface ChannelBan {
  Member?: Identity;
  ChannelArn?: string;
  CreatedTimestamp?: Date;
  CreatedBy?: Identity;
}
export interface ChannelBanSummary {
  Member?: Identity;
}
export interface ChannelMembership {
  InvitedBy?: Identity;
  Type?: ChannelMembershipType | string;
  Member?: Identity;
  ChannelArn?: string;
  CreatedTimestamp?: Date;
  LastUpdatedTimestamp?: Date;
}
export interface ChannelSummary {
  Name?: string;
  ChannelArn?: string;
  Mode?: ChannelMode | string;
  Privacy?: ChannelPrivacy | string;
  Metadata?: string;
  LastMessageTimestamp?: Date;
}
export interface ChannelMembershipForAppInstanceUserSummary {
  ChannelSummary?: ChannelSummary;
  AppInstanceUserMembershipSummary?: AppInstanceUserMembershipSummary;
}
export interface ChannelMembershipSummary {
  Member?: Identity;
}
export declare enum ChannelMessagePersistenceType {
  NON_PERSISTENT = "NON_PERSISTENT",
  PERSISTENT = "PERSISTENT",
}
export declare enum ChannelMessageType {
  CONTROL = "CONTROL",
  STANDARD = "STANDARD",
}
export interface ChannelMessage {
  ChannelArn?: string;
  MessageId?: string;
  Content?: string;
  Metadata?: string;
  Type?: ChannelMessageType | string;
  CreatedTimestamp?: Date;
  LastEditedTimestamp?: Date;
  LastUpdatedTimestamp?: Date;
  Sender?: Identity;
  Redacted?: boolean;
  Persistence?: ChannelMessagePersistenceType | string;
}
export interface ChannelMessageSummary {
  MessageId?: string;
  Content?: string;
  Metadata?: string;
  Type?: ChannelMessageType | string;
  CreatedTimestamp?: Date;
  LastUpdatedTimestamp?: Date;
  LastEditedTimestamp?: Date;
  Sender?: Identity;
  Redacted?: boolean;
}
export interface ChannelModeratedByAppInstanceUserSummary {
  ChannelSummary?: ChannelSummary;
}
export interface ChannelModerator {
  Moderator?: Identity;
  ChannelArn?: string;
  CreatedTimestamp?: Date;
  CreatedBy?: Identity;
}
export interface ChannelModeratorSummary {
  Moderator?: Identity;
}
export interface SelectedVideoStreams {
  AttendeeIds?: string[];
  ExternalUserIds?: string[];
}
export interface SourceConfiguration {
  SelectedVideoStreams?: SelectedVideoStreams;
}
export interface ChimeSdkMeetingConfiguration {
  SourceConfiguration?: SourceConfiguration;
  ArtifactsConfiguration?: ArtifactsConfiguration;
}
export declare class ConflictException extends __BaseException {
  readonly name: "ConflictException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(opts: __ExceptionOptionType<ConflictException, __BaseException>);
}
export interface ConversationRetentionSettings {
  RetentionDays?: number;
}
export interface CreateAccountRequest {
  Name: string | undefined;
}
export interface CreateAccountResponse {
  Account?: Account;
}
export interface CreateAppInstanceRequest {
  Name: string | undefined;
  Metadata?: string;
  ClientRequestToken?: string;
  Tags?: Tag[];
}
export interface CreateAppInstanceResponse {
  AppInstanceArn?: string;
}
export interface CreateAppInstanceAdminRequest {
  AppInstanceAdminArn: string | undefined;
  AppInstanceArn: string | undefined;
}
export interface CreateAppInstanceAdminResponse {
  AppInstanceAdmin?: Identity;
  AppInstanceArn?: string;
}
export interface CreateAppInstanceUserRequest {
  AppInstanceArn: string | undefined;
  AppInstanceUserId: string | undefined;
  Name: string | undefined;
  Metadata?: string;
  ClientRequestToken?: string;
  Tags?: Tag[];
}
export interface CreateAppInstanceUserResponse {
  AppInstanceUserArn?: string;
}
export interface CreateAttendeeRequest {
  MeetingId: string | undefined;
  ExternalUserId: string | undefined;
  Tags?: Tag[];
}
export interface CreateAttendeeResponse {
  Attendee?: Attendee;
}
export interface CreateBotRequest {
  AccountId: string | undefined;
  DisplayName: string | undefined;
  Domain?: string;
}
export interface CreateBotResponse {
  Bot?: Bot;
}
export interface CreateChannelRequest {
  AppInstanceArn: string | undefined;
  Name: string | undefined;
  Mode?: ChannelMode | string;
  Privacy?: ChannelPrivacy | string;
  Metadata?: string;
  ClientRequestToken?: string;
  Tags?: Tag[];
  ChimeBearer?: string;
}
export interface CreateChannelResponse {
  ChannelArn?: string;
}
export interface CreateChannelBanRequest {
  ChannelArn: string | undefined;
  MemberArn: string | undefined;
  ChimeBearer?: string;
}
export interface CreateChannelBanResponse {
  ChannelArn?: string;
  Member?: Identity;
}
export interface CreateChannelMembershipRequest {
  ChannelArn: string | undefined;
  MemberArn: string | undefined;
  Type: ChannelMembershipType | string | undefined;
  ChimeBearer?: string;
}
export interface CreateChannelMembershipResponse {
  ChannelArn?: string;
  Member?: Identity;
}
export interface CreateChannelModeratorRequest {
  ChannelArn: string | undefined;
  ChannelModeratorArn: string | undefined;
  ChimeBearer?: string;
}
export interface CreateChannelModeratorResponse {
  ChannelArn?: string;
  ChannelModerator?: Identity;
}
export declare enum MediaPipelineSinkType {
  S3Bucket = "S3Bucket",
}
export declare enum MediaPipelineSourceType {
  ChimeSdkMeeting = "ChimeSdkMeeting",
}
export interface CreateMediaCapturePipelineRequest {
  SourceType: MediaPipelineSourceType | string | undefined;
  SourceArn: string | undefined;
  SinkType: MediaPipelineSinkType | string | undefined;
  SinkArn: string | undefined;
  ClientRequestToken?: string;
  ChimeSdkMeetingConfiguration?: ChimeSdkMeetingConfiguration;
}
export declare enum MediaPipelineStatus {
  Failed = "Failed",
  InProgress = "InProgress",
  Initializing = "Initializing",
  Stopped = "Stopped",
  Stopping = "Stopping",
}
export interface MediaCapturePipeline {
  MediaPipelineId?: string;
  SourceType?: MediaPipelineSourceType | string;
  SourceArn?: string;
  Status?: MediaPipelineStatus | string;
  SinkType?: MediaPipelineSinkType | string;
  SinkArn?: string;
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
  ChimeSdkMeetingConfiguration?: ChimeSdkMeetingConfiguration;
}
export interface CreateMediaCapturePipelineResponse {
  MediaCapturePipeline?: MediaCapturePipeline;
}
export interface MeetingNotificationConfiguration {
  SnsTopicArn?: string;
  SqsQueueArn?: string;
}
export interface CreateMeetingRequest {
  ClientRequestToken?: string;
  ExternalMeetingId?: string;
  MeetingHostId?: string;
  MediaRegion?: string;
  Tags?: Tag[];
  NotificationsConfiguration?: MeetingNotificationConfiguration;
}
export interface MediaPlacement {
  AudioHostUrl?: string;
  AudioFallbackUrl?: string;
  ScreenDataUrl?: string;
  ScreenSharingUrl?: string;
  ScreenViewingUrl?: string;
  SignalingUrl?: string;
  TurnControlUrl?: string;
  EventIngestionUrl?: string;
}
export interface Meeting {
  MeetingId?: string;
  ExternalMeetingId?: string;
  MediaPlacement?: MediaPlacement;
  MediaRegion?: string;
}
export interface CreateMeetingResponse {
  Meeting?: Meeting;
}
export interface CreateMeetingDialOutRequest {
  MeetingId: string | undefined;
  FromPhoneNumber: string | undefined;
  ToPhoneNumber: string | undefined;
  JoinToken: string | undefined;
}
export interface CreateMeetingDialOutResponse {
  TransactionId?: string;
}
export interface CreateMeetingWithAttendeesRequest {
  ClientRequestToken?: string;
  ExternalMeetingId?: string;
  MeetingHostId?: string;
  MediaRegion?: string;
  Tags?: Tag[];
  NotificationsConfiguration?: MeetingNotificationConfiguration;
  Attendees?: CreateAttendeeRequestItem[];
}
export interface CreateMeetingWithAttendeesResponse {
  Meeting?: Meeting;
  Attendees?: Attendee[];
  Errors?: CreateAttendeeError[];
}
export interface CreatePhoneNumberOrderRequest {
  ProductType: PhoneNumberProductType | string | undefined;
  E164PhoneNumbers: string[] | undefined;
}
export declare enum OrderedPhoneNumberStatus {
  Acquired = "Acquired",
  Failed = "Failed",
  Processing = "Processing",
}
export interface OrderedPhoneNumber {
  E164PhoneNumber?: string;
  Status?: OrderedPhoneNumberStatus | string;
}
export declare enum PhoneNumberOrderStatus {
  Failed = "Failed",
  Partial = "Partial",
  Processing = "Processing",
  Successful = "Successful",
}
export interface PhoneNumberOrder {
  PhoneNumberOrderId?: string;
  ProductType?: PhoneNumberProductType | string;
  Status?: PhoneNumberOrderStatus | string;
  OrderedPhoneNumbers?: OrderedPhoneNumber[];
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
}
export interface CreatePhoneNumberOrderResponse {
  PhoneNumberOrder?: PhoneNumberOrder;
}
export declare enum GeoMatchLevel {
  AreaCode = "AreaCode",
  Country = "Country",
}
export interface GeoMatchParams {
  Country: string | undefined;
  AreaCode: string | undefined;
}
export declare enum NumberSelectionBehavior {
  AvoidSticky = "AvoidSticky",
  PreferSticky = "PreferSticky",
}
export interface CreateProxySessionRequest {
  VoiceConnectorId: string | undefined;
  ParticipantPhoneNumbers: string[] | undefined;
  Name?: string;
  ExpiryMinutes?: number;
  Capabilities: (Capability | string)[] | undefined;
  NumberSelectionBehavior?: NumberSelectionBehavior | string;
  GeoMatchLevel?: GeoMatchLevel | string;
  GeoMatchParams?: GeoMatchParams;
}
export interface Participant {
  PhoneNumber?: string;
  ProxyPhoneNumber?: string;
}
export declare enum ProxySessionStatus {
  Closed = "Closed",
  InProgress = "InProgress",
  Open = "Open",
}
export interface ProxySession {
  VoiceConnectorId?: string;
  ProxySessionId?: string;
  Name?: string;
  Status?: ProxySessionStatus | string;
  ExpiryMinutes?: number;
  Capabilities?: (Capability | string)[];
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
  EndedTimestamp?: Date;
  Participants?: Participant[];
  NumberSelectionBehavior?: NumberSelectionBehavior | string;
  GeoMatchLevel?: GeoMatchLevel | string;
  GeoMatchParams?: GeoMatchParams;
}
export interface CreateProxySessionResponse {
  ProxySession?: ProxySession;
}
export interface CreateRoomRequest {
  AccountId: string | undefined;
  Name: string | undefined;
  ClientRequestToken?: string;
}
export interface Room {
  RoomId?: string;
  Name?: string;
  AccountId?: string;
  CreatedBy?: string;
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
}
export interface CreateRoomResponse {
  Room?: Room;
}
export interface CreateRoomMembershipRequest {
  AccountId: string | undefined;
  RoomId: string | undefined;
  MemberId: string | undefined;
  Role?: RoomMembershipRole | string;
}
export declare enum MemberType {
  Bot = "Bot",
  User = "User",
  Webhook = "Webhook",
}
export interface Member {
  MemberId?: string;
  MemberType?: MemberType | string;
  Email?: string;
  FullName?: string;
  AccountId?: string;
}
export interface RoomMembership {
  RoomId?: string;
  Member?: Member;
  Role?: RoomMembershipRole | string;
  InvitedBy?: string;
  UpdatedTimestamp?: Date;
}
export interface CreateRoomMembershipResponse {
  RoomMembership?: RoomMembership;
}
export interface SipMediaApplicationEndpoint {
  LambdaArn?: string;
}
export interface CreateSipMediaApplicationRequest {
  AwsRegion: string | undefined;
  Name: string | undefined;
  Endpoints: SipMediaApplicationEndpoint[] | undefined;
}
export interface SipMediaApplication {
  SipMediaApplicationId?: string;
  AwsRegion?: string;
  Name?: string;
  Endpoints?: SipMediaApplicationEndpoint[];
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
}
export interface CreateSipMediaApplicationResponse {
  SipMediaApplication?: SipMediaApplication;
}
export interface CreateSipMediaApplicationCallRequest {
  FromPhoneNumber: string | undefined;
  ToPhoneNumber: string | undefined;
  SipMediaApplicationId: string | undefined;
  SipHeaders?: Record<string, string>;
}
export interface SipMediaApplicationCall {
  TransactionId?: string;
}
export interface CreateSipMediaApplicationCallResponse {
  SipMediaApplicationCall?: SipMediaApplicationCall;
}
export interface SipRuleTargetApplication {
  SipMediaApplicationId?: string;
  Priority?: number;
  AwsRegion?: string;
}
export declare enum SipRuleTriggerType {
  RequestUriHostname = "RequestUriHostname",
  ToPhoneNumber = "ToPhoneNumber",
}
export interface CreateSipRuleRequest {
  Name: string | undefined;
  TriggerType: SipRuleTriggerType | string | undefined;
  TriggerValue: string | undefined;
  Disabled?: boolean;
  TargetApplications: SipRuleTargetApplication[] | undefined;
}
export interface SipRule {
  SipRuleId?: string;
  Name?: string;
  Disabled?: boolean;
  TriggerType?: SipRuleTriggerType | string;
  TriggerValue?: string;
  TargetApplications?: SipRuleTargetApplication[];
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
}
export interface CreateSipRuleResponse {
  SipRule?: SipRule;
}
export interface CreateUserRequest {
  AccountId: string | undefined;
  Username?: string;
  Email?: string;
  UserType?: UserType | string;
}
export declare enum InviteStatus {
  Accepted = "Accepted",
  Failed = "Failed",
  Pending = "Pending",
}
export declare enum RegistrationStatus {
  Registered = "Registered",
  Suspended = "Suspended",
  Unregistered = "Unregistered",
}
export interface User {
  UserId: string | undefined;
  AccountId?: string;
  PrimaryEmail?: string;
  PrimaryProvisionedNumber?: string;
  DisplayName?: string;
  LicenseType?: License | string;
  UserType?: UserType | string;
  UserRegistrationStatus?: RegistrationStatus | string;
  UserInvitationStatus?: InviteStatus | string;
  RegisteredOn?: Date;
  InvitedOn?: Date;
  AlexaForBusinessMetadata?: AlexaForBusinessMetadata;
  PersonalPIN?: string;
}
export interface CreateUserResponse {
  User?: User;
}
export declare enum VoiceConnectorAwsRegion {
  US_EAST_1 = "us-east-1",
  US_WEST_2 = "us-west-2",
}
export interface CreateVoiceConnectorRequest {
  Name: string | undefined;
  AwsRegion?: VoiceConnectorAwsRegion | string;
  RequireEncryption: boolean | undefined;
}
export interface VoiceConnector {
  VoiceConnectorId?: string;
  AwsRegion?: VoiceConnectorAwsRegion | string;
  Name?: string;
  OutboundHostName?: string;
  RequireEncryption?: boolean;
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
  VoiceConnectorArn?: string;
}
export interface CreateVoiceConnectorResponse {
  VoiceConnector?: VoiceConnector;
}
export interface VoiceConnectorItem {
  VoiceConnectorId: string | undefined;
  Priority: number | undefined;
}
export interface CreateVoiceConnectorGroupRequest {
  Name: string | undefined;
  VoiceConnectorItems?: VoiceConnectorItem[];
}
export interface VoiceConnectorGroup {
  VoiceConnectorGroupId?: string;
  Name?: string;
  VoiceConnectorItems?: VoiceConnectorItem[];
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
  VoiceConnectorGroupArn?: string;
}
export interface CreateVoiceConnectorGroupResponse {
  VoiceConnectorGroup?: VoiceConnectorGroup;
}
export interface Credential {
  Username?: string;
  Password?: string;
}
export interface DeleteAccountRequest {
  AccountId: string | undefined;
}
export interface DeleteAccountResponse {}
export declare class UnprocessableEntityException extends __BaseException {
  readonly name: "UnprocessableEntityException";
  readonly $fault: "client";
  Code?: ErrorCode | string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<UnprocessableEntityException, __BaseException>
  );
}
export interface DeleteAppInstanceRequest {
  AppInstanceArn: string | undefined;
}
export interface DeleteAppInstanceAdminRequest {
  AppInstanceAdminArn: string | undefined;
  AppInstanceArn: string | undefined;
}
export interface DeleteAppInstanceStreamingConfigurationsRequest {
  AppInstanceArn: string | undefined;
}
export interface DeleteAppInstanceUserRequest {
  AppInstanceUserArn: string | undefined;
}
export interface DeleteAttendeeRequest {
  MeetingId: string | undefined;
  AttendeeId: string | undefined;
}
export interface DeleteChannelRequest {
  ChannelArn: string | undefined;
  ChimeBearer?: string;
}
export interface DeleteChannelBanRequest {
  ChannelArn: string | undefined;
  MemberArn: string | undefined;
  ChimeBearer?: string;
}
export interface DeleteChannelMembershipRequest {
  ChannelArn: string | undefined;
  MemberArn: string | undefined;
  ChimeBearer?: string;
}
export interface DeleteChannelMessageRequest {
  ChannelArn: string | undefined;
  MessageId: string | undefined;
  ChimeBearer?: string;
}
export interface DeleteChannelModeratorRequest {
  ChannelArn: string | undefined;
  ChannelModeratorArn: string | undefined;
  ChimeBearer?: string;
}
export interface DeleteEventsConfigurationRequest {
  AccountId: string | undefined;
  BotId: string | undefined;
}
export interface DeleteMediaCapturePipelineRequest {
  MediaPipelineId: string | undefined;
}
export interface DeleteMeetingRequest {
  MeetingId: string | undefined;
}
export interface DeletePhoneNumberRequest {
  PhoneNumberId: string | undefined;
}
export interface DeleteProxySessionRequest {
  VoiceConnectorId: string | undefined;
  ProxySessionId: string | undefined;
}
export interface DeleteRoomRequest {
  AccountId: string | undefined;
  RoomId: string | undefined;
}
export interface DeleteRoomMembershipRequest {
  AccountId: string | undefined;
  RoomId: string | undefined;
  MemberId: string | undefined;
}
export interface DeleteSipMediaApplicationRequest {
  SipMediaApplicationId: string | undefined;
}
export interface DeleteSipRuleRequest {
  SipRuleId: string | undefined;
}
export interface DeleteVoiceConnectorRequest {
  VoiceConnectorId: string | undefined;
}
export interface DeleteVoiceConnectorEmergencyCallingConfigurationRequest {
  VoiceConnectorId: string | undefined;
}
export interface DeleteVoiceConnectorGroupRequest {
  VoiceConnectorGroupId: string | undefined;
}
export interface DeleteVoiceConnectorOriginationRequest {
  VoiceConnectorId: string | undefined;
}
export interface DeleteVoiceConnectorProxyRequest {
  VoiceConnectorId: string | undefined;
}
export interface DeleteVoiceConnectorStreamingConfigurationRequest {
  VoiceConnectorId: string | undefined;
}
export interface DeleteVoiceConnectorTerminationRequest {
  VoiceConnectorId: string | undefined;
}
export interface DeleteVoiceConnectorTerminationCredentialsRequest {
  VoiceConnectorId: string | undefined;
  Usernames: string[] | undefined;
}
export interface DescribeAppInstanceRequest {
  AppInstanceArn: string | undefined;
}
export interface DescribeAppInstanceResponse {
  AppInstance?: AppInstance;
}
export interface DescribeAppInstanceAdminRequest {
  AppInstanceAdminArn: string | undefined;
  AppInstanceArn: string | undefined;
}
export interface DescribeAppInstanceAdminResponse {
  AppInstanceAdmin?: AppInstanceAdmin;
}
export interface DescribeAppInstanceUserRequest {
  AppInstanceUserArn: string | undefined;
}
export interface DescribeAppInstanceUserResponse {
  AppInstanceUser?: AppInstanceUser;
}
export interface DescribeChannelRequest {
  ChannelArn: string | undefined;
  ChimeBearer?: string;
}
export interface DescribeChannelResponse {
  Channel?: Channel;
}
export interface DescribeChannelBanRequest {
  ChannelArn: string | undefined;
  MemberArn: string | undefined;
  ChimeBearer?: string;
}
export interface DescribeChannelBanResponse {
  ChannelBan?: ChannelBan;
}
export interface DescribeChannelMembershipRequest {
  ChannelArn: string | undefined;
  MemberArn: string | undefined;
  ChimeBearer?: string;
}
export interface DescribeChannelMembershipResponse {
  ChannelMembership?: ChannelMembership;
}
export interface DescribeChannelMembershipForAppInstanceUserRequest {
  ChannelArn: string | undefined;
  AppInstanceUserArn: string | undefined;
  ChimeBearer?: string;
}
export interface DescribeChannelMembershipForAppInstanceUserResponse {
  ChannelMembership?: ChannelMembershipForAppInstanceUserSummary;
}
export interface DescribeChannelModeratedByAppInstanceUserRequest {
  ChannelArn: string | undefined;
  AppInstanceUserArn: string | undefined;
  ChimeBearer?: string;
}
export interface DescribeChannelModeratedByAppInstanceUserResponse {
  Channel?: ChannelModeratedByAppInstanceUserSummary;
}
export interface DescribeChannelModeratorRequest {
  ChannelArn: string | undefined;
  ChannelModeratorArn: string | undefined;
  ChimeBearer?: string;
}
export interface DescribeChannelModeratorResponse {
  ChannelModerator?: ChannelModerator;
}
export interface DisassociatePhoneNumberFromUserRequest {
  AccountId: string | undefined;
  UserId: string | undefined;
}
export interface DisassociatePhoneNumberFromUserResponse {}
export interface DisassociatePhoneNumbersFromVoiceConnectorRequest {
  VoiceConnectorId: string | undefined;
  E164PhoneNumbers: string[] | undefined;
}
export interface DisassociatePhoneNumbersFromVoiceConnectorResponse {
  PhoneNumberErrors?: PhoneNumberError[];
}
export interface DisassociatePhoneNumbersFromVoiceConnectorGroupRequest {
  VoiceConnectorGroupId: string | undefined;
  E164PhoneNumbers: string[] | undefined;
}
export interface DisassociatePhoneNumbersFromVoiceConnectorGroupResponse {
  PhoneNumberErrors?: PhoneNumberError[];
}
export interface DisassociateSigninDelegateGroupsFromAccountRequest {
  AccountId: string | undefined;
  GroupNames: string[] | undefined;
}
export interface DisassociateSigninDelegateGroupsFromAccountResponse {}
export interface DNISEmergencyCallingConfiguration {
  EmergencyPhoneNumber: string | undefined;
  TestPhoneNumber?: string;
  CallingCountry: string | undefined;
}
export declare enum EmailStatus {
  Failed = "Failed",
  NotSent = "NotSent",
  Sent = "Sent",
}
export interface EmergencyCallingConfiguration {
  DNIS?: DNISEmergencyCallingConfiguration[];
}
export declare enum TranscribeMedicalContentIdentificationType {
  PHI = "PHI",
}
export declare enum TranscribeMedicalLanguageCode {
  EN_US = "en-US",
}
export declare enum TranscribeMedicalRegion {
  AP_SOUTHEAST_2 = "ap-southeast-2",
  AUTO = "auto",
  CA_CENTRAL_1 = "ca-central-1",
  EU_WEST_1 = "eu-west-1",
  US_EAST_1 = "us-east-1",
  US_EAST_2 = "us-east-2",
  US_WEST_2 = "us-west-2",
}
export declare enum TranscribeMedicalSpecialty {
  Cardiology = "CARDIOLOGY",
  Neurology = "NEUROLOGY",
  Oncology = "ONCOLOGY",
  PrimaryCare = "PRIMARYCARE",
  Radiology = "RADIOLOGY",
  Urology = "UROLOGY",
}
export declare enum TranscribeMedicalType {
  Conversation = "CONVERSATION",
  Dictation = "DICTATION",
}
export interface EngineTranscribeMedicalSettings {
  LanguageCode: TranscribeMedicalLanguageCode | string | undefined;
  Specialty: TranscribeMedicalSpecialty | string | undefined;
  Type: TranscribeMedicalType | string | undefined;
  VocabularyName?: string;
  Region?: TranscribeMedicalRegion | string;
  ContentIdentificationType?:
    | TranscribeMedicalContentIdentificationType
    | string;
}
export declare enum TranscribeContentIdentificationType {
  PII = "PII",
}
export declare enum TranscribeContentRedactionType {
  PII = "PII",
}
export declare enum TranscribeLanguageCode {
  DE_DE = "de-DE",
  EN_AU = "en-AU",
  EN_GB = "en-GB",
  EN_US = "en-US",
  ES_US = "es-US",
  FR_CA = "fr-CA",
  FR_FR = "fr-FR",
  IT_IT = "it-IT",
  JA_JP = "ja-JP",
  KO_KR = "ko-KR",
  PT_BR = "pt-BR",
  ZH_CN = "zh-CN",
}
export declare enum TranscribePartialResultsStability {
  HIGH = "high",
  LOW = "low",
  MEDIUM = "medium",
}
export declare enum TranscribeRegion {
  AP_NORTHEAST_1 = "ap-northeast-1",
  AP_NORTHEAST_2 = "ap-northeast-2",
  AP_SOUTHEAST_2 = "ap-southeast-2",
  AUTO = "auto",
  CA_CENTRAL_1 = "ca-central-1",
  EU_CENTRAL_1 = "eu-central-1",
  EU_WEST_1 = "eu-west-1",
  EU_WEST_2 = "eu-west-2",
  SA_EAST_1 = "sa-east-1",
  US_EAST_1 = "us-east-1",
  US_EAST_2 = "us-east-2",
  US_WEST_2 = "us-west-2",
}
export declare enum TranscribeVocabularyFilterMethod {
  Mask = "mask",
  Remove = "remove",
  Tag = "tag",
}
export interface EngineTranscribeSettings {
  LanguageCode: TranscribeLanguageCode | string | undefined;
  VocabularyFilterMethod?: TranscribeVocabularyFilterMethod | string;
  VocabularyFilterName?: string;
  VocabularyName?: string;
  Region?: TranscribeRegion | string;
  EnablePartialResultsStabilization?: boolean;
  PartialResultsStability?: TranscribePartialResultsStability | string;
  ContentIdentificationType?: TranscribeContentIdentificationType | string;
  ContentRedactionType?: TranscribeContentRedactionType | string;
  PiiEntityTypes?: string;
  LanguageModelName?: string;
}
export interface EventsConfiguration {
  BotId?: string;
  OutboundEventsHTTPSEndpoint?: string;
  LambdaFunctionArn?: string;
}
export interface GetAccountRequest {
  AccountId: string | undefined;
}
export interface GetAccountResponse {
  Account?: Account;
}
export interface GetAccountSettingsRequest {
  AccountId: string | undefined;
}
export interface GetAccountSettingsResponse {
  AccountSettings?: AccountSettings;
}
export interface GetAppInstanceRetentionSettingsRequest {
  AppInstanceArn: string | undefined;
}
export interface GetAppInstanceRetentionSettingsResponse {
  AppInstanceRetentionSettings?: AppInstanceRetentionSettings;
  InitiateDeletionTimestamp?: Date;
}
export interface GetAppInstanceStreamingConfigurationsRequest {
  AppInstanceArn: string | undefined;
}
export interface GetAppInstanceStreamingConfigurationsResponse {
  AppInstanceStreamingConfigurations?: AppInstanceStreamingConfiguration[];
}
export interface GetAttendeeRequest {
  MeetingId: string | undefined;
  AttendeeId: string | undefined;
}
export interface GetAttendeeResponse {
  Attendee?: Attendee;
}
export interface GetBotRequest {
  AccountId: string | undefined;
  BotId: string | undefined;
}
export interface GetBotResponse {
  Bot?: Bot;
}
export interface GetChannelMessageRequest {
  ChannelArn: string | undefined;
  MessageId: string | undefined;
  ChimeBearer?: string;
}
export interface GetChannelMessageResponse {
  ChannelMessage?: ChannelMessage;
}
export interface GetEventsConfigurationRequest {
  AccountId: string | undefined;
  BotId: string | undefined;
}
export interface GetEventsConfigurationResponse {
  EventsConfiguration?: EventsConfiguration;
}
export interface VoiceConnectorSettings {
  CdrBucket?: string;
}
export interface GetGlobalSettingsResponse {
  BusinessCalling?: BusinessCallingSettings;
  VoiceConnector?: VoiceConnectorSettings;
}
export interface GetMediaCapturePipelineRequest {
  MediaPipelineId: string | undefined;
}
export interface GetMediaCapturePipelineResponse {
  MediaCapturePipeline?: MediaCapturePipeline;
}
export interface GetMeetingRequest {
  MeetingId: string | undefined;
}
export interface GetMeetingResponse {
  Meeting?: Meeting;
}
export interface GetMessagingSessionEndpointRequest {}
export interface MessagingSessionEndpoint {
  Url?: string;
}
export interface GetMessagingSessionEndpointResponse {
  Endpoint?: MessagingSessionEndpoint;
}
export interface GetPhoneNumberRequest {
  PhoneNumberId: string | undefined;
}
export declare enum PhoneNumberAssociationName {
  AccountId = "AccountId",
  SipRuleId = "SipRuleId",
  UserId = "UserId",
  VoiceConnectorGroupId = "VoiceConnectorGroupId",
  VoiceConnectorId = "VoiceConnectorId",
}
export interface PhoneNumberAssociation {
  Value?: string;
  Name?: PhoneNumberAssociationName | string;
  AssociatedTimestamp?: Date;
}
export interface PhoneNumberCapabilities {
  InboundCall?: boolean;
  OutboundCall?: boolean;
  InboundSMS?: boolean;
  OutboundSMS?: boolean;
  InboundMMS?: boolean;
  OutboundMMS?: boolean;
}
export declare enum PhoneNumberStatus {
  AcquireFailed = "AcquireFailed",
  AcquireInProgress = "AcquireInProgress",
  Assigned = "Assigned",
  DeleteFailed = "DeleteFailed",
  DeleteInProgress = "DeleteInProgress",
  ReleaseFailed = "ReleaseFailed",
  ReleaseInProgress = "ReleaseInProgress",
  Unassigned = "Unassigned",
}
export declare enum PhoneNumberType {
  Local = "Local",
  TollFree = "TollFree",
}
export interface PhoneNumber {
  PhoneNumberId?: string;
  E164PhoneNumber?: string;
  Country?: string;
  Type?: PhoneNumberType | string;
  ProductType?: PhoneNumberProductType | string;
  Status?: PhoneNumberStatus | string;
  Capabilities?: PhoneNumberCapabilities;
  Associations?: PhoneNumberAssociation[];
  CallingName?: string;
  CallingNameStatus?: CallingNameStatus | string;
  CreatedTimestamp?: Date;
  UpdatedTimestamp?: Date;
  DeletionTimestamp?: Date;
}
export interface GetPhoneNumberResponse {
  PhoneNumber?: PhoneNumber;
}
export interface GetPhoneNumberOrderRequest {
  PhoneNumberOrderId: string | undefined;
}
export interface GetPhoneNumberOrderResponse {
  PhoneNumberOrder?: PhoneNumberOrder;
}
export interface GetPhoneNumberSettingsResponse {
  CallingName?: string;
  CallingNameUpdatedTimestamp?: Date;
}
export interface GetProxySessionRequest {
  VoiceConnectorId: string | undefined;
  ProxySessionId: string | undefined;
}
export interface GetProxySessionResponse {
  ProxySession?: ProxySession;
}
export interface GetRetentionSettingsRequest {
  AccountId: string | undefined;
}
export declare const SigninDelegateGroupFilterSensitiveLog: (
  obj: SigninDelegateGroup
) => any;
export declare const AccountFilterSensitiveLog: (obj: Account) => any;
export declare const AccountSettingsFilterSensitiveLog: (
  obj: AccountSettings
) => any;
export declare const AddressFilterSensitiveLog: (obj: Address) => any;
export declare const AlexaForBusinessMetadataFilterSensitiveLog: (
  obj: AlexaForBusinessMetadata
) => any;
export declare const AppInstanceFilterSensitiveLog: (obj: AppInstance) => any;
export declare const IdentityFilterSensitiveLog: (obj: Identity) => any;
export declare const AppInstanceAdminFilterSensitiveLog: (
  obj: AppInstanceAdmin
) => any;
export declare const AppInstanceAdminSummaryFilterSensitiveLog: (
  obj: AppInstanceAdminSummary
) => any;
export declare const AppInstanceSummaryFilterSensitiveLog: (
  obj: AppInstanceSummary
) => any;
export declare const ChannelRetentionSettingsFilterSensitiveLog: (
  obj: ChannelRetentionSettings
) => any;
export declare const AppInstanceRetentionSettingsFilterSensitiveLog: (
  obj: AppInstanceRetentionSettings
) => any;
export declare const AppInstanceStreamingConfigurationFilterSensitiveLog: (
  obj: AppInstanceStreamingConfiguration
) => any;
export declare const AppInstanceUserFilterSensitiveLog: (
  obj: AppInstanceUser
) => any;
export declare const AppInstanceUserSummaryFilterSensitiveLog: (
  obj: AppInstanceUserSummary
) => any;
export declare const AppInstanceUserMembershipSummaryFilterSensitiveLog: (
  obj: AppInstanceUserMembershipSummary
) => any;
export declare const AudioArtifactsConfigurationFilterSensitiveLog: (
  obj: AudioArtifactsConfiguration
) => any;
export declare const ContentArtifactsConfigurationFilterSensitiveLog: (
  obj: ContentArtifactsConfiguration
) => any;
export declare const VideoArtifactsConfigurationFilterSensitiveLog: (
  obj: VideoArtifactsConfiguration
) => any;
export declare const ArtifactsConfigurationFilterSensitiveLog: (
  obj: ArtifactsConfiguration
) => any;
export declare const AssociatePhoneNumbersWithVoiceConnectorRequestFilterSensitiveLog: (
  obj: AssociatePhoneNumbersWithVoiceConnectorRequest
) => any;
export declare const PhoneNumberErrorFilterSensitiveLog: (
  obj: PhoneNumberError
) => any;
export declare const AssociatePhoneNumbersWithVoiceConnectorResponseFilterSensitiveLog: (
  obj: AssociatePhoneNumbersWithVoiceConnectorResponse
) => any;
export declare const AssociatePhoneNumbersWithVoiceConnectorGroupRequestFilterSensitiveLog: (
  obj: AssociatePhoneNumbersWithVoiceConnectorGroupRequest
) => any;
export declare const AssociatePhoneNumbersWithVoiceConnectorGroupResponseFilterSensitiveLog: (
  obj: AssociatePhoneNumbersWithVoiceConnectorGroupResponse
) => any;
export declare const AssociatePhoneNumberWithUserRequestFilterSensitiveLog: (
  obj: AssociatePhoneNumberWithUserRequest
) => any;
export declare const AssociatePhoneNumberWithUserResponseFilterSensitiveLog: (
  obj: AssociatePhoneNumberWithUserResponse
) => any;
export declare const AssociateSigninDelegateGroupsWithAccountRequestFilterSensitiveLog: (
  obj: AssociateSigninDelegateGroupsWithAccountRequest
) => any;
export declare const AssociateSigninDelegateGroupsWithAccountResponseFilterSensitiveLog: (
  obj: AssociateSigninDelegateGroupsWithAccountResponse
) => any;
export declare const AttendeeFilterSensitiveLog: (obj: Attendee) => any;
export declare const TagFilterSensitiveLog: (obj: Tag) => any;
export declare const BatchChannelMembershipsFilterSensitiveLog: (
  obj: BatchChannelMemberships
) => any;
export declare const CreateAttendeeRequestItemFilterSensitiveLog: (
  obj: CreateAttendeeRequestItem
) => any;
export declare const BatchCreateAttendeeRequestFilterSensitiveLog: (
  obj: BatchCreateAttendeeRequest
) => any;
export declare const CreateAttendeeErrorFilterSensitiveLog: (
  obj: CreateAttendeeError
) => any;
export declare const BatchCreateAttendeeResponseFilterSensitiveLog: (
  obj: BatchCreateAttendeeResponse
) => any;
export declare const BatchCreateChannelMembershipRequestFilterSensitiveLog: (
  obj: BatchCreateChannelMembershipRequest
) => any;
export declare const BatchCreateChannelMembershipErrorFilterSensitiveLog: (
  obj: BatchCreateChannelMembershipError
) => any;
export declare const BatchCreateChannelMembershipResponseFilterSensitiveLog: (
  obj: BatchCreateChannelMembershipResponse
) => any;
export declare const MembershipItemFilterSensitiveLog: (
  obj: MembershipItem
) => any;
export declare const BatchCreateRoomMembershipRequestFilterSensitiveLog: (
  obj: BatchCreateRoomMembershipRequest
) => any;
export declare const MemberErrorFilterSensitiveLog: (obj: MemberError) => any;
export declare const BatchCreateRoomMembershipResponseFilterSensitiveLog: (
  obj: BatchCreateRoomMembershipResponse
) => any;
export declare const BatchDeletePhoneNumberRequestFilterSensitiveLog: (
  obj: BatchDeletePhoneNumberRequest
) => any;
export declare const BatchDeletePhoneNumberResponseFilterSensitiveLog: (
  obj: BatchDeletePhoneNumberResponse
) => any;
export declare const BatchSuspendUserRequestFilterSensitiveLog: (
  obj: BatchSuspendUserRequest
) => any;
export declare const UserErrorFilterSensitiveLog: (obj: UserError) => any;
export declare const BatchSuspendUserResponseFilterSensitiveLog: (
  obj: BatchSuspendUserResponse
) => any;
export declare const BatchUnsuspendUserRequestFilterSensitiveLog: (
  obj: BatchUnsuspendUserRequest
) => any;
export declare const BatchUnsuspendUserResponseFilterSensitiveLog: (
  obj: BatchUnsuspendUserResponse
) => any;
export declare const UpdatePhoneNumberRequestItemFilterSensitiveLog: (
  obj: UpdatePhoneNumberRequestItem
) => any;
export declare const BatchUpdatePhoneNumberRequestFilterSensitiveLog: (
  obj: BatchUpdatePhoneNumberRequest
) => any;
export declare const BatchUpdatePhoneNumberResponseFilterSensitiveLog: (
  obj: BatchUpdatePhoneNumberResponse
) => any;
export declare const UpdateUserRequestItemFilterSensitiveLog: (
  obj: UpdateUserRequestItem
) => any;
export declare const BatchUpdateUserRequestFilterSensitiveLog: (
  obj: BatchUpdateUserRequest
) => any;
export declare const BatchUpdateUserResponseFilterSensitiveLog: (
  obj: BatchUpdateUserResponse
) => any;
export declare const BotFilterSensitiveLog: (obj: Bot) => any;
export declare const BusinessCallingSettingsFilterSensitiveLog: (
  obj: BusinessCallingSettings
) => any;
export declare const CandidateAddressFilterSensitiveLog: (
  obj: CandidateAddress
) => any;
export declare const ChannelFilterSensitiveLog: (obj: Channel) => any;
export declare const ChannelBanFilterSensitiveLog: (obj: ChannelBan) => any;
export declare const ChannelBanSummaryFilterSensitiveLog: (
  obj: ChannelBanSummary
) => any;
export declare const ChannelMembershipFilterSensitiveLog: (
  obj: ChannelMembership
) => any;
export declare const ChannelSummaryFilterSensitiveLog: (
  obj: ChannelSummary
) => any;
export declare const ChannelMembershipForAppInstanceUserSummaryFilterSensitiveLog: (
  obj: ChannelMembershipForAppInstanceUserSummary
) => any;
export declare const ChannelMembershipSummaryFilterSensitiveLog: (
  obj: ChannelMembershipSummary
) => any;
export declare const ChannelMessageFilterSensitiveLog: (
  obj: ChannelMessage
) => any;
export declare const ChannelMessageSummaryFilterSensitiveLog: (
  obj: ChannelMessageSummary
) => any;
export declare const ChannelModeratedByAppInstanceUserSummaryFilterSensitiveLog: (
  obj: ChannelModeratedByAppInstanceUserSummary
) => any;
export declare const ChannelModeratorFilterSensitiveLog: (
  obj: ChannelModerator
) => any;
export declare const ChannelModeratorSummaryFilterSensitiveLog: (
  obj: ChannelModeratorSummary
) => any;
export declare const SelectedVideoStreamsFilterSensitiveLog: (
  obj: SelectedVideoStreams
) => any;
export declare const SourceConfigurationFilterSensitiveLog: (
  obj: SourceConfiguration
) => any;
export declare const ChimeSdkMeetingConfigurationFilterSensitiveLog: (
  obj: ChimeSdkMeetingConfiguration
) => any;
export declare const ConversationRetentionSettingsFilterSensitiveLog: (
  obj: ConversationRetentionSettings
) => any;
export declare const CreateAccountRequestFilterSensitiveLog: (
  obj: CreateAccountRequest
) => any;
export declare const CreateAccountResponseFilterSensitiveLog: (
  obj: CreateAccountResponse
) => any;
export declare const CreateAppInstanceRequestFilterSensitiveLog: (
  obj: CreateAppInstanceRequest
) => any;
export declare const CreateAppInstanceResponseFilterSensitiveLog: (
  obj: CreateAppInstanceResponse
) => any;
export declare const CreateAppInstanceAdminRequestFilterSensitiveLog: (
  obj: CreateAppInstanceAdminRequest
) => any;
export declare const CreateAppInstanceAdminResponseFilterSensitiveLog: (
  obj: CreateAppInstanceAdminResponse
) => any;
export declare const CreateAppInstanceUserRequestFilterSensitiveLog: (
  obj: CreateAppInstanceUserRequest
) => any;
export declare const CreateAppInstanceUserResponseFilterSensitiveLog: (
  obj: CreateAppInstanceUserResponse
) => any;
export declare const CreateAttendeeRequestFilterSensitiveLog: (
  obj: CreateAttendeeRequest
) => any;
export declare const CreateAttendeeResponseFilterSensitiveLog: (
  obj: CreateAttendeeResponse
) => any;
export declare const CreateBotRequestFilterSensitiveLog: (
  obj: CreateBotRequest
) => any;
export declare const CreateBotResponseFilterSensitiveLog: (
  obj: CreateBotResponse
) => any;
export declare const CreateChannelRequestFilterSensitiveLog: (
  obj: CreateChannelRequest
) => any;
export declare const CreateChannelResponseFilterSensitiveLog: (
  obj: CreateChannelResponse
) => any;
export declare const CreateChannelBanRequestFilterSensitiveLog: (
  obj: CreateChannelBanRequest
) => any;
export declare const CreateChannelBanResponseFilterSensitiveLog: (
  obj: CreateChannelBanResponse
) => any;
export declare const CreateChannelMembershipRequestFilterSensitiveLog: (
  obj: CreateChannelMembershipRequest
) => any;
export declare const CreateChannelMembershipResponseFilterSensitiveLog: (
  obj: CreateChannelMembershipResponse
) => any;
export declare const CreateChannelModeratorRequestFilterSensitiveLog: (
  obj: CreateChannelModeratorRequest
) => any;
export declare const CreateChannelModeratorResponseFilterSensitiveLog: (
  obj: CreateChannelModeratorResponse
) => any;
export declare const CreateMediaCapturePipelineRequestFilterSensitiveLog: (
  obj: CreateMediaCapturePipelineRequest
) => any;
export declare const MediaCapturePipelineFilterSensitiveLog: (
  obj: MediaCapturePipeline
) => any;
export declare const CreateMediaCapturePipelineResponseFilterSensitiveLog: (
  obj: CreateMediaCapturePipelineResponse
) => any;
export declare const MeetingNotificationConfigurationFilterSensitiveLog: (
  obj: MeetingNotificationConfiguration
) => any;
export declare const CreateMeetingRequestFilterSensitiveLog: (
  obj: CreateMeetingRequest
) => any;
export declare const MediaPlacementFilterSensitiveLog: (
  obj: MediaPlacement
) => any;
export declare const MeetingFilterSensitiveLog: (obj: Meeting) => any;
export declare const CreateMeetingResponseFilterSensitiveLog: (
  obj: CreateMeetingResponse
) => any;
export declare const CreateMeetingDialOutRequestFilterSensitiveLog: (
  obj: CreateMeetingDialOutRequest
) => any;
export declare const CreateMeetingDialOutResponseFilterSensitiveLog: (
  obj: CreateMeetingDialOutResponse
) => any;
export declare const CreateMeetingWithAttendeesRequestFilterSensitiveLog: (
  obj: CreateMeetingWithAttendeesRequest
) => any;
export declare const CreateMeetingWithAttendeesResponseFilterSensitiveLog: (
  obj: CreateMeetingWithAttendeesResponse
) => any;
export declare const CreatePhoneNumberOrderRequestFilterSensitiveLog: (
  obj: CreatePhoneNumberOrderRequest
) => any;
export declare const OrderedPhoneNumberFilterSensitiveLog: (
  obj: OrderedPhoneNumber
) => any;
export declare const PhoneNumberOrderFilterSensitiveLog: (
  obj: PhoneNumberOrder
) => any;
export declare const CreatePhoneNumberOrderResponseFilterSensitiveLog: (
  obj: CreatePhoneNumberOrderResponse
) => any;
export declare const GeoMatchParamsFilterSensitiveLog: (
  obj: GeoMatchParams
) => any;
export declare const CreateProxySessionRequestFilterSensitiveLog: (
  obj: CreateProxySessionRequest
) => any;
export declare const ParticipantFilterSensitiveLog: (obj: Participant) => any;
export declare const ProxySessionFilterSensitiveLog: (obj: ProxySession) => any;
export declare const CreateProxySessionResponseFilterSensitiveLog: (
  obj: CreateProxySessionResponse
) => any;
export declare const CreateRoomRequestFilterSensitiveLog: (
  obj: CreateRoomRequest
) => any;
export declare const RoomFilterSensitiveLog: (obj: Room) => any;
export declare const CreateRoomResponseFilterSensitiveLog: (
  obj: CreateRoomResponse
) => any;
export declare const CreateRoomMembershipRequestFilterSensitiveLog: (
  obj: CreateRoomMembershipRequest
) => any;
export declare const MemberFilterSensitiveLog: (obj: Member) => any;
export declare const RoomMembershipFilterSensitiveLog: (
  obj: RoomMembership
) => any;
export declare const CreateRoomMembershipResponseFilterSensitiveLog: (
  obj: CreateRoomMembershipResponse
) => any;
export declare const SipMediaApplicationEndpointFilterSensitiveLog: (
  obj: SipMediaApplicationEndpoint
) => any;
export declare const CreateSipMediaApplicationRequestFilterSensitiveLog: (
  obj: CreateSipMediaApplicationRequest
) => any;
export declare const SipMediaApplicationFilterSensitiveLog: (
  obj: SipMediaApplication
) => any;
export declare const CreateSipMediaApplicationResponseFilterSensitiveLog: (
  obj: CreateSipMediaApplicationResponse
) => any;
export declare const CreateSipMediaApplicationCallRequestFilterSensitiveLog: (
  obj: CreateSipMediaApplicationCallRequest
) => any;
export declare const SipMediaApplicationCallFilterSensitiveLog: (
  obj: SipMediaApplicationCall
) => any;
export declare const CreateSipMediaApplicationCallResponseFilterSensitiveLog: (
  obj: CreateSipMediaApplicationCallResponse
) => any;
export declare const SipRuleTargetApplicationFilterSensitiveLog: (
  obj: SipRuleTargetApplication
) => any;
export declare const CreateSipRuleRequestFilterSensitiveLog: (
  obj: CreateSipRuleRequest
) => any;
export declare const SipRuleFilterSensitiveLog: (obj: SipRule) => any;
export declare const CreateSipRuleResponseFilterSensitiveLog: (
  obj: CreateSipRuleResponse
) => any;
export declare const CreateUserRequestFilterSensitiveLog: (
  obj: CreateUserRequest
) => any;
export declare const UserFilterSensitiveLog: (obj: User) => any;
export declare const CreateUserResponseFilterSensitiveLog: (
  obj: CreateUserResponse
) => any;
export declare const CreateVoiceConnectorRequestFilterSensitiveLog: (
  obj: CreateVoiceConnectorRequest
) => any;
export declare const VoiceConnectorFilterSensitiveLog: (
  obj: VoiceConnector
) => any;
export declare const CreateVoiceConnectorResponseFilterSensitiveLog: (
  obj: CreateVoiceConnectorResponse
) => any;
export declare const VoiceConnectorItemFilterSensitiveLog: (
  obj: VoiceConnectorItem
) => any;
export declare const CreateVoiceConnectorGroupRequestFilterSensitiveLog: (
  obj: CreateVoiceConnectorGroupRequest
) => any;
export declare const VoiceConnectorGroupFilterSensitiveLog: (
  obj: VoiceConnectorGroup
) => any;
export declare const CreateVoiceConnectorGroupResponseFilterSensitiveLog: (
  obj: CreateVoiceConnectorGroupResponse
) => any;
export declare const CredentialFilterSensitiveLog: (obj: Credential) => any;
export declare const DeleteAccountRequestFilterSensitiveLog: (
  obj: DeleteAccountRequest
) => any;
export declare const DeleteAccountResponseFilterSensitiveLog: (
  obj: DeleteAccountResponse
) => any;
export declare const DeleteAppInstanceRequestFilterSensitiveLog: (
  obj: DeleteAppInstanceRequest
) => any;
export declare const DeleteAppInstanceAdminRequestFilterSensitiveLog: (
  obj: DeleteAppInstanceAdminRequest
) => any;
export declare const DeleteAppInstanceStreamingConfigurationsRequestFilterSensitiveLog: (
  obj: DeleteAppInstanceStreamingConfigurationsRequest
) => any;
export declare const DeleteAppInstanceUserRequestFilterSensitiveLog: (
  obj: DeleteAppInstanceUserRequest
) => any;
export declare const DeleteAttendeeRequestFilterSensitiveLog: (
  obj: DeleteAttendeeRequest
) => any;
export declare const DeleteChannelRequestFilterSensitiveLog: (
  obj: DeleteChannelRequest
) => any;
export declare const DeleteChannelBanRequestFilterSensitiveLog: (
  obj: DeleteChannelBanRequest
) => any;
export declare const DeleteChannelMembershipRequestFilterSensitiveLog: (
  obj: DeleteChannelMembershipRequest
) => any;
export declare const DeleteChannelMessageRequestFilterSensitiveLog: (
  obj: DeleteChannelMessageRequest
) => any;
export declare const DeleteChannelModeratorRequestFilterSensitiveLog: (
  obj: DeleteChannelModeratorRequest
) => any;
export declare const DeleteEventsConfigurationRequestFilterSensitiveLog: (
  obj: DeleteEventsConfigurationRequest
) => any;
export declare const DeleteMediaCapturePipelineRequestFilterSensitiveLog: (
  obj: DeleteMediaCapturePipelineRequest
) => any;
export declare const DeleteMeetingRequestFilterSensitiveLog: (
  obj: DeleteMeetingRequest
) => any;
export declare const DeletePhoneNumberRequestFilterSensitiveLog: (
  obj: DeletePhoneNumberRequest
) => any;
export declare const DeleteProxySessionRequestFilterSensitiveLog: (
  obj: DeleteProxySessionRequest
) => any;
export declare const DeleteRoomRequestFilterSensitiveLog: (
  obj: DeleteRoomRequest
) => any;
export declare const DeleteRoomMembershipRequestFilterSensitiveLog: (
  obj: DeleteRoomMembershipRequest
) => any;
export declare const DeleteSipMediaApplicationRequestFilterSensitiveLog: (
  obj: DeleteSipMediaApplicationRequest
) => any;
export declare const DeleteSipRuleRequestFilterSensitiveLog: (
  obj: DeleteSipRuleRequest
) => any;
export declare const DeleteVoiceConnectorRequestFilterSensitiveLog: (
  obj: DeleteVoiceConnectorRequest
) => any;
export declare const DeleteVoiceConnectorEmergencyCallingConfigurationRequestFilterSensitiveLog: (
  obj: DeleteVoiceConnectorEmergencyCallingConfigurationRequest
) => any;
export declare const DeleteVoiceConnectorGroupRequestFilterSensitiveLog: (
  obj: DeleteVoiceConnectorGroupRequest
) => any;
export declare const DeleteVoiceConnectorOriginationRequestFilterSensitiveLog: (
  obj: DeleteVoiceConnectorOriginationRequest
) => any;
export declare const DeleteVoiceConnectorProxyRequestFilterSensitiveLog: (
  obj: DeleteVoiceConnectorProxyRequest
) => any;
export declare const DeleteVoiceConnectorStreamingConfigurationRequestFilterSensitiveLog: (
  obj: DeleteVoiceConnectorStreamingConfigurationRequest
) => any;
export declare const DeleteVoiceConnectorTerminationRequestFilterSensitiveLog: (
  obj: DeleteVoiceConnectorTerminationRequest
) => any;
export declare const DeleteVoiceConnectorTerminationCredentialsRequestFilterSensitiveLog: (
  obj: DeleteVoiceConnectorTerminationCredentialsRequest
) => any;
export declare const DescribeAppInstanceRequestFilterSensitiveLog: (
  obj: DescribeAppInstanceRequest
) => any;
export declare const DescribeAppInstanceResponseFilterSensitiveLog: (
  obj: DescribeAppInstanceResponse
) => any;
export declare const DescribeAppInstanceAdminRequestFilterSensitiveLog: (
  obj: DescribeAppInstanceAdminRequest
) => any;
export declare const DescribeAppInstanceAdminResponseFilterSensitiveLog: (
  obj: DescribeAppInstanceAdminResponse
) => any;
export declare const DescribeAppInstanceUserRequestFilterSensitiveLog: (
  obj: DescribeAppInstanceUserRequest
) => any;
export declare const DescribeAppInstanceUserResponseFilterSensitiveLog: (
  obj: DescribeAppInstanceUserResponse
) => any;
export declare const DescribeChannelRequestFilterSensitiveLog: (
  obj: DescribeChannelRequest
) => any;
export declare const DescribeChannelResponseFilterSensitiveLog: (
  obj: DescribeChannelResponse
) => any;
export declare const DescribeChannelBanRequestFilterSensitiveLog: (
  obj: DescribeChannelBanRequest
) => any;
export declare const DescribeChannelBanResponseFilterSensitiveLog: (
  obj: DescribeChannelBanResponse
) => any;
export declare const DescribeChannelMembershipRequestFilterSensitiveLog: (
  obj: DescribeChannelMembershipRequest
) => any;
export declare const DescribeChannelMembershipResponseFilterSensitiveLog: (
  obj: DescribeChannelMembershipResponse
) => any;
export declare const DescribeChannelMembershipForAppInstanceUserRequestFilterSensitiveLog: (
  obj: DescribeChannelMembershipForAppInstanceUserRequest
) => any;
export declare const DescribeChannelMembershipForAppInstanceUserResponseFilterSensitiveLog: (
  obj: DescribeChannelMembershipForAppInstanceUserResponse
) => any;
export declare const DescribeChannelModeratedByAppInstanceUserRequestFilterSensitiveLog: (
  obj: DescribeChannelModeratedByAppInstanceUserRequest
) => any;
export declare const DescribeChannelModeratedByAppInstanceUserResponseFilterSensitiveLog: (
  obj: DescribeChannelModeratedByAppInstanceUserResponse
) => any;
export declare const DescribeChannelModeratorRequestFilterSensitiveLog: (
  obj: DescribeChannelModeratorRequest
) => any;
export declare const DescribeChannelModeratorResponseFilterSensitiveLog: (
  obj: DescribeChannelModeratorResponse
) => any;
export declare const DisassociatePhoneNumberFromUserRequestFilterSensitiveLog: (
  obj: DisassociatePhoneNumberFromUserRequest
) => any;
export declare const DisassociatePhoneNumberFromUserResponseFilterSensitiveLog: (
  obj: DisassociatePhoneNumberFromUserResponse
) => any;
export declare const DisassociatePhoneNumbersFromVoiceConnectorRequestFilterSensitiveLog: (
  obj: DisassociatePhoneNumbersFromVoiceConnectorRequest
) => any;
export declare const DisassociatePhoneNumbersFromVoiceConnectorResponseFilterSensitiveLog: (
  obj: DisassociatePhoneNumbersFromVoiceConnectorResponse
) => any;
export declare const DisassociatePhoneNumbersFromVoiceConnectorGroupRequestFilterSensitiveLog: (
  obj: DisassociatePhoneNumbersFromVoiceConnectorGroupRequest
) => any;
export declare const DisassociatePhoneNumbersFromVoiceConnectorGroupResponseFilterSensitiveLog: (
  obj: DisassociatePhoneNumbersFromVoiceConnectorGroupResponse
) => any;
export declare const DisassociateSigninDelegateGroupsFromAccountRequestFilterSensitiveLog: (
  obj: DisassociateSigninDelegateGroupsFromAccountRequest
) => any;
export declare const DisassociateSigninDelegateGroupsFromAccountResponseFilterSensitiveLog: (
  obj: DisassociateSigninDelegateGroupsFromAccountResponse
) => any;
export declare const DNISEmergencyCallingConfigurationFilterSensitiveLog: (
  obj: DNISEmergencyCallingConfiguration
) => any;
export declare const EmergencyCallingConfigurationFilterSensitiveLog: (
  obj: EmergencyCallingConfiguration
) => any;
export declare const EngineTranscribeMedicalSettingsFilterSensitiveLog: (
  obj: EngineTranscribeMedicalSettings
) => any;
export declare const EngineTranscribeSettingsFilterSensitiveLog: (
  obj: EngineTranscribeSettings
) => any;
export declare const EventsConfigurationFilterSensitiveLog: (
  obj: EventsConfiguration
) => any;
export declare const GetAccountRequestFilterSensitiveLog: (
  obj: GetAccountRequest
) => any;
export declare const GetAccountResponseFilterSensitiveLog: (
  obj: GetAccountResponse
) => any;
export declare const GetAccountSettingsRequestFilterSensitiveLog: (
  obj: GetAccountSettingsRequest
) => any;
export declare const GetAccountSettingsResponseFilterSensitiveLog: (
  obj: GetAccountSettingsResponse
) => any;
export declare const GetAppInstanceRetentionSettingsRequestFilterSensitiveLog: (
  obj: GetAppInstanceRetentionSettingsRequest
) => any;
export declare const GetAppInstanceRetentionSettingsResponseFilterSensitiveLog: (
  obj: GetAppInstanceRetentionSettingsResponse
) => any;
export declare const GetAppInstanceStreamingConfigurationsRequestFilterSensitiveLog: (
  obj: GetAppInstanceStreamingConfigurationsRequest
) => any;
export declare const GetAppInstanceStreamingConfigurationsResponseFilterSensitiveLog: (
  obj: GetAppInstanceStreamingConfigurationsResponse
) => any;
export declare const GetAttendeeRequestFilterSensitiveLog: (
  obj: GetAttendeeRequest
) => any;
export declare const GetAttendeeResponseFilterSensitiveLog: (
  obj: GetAttendeeResponse
) => any;
export declare const GetBotRequestFilterSensitiveLog: (
  obj: GetBotRequest
) => any;
export declare const GetBotResponseFilterSensitiveLog: (
  obj: GetBotResponse
) => any;
export declare const GetChannelMessageRequestFilterSensitiveLog: (
  obj: GetChannelMessageRequest
) => any;
export declare const GetChannelMessageResponseFilterSensitiveLog: (
  obj: GetChannelMessageResponse
) => any;
export declare const GetEventsConfigurationRequestFilterSensitiveLog: (
  obj: GetEventsConfigurationRequest
) => any;
export declare const GetEventsConfigurationResponseFilterSensitiveLog: (
  obj: GetEventsConfigurationResponse
) => any;
export declare const VoiceConnectorSettingsFilterSensitiveLog: (
  obj: VoiceConnectorSettings
) => any;
export declare const GetGlobalSettingsResponseFilterSensitiveLog: (
  obj: GetGlobalSettingsResponse
) => any;
export declare const GetMediaCapturePipelineRequestFilterSensitiveLog: (
  obj: GetMediaCapturePipelineRequest
) => any;
export declare const GetMediaCapturePipelineResponseFilterSensitiveLog: (
  obj: GetMediaCapturePipelineResponse
) => any;
export declare const GetMeetingRequestFilterSensitiveLog: (
  obj: GetMeetingRequest
) => any;
export declare const GetMeetingResponseFilterSensitiveLog: (
  obj: GetMeetingResponse
) => any;
export declare const GetMessagingSessionEndpointRequestFilterSensitiveLog: (
  obj: GetMessagingSessionEndpointRequest
) => any;
export declare const MessagingSessionEndpointFilterSensitiveLog: (
  obj: MessagingSessionEndpoint
) => any;
export declare const GetMessagingSessionEndpointResponseFilterSensitiveLog: (
  obj: GetMessagingSessionEndpointResponse
) => any;
export declare const GetPhoneNumberRequestFilterSensitiveLog: (
  obj: GetPhoneNumberRequest
) => any;
export declare const PhoneNumberAssociationFilterSensitiveLog: (
  obj: PhoneNumberAssociation
) => any;
export declare const PhoneNumberCapabilitiesFilterSensitiveLog: (
  obj: PhoneNumberCapabilities
) => any;
export declare const PhoneNumberFilterSensitiveLog: (obj: PhoneNumber) => any;
export declare const GetPhoneNumberResponseFilterSensitiveLog: (
  obj: GetPhoneNumberResponse
) => any;
export declare const GetPhoneNumberOrderRequestFilterSensitiveLog: (
  obj: GetPhoneNumberOrderRequest
) => any;
export declare const GetPhoneNumberOrderResponseFilterSensitiveLog: (
  obj: GetPhoneNumberOrderResponse
) => any;
export declare const GetPhoneNumberSettingsResponseFilterSensitiveLog: (
  obj: GetPhoneNumberSettingsResponse
) => any;
export declare const GetProxySessionRequestFilterSensitiveLog: (
  obj: GetProxySessionRequest
) => any;
export declare const GetProxySessionResponseFilterSensitiveLog: (
  obj: GetProxySessionResponse
) => any;
export declare const GetRetentionSettingsRequestFilterSensitiveLog: (
  obj: GetRetentionSettingsRequest
) => any;
