import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DescribeEffectiveInstanceAssociationsRequestFilterSensitiveLog, DescribeEffectiveInstanceAssociationsResultFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_json1_1DescribeEffectiveInstanceAssociationsCommand, serializeAws_json1_1DescribeEffectiveInstanceAssociationsCommand, } from "../protocols/Aws_json1_1";
export class DescribeEffectiveInstanceAssociationsCommand extends $Command {
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    constructor(input) {
        super();
        this.input = input;
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, DescribeEffectiveInstanceAssociationsCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SSMClient";
        const commandName = "DescribeEffectiveInstanceAssociationsCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: DescribeEffectiveInstanceAssociationsRequestFilterSensitiveLog,
            outputFilterSensitiveLog: DescribeEffectiveInstanceAssociationsResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_json1_1DescribeEffectiveInstanceAssociationsCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_json1_1DescribeEffectiveInstanceAssociationsCommand(output, context);
    }
}
