import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetDeployablePatchSnapshotForInstanceRequestFilterSensitiveLog, GetDeployablePatchSnapshotForInstanceResultFilterSensitiveLog, } from "../models/models_1";
import { deserializeAws_json1_1GetDeployablePatchSnapshotForInstanceCommand, serializeAws_json1_1GetDeployablePatchSnapshotForInstanceCommand, } from "../protocols/Aws_json1_1";
export class GetDeployablePatchSnapshotForInstanceCommand extends $Command {
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    constructor(input) {
        super();
        this.input = input;
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, GetDeployablePatchSnapshotForInstanceCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SSMClient";
        const commandName = "GetDeployablePatchSnapshotForInstanceCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: GetDeployablePatchSnapshotForInstanceRequestFilterSensitiveLog,
            outputFilterSensitiveLog: GetDeployablePatchSnapshotForInstanceResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_json1_1GetDeployablePatchSnapshotForInstanceCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_json1_1GetDeployablePatchSnapshotForInstanceCommand(output, context);
    }
}
