import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetMaintenanceWindowExecutionTaskInvocationRequestFilterSensitiveLog, GetMaintenanceWindowExecutionTaskInvocationResultFilterSensitiveLog, } from "../models/models_1";
import { deserializeAws_json1_1GetMaintenanceWindowExecutionTaskInvocationCommand, serializeAws_json1_1GetMaintenanceWindowExecutionTaskInvocationCommand, } from "../protocols/Aws_json1_1";
export class GetMaintenanceWindowExecutionTaskInvocationCommand extends $Command {
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    constructor(input) {
        super();
        this.input = input;
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, GetMaintenanceWindowExecutionTaskInvocationCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SSMClient";
        const commandName = "GetMaintenanceWindowExecutionTaskInvocationCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: GetMaintenanceWindowExecutionTaskInvocationRequestFilterSensitiveLog,
            outputFilterSensitiveLog: GetMaintenanceWindowExecutionTaskInvocationResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_json1_1GetMaintenanceWindowExecutionTaskInvocationCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_json1_1GetMaintenanceWindowExecutionTaskInvocationCommand(output, context);
    }
}
