import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { LabelParameterVersionRequestFilterSensitiveLog, LabelParameterVersionResultFilterSensitiveLog, } from "../models/models_1";
import { deserializeAws_json1_1LabelParameterVersionCommand, serializeAws_json1_1LabelParameterVersionCommand, } from "../protocols/Aws_json1_1";
export class LabelParameterVersionCommand extends $Command {
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    constructor(input) {
        super();
        this.input = input;
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, LabelParameterVersionCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SSMClient";
        const commandName = "LabelParameterVersionCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: LabelParameterVersionRequestFilterSensitiveLog,
            outputFilterSensitiveLog: LabelParameterVersionResultFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_json1_1LabelParameterVersionCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_json1_1LabelParameterVersionCommand(output, context);
    }
}
