import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ListDocumentMetadataHistoryRequestFilterSensitiveLog, ListDocumentMetadataHistoryResponseFilterSensitiveLog, } from "../models/models_1";
import { deserializeAws_json1_1ListDocumentMetadataHistoryCommand, serializeAws_json1_1ListDocumentMetadataHistoryCommand, } from "../protocols/Aws_json1_1";
export class ListDocumentMetadataHistoryCommand extends $Command {
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    constructor(input) {
        super();
        this.input = input;
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, ListDocumentMetadataHistoryCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "SSMClient";
        const commandName = "ListDocumentMetadataHistoryCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: ListDocumentMetadataHistoryRequestFilterSensitiveLog,
            outputFilterSensitiveLog: ListDocumentMetadataHistoryResponseFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_json1_1ListDocumentMetadataHistoryCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_json1_1ListDocumentMetadataHistoryCommand(output, context);
    }
}
