import { SENSITIVE_STRING } from "@aws-sdk/smithy-client";
import { PatchSourceFilterSensitiveLog, } from "./models_0";
import { SSMServiceException as __BaseException } from "./SSMServiceException";
export var OpsItemStatus;
(function (OpsItemStatus) {
    OpsItemStatus["APPROVED"] = "Approved";
    OpsItemStatus["CANCELLED"] = "Cancelled";
    OpsItemStatus["CANCELLING"] = "Cancelling";
    OpsItemStatus["CHANGE_CALENDAR_OVERRIDE_APPROVED"] = "ChangeCalendarOverrideApproved";
    OpsItemStatus["CHANGE_CALENDAR_OVERRIDE_REJECTED"] = "ChangeCalendarOverrideRejected";
    OpsItemStatus["CLOSED"] = "Closed";
    OpsItemStatus["COMPLETED_WITH_FAILURE"] = "CompletedWithFailure";
    OpsItemStatus["COMPLETED_WITH_SUCCESS"] = "CompletedWithSuccess";
    OpsItemStatus["FAILED"] = "Failed";
    OpsItemStatus["IN_PROGRESS"] = "InProgress";
    OpsItemStatus["OPEN"] = "Open";
    OpsItemStatus["PENDING"] = "Pending";
    OpsItemStatus["PENDING_APPROVAL"] = "PendingApproval";
    OpsItemStatus["PENDING_CHANGE_CALENDAR_OVERRIDE"] = "PendingChangeCalendarOverride";
    OpsItemStatus["REJECTED"] = "Rejected";
    OpsItemStatus["RESOLVED"] = "Resolved";
    OpsItemStatus["RUNBOOK_IN_PROGRESS"] = "RunbookInProgress";
    OpsItemStatus["SCHEDULED"] = "Scheduled";
    OpsItemStatus["TIMED_OUT"] = "TimedOut";
})(OpsItemStatus || (OpsItemStatus = {}));
export var ParametersFilterKey;
(function (ParametersFilterKey) {
    ParametersFilterKey["KEY_ID"] = "KeyId";
    ParametersFilterKey["NAME"] = "Name";
    ParametersFilterKey["TYPE"] = "Type";
})(ParametersFilterKey || (ParametersFilterKey = {}));
export var ParameterTier;
(function (ParameterTier) {
    ParameterTier["ADVANCED"] = "Advanced";
    ParameterTier["INTELLIGENT_TIERING"] = "Intelligent-Tiering";
    ParameterTier["STANDARD"] = "Standard";
})(ParameterTier || (ParameterTier = {}));
export var ParameterType;
(function (ParameterType) {
    ParameterType["SECURE_STRING"] = "SecureString";
    ParameterType["STRING"] = "String";
    ParameterType["STRING_LIST"] = "StringList";
})(ParameterType || (ParameterType = {}));
export class InvalidFilterOption extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidFilterOption",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidFilterOption";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidFilterOption.prototype);
    }
}
export var PatchSet;
(function (PatchSet) {
    PatchSet["Application"] = "APPLICATION";
    PatchSet["Os"] = "OS";
})(PatchSet || (PatchSet = {}));
export var PatchProperty;
(function (PatchProperty) {
    PatchProperty["PatchClassification"] = "CLASSIFICATION";
    PatchProperty["PatchMsrcSeverity"] = "MSRC_SEVERITY";
    PatchProperty["PatchPriority"] = "PRIORITY";
    PatchProperty["PatchProductFamily"] = "PRODUCT_FAMILY";
    PatchProperty["PatchSeverity"] = "SEVERITY";
    PatchProperty["Product"] = "PRODUCT";
})(PatchProperty || (PatchProperty = {}));
export var SessionFilterKey;
(function (SessionFilterKey) {
    SessionFilterKey["INVOKED_AFTER"] = "InvokedAfter";
    SessionFilterKey["INVOKED_BEFORE"] = "InvokedBefore";
    SessionFilterKey["OWNER"] = "Owner";
    SessionFilterKey["SESSION_ID"] = "SessionId";
    SessionFilterKey["STATUS"] = "Status";
    SessionFilterKey["TARGET_ID"] = "Target";
})(SessionFilterKey || (SessionFilterKey = {}));
export var SessionState;
(function (SessionState) {
    SessionState["ACTIVE"] = "Active";
    SessionState["HISTORY"] = "History";
})(SessionState || (SessionState = {}));
export var SessionStatus;
(function (SessionStatus) {
    SessionStatus["CONNECTED"] = "Connected";
    SessionStatus["CONNECTING"] = "Connecting";
    SessionStatus["DISCONNECTED"] = "Disconnected";
    SessionStatus["FAILED"] = "Failed";
    SessionStatus["TERMINATED"] = "Terminated";
    SessionStatus["TERMINATING"] = "Terminating";
})(SessionStatus || (SessionStatus = {}));
export class OpsItemRelatedItemAssociationNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "OpsItemRelatedItemAssociationNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemRelatedItemAssociationNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemRelatedItemAssociationNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export var CalendarState;
(function (CalendarState) {
    CalendarState["CLOSED"] = "CLOSED";
    CalendarState["OPEN"] = "OPEN";
})(CalendarState || (CalendarState = {}));
export class InvalidDocumentType extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidDocumentType",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDocumentType";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDocumentType.prototype);
        this.Message = opts.Message;
    }
}
export class UnsupportedCalendarException extends __BaseException {
    constructor(opts) {
        super({
            name: "UnsupportedCalendarException",
            $fault: "client",
            ...opts,
        });
        this.name = "UnsupportedCalendarException";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnsupportedCalendarException.prototype);
        this.Message = opts.Message;
    }
}
export var CommandInvocationStatus;
(function (CommandInvocationStatus) {
    CommandInvocationStatus["CANCELLED"] = "Cancelled";
    CommandInvocationStatus["CANCELLING"] = "Cancelling";
    CommandInvocationStatus["DELAYED"] = "Delayed";
    CommandInvocationStatus["FAILED"] = "Failed";
    CommandInvocationStatus["IN_PROGRESS"] = "InProgress";
    CommandInvocationStatus["PENDING"] = "Pending";
    CommandInvocationStatus["SUCCESS"] = "Success";
    CommandInvocationStatus["TIMED_OUT"] = "TimedOut";
})(CommandInvocationStatus || (CommandInvocationStatus = {}));
export class InvalidPluginName extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidPluginName",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidPluginName";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidPluginName.prototype);
    }
}
export class InvocationDoesNotExist extends __BaseException {
    constructor(opts) {
        super({
            name: "InvocationDoesNotExist",
            $fault: "client",
            ...opts,
        });
        this.name = "InvocationDoesNotExist";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvocationDoesNotExist.prototype);
    }
}
export var ConnectionStatus;
(function (ConnectionStatus) {
    ConnectionStatus["CONNECTED"] = "Connected";
    ConnectionStatus["NOT_CONNECTED"] = "NotConnected";
})(ConnectionStatus || (ConnectionStatus = {}));
export class UnsupportedFeatureRequiredException extends __BaseException {
    constructor(opts) {
        super({
            name: "UnsupportedFeatureRequiredException",
            $fault: "client",
            ...opts,
        });
        this.name = "UnsupportedFeatureRequiredException";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnsupportedFeatureRequiredException.prototype);
        this.Message = opts.Message;
    }
}
export var AttachmentHashType;
(function (AttachmentHashType) {
    AttachmentHashType["SHA256"] = "Sha256";
})(AttachmentHashType || (AttachmentHashType = {}));
export var InventoryQueryOperatorType;
(function (InventoryQueryOperatorType) {
    InventoryQueryOperatorType["BEGIN_WITH"] = "BeginWith";
    InventoryQueryOperatorType["EQUAL"] = "Equal";
    InventoryQueryOperatorType["EXISTS"] = "Exists";
    InventoryQueryOperatorType["GREATER_THAN"] = "GreaterThan";
    InventoryQueryOperatorType["LESS_THAN"] = "LessThan";
    InventoryQueryOperatorType["NOT_EQUAL"] = "NotEqual";
})(InventoryQueryOperatorType || (InventoryQueryOperatorType = {}));
export class InvalidAggregatorException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidAggregatorException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAggregatorException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAggregatorException.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidInventoryGroupException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidInventoryGroupException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidInventoryGroupException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidInventoryGroupException.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidResultAttributeException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidResultAttributeException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidResultAttributeException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidResultAttributeException.prototype);
        this.Message = opts.Message;
    }
}
export var InventoryAttributeDataType;
(function (InventoryAttributeDataType) {
    InventoryAttributeDataType["NUMBER"] = "number";
    InventoryAttributeDataType["STRING"] = "string";
})(InventoryAttributeDataType || (InventoryAttributeDataType = {}));
export var NotificationEvent;
(function (NotificationEvent) {
    NotificationEvent["ALL"] = "All";
    NotificationEvent["CANCELLED"] = "Cancelled";
    NotificationEvent["FAILED"] = "Failed";
    NotificationEvent["IN_PROGRESS"] = "InProgress";
    NotificationEvent["SUCCESS"] = "Success";
    NotificationEvent["TIMED_OUT"] = "TimedOut";
})(NotificationEvent || (NotificationEvent = {}));
export var NotificationType;
(function (NotificationType) {
    NotificationType["Command"] = "Command";
    NotificationType["Invocation"] = "Invocation";
})(NotificationType || (NotificationType = {}));
export var OpsFilterOperatorType;
(function (OpsFilterOperatorType) {
    OpsFilterOperatorType["BEGIN_WITH"] = "BeginWith";
    OpsFilterOperatorType["EQUAL"] = "Equal";
    OpsFilterOperatorType["EXISTS"] = "Exists";
    OpsFilterOperatorType["GREATER_THAN"] = "GreaterThan";
    OpsFilterOperatorType["LESS_THAN"] = "LessThan";
    OpsFilterOperatorType["NOT_EQUAL"] = "NotEqual";
})(OpsFilterOperatorType || (OpsFilterOperatorType = {}));
export class InvalidKeyId extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidKeyId",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidKeyId";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidKeyId.prototype);
    }
}
export class ParameterVersionNotFound extends __BaseException {
    constructor(opts) {
        super({
            name: "ParameterVersionNotFound",
            $fault: "client",
            ...opts,
        });
        this.name = "ParameterVersionNotFound";
        this.$fault = "client";
        Object.setPrototypeOf(this, ParameterVersionNotFound.prototype);
    }
}
export class ServiceSettingNotFound extends __BaseException {
    constructor(opts) {
        super({
            name: "ServiceSettingNotFound",
            $fault: "client",
            ...opts,
        });
        this.name = "ServiceSettingNotFound";
        this.$fault = "client";
        Object.setPrototypeOf(this, ServiceSettingNotFound.prototype);
        this.Message = opts.Message;
    }
}
export class ParameterVersionLabelLimitExceeded extends __BaseException {
    constructor(opts) {
        super({
            name: "ParameterVersionLabelLimitExceeded",
            $fault: "client",
            ...opts,
        });
        this.name = "ParameterVersionLabelLimitExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, ParameterVersionLabelLimitExceeded.prototype);
    }
}
export var AssociationFilterKey;
(function (AssociationFilterKey) {
    AssociationFilterKey["AssociationId"] = "AssociationId";
    AssociationFilterKey["AssociationName"] = "AssociationName";
    AssociationFilterKey["InstanceId"] = "InstanceId";
    AssociationFilterKey["LastExecutedAfter"] = "LastExecutedAfter";
    AssociationFilterKey["LastExecutedBefore"] = "LastExecutedBefore";
    AssociationFilterKey["Name"] = "Name";
    AssociationFilterKey["ResourceGroupName"] = "ResourceGroupName";
    AssociationFilterKey["Status"] = "AssociationStatusName";
})(AssociationFilterKey || (AssociationFilterKey = {}));
export var CommandFilterKey;
(function (CommandFilterKey) {
    CommandFilterKey["DOCUMENT_NAME"] = "DocumentName";
    CommandFilterKey["EXECUTION_STAGE"] = "ExecutionStage";
    CommandFilterKey["INVOKED_AFTER"] = "InvokedAfter";
    CommandFilterKey["INVOKED_BEFORE"] = "InvokedBefore";
    CommandFilterKey["STATUS"] = "Status";
})(CommandFilterKey || (CommandFilterKey = {}));
export var CommandPluginStatus;
(function (CommandPluginStatus) {
    CommandPluginStatus["CANCELLED"] = "Cancelled";
    CommandPluginStatus["FAILED"] = "Failed";
    CommandPluginStatus["IN_PROGRESS"] = "InProgress";
    CommandPluginStatus["PENDING"] = "Pending";
    CommandPluginStatus["SUCCESS"] = "Success";
    CommandPluginStatus["TIMED_OUT"] = "TimedOut";
})(CommandPluginStatus || (CommandPluginStatus = {}));
export var CommandStatus;
(function (CommandStatus) {
    CommandStatus["CANCELLED"] = "Cancelled";
    CommandStatus["CANCELLING"] = "Cancelling";
    CommandStatus["FAILED"] = "Failed";
    CommandStatus["IN_PROGRESS"] = "InProgress";
    CommandStatus["PENDING"] = "Pending";
    CommandStatus["SUCCESS"] = "Success";
    CommandStatus["TIMED_OUT"] = "TimedOut";
})(CommandStatus || (CommandStatus = {}));
export var ComplianceQueryOperatorType;
(function (ComplianceQueryOperatorType) {
    ComplianceQueryOperatorType["BeginWith"] = "BEGIN_WITH";
    ComplianceQueryOperatorType["Equal"] = "EQUAL";
    ComplianceQueryOperatorType["GreaterThan"] = "GREATER_THAN";
    ComplianceQueryOperatorType["LessThan"] = "LESS_THAN";
    ComplianceQueryOperatorType["NotEqual"] = "NOT_EQUAL";
})(ComplianceQueryOperatorType || (ComplianceQueryOperatorType = {}));
export var ComplianceSeverity;
(function (ComplianceSeverity) {
    ComplianceSeverity["Critical"] = "CRITICAL";
    ComplianceSeverity["High"] = "HIGH";
    ComplianceSeverity["Informational"] = "INFORMATIONAL";
    ComplianceSeverity["Low"] = "LOW";
    ComplianceSeverity["Medium"] = "MEDIUM";
    ComplianceSeverity["Unspecified"] = "UNSPECIFIED";
})(ComplianceSeverity || (ComplianceSeverity = {}));
export var ComplianceStatus;
(function (ComplianceStatus) {
    ComplianceStatus["Compliant"] = "COMPLIANT";
    ComplianceStatus["NonCompliant"] = "NON_COMPLIANT";
})(ComplianceStatus || (ComplianceStatus = {}));
export var DocumentMetadataEnum;
(function (DocumentMetadataEnum) {
    DocumentMetadataEnum["DocumentReviews"] = "DocumentReviews";
})(DocumentMetadataEnum || (DocumentMetadataEnum = {}));
export var DocumentReviewCommentType;
(function (DocumentReviewCommentType) {
    DocumentReviewCommentType["Comment"] = "Comment";
})(DocumentReviewCommentType || (DocumentReviewCommentType = {}));
export var DocumentFilterKey;
(function (DocumentFilterKey) {
    DocumentFilterKey["DocumentType"] = "DocumentType";
    DocumentFilterKey["Name"] = "Name";
    DocumentFilterKey["Owner"] = "Owner";
    DocumentFilterKey["PlatformTypes"] = "PlatformTypes";
})(DocumentFilterKey || (DocumentFilterKey = {}));
export var OpsItemEventFilterKey;
(function (OpsItemEventFilterKey) {
    OpsItemEventFilterKey["OPSITEM_ID"] = "OpsItemId";
})(OpsItemEventFilterKey || (OpsItemEventFilterKey = {}));
export var OpsItemEventFilterOperator;
(function (OpsItemEventFilterOperator) {
    OpsItemEventFilterOperator["EQUAL"] = "Equal";
})(OpsItemEventFilterOperator || (OpsItemEventFilterOperator = {}));
export var OpsItemRelatedItemsFilterKey;
(function (OpsItemRelatedItemsFilterKey) {
    OpsItemRelatedItemsFilterKey["ASSOCIATION_ID"] = "AssociationId";
    OpsItemRelatedItemsFilterKey["RESOURCE_TYPE"] = "ResourceType";
    OpsItemRelatedItemsFilterKey["RESOURCE_URI"] = "ResourceUri";
})(OpsItemRelatedItemsFilterKey || (OpsItemRelatedItemsFilterKey = {}));
export var OpsItemRelatedItemsFilterOperator;
(function (OpsItemRelatedItemsFilterOperator) {
    OpsItemRelatedItemsFilterOperator["EQUAL"] = "Equal";
})(OpsItemRelatedItemsFilterOperator || (OpsItemRelatedItemsFilterOperator = {}));
export var LastResourceDataSyncStatus;
(function (LastResourceDataSyncStatus) {
    LastResourceDataSyncStatus["FAILED"] = "Failed";
    LastResourceDataSyncStatus["INPROGRESS"] = "InProgress";
    LastResourceDataSyncStatus["SUCCESSFUL"] = "Successful";
})(LastResourceDataSyncStatus || (LastResourceDataSyncStatus = {}));
export class DocumentPermissionLimit extends __BaseException {
    constructor(opts) {
        super({
            name: "DocumentPermissionLimit",
            $fault: "client",
            ...opts,
        });
        this.name = "DocumentPermissionLimit";
        this.$fault = "client";
        Object.setPrototypeOf(this, DocumentPermissionLimit.prototype);
        this.Message = opts.Message;
    }
}
export class ComplianceTypeCountLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "ComplianceTypeCountLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ComplianceTypeCountLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ComplianceTypeCountLimitExceededException.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidItemContentException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidItemContentException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidItemContentException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidItemContentException.prototype);
        this.TypeName = opts.TypeName;
        this.Message = opts.Message;
    }
}
export class ItemSizeLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "ItemSizeLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ItemSizeLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ItemSizeLimitExceededException.prototype);
        this.TypeName = opts.TypeName;
        this.Message = opts.Message;
    }
}
export var ComplianceUploadType;
(function (ComplianceUploadType) {
    ComplianceUploadType["Complete"] = "COMPLETE";
    ComplianceUploadType["Partial"] = "PARTIAL";
})(ComplianceUploadType || (ComplianceUploadType = {}));
export class TotalSizeLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "TotalSizeLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "TotalSizeLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, TotalSizeLimitExceededException.prototype);
        this.Message = opts.Message;
    }
}
export class CustomSchemaCountLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "CustomSchemaCountLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "CustomSchemaCountLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, CustomSchemaCountLimitExceededException.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidInventoryItemContextException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidInventoryItemContextException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidInventoryItemContextException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidInventoryItemContextException.prototype);
        this.Message = opts.Message;
    }
}
export class ItemContentMismatchException extends __BaseException {
    constructor(opts) {
        super({
            name: "ItemContentMismatchException",
            $fault: "client",
            ...opts,
        });
        this.name = "ItemContentMismatchException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ItemContentMismatchException.prototype);
        this.TypeName = opts.TypeName;
        this.Message = opts.Message;
    }
}
export class SubTypeCountLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "SubTypeCountLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "SubTypeCountLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, SubTypeCountLimitExceededException.prototype);
        this.Message = opts.Message;
    }
}
export class UnsupportedInventoryItemContextException extends __BaseException {
    constructor(opts) {
        super({
            name: "UnsupportedInventoryItemContextException",
            $fault: "client",
            ...opts,
        });
        this.name = "UnsupportedInventoryItemContextException";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnsupportedInventoryItemContextException.prototype);
        this.TypeName = opts.TypeName;
        this.Message = opts.Message;
    }
}
export class UnsupportedInventorySchemaVersionException extends __BaseException {
    constructor(opts) {
        super({
            name: "UnsupportedInventorySchemaVersionException",
            $fault: "client",
            ...opts,
        });
        this.name = "UnsupportedInventorySchemaVersionException";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnsupportedInventorySchemaVersionException.prototype);
        this.Message = opts.Message;
    }
}
export class HierarchyLevelLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "HierarchyLevelLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "HierarchyLevelLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, HierarchyLevelLimitExceededException.prototype);
    }
}
export class HierarchyTypeMismatchException extends __BaseException {
    constructor(opts) {
        super({
            name: "HierarchyTypeMismatchException",
            $fault: "client",
            ...opts,
        });
        this.name = "HierarchyTypeMismatchException";
        this.$fault = "client";
        Object.setPrototypeOf(this, HierarchyTypeMismatchException.prototype);
    }
}
export class IncompatiblePolicyException extends __BaseException {
    constructor(opts) {
        super({
            name: "IncompatiblePolicyException",
            $fault: "client",
            ...opts,
        });
        this.name = "IncompatiblePolicyException";
        this.$fault = "client";
        Object.setPrototypeOf(this, IncompatiblePolicyException.prototype);
    }
}
export class InvalidAllowedPatternException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidAllowedPatternException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAllowedPatternException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAllowedPatternException.prototype);
    }
}
export class InvalidPolicyAttributeException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidPolicyAttributeException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidPolicyAttributeException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidPolicyAttributeException.prototype);
    }
}
export class InvalidPolicyTypeException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidPolicyTypeException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidPolicyTypeException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidPolicyTypeException.prototype);
    }
}
export class ParameterAlreadyExists extends __BaseException {
    constructor(opts) {
        super({
            name: "ParameterAlreadyExists",
            $fault: "client",
            ...opts,
        });
        this.name = "ParameterAlreadyExists";
        this.$fault = "client";
        Object.setPrototypeOf(this, ParameterAlreadyExists.prototype);
    }
}
export class ParameterLimitExceeded extends __BaseException {
    constructor(opts) {
        super({
            name: "ParameterLimitExceeded",
            $fault: "client",
            ...opts,
        });
        this.name = "ParameterLimitExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, ParameterLimitExceeded.prototype);
    }
}
export class ParameterMaxVersionLimitExceeded extends __BaseException {
    constructor(opts) {
        super({
            name: "ParameterMaxVersionLimitExceeded",
            $fault: "client",
            ...opts,
        });
        this.name = "ParameterMaxVersionLimitExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, ParameterMaxVersionLimitExceeded.prototype);
    }
}
export class ParameterPatternMismatchException extends __BaseException {
    constructor(opts) {
        super({
            name: "ParameterPatternMismatchException",
            $fault: "client",
            ...opts,
        });
        this.name = "ParameterPatternMismatchException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ParameterPatternMismatchException.prototype);
    }
}
export class PoliciesLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "PoliciesLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "PoliciesLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, PoliciesLimitExceededException.prototype);
    }
}
export class UnsupportedParameterType extends __BaseException {
    constructor(opts) {
        super({
            name: "UnsupportedParameterType",
            $fault: "client",
            ...opts,
        });
        this.name = "UnsupportedParameterType";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnsupportedParameterType.prototype);
    }
}
export class ResourcePolicyLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourcePolicyLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourcePolicyLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourcePolicyLimitExceededException.prototype);
        this.Limit = opts.Limit;
        this.LimitType = opts.LimitType;
        this.Message = opts.Message;
    }
}
export class FeatureNotAvailableException extends __BaseException {
    constructor(opts) {
        super({
            name: "FeatureNotAvailableException",
            $fault: "client",
            ...opts,
        });
        this.name = "FeatureNotAvailableException";
        this.$fault = "client";
        Object.setPrototypeOf(this, FeatureNotAvailableException.prototype);
        this.Message = opts.Message;
    }
}
export class AutomationStepNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "AutomationStepNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "AutomationStepNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AutomationStepNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidAutomationSignalException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidAutomationSignalException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAutomationSignalException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAutomationSignalException.prototype);
        this.Message = opts.Message;
    }
}
export var SignalType;
(function (SignalType) {
    SignalType["APPROVE"] = "Approve";
    SignalType["REJECT"] = "Reject";
    SignalType["RESUME"] = "Resume";
    SignalType["START_STEP"] = "StartStep";
    SignalType["STOP_STEP"] = "StopStep";
})(SignalType || (SignalType = {}));
export class InvalidNotificationConfig extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidNotificationConfig",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidNotificationConfig";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidNotificationConfig.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidOutputFolder extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidOutputFolder",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidOutputFolder";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidOutputFolder.prototype);
    }
}
export class InvalidRole extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidRole",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidRole";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidRole.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidAssociation extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidAssociation",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAssociation";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAssociation.prototype);
        this.Message = opts.Message;
    }
}
export class AutomationDefinitionNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "AutomationDefinitionNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "AutomationDefinitionNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AutomationDefinitionNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export class AutomationDefinitionVersionNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "AutomationDefinitionVersionNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "AutomationDefinitionVersionNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AutomationDefinitionVersionNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export class AutomationExecutionLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "AutomationExecutionLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "AutomationExecutionLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AutomationExecutionLimitExceededException.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidAutomationExecutionParametersException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidAutomationExecutionParametersException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAutomationExecutionParametersException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAutomationExecutionParametersException.prototype);
        this.Message = opts.Message;
    }
}
export class AutomationDefinitionNotApprovedException extends __BaseException {
    constructor(opts) {
        super({
            name: "AutomationDefinitionNotApprovedException",
            $fault: "client",
            ...opts,
        });
        this.name = "AutomationDefinitionNotApprovedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AutomationDefinitionNotApprovedException.prototype);
        this.Message = opts.Message;
    }
}
export class TargetNotConnected extends __BaseException {
    constructor(opts) {
        super({
            name: "TargetNotConnected",
            $fault: "client",
            ...opts,
        });
        this.name = "TargetNotConnected";
        this.$fault = "client";
        Object.setPrototypeOf(this, TargetNotConnected.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidAutomationStatusUpdateException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidAutomationStatusUpdateException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAutomationStatusUpdateException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAutomationStatusUpdateException.prototype);
        this.Message = opts.Message;
    }
}
export var StopType;
(function (StopType) {
    StopType["CANCEL"] = "Cancel";
    StopType["COMPLETE"] = "Complete";
})(StopType || (StopType = {}));
export class AssociationVersionLimitExceeded extends __BaseException {
    constructor(opts) {
        super({
            name: "AssociationVersionLimitExceeded",
            $fault: "client",
            ...opts,
        });
        this.name = "AssociationVersionLimitExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, AssociationVersionLimitExceeded.prototype);
        this.Message = opts.Message;
    }
}
export const OpsItemFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeOpsItemsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const OpsItemSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeOpsItemsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ParametersFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ParameterStringFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeParametersRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ParameterInlinePolicyFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ParameterMetadataFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeParametersResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribePatchBaselinesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PatchBaselineIdentityFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribePatchBaselinesResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribePatchGroupsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PatchGroupPatchBaselineMappingFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribePatchGroupsResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribePatchGroupStateRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribePatchGroupStateResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribePatchPropertiesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribePatchPropertiesResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SessionFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeSessionsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SessionManagerOutputUrlFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SessionFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DescribeSessionsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DisassociateOpsItemRelatedItemRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DisassociateOpsItemRelatedItemResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetAutomationExecutionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ProgressCountersFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AutomationExecutionFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetAutomationExecutionResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetCalendarStateRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetCalendarStateResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetCommandInvocationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CloudWatchOutputConfigFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetCommandInvocationResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetConnectionStatusRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetConnectionStatusResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetDefaultPatchBaselineRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetDefaultPatchBaselineResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const BaselineOverrideFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Sources && { Sources: obj.Sources.map((item) => PatchSourceFilterSensitiveLog(item)) }),
});
export const GetDeployablePatchSnapshotForInstanceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetDeployablePatchSnapshotForInstanceResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetDocumentRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AttachmentContentFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetDocumentResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const InventoryFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const InventoryGroupFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ResultAttributeFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const InventoryResultItemFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const InventoryResultEntityFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetInventoryResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetInventorySchemaRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const InventoryItemAttributeFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const InventoryItemSchemaFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetInventorySchemaResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetMaintenanceWindowRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetMaintenanceWindowResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Description && { Description: SENSITIVE_STRING }),
});
export const GetMaintenanceWindowExecutionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetMaintenanceWindowExecutionResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetMaintenanceWindowExecutionTaskRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetMaintenanceWindowExecutionTaskResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.TaskParameters && { TaskParameters: SENSITIVE_STRING }),
});
export const GetMaintenanceWindowExecutionTaskInvocationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetMaintenanceWindowExecutionTaskInvocationResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: SENSITIVE_STRING }),
    ...(obj.OwnerInformation && { OwnerInformation: SENSITIVE_STRING }),
});
export const GetMaintenanceWindowTaskRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const MaintenanceWindowAutomationParametersFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const MaintenanceWindowLambdaParametersFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Payload && { Payload: SENSITIVE_STRING }),
});
export const NotificationConfigFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const MaintenanceWindowRunCommandParametersFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: SENSITIVE_STRING }),
});
export const MaintenanceWindowStepFunctionsParametersFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Input && { Input: SENSITIVE_STRING }),
});
export const MaintenanceWindowTaskInvocationParametersFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.RunCommand && { RunCommand: MaintenanceWindowRunCommandParametersFilterSensitiveLog(obj.RunCommand) }),
    ...(obj.StepFunctions && {
        StepFunctions: MaintenanceWindowStepFunctionsParametersFilterSensitiveLog(obj.StepFunctions),
    }),
    ...(obj.Lambda && { Lambda: MaintenanceWindowLambdaParametersFilterSensitiveLog(obj.Lambda) }),
});
export const GetMaintenanceWindowTaskResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.TaskParameters && { TaskParameters: SENSITIVE_STRING }),
    ...(obj.TaskInvocationParameters && {
        TaskInvocationParameters: MaintenanceWindowTaskInvocationParametersFilterSensitiveLog(obj.TaskInvocationParameters),
    }),
    ...(obj.Description && { Description: SENSITIVE_STRING }),
});
export const GetOpsItemRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const OpsItemFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetOpsItemResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetOpsMetadataRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetOpsMetadataResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const OpsFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const OpsResultAttributeFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const OpsEntityItemFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const OpsEntityFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetOpsSummaryResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetParameterRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ParameterFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Value && { Value: SENSITIVE_STRING }),
});
export const GetParameterResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameter && { Parameter: ParameterFilterSensitiveLog(obj.Parameter) }),
});
export const GetParameterHistoryRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ParameterHistoryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Value && { Value: SENSITIVE_STRING }),
});
export const GetParameterHistoryResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: obj.Parameters.map((item) => ParameterHistoryFilterSensitiveLog(item)) }),
});
export const GetParametersRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetParametersResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: obj.Parameters.map((item) => ParameterFilterSensitiveLog(item)) }),
});
export const GetParametersByPathRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetParametersByPathResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: obj.Parameters.map((item) => ParameterFilterSensitiveLog(item)) }),
});
export const GetPatchBaselineRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetPatchBaselineResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Sources && { Sources: obj.Sources.map((item) => PatchSourceFilterSensitiveLog(item)) }),
});
export const GetPatchBaselineForPatchGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetPatchBaselineForPatchGroupResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetResourcePoliciesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetResourcePoliciesResponseEntryFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetResourcePoliciesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetServiceSettingRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ServiceSettingFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetServiceSettingResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const LabelParameterVersionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const LabelParameterVersionResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AssociationFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListAssociationsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AssociationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListAssociationsResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListAssociationVersionsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const AssociationVersionInfoFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: SENSITIVE_STRING }),
});
export const ListAssociationVersionsResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AssociationVersions && {
        AssociationVersions: obj.AssociationVersions.map((item) => AssociationVersionInfoFilterSensitiveLog(item)),
    }),
});
export const CommandFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListCommandInvocationsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CommandPluginFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CommandInvocationFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListCommandInvocationsResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListCommandsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CommandFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: SENSITIVE_STRING }),
});
export const ListCommandsResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Commands && { Commands: obj.Commands.map((item) => CommandFilterSensitiveLog(item)) }),
});
export const ComplianceStringFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListComplianceItemsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ComplianceExecutionSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ComplianceItemFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListComplianceItemsResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListComplianceSummariesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SeveritySummaryFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const CompliantSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const NonCompliantSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ComplianceSummaryItemFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListComplianceSummariesResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListDocumentMetadataHistoryRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DocumentReviewCommentSourceFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DocumentReviewerResponseSourceFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DocumentMetadataResponseInfoFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListDocumentMetadataHistoryResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DocumentFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DocumentKeyValuesFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListDocumentsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DocumentIdentifierFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListDocumentsResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListDocumentVersionsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const DocumentVersionInfoFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListDocumentVersionsResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListInventoryEntriesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListInventoryEntriesResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const OpsItemEventFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListOpsItemEventsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const OpsItemIdentityFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const OpsItemEventSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListOpsItemEventsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const OpsItemRelatedItemsFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListOpsItemRelatedItemsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const OpsItemRelatedItemSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListOpsItemRelatedItemsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const OpsMetadataFilterFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListOpsMetadataRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const OpsMetadataFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListOpsMetadataResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListResourceComplianceSummariesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ResourceComplianceSummaryItemFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListResourceComplianceSummariesResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListResourceDataSyncRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ResourceDataSyncSourceWithStateFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ResourceDataSyncItemFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListResourceDataSyncResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListTagsForResourceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListTagsForResourceResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ModifyDocumentPermissionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ModifyDocumentPermissionResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ComplianceItemEntryFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutComplianceItemsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutComplianceItemsResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const InventoryItemFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutInventoryRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutInventoryResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutParameterRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Value && { Value: SENSITIVE_STRING }),
});
export const PutParameterResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutResourcePolicyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const PutResourcePolicyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RegisterDefaultPatchBaselineRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RegisterDefaultPatchBaselineResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RegisterPatchBaselineForPatchGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RegisterPatchBaselineForPatchGroupResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RegisterTargetWithMaintenanceWindowRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.OwnerInformation && { OwnerInformation: SENSITIVE_STRING }),
    ...(obj.Description && { Description: SENSITIVE_STRING }),
});
export const RegisterTargetWithMaintenanceWindowResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RegisterTaskWithMaintenanceWindowRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.TaskParameters && { TaskParameters: SENSITIVE_STRING }),
    ...(obj.TaskInvocationParameters && {
        TaskInvocationParameters: MaintenanceWindowTaskInvocationParametersFilterSensitiveLog(obj.TaskInvocationParameters),
    }),
    ...(obj.Description && { Description: SENSITIVE_STRING }),
});
export const RegisterTaskWithMaintenanceWindowResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RemoveTagsFromResourceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const RemoveTagsFromResourceResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ResetServiceSettingRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ResetServiceSettingResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ResumeSessionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ResumeSessionResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SendAutomationSignalRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SendAutomationSignalResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const SendCommandRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: SENSITIVE_STRING }),
});
export const SendCommandResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Command && { Command: CommandFilterSensitiveLog(obj.Command) }),
});
export const StartAssociationsOnceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const StartAssociationsOnceResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const StartAutomationExecutionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const StartAutomationExecutionResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const StartChangeRequestExecutionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const StartChangeRequestExecutionResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const StartSessionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const StartSessionResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const StopAutomationExecutionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const StopAutomationExecutionResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const TerminateSessionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const TerminateSessionResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UnlabelParameterVersionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const UnlabelParameterVersionResultFilterSensitiveLog = (obj) => ({
    ...obj,
});
