from skidl import SKIDL, TEMPLATE, Part, Pin, SchLib

SKIDL_lib_version = '0.0.1'

microchip_pic12mcu = SchLib(tool=SKIDL).add_parts(*[
        Part(name='PIC12(L)F1501-I/P',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC12(L)F1501-I/SN', 'PIC12(L)F1501-I/MS', 'PIC12(L)F1501-I/MC']),
        Part(name='PIC12(L)F1822-I/P',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC12(L)F1822-I/SN', 'PIC12(L)F1822-I/MC']),
        Part(name='PIC12(L)F1840-I/P',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC12(L)F1840-I/SN', 'PIC12(L)F1840-I/MC']),
        Part(name='PIC12C508-I/P',dest=TEMPLATE,tool=SKIDL,keywords='8-Bit CMOS Microcontroller',description='PIC12C508, 512W EPROM, 25B SRAM, SO8 Wide',ref_prefix='U',num_units=1,do_erc=True,aliases=['PIC12C508-I/SM', 'PIC12C508-I/JW'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='CLKIN/OSC1/GP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='OSC2/GP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/GP3',do_erc=True),
            Pin(num='5',name='T0CKI/GP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='ICSPCLK/GP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ICSPDAT/GP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC12C508A-I/P',dest=TEMPLATE,tool=SKIDL,keywords='8-Bit CMOS Microcontroller',description='PIC12C508A, 512W EPROM, 25B SRAM, SO8',ref_prefix='U',num_units=1,do_erc=True,aliases=['PIC12C508A-I/SN', 'PIC12C508A-I/SM', 'PIC12C508A-I/JW'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='CLKIN/OSC1/GP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='OSC2/GP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/GP3',do_erc=True),
            Pin(num='5',name='T0CKI/GP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='ICSPCLK/GP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ICSPDAT/GP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC12C509-I/P',dest=TEMPLATE,tool=SKIDL,keywords='8-Bit CMOS Microcontroller',description='PIC12C509, 1024W EPROM, 41B SRAM, SO8 Wide',ref_prefix='U',num_units=1,do_erc=True,aliases=['PIC12C509-I/SM', 'PIC12C509-I/JW'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='CLKIN/OSC1/GP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='OSC2/GP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/GP3',do_erc=True),
            Pin(num='5',name='T0CKI/GP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='ICSPCLK/GP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ICSPDAT/GP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC12C509A-I/P',dest=TEMPLATE,tool=SKIDL,keywords='8-Bit CMOS Microcontroller',description='PIC12C509A, 1024W EPROM, 41B SRAM, SO8',ref_prefix='U',num_units=1,do_erc=True,aliases=['PIC12C509A-I/SN', 'PIC12C509A-I/SM', 'PIC12C509A-I/JW'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='CLKIN/OSC1/GP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='OSC2/GP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/GP3',do_erc=True),
            Pin(num='5',name='T0CKI/GP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='ICSPCLK/GP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ICSPDAT/GP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC12C671-I/P',dest=TEMPLATE,tool=SKIDL,keywords='8-Bit CMOS Microcontroller',description='PIC12C671, 1024W EPROM, 128B SRAM, SO8',ref_prefix='U',num_units=1,do_erc=True,aliases=['PIC12C671-I/SN', 'PIC12C671-I/JW'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='CLKIN/OSC1/GP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='CLKOUT/OSC2/AN3/GP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/GP3',do_erc=True),
            Pin(num='5',name='INT/T0CKI/AN2/GP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='Vref/AN1/GP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AN0/GP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC12C672-I/P',dest=TEMPLATE,tool=SKIDL,keywords='8-Bit CMOS Microcontroller',description='PIC12C672, 2048W EPROM, 128B SRAM, SO8',ref_prefix='U',num_units=1,do_erc=True,aliases=['PIC12C672-I/SN', 'PIC12C672-I/JW'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='CLKIN/OSC1/GP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='CLKOUT/OSC2/AN3/GP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/GP3',do_erc=True),
            Pin(num='5',name='INT/T0CKI/AN2/GP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='Vref/AN1/GP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AN0/GP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC12CE518-I/P',dest=TEMPLATE,tool=SKIDL,keywords='8-Bit CMOS Microcontroller',description='PIC12CE518, 512W EPROM, 25B SRAM, SO8',ref_prefix='U',num_units=1,do_erc=True,aliases=['PIC12CE518-I/SN', 'PIC12CE518-I/SM', 'PIC12CE518-I/JW'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='OSC1/CLKIN/GP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='OSC2/GP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/GP3',do_erc=True),
            Pin(num='5',name='T0CKI/GP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='ICSPCLK/GP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ICSPDAT/GP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC12CE519-I/P',dest=TEMPLATE,tool=SKIDL,keywords='8-Bit CMOS Microcontroller',description='PIC12CE519, 1024W EPROM, 41B SRAM, SO8',ref_prefix='U',num_units=1,do_erc=True,aliases=['PIC12CE519-I/SN', 'PIC12CE519-I/SM', 'PIC12CE519-I/JW'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='CLKIN/OSC1/GP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='OSC2/GP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/GP3',do_erc=True),
            Pin(num='5',name='T0CKI/GP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='ICSPCLK/GP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ICSPDAT/GP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC12CE673-I/P',dest=TEMPLATE,tool=SKIDL,keywords='8-Bit CMOS Microcontroller',description='1024W EPROM, 128B SRAM, 128B EPROM, PDIP8',ref_prefix='U',num_units=1,do_erc=True,aliases=['PIC12CE673-I/JW'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='CLKIN/OSC1/GP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='CLKOUT/OSC2/AN3/GP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/GP3',do_erc=True),
            Pin(num='5',name='INT/T0CKI/AN2/GP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='Vref/AN1/GP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AN0/GP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC12CE674-I/P',dest=TEMPLATE,tool=SKIDL,keywords='8-Bit CMOS Microcontroller',description='2048W EPROM, 128B SRAM, 128B EPROM, PDIP8',ref_prefix='U',num_units=1,do_erc=True,aliases=['PIC12CE674-I/JW'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='CLKIN/OSC1/GP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='CLKOUT/OSC2/AN3/GP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/GP3',do_erc=True),
            Pin(num='5',name='INT/T0CKI/AN2/GP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='Vref/AN1/GP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AN0/GP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC12CR509A-I/P',dest=TEMPLATE,tool=SKIDL,keywords='8-Bit CMOS Microcontroller',description='PIC12CR509A, 1024W ROM, 41B SRAM, SO8',ref_prefix='U',num_units=1,do_erc=True,aliases=['PIC12CR509A-I/SM', 'PIC12CR509A-I/SN'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='CLKIN/OSC1/GP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='OSC2/GP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/GP3',do_erc=True),
            Pin(num='5',name='T0CKI/GP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='ICSPCLK/GP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ICSPDAT/GP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC12F508-I/P',dest=TEMPLATE,tool=SKIDL,keywords='FLASH-Based 8-Bit CMOS Microcontroller',description='PIC12F508, 512W Flash, 25B SRAM, SO8',ref_prefix='U',num_units=1,do_erc=True,aliases=['PIC12F508-I/SN', 'PIC12F508-I/MS', 'PIC12F508-I/MC'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='CLKIN/OSC1/GP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='OSC2/GP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/GP3',do_erc=True),
            Pin(num='5',name='T0CKI/GP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='ICSPCLK/GP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ICSPDAT/GP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC12F509-I/P',dest=TEMPLATE,tool=SKIDL,keywords='FLASH-Based 8-Bit CMOS Microcontroller',description='PIC12F509, 1024W Flash, 41B SRAM, SO8',ref_prefix='U',num_units=1,do_erc=True,aliases=['PIC12F509-I/SN', 'PIC12F509-I/MS', 'PIC12F509-I/MC'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='CLKIN/OSC1/GP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='OSC2/GP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/GP3',do_erc=True),
            Pin(num='5',name='T0CKI/GP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='ICSPCLK/GP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ICSPDAT/GP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC12F510-I/P',dest=TEMPLATE,tool=SKIDL,keywords='FLASH-Based 8-Bit CMOS Microcontroller',description='PIC12F510, 1024W FLASH, 38B SRAM, SO8',ref_prefix='U',num_units=1,do_erc=True,aliases=['PIC12F510-I/SN', 'PIC12F510-I/MS', 'PIC12F510-I/MC'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='CLKIN/OSC1/GP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='OSC2/GP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/GP3',do_erc=True),
            Pin(num='5',name='T0CKI/C1OUTI/AN2/GP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='ICSPCLK/C1IN-/AN1/GP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ICSPDAT/C1IN+/AN0/GP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC12F519-I/P',dest=TEMPLATE,tool=SKIDL,keywords='FLASH-Based 8-Bit CMOS Microcontroller',description='PIC12F519, 1024W Flash, 41B SRAM, 64B EEPROM, SO8',ref_prefix='U',num_units=1,do_erc=True,aliases=['PIC12F519-I/SN', 'PIC12F519-I/MS', 'PIC12F519-I/MC'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='CLKIN/OSC1/GP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='OSC2/GP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/GP3',do_erc=True),
            Pin(num='5',name='T0CKI/GP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='ICSPCLK/GP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ICSPDAT/GP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC12F609-I/P',dest=TEMPLATE,tool=SKIDL,keywords='FLASH-Based 8-Bit CMOS Microcontroller',description='PIC12F609, 1024W Flash, 64B SRAM, SO8',ref_prefix='U',num_units=1,do_erc=True,aliases=['PIC12F609-I/SN', 'PIC12F609-I/MS', 'PIC12F609-I/MC'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='T1CKI/CLKIN/OSC1/GP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='CIN1-/~T1G~/CLKOUT/OSC2/GP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/GP3',do_erc=True),
            Pin(num='5',name='T0CKI/INT/COUT/GP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='CIN0-/ICSPCLK/GP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CIN+/ICSPDAT/GP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC12F615-I/P',dest=TEMPLATE,tool=SKIDL,keywords='FLASH-Based 8-Bit CMOS Microcontroller',description='PIC12F615, 1024W Flash, 64B SRAM, SO8',ref_prefix='U',num_units=1,do_erc=True,aliases=['PIC12F615-I/SN', 'PIC12F615-I/MS', 'PIC12F615-I/MC'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='T1CKI/P1A/CLKIN/OSC1/GP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AN3/CIN1-/~T1G~/P1B/CLKOUT/OSC2/GP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/~T1G~/GP3',do_erc=True),
            Pin(num='5',name='AN2/T0CKI/INT/COUT/CCP1/P1A/GP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AN1/CIN0-/Vref/ICSPCLK/GP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AN0/CIN+/P1B/ICSPDAT/GP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC12F617-I/P',dest=TEMPLATE,tool=SKIDL,keywords='FLASH-Based 8-Bit CMOS Microcontroller',description='PIC12F617, 2048W Flash, 128B SRAM, SO8',ref_prefix='U',num_units=1,do_erc=True,aliases=['PIC12F617-I/SN', 'PIC12F617-I/MS', 'PIC12F617-I/MC'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='T1CKI/P1A/CLKIN/OSC1/GP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AN3/CIN1-/~T1G~/P1B/CLKOUT/OSC2/GP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/~T1G~/GP3',do_erc=True),
            Pin(num='5',name='AN2/T0CKI/INT/COUT/CCP1/P1A/GP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AN1/CIN0-/Vref/ICSPCLK/GP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AN0/CIN+/P1B/ICSPDAT/GP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC12F629-I/P',dest=TEMPLATE,tool=SKIDL,keywords='FLASH-Based 8-Bit CMOS Microcontroller',description='PIC12F629, 1024W Flash, 64B SRAM, 128B EEPROM, SO8',ref_prefix='U',num_units=1,do_erc=True,aliases=['PIC12F629-I/SN', 'PIC12F629-I/MS', 'PIC12F629-I/MC'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='T1CKI/CLKIN/OSC1/GP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='~T1G~/CLKOUT/OSC2/GP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/GP3',do_erc=True),
            Pin(num='5',name='T0CKI/INT/COUT/GP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='CIN-/ICSPCLK/GP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CIN+/ICSPDAT/GP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC12F635-I/P',dest=TEMPLATE,tool=SKIDL,keywords='FLASH-Based 8-Bit CMOS Microcontroller',description='PIC12F635, 1024W Flash, 64B SRAM, 128B EEPROM, SO8',ref_prefix='U',num_units=1,do_erc=True,aliases=['PIC12F635-I/SN', 'PIC12F635-I/MS', 'PIC12F635-I/MC'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='T1CKI/CLKIN/OSC1/GP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AN3/~T1G~/CLKOUT/OSC2/GP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/GP3',do_erc=True),
            Pin(num='5',name='AN2/T0CKI/INT/COUT/GP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AN1/CIN-/Vref/ICSPCLK/GP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AN0/CIN+/ICSPDAT/GP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC12F675-I/P',dest=TEMPLATE,tool=SKIDL,keywords='FLASH-Based 8-Bit CMOS Microcontroller',description='PIC12F675, 1024W Flash, 64B SRAM, 128B EEPROM, SO8',ref_prefix='U',num_units=1,do_erc=True,aliases=['PIC12F675-I/SN', 'PIC12F675-I/MS', 'PIC12F675-I/MC'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='T1CKI/CLKIN/OSC1/GP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AN3/~T1G~/CLKOUT/OSC2/GP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/GP3',do_erc=True),
            Pin(num='5',name='AN2/T0CKI/INT/COUT/GP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AN1/CIN-/Vref/ICSPCLK/GP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AN0/CIN+/ICSPDAT/GP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC12F683-I/P',dest=TEMPLATE,tool=SKIDL,keywords='FLASH-Based 8-Bit CMOS Microcontroller',description='PIC12F683, 2048W Flash, 128B SRAM, 256B EEPROM, SO8',ref_prefix='U',num_units=1,do_erc=True,aliases=['PIC12F683-I/SN', 'PIC12F683-I/MS', 'PIC12F683-I/MC'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='T1CKI/CLKIN/OSC1/GP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AN3/~T1G~/CLKOUT/OSC2/GP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/GP3',do_erc=True),
            Pin(num='5',name='AN2/T0CKI/INT/COUT/CCCP1/GP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AN1/CIN-/Vref/ICSPCLK/GP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AN0/CIN+/ICSPDAT/ULPWU/GP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC12F752-I/P',dest=TEMPLATE,tool=SKIDL,keywords='FLASH-Based 8-Bit CMOS Microcontroller',description='PIC12F752, 1024W Flash, 64B SRAM, SO8',ref_prefix='U',num_units=1,do_erc=True,aliases=['PIC12F752-I/SN', 'PIC12F752-I/MC'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='CLKIN/OSC1/GP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='OSC2/GP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/GP3',do_erc=True),
            Pin(num='5',name='T0CKI/GP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='ICSPCLK/GP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ICSPDAT/GP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC12HV609-I/P',dest=TEMPLATE,tool=SKIDL,keywords='FLASH-Based 8-Bit CMOS Microcontroller High Voltage',description='PIC12HV609, 1024W Flash, 64B SRAM, SO8',ref_prefix='U',num_units=1,do_erc=True,aliases=['PIC12HV609-I/SN', 'PIC12HV609-I/MS', 'PIC12HV609-I/MC'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='T1CKI/CLKIN/OSC1/GP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='CIN1-/~T1G~/CLKOUT/OSC2/GP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/GP3',do_erc=True),
            Pin(num='5',name='T0CKI/INT/COUT/GP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='CIN0-/ICSPCLK/GP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='CIN+/ICSPDAT/GP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC12HV615-I/P',dest=TEMPLATE,tool=SKIDL,keywords='FLASH-Based 8-Bit CMOS Microcontroller High Voltage',description='PIC12HV615, 1024W Flash, 64B SRAM, SO8',ref_prefix='U',num_units=1,do_erc=True,aliases=['PIC12HV615-I/SN', 'PIC12HV615-I/MS', 'PIC12HV615-I/MC'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='T1CKI/P1A/CLKIN/OSC1/GP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='AN3/CIN1-/~T1G~/P1B/CLKOUT/OSC2/GP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/~T1G~/GP3',do_erc=True),
            Pin(num='5',name='AN2/T0CKI/INT/COUT/CCP1/P1A/GP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AN1/CIN0-/Vref/ICSPCLK/GP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='AN0/CIN+/P1B/ICSPDAT/GP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC12HV752-I/P',dest=TEMPLATE,tool=SKIDL,keywords='FLASH-Based 8-Bit CMOS Microcontroller High Voltage',description='PIC12HV752, 1024W Flash, 64B SRAM, SO8',ref_prefix='U',num_units=1,do_erc=True,aliases=['PIC12HV752-I/SN', 'PIC12HV752-I/MC'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='CLKIN/OSC1/GP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='OSC2/GP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/GP3',do_erc=True),
            Pin(num='5',name='T0CKI/GP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='ICSPCLK/GP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='ICSPDAT/GP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC12LF1840T48-I/ST',dest=TEMPLATE,tool=SKIDL,keywords='FLASH-Based 8-Bit CMOS Microcontroller XLP RF Transmitter',description='PIC12LF1840T48, 4kW FLASH, 256B SRAM, 256B EEPROM, RF, TSSOP14',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='RX/DT/CCP1/P1A/SRNQ/T1CKI/T1OSI/CLKIN/OSC1/RA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='MDCIN2/T1G/P1B/TX/CK/SDO/CLKR/C1IN1-/T1OSO/CPS3/AN3/CLKOUT/OSC2/RA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/T1G/~SS~/RA3',do_erc=True),
            Pin(num='5',name='VDDRF',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='CTRL',do_erc=True),
            Pin(num='7',name='RFOUT',do_erc=True),
            Pin(num='8',name='VSSRF',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='DATA',do_erc=True),
            Pin(num='10',name='XTAL',do_erc=True),
            Pin(num='11',name='AN2/CPS2/C1OUT/SRQ/T0CKI/CCP1/P1A/FLT0/SDA/SDI/INT/MDCIN1/RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='AN1/CPS1/Vref/C1IN0-/SRI/RX/DT/SCL/SCK/MDMIN/ICSPCLK/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='AN0/CPS0/C1IN+/DACOUT/TX/CK/SDO/~SS~/P1B/MDOUT/ICSPDAT/RA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VSS',func=Pin.PWRIN,do_erc=True)])])
