from skidl import SKIDL, TEMPLATE, Part, Pin, SchLib

SKIDL_lib_version = '0.0.1'

motorola = SchLib(tool=SKIDL).add_parts(*[
        Part(name='68000D',dest=TEMPLATE,tool=SKIDL,keywords='MPRO',description='Microprocesseur bus 16 bits',ref_prefix='U',num_units=1,do_erc=True,aliases=['68010D'],pins=[
            Pin(num='1',name='D4',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='D3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='D2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='D1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='D0',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='UDS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='LDS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='R/W',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='DTACK',do_erc=True),
            Pin(num='20',name='E',func=Pin.OUTPUT,do_erc=True),
            Pin(num='30',name='A2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='40',name='A12',func=Pin.OUTPUT,do_erc=True),
            Pin(num='50',name='A21',func=Pin.OUTPUT,do_erc=True),
            Pin(num='60',name='D9',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='BG',func=Pin.OUTPUT,do_erc=True),
            Pin(num='21',name='VPA',do_erc=True),
            Pin(num='31',name='A3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='41',name='A13',func=Pin.OUTPUT,do_erc=True),
            Pin(num='51',name='A22',func=Pin.OUTPUT,do_erc=True),
            Pin(num='61',name='D8',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='BGACK',do_erc=True),
            Pin(num='22',name='BERR',do_erc=True),
            Pin(num='32',name='A4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='42',name='A14',func=Pin.OUTPUT,do_erc=True),
            Pin(num='52',name='A23',func=Pin.OUTPUT,do_erc=True),
            Pin(num='62',name='D7',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='BR',do_erc=True),
            Pin(num='23',name='IPL2',do_erc=True),
            Pin(num='33',name='A5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='43',name='A15',func=Pin.OUTPUT,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='D6',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='IPL1',do_erc=True),
            Pin(num='34',name='A6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='44',name='A16',func=Pin.OUTPUT,do_erc=True),
            Pin(num='54',name='D15',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='D5',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='CLK',do_erc=True),
            Pin(num='25',name='IPL0',do_erc=True),
            Pin(num='35',name='A7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='45',name='A17',func=Pin.OUTPUT,do_erc=True),
            Pin(num='55',name='D14',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='FC2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='36',name='A8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='46',name='A18',func=Pin.OUTPUT,do_erc=True),
            Pin(num='56',name='D13',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='HALT',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='FC1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='37',name='A9',func=Pin.OUTPUT,do_erc=True),
            Pin(num='47',name='A19',func=Pin.OUTPUT,do_erc=True),
            Pin(num='57',name='D12',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RESET',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='FC0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='38',name='A10',func=Pin.OUTPUT,do_erc=True),
            Pin(num='48',name='A20',func=Pin.OUTPUT,do_erc=True),
            Pin(num='58',name='D11',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VMA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='29',name='A1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='39',name='A11',func=Pin.OUTPUT,do_erc=True),
            Pin(num='49',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='59',name='D10',func=Pin.BIDIR,do_erc=True)]),
        Part(name='68008D',dest=TEMPLATE,tool=SKIDL,keywords='MPRO',description='Microprocesseur bus 8 bits',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='A3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='2',name='A4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='3',name='A5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='4',name='A6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='5',name='A7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='6',name='A8',func=Pin.TRISTATE,do_erc=True),
            Pin(num='7',name='A9',func=Pin.TRISTATE,do_erc=True),
            Pin(num='8',name='A10',func=Pin.TRISTATE,do_erc=True),
            Pin(num='9',name='A11',func=Pin.TRISTATE,do_erc=True),
            Pin(num='10',name='A12',func=Pin.TRISTATE,do_erc=True),
            Pin(num='20',name='D7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='30',name='R/W',func=Pin.TRISTATE,do_erc=True),
            Pin(num='40',name='BERR',do_erc=True),
            Pin(num='11',name='A13',func=Pin.TRISTATE,do_erc=True),
            Pin(num='21',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='31',name='DTACK',do_erc=True),
            Pin(num='41',name='IPL1',do_erc=True),
            Pin(num='12',name='A14',func=Pin.TRISTATE,do_erc=True),
            Pin(num='22',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='32',name='BG',func=Pin.OUTPUT,do_erc=True),
            Pin(num='42',name='IPL0/2',do_erc=True),
            Pin(num='13',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='33',name='BR',do_erc=True),
            Pin(num='43',name='FC2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='A15',func=Pin.TRISTATE,do_erc=True),
            Pin(num='24',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='34',name='CLK',do_erc=True),
            Pin(num='44',name='FC1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='35',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='FC0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='A16',func=Pin.TRISTATE,do_erc=True),
            Pin(num='26',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='36',name='HALT',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='A0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='A17',func=Pin.TRISTATE,do_erc=True),
            Pin(num='27',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='37',name='RESET',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='A1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='18',name='A18',func=Pin.TRISTATE,do_erc=True),
            Pin(num='28',name='AS',func=Pin.TRISTATE,do_erc=True),
            Pin(num='38',name='E',func=Pin.OUTPUT,do_erc=True),
            Pin(num='48',name='A2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='A19',func=Pin.TRISTATE,do_erc=True),
            Pin(num='29',name='DS',func=Pin.TRISTATE,do_erc=True),
            Pin(num='39',name='VPA',do_erc=True)]),
        Part(name='6821',dest=TEMPLATE,tool=SKIDL,keywords='MPRO',description='Interface parallele 2 x 8 bits',ref_prefix='U',num_units=1,do_erc=True,aliases=['6822'],pins=[
            Pin(num='1',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='PA0',do_erc=True),
            Pin(num='3',name='PA1',do_erc=True),
            Pin(num='4',name='PA2',do_erc=True),
            Pin(num='5',name='PA3',do_erc=True),
            Pin(num='6',name='PA4',do_erc=True),
            Pin(num='7',name='PA5',do_erc=True),
            Pin(num='8',name='PA6',do_erc=True),
            Pin(num='9',name='PA7',do_erc=True),
            Pin(num='10',name='PB0',do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='D3',do_erc=True),
            Pin(num='40',name='CA1',do_erc=True),
            Pin(num='11',name='PB1',do_erc=True),
            Pin(num='21',name='R/W',do_erc=True),
            Pin(num='31',name='D2',do_erc=True),
            Pin(num='12',name='PB2',do_erc=True),
            Pin(num='22',name='CS0',do_erc=True),
            Pin(num='32',name='D1',do_erc=True),
            Pin(num='13',name='PB3',do_erc=True),
            Pin(num='23',name='CS2',do_erc=True),
            Pin(num='33',name='D0',do_erc=True),
            Pin(num='14',name='PB4',do_erc=True),
            Pin(num='24',name='CS1',do_erc=True),
            Pin(num='34',name='RESET',do_erc=True),
            Pin(num='15',name='PB5',do_erc=True),
            Pin(num='25',name='ENABLE',do_erc=True),
            Pin(num='35',name='RS1',do_erc=True),
            Pin(num='16',name='PB6',do_erc=True),
            Pin(num='26',name='D7',do_erc=True),
            Pin(num='36',name='RS0',do_erc=True),
            Pin(num='17',name='PB7',do_erc=True),
            Pin(num='27',name='D6',do_erc=True),
            Pin(num='37',name='IRQB',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='18',name='CB1',do_erc=True),
            Pin(num='28',name='D5',do_erc=True),
            Pin(num='38',name='IRQA',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='19',name='CB2',do_erc=True),
            Pin(num='29',name='D4',do_erc=True),
            Pin(num='39',name='CA2',do_erc=True)]),
        Part(name='68230',dest=TEMPLATE,tool=SKIDL,keywords='MPRO',description='PIT Interface parallele et Timer',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='2',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='3',name='D7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='4',name='PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='CLK',do_erc=True),
            Pin(num='11',name='PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='CS',do_erc=True),
            Pin(num='12',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='TIN/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='DTACK',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='13',name='H1',do_erc=True),
            Pin(num='23',name='PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PC3/TOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='R/W',do_erc=True),
            Pin(num='14',name='H2',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='DMAREQ/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='15',name='H3',do_erc=True),
            Pin(num='25',name='RS5',do_erc=True),
            Pin(num='35',name='PC5/PIRQ',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='16',name='H4',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='RS4',do_erc=True),
            Pin(num='36',name='PC6/PIACK',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='17',name='PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='RS3',do_erc=True),
            Pin(num='37',name='PC7/TIACK',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='18',name='PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='RS2',do_erc=True),
            Pin(num='38',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='19',name='PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='RS1',do_erc=True),
            Pin(num='39',name='RESET',do_erc=True)]),
        Part(name='68681',dest=TEMPLATE,tool=SKIDL,keywords='MPRO',description='Interface serie 2 voies + 1 port parallele',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='RS1',do_erc=True),
            Pin(num='2',name='IP3',do_erc=True),
            Pin(num='3',name='RS2',do_erc=True),
            Pin(num='4',name='IP1',do_erc=True),
            Pin(num='5',name='RS3',do_erc=True),
            Pin(num='6',name='RS4',do_erc=True),
            Pin(num='7',name='IP0',do_erc=True),
            Pin(num='8',name='R/W',do_erc=True),
            Pin(num='9',name='DTACK',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='10',name='RXDB',do_erc=True),
            Pin(num='20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='TXDA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='40',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='TXDB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='21',name='IRQ',func=Pin.OUTPUT,do_erc=True),
            Pin(num='31',name='RXDA',do_erc=True),
            Pin(num='12',name='OP1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='22',name='D6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='32',name='X1/CLK',do_erc=True),
            Pin(num='13',name='OP3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='23',name='D4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='33',name='X2',do_erc=True),
            Pin(num='14',name='OP5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='D2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='34',name='RESET',do_erc=True),
            Pin(num='15',name='OP7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='25',name='D0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='35',name='CS',do_erc=True),
            Pin(num='16',name='D1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='26',name='OP6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='36',name='IP2',do_erc=True),
            Pin(num='17',name='D3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='27',name='OP4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='37',name='IACK',do_erc=True),
            Pin(num='18',name='D5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='28',name='OP2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='38',name='IP5',do_erc=True),
            Pin(num='19',name='D7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='29',name='OP0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='39',name='IP4',do_erc=True)]),
        Part(name='68901_PLCC',dest=TEMPLATE,tool=SKIDL,keywords='MPRO',description='Interface parallele',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='2',name='R/W',do_erc=True),
            Pin(num='3',name='RS1',do_erc=True),
            Pin(num='4',name='RS2',do_erc=True),
            Pin(num='5',name='RS3',do_erc=True),
            Pin(num='6',name='RS4',do_erc=True),
            Pin(num='7',name='RS5',do_erc=True),
            Pin(num='8',name='TC',do_erc=True),
            Pin(num='9',name='SO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='SI',do_erc=True),
            Pin(num='20',name='X2',do_erc=True),
            Pin(num='30',name='I5',do_erc=True),
            Pin(num='40',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='DTACK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='RC',do_erc=True),
            Pin(num='31',name='I6',do_erc=True),
            Pin(num='41',name='D0',do_erc=True),
            Pin(num='51',name='DS',do_erc=True),
            Pin(num='12',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='TAI',do_erc=True),
            Pin(num='32',name='I7',do_erc=True),
            Pin(num='42',name='D1',do_erc=True),
            Pin(num='52',name='CS',do_erc=True),
            Pin(num='13',name='MPX',do_erc=True),
            Pin(num='23',name='TBI',do_erc=True),
            Pin(num='43',name='D2',do_erc=True),
            Pin(num='24',name='RESET',do_erc=True),
            Pin(num='34',name='TR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='44',name='D3',do_erc=True),
            Pin(num='15',name='TAO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='25',name='I0',do_erc=True),
            Pin(num='35',name='RR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='45',name='D4',do_erc=True),
            Pin(num='16',name='TBO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='26',name='I1',do_erc=True),
            Pin(num='36',name='IRQ',func=Pin.OUTPUT,do_erc=True),
            Pin(num='46',name='D5',do_erc=True),
            Pin(num='17',name='TCO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='27',name='I2',do_erc=True),
            Pin(num='37',name='IEO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='47',name='D6',do_erc=True),
            Pin(num='18',name='TDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='28',name='I3',do_erc=True),
            Pin(num='38',name='IEI',do_erc=True),
            Pin(num='48',name='D7',do_erc=True),
            Pin(num='19',name='X1',do_erc=True),
            Pin(num='29',name='I4',do_erc=True),
            Pin(num='39',name='CLK',do_erc=True),
            Pin(num='49',name='IACK',do_erc=True)]),
        Part(name='68C681',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='68HC11',dest=TEMPLATE,tool=SKIDL,keywords='MPRO',description='Microprocesseur monoboitier',ref_prefix='U',num_units=1,do_erc=True,aliases=['68HC11A8'],pins=[
            Pin(num='1',name='PAI/PA7',do_erc=True),
            Pin(num='2',name='OC2/PA6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='OC3/PA5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='OC4/PA4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='OC5/PA3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='IC1/PA2',do_erc=True),
            Pin(num='7',name='IC2/PA1',do_erc=True),
            Pin(num='8',name='IC3/PA0',do_erc=True),
            Pin(num='9',name='A15/PB7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='PB6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='20',name='PE3',do_erc=True),
            Pin(num='30',name='XTAL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='40',name='XIRQ',do_erc=True),
            Pin(num='11',name='PB5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='21',name='VRL',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='AD0/PC0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='41',name='IRQ',do_erc=True),
            Pin(num='12',name='PB4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='22',name='VRH',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='PC1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='42',name='PD0/RX',do_erc=True),
            Pin(num='13',name='PB3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='PC2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='43',name='PD1/TX',do_erc=True),
            Pin(num='14',name='PB2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='MODB',do_erc=True),
            Pin(num='34',name='PC3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='44',name='PD2/MISO',do_erc=True),
            Pin(num='15',name='PB1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='25',name='MODA',do_erc=True),
            Pin(num='35',name='PC4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='45',name='PD3/MOSI',do_erc=True),
            Pin(num='16',name='A8/PB0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='26',name='AS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='36',name='PC5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='46',name='PD4/SCLK',do_erc=True),
            Pin(num='17',name='PE0',do_erc=True),
            Pin(num='27',name='E',func=Pin.OUTPUT,do_erc=True),
            Pin(num='37',name='PC6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='47',name='PD5/SS-',do_erc=True),
            Pin(num='18',name='PE1',do_erc=True),
            Pin(num='28',name='R/W',func=Pin.OUTPUT,do_erc=True),
            Pin(num='38',name='AD7/PC7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='48',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='PE2',do_erc=True),
            Pin(num='29',name='EXTAL',do_erc=True),
            Pin(num='39',name='RESET',do_erc=True)]),
        Part(name='68HC11F1',dest=TEMPLATE,tool=SKIDL,keywords='MPRO',description='Microprocesseur monoboitier (version PLCC 68 pins)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='MODB/STBY',do_erc=True),
            Pin(num='3',name='MODA/LR',do_erc=True),
            Pin(num='4',name='E',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='R/W',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='EXTAL',do_erc=True),
            Pin(num='7',name='XTAL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='4XOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='D0/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='CSPROG/PG7',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PD2/MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='IC1/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='A8/PB0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='60',name='PE4',do_erc=True),
            Pin(num='11',name='PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='CSGEN/PG6',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PD3/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='IC2/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='A7/PF7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PE1',do_erc=True),
            Pin(num='12',name='PC3',do_erc=True),
            Pin(num='22',name='CSIO1/PG5',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PD4/SCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='IC3/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PF6',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='PE5',do_erc=True),
            Pin(num='13',name='PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='CSIO2/PG4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PD5/SS-',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='A15/PB7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='53',name='PF5',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='PE2',do_erc=True),
            Pin(num='14',name='PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PG3',do_erc=True),
            Pin(num='34',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='PB6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='54',name='PF4',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='PE6',do_erc=True),
            Pin(num='15',name='PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PG2',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PA1/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PB5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='55',name='PF3',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='PE3',do_erc=True),
            Pin(num='16',name='D7/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PG1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='OC2/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PB4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='56',name='PF2',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='PE7',do_erc=True),
            Pin(num='17',name='RESET',do_erc=True),
            Pin(num='27',name='PG0',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='OC3/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='PB3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='57',name='PF1',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='VRL',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='XIRQ',do_erc=True),
            Pin(num='28',name='PD0/RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='OC4/PA4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='48',name='PB2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='58',name='A0/PF0',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='VRH',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='IRQ',do_erc=True),
            Pin(num='29',name='PD1/TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='OC5/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PB1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='59',name='PE0',do_erc=True)]),
        Part(name='68HC11_PLCC',dest=TEMPLATE,tool=SKIDL,keywords='MPRO',description='Microprocesseur monoboitier (version PLCC 52 pins)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='MODB',do_erc=True),
            Pin(num='3',name='MODA',do_erc=True),
            Pin(num='4',name='AS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='E',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='R/W',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='EXTAL',do_erc=True),
            Pin(num='8',name='XTAL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='AD0/PC0',func=Pin.TRISTATE,do_erc=True),
            Pin(num='10',name='AD1/PC1',func=Pin.TRISTATE,do_erc=True),
            Pin(num='20',name='PD0/RX',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='OC4/PA4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='40',name='PB2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='50',name='PE7',do_erc=True),
            Pin(num='11',name='AD2/PC2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='21',name='PD1/TX',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='OC5/PA3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='41',name='PB1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='51',name='VRL',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='AD3/PC3',func=Pin.TRISTATE,do_erc=True),
            Pin(num='22',name='PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='IC1/PA2',do_erc=True),
            Pin(num='42',name='A8/PB0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='52',name='VRH',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='AD4/PC4',func=Pin.TRISTATE,do_erc=True),
            Pin(num='23',name='PD3',do_erc=True),
            Pin(num='33',name='IC2/PA1',do_erc=True),
            Pin(num='43',name='PE0',do_erc=True),
            Pin(num='14',name='AD5/PC5',func=Pin.TRISTATE,do_erc=True),
            Pin(num='24',name='PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IC3/PA0',do_erc=True),
            Pin(num='44',name='PE4',do_erc=True),
            Pin(num='15',name='AD6/PC6',func=Pin.TRISTATE,do_erc=True),
            Pin(num='25',name='PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='A15/PB7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='45',name='PE1',do_erc=True),
            Pin(num='16',name='AD7/PC7',func=Pin.TRISTATE,do_erc=True),
            Pin(num='26',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='PB6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='46',name='PE5',do_erc=True),
            Pin(num='17',name='RESET',do_erc=True),
            Pin(num='27',name='PA1/PA7',do_erc=True),
            Pin(num='37',name='PB5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='47',name='PE2',do_erc=True),
            Pin(num='18',name='XIRQ',do_erc=True),
            Pin(num='28',name='OC2/PA6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='38',name='PB4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='48',name='PE6',do_erc=True),
            Pin(num='19',name='IRQ',do_erc=True),
            Pin(num='29',name='OC3/PA5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='39',name='PB3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='49',name='PE3',do_erc=True)]),
        Part(name='68HC711_PLCC',dest=TEMPLATE,tool=SKIDL,keywords='MPRO',description='Microprocesseur monoboitier Reprom interne (version PLCC 44 pins)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='EVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='PC0',do_erc=True),
            Pin(num='4',name='PC1',do_erc=True),
            Pin(num='5',name='PC2',do_erc=True),
            Pin(num='6',name='PC3',do_erc=True),
            Pin(num='7',name='PC4',do_erc=True),
            Pin(num='8',name='PC5',do_erc=True),
            Pin(num='9',name='PC6',do_erc=True),
            Pin(num='10',name='PC7',do_erc=True),
            Pin(num='20',name='PD4',do_erc=True),
            Pin(num='30',name='IC3/PA0',do_erc=True),
            Pin(num='40',name='MODB',do_erc=True),
            Pin(num='11',name='XIRQ/VPP',do_erc=True),
            Pin(num='21',name='PD5',do_erc=True),
            Pin(num='41',name='MODA',do_erc=True),
            Pin(num='12',name='PD7-R/W',func=Pin.OUTPUT,do_erc=True),
            Pin(num='22',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='PB7/OE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='42',name='E',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='PD6-AS',do_erc=True),
            Pin(num='23',name='PA1/PA7',do_erc=True),
            Pin(num='33',name='PB6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='43',name='EXTAL',do_erc=True),
            Pin(num='14',name='RESET',do_erc=True),
            Pin(num='24',name='OC2/PA6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='34',name='PB5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='44',name='XTAL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='IRQ/CE',do_erc=True),
            Pin(num='25',name='OC3/PA5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='35',name='PB4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='PD0/RX',do_erc=True),
            Pin(num='26',name='OC4/PA4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='36',name='PB3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='PD1/TX',do_erc=True),
            Pin(num='27',name='OC5/PA3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='37',name='PB2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='PD2',do_erc=True),
            Pin(num='28',name='IC1/PA2',do_erc=True),
            Pin(num='38',name='PB1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='PD3',do_erc=True),
            Pin(num='29',name='IC2/PA1',do_erc=True),
            Pin(num='39',name='PB0',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='DSP56301',dest=TEMPLATE,tool=SKIDL,keywords='DSP PCI',description='DSP with PCI bus interface',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='AA0/RAS0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='AA1/RAS1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='CLKOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='BCLK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='/CAS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='/TA',do_erc=True),
            Pin(num='9',name='PINIT/NMI',do_erc=True),
            Pin(num='10',name='/RESET',do_erc=True),
            Pin(num='20',name='AA2/RAS2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='30',name='A1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='40',name='A7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='50',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='60',name='A19',func=Pin.OUTPUT,do_erc=True),
            Pin(num='70',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='80',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='90',name='D15',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VCCPLL',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='AA3/RAS3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='31',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='A8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='51',name='A14',func=Pin.OUTPUT,do_erc=True),
            Pin(num='61',name='A20',func=Pin.OUTPUT,do_erc=True),
            Pin(num='71',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='81',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='91',name='D16',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PCAP',do_erc=True),
            Pin(num='22',name='/WR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='32',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='42',name='A9',func=Pin.OUTPUT,do_erc=True),
            Pin(num='52',name='A15',func=Pin.OUTPUT,do_erc=True),
            Pin(num='62',name='A21',func=Pin.OUTPUT,do_erc=True),
            Pin(num='72',name='D3',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='D9',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='D17',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='GNDP',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='/RD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='33',name='A2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='43',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='73',name='D4',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='D10',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='D18',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='GND1P',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='XTAL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='34',name='A3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='44',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='D5',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='D11',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='D19',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='/BB',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='A4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='45',name='A10',func=Pin.OUTPUT,do_erc=True),
            Pin(num='55',name='A16',func=Pin.OUTPUT,do_erc=True),
            Pin(num='65',name='A22',func=Pin.OUTPUT,do_erc=True),
            Pin(num='75',name='D6',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='D12',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='D20',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='/BG',do_erc=True),
            Pin(num='26',name='EXTAL',do_erc=True),
            Pin(num='36',name='A5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='46',name='A11',func=Pin.OUTPUT,do_erc=True),
            Pin(num='56',name='A17',func=Pin.OUTPUT,do_erc=True),
            Pin(num='66',name='A23',func=Pin.OUTPUT,do_erc=True),
            Pin(num='76',name='D7',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='D13',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='/BR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='27',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='A12',func=Pin.OUTPUT,do_erc=True),
            Pin(num='57',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='67',name='D0',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='D8',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='D14',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='/BCLK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='A13',func=Pin.OUTPUT,do_erc=True),
            Pin(num='58',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='68',name='D1',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='88',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='98',name='D21',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='A0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='39',name='A6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='49',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='59',name='A18',func=Pin.OUTPUT,do_erc=True),
            Pin(num='69',name='D2',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='89',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='D22',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='D23',func=Pin.BIDIR,do_erc=True),
            Pin(num='200',name='TMS',do_erc=True),
            Pin(num='110',name='HAD28',func=Pin.BIDIR,do_erc=True),
            Pin(num='120',name='HAD21',func=Pin.BIDIR,do_erc=True),
            Pin(num='130',name='/HFRAME',func=Pin.BIDIR,do_erc=True),
            Pin(num='140',name='/HLOCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='150',name='HC1/HBE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='160',name='HAD10',func=Pin.BIDIR,do_erc=True),
            Pin(num='170',name='HAD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='180',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='190',name='PD4/SRD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='101',name='MODA/IRQA',do_erc=True),
            Pin(num='201',name='TCK',do_erc=True),
            Pin(num='111',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='121',name='HAD20',func=Pin.BIDIR,do_erc=True),
            Pin(num='131',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='141',name='/HPERR',func=Pin.BIDIR,do_erc=True),
            Pin(num='151',name='HAD15',func=Pin.BIDIR,do_erc=True),
            Pin(num='161',name='HAD9',func=Pin.BIDIR,do_erc=True),
            Pin(num='171',name='HAD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='181',name='/HINTA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='191',name='PC4/SRD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='102',name='MODB/IRQB',do_erc=True),
            Pin(num='202',name='TDI',do_erc=True),
            Pin(num='112',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='122',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='132',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='142',name='/HSERR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='152',name='HAD14',func=Pin.BIDIR,do_erc=True),
            Pin(num='162',name='HAD8',func=Pin.BIDIR,do_erc=True),
            Pin(num='172',name='HAD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='182',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='192',name='PC3/SCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='203',name='TDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='113',name='HAD27',func=Pin.BIDIR,do_erc=True),
            Pin(num='123',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='133',name='/HIRDY',func=Pin.BIDIR,do_erc=True),
            Pin(num='143',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='153',name='HAD13',func=Pin.BIDIR,do_erc=True),
            Pin(num='163',name='HC0/HBE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='173',name='HAD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='183',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='193',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='204',name='/TRST',do_erc=True),
            Pin(num='114',name='HAD26',func=Pin.BIDIR,do_erc=True),
            Pin(num='124',name='HAD19',func=Pin.BIDIR,do_erc=True),
            Pin(num='134',name='/HTRDY',func=Pin.BIDIR,do_erc=True),
            Pin(num='144',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='154',name='HAD12',func=Pin.BIDIR,do_erc=True),
            Pin(num='164',name='HAD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='174',name='TIO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='184',name='PE1/TXD',func=Pin.BIDIR,do_erc=True),
            Pin(num='194',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='105',name='MODC/IRQC',do_erc=True),
            Pin(num='205',name='/BS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='115',name='HAD25',func=Pin.BIDIR,do_erc=True),
            Pin(num='125',name='HAD18',func=Pin.BIDIR,do_erc=True),
            Pin(num='135',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='145',name='HPAR',func=Pin.BIDIR,do_erc=True),
            Pin(num='155',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='165',name='HAD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='175',name='TIO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='185',name='PD2/SC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='195',name='PC5/STD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='106',name='MODD/IRQD',do_erc=True),
            Pin(num='206',name='/BL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='116',name='HAD24',func=Pin.BIDIR,do_erc=True),
            Pin(num='126',name='HAD17',func=Pin.BIDIR,do_erc=True),
            Pin(num='136',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='146',name='/HREQ',func=Pin.OUTPUT,do_erc=True),
            Pin(num='156',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='166',name='HAD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='176',name='TIO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='186',name='PD1/SC11',func=Pin.BIDIR,do_erc=True),
            Pin(num='196',name='PC0/SC00',func=Pin.BIDIR,do_erc=True),
            Pin(num='107',name='HAD31',func=Pin.BIDIR,do_erc=True),
            Pin(num='117',name='HC3/HBE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='127',name='HAD16',func=Pin.BIDIR,do_erc=True),
            Pin(num='137',name='PVCL',do_erc=True),
            Pin(num='147',name='/HRST',do_erc=True),
            Pin(num='167',name='HAD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='177',name='PE0/RXD',func=Pin.BIDIR,do_erc=True),
            Pin(num='187',name='PD0/SC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='197',name='PC1/SC01',func=Pin.BIDIR,do_erc=True),
            Pin(num='108',name='HAD30',func=Pin.BIDIR,do_erc=True),
            Pin(num='118',name='HAD23',func=Pin.BIDIR,do_erc=True),
            Pin(num='128',name='HC2/HBE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='138',name='/HDEVSEL',func=Pin.BIDIR,do_erc=True),
            Pin(num='148',name='HCLK',do_erc=True),
            Pin(num='168',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='178',name='PE2/SCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='188',name='PD5/STD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='198',name='PC2/SC02',func=Pin.BIDIR,do_erc=True),
            Pin(num='109',name='HAD29',func=Pin.BIDIR,do_erc=True),
            Pin(num='119',name='HAD22',func=Pin.BIDIR,do_erc=True),
            Pin(num='129',name='HIDSEL',do_erc=True),
            Pin(num='139',name='/HSTOP',func=Pin.BIDIR,do_erc=True),
            Pin(num='149',name='/HGNT',do_erc=True),
            Pin(num='159',name='HAD11',func=Pin.BIDIR,do_erc=True),
            Pin(num='169',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='179',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='189',name='PD3/SCK1',func=Pin.BIDIR,do_erc=True),
            Pin(num='199',name='/DE',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='MAC7101',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='MAC7111',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='MC13192',dest=TEMPLATE,tool=SKIDL,keywords='ZIGBEE',description='Zigbee controller',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='RFIN-',do_erc=True),
            Pin(num='2',name='RFIN+',do_erc=True),
            Pin(num='3',name='TINJ_P',do_erc=True),
            Pin(num='4',name='TINJ_M',do_erc=True),
            Pin(num='5',name='PAO_P',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='6',name='PAO_M',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='7',name='SM',do_erc=True),
            Pin(num='8',name='GPIO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='GPIO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GPIO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='IRQBo',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='30',name='VDDVCO',func=Pin.PWROUT,do_erc=True),
            Pin(num='11',name='GPIO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VDDD',func=Pin.PWROUT,do_erc=True),
            Pin(num='31',name='VBATT',do_erc=True),
            Pin(num='12',name='RSTBi',do_erc=True),
            Pin(num='22',name='VDDIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='VDDA',func=Pin.PWROUT,do_erc=True),
            Pin(num='13',name='RXTXENi',do_erc=True),
            Pin(num='23',name='GPIO5',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='ATTNBi',do_erc=True),
            Pin(num='24',name='GPIO6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='CLKOo',func=Pin.OUTPUT,do_erc=True),
            Pin(num='25',name='GPIO7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='SPICLKi',do_erc=True),
            Pin(num='26',name='XTALin',do_erc=True),
            Pin(num='17',name='MOSIi',do_erc=True),
            Pin(num='27',name='XTALout',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='MISOo',func=Pin.TRISTATE,do_erc=True),
            Pin(num='28',name='VDDLO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='CEBi',do_erc=True),
            Pin(num='29',name='VDDLO1',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MC68000FN',dest=TEMPLATE,tool=SKIDL,keywords='MPRO',description='Microprocessor, 16-bit bus',ref_prefix='U',num_units=1,fplist=['PLCC*'],do_erc=True,pins=[
            Pin(num='1',name='D4',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='D3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='D2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='D1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='D0',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='AS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='UDS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='LDS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='R/W',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='DTACK',do_erc=True),
            Pin(num='20',name='RESET',do_erc=True),
            Pin(num='30',name='FC0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='40',name='A9',func=Pin.OUTPUT,do_erc=True),
            Pin(num='50',name='A19',func=Pin.OUTPUT,do_erc=True),
            Pin(num='60',name='D13',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='BG',func=Pin.OUTPUT,do_erc=True),
            Pin(num='21',name='VMA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='31',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='41',name='A10',func=Pin.OUTPUT,do_erc=True),
            Pin(num='51',name='A20',func=Pin.OUTPUT,do_erc=True),
            Pin(num='61',name='D12',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='BGACK',do_erc=True),
            Pin(num='22',name='E',func=Pin.OUTPUT,do_erc=True),
            Pin(num='32',name='A1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='42',name='A11',func=Pin.OUTPUT,do_erc=True),
            Pin(num='52',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='D11',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='BR',do_erc=True),
            Pin(num='23',name='VPA',do_erc=True),
            Pin(num='33',name='A2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='43',name='A12',func=Pin.OUTPUT,do_erc=True),
            Pin(num='53',name='A21',func=Pin.OUTPUT,do_erc=True),
            Pin(num='63',name='D10',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='BERR',do_erc=True),
            Pin(num='34',name='A3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='44',name='A13',func=Pin.OUTPUT,do_erc=True),
            Pin(num='54',name='A22',func=Pin.OUTPUT,do_erc=True),
            Pin(num='64',name='D9',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='CLK',do_erc=True),
            Pin(num='25',name='IPL2',do_erc=True),
            Pin(num='35',name='A4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='45',name='A14',func=Pin.OUTPUT,do_erc=True),
            Pin(num='55',name='A23',func=Pin.OUTPUT,do_erc=True),
            Pin(num='65',name='D8',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='IPL1',do_erc=True),
            Pin(num='36',name='A5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='46',name='A15',func=Pin.OUTPUT,do_erc=True),
            Pin(num='56',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='66',name='D7',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='IPL0',do_erc=True),
            Pin(num='37',name='A6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='47',name='A16',func=Pin.OUTPUT,do_erc=True),
            Pin(num='57',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='67',name='D6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='28',name='FC2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='38',name='A7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='48',name='A17',func=Pin.OUTPUT,do_erc=True),
            Pin(num='58',name='D15',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='D5',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='HALT',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='FC1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='39',name='A8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='49',name='A18',func=Pin.OUTPUT,do_erc=True),
            Pin(num='59',name='D14',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MC68332',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='MC68HC812A4',dest=TEMPLATE,tool=SKIDL,description='micropro. Motorola 68HC12 112 pins',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='VSSX',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VDDX',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='PJ0/KWUJ0',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PJ1/KWUJ1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PJ2/KWUJ2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PJ3/KWUJ3',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PJ4/KWUJ4',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PJ5/KWUJ5',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PJ6/KWUJ6',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PJ7/KWUJ7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PD0/D0/KWUD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PC2/D10/D2',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='RESET',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='PE6/MODB/IPIPE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='PA0/A8',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='PF2/CS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='VSSX',func=Pin.PWRIN,do_erc=True),
            Pin(num='90',name='PAD3',do_erc=True),
            Pin(num='11',name='PG0/A16',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='PD1/D1/KWUD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='PC3/D11/D3',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='VSSX',func=Pin.PWRIN,do_erc=True),
            Pin(num='51',name='PE7/ARST',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='PA1/A9',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='PF3/CS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='PH4/KWUH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='PAD4',do_erc=True),
            Pin(num='12',name='PG1/A17',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PD2/D2/KWUD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='PC4/D12/D4',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='VDDX',func=Pin.PWRIN,do_erc=True),
            Pin(num='52',name='PB0/A0',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='PA2/A10',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='PF4/CSD',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='PH5/KWUH5',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='PAD5',do_erc=True),
            Pin(num='13',name='PG2/A18',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PD3/D3/KWUD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PC5/D13/D5',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='VDDPLL',do_erc=True),
            Pin(num='53',name='PB1/A1',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='PA3/A11',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='PF5/CSP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='PH6/KWUH6',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='PAD6',do_erc=True),
            Pin(num='14',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='PD4/D4/KWUD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PC6/D14/D6',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='XFC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='54',name='PB2/A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='PA4/A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='PF6/CSP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='PH7/KWUH7',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='VSTBY/PAD7',do_erc=True),
            Pin(num='15',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='PD5/D5/KWUD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PC7/D15/D7',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='VSSPLL',do_erc=True),
            Pin(num='55',name='PB3/A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='PA5/A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='PH0/KWUH0',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='VRH',do_erc=True),
            Pin(num='95',name='VDDAD',do_erc=True),
            Pin(num='16',name='PG3/A19',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PD6/D6/KWUD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PE0/XIRQ',do_erc=True),
            Pin(num='46',name='EXTAL',do_erc=True),
            Pin(num='56',name='PB4/A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='PA6/A14',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='PH1/KWUH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='VRL',do_erc=True),
            Pin(num='96',name='VSSAD',do_erc=True),
            Pin(num='17',name='PG4/A20',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PD7/D7/KWUD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PE1/IRQ',do_erc=True),
            Pin(num='47',name='XTAL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='57',name='PB5/A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='PA7/A15',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='PH2/KWUH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='PAD0',do_erc=True),
            Pin(num='97',name='PS0/RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='PG5/A21',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PC0/D8/D0',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE2/RW',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='PE4/ECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='PB6/A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='PF0/CS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='PH3/KWUH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='PAD1',do_erc=True),
            Pin(num='98',name='PS1/TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='BKGD/TAGHI',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PC1/D9/D1',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PE3/LSTRB/TAGL0',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='PE5/MODA/IPIPE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='PB7/A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='PF1/CS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='VDDX',func=Pin.PWRIN,do_erc=True),
            Pin(num='89',name='PAD2',do_erc=True),
            Pin(num='99',name='PS2/RXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='PS3/TXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='110',name='PT5/IOC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='101',name='PS4/SDI/MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='111',name='PT6/IOC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='102',name='PS5/SDO/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='112',name='PT7/IOC7/PAI',func=Pin.BIDIR,do_erc=True),
            Pin(num='103',name='PS6/SCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='104',name='PS7/SS',func=Pin.BIDIR,do_erc=True),
            Pin(num='105',name='PT0/IOC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='106',name='PT1/IOC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='107',name='PT2/IOC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='108',name='PT3/IOC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='109',name='PT4/IOC4',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MC68HC912',dest=TEMPLATE,tool=SKIDL,description='HCMC68HC12 a flash eprom interne',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PP5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PP3/PW3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PP2/PW3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PP1/PW1',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PP0/PW0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PT0-IOC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PT1-IOC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PT2-IOC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='PB2/AD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='VSSX',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='PA1/D9/A9',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='VRL',do_erc=True),
            Pin(num='60',name='VSSA',do_erc=True),
            Pin(num='70',name='PDLC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='PP6',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='PB3/AD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VDDX',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='PA2/AD10',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='PAD0',do_erc=True),
            Pin(num='61',name='PS0/RxD',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='PDLC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='PT3-IOC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='PB4/AD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='RST',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PA3/AD11',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='PAD1',do_erc=True),
            Pin(num='62',name='PS1/TxD',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='PDLC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='PT4-IOC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='PB5/AD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='EXTAL',do_erc=True),
            Pin(num='43',name='PA4/AD12',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='PAD2',do_erc=True),
            Pin(num='63',name='PS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='PDLC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='PT5-IOC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PB6/AD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='XTAL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='44',name='PA5/AD13',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='PAD3',do_erc=True),
            Pin(num='64',name='PS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='PDLC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='PT6-IOC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PB7/AD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PE3/LSTRB/TAGLO',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='PA6/AD14',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='PAD4',do_erc=True),
            Pin(num='65',name='PS4SDI/MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='PDLC1/DLCTx',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='PT7-IOC7-PAI',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PE7/DBE',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PE2-R/W',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='PA7/AD15',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='PAD5',do_erc=True),
            Pin(num='66',name='PS5/SD0/MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='PDLC0/DLCRx',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='BKGD/SMODN/TAGHI',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PE6-MODB/IPIPE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='PE1/IRQ',do_erc=True),
            Pin(num='47',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='57',name='PAD6',do_erc=True),
            Pin(num='67',name='PS6/SCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='VSSX',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='PB0/AD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PE5-MODA/IPIPE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PE0/XIRQ',do_erc=True),
            Pin(num='48',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='58',name='PAD7',do_erc=True),
            Pin(num='68',name='PS7/CS/SS',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='VDDX',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='PB1/AD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PE4-ECLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='PA0/AD8',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='VRH',do_erc=True),
            Pin(num='59',name='VDDA',do_erc=True),
            Pin(num='69',name='VFP',do_erc=True),
            Pin(num='79',name='PP7',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MC9S12DT256',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='MCF5212-LQFP64',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='MCF5213-LQFP100',dest=TEMPLATE,tool=SKIDL,keywords='COLDFIRE',description='Coldfire with SRAM and Flash Eprom - LQFP100 package',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~URTS1~/SYNCB/UTXD2/PUB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='TEST',do_erc=True),
            Pin(num='6',name='~UCTS0~/CANRX/PUA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='URXD0/PUA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='UTXD0/PUA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='~URTS0~/CANTX/PUA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='SCL/CANTX/PAS0/UTXD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='QSPI_CS0/SDA/CTS1/PQS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='~URTS2~/PUC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='CLKMOD0',do_erc=True),
            Pin(num='50',name='VCCA',do_erc=True),
            Pin(num='60',name='PWM5/PTD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='PST3/PDD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='DSO/TDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='90',name='~IRQ4~/PNQ4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='SDA/CANRX/PAS1/URXD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='RCON/EZPCS',do_erc=True),
            Pin(num='31',name='DTIN2/DTOUT2/PWM4/PTC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='51',name='AN7/PAN7',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='GPT2PWM5//PTA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='GNDPLL',func=Pin.PASSIVE,do_erc=True),
            Pin(num='81',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='91',name='~IRQ5~/PNQ5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='QSPI_CS3/SYNCA/SYNCB/PQS6',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='DTIN3/DTOUT3/PWM6/PTC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='52',name='AN6/PAN6',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='GPT3/PWM7/PTA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='XTAL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='82',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='92',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='QSPI_CS2/PQS5',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='PWM3/PTD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='AN0/PAN0',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='AN5/PAN5',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='PWM7/PTD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='CLKIN/EXTAL',do_erc=True),
            Pin(num='83',name='DDATA2/PDD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='AN1/PAN1',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='AN4/PAN4',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='TCLK/PSTCLK/CLKOUT',do_erc=True),
            Pin(num='74',name='VCCPLL',func=Pin.PASSIVE,do_erc=True),
            Pin(num='84',name='DDATA3/PDD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='~IRQ6~/PNQ6',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='25',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='AN2/PAN2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='VSTBY',func=Pin.PWRIN,do_erc=True),
            Pin(num='65',name='PST0/PDD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='85',name='DSCLK/~TRST~',do_erc=True),
            Pin(num='95',name='~IRQ7~/PNQ7',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='QSPI_DIN/EZPD/CANRX/RXD1/PQS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='JTAG_EN',do_erc=True),
            Pin(num='36',name='DTIN0/DTOUT0/PWM0/PTC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='AN3/PAN3',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='66',name='PST1/PDD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='~BKPT~/TMS',do_erc=True),
            Pin(num='86',name='ALLPST',func=Pin.OUTPUT,do_erc=True),
            Pin(num='96',name='RSTI',do_erc=True),
            Pin(num='17',name='QSPI_DOUT/EZPQ/CANTX/RXD0/PQS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='~UCTS2~/PUC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='DTIN1/DTOUT1/PWM2/PTC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='VSSA',do_erc=True),
            Pin(num='57',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='67',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='77',name='DDATA0/PDD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='~IRQ1~/PNQ1/SYNCA/PWM1',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='RSTO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='QSPI_CLK/EZPCK/SCL/RTS1/PQS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='URXD2/PUC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PWM1/PTD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='VRL',do_erc=True),
            Pin(num='58',name='GPT0/PWM1/PTA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='78',name='DDATA1/PDD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='~IRQ2~/PNQ2',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='~UCTS1~/SYNCA/URXD2/PUB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='QSPI_CS1/PQS4',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='UTXD2/PUC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='CLKMOD1',do_erc=True),
            Pin(num='49',name='VRH',do_erc=True),
            Pin(num='59',name='GPT1/PWM3/PTA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='PST2/PDD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='DSI/TDI',do_erc=True),
            Pin(num='89',name='~IRQ3~/PNQ3',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='UTXD1/PUB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='URXD1/PUB1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MCF5282',dest=TEMPLATE,tool=SKIDL,keywords='COLDFIRE',description='Coldfire with SRAM and Flash Eprom',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='A1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B1',name='A14/PG6',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='A12/PG4',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='A9/PG1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='A5/PH5',func=Pin.BIDIR,do_erc=True),
            Pin(num='F1',name='A1/PH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='D30/PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='H1',name='D26/PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='J1',name='D22/PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='K1',name='D18/PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='L1',name='D15/PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='M1',name='D11/PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='N1',name='D7/PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='P1',name='D4/PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='R1',name='AN3/PQB3/ANZ',func=Pin.BIDIR,do_erc=True),
            Pin(num='T1',name='VSSA',do_erc=True),
            Pin(num='A2',name='A15/PG7',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='A13/PG5',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='A11/PG3',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='A8/PG0',func=Pin.BIDIR,do_erc=True),
            Pin(num='E2',name='A4/PH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='A0/PH0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G2',name='D29/PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='D25/PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J2',name='D21/PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='K2',name='D17/PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='L2',name='D14/PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='M2',name='D10/PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='N2',name='D6/PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='P2',name='VDDH',func=Pin.PWRIN,do_erc=True),
            Pin(num='R2',name='AN1/PQB1/ANX',func=Pin.BIDIR,do_erc=True),
            Pin(num='T2',name='AN2/PQB2/ANY',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='A16/PF0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='A17/PF1',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='A10/PG2',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='A7/PH7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='A3/PH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='D31/PA7',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='D28/PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='D24/PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='J3',name='D20/PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='K3',name='D16/PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='L3',name='D13/PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='M3',name='D9/PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='N3',name='D5/PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='P3',name='AN55/PQA3/ETRIG1',func=Pin.BIDIR,do_erc=True),
            Pin(num='R3',name='AN56/PQA4/ETRIG2',func=Pin.BIDIR,do_erc=True),
            Pin(num='T3',name='AN0/PQB0/ANW',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='A18/PF2',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='A19/PF3',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='A20/PF4',func=Pin.BIDIR,do_erc=True),
            Pin(num='D4',name='A6/PH6',func=Pin.BIDIR,do_erc=True),
            Pin(num='E4',name='A2/PH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='G4',name='D27/PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='D23/PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='J4',name='D19/PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='L4',name='D12/PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='M4',name='D8/PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='P4',name='VRH',do_erc=True),
            Pin(num='R4',name='AN52/PQA0/MA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='T4',name='AN53/PQA1/MA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='A21/PF5/~CS4~',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='GNDF',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C5',name='VDDF',func=Pin.PWRIN,do_erc=True),
            Pin(num='D5',name='VDDF',func=Pin.PWRIN,do_erc=True),
            Pin(num='E5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='G5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='H5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='J5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='K5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='L5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='M5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N5',name='D3/PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='P5',name='VSSA',do_erc=True),
            Pin(num='R5',name='VCCA',do_erc=True),
            Pin(num='T5',name='VRL',do_erc=True),
            Pin(num='A6',name='VPP',func=Pin.PWRIN,do_erc=True),
            Pin(num='B6',name='A22/PF6/~CS5~',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='A23/PF7/~CS6~',func=Pin.BIDIR,do_erc=True),
            Pin(num='D6',name='ETXEN/PEH6',func=Pin.BIDIR,do_erc=True),
            Pin(num='E6',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='F6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G6',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='H6',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='J6',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='K6',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='L6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='M6',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='N6',name='URXD0/PUA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='P6',name='D0/PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='R6',name='D1/PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='T6',name='D2/PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='ETXD3/PEL7',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='ETXD2/PEL6',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='ETXD1/PEL5',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='ETXD0/PEH5',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='F7',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='G7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='K7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='L7',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='M7',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='N7',name='CLKOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='P7',name='UTXD1/PUA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='R7',name='URXD1/PUA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='T7',name='UTXD0/PUA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='ETXCLK/PEH7',func=Pin.BIDIR,do_erc=True),
            Pin(num='B8',name='ERXER/PEL0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C8',name='ERXDV/PEH2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='F8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='G8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='K8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='L8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='M8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='N8',name='VCCPLL',func=Pin.PASSIVE,do_erc=True),
            Pin(num='P8',name='GNDPLL',func=Pin.PASSIVE,do_erc=True),
            Pin(num='R8',name='XTAL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='T8',name='CLKIN/EXTAL',do_erc=True),
            Pin(num='A9',name='ERXD3/PEL3',func=Pin.BIDIR,do_erc=True),
            Pin(num='B9',name='ERXD2/PEL2',func=Pin.BIDIR,do_erc=True),
            Pin(num='C9',name='ERXD1/PEL1',func=Pin.BIDIR,do_erc=True),
            Pin(num='D9',name='ERXDO/PEH1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E9',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='F9',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='G9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='K9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='L9',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='M9',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='P9',name='DSCLK/~TRST~',do_erc=True),
            Pin(num='R9',name='JTAG_EN',do_erc=True),
            Pin(num='T9',name='TCLK',do_erc=True),
            Pin(num='A10',name='ERXCLK/PEH3',func=Pin.BIDIR,do_erc=True),
            Pin(num='B10',name='EMDC/PAS4/UTXD2',do_erc=True),
            Pin(num='C10',name='EMDIO/PAS5/URXD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='D10',name='ETXER/PEL4',func=Pin.BIDIR,do_erc=True),
            Pin(num='E10',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='F10',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='G10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='K10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='L10',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='M10',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='N10',name='TEST',do_erc=True),
            Pin(num='P10',name='~BKPT~/TMS',do_erc=True),
            Pin(num='R10',name='DSI/TDI',do_erc=True),
            Pin(num='T10',name='DSO/TDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='A11',name='ECRS/PEH0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B11',name='ECOL/PEH4',func=Pin.BIDIR,do_erc=True),
            Pin(num='D11',name='VDDF',func=Pin.PWRIN,do_erc=True),
            Pin(num='E11',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='F11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G11',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='H11',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='J11',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='K11',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='L11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='M11',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='N11',name='VSTBY',func=Pin.PWRIN,do_erc=True),
            Pin(num='P11',name='RSTO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='R11',name='RSTI',do_erc=True),
            Pin(num='T11',name='RCON',do_erc=True),
            Pin(num='A12',name='VDDF',func=Pin.PWRIN,do_erc=True),
            Pin(num='B12',name='GNDF',func=Pin.PWRIN,do_erc=True),
            Pin(num='C12',name='DDATA3/PDD7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='D12',name='DDATA2/PDD6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='E12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F12',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='G12',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='H12',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='J12',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='K12',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='L12',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='M12',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='N12',name='GPTB0/PTB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='P12',name='GPTB1/PTB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='R12',name='GPTB2/PTB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='T12',name='GPTB3/PTB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A13',name='DDATA1/PDD5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='B13',name='DDATA0/PDD4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='C13',name='PST3/PDD3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='E13',name='CANTX/PAS2/UTxD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='F13',name='QSPI_DOUT/PQS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G13',name='QSPI_CS2/PQS5',func=Pin.BIDIR,do_erc=True),
            Pin(num='H13',name='~SDRAM_CS1~/PSD2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='J13',name='DTOUT0/PTD0/~UCTS1~/~UCTS0~',do_erc=True),
            Pin(num='K13',name='DTOUT2/PTC0/~UCTS1~/~UCTS0~',func=Pin.BIDIR,do_erc=True),
            Pin(num='L13',name='~CS0~/PJ0',func=Pin.BIDIR,do_erc=True),
            Pin(num='N13',name='GPTA0/PTA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='P13',name='GPTA1/PTA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='R13',name='GPTA2/PTA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='T13',name='GPTA3/PTA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A14',name='PST2/PDD2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='B14',name='PST1/PDD1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='C14',name='~IRQ5~/PNQ5',func=Pin.BIDIR,do_erc=True),
            Pin(num='D14',name='~IRQ2~/PNQ2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E14',name='SDA/PAS1/URxD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='F14',name='QSPI_CLK/PQS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='G14',name='QSPI_CS3/PQS6',func=Pin.BIDIR,do_erc=True),
            Pin(num='H14',name='SCKE/PSD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='J14',name='DTIN0/PTD1/~UCTS1~/~UCTS0~',func=Pin.BIDIR,do_erc=True),
            Pin(num='K14',name='DTIN2/PTC1/~UCTS1~/~UCTS0~',func=Pin.BIDIR,do_erc=True),
            Pin(num='L14',name='~CS1~/PJ1',func=Pin.BIDIR,do_erc=True),
            Pin(num='M14',name='~TIP~/PE0/SYNCB',func=Pin.BIDIR,do_erc=True),
            Pin(num='N14',name='SIZ1/PE3/SYNCA',func=Pin.BIDIR,do_erc=True),
            Pin(num='P14',name='~BS3~/PJ7',func=Pin.BIDIR,do_erc=True),
            Pin(num='R14',name='CLKMOD0',do_erc=True),
            Pin(num='T14',name='CLKMOD1',do_erc=True),
            Pin(num='A15',name='PST0/PDD0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='B15',name='~IRQ7~/PNQ7',func=Pin.BIDIR,do_erc=True),
            Pin(num='C15',name='~IRQ4~/PNQ4',func=Pin.BIDIR,do_erc=True),
            Pin(num='D15',name='~IRQ1~/PNQ1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E15',name='SCL/PAS0/UTxD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='F15',name='QSPI_CS0/PQS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G15',name='~DRAMW~/PSD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H15',name='~SRAS~/PSD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='J15',name='DTOUT1/PTD2/~URTS1~/~URTS0~',func=Pin.BIDIR,do_erc=True),
            Pin(num='K15',name='DTOUT3/PTC2/~URTS1~/~URTS0~',func=Pin.BIDIR,do_erc=True),
            Pin(num='L15',name='~CS2~/PJ2',func=Pin.BIDIR,do_erc=True),
            Pin(num='M15',name='~TS~/PE1/SYNCA',func=Pin.BIDIR,do_erc=True),
            Pin(num='N15',name='R/W/PE4',func=Pin.BIDIR,do_erc=True),
            Pin(num='P15',name='~TEA~/PE5',func=Pin.BIDIR,do_erc=True),
            Pin(num='R15',name='~BS1~/PJ5',func=Pin.BIDIR,do_erc=True),
            Pin(num='T15',name='~BS2~/PJ6',func=Pin.BIDIR,do_erc=True),
            Pin(num='A16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B16',name='~IRQ6~/PNQ6',func=Pin.BIDIR,do_erc=True),
            Pin(num='C16',name='~IRQ3~/PNQ3',func=Pin.BIDIR,do_erc=True),
            Pin(num='D16',name='CANRX/PAS3/URxD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E16',name='QSPI_DIN/PQS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='F16',name='QSPI_CS1/PQS4',func=Pin.BIDIR,do_erc=True),
            Pin(num='G16',name='~SDRAM_CS0~/PSD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='H16',name='~SCAS~/PSD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='J16',name='DTIN1/PTD3/~URTS1~/~URTS0~',func=Pin.BIDIR,do_erc=True),
            Pin(num='K16',name='DTIN3/PTC3/~URTS1~/~URTS0~',func=Pin.BIDIR,do_erc=True),
            Pin(num='L16',name='~CS3~/PJ3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M16',name='SIZ0/PE2/SYNCB',func=Pin.BIDIR,do_erc=True),
            Pin(num='N16',name='~OE~/PE7',func=Pin.BIDIR,do_erc=True),
            Pin(num='P16',name='~TA~/PE6',func=Pin.BIDIR,do_erc=True),
            Pin(num='R16',name='~BS0~/PJ4',func=Pin.BIDIR,do_erc=True),
            Pin(num='T16',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCF5328/BGA256',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='MCF5407',dest=TEMPLATE,tool=SKIDL,keywords='COLDFIRE',description='Coldfire',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='IVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='A0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='A1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='EVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='A20',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='PP12/A28',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='/CS0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='60',name='/CS7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='70',name='/IRQ5',do_erc=True),
            Pin(num='80',name='TIN0',do_erc=True),
            Pin(num='90',name='/CAS3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='EVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='A21',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='51',name='/CS1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='61',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='71',name='/IRQ3',do_erc=True),
            Pin(num='81',name='EVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='91',name='/DRAMW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='A14',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='A22',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='PP13/A29',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='EVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='/AS',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='/IRQ1',do_erc=True),
            Pin(num='82',name='TIN1',do_erc=True),
            Pin(num='92',name='/SRAS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='EVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='A15',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='43',name='PP14/A30',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='R/W',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='IVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='83',name='/RAS0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='93',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='A8',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='A16',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='A23',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='PP15/A31',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='/CS2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='64',name='/TA',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='/BR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='84',name='/RAS1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='94',name='/SCAS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='A9',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='PP8/A24',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='EVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='55',name='/CS3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='65',name='EVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='75',name='/BD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='85',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='95',name='SCKE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='A10',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='A17',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='PP9/A25',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='SIZ0',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='/CS4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='66',name='/TS',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='/BG',do_erc=True),
            Pin(num='86',name='/CAS0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='96',name='/BE0',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='A18',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='EVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='SIZ1',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='IVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='67',name='/RSTI',do_erc=True),
            Pin(num='77',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='87',name='/CAS1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='97',name='EVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='A11',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='A19',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='PP10/A26',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='58',name='/CS5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='68',name='/IRQ7',do_erc=True),
            Pin(num='78',name='TOUT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='88',name='/CAS2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='98',name='/BE1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='EVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='PP11/A27',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='/OE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='59',name='/CS6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='69',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='79',name='TOUT0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='89',name='EVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='/BE2',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='/BE3',func=Pin.BIDIR,do_erc=True),
            Pin(num='200',name='PP5/DREQ1',func=Pin.BIDIR,do_erc=True),
            Pin(num='110',name='D28',func=Pin.BIDIR,do_erc=True),
            Pin(num='120',name='D20',func=Pin.BIDIR,do_erc=True),
            Pin(num='130',name='D13',func=Pin.BIDIR,do_erc=True),
            Pin(num='140',name='D5',func=Pin.BIDIR,do_erc=True),
            Pin(num='150',name='TCK',do_erc=True),
            Pin(num='160',name='RXD1',do_erc=True),
            Pin(num='170',name='BCLKO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='180',name='PVCC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='190',name='PSTDDATA3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='101',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='201',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='111',name='D27',func=Pin.BIDIR,do_erc=True),
            Pin(num='121',name='EVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='131',name='D12',func=Pin.BIDIR,do_erc=True),
            Pin(num='141',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='151',name='DSO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='161',name='TXD1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='171',name='IVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='181',name='MTMOD2',do_erc=True),
            Pin(num='191',name='EVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='102',name='SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='202',name='PP4/TM2',func=Pin.BIDIR,do_erc=True),
            Pin(num='112',name='D26',func=Pin.BIDIR,do_erc=True),
            Pin(num='122',name='D19',func=Pin.BIDIR,do_erc=True),
            Pin(num='132',name='D11',func=Pin.BIDIR,do_erc=True),
            Pin(num='142',name='D4',func=Pin.BIDIR,do_erc=True),
            Pin(num='152',name='IVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='162',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='172',name='/RSTO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='182',name='MTMOD3',do_erc=True),
            Pin(num='192',name='PSTDDATA4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='103',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='203',name='PP3/TM1',func=Pin.BIDIR,do_erc=True),
            Pin(num='113',name='EVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='123',name='D18',func=Pin.BIDIR,do_erc=True),
            Pin(num='133',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='143',name='D3',func=Pin.BIDIR,do_erc=True),
            Pin(num='153',name='DSI',do_erc=True),
            Pin(num='163',name='/CTS0',do_erc=True),
            Pin(num='173',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='183',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='193',name='PSTDDATA5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='104',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='204',name='PP2/TM0',func=Pin.BIDIR,do_erc=True),
            Pin(num='114',name='D25',func=Pin.BIDIR,do_erc=True),
            Pin(num='124',name='D17',func=Pin.BIDIR,do_erc=True),
            Pin(num='134',name='D10',func=Pin.BIDIR,do_erc=True),
            Pin(num='144',name='D2',func=Pin.BIDIR,do_erc=True),
            Pin(num='154',name='/BKPT',do_erc=True),
            Pin(num='164',name='/RTS0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='174',name='CLKIN',func=Pin.OUTPUT,do_erc=True),
            Pin(num='184',name='PSTCLK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='194',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='105',name='IVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='205',name='EVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='115',name='D24',func=Pin.BIDIR,do_erc=True),
            Pin(num='125',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='135',name='D9',func=Pin.BIDIR,do_erc=True),
            Pin(num='145',name='EVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='155',name='/HIZ',do_erc=True),
            Pin(num='165',name='RXD0',do_erc=True),
            Pin(num='175',name='IVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='185',name='IVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='195',name='PSTDDATA6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='106',name='D31',func=Pin.BIDIR,do_erc=True),
            Pin(num='206',name='PP1/TT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='116',name='D23',func=Pin.BIDIR,do_erc=True),
            Pin(num='126',name='D16',func=Pin.BIDIR,do_erc=True),
            Pin(num='136',name='D8',func=Pin.BIDIR,do_erc=True),
            Pin(num='146',name='D1',func=Pin.BIDIR,do_erc=True),
            Pin(num='156',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='166',name='TXD0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='176',name='MTMOD0',do_erc=True),
            Pin(num='186',name='PSTDDATA0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='196',name='PSTDDATA7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='107',name='D30',func=Pin.BIDIR,do_erc=True),
            Pin(num='207',name='PP0/TT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='117',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='127',name='D15',func=Pin.BIDIR,do_erc=True),
            Pin(num='137',name='EVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='147',name='D0',func=Pin.BIDIR,do_erc=True),
            Pin(num='157',name='IVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='167',name='EVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='177',name='MTMOD1',do_erc=True),
            Pin(num='187',name='PSTDDATA1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='197',name='IVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='108',name='D29',func=Pin.BIDIR,do_erc=True),
            Pin(num='208',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='118',name='D22',func=Pin.BIDIR,do_erc=True),
            Pin(num='128',name='D14',func=Pin.BIDIR,do_erc=True),
            Pin(num='138',name='D7',func=Pin.BIDIR,do_erc=True),
            Pin(num='148',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='158',name='/CTS1',do_erc=True),
            Pin(num='168',name='EDGESEL',do_erc=True),
            Pin(num='178',name='PGND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='188',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='198',name='PP7/TIP',func=Pin.BIDIR,do_erc=True),
            Pin(num='109',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='119',name='D21',func=Pin.BIDIR,do_erc=True),
            Pin(num='129',name='EVCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='139',name='D6',func=Pin.BIDIR,do_erc=True),
            Pin(num='149',name='DSCLK',do_erc=True),
            Pin(num='159',name='/RTS1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='169',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='189',name='PSTDDATA2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='199',name='PP6/DREQ0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MMC2114CFCPU',dest=TEMPLATE,tool=SKIDL,description='Motorola M*CORE upro 100 pins',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='PA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='PA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='PA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='PA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='PA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='PB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='PB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='PB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='PC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='PD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='ICOC13',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='INT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='INT6',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='VDDH',func=Pin.PWRIN,do_erc=True),
            Pin(num='80',name='VrH',do_erc=True),
            Pin(num='90',name='CLKOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='PB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='PD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='ICOC12',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='VSSF',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='INT7',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='PQB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='VSSA',func=Pin.PWRIN,do_erc=True),
            Pin(num='91',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='PD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='IC0C11',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='VDDF',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='PQB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='VDDA',func=Pin.PWRIN,do_erc=True),
            Pin(num='92',name='TCLK',do_erc=True),
            Pin(num='13',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='PC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='PD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='ICOC10',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='INT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='PQB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='RESET',do_erc=True),
            Pin(num='93',name='TDI',do_erc=True),
            Pin(num='14',name='PB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='PD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='TEST',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='64',name='VSTBY',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='PQB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='RSTOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='94',name='TDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='PB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='PC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='PD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='TXD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='65',name='SCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='PQA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='PLLEN',do_erc=True),
            Pin(num='95',name='TMS',do_erc=True),
            Pin(num='16',name='PB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='PC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='ICOC23',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='RXD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='INT3',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='SS',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='PQA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='XTAL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='96',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='PB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='PC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='ICOC22',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='TXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='INT4',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='PE7',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='PQA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='EXTAL',do_erc=True),
            Pin(num='97',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='PC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='PD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='ICOC21',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='RXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='INT5',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='PE6',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='PQA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='98',name='TRST',do_erc=True),
            Pin(num='19',name='PC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='PD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='ICOC20',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='INT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='PE5',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='VrL',do_erc=True),
            Pin(num='89',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='DE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='100',name='PA7',func=Pin.BIDIR,do_erc=True)]),
        Part(name='MPC8641D',dest=TEMPLATE,tool=SKIDL,keywords='POWERPC',description='Freescale PowerPC E600 core, package BGA1023 pins pitch 1mm',ref_prefix='U',num_units=7,do_erc=True,pins=[
            Pin(num='B1',name='D2_MDQS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='D2_MDQ15',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='D2_MDQ20',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='D2_MDQ17',func=Pin.BIDIR,do_erc=True),
            Pin(num='F1',name='D2_MDQS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='D2_MDQ19',func=Pin.BIDIR,do_erc=True),
            Pin(num='H1',name='D2_MDQ29',func=Pin.BIDIR,do_erc=True),
            Pin(num='J1',name='D2_MDM3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='K1',name='D2_MDQ30',func=Pin.BIDIR,do_erc=True),
            Pin(num='L1',name='D2_MDQ26',func=Pin.BIDIR,do_erc=True),
            Pin(num='M1',name='D2_MECC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='N1',name='D2_MA15',func=Pin.OUTPUT,do_erc=True),
            Pin(num='P1',name='D2_MA12',func=Pin.OUTPUT,do_erc=True),
            Pin(num='R1',name='D2_MA8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='T1',name='D2_MA3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='U1',name='D2_MCK0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='V1',name='/D2_MCK0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='W1',name='D2_MA0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='Y1',name='D2_MDQ36',func=Pin.BIDIR,do_erc=True),
            Pin(num='A2',name='/D2_MDQS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='D2_MDQ14',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='D2_MDQ11',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='/D2_MDQS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='G2',name='D2_MDQ23',func=Pin.BIDIR,do_erc=True),
            Pin(num='J2',name='D2_MDQ25',func=Pin.BIDIR,do_erc=True),
            Pin(num='K2',name='D2_MDQS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M2',name='D2_MECC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='N2',name='D2_MCKE2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='R2',name='D2_MA7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='T2',name='D2_MA4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='V2',name='D2_MCK3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='W2',name='/D2_MCK3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='A3',name='D2_MDQ9',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='D2_MDM1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='D3',name='D2_MDQ10',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='D2_MDQ16',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='D2_MDQ22',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='D2_MDQ28',func=Pin.BIDIR,do_erc=True),
            Pin(num='K3',name='/D2_MDQS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='L3',name='D2_MDQ27',func=Pin.BIDIR,do_erc=True),
            Pin(num='N3',name='D2_MCKE3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='P3',name='D2_MBA2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='T3',name='D2_MA5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='U3',name='D2_MA2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='W3',name='/D2_MRAS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='Y3',name='/D2_MCS0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='A4',name='D2_MDQ12',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='D2_MDQ13',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='D2_MDQ8',func=Pin.BIDIR,do_erc=True),
            Pin(num='E4',name='D2_MDQ21',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='D2_MDM2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='H4',name='D2_MDQ18',func=Pin.BIDIR,do_erc=True),
            Pin(num='J4',name='D2_MDQ24',func=Pin.BIDIR,do_erc=True),
            Pin(num='L4',name='D2_MDQ31',func=Pin.BIDIR,do_erc=True),
            Pin(num='M4',name='D2_MECC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='P4',name='D2_MA14',func=Pin.OUTPUT,do_erc=True),
            Pin(num='R4',name='D2_MA11',func=Pin.OUTPUT,do_erc=True),
            Pin(num='U4',name='D2_MA1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='V4',name='D2_MA10',func=Pin.OUTPUT,do_erc=True),
            Pin(num='Y4',name='/D2_MWE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='A5',name='D2_MDQ7',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='D2_MDQ2',func=Pin.BIDIR,do_erc=True),
            Pin(num='D5',name='D2_MDQ3',func=Pin.BIDIR,do_erc=True),
            Pin(num='F5',name='D2_MCK1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='G5',name='/D2_MCK1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='J5',name='D2_MECC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='K5',name='/D2_MDQS8',func=Pin.BIDIR,do_erc=True),
            Pin(num='M5',name='D2_MECC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='N5',name='D2_MCKE1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='R5',name='D2_MA9',func=Pin.OUTPUT,do_erc=True),
            Pin(num='T5',name='D2_MA6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='V5',name='D2_MBA1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='W5',name='D2_MBA0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='A6',name='/D2_MDQS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='D2_MDQS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='D6',name='D2_MDQ6',func=Pin.BIDIR,do_erc=True),
            Pin(num='E6',name='/D2_MCK4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='G6',name='D2_MECC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='H6',name='D2_MECC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='K6',name='D2_MDM8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='L6',name='D2_MDQS8',func=Pin.BIDIR,do_erc=True),
            Pin(num='N6',name='D2_MCKE0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='A7',name='D2_MDQ0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='D2_MDQ1',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='D2_MDM0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='E7',name='D2_MCK4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='F7',name='D2_MDIC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='D2_MECC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='C8',name='D2_MDQ4',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='D2_MDQ5',func=Pin.BIDIR,do_erc=True),
            Pin(num='F8',name='D2_MDIC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA1',name='D2_MDQ37',func=Pin.BIDIR,do_erc=True),
            Pin(num='AB1',name='D2_MDM4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AC1',name='D2_MDQ38',func=Pin.BIDIR,do_erc=True),
            Pin(num='AD1',name='D2_MDQ34',func=Pin.BIDIR,do_erc=True),
            Pin(num='AE1',name='D2_MDQ41',func=Pin.BIDIR,do_erc=True),
            Pin(num='AF1',name='D2_MDQS5',func=Pin.BIDIR,do_erc=True),
            Pin(num='AG1',name='D2_MDQ42',func=Pin.BIDIR,do_erc=True),
            Pin(num='AH1',name='D2_MDQ52',func=Pin.BIDIR,do_erc=True),
            Pin(num='AJ1',name='D2_MDQ49',func=Pin.BIDIR,do_erc=True),
            Pin(num='AK1',name='D2_MDM6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AL1',name='D2_MDQS6',func=Pin.BIDIR,do_erc=True),
            Pin(num='AM1',name='D2_MDQ50',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA2',name='D2_MDQ33',func=Pin.BIDIR,do_erc=True),
            Pin(num='AB2',name='/D2_MDQS4',func=Pin.BIDIR,do_erc=True),
            Pin(num='AD2',name='D2_MDQ35',func=Pin.BIDIR,do_erc=True),
            Pin(num='AE2',name='D2_MDM5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AG2',name='D2_MDQ43',func=Pin.BIDIR,do_erc=True),
            Pin(num='AH2',name='D2_MDQ53',func=Pin.BIDIR,do_erc=True),
            Pin(num='AK2',name='/D2_MDQS6',func=Pin.BIDIR,do_erc=True),
            Pin(num='AL2',name='D2_MDQ54',func=Pin.BIDIR,do_erc=True),
            Pin(num='AB3',name='D2_MDQS4',func=Pin.BIDIR,do_erc=True),
            Pin(num='AC3',name='D2_MDQ39',func=Pin.BIDIR,do_erc=True),
            Pin(num='AE3',name='/D2_MDQS5',func=Pin.BIDIR,do_erc=True),
            Pin(num='AF3',name='D2_MDQ46',func=Pin.BIDIR,do_erc=True),
            Pin(num='AH3',name='D2_MDQ48',func=Pin.BIDIR,do_erc=True),
            Pin(num='AJ3',name='D2_MCK2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AL3',name='D2_MDQ55',func=Pin.BIDIR,do_erc=True),
            Pin(num='AM3',name='D2_MDQ51',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA4',name='D2_MDQ32',func=Pin.BIDIR,do_erc=True),
            Pin(num='AC4',name='D2_MDQ44',func=Pin.BIDIR,do_erc=True),
            Pin(num='AD4',name='D2_MDQ45',func=Pin.BIDIR,do_erc=True),
            Pin(num='AF4',name='D2_MDQ47',func=Pin.BIDIR,do_erc=True),
            Pin(num='AG4',name='D2_MCK5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AJ4',name='/D2_MCK2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AK4',name='D2_MDQ60',func=Pin.BIDIR,do_erc=True),
            Pin(num='AM4',name='D2_MDQ61',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA5',name='/D2_MCS2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AB5',name='/D2_MCAS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AD5',name='D2_MDQ40',func=Pin.BIDIR,do_erc=True),
            Pin(num='AE5',name='D2_MODT2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AG5',name='/D2_MCK5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AH5',name='D2_MA13',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AK5',name='D2_MDQ56',func=Pin.BIDIR,do_erc=True),
            Pin(num='AL5',name='D2_MDQ57',func=Pin.BIDIR,do_erc=True),
            Pin(num='AM5',name='D2_MDM7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AE6',name='D2_MODT0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AF6',name='/D2_MCS1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AH6',name='D2_MODT3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AJ6',name='/D2_MDQS7',func=Pin.BIDIR,do_erc=True),
            Pin(num='AL6',name='D2_MDQS7',func=Pin.BIDIR,do_erc=True),
            Pin(num='AM6',name='D2_MDQ62',func=Pin.BIDIR,do_erc=True),
            Pin(num='AF7',name='/D2_MCS3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AG7',name='D2_MODT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AJ7',name='D2_MDQ63',func=Pin.BIDIR,do_erc=True),
            Pin(num='AK7',name='D2_MDQ58',func=Pin.BIDIR,do_erc=True),
            Pin(num='AM7',name='D2_MDQ59',func=Pin.BIDIR,do_erc=True),
            Pin(num='A18',name='D2_MVREF',func=Pin.OUTPUT,do_erc=True),
            Pin(num='K30',name='SD1_RX1',do_erc=True),
            Pin(num='M30',name='SD1_RX3',do_erc=True),
            Pin(num='T30',name='SD1_RX4',do_erc=True),
            Pin(num='V30',name='SD1_RX6',do_erc=True),
            Pin(num='Y30',name='SD2_RX0',do_erc=True),
            Pin(num='G31',name='EC_MDC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='J31',name='/SD1_RX0',do_erc=True),
            Pin(num='L31',name='/SD1_RX2',do_erc=True),
            Pin(num='N31',name='/SD1_REF_CLK',do_erc=True),
            Pin(num='P31',name='SD1_DLL_TPA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='U31',name='/SD1_RX5',do_erc=True),
            Pin(num='W31',name='/SD1_RX7',do_erc=True),
            Pin(num='G32',name='EC_MDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='J32',name='SD1_RX0',do_erc=True),
            Pin(num='L32',name='SD1_RX2',do_erc=True),
            Pin(num='N32',name='SD1_REF_CLK',do_erc=True),
            Pin(num='U32',name='SD1_RX5',do_erc=True),
            Pin(num='W32',name='SD1_RX7',do_erc=True),
            Pin(num='M24',name='SD1_TX1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='P24',name='SD1_TX3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='T24',name='SD1_TX5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='V24',name='SD1_TX7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='Y24',name='SD2_TX0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='M25',name='/SD1_TX1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='P25',name='/SD1_TX3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='T25',name='/SD1_TX5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='V25',name='/SD1_TX7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='Y25',name='/SD2_TX0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='L26',name='SD1_TX0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='N26',name='SD1_TX2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='R26',name='SD1_TX4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='U26',name='SD1_TX6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='Y26',name='SD1_IMP_CAL_TX',do_erc=True),
            Pin(num='L27',name='/SD1_TX0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='N27',name='/SD1_TX2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='R27',name='/SD1_TX4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='U27',name='/SD1_TX6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='J28',name='SD1_IMP_CAL_RX',do_erc=True),
            Pin(num='N28',name='SD1_DLL_TPD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='T28',name='SD1_PLL_TPA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='U28',name='SD1_PLL_TPD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='K29',name='/SD1_RX1',do_erc=True),
            Pin(num='M29',name='/SD1_RX3',do_erc=True),
            Pin(num='T29',name='/SD1_RX4',do_erc=True),
            Pin(num='V29',name='/SD1_RX6',do_erc=True),
            Pin(num='Y29',name='/SD2_RX0',do_erc=True),
            Pin(num='AB20',name='TSEC2_TXD0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AD20',name='TSEC2_GTX_CLK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AE20',name='TSEC2_CRS',func=Pin.BIDIR,do_erc=True),
            Pin(num='AF20',name='TSEC2_RXD5',do_erc=True),
            Pin(num='AG20',name='TSEC2_RXD4',do_erc=True),
            Pin(num='AH20',name='TSEC2_RXD3',do_erc=True),
            Pin(num='AJ20',name='TSEC3_TXD3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AL20',name='TSEC3_TXD6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AM20',name='TSEC3_TXD2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AB30',name='SD2_RX2',do_erc=True),
            Pin(num='AD30',name='SD2_DLL_TPA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AH30',name='SD2_RX4',do_erc=True),
            Pin(num='AK30',name='SD2_RX6',do_erc=True),
            Pin(num='AB21',name='TSEC2_TX_EN',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AC21',name='TSEC2_TX_CLK',do_erc=True),
            Pin(num='AD21',name='TSEC2_RX_ER',do_erc=True),
            Pin(num='AE21',name='TSEC2_COL',do_erc=True),
            Pin(num='AG21',name='TSEC2_TXD7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AH21',name='TSEC2_TXD5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AJ21',name='TSEC3_TXD1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AK21',name='TSEC3_TXD5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AL21',name='TSEC3_TXD0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AM21',name='TSEC2_RXD2',do_erc=True),
            Pin(num='AA31',name='/SD2_RX1',do_erc=True),
            Pin(num='AC31',name='/SD2_RX3',do_erc=True),
            Pin(num='AE31',name='/SD2_REF_CLK',do_erc=True),
            Pin(num='AF31',name='SD2_PLL_TPA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AJ31',name='/SD2_RX5',do_erc=True),
            Pin(num='AL31',name='/SD2_RX7',do_erc=True),
            Pin(num='AB22',name='TSEC1_TX_EN',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AC22',name='TSEC1_TX_CLK',do_erc=True),
            Pin(num='AD22',name='TSEC1_TXD7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AE22',name='TSEC1_TXD6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AF22',name='TSEC3_RXD7',do_erc=True),
            Pin(num='AG22',name='TSEC2_TXD6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AJ22',name='TSEC2_TXD2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AK22',name='TSEC2_RXD1',do_erc=True),
            Pin(num='AL22',name='TSEC2_RXD0',do_erc=True),
            Pin(num='AM22',name='TSEC2_RX_CLK',do_erc=True),
            Pin(num='AA32',name='SD2_RX1',do_erc=True),
            Pin(num='AC32',name='SD2_RX3',do_erc=True),
            Pin(num='AE32',name='SD2_REF_CLK',do_erc=True),
            Pin(num='AJ32',name='SD2_RX5',do_erc=True),
            Pin(num='AL32',name='SD2_RX7',do_erc=True),
            Pin(num='AC13',name='TSEC4_COL',do_erc=True),
            Pin(num='AD13',name='TSEC4_RXD1',do_erc=True),
            Pin(num='AF13',name='TSEC4_RXD2',do_erc=True),
            Pin(num='AG13',name='TSEC4_RX_CLK',do_erc=True),
            Pin(num='AC23',name='TSEC1_TXD1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AE23',name='TSEC1_TXD5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AF23',name='TSEC2_RXD6',do_erc=True),
            Pin(num='AG23',name='TSEC1_TXD3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AH23',name='TSEC2_TXD4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AJ23',name='TSEC2_TXD1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AL23',name='EC1_GTX_CLK125',do_erc=True),
            Pin(num='AM23',name='EC2_GTX_CLK125',do_erc=True),
            Pin(num='AB14',name='TSEC4_CRS',func=Pin.BIDIR,do_erc=True),
            Pin(num='AC14',name='TSEC4_RXD6',do_erc=True),
            Pin(num='AD14',name='TSEC4_RXD3',do_erc=True),
            Pin(num='AE14',name='TSEX4_RXD4',do_erc=True),
            Pin(num='AF14',name='TSEC4_RX_ER',do_erc=True),
            Pin(num='AG14',name='TSEC4_RXD0',do_erc=True),
            Pin(num='AH14',name='TSEC3_RXD3',do_erc=True),
            Pin(num='AE24',name='TSEC1_TXD4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AG24',name='TSEC1_TXD2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AH24',name='TSEC1_RXD6',do_erc=True),
            Pin(num='AJ24',name='TSEC1_RX_DV',do_erc=True),
            Pin(num='AK24',name='TSEC1_RX_CLK',do_erc=True),
            Pin(num='AL24',name='TSEC1_RXD1',do_erc=True),
            Pin(num='AM24',name='TSEC1_CRS',func=Pin.BIDIR,do_erc=True),
            Pin(num='AB15',name='TSEC4_RXD5',do_erc=True),
            Pin(num='AC15',name='TSEC4_RX_DV',do_erc=True),
            Pin(num='AE15',name='TSEC3_CRS',func=Pin.BIDIR,do_erc=True),
            Pin(num='AF15',name='TSEC3_COL',do_erc=True),
            Pin(num='AG15',name='TSEC3_RX_DV',do_erc=True),
            Pin(num='AH15',name='TSEC3_RXD5',do_erc=True),
            Pin(num='AB25',name='SD2_TX2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AF25',name='TSEC1_TXD0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AG25',name='TSEC1_RXD7',do_erc=True),
            Pin(num='AH25',name='TSEC1_GTX_CLK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AJ25',name='TSEC1_RX_ER',do_erc=True),
            Pin(num='AK25',name='TSEC1_RXD3',do_erc=True),
            Pin(num='AL25',name='TSEC1_RXD0',do_erc=True),
            Pin(num='AM25',name='TSEC1_COL',do_erc=True),
            Pin(num='AB16',name='TSEC4_TXD7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AC16',name='TSEC4_TXD1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AD16',name='TSEC4_TXD4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AE16',name='TSEC3_RXD1',do_erc=True),
            Pin(num='AF16',name='TSEC3_RX_ER',do_erc=True),
            Pin(num='AG16',name='TSEC3_RXD6',do_erc=True),
            Pin(num='AH16',name='TSEC3_RXD2',do_erc=True),
            Pin(num='AA26',name='SD2_IMP_CAL_RX',do_erc=True),
            Pin(num='AB26',name='/SD2_TX2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AF26',name='TSEC1_RXD5',do_erc=True),
            Pin(num='AH26',name='TSEC1_TX_ER',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AK26',name='TSEC1_RXD2',do_erc=True),
            Pin(num='AM26',name='TSEC1_RXD4',do_erc=True),
            Pin(num='AB17',name='TSEC4_TXD6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AD17',name='TSEC4_TXD3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AE17',name='TSEC4_RXD7',do_erc=True),
            Pin(num='AF17',name='TSEC4_TX_EN',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AG17',name='TSEC4_GTX_CLK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AH17',name='TSEC3_TX_ER',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AJ17',name='TSEC3_RXD0',do_erc=True),
            Pin(num='AA27',name='SD2_TX1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AC27',name='SD2_TX3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AE27',name='SD2_TX4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AG27',name='SD2_TX5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AJ27',name='SD2_TX6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AL27',name='SD2_TX7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AB18',name='TSEC4_TXD5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AC18',name='TSEC4_TXD0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AD18',name='TSEC4_TXD2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AF18',name='TSEC4_TX_CLK',do_erc=True),
            Pin(num='AH18',name='TSEC3_TX_CLK',do_erc=True),
            Pin(num='AJ18',name='TSEC3_RX_CLK',do_erc=True),
            Pin(num='AA28',name='/SD2_TX1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AC28',name='/SD2_TX3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AE28',name='/SD2_TX4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AG28',name='/SD2_TX5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AJ28',name='/SD2_TX6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AL28',name='/SD2_TX7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AB19',name='TSEC2_TX_ER',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AC19',name='TSEC2_RX_DV',do_erc=True),
            Pin(num='AD19',name='TSEC2_TXD3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AE19',name='TSEC3_RXD7',do_erc=True),
            Pin(num='AF19',name='TSEC4_TX_ER',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AG19',name='TSEC3_GTX_CLK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AH19',name='TSEC3_TX_EN',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AJ19',name='TSEC3_RXD4',do_erc=True),
            Pin(num='AL19',name='TSEC3_TXD7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AM19',name='TSEC3_TXD4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AB29',name='/SD2_RX2',do_erc=True),
            Pin(num='AD29',name='SD2_DLL_TPD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AF29',name='SD2_PLL_TPD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AH29',name='/SD2_RX4',do_erc=True),
            Pin(num='AK29',name='/SD2_RX6',do_erc=True),
            Pin(num='AM29',name='SD2_IMP_CAL_TX',do_erc=True),
            Pin(num='C20',name='/SRESET_0',do_erc=True),
            Pin(num='D20',name='LSYNC_OUT',do_erc=True),
            Pin(num='E20',name='/LWE3/LBS3/LSDDQM3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='F20',name='LGPL0/LSDA10',func=Pin.OUTPUT,do_erc=True),
            Pin(num='H20',name='LGPL1/LSDWE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='J20',name='LGPL2/LOE/LSDRAS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='K20',name='LGPL3/LSDCAS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='M20',name='LCLK2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='A30',name='LAD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B30',name='IRQ9/DMA_DREQ3',do_erc=True),
            Pin(num='C30',name='IRQ10/DMA_DACK3',do_erc=True),
            Pin(num='D30',name='IRQ11/DMA_DDONE3',do_erc=True),
            Pin(num='E30',name='/UART_RTS1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='F30',name='DMA_DACK1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='H30',name='RSVD',func=Pin.UNSPEC,do_erc=True),
            Pin(num='Y11',name='TEMP_CATHODE',func=Pin.BIDIR,do_erc=True),
            Pin(num='A21',name='IIC2_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='B21',name='IIC2_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='C21',name='/SRESET_1',do_erc=True),
            Pin(num='D21',name='LBCTL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='E21',name='/LWE0/LBS0/LSDDQM0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='F21',name='/LWE1/LBS1/LSDDQM1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='G21',name='LA31',func=Pin.OUTPUT,do_erc=True),
            Pin(num='J21',name='LA27',func=Pin.OUTPUT,do_erc=True),
            Pin(num='K21',name='LA28',func=Pin.OUTPUT,do_erc=True),
            Pin(num='L21',name='LGPL4/LGTA/LUPWAIT/LPBSE',func=Pin.BIDIR,do_erc=True),
            Pin(num='A31',name='/UART_CTS0',do_erc=True),
            Pin(num='B31',name='/UART_CTS1',do_erc=True),
            Pin(num='C31',name='/UART_RTS0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='D31',name='UART_SOUT0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='E31',name='DMA_DREQ0',do_erc=True),
            Pin(num='F31',name='DMA_DDONE0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='R31',name='RSVD',func=Pin.UNSPEC,do_erc=True),
            Pin(num='A22',name='/LCS0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='C22',name='/LCS1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='D22',name='/LWE2/LBS2/LSDDQM2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='E22',name='/LCS4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='G22',name='LA29',func=Pin.OUTPUT,do_erc=True),
            Pin(num='H22',name='LAD31',func=Pin.BIDIR,do_erc=True),
            Pin(num='K22',name='LAD28',func=Pin.BIDIR,do_erc=True),
            Pin(num='L22',name='LAD9',func=Pin.BIDIR,do_erc=True),
            Pin(num='M22',name='LAD10',func=Pin.BIDIR,do_erc=True),
            Pin(num='A32',name='UART_SOUT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='B32',name='UART_SIN0',do_erc=True),
            Pin(num='C32',name='UART_SIN1',do_erc=True),
            Pin(num='D32',name='DMA_DACK0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='E32',name='DMA_DREQ1',do_erc=True),
            Pin(num='F32',name='DMA_DDONE1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='R32',name='RSVD',func=Pin.UNSPEC,do_erc=True),
            Pin(num='J13',name='TRIG_OUT/READY',func=Pin.OUTPUT,do_erc=True),
            Pin(num='A23',name='/LCS5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='B23',name='/LCS5/DMA_DREQ2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='D23',name='/LCS3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='E23',name='/LCS6/DMA_DACK2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='F23',name='/LCS7/DMA_DDONE2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='H23',name='LAD27',func=Pin.BIDIR,do_erc=True),
            Pin(num='J23',name='IRQ3',do_erc=True),
            Pin(num='L23',name='IRQ8',do_erc=True),
            Pin(num='M23',name='IRQ4',do_erc=True),
            Pin(num='J14',name='TRIG_IN',do_erc=True),
            Pin(num='K14',name='D1_MSRCID2/LB_SRCID2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='A24',name='LDP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B24',name='LDP3',func=Pin.BIDIR,do_erc=True),
            Pin(num='C24',name='LDP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E24',name='LDP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='F24',name='LA30',func=Pin.OUTPUT,do_erc=True),
            Pin(num='G24',name='LAD22',func=Pin.BIDIR,do_erc=True),
            Pin(num='J24',name='IRQ7',do_erc=True),
            Pin(num='K24',name='NC',func=Pin.UNSPEC,do_erc=True),
            Pin(num='F15',name='D1_MSRCID0/LB_SRCID0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='G15',name='D1_MSRCID4/LB_SRCID4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='H15',name='D1_MSRCID3/LB_SRCID3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='K15',name='D1_MSRCID1/LB_SRCID1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='L15',name='SMI_0',do_erc=True),
            Pin(num='A25',name='LAD25',func=Pin.BIDIR,do_erc=True),
            Pin(num='C25',name='LAD26',func=Pin.BIDIR,do_erc=True),
            Pin(num='D25',name='LAD29',func=Pin.BIDIR,do_erc=True),
            Pin(num='F25',name='LAD30',func=Pin.BIDIR,do_erc=True),
            Pin(num='G25',name='LAD19',func=Pin.BIDIR,do_erc=True),
            Pin(num='H25',name='LAD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='K25',name='NC',func=Pin.UNSPEC,do_erc=True),
            Pin(num='A16',name='IIC1_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='B16',name='CLK_OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='C16',name='TEST_MODE0',do_erc=True),
            Pin(num='D16',name='TEST_MODE3',do_erc=True),
            Pin(num='E16',name='D2_MSRCID0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='F16',name='D2_MSRCID2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='G16',name='SYSCLK',do_erc=True),
            Pin(num='H16',name='D2_MSRCID3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='J16',name='D1_MDVAL/LB_DVAL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='K16',name='D2_MSRCID4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='L16',name='SMI_1',do_erc=True),
            Pin(num='A26',name='LAD24',func=Pin.BIDIR,do_erc=True),
            Pin(num='B26',name='LAD16',func=Pin.BIDIR,do_erc=True),
            Pin(num='D26',name='LAD20',func=Pin.BIDIR,do_erc=True),
            Pin(num='E26',name='LAD21',func=Pin.BIDIR,do_erc=True),
            Pin(num='G26',name='LAD14',func=Pin.BIDIR,do_erc=True),
            Pin(num='H26',name='LAD13',func=Pin.BIDIR,do_erc=True),
            Pin(num='J26',name='/IRQ_OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='W26',name='NC',func=Pin.UNSPEC,do_erc=True),
            Pin(num='A17',name='/TRST',do_erc=True),
            Pin(num='B17',name='IIC1_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='C17',name='D2_MSRCID1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='E17',name='TEST_MODE1',do_erc=True),
            Pin(num='F17',name='/MCP_0',do_erc=True),
            Pin(num='H17',name='/MCP_1',do_erc=True),
            Pin(num='J17',name='SPARE',func=Pin.UNSPEC,do_erc=True),
            Pin(num='K17',name='RTC',do_erc=True),
            Pin(num='L17',name='/CKSTP_OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='A27',name='LAD17',func=Pin.BIDIR,do_erc=True),
            Pin(num='B27',name='LAD15',func=Pin.BIDIR,do_erc=True),
            Pin(num='C27',name='LAD12',func=Pin.BIDIR,do_erc=True),
            Pin(num='E27',name='LAD18',func=Pin.BIDIR,do_erc=True),
            Pin(num='F27',name='LAD23',func=Pin.BIDIR,do_erc=True),
            Pin(num='H27',name='IRQ2',do_erc=True),
            Pin(num='J27',name='IRQ5',do_erc=True),
            Pin(num='W27',name='NC',func=Pin.UNSPEC,do_erc=True),
            Pin(num='B18',name='/HRESET',func=Pin.BIDIR,do_erc=True),
            Pin(num='C18',name='/LSSD_MODE',do_erc=True),
            Pin(num='D18',name='TEST_MODE2',do_erc=True),
            Pin(num='F18',name='TMS',do_erc=True),
            Pin(num='G18',name='TDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='H18',name='TCK',do_erc=True),
            Pin(num='J18',name='TDI',do_erc=True),
            Pin(num='K18',name='/HRESET_REQ',func=Pin.OUTPUT,do_erc=True),
            Pin(num='L18',name='/CKSTP_IN',do_erc=True),
            Pin(num='A28',name='LAD11',func=Pin.BIDIR,do_erc=True),
            Pin(num='C28',name='LAD8',func=Pin.BIDIR,do_erc=True),
            Pin(num='D28',name='LAD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='F28',name='IRQ6',do_erc=True),
            Pin(num='G28',name='IRQ0',do_erc=True),
            Pin(num='P28',name='NC',func=Pin.UNSPEC,do_erc=True),
            Pin(num='V28',name='RSVD',func=Pin.UNSPEC,do_erc=True),
            Pin(num='W28',name='RSVD',func=Pin.UNSPEC,do_erc=True),
            Pin(num='C19',name='ASLEEP',func=Pin.OUTPUT,do_erc=True),
            Pin(num='D19',name='D2_MDVAL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='E19',name='LALE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='G19',name='LCLK0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='H19',name='LCKE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='J19',name='LGPL5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='L19',name='LCLK1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='M19',name='LSYNC_IN',do_erc=True),
            Pin(num='A29',name='LAD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='B29',name='LAD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='C29',name='LAD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='D29',name='LAD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='E29',name='LAD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G29',name='IRQ1',do_erc=True),
            Pin(num='H29',name='RSVD',func=Pin.UNSPEC,do_erc=True),
            Pin(num='P29',name='NC',func=Pin.UNSPEC,do_erc=True),
            Pin(num='AA11',name='TEMP_ANODE',func=Pin.BIDIR,do_erc=True),
            Pin(num='AG31',name='RSVD',func=Pin.UNSPEC,do_erc=True),
            Pin(num='AG32',name='RSVD',func=Pin.UNSPEC,do_erc=True),
            Pin(num='AD24',name='RSVD',func=Pin.UNSPEC,do_erc=True),
            Pin(num='AD25',name='NC',func=Pin.UNSPEC,do_erc=True),
            Pin(num='AD26',name='NC',func=Pin.UNSPEC,do_erc=True),
            Pin(num='AG26',name='RSVD',func=Pin.UNSPEC,do_erc=True),
            Pin(num='B20',name='AVDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='N20',name='VDD_PLAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='R20',name='VDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='U20',name='SENSEVDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='V20',name='SENSEVSS_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='W20',name='VDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='J30',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N30',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='U30',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='P11',name='VDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='T11',name='VDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='V11',name='VDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='P21',name='VDD_PLAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='T21',name='VDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='V21',name='VDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y21',name='VDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='K31',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='V31',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='L12',name='VDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='N12',name='VDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='R12',name='VDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='U12',name='VDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='W12',name='VDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y12',name='VDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='N22',name='VDD_PLAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='R22',name='VDD_PLAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='U22',name='VDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='W22',name='VDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='H32',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='M32',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='T32',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y32',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='L13',name='VDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='M13',name='VDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='P13',name='VDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='T13',name='VDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='V13',name='VDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y13',name='VDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='P23',name='VDD_PLAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='T23',name='VDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='V23',name='VDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y23',name='VDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='L14',name='VDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='M14',name='SENSEVDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='N14',name='VDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='P14',name='SENSEVSS_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='R14',name='VDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='U14',name='VDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='W14',name='VDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='N24',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='U24',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='M15',name='VDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='P15',name='VDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='T15',name='VDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='V15',name='VDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y15',name='VDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='L25',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R25',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='W25',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='M16',name='VDD_PLAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='R16',name='VDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='U16',name='VDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='W16',name='VDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='M26',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='T26',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='M17',name='VDD_PLAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='P17',name='VDD_PLAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='T17',name='VDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='V17',name='VDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y17',name='VDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='K27',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='P27',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='V27',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='M18',name='VDD_PLAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='N18',name='VDD_PLAT/SENSEVDD_PLAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='R18',name='VDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='U18',name='VDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='W18',name='VDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='H28',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='L28',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y28',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A19',name='AVDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='P19',name='VDD_PLAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='T19',name='VDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='V19',name='VDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y19',name='VDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='L29',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R29',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='W29',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA20',name='VDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA30',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE30',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AJ30',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB31',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AK31',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA12',name='VDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA22',name='VDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD32',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AH32',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AM32',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB13',name='VDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB23',name='VDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA14',name='VDD_CORE0',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA24',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC24',name='VDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC25',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA16',name='VDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE26',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AJ26',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AL26',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB27',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF27',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AK27',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA18',name='VDD_CORE1',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD28',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AH28',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AM28',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC29',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AG29',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AL29',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B2',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E2',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H2',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='L2',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='P2',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='U2',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y2',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='D4',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G4',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='K4',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='N4',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='T4',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='W4',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='B5',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F6',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='J6',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='M6',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='R6',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='V6',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='D7',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='B8',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H8',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='L8',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='P8',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='U8',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y8',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F9',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='D10',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='K10',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='W10',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='A20',name='AVDD_LB',func=Pin.PWRIN,do_erc=True),
            Pin(num='L30',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='P30',name='AGND_SRDS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='R30',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='W30',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='B11',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H11',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H21',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='M21',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H31',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='M31',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='T31',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y31',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F12',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='B22',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F22',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='K32',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='P32',name='AVDD_SRDS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='V32',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC2',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF2',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AJ2',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AM2',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='D13',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='K13',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='K23',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='B14',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H14',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='D24',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H24',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='L24',name='XVDD_SRDS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='R24',name='XVDD_SRDS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='W24',name='XVDD_SRDS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB4',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE4',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AH4',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AL4',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='B25',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='N25',name='XVDD_SRDS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='U25',name='XVDD_SRDS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='F26',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='K26',name='XVDD_SRDS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='P26',name='XVDD_SRDS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='V26',name='XVDD_SRDS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA6',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD6',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AG6',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AK6',name='D2_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='D17',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G17',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='D27',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='M27',name='XVDD_SRDS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='T27',name='XVDD_SRDS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y27',name='XVDD_SRDS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='B28',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='K28',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='M28',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='R28',name='XVDD_SRDS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC8',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF8',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AJ8',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='B19',name='AVDD_PLAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='F19',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='K19',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F29',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='J29',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='N29',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='U29',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB10',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE10',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AH10',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AL10',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC20',name='LVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AK20',name='TVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC30',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF30',name='AGND_SRDS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='AG30',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AL30',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AM30',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD31',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AH31',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AM31',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD12',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AG12',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AK12',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AH22',name='LVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB32',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF32',name='AVDD_SRDS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='AK32',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD23',name='LVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AJ14',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA25',name='XVDD_SRDS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE25',name='XVDD_SRDS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='AL16',name='D1_GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC26',name='XVDD_SRDS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC17',name='TVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD27',name='XVDD_SRDS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='AH27',name='XVDD_SRDS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='AM27',name='XVDD_SRDS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='AG18',name='TVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB28',name='XVDD_SRDS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF28',name='XVDD_SRDS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='AK28',name='XVDD_SRDS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA29',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE29',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AJ29',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='C3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='M3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='V3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='E5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='L5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='P5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='U5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='C6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='K7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='T7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='W7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='E8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='C9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='M9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='V9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='L20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='P20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='T20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G30',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='E11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='U11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='W11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='U21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='W21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='C12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='M12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='P12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='T12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='V12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='P22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='T22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='V22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='U13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='W13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='C23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='U23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='W23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AG3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AK3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='E14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='T14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='V14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='C15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='U15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='W15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='E25',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J25',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AJ5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='P16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='T16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='V16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='C26',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='U17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='W17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G27',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AH7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AL7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='E18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='P18',name='GNDGND/SENSEVSS_PLAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='T18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='V18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='E28',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N19',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R19',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='U19',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='W19',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AG9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AK9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AJ11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AH13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AL13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AK23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AK15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA19',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AK19',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J15~',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='P6',name='D1_MA15',func=Pin.OUTPUT,do_erc=True),
            Pin(num='T6',name='D1_MA11',func=Pin.OUTPUT,do_erc=True),
            Pin(num='U6',name='D1_MA5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='W6',name='D1_MCK0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='Y6',name='/D1_MCK0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='J7',name='D1_MDQS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='L7',name='D1_MDQ27',func=Pin.BIDIR,do_erc=True),
            Pin(num='M7',name='D1_MECC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='P7',name='D1_MCKE0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='R7',name='D1_MA14',func=Pin.OUTPUT,do_erc=True),
            Pin(num='U7',name='D1_MA8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='V7',name='D1_MA3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='Y7',name='D1_MCK3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='A8',name='D1_MDQ11',func=Pin.BIDIR,do_erc=True),
            Pin(num='G8',name='D1_MDQ24',func=Pin.BIDIR,do_erc=True),
            Pin(num='J8',name='/D1_MDQS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='K8',name='D1_MDQ31',func=Pin.BIDIR,do_erc=True),
            Pin(num='M8',name='D1_MECC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='N8',name='D1_MCKE2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='R8',name='D1_MECC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='T8',name='D1_MA12',func=Pin.OUTPUT,do_erc=True),
            Pin(num='V8',name='D1_MA4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='W8',name='D1_MA1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='A9',name='D1_MDQ14',func=Pin.BIDIR,do_erc=True),
            Pin(num='B9',name='D1_MDQ15',func=Pin.BIDIR,do_erc=True),
            Pin(num='D9',name='D1_MDQ10',func=Pin.BIDIR,do_erc=True),
            Pin(num='E9',name='D1_MDQ21',func=Pin.BIDIR,do_erc=True),
            Pin(num='G9',name='D1_MDQ29',func=Pin.BIDIR,do_erc=True),
            Pin(num='H9',name='D1_MDM3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='K9',name='D1_MDQ30',func=Pin.BIDIR,do_erc=True),
            Pin(num='L9',name='D1_MDQ26',func=Pin.BIDIR,do_erc=True),
            Pin(num='N9',name='D1_MDQS8',func=Pin.BIDIR,do_erc=True),
            Pin(num='P9',name='D1_MECC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='T9',name='D1_MBA2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='U9',name='D1_MA7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='W9',name='D1_MA2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='Y9',name='D1_MA10',func=Pin.OUTPUT,do_erc=True),
            Pin(num='A10',name='D1_MDM1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='B10',name='/D1_MDQS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='C10',name='D1_MDQS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E10',name='D1_MDQ20',func=Pin.BIDIR,do_erc=True),
            Pin(num='F10',name='D1_MDQ28',func=Pin.BIDIR,do_erc=True),
            Pin(num='H10',name='D1_MDQ25',func=Pin.BIDIR,do_erc=True),
            Pin(num='J10',name='D1_MDQ23',func=Pin.BIDIR,do_erc=True),
            Pin(num='L10',name='D1_MECC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='M10',name='D1_MCKE1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='N10',name='D1_MDM8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='P10',name='/D1_MDQS8',func=Pin.BIDIR,do_erc=True),
            Pin(num='R10',name='D1_MECC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='T10',name='D1_MECC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='U10',name='D1_MA9',func=Pin.OUTPUT,do_erc=True),
            Pin(num='V10',name='D1_MA6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='Y10',name='D1_MA0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='A11',name='D1_MDQ13',func=Pin.BIDIR,do_erc=True),
            Pin(num='C11',name='D1_MDQ8',func=Pin.BIDIR,do_erc=True),
            Pin(num='D11',name='D1_MDQ9',func=Pin.BIDIR,do_erc=True),
            Pin(num='F11',name='D1_MDQ16',func=Pin.BIDIR,do_erc=True),
            Pin(num='G11',name='D1_MDM2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='J11',name='D1_MDQ22',func=Pin.BIDIR,do_erc=True),
            Pin(num='K11',name='D1_MDQ18',func=Pin.BIDIR,do_erc=True),
            Pin(num='L11',name='D1_MECC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='M11',name='D1_MCKE3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='A12',name='D1_MDQ12',func=Pin.BIDIR,do_erc=True),
            Pin(num='B12',name='D1_MDQ2',func=Pin.BIDIR,do_erc=True),
            Pin(num='D12',name='D1_MDQ3',func=Pin.BIDIR,do_erc=True),
            Pin(num='E12',name='/D1_MCK1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='G12',name='D1_MDQ17',func=Pin.BIDIR,do_erc=True),
            Pin(num='H12',name='D1_MDQS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='K12',name='D1_MDQ19',func=Pin.BIDIR,do_erc=True),
            Pin(num='A13',name='D1_MDQS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B13',name='D1_MDQ6',func=Pin.BIDIR,do_erc=True),
            Pin(num='C13',name='D1_MDQ7',func=Pin.BIDIR,do_erc=True),
            Pin(num='E13',name='D1_MCK1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='F13',name='/D1_MCK4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='H13',name='/D1_MDQS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A14',name='D1_MDQ1',func=Pin.BIDIR,do_erc=True),
            Pin(num='C14',name='D1_MDM0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='D14',name='/D1_MDQS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F14',name='D1_MCK4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='G14',name='D1_MDIC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A15',name='D1_MDQ4',func=Pin.BIDIR,do_erc=True),
            Pin(num='B15',name='D1_MDQ5',func=Pin.BIDIR,do_erc=True),
            Pin(num='D15',name='D1_MDQ0',func=Pin.BIDIR,do_erc=True),
            Pin(num='E15',name='D1_MDIC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='AB6',name='D1_MDQ36',func=Pin.BIDIR,do_erc=True),
            Pin(num='AC6',name='D1_MDQ32',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA7',name='/D1_MCK3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AC7',name='D1_MDQ33',func=Pin.BIDIR,do_erc=True),
            Pin(num='AD7',name='D1_MDM4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AA8',name='D1_MBA0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AB8',name='D1_MDQ37',func=Pin.BIDIR,do_erc=True),
            Pin(num='AD8',name='/D1_MDQS4',func=Pin.BIDIR,do_erc=True),
            Pin(num='AE8',name='D1_MDQS4',func=Pin.BIDIR,do_erc=True),
            Pin(num='AG8',name='D1_MDQ34',func=Pin.BIDIR,do_erc=True),
            Pin(num='AH8',name='D1_MDQ44',func=Pin.BIDIR,do_erc=True),
            Pin(num='AK8',name='D1_MDQ45',func=Pin.BIDIR,do_erc=True),
            Pin(num='AL8',name='D1_MDQ40',func=Pin.BIDIR,do_erc=True),
            Pin(num='AM8',name='D1_MDQ41',func=Pin.BIDIR,do_erc=True),
            Pin(num='AB9',name='/D1_MCS0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AC9',name='D1_MODT0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AE9',name='D1_MDQ38',func=Pin.BIDIR,do_erc=True),
            Pin(num='AF9',name='D1_MDQ39',func=Pin.BIDIR,do_erc=True),
            Pin(num='AH9',name='D1_MDQ35',func=Pin.BIDIR,do_erc=True),
            Pin(num='AJ9',name='D1_MDM5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AL9',name='/D1_MDQS5',func=Pin.BIDIR,do_erc=True),
            Pin(num='AM9',name='D1_MDQS5',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA10',name='D1_MBA1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AC10',name='/D1_MCAS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AD10',name='/D1_MCS1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AF10',name='D1_MODT3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AG10',name='D1_MCK5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AJ10',name='D1_MDQ46',func=Pin.BIDIR,do_erc=True),
            Pin(num='AK10',name='D1_MDQ47',func=Pin.BIDIR,do_erc=True),
            Pin(num='AM10',name='D1_MDQ42',func=Pin.BIDIR,do_erc=True),
            Pin(num='AB11',name='/D1_MWE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AD11',name='/D1_MCS3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AE11',name='D1_MODT2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AG11',name='/D1_MCK5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AH11',name='D1_MCK2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AK11',name='D1_MDQ43',func=Pin.BIDIR,do_erc=True),
            Pin(num='AL11',name='D1_MDQ52',func=Pin.BIDIR,do_erc=True),
            Pin(num='AM11',name='D1_MDQ53',func=Pin.BIDIR,do_erc=True),
            Pin(num='AB12',name='/D1_MRAS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AC12',name='/D1_MCS2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AE12',name='D1_MA13',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AF12',name='D1_MODT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AH12',name='/D1_MCK2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AJ12',name='D1_MDQ49',func=Pin.BIDIR,do_erc=True),
            Pin(num='AL12',name='D1_MDQ48',func=Pin.BIDIR,do_erc=True),
            Pin(num='AM12',name='D1_MDM6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AJ13',name='/D1_MDQS6',func=Pin.BIDIR,do_erc=True),
            Pin(num='AK13',name='D1_MDQS6',func=Pin.BIDIR,do_erc=True),
            Pin(num='AM13',name='D1_MDQ54',func=Pin.BIDIR,do_erc=True),
            Pin(num='AK14',name='D1_MDQ55',func=Pin.BIDIR,do_erc=True),
            Pin(num='AL14',name='D1_MDQ50',func=Pin.BIDIR,do_erc=True),
            Pin(num='AM14',name='D1_MDQ51',func=Pin.BIDIR,do_erc=True),
            Pin(num='AJ15',name='D1_MDQ60',func=Pin.BIDIR,do_erc=True),
            Pin(num='AL15',name='D1_MDQ61',func=Pin.BIDIR,do_erc=True),
            Pin(num='AM15',name='D1_MDQ56',func=Pin.BIDIR,do_erc=True),
            Pin(num='AJ16',name='D1_MDQ57',func=Pin.BIDIR,do_erc=True),
            Pin(num='AK16',name='D1_MDM7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AM16',name='/D1_MDQS7',func=Pin.BIDIR,do_erc=True),
            Pin(num='AK17',name='D1_MDQS7',func=Pin.BIDIR,do_erc=True),
            Pin(num='AL17',name='D1_MDQ62',func=Pin.BIDIR,do_erc=True),
            Pin(num='AM17',name='D1_MDQ63',func=Pin.BIDIR,do_erc=True),
            Pin(num='AK18',name='D1_MDQ58',func=Pin.BIDIR,do_erc=True),
            Pin(num='AL18',name='D1_MDQ59',func=Pin.BIDIR,do_erc=True),
            Pin(num='AM18',name='D1_MVREF',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='P4080-BGA1295',dest=TEMPLATE,tool=SKIDL,description='QorIQ P4080 Communications Processor',ref_prefix='U',num_units=10,do_erc=True,pins=[
            Pin(num='F1',name='D1_MCK4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='F2',name='/D1_MCK4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='J5',name='D1_MECC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='K5',name='/D1_MDQS8',func=Pin.BIDIR,do_erc=True),
            Pin(num='V5',name='/D1_MCK1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='W5',name='/D1_MCK0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='E6',name='D1_MDQ22',func=Pin.BIDIR,do_erc=True),
            Pin(num='K6',name='D1_MDQS8',func=Pin.BIDIR,do_erc=True),
            Pin(num='L6',name='D1_MA15',func=Pin.OUTPUT,do_erc=True),
            Pin(num='N6',name='D1_MA12',func=Pin.OUTPUT,do_erc=True),
            Pin(num='P6',name='D1_MA9',func=Pin.OUTPUT,do_erc=True),
            Pin(num='T6',name='D1_MDIC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='U6',name='D1_MA1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='V6',name='D1_MCK1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='W6',name='D1_MCK0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='E7',name='D1_MDQ23',func=Pin.BIDIR,do_erc=True),
            Pin(num='F7',name='D1_MDQ24',func=Pin.BIDIR,do_erc=True),
            Pin(num='H7',name='D1_MDQ30',func=Pin.BIDIR,do_erc=True),
            Pin(num='J7',name='D1_MECC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='L7',name='D1_MECC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='M7',name='D1_MA14',func=Pin.OUTPUT,do_erc=True),
            Pin(num='P7',name='D1_MA11',func=Pin.OUTPUT,do_erc=True),
            Pin(num='R7',name='D1_MA8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='U7',name='D1_MA2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='Y7',name='D1_MAPAR_OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='C8',name='D1_MDQ16',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='/D1_MDQS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='F8',name='D1_MDQ29',func=Pin.BIDIR,do_erc=True),
            Pin(num='G8',name='/D1_MDQS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='J8',name='D1_MECC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='K8',name='D1_MDM8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='M8',name='D1_MBA2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='N8',name='/D1_MAPAR_ERR',do_erc=True),
            Pin(num='R8',name='D1_MA7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='T8',name='D1_MA5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='V8',name='D1_MCK2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='W8',name='/D1_MCK3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='D9',name='D1_MDQS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='E9',name='D1_MDQ18',func=Pin.BIDIR,do_erc=True),
            Pin(num='G9',name='D1_MDQS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H9',name='D1_MDQ31',func=Pin.BIDIR,do_erc=True),
            Pin(num='K9',name='D1_MECC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='L9',name='D1_MECC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='N9',name='D1_MCKE3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='P9',name='D1_MCKE2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='T9',name='D1_MA6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='U9',name='D1_MA3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='V9',name='/D1_MCK2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='W9',name='D1_MCK3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='Y9',name='D1_MA0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='C10',name='D1_MDQ21',func=Pin.BIDIR,do_erc=True),
            Pin(num='E10',name='D1_MDQ19',func=Pin.BIDIR,do_erc=True),
            Pin(num='F10',name='D1_MDQ28',func=Pin.BIDIR,do_erc=True),
            Pin(num='H10',name='D1_MDQ26',func=Pin.BIDIR,do_erc=True),
            Pin(num='J10',name='D1_MDQ27',func=Pin.BIDIR,do_erc=True),
            Pin(num='L10',name='D1_MECC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='M10',name='D1_MECC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='P10',name='D1_MCKE0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='R10',name='D1_MCKE1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='U10',name='D1_MA4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='Y10',name='D1_MBA1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='C11',name='D1_MDQ20',func=Pin.BIDIR,do_erc=True),
            Pin(num='D11',name='D1_MDM2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='F11',name='D1_MDQ25',func=Pin.BIDIR,do_erc=True),
            Pin(num='G11',name='D1_MDM3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AL1',name='D1_MCK5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='D12',name='D1_MDQ17',func=Pin.BIDIR,do_erc=True),
            Pin(num='E12',name='D1_MDQ10',func=Pin.BIDIR,do_erc=True),
            Pin(num='G12',name='D1_MDQ11',func=Pin.BIDIR,do_erc=True),
            Pin(num='AL2',name='/D1_MCK5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='E13',name='D1_MDQ14',func=Pin.BIDIR,do_erc=True),
            Pin(num='F13',name='D1_MDQ15',func=Pin.BIDIR,do_erc=True),
            Pin(num='A14',name='D1_MDQ3',func=Pin.BIDIR,do_erc=True),
            Pin(num='C14',name='D1_MDQ2',func=Pin.BIDIR,do_erc=True),
            Pin(num='D14',name='D1_MDM1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='F14',name='/D1_MDQS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G14',name='D1_MDQS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='AD4',name='/D1_MDQS4',func=Pin.BIDIR,do_erc=True),
            Pin(num='A15',name='D1_MDQ6',func=Pin.BIDIR,do_erc=True),
            Pin(num='B15',name='D1_MDQ7',func=Pin.BIDIR,do_erc=True),
            Pin(num='D15',name='D1_MDQ8',func=Pin.BIDIR,do_erc=True),
            Pin(num='E15',name='D1_MDQ13',func=Pin.BIDIR,do_erc=True),
            Pin(num='G15',name='D1_MDQ9',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA5',name='D1_MDIC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='AB5',name='D1_MDQ36',func=Pin.BIDIR,do_erc=True),
            Pin(num='AD5',name='D1_MDQS4',func=Pin.BIDIR,do_erc=True),
            Pin(num='AE5',name='D1_MDQ38',func=Pin.BIDIR,do_erc=True),
            Pin(num='AG5',name='D1_MDQ40',func=Pin.BIDIR,do_erc=True),
            Pin(num='AH5',name='/D1_MDQS5',func=Pin.BIDIR,do_erc=True),
            Pin(num='A16',name='D1_MDM0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='B16',name='/D1_MDQS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C16',name='D1_MDQS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F16',name='D1_MDQ12',func=Pin.BIDIR,do_erc=True),
            Pin(num='AB6',name='D1_MDQ37',func=Pin.BIDIR,do_erc=True),
            Pin(num='AC6',name='D1_MDQ33',func=Pin.BIDIR,do_erc=True),
            Pin(num='AE6',name='D1_MDQ39',func=Pin.BIDIR,do_erc=True),
            Pin(num='AF6',name='D1_MDQ34',func=Pin.BIDIR,do_erc=True),
            Pin(num='AH6',name='D1_MDQS5',func=Pin.BIDIR,do_erc=True),
            Pin(num='AJ6',name='D1_MDQ46',func=Pin.BIDIR,do_erc=True),
            Pin(num='A17',name='D1_MDQ0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B17',name='D1_MDQ5',func=Pin.BIDIR,do_erc=True),
            Pin(num='C17',name='D1_MDQ4',func=Pin.BIDIR,do_erc=True),
            Pin(num='D17',name='D1_MDQ1',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA7',name='D1_MA10',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AC7',name='D1_MDQ32',func=Pin.BIDIR,do_erc=True),
            Pin(num='AD7',name='D1_MDM4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AF7',name='D1_MDQ35',func=Pin.BIDIR,do_erc=True),
            Pin(num='AG7',name='D1_MDQ45',func=Pin.BIDIR,do_erc=True),
            Pin(num='AJ7',name='D1_MDQ47',func=Pin.BIDIR,do_erc=True),
            Pin(num='AK7',name='D1_MDQ53',func=Pin.BIDIR,do_erc=True),
            Pin(num='AN7',name='D1_MDQ54',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA8',name='D1_MBA0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AB8',name='/D1_MWE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AD8',name='D1_MODT2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AE8',name='D1_MA13',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AG8',name='D1_MDQ44',func=Pin.BIDIR,do_erc=True),
            Pin(num='AH8',name='D1_MDM5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AK8',name='D1_MDQ52',func=Pin.BIDIR,do_erc=True),
            Pin(num='AL8',name='D1_MDQ49',func=Pin.BIDIR,do_erc=True),
            Pin(num='AN8',name='D1_MDQ55',func=Pin.BIDIR,do_erc=True),
            Pin(num='AB9',name='/D1_MCS2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AC9',name='/D1_MCS0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AE9',name='/D1_MCS1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AF9',name='/D1_MCS3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AH9',name='D1_MDQ41',func=Pin.BIDIR,do_erc=True),
            Pin(num='AJ9',name='D1_MDQ42',func=Pin.BIDIR,do_erc=True),
            Pin(num='AL9',name='D1_MDQ48',func=Pin.BIDIR,do_erc=True),
            Pin(num='AM9',name='/D1_MDQS6',func=Pin.BIDIR,do_erc=True),
            Pin(num='AP9',name='D1_MDQ60',func=Pin.BIDIR,do_erc=True),
            Pin(num='AR9',name='D1_MDQ61',func=Pin.BIDIR,do_erc=True),
            Pin(num='AT9',name='D1_MDQ56',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA10',name='/D1_MRAS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AC10',name='/D1_MCAS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AD10',name='D1_MODT0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AF10',name='D1_MODT3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AG10',name='D1_MODT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AJ10',name='D1_MDQ43',func=Pin.BIDIR,do_erc=True),
            Pin(num='AM10',name='D1_MDQS6',func=Pin.BIDIR,do_erc=True),
            Pin(num='AN10',name='D1_MDQ50',func=Pin.BIDIR,do_erc=True),
            Pin(num='AR10',name='D1_MDQ57',func=Pin.BIDIR,do_erc=True),
            Pin(num='AT10',name='D1_MDM7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AL11',name='D1_MDM6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AN11',name='D1_MDQ51',func=Pin.BIDIR,do_erc=True),
            Pin(num='AT11',name='/D1_MDQS7',func=Pin.BIDIR,do_erc=True),
            Pin(num='AP12',name='D1_MDQ63',func=Pin.BIDIR,do_erc=True),
            Pin(num='AR12',name='D1_MDQ62',func=Pin.BIDIR,do_erc=True),
            Pin(num='AT12',name='D1_MDQS7',func=Pin.BIDIR,do_erc=True),
            Pin(num='AR13',name='D1_MDQ59',func=Pin.BIDIR,do_erc=True),
            Pin(num='AT13',name='D1_MDQ58',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='D2_MDQ16',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='/D2_MDQS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='D2_MDQ22',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='D2_MDQ19',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='D2_MCK4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='H1',name='D2_MDQ31',func=Pin.BIDIR,do_erc=True),
            Pin(num='J1',name='D2_MECC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='K1',name='/D2_MDQS8',func=Pin.BIDIR,do_erc=True),
            Pin(num='L1',name='D2_MDQS8',func=Pin.BIDIR,do_erc=True),
            Pin(num='M1',name='D2_MBA2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='N1',name='D2_MA12',func=Pin.OUTPUT,do_erc=True),
            Pin(num='P1',name='D2_MA9',func=Pin.OUTPUT,do_erc=True),
            Pin(num='R1',name='D2_MA6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='T1',name='D2_MA3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='U1',name='D2_MA1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='V1',name='D2_MCK2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='W1',name='/D2_MCK3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='Y1',name='D2_MAPAR_OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='A2',name='D2_MDQ21',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='D2_MDQS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='D2_MDQ23',func=Pin.BIDIR,do_erc=True),
            Pin(num='G2',name='/D2_MCK4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='J2',name='D2_MECC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='K2',name='D2_MDM8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='M2',name='D2_MA15',func=Pin.OUTPUT,do_erc=True),
            Pin(num='N2',name='/D2_MAPA_ERR',do_erc=True),
            Pin(num='R2',name='D2_MA8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='T2',name='D2_MA4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='V2',name='/D2_MCK2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='W2',name='D2_MCK3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='A3',name='D2_MDQ20',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='D2_MDQ17',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='D2_MDQ18',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='D2_MDQ29',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='D2_MDM3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='H3',name='D2_MDQ30',func=Pin.BIDIR,do_erc=True),
            Pin(num='K3',name='D2_MECC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='L3',name='D2_MECC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='N3',name='D2_MA14',func=Pin.OUTPUT,do_erc=True),
            Pin(num='P3',name='D2_MA11',func=Pin.OUTPUT,do_erc=True),
            Pin(num='T3',name='D2_MA5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='V3',name='D2_MCK1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='W3',name='D2_MCK0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='A4',name='D2_MDQ10',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='D2_MDQ11',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='D2_MDM2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='E4',name='D2_MDQ28',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='D2_MDQ24',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='D2_MDQ26',func=Pin.BIDIR,do_erc=True),
            Pin(num='J4',name='D2_MECC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='L4',name='D2_MECC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='M4',name='D2_MCKE3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='P4',name='D2_MCKE2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='R4',name='D2_MA7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='U4',name='D2_MA2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='V4',name='/D2_MCK1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='W4',name='/D2_MCK0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='Y4',name='D2_MA0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='A5',name='D2_MDQS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='D2_MDQ14',func=Pin.BIDIR,do_erc=True),
            Pin(num='D5',name='D2_MDQ15',func=Pin.BIDIR,do_erc=True),
            Pin(num='F5',name='D2_MDQ25',func=Pin.BIDIR,do_erc=True),
            Pin(num='G5',name='/D2_MDQS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M5',name='D2_MECC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='N5',name='D2_MECC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='R5',name='D2_MCKE0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='T5',name='D2_MCKE1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='A6',name='/D2_MDQS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='D2_MDM1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='D6',name='D2_MDQ9',func=Pin.BIDIR,do_erc=True),
            Pin(num='G6',name='D2_MDQS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H6',name='D2_MDQ27',func=Pin.BIDIR,do_erc=True),
            Pin(num='Y6',name='D2_MDIC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='D2_MDQ8',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='D2_MDQ13',func=Pin.BIDIR,do_erc=True),
            Pin(num='C7',name='D2_MDQ12',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='D2_MDQ3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A9',name='D2_MDQ7',func=Pin.BIDIR,do_erc=True),
            Pin(num='B9',name='D2_MDQ2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A10',name='D2_MDQS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B10',name='D2_MDQ6',func=Pin.BIDIR,do_erc=True),
            Pin(num='A11',name='/D2_MDQS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA1',name='D2_MBA1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AB1',name='/D2_MRAS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AC1',name='/D2_MCS0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AD1',name='D2_MODT2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AE1',name='/D2_MCS1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AF1',name='D2_MODT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AG1',name='D2_MDM4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AH1',name='D2_MDQ38',func=Pin.BIDIR,do_erc=True),
            Pin(num='AJ1',name='D2_MDQ35',func=Pin.BIDIR,do_erc=True),
            Pin(num='AK1',name='/D2_MCK5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AM1',name='D2_MDQ52',func=Pin.BIDIR,do_erc=True),
            Pin(num='AN1',name='D2_MDQ48',func=Pin.BIDIR,do_erc=True),
            Pin(num='AP1',name='/D2_MDQS6',func=Pin.BIDIR,do_erc=True),
            Pin(num='AR1',name='D2_MDQS6',func=Pin.BIDIR,do_erc=True),
            Pin(num='AT1',name='D2_MDQ50',func=Pin.BIDIR,do_erc=True),
            Pin(num='A12',name='D2_MDQ1',func=Pin.BIDIR,do_erc=True),
            Pin(num='B12',name='D2_MDM0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AA2',name='D2_MA10',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AB2',name='/D2_MWE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AD2',name='D2_MODT0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AE2',name='/D2_MCS3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AG2',name='D2_MDQ33',func=Pin.BIDIR,do_erc=True),
            Pin(num='AH2',name='D2_MDQS4',func=Pin.BIDIR,do_erc=True),
            Pin(num='AK2',name='D2_MCK5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AN2',name='D2_MDQ53',func=Pin.BIDIR,do_erc=True),
            Pin(num='AP2',name='D2_MDM6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AT2',name='D2_MDQ51',func=Pin.BIDIR,do_erc=True),
            Pin(num='A13',name='D2_MDQ4',func=Pin.BIDIR,do_erc=True),
            Pin(num='B13',name='D2_MDQ5',func=Pin.BIDIR,do_erc=True),
            Pin(num='C13',name='D2_MDQ0',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA3',name='D2_MBA0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AB3',name='/D2_MCS2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AC3',name='/D2_MCAS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AE3',name='D2_MODT3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AF3',name='D2_MDQ37',func=Pin.BIDIR,do_erc=True),
            Pin(num='AH3',name='/D2_MDQS4',func=Pin.BIDIR,do_erc=True),
            Pin(num='AJ3',name='D2_MDQ34',func=Pin.BIDIR,do_erc=True),
            Pin(num='AL3',name='D2_MDM5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AM3',name='/D2_MDQS5',func=Pin.BIDIR,do_erc=True),
            Pin(num='AP3',name='D2_MDQ49',func=Pin.BIDIR,do_erc=True),
            Pin(num='AR3',name='D2_MDQ54',func=Pin.BIDIR,do_erc=True),
            Pin(num='AT3',name='D2_MDQ55',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA4',name='D2_MDIC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='AC4',name='D2_MA13',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AF4',name='D2_MDQ36',func=Pin.BIDIR,do_erc=True),
            Pin(num='AG4',name='D2_MDQ32',func=Pin.BIDIR,do_erc=True),
            Pin(num='AJ4',name='D2_MDQ39',func=Pin.BIDIR,do_erc=True),
            Pin(num='AK4',name='D2_MDQ45',func=Pin.BIDIR,do_erc=True),
            Pin(num='AM4',name='D2_MDQS5',func=Pin.BIDIR,do_erc=True),
            Pin(num='AN4',name='D2_MDQ42',func=Pin.BIDIR,do_erc=True),
            Pin(num='AR4',name='D2_MDQ60',func=Pin.BIDIR,do_erc=True),
            Pin(num='AT4',name='D2_MDQ61',func=Pin.BIDIR,do_erc=True),
            Pin(num='AK5',name='D2_MDQ44',func=Pin.BIDIR,do_erc=True),
            Pin(num='AL5',name='D2_MDQ41',func=Pin.BIDIR,do_erc=True),
            Pin(num='AN5',name='D2_MDQ43',func=Pin.BIDIR,do_erc=True),
            Pin(num='AP5',name='D2_MDQ56',func=Pin.BIDIR,do_erc=True),
            Pin(num='AT5',name='D2_MDQ57',func=Pin.BIDIR,do_erc=True),
            Pin(num='AL6',name='D2_MDQ40',func=Pin.BIDIR,do_erc=True),
            Pin(num='AM6',name='D2_MDQ46',func=Pin.BIDIR,do_erc=True),
            Pin(num='AP6',name='D2_MDM7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AR6',name='D2_MDQS7',func=Pin.BIDIR,do_erc=True),
            Pin(num='AT6',name='/D2_MDQS7',func=Pin.BIDIR,do_erc=True),
            Pin(num='AM7',name='D2_MDQ47',func=Pin.BIDIR,do_erc=True),
            Pin(num='AR7',name='D2_MDQ62',func=Pin.BIDIR,do_erc=True),
            Pin(num='AT7',name='D2_MDQ63',func=Pin.BIDIR,do_erc=True),
            Pin(num='AP8',name='D2_MDQ58',func=Pin.BIDIR,do_erc=True),
            Pin(num='AT8',name='D2_MDQ59',func=Pin.BIDIR,do_erc=True),
            Pin(num='D20',name='/LCS1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='E20',name='/LCS2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='G20',name='LA25',func=Pin.OUTPUT,do_erc=True),
            Pin(num='J20',name='LA26',func=Pin.OUTPUT,do_erc=True),
            Pin(num='K20',name='LA27',func=Pin.OUTPUT,do_erc=True),
            Pin(num='D21',name='/LCS3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='E21',name='LA21',func=Pin.OUTPUT,do_erc=True),
            Pin(num='F21',name='LA22',func=Pin.OUTPUT,do_erc=True),
            Pin(num='H21',name='LA23',func=Pin.OUTPUT,do_erc=True),
            Pin(num='K21',name='LA24',func=Pin.OUTPUT,do_erc=True),
            Pin(num='C22',name='LBCTL',func=Pin.OUTPUT,do_erc=True),
            Pin(num='D22',name='/LCS4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='F22',name='LA19',func=Pin.OUTPUT,do_erc=True),
            Pin(num='G22',name='LAD11',func=Pin.BIDIR,do_erc=True),
            Pin(num='H22',name='LA20',func=Pin.OUTPUT,do_erc=True),
            Pin(num='J22',name='LAD10',func=Pin.BIDIR,do_erc=True),
            Pin(num='A23',name='LALE',func=Pin.BIDIR,do_erc=True),
            Pin(num='B23',name='/LCS5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='C23',name='LCLK1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='D23',name='LAD9',func=Pin.BIDIR,do_erc=True),
            Pin(num='E23',name='LAD8',func=Pin.BIDIR,do_erc=True),
            Pin(num='G23',name='LAD7',func=Pin.BIDIR,do_erc=True),
            Pin(num='H23',name='LA18',func=Pin.OUTPUT,do_erc=True),
            Pin(num='K23',name='LDP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A24',name='/LWE1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='C24',name='LCLK0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='D24',name='/LWE0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='F24',name='/LCS6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='G24',name='LAD6',func=Pin.BIDIR,do_erc=True),
            Pin(num='H24',name='LAD5',func=Pin.BIDIR,do_erc=True),
            Pin(num='J24',name='LDP0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B25',name='LGPL0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='C25',name='LGPL4',func=Pin.BIDIR,do_erc=True),
            Pin(num='D25',name='LGPL2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='E25',name='LGPL1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='F25',name='LAD4',func=Pin.BIDIR,do_erc=True),
            Pin(num='G25',name='LA17',func=Pin.OUTPUT,do_erc=True),
            Pin(num='H25',name='LAD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='J25',name='LA16',func=Pin.OUTPUT,do_erc=True),
            Pin(num='E26',name='LGPL5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='G26',name='/LCS7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='H26',name='LGPL3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='J26',name='LAD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='K26',name='LAD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='L26',name='LAD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J17',name='LAD15',func=Pin.BIDIR,do_erc=True),
            Pin(num='G18',name='LA31',func=Pin.OUTPUT,do_erc=True),
            Pin(num='J18',name='LAD13',func=Pin.BIDIR,do_erc=True),
            Pin(num='K18',name='LAD14',func=Pin.BIDIR,do_erc=True),
            Pin(num='D19',name='/LCS0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='F19',name='LAD12',func=Pin.BIDIR,do_erc=True),
            Pin(num='G19',name='LA28',func=Pin.OUTPUT,do_erc=True),
            Pin(num='H19',name='LA29',func=Pin.OUTPUT,do_erc=True),
            Pin(num='J19',name='LA30',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AG20',name='GPIO7',func=Pin.BIDIR,do_erc=True),
            Pin(num='AJ20',name='/DMA2_DREQ0',do_erc=True),
            Pin(num='AJ20',name='GPIO20/DMA2_DREQ0/ALT_MDVAL',func=Pin.BIDIR,do_erc=True),
            Pin(num='AM20',name='GPIO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AN20',name='GPIO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='AP20',name='/DMA2_DDONE0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AK11',name='GPIO27/IRQ9',func=Pin.BIDIR,do_erc=True),
            Pin(num='AK11',name='IRQ9/GPIO27',do_erc=True),
            Pin(num='AH21',name='GPIO4',func=Pin.BIDIR,do_erc=True),
            Pin(num='AJ21',name='GPIO5',func=Pin.BIDIR,do_erc=True),
            Pin(num='AK21',name='GPIO6',func=Pin.BIDIR,do_erc=True),
            Pin(num='AL21',name='GPIO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='AN21',name='/DMA1_DDONE0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AP21',name='/DMA1_DREQ0',do_erc=True),
            Pin(num='AP21',name='GPIO18/DMA1_DREQ0',func=Pin.BIDIR,do_erc=True),
            Pin(num='AK12',name='IRQ2',do_erc=True),
            Pin(num='AL12',name='GPIO29/IRQ11',func=Pin.BIDIR,do_erc=True),
            Pin(num='AL12',name='IRQ11/GPIO29',do_erc=True),
            Pin(num='AJ22',name='GPIO9/UART2_SOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='AK22',name='GPIO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='AL22',name='GPIO8/UART1_SOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='AM22',name='GPIO12/RTS/UART3_SOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='AP22',name='GPIO14/CTS/UART3_SIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='AG13',name='GPIO26/IRQ8',func=Pin.BIDIR,do_erc=True),
            Pin(num='AG13',name='IRQ8/GPIO26',do_erc=True),
            Pin(num='AJ13',name='GPIO23/IRQ5',func=Pin.BIDIR,do_erc=True),
            Pin(num='AJ13',name='IRQ5/GPIO23',do_erc=True),
            Pin(num='AK13',name='GPIO16/IIC3_SCL/SDHC_CD',func=Pin.BIDIR,do_erc=True),
            Pin(num='AM13',name='GPIO25/IRQ7',func=Pin.BIDIR,do_erc=True),
            Pin(num='AM13',name='IRQ7/GPIO25',do_erc=True),
            Pin(num='AH23',name='GPIO15/CTS/UART4_SIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='AK23',name='GPIO13/RTS/UART4_SOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='AN23',name='GPIO11/UART2_SIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='AR23',name='GPIO10/UART1_SIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='AH14',name='GPIO28/IRQ10',func=Pin.BIDIR,do_erc=True),
            Pin(num='AH14',name='IRQ10/GPIO28',do_erc=True),
            Pin(num='AK14',name='/IRQ_OUT/EVT9',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AM14',name='GPIO17/IIC3_SDA/SDHC_WP',func=Pin.BIDIR,do_erc=True),
            Pin(num='AJ34',name='GPIO31/TSEC_1588_PULSE_OUT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AJ15',name='GPIO21/IRQ3',func=Pin.BIDIR,do_erc=True),
            Pin(num='AJ15',name='IRQ3/GPIO21',do_erc=True),
            Pin(num='AK35',name='GPIO30/TSEC_1588_ALARM_OUT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AH16',name='IRQ1',do_erc=True),
            Pin(num='AJ16',name='IRQ0',do_erc=True),
            Pin(num='AG17',name='GPIO24/IRQ6',func=Pin.BIDIR,do_erc=True),
            Pin(num='AG17',name='IRQ6/GPIO24',do_erc=True),
            Pin(num='AH17',name='GPIO22/IRQ4',func=Pin.BIDIR,do_erc=True),
            Pin(num='AH17',name='IRQ4/GPIO22',do_erc=True),
            Pin(num='AG19',name='/DMA2_DACK0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AL19',name='/DMA1_DACK0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AL19',name='GPIO19/DMA1_DACK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='AN19',name='/TMP_DETECT',do_erc=True),
            Pin(num='C30',name='SD_RX2',do_erc=True),
            Pin(num='D30',name='/SD_RX2',do_erc=True),
            Pin(num='G30',name='/SD_TX2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='H30',name='SD_TX2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='T30',name='SD_TX11',func=Pin.OUTPUT,do_erc=True),
            Pin(num='Y30',name='/SD_TX13',func=Pin.OUTPUT,do_erc=True),
            Pin(num='A31',name='SD_RX3',do_erc=True),
            Pin(num='B31',name='/SD_RX3',do_erc=True),
            Pin(num='E31',name='/SD_TX3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='F31',name='SD_TX3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='K31',name='SD_TX7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='M31',name='SD_TX8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='P31',name='SD_TX10',func=Pin.OUTPUT,do_erc=True),
            Pin(num='T31',name='/SD_TX11',func=Pin.OUTPUT,do_erc=True),
            Pin(num='W31',name='SD_TX12',func=Pin.OUTPUT,do_erc=True),
            Pin(num='K32',name='/SD_TX7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='M32',name='/SD_TX8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='P32',name='/SD_TX10',func=Pin.OUTPUT,do_erc=True),
            Pin(num='W32',name='/SD_TX12',func=Pin.OUTPUT,do_erc=True),
            Pin(num='F33',name='/SD_TX5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='G33',name='SD_TX5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='J33',name='SD_TX6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='L33',name='/SD_RX8',do_erc=True),
            Pin(num='N33',name='SD_TX9',func=Pin.OUTPUT,do_erc=True),
            Pin(num='T33',name='/SD_RX11',do_erc=True),
            Pin(num='V33',name='/SD_REF_CLK2',do_erc=True),
            Pin(num='Y33',name='/SD_RX13',do_erc=True),
            Pin(num='D34',name='SD_TX4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='E34',name='/SD_TX4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='J34',name='/SD_TX6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='L34',name='SD_RX8',do_erc=True),
            Pin(num='N34',name='/SD_TX9',func=Pin.OUTPUT,do_erc=True),
            Pin(num='T34',name='SD_RX11',do_erc=True),
            Pin(num='V34',name='SD_REF_CLK2',do_erc=True),
            Pin(num='Y34',name='SD_RX13',do_erc=True),
            Pin(num='A35',name='SD_REF_CLK1',do_erc=True),
            Pin(num='B35',name='/SD_REF_CLK1',do_erc=True),
            Pin(num='F35',name='/SD_RX5',do_erc=True),
            Pin(num='H35',name='/SD_RX6',do_erc=True),
            Pin(num='K35',name='/SD_RX7',do_erc=True),
            Pin(num='M35',name='/SD_RX9',do_erc=True),
            Pin(num='P35',name='/SD_RX10',do_erc=True),
            Pin(num='W35',name='/SD_RX12',do_erc=True),
            Pin(num='C36',name='/SD_RX4',do_erc=True),
            Pin(num='D36',name='SD_RX4',do_erc=True),
            Pin(num='F36',name='SD_RX5',do_erc=True),
            Pin(num='H36',name='SD_RX6',do_erc=True),
            Pin(num='K36',name='SD_RX7',do_erc=True),
            Pin(num='M36',name='SD_RX9',do_erc=True),
            Pin(num='P36',name='SD_RX10',do_erc=True),
            Pin(num='W36',name='SD_RX12',do_erc=True),
            Pin(num='C28',name='SD_RX0',do_erc=True),
            Pin(num='D28',name='/SD_RX0',do_erc=True),
            Pin(num='G28',name='/SD_TX0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='H28',name='SD_TX0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='A29',name='SD_RX1',do_erc=True),
            Pin(num='B29',name='/SD_RX1',do_erc=True),
            Pin(num='E29',name='/SD_TX1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='F29',name='SD_TX1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='Y29',name='SD_TX13',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AA31',name='SD_TX14',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AC31',name='/SD_REF_CLK3',do_erc=True),
            Pin(num='AE31',name='SD_TX16',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AG31',name='SD_TX17',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AA32',name='/SD_TX14',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AC32',name='SD_REF_CLK3',do_erc=True),
            Pin(num='AE32',name='/SD_TX16',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AG32',name='/SD_TX17',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AB33',name='SD_TX15',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AF33',name='/SD_RX16',do_erc=True),
            Pin(num='AB34',name='/SD_TX15',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AF34',name='SD_RX16',do_erc=True),
            Pin(num='AA35',name='/SD_RX14',do_erc=True),
            Pin(num='AC35',name='/SD_RX15',do_erc=True),
            Pin(num='AG35',name='/SD_RX17',do_erc=True),
            Pin(num='AA36',name='SD_RX14',do_erc=True),
            Pin(num='AC36',name='SD_RX15',do_erc=True),
            Pin(num='AG36',name='SD_RX17',do_erc=True),
            Pin(num='A30',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='B30',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='E30',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F30',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='J30',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='K30',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='L30',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='M30',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N30',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='P30',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='R30',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='U30',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='V30',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='W30',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='C31',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='D31',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G31',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H31',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='J31',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='L31',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='N31',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='R31',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='U31',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='V31',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y31',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='A32',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B32',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E32',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F32',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G32',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H32',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J32',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='L32',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N32',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R32',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='T32',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='V32',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y32',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A33',name='AVDD_SRDS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='B33',name='AGND_SRDS1',func=Pin.PWRIN,do_erc=True),
            Pin(num='C33',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='D33',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='E33',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H33',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='K33',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='M33',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='P33',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='R33',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='U33',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='W33',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A34',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='B34',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='C34',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F34',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G34',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H34',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='K34',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='M34',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='P34',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R34',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='U34',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='W34',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='C35',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='D35',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='E35',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G35',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='J35',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='L35',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='N35',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R35',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='T35',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='V35',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y35',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A36',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B36',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E36',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G36',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J36',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='L36',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N36',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='R36',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='T36',name='AGND_SRDS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='U36',name='AVDD_SRDS2',func=Pin.PWRIN,do_erc=True),
            Pin(num='V36',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y36',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='B27',name='SD_IMP_CAL_RX',do_erc=True),
            Pin(num='A28',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B28',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E28',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F28',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='J28',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='K28',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='C29',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='D29',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G29',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H29',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J29',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='K29',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='L29',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='M29',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='N29',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='P29',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R29',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='T29',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='U29',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='V29',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='W29',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA30',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB30',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC30',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD30',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE30',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF30',name='SD_IMP_CAL_TX',do_erc=True),
            Pin(num='AG30',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB31',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD31',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF31',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AH31',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB32',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD32',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF32',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AH32',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA33',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC33',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE33',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AG33',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AH33',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA34',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC34',name='XGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE34',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AG34',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB35',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD35',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE35',name='AVDD_SRDS3',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF35',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AH35',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB36',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD36',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE36',name='AGND_SRDS3',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF36',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AH36',name='SVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA29',name='XVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AH20',name='MSRCID0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AJ20',name='ALT_MDVAL/DMA2_DREQ0/GPIO20',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AK20',name='CLK_OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AP20',name='/EVT8/DMA2_DDONE0:ALT_MSRCID1',func=Pin.BIDIR,do_erc=True),
            Pin(num='AP20',name='ALT_MSRCID1/DMA2_DDONE0/EVT8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AR20',name='TMS',do_erc=True),
            Pin(num='AL30',name='TSEC_1588_PULSE_OUT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AM30',name='TSEC_1588_CLK_OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AP30',name='USB2_D6/EC2_TXD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AR30',name='USB2_D5/EC2_TXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='AT30',name='USB2_D4/EC2_TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='AR21',name='ASLEEP',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AT21',name='/TEST_SEL',do_erc=True),
            Pin(num='AN31',name='USB2_CLK/EC2_GTX_CLK',do_erc=True),
            Pin(num='AR31',name='USB2_STP/EC2_TX_EN',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AT31',name='USB2_D7/EC2_TXD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='AG22',name='SDHC_DAT3',func=Pin.BIDIR,do_erc=True),
            Pin(num='AJ22',name='UART2_SDOUT/GPIO9',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AL22',name='UART1_SDOUT/GPIO8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AM22',name='UART1_RTS/UART3_SDOUT/GPIO12',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AP22',name='UART1_CTS/UART3_SIN/GPIO14',do_erc=True),
            Pin(num='AR22',name='TCK',do_erc=True),
            Pin(num='AN32',name='USB2_D2/EC2_RXD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AP32',name='USB2_D1/EC2_RXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='AT32',name='USB2_D0/EC2_RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='AK13',name='/SDHC_CD/IIC3_SCL/GPIO16',do_erc=True),
            Pin(num='AK13',name='IIC3_SCL/GPIO16/SDHC_CD',func=Pin.BIDIR,do_erc=True),
            Pin(num='AG23',name='SDHC_CMD',func=Pin.BIDIR,do_erc=True),
            Pin(num='AH23',name='UART2_CTS/UART4_SIN/GPIO15',do_erc=True),
            Pin(num='AK23',name='UART2_RTS/UART4_SDOUT/GPIO13',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AL23',name='SDHC_CLK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AM23',name='SDHC_DAT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AN23',name='UART2_SIN/GPIO11',do_erc=True),
            Pin(num='AR23',name='UART1_SIN/GPIO10',do_erc=True),
            Pin(num='AT23',name='SYSCLK',do_erc=True),
            Pin(num='AM33',name='USB1_D3/EC1_RXD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='AP33',name='USB2_D3/EC2_RXD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='AR33',name='USB2_NXT/EC2_RX_DV',do_erc=True),
            Pin(num='AT33',name='USB2_DIR/EC2_RX_CLK',do_erc=True),
            Pin(num='AG14',name='/EVT5/IIC4_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='AG14',name='IIC4_SCL/EVT5',func=Pin.BIDIR,do_erc=True),
            Pin(num='AK14',name='/EVT9/IRQ_OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='AL14',name='INC2_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='AM14',name='/SDHC_WP/IIC3_SDA/GPIO17',do_erc=True),
            Pin(num='AM14',name='IIC3_SDA/GPIO17/SDHC_WP',func=Pin.BIDIR,do_erc=True),
            Pin(num='AN14',name='IIC1_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='AN24',name='RTC',do_erc=True),
            Pin(num='AP24',name='SDHC_DAT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='AT24',name='SDHC_DAT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='AJ34',name='TSEC_1588_PULSE_OUT2/GPIO31',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AM34',name='USB1_NXT/EC1_RX_DV',do_erc=True),
            Pin(num='AN34',name='USB1_D2/EC1_RXD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AR34',name='USB1_D5/EC1_TXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='AT34',name='USB1_D6/EC1_TXD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AH15',name='IIC1_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='AL15',name='/EVT6/IIC4_SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='AL15',name='IIC4_SDA/EVT6',func=Pin.BIDIR,do_erc=True),
            Pin(num='AM15',name='INC2_SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='AP15',name='TDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AR15',name='MDVA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AK35',name='TSEC_1588_ALARM_OUT2/GPIO30',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AL35',name='TSEC_1588_CLK_IN',do_erc=True),
            Pin(num='AN35',name='USB1_D0/EC1_RXD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='AP35',name='USB1_CLK/EC1_GTX_CLK',do_erc=True),
            Pin(num='AT35',name='USB1_D4/EC1_TXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='AK16',name='/EVT3',func=Pin.BIDIR,do_erc=True),
            Pin(num='AM16',name='/EVT4',func=Pin.BIDIR,do_erc=True),
            Pin(num='AN16',name='/EVT2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AT16',name='/RESET_REQ',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AJ36',name='TSEC_1588_ALARM_OUT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AK36',name='TSEC_1588_TRIG_IN2',do_erc=True),
            Pin(num='AL36',name='TSEC_1588_TRIG_IN1C',do_erc=True),
            Pin(num='AM36',name='USB1_DIR/EC1_RX_CLK',do_erc=True),
            Pin(num='AN36',name='USB1_D0/EC1_RXD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='AP36',name='USB1_D7/EC1_TXD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='AR36',name='USB1_STP/EC1_TX_EN',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AJ17',name='/EVT0',func=Pin.BIDIR,do_erc=True),
            Pin(num='AK17',name='/EVT1',func=Pin.BIDIR,do_erc=True),
            Pin(num='AL17',name='/SCAN_MODE',do_erc=True),
            Pin(num='AN17',name='TDI',do_erc=True),
            Pin(num='AP17',name='/PORESET',do_erc=True),
            Pin(num='AR17',name='/HRESET',func=Pin.BIDIR,do_erc=True),
            Pin(num='AH18',name='MSRCID2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AK18',name='IO_VSEL2',do_erc=True),
            Pin(num='AL18',name='IO_VSEL0',do_erc=True),
            Pin(num='AM18',name='IO_VSEL3',do_erc=True),
            Pin(num='AP18',name='IO_VSEL1',do_erc=True),
            Pin(num='AH28',name='SPI_MISO',do_erc=True),
            Pin(num='AJ28',name='/SPI_CS1/SDHC_DAT5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AJ28',name='SDHC_DAT5/SPI_CS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='AG19',name='/EVT7/DMA2_DACK0/ALT_MSRCID0',func=Pin.BIDIR,do_erc=True),
            Pin(num='AG19',name='ALT_MSRCID0/DMA2_DACK0/EVT7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AH19',name='IO_VSEL4',do_erc=True),
            Pin(num='AJ19',name='MSRCID1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AM19',name='/CKSTP_OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AR19',name='/TRST',do_erc=True),
            Pin(num='AK29',name='SPI_CLK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AM29',name='/SPI_CS3/SDHC_DAT7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AM29',name='SDHC_DAT7/SPI_CS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='AN29',name='/SPI_CS0/SDHC_DAT4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AN29',name='SDHC_DAT4/SPI_CS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='AR29',name='/SPI_CS2/SDHC_DAT6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AR29',name='SDHC_DAT6/SPI_CS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AT29',name='SPI_MOSI',func=Pin.BIDIR,do_erc=True),
            Pin(num='AJ30',name='EMI2_MDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='AK30',name='EMI2_MDC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AP30',name='EC2_TXD2/USB2_D6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AR30',name='EC2_TXD1/USB2_D5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AT30',name='EC2_TXD0/USB2_D4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AJ31',name='EC_XTRNL_TX_STMP2',do_erc=True),
            Pin(num='AK31',name='EC_XTRNL_RX_STMP2',do_erc=True),
            Pin(num='AM31',name='EC_XTRNL_TX_STMP1',do_erc=True),
            Pin(num='AN31',name='EC2_GTX_CLK/USB2_CLK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AR31',name='EC2_TX_EN/USB2_STP',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AT31',name='EC2_TXD3/USB2_D7',func=Pin.BIDIR,do_erc=True),
            Pin(num='AK32',name='EC_XTRNL_RX_STMP1',do_erc=True),
            Pin(num='AL32',name='EMI1_MDIO',func=Pin.BIDIR,do_erc=True),
            Pin(num='AN32',name='EC2_RXD2/USB2_D2',do_erc=True),
            Pin(num='AP32',name='EC2_RXD1/USB2_D1',do_erc=True),
            Pin(num='AT32',name='EC2_RXD0/USB2_D0',do_erc=True),
            Pin(num='AJ33',name='EMI1_MDC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AM33',name='EC1_RXD3/USB1_D3',do_erc=True),
            Pin(num='AP33',name='EC2_RXD3/USB2_D3',do_erc=True),
            Pin(num='AR33',name='EC2_RX_DV/USB2_NXT',do_erc=True),
            Pin(num='AT33',name='EC2_RX_CLK/USB2_DIR',do_erc=True),
            Pin(num='AK34',name='EC_GTX_CLK125',do_erc=True),
            Pin(num='AM34',name='EC1_RX_DV/USB1_NXT',do_erc=True),
            Pin(num='AN34',name='EC1_RXD2/USB1_D2',do_erc=True),
            Pin(num='AR34',name='EC1_TXD1/USB1_D5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AT34',name='EC1_TXD2/USB1_D6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AN35',name='EC1_RXD1/USB1_D1',do_erc=True),
            Pin(num='AP35',name='EC1_GTX_CLK/USB1_CLK',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AT35',name='EC1_TXD0/USB1_D4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='AM36',name='EC1_RX_CLK/USB1_DIR',do_erc=True),
            Pin(num='AN36',name='EC1_RXD0/USB1_D0',do_erc=True),
            Pin(num='AP36',name='EC1_TXD3/USB1_D7',func=Pin.BIDIR,do_erc=True),
            Pin(num='AR36',name='EC1_TX_EN/USB1_STP',func=Pin.OUTPUT,do_erc=True),
            Pin(num='C3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='M3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='U3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='E5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='L5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='P5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='U5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='D7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='K7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='T7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='W7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='C9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='M9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='V10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='L20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='U20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='W20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='E11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='M11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='P11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='T11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='V11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='M21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='P21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='T21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='V21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='L12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='U12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='W12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='L22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='U22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='W22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='D13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='M13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='P13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='T13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='V13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='M23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='P23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='T23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='V23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AG3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AK3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AN3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='L14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='U14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='W14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='L24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='U24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='W24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='C15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='M15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='P15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='T15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='V15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='K25',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='M25',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='P25',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='T25',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='V25',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y25',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AJ5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AM5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AR5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='L16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='U16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='W16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A26',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N26',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R26',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='U26',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='W26',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='E17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='M17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='P17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='T17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='V17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F27',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J27',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='M27',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='P27',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='T27',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='V27',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y27',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AH7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AL7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AP7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='L18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='U18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='W18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='E19',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='K19',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='M19',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='P19',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='T19',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='V19',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y19',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AG9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AK9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AN9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AN30',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AJ11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AM11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AR11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AM21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AH22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AT22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AJ32',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AM32',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AR32',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AH13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AL13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AP13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AP23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AH34',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AK34',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AL34',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AP34',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AK15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AN15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB25',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD25',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF25',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AR16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA26',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC26',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE26',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AT36',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AM17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB27',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD27',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE27',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AG18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AR18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AK28',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB19',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD19',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF19',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AK19',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AP19',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AL29',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B2',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E2',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H2',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='L2',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='P2',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='U2',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y2',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='D4',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G4',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='K4',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='N4',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='T4',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='C6',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F6',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='J6',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='M6',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='R6',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='V7',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='B8',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E8',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H8',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='L8',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='P8',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='U8',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y8',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='D10',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G10',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='K10',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='N10',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='T10',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='W10',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='A20',name='AVDD_CC1',func=Pin.PWRIN,do_erc=True),
            Pin(num='F20',name='BVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H20',name='BVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='A21',name='AVDD_CC2',func=Pin.PWRIN,do_erc=True),
            Pin(num='C12',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='F12',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='J12',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E22',name='BVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='K22',name='BVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC2',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF2',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AJ2',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AM2',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AR2',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='B14',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E14',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H14',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='B24',name='BVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='E24',name='BVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='K24',name='BVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB4',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE4',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AH4',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AL4',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AP4',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='D16',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='G16',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='K16',name='SENSEVDD_CA',func=Pin.PWRIN,do_erc=True),
            Pin(num='F26',name='BVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA6',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD6',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AG6',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AK6',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AN6',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='K17',name='SENSEGND_CA',func=Pin.PWRIN,do_erc=True),
            Pin(num='K27',name='SENSEGND_PL2',func=Pin.PWRIN,do_erc=True),
            Pin(num='L27',name='SENSEVDD_PL2',func=Pin.PWRIN,do_erc=True),
            Pin(num='C18',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='H18',name='BVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC8',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF8',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AJ8',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AM8',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AR8',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='A19',name='AVDD_DDR',func=Pin.PWRIN,do_erc=True),
            Pin(num='B19',name='MVREF',do_erc=True),
            Pin(num='AB10',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE10',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AH10',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AK10',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AL10',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AP10',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AL20',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AT20',name='AVDD_PLAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF11',name='SENSEVDD_PL1',func=Pin.PWRIN,do_erc=True),
            Pin(num='AG21',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AL31',name='LVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AP31',name='LVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF12',name='SENSEGND_PL1',func=Pin.PWRIN,do_erc=True),
            Pin(num='AJ12',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AN12',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AN22',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AJ23',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AK33',name='LVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AN33',name='LVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AJ14',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AR14',name='GVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AR24',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AG15',name='SENSEVDD_CB',func=Pin.PWRIN,do_erc=True),
            Pin(num='AT15',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AJ35',name='LVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AM35',name='LVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AR35',name='LVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AG16',name='SENSEGND_CB',func=Pin.PWRIN,do_erc=True),
            Pin(num='AL16',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AP16',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AT17',name='POVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AJ18',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AN18',name='OVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AT18',name='AVDD_CC3',func=Pin.PWRIN,do_erc=True),
            Pin(num='AT19',name='AVDD_CC4',func=Pin.PWRIN,do_erc=True),
            Pin(num='AJ29',name='CVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='AP29',name='CVDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='M20',name='VDD_CA',func=Pin.PWRIN,do_erc=True),
            Pin(num='P20',name='VDD_CA',func=Pin.PWRIN,do_erc=True),
            Pin(num='T20',name='VDD_CA',func=Pin.PWRIN,do_erc=True),
            Pin(num='V20',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y20',name='VDD_CB',func=Pin.PWRIN,do_erc=True),
            Pin(num='L11',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='N11',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='R11',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='U11',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='W11',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='L21',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='N21',name='VDD_CA',func=Pin.PWRIN,do_erc=True),
            Pin(num='R21',name='VDD_CA',func=Pin.PWRIN,do_erc=True),
            Pin(num='U21',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='W21',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='M12',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='P12',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='T12',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='V12',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y12',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='M22',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='P22',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='T22',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='V22',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y22',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='L13',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='N13',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='R13',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='U13',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='W13',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='L23',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='N23',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='R23',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='U23',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='W23',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='M14',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='P14',name='VDD_CA',func=Pin.PWRIN,do_erc=True),
            Pin(num='T14',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='V14',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y14',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='M24',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='P24',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='T24',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='V24',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y24',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='L15',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='N15',name='VDD_CA',func=Pin.PWRIN,do_erc=True),
            Pin(num='R15',name='VDD_CA',func=Pin.PWRIN,do_erc=True),
            Pin(num='U15',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='W15',name='VDD_CB',func=Pin.PWRIN,do_erc=True),
            Pin(num='L25',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='N25',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='R25',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='U25',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='W25',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='M16',name='VDD_CA',func=Pin.PWRIN,do_erc=True),
            Pin(num='P16',name='VDD_CA',func=Pin.PWRIN,do_erc=True),
            Pin(num='T16',name='VDD_CA',func=Pin.PWRIN,do_erc=True),
            Pin(num='V16',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y16',name='VDD_CB',func=Pin.PWRIN,do_erc=True),
            Pin(num='M26',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='P26',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='T26',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='V26',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y26',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='L17',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='N17',name='VDD_CA',func=Pin.PWRIN,do_erc=True),
            Pin(num='R17',name='VDD_CA',func=Pin.PWRIN,do_erc=True),
            Pin(num='U17',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='W17',name='VDD_CB',func=Pin.PWRIN,do_erc=True),
            Pin(num='N27',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='R27',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='U27',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='M18',name='VDD_CA',func=Pin.PWRIN,do_erc=True),
            Pin(num='P18',name='VDD_CA',func=Pin.PWRIN,do_erc=True),
            Pin(num='T18',name='VDD_CA',func=Pin.PWRIN,do_erc=True),
            Pin(num='V18',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y18',name='VDD_CB',func=Pin.PWRIN,do_erc=True),
            Pin(num='W28',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='L19',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='N19',name='VDD_CA',func=Pin.PWRIN,do_erc=True),
            Pin(num='R19',name='VDD_CA',func=Pin.PWRIN,do_erc=True),
            Pin(num='U19',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='W19',name='VDD_CB',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB20',name='VDD_CB',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD20',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF20',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA11',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC11',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE11',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA21',name='VDD_CB',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC21',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE21',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB12',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD12',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB22',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD22',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF22',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA13',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC13',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE13',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA23',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC23',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE23',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB14',name='VDD_CB',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD14',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF14',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB24',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD24',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF24',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA15',name='VDD_CB',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC15',name='VDD_CB',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE15',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA25',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC25',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE25',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB16',name='VDD_CB',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD16',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF16',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB26',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD26',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA17',name='VDD_CB',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC17',name='VDD_CB',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE17',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA27',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC27',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB18',name='VDD_CB',func=Pin.PWRIN,do_erc=True),
            Pin(num='AD18',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AF18',name='VDD_PL',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA19',name='VDD_CB',func=Pin.PWRIN,do_erc=True),
            Pin(num='AC19',name='VDD_CB',func=Pin.PWRIN,do_erc=True),
            Pin(num='AE19',name='VDD_PL',func=Pin.PWRIN,do_erc=True)])])
