from skidl import SKIDL, TEMPLATE, Part, Pin, SchLib

SKIDL_lib_version = '0.0.1'

regul = SchLib(tool=SKIDL).add_parts(*[
        Part(name='7805',dest=TEMPLATE,tool=SKIDL,keywords='POWER REGUL',description='Linear Regulator +12V',ref_prefix='U',num_units=1,do_erc=True,aliases=['LM7805', 'LM7812', '78L05'],pins=[
            Pin(num='VI',name='VI',do_erc=True),
            Pin(num='VO',name='VO',func=Pin.PWROUT,do_erc=True),
            Pin(num='GND',name='GND',do_erc=True)]),
        Part(name='7805MS',dest=TEMPLATE,tool=SKIDL,keywords='POWER REGUL',description='Regulator +5V CMS',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='VOUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VIN',do_erc=True)]),
        Part(name='7905',dest=TEMPLATE,tool=SKIDL,keywords='POWER REGUL',description='Linear Regulator -12V',ref_prefix='U',num_units=1,do_erc=True,aliases=['LM7905', 'LM7912', '79L05'],pins=[
            Pin(num='VI',name='VI',do_erc=True),
            Pin(num='VO',name='VO',func=Pin.PWROUT,do_erc=True),
            Pin(num='GND',name='GND',do_erc=True)]),
        Part(name='AP1117',dest=TEMPLATE,tool=SKIDL,keywords='linear regulator ldo fixed positive obsolete',description='1A Low Dropout regulator, positive, 5.0V fixed output, NRND',ref_prefix='U',num_units=1,fplist=['SOT-223*'],do_erc=True,aliases=['AP111715', 'AP111718', 'AP111725', 'AP111733', 'AP111750'],pins=[
            Pin(num='1',name='GND/ADJ',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VO',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='VI',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VO',func=Pin.PWROUT,do_erc=True)]),
        Part(name='AP131-15',dest=TEMPLATE,tool=SKIDL,keywords='linear regulator ldo fixed positive',description='300mA low dropout linear regulator, shutdown pin, 3.5V fixed positive output, SOT-23-5 package',ref_prefix='U',num_units=1,fplist=['SOT-23*'],do_erc=True,aliases=['AP131-18', 'AP131-20', 'AP131-25', 'AP131-28', 'AP131-29', 'AP131-30', 'AP131-33', 'AP131-35'],pins=[
            Pin(num='1',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='EN',do_erc=True),
            Pin(num='4',name='BP',do_erc=True),
            Pin(num='5',name='OUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='APE8865N-12-HF-3',dest=TEMPLATE,tool=SKIDL,keywords='300mA LDO Regulator Fixed Positive',description='300 mA Low Dropout Voltage Regulator, Fixed Output 3.3V, SOT-23',ref_prefix='U',num_units=1,fplist=['SOT*'],do_erc=True,aliases=['APE8865N-15-HF-3', 'APE8865N-16-HF-3', 'APE8865N-17-HF-3', 'APE8865N-18-HF-3', 'APE8865N-19-HF-3', 'APE8865N-20-HF-3', 'APE8865N-21-HF-3', 'APE8865N-22-HF-3', 'APE8865N-23-HF-3', 'APE8865N-24-HF-3', 'APE8865N-25-HF-3', 'APE8865N-26-HF-3', 'APE8865N-27-HF-3', 'APE8865N-28-HF-3', 'APE8865N-29-HF-3', 'APE8865N-30-HF-3', 'APE8865N-31-HF-3', 'APE8865N-32-HF-3', 'APE8865N-33-HF-3'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VOUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='VIN',do_erc=True)]),
        Part(name='APE8865NL-12-HF-3',dest=TEMPLATE,tool=SKIDL,keywords='300mA LDO Regulator Fixed Positive',description='300 mA Low Dropout Voltage Regulator, Fixed Output 3.3V, SOT-23',ref_prefix='U',num_units=1,fplist=['SOT*'],do_erc=True,aliases=['APE8865NL-15-HF-3', 'APE8865NL-16-HF-3', 'APE8865NL-17-HF-3', 'APE8865NL-18-HF-3', 'APE8865NL-19-HF-3', 'APE8865NL-20-HF-3', 'APE8865NL-21-HF-3', 'APE8865NL-22-HF-3', 'APE8865NL-23-HF-3', 'APE8865NL-24-HF-3', 'APE8865NL-25-HF-3', 'APE8865NL-26-HF-3', 'APE8865NL-27-HF-3', 'APE8865NL-28-HF-3', 'APE8865NL-29-HF-3', 'APE8865NL-30-HF-3', 'APE8865NL-31-HF-3', 'APE8865NL-32-HF-3', 'APE8865NL-33-HF-3'],pins=[
            Pin(num='1',name='VOUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VIN',do_erc=True)]),
        Part(name='APE8865NR-12-HF-3',dest=TEMPLATE,tool=SKIDL,keywords='300mA LDO Regulator Fixed Positive',description='300 mA Low Dropout Voltage Regulator, Fixed Output 3.3V, SOT-23',ref_prefix='U',num_units=1,fplist=['SOT*'],do_erc=True,aliases=['APE8865NR-15-HF-3', 'APE8865NR-16-HF-3', 'APE8865NR-17-HF-3', 'APE8865NR-18-HF-3', 'APE8865NR-19-HF-3', 'APE8865NR-20-HF-3', 'APE8865NR-21-HF-3', 'APE8865NR-22-HF-3', 'APE8865NR-23-HF-3', 'APE8865NR-24-HF-3', 'APE8865NR-25-HF-3', 'APE8865NR-26-HF-3', 'APE8865NR-27-HF-3', 'APE8865NR-28-HF-3', 'APE8865NR-29-HF-3', 'APE8865NR-30-HF-3', 'APE8865NR-31-HF-3', 'APE8865NR-32-HF-3', 'APE8865NR-33-HF-3'],pins=[
            Pin(num='1',name='VIN',do_erc=True),
            Pin(num='2',name='VOUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='APE8865U4-12-HF-3',dest=TEMPLATE,tool=SKIDL,keywords='300mA LDO Regulator Fixed Positive',description='300 mA Low Dropout Voltage Regulator, Fixed Output 3.3V, SC-70-4',ref_prefix='U',num_units=1,fplist=['SC*'],do_erc=True,aliases=['APE8865U4-15-HF-3', 'APE8865U4-16-HF-3', 'APE8865U4-17-HF-3', 'APE8865U4-18-HF-3', 'APE8865U4-19-HF-3', 'APE8865U4-20-HF-3', 'APE8865U4-21-HF-3', 'APE8865U4-22-HF-3', 'APE8865U4-23-HF-3', 'APE8865U4-24-HF-3', 'APE8865U4-25-HF-3', 'APE8865U4-26-HF-3', 'APE8865U4-27-HF-3', 'APE8865U4-28-HF-3', 'APE8865U4-29-HF-3', 'APE8865U4-30-HF-3', 'APE8865U4-31-HF-3', 'APE8865U4-32-HF-3', 'APE8865U4-33-HF-3'],pins=[
            Pin(num='1',name='~EN~',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VOUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='4',name='VIN',do_erc=True)]),
        Part(name='APE8865U5-12-HF-3',dest=TEMPLATE,tool=SKIDL,keywords='300mA LDO Regulator Fixed Positive',description='300 mA Low Dropout Voltage Regulator, Fixed Output 3.3V, SC-70-5',ref_prefix='U',num_units=1,fplist=['SC*'],do_erc=True,aliases=['APE8865U5-15-HF-3', 'APE8865U5-16-HF-3', 'APE8865U5-17-HF-3', 'APE8865U5-18-HF-3', 'APE8865U5-19-HF-3', 'APE8865U5-20-HF-3', 'APE8865U5-21-HF-3', 'APE8865U5-22-HF-3', 'APE8865U5-23-HF-3', 'APE8865U5-24-HF-3', 'APE8865U5-25-HF-3', 'APE8865U5-26-HF-3', 'APE8865U5-27-HF-3', 'APE8865U5-28-HF-3', 'APE8865U5-29-HF-3', 'APE8865U5-30-HF-3', 'APE8865U5-31-HF-3', 'APE8865U5-32-HF-3', 'APE8865U5-33-HF-3'],pins=[
            Pin(num='1',name='VIN',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~SHDN~',do_erc=True),
            Pin(num='4',name='BYP',do_erc=True),
            Pin(num='5',name='VOUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='APE8865Y5-12-HF-3',dest=TEMPLATE,tool=SKIDL,keywords='300mA LDO Regulator Fixed Positive',description='300 mA Low Dropout Voltage Regulator, Fixed Output 3.3V, SOT-23-5',ref_prefix='U',num_units=1,fplist=['SOT*'],do_erc=True,aliases=['APE8865Y5-15-HF-3', 'APE8865Y5-16-HF-3', 'APE8865Y5-17-HF-3', 'APE8865Y5-18-HF-3', 'APE8865Y5-19-HF-3', 'APE8865Y5-20-HF-3', 'APE8865Y5-21-HF-3', 'APE8865Y5-22-HF-3', 'APE8865Y5-23-HF-3', 'APE8865Y5-24-HF-3', 'APE8865Y5-25-HF-3', 'APE8865Y5-26-HF-3', 'APE8865Y5-27-HF-3', 'APE8865Y5-28-HF-3', 'APE8865Y5-29-HF-3', 'APE8865Y5-30-HF-3', 'APE8865Y5-31-HF-3', 'APE8865Y5-32-HF-3', 'APE8865Y5-33-HF-3'],pins=[
            Pin(num='1',name='VIN',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~SHDN~',do_erc=True),
            Pin(num='4',name='BYP',do_erc=True),
            Pin(num='5',name='VOUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='KA378R05',dest=TEMPLATE,tool=SKIDL,keywords='Voltage Regulator 3A Positive LDO Disable Pin',description='Positive 3A 35V Linear Regulator with Disable Pin, LDO, Fixed Output 5V, TO-220F-4L',ref_prefix='U',num_units=1,fplist=['TO*'],do_erc=True,pins=[
            Pin(num='1',name='IN',do_erc=True),
            Pin(num='2',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='Vdis',do_erc=True)]),
        Part(name='KA378R12C',dest=TEMPLATE,tool=SKIDL,keywords='Voltage Regulator 3A Positive LDO Disable Pin',description='Positive 3A 35V Linear Regulator with Disable Pin, LDO, Fixed Output 12V, TO-220F-4L',ref_prefix='U',num_units=1,fplist=['TO*'],do_erc=True,pins=[
            Pin(num='1',name='IN',do_erc=True),
            Pin(num='2',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='Vdis',do_erc=True)]),
        Part(name='KA378R33',dest=TEMPLATE,tool=SKIDL,keywords='Voltage Regulator 3A Positive LDO Disable Pin',description='Positive 3A 35V Linear Regulator with Disable Pin, LDO, Fixed Output 3.3V, TO-220F-4L',ref_prefix='U',num_units=1,fplist=['TO*'],do_erc=True,pins=[
            Pin(num='1',name='IN',do_erc=True),
            Pin(num='2',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='Vdis',do_erc=True)]),
        Part(name='L200',dest=TEMPLATE,tool=SKIDL,keywords='2A Regulator Adjustable Positive',description='Adjustable voltage and current regulator, 2A, 36V',ref_prefix='U',num_units=1,fplist=['Pentawatt*'],do_erc=True,pins=[
            Pin(num='1',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='LIMIT',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='REF',do_erc=True),
            Pin(num='5',name='VOUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='LD1117S33TR',dest=TEMPLATE,tool=SKIDL,keywords='REGULATOR LDO 5.0V',description='800mA Fixed Low Drop Positive Voltage Regulator, Fixed Output 5.0V, SOT223',ref_prefix='U',num_units=1,fplist=['SOT223'],do_erc=True,aliases=['LD1117S33CTR', 'LD1117S12TR', 'LD1117S12CTR', 'LD1117S18TR', 'LD1117S18CTR', 'LD1117S25TR', 'LD1117S25CTR', 'LD1117S50TR', 'LD1117S50CTR'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VO',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='VI',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LD3985G',dest=TEMPLATE,tool=SKIDL,keywords='LDO Regulator',description='150 mA Low Dropout Voltage Regulator',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='VIN',do_erc=True),
            Pin(num='2',name='GND',do_erc=True),
            Pin(num='3',name='INH',do_erc=True),
            Pin(num='4',name='BYP',do_erc=True),
            Pin(num='5',name='VOUT',do_erc=True)]),
        Part(name='LD3985G122R',dest=TEMPLATE,tool=SKIDL,keywords='150mA LDO Regulator Fixed Positive',description='150 mA Low Dropout Voltage Regulator, Fixed Output 4.7V, TSOT-23-5',ref_prefix='U',num_units=1,fplist=['TSOT*'],do_erc=True,aliases=['LD3985G18R', 'LD3985G25R', 'LD3985G26R', 'LD3985G27R', 'LD3985G28R', 'LD3985G30R', 'LD3985G33R', 'LD3985G47R'],pins=[
            Pin(num='1',name='VIN',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='INH',do_erc=True),
            Pin(num='4',name='BYP',do_erc=True),
            Pin(num='5',name='VOUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='LD3985M',dest=TEMPLATE,tool=SKIDL,keywords='LDO Regulator',description='150 mA Low Dropout Voltage Regulator',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='VIN',do_erc=True),
            Pin(num='2',name='GND',do_erc=True),
            Pin(num='3',name='INH',do_erc=True),
            Pin(num='4',name='BYP',do_erc=True),
            Pin(num='5',name='VOUT',do_erc=True)]),
        Part(name='LD3985M122R',dest=TEMPLATE,tool=SKIDL,keywords='150mA LDO Regulator Fixed Positive',description='150 mA Low Dropout Voltage Regulator, Fixed Output 4.7V, SOT-23-5',ref_prefix='U',num_units=1,fplist=['SOT*'],do_erc=True,aliases=['LD3985M18R', 'LD3985M25R', 'LD3985M26R', 'LD3985M27R', 'LD3985M28R', 'LD3985M29R', 'LD3985M30R', 'LD3985M33R', 'LD3985M47R'],pins=[
            Pin(num='1',name='VIN',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='INH',do_erc=True),
            Pin(num='4',name='BYP',do_erc=True),
            Pin(num='5',name='VOUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='LF15ABDT-TR',dest=TEMPLATE,tool=SKIDL,keywords='LDO regulator voltage',description='Low-drop Voltage Regulator, Io up to 500mA, Fixed Vo 8.5V, DPAK.',ref_prefix='U',num_units=1,fplist=['TO-252*'],do_erc=True,aliases=['LF18ABDT-TR', 'LF18CDT-TR', 'LF18CDT-TRY', 'LF25ABDT-TR', 'LF25ABDT-TRY', 'LF25CDT-TR', 'LF25CDT-TRY', 'LF33ABDT-TR', 'LF33CDT-TR', 'LF33CDT-TRY', 'LF50ABDT-TR', 'LF50ABDT-TRY', 'LF50CDT-TR', 'LF50CDT-TRY', 'LF60ABDT-TR', 'LF60CDT-TR', 'LF80ABDT-TR', 'LF80CDT-TR', 'LF80CDT-TRY', 'LF85CDT-TR', 'LF85CDT-TRY', 'LF120ABDT-TR', 'LF120CDT-TR'],pins=[
            Pin(num='1',name='Vin',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Vout',func=Pin.PWROUT,do_erc=True)]),
        Part(name='LM1084IS-3.3/NOPB',dest=TEMPLATE,tool=SKIDL,keywords='Voltage Regulator 5A Positive',description='LM1084IS-5.0, 5A 27V Linear Regulator, Fixed Output 5.0V, TO-263',ref_prefix='U',num_units=1,fplist=['TO*'],do_erc=True,aliases=['LM1084IS-5.0/NOPB'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='IN',do_erc=True)]),
        Part(name='LM1084IS-ADJ/NOPB',dest=TEMPLATE,tool=SKIDL,keywords='Adjustable Voltage Regulator 5A Positive',description='LM1084IS, 5A 29V Adjustable Linear Regulator, TO-263 (D2-PAK)',ref_prefix='U',num_units=1,fplist=['TO*'],do_erc=True,pins=[
            Pin(num='1',name='ADJ',do_erc=True),
            Pin(num='2',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='IN',do_erc=True)]),
        Part(name='LM1084IT-3.3/NOPB',dest=TEMPLATE,tool=SKIDL,keywords='Voltage Regulator 5A Positive',description='LM1084IT-5.0, 5A 25V Linear Regulator, Fixed Output 5.0V, TO-220',ref_prefix='U',num_units=1,fplist=['TO*'],do_erc=True,aliases=['LM1084IT-5.0/NOPB'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='IN',do_erc=True)]),
        Part(name='LM1084IT-ADJ/NOPB',dest=TEMPLATE,tool=SKIDL,keywords='Adjustable Voltage Regulator 5A Positive',description='LM1084IT, 5A 29V Adjustable Linear Regulator, TO-220',ref_prefix='U',num_units=1,fplist=['TO*'],do_erc=True,pins=[
            Pin(num='1',name='ADJ',do_erc=True),
            Pin(num='2',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='IN',do_erc=True)]),
        Part(name='LM1117-ADJ',dest=TEMPLATE,tool=SKIDL,keywords='linear regulator ldo adjustable positive',description='800mA Low-Dropout Linear Regulator, adjustable output',ref_prefix='U',num_units=1,fplist=['SOT-223*', 'TO-263*', 'TO-252*'],do_erc=True,aliases=['LM1117-1.8', 'LM1117-2.5', 'LM1117-3.3', 'LM1117-5.0'],pins=[
            Pin(num='1',name='GND/ADJ',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VO',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='VI',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VO',func=Pin.PWROUT,do_erc=True)]),
        Part(name='LM117E',dest=TEMPLATE,tool=SKIDL,keywords='Adjustable Voltage Regulator 0.5A Positive',description='0.5A 35V Adjustable Linear Regulator, LCC-20',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='ADJ',do_erc=True),
            Pin(num='11',name='IN',do_erc=True)]),
        Part(name='LM2931AZ-3.3/5.0',dest=TEMPLATE,tool=SKIDL,keywords='REGULATOR LDO 3.3V 5V',description='LM2931, 100mA Low drop-out regulator, Fixed Output 3.3V, 5V',ref_prefix='U',num_units=1,fplist=['TO?92*'],do_erc=True,aliases=['LM2931Z-3.3/5.0'],pins=[
            Pin(num='1',name='VO',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VI',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LM2931AZ-5.0',dest=TEMPLATE,tool=SKIDL,keywords='REGULATOR LDO 5V',description='LM2931, 100mA Low drop-out regulator, Fixed Output 5V',ref_prefix='U',num_units=1,fplist=['TO?92*'],do_erc=True,aliases=['LM2931Z-5.0'],pins=[
            Pin(num='1',name='VO',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VI',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LM317EMP',dest=TEMPLATE,tool=SKIDL,keywords='Adjustable Voltage Regulator 1A Positive',description='1A 35V Adjustable Linear Regulator, SOT-223',ref_prefix='U',num_units=1,fplist=['SOT*'],do_erc=True,aliases=['LM317AEMP'],pins=[
            Pin(num='1',name='ADJ',do_erc=True),
            Pin(num='2',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='IN',do_erc=True)]),
        Part(name='LM317H',dest=TEMPLATE,tool=SKIDL,keywords='Adjustable Voltage Regulator 0.5A Positive',description='0.5A 35V Adjustable Linear Regulator, TO-39',ref_prefix='U',num_units=1,fplist=['TO*'],do_erc=True,aliases=['LM317AH', 'LM117H'],pins=[
            Pin(num='1',name='IN',do_erc=True),
            Pin(num='2',name='ADJ',do_erc=True),
            Pin(num='3',name='OUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='LM317K',dest=TEMPLATE,tool=SKIDL,keywords='Adjustable Voltage Regulator 1.5A Positive',description='1.5A 35V Adjustable Linear Regulator, TO-3',ref_prefix='U',num_units=1,fplist=['TO*'],do_erc=True,aliases=['LM117K'],pins=[
            Pin(num='1',name='ADJ',do_erc=True),
            Pin(num='2',name='IN',do_erc=True),
            Pin(num='3',name='OUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='LM317MDT',dest=TEMPLATE,tool=SKIDL,keywords='Adjustable Voltage Regulator 0.5A Positive',description='0.5A 35V Adjustable Linear Regulator, TO-252',ref_prefix='U',num_units=1,fplist=['TO*'],do_erc=True,aliases=['LM317AMDT'],pins=[
            Pin(num='1',name='ADJ',do_erc=True),
            Pin(num='2',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='IN',do_erc=True)]),
        Part(name='LM317S',dest=TEMPLATE,tool=SKIDL,keywords='Adjustable Voltage Regulator 1.5A Positive',description='1.5A 35V Adjustable Linear Regulator, TO-263',ref_prefix='U',num_units=1,fplist=['TO*'],do_erc=True,pins=[
            Pin(num='1',name='ADJ',do_erc=True),
            Pin(num='2',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='IN',do_erc=True)]),
        Part(name='LM317T',dest=TEMPLATE,tool=SKIDL,keywords='Adjustable Voltage Regulator 1.5A Positive',description='1.5A 35V Adjustable Linear Regulator, TO-220',ref_prefix='U',num_units=1,fplist=['TO*'],do_erc=True,aliases=['LM317AT'],pins=[
            Pin(num='1',name='ADJ',do_erc=True),
            Pin(num='2',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='IN',do_erc=True)]),
        Part(name='LM317_SOT223',dest=TEMPLATE,tool=SKIDL,keywords='POWER REGUL',description='Linear Regulator (adjustable)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='ADJ',do_erc=True),
            Pin(num='2',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='IN',do_erc=True)]),
        Part(name='LM337H',dest=TEMPLATE,tool=SKIDL,keywords='Adjustable Voltage Regulator 0.5A Negative',description='Negative 0.5A 35V Adjustable Linear Regulator, TO-39',ref_prefix='U',num_units=1,fplist=['TO*'],do_erc=True,aliases=['LM137H'],pins=[
            Pin(num='1',name='ADJ',do_erc=True),
            Pin(num='2',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='IN',do_erc=True)]),
        Part(name='LM337IMP',dest=TEMPLATE,tool=SKIDL,keywords='Adjustable Voltage Regulator 1A Negative',description='Negative 1A 35V Adjustable Linear Regulator, SOT-223',ref_prefix='U',num_units=1,fplist=['SOT*'],do_erc=True,pins=[
            Pin(num='1',name='ADJ',do_erc=True),
            Pin(num='2',name='IN',do_erc=True),
            Pin(num='3',name='OUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='LM337K',dest=TEMPLATE,tool=SKIDL,keywords='Adjustable Voltage Regulator 1.5A Negative',description='Negative 1.5A 35V Adjustable Linear Regulator, TO-3',ref_prefix='U',num_units=1,fplist=['TO*'],do_erc=True,aliases=['LM137K'],pins=[
            Pin(num='1',name='ADJ',do_erc=True),
            Pin(num='2',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='IN',do_erc=True)]),
        Part(name='LM337T',dest=TEMPLATE,tool=SKIDL,keywords='Adjustable Voltage Regulator 1.5A Negative',description='Negative 1.5A 35V Adjustable Linear Regulator, TO-220',ref_prefix='U',num_units=1,fplist=['TO*'],do_erc=True,pins=[
            Pin(num='1',name='ADJ',do_erc=True),
            Pin(num='2',name='IN',do_erc=True),
            Pin(num='3',name='OUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='LM3480-3.3',dest=TEMPLATE,tool=SKIDL,keywords='ldo linear fixed positive',description='100mA, Quasi Low Dropout Voltage Regulator, 5.0V positive fixed output, SOT-23 package',ref_prefix='U',num_units=1,fplist=['SOT-23*'],do_erc=True,aliases=['LM3480-5.0', 'LM3480-12', 'LM3480-15'],pins=[
            Pin(num='1',name='VOUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LM350T',dest=TEMPLATE,tool=SKIDL,keywords='Adjustable Voltage Regulator 3A Positive',description='3A 33V Adjustable Linear Regulator, TO-220',ref_prefix='U',num_units=1,fplist=['TO*'],do_erc=True,pins=[
            Pin(num='1',name='ADJ',do_erc=True),
            Pin(num='2',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='IN',do_erc=True)]),
        Part(name='LM723',dest=TEMPLATE,tool=SKIDL,keywords='POWER REGUL',description='Linear Regulator (adjustable)',ref_prefix='U',num_units=1,do_erc=True,aliases=['LM723C'],pins=[
            Pin(num='2',name='LIM',do_erc=True),
            Pin(num='3',name='SEN',do_erc=True),
            Pin(num='4',name='-',do_erc=True),
            Pin(num='5',name='+',do_erc=True),
            Pin(num='6',name='REF',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='V-',do_erc=True),
            Pin(num='9',name='VZ',do_erc=True),
            Pin(num='10',name='VS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='VC',do_erc=True),
            Pin(num='12',name='V+',do_erc=True),
            Pin(num='13',name='FC',do_erc=True)]),
        Part(name='LM7805CT',dest=TEMPLATE,tool=SKIDL,keywords='Voltage Regulator 1A Positive',description='Positive 1A 35V Linear Regulator, Fixed Output 24V, TO-220',ref_prefix='U',num_units=1,fplist=['TO*'],do_erc=True,aliases=['LM7806CT', 'LM7808CT', 'LM7809CT', 'LM7810CT', 'LM7812CT', 'LM7815CT', 'LM7818CT', 'LM7824CT', 'LM7806ACT', 'LM7808ACT', 'LM7809ACT', 'LM7810ACT', 'LM7812ACT', 'LM7815ACT', 'LM7818ACT', 'LM7824ACT'],pins=[
            Pin(num='1',name='IN',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='OUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='LM78L05ACZ',dest=TEMPLATE,tool=SKIDL,keywords='Voltage Regulator 100mA Positive',description='Positive 100mA 30V Linear Regulator, Fixed Output 24V, TO-92',ref_prefix='U',num_units=1,fplist=['TO*'],do_erc=True,aliases=['LM78L12ACZ', 'MC78L05ACP', 'MC78L06ACP', 'MC78L08ACP', 'MC78L12ACP', 'MC78L15ACP', 'MC78L18ACP', 'MC78L24ACP', 'MC78L05AACP'],pins=[
            Pin(num='1',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='IN',do_erc=True)]),
        Part(name='LM78M05CT',dest=TEMPLATE,tool=SKIDL,keywords='Voltage Regulator 0.5A Positive',description='Positive 0.5A 35V Linear Regulator, Fixed Output 5V, TO-220',ref_prefix='U',num_units=1,fplist=['TO*'],do_erc=True,pins=[
            Pin(num='1',name='IN',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='OUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='LM7905CT',dest=TEMPLATE,tool=SKIDL,keywords='Voltage Regulator 1A Negative',description='Negative 1A 35V Linear Regulator, Fixed Output 24V, TO-220',ref_prefix='U',num_units=1,fplist=['TO*'],do_erc=True,aliases=['LM7906CT', 'LM7908CT', 'LM7909CT', 'LM7910CT', 'LM7912CT', 'LM7915CT', 'LM7918CT', 'LM7924CT'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='IN',do_erc=True),
            Pin(num='3',name='OUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='LM79M05CT',dest=TEMPLATE,tool=SKIDL,keywords='Voltage Regulator 0.5A Negative',description='Negative 0.5A 35V Linear Regulator, Fixed Output 5V, TO-220',ref_prefix='U',num_units=1,fplist=['TO*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='IN',do_erc=True),
            Pin(num='3',name='OUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='LP2985LV',dest=TEMPLATE,tool=SKIDL,keywords='REGUL POWER SOT-23-5',description='MICROPOWER 150mA Regulator',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='ON/OFF',do_erc=True),
            Pin(num='4',name='BYPASS',do_erc=True),
            Pin(num='5',name='VOUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='LP2987AIMM-5.0/NOPB',dest=TEMPLATE,tool=SKIDL,keywords='Linear LDO Regulator 200mA 5V',description='LM2987IMMX-5.0, 200mA Linear LDO Regulator, Low Noise, Fixed Output 5V, MSOP-8',ref_prefix='U',num_units=1,fplist=['MSOP*', 'VSSOP*'],do_erc=True,aliases=['LP2987AIMMX-5.0/NOPB', 'LP2987IMM-3.3/NOPB', 'LP2987IMM-5.0/NOPB', 'LP2987IMMX-3.3/NOPB', 'LP2987IMMX-5.0/NOPB'],pins=[
            Pin(num='2',name='DELAY',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='SENSE',do_erc=True),
            Pin(num='7',name='~ERROR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~SHTD',do_erc=True)]),
        Part(name='LP2987AIMX-5.0/NOPB',dest=TEMPLATE,tool=SKIDL,keywords='Linear LDO Regulator 200mA 5V',description='LM2987AIMX-5.0, 200mA Linear LDO Regulator, Low Noise, Fixed Output 5V, SO-8',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,aliases=['LP2987IMX-3.0/NOPB', 'LP2987IMX-5.0/NOPB'],pins=[
            Pin(num='2',name='DELAY',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='SENSE',do_erc=True),
            Pin(num='7',name='~ERROR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~SHTD',do_erc=True)]),
        Part(name='LP2988AIMM-5.0/NOPB',dest=TEMPLATE,tool=SKIDL,keywords='Linear LDO Regulator 200mA 5V',description='LP2988IMMX-5.0, 200mA Linear LDO Regulator, Low Noise, Fixed Output 5V, MSOP-8',ref_prefix='U',num_units=1,fplist=['MSOP*', 'VSSOP*'],do_erc=True,aliases=['LP2988AIMM-2.8/NOPB', 'LP2988AIMM-3.0/NOPB', 'LP2988AIMM-3.3/NOPB', 'LP2988AIMMX-3.0/NOPB', 'LP2988AIMMX-3.3/NOPB', 'LP2988AIMMX-5.0/NOPB', 'LP2988IMM-2.8/NOPB', 'LP2988IMM-3.0/NOPB', 'LP2988IMM-3.3/NOPB', 'LP2988IMM-5.0/NOPB', 'LP2988IMMX-3.0/NOPB', 'LP2988IMMX-3.3/NOPB', 'LP2988IMMX-5.0/NOPB'],pins=[
            Pin(num='1',name='BYPASS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='DELAY',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='SENSE',do_erc=True),
            Pin(num='7',name='~ERROR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~SHTD',do_erc=True)]),
        Part(name='LP2988IMX-5.0/NOPB',dest=TEMPLATE,tool=SKIDL,keywords='Linear LDO Regulator 200mA 5V',description='LP2988IMX-5.0, 200mA Linear LDO Regulator, Low Noise, Fixed Output 5V, SO-8',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,aliases=['LP2988AIMX-3.3/NOPB'],pins=[
            Pin(num='1',name='BYPASS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='DELAY',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='SENSE',do_erc=True),
            Pin(num='7',name='~ERROR',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~SHTD',do_erc=True)]),
        Part(name='LP3963',dest=TEMPLATE,tool=SKIDL,keywords='REGUL POWER',description='LowDrop Linear Regulator (QPACK 5 pins)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='SHDN',do_erc=True),
            Pin(num='2',name='IN',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='5',name='ERROR',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LP3966',dest=TEMPLATE,tool=SKIDL,keywords='REGUL POWER',description='LowDrop Linear Regulator (QPACK 5 pins)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='SHDN',do_erc=True),
            Pin(num='2',name='IN',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='5',name='SENSE/ADJ',do_erc=True)]),
        Part(name='LT1129CQ',dest=TEMPLATE,tool=SKIDL,keywords='700mA LDO Regulator 5V Positive',description='700 mA Low Dropout Voltage Regulator, Fixed 5V, TO263',ref_prefix='U',num_units=1,fplist=['TO*'],do_erc=True,aliases=['LT1129IQ', 'LT1129CQ-3.3', 'LT1129IQ-3.3', 'LT1129CQ-5', 'LT1129IQ-5'],pins=[
            Pin(num='1',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='FB/ADJ',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~SHDN~',do_erc=True),
            Pin(num='5',name='VIN',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LT1129CS8',dest=TEMPLATE,tool=SKIDL,keywords='700mA LDO Regulator 5V Positive',description='700 mA Low Dropout Voltage Regulator, Fixed 5V, SO8',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,aliases=['LT1129IS8', 'LT1129CS8-3.3', 'LT1129IS8-3.3', 'LT1129CS8-5', 'LT1129IS8-5'],pins=[
            Pin(num='1',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='FB/ADJ',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='~SHDN~',do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VIN',do_erc=True)]),
        Part(name='LT1129CST-3.3',dest=TEMPLATE,tool=SKIDL,keywords='700mA LDO Regulator 3.3V Positive',description='LT1129MSPT-3.3, 700 mA Low Dropout Voltage Regulator, Fixed 3.3V, SOT-223',ref_prefix='U',num_units=1,fplist=['SOT*'],do_erc=True,aliases=['LT1129IST-3.3', 'LT1129MPST-3.3', 'LT1129CST-5', 'LT1129IST-5'],pins=[
            Pin(num='1',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='OUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='LT1129CT',dest=TEMPLATE,tool=SKIDL,keywords='700mA LDO Regulator 5V Positive',description='700 mA Low Dropout Voltage Regulator, Fixed 5V, TO220',ref_prefix='U',num_units=1,fplist=['TO*'],do_erc=True,aliases=['LT1129IT', 'LT1129CT-3.3', 'LT1129IT-3.3', 'LT1129CT-5', 'LT1129IT-5'],pins=[
            Pin(num='1',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='FB/ADJ',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~SHDN~',do_erc=True),
            Pin(num='5',name='VIN',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LT1129_QPACK',dest=TEMPLATE,tool=SKIDL,keywords='REGUL POWER',description='LowDrop Linear Regulator (QPACK 5 pins)',ref_prefix='U',num_units=1,do_erc=True,aliases=['LT_1129_QP'],pins=[
            Pin(num='1',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='SENSE',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='SHDN',do_erc=True),
            Pin(num='5',name='IN',do_erc=True)]),
        Part(name='LT1129_SO8',dest=TEMPLATE,tool=SKIDL,keywords='REGUL POWER',description='LowDrop Linear Regulator (8 pins SOJ)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='SENSE',do_erc=True),
            Pin(num='3',name='GND',do_erc=True),
            Pin(num='4',name='NC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='SHDN',do_erc=True),
            Pin(num='6',name='GND',do_erc=True),
            Pin(num='7',name='GND',do_erc=True),
            Pin(num='8',name='IN',do_erc=True)]),
        Part(name='LT1175CN8',dest=TEMPLATE,tool=SKIDL,description='REGULATOR (Negative voltage)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='IN',do_erc=True),
            Pin(num='2',name='Ilim2',do_erc=True),
            Pin(num='3',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='4',name='SENSE',do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='SHDN',do_erc=True),
            Pin(num='7',name='Ilim4',do_erc=True),
            Pin(num='8',name='IN',do_erc=True)]),
        Part(name='LT1175_QP',dest=TEMPLATE,tool=SKIDL,description='REGULATOR (Negative voltage)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='SENSE',do_erc=True),
            Pin(num='3',name='IN',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SHDN',do_erc=True)]),
        Part(name='LT1585CM',dest=TEMPLATE,tool=SKIDL,keywords='POWER REGUL',description='Linear Regulator (adjustable)',ref_prefix='Q',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='ADJ',do_erc=True),
            Pin(num='2',name='OUT',do_erc=True),
            Pin(num='3',name='IN',do_erc=True)]),
        Part(name='LT1761-5',dest=TEMPLATE,tool=SKIDL,keywords='REGULATOR POSITIVE POWER LDO',description='MICROPOWER 5V 100mA LDO regulator TSOT-23 5-leads package',ref_prefix='U',num_units=1,fplist=['TSOT-23*', 'SOT-23*'],do_erc=True,aliases=['LT1761-1.2', 'LT1761-1.5', 'LT1761-1.8', 'LT1761-2', 'LT1761-2.5', 'LT1761-2.8', 'LT1761-3', 'LT1761-3.3'],pins=[
            Pin(num='1',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~SHDN',do_erc=True),
            Pin(num='4',name='BYP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='VOUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='LT1761-BYP',dest=TEMPLATE,tool=SKIDL,keywords='REGULATOR POSITIVE POWER LDO adjustable',description='MICROPOWER 100mA LDO adjustable regulator TSOT-23 5-leads package',ref_prefix='U',num_units=1,fplist=['TSOT-23*', 'SOT-23*'],do_erc=True,pins=[
            Pin(num='1',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='BYP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='ADJ',do_erc=True),
            Pin(num='5',name='VOUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='LT1761-SD',dest=TEMPLATE,tool=SKIDL,keywords='REGULATOR POSITIVE POWER LDO adjustable',description='MICROPOWER 100mA LDO adjustable regulator TSOT-23 5-leads package',ref_prefix='U',num_units=1,fplist=['TSOT-23*', 'SOT-23*'],do_erc=True,pins=[
            Pin(num='1',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~SHDN',do_erc=True),
            Pin(num='4',name='ADJ',do_erc=True),
            Pin(num='5',name='VOUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='LT1964-BYP',dest=TEMPLATE,tool=SKIDL,keywords='REGUL POWER',description='MICROPOWER 150mA Regulator tiny SOT-23 5-leads package',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='BYP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='ADJ',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='VOUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='LT3010',dest=TEMPLATE,tool=SKIDL,keywords='REGUL POWER',description='Adj Low drop Linear Regulator (MSOP package 9 pins), Vin <= 80V',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='SENSE-1.275V',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SHDN',do_erc=True),
            Pin(num='8',name='IN',do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LT3472',dest=TEMPLATE,tool=SKIDL,description='DC/DC converter for CCD bias',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='SWP',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='SHDN',do_erc=True),
            Pin(num='4',name='SWN',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='DN',do_erc=True),
            Pin(num='6',name='FBN',do_erc=True),
            Pin(num='7',name='SSN',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='FBP',do_erc=True),
            Pin(num='9',name='SSP',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='VPOS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LTC3406B-1.2',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='MAX1658ESA',dest=TEMPLATE,tool=SKIDL,keywords='Linear LDO Regulator 350mA 5V',description='350mA Linear LDO Regulator, Fixed Output 5V, SO-8',ref_prefix='U',num_units=1,fplist=['SO*', 'SOIC*'],do_erc=True,aliases=['MAX1659ESA'],pins=[
            Pin(num='1',name='SET',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='~SHTD',do_erc=True),
            Pin(num='3',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='5',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MAX16910CASA',dest=TEMPLATE,tool=SKIDL,keywords='Linear LDO Regulator',description='200mA Automotive Linear LDO Regulator, Fixed Output 5V/3.3V or Adjustable, SOIC8',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='ENABLE',do_erc=True),
            Pin(num='3',name='SET',do_erc=True),
            Pin(num='4',name='~RST',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='5',name='TIMEOUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='SET0V',do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MAX16910CATA',dest=TEMPLATE,tool=SKIDL,keywords='Linear LDO Regulator',description='200mA Automotive Linear LDO Regulator, Fixed Output 5V/3.3V or Adjustable, TDFN8',ref_prefix='U',num_units=1,fplist=['DFN*3x3mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='ENABLE',do_erc=True),
            Pin(num='3',name='SET',do_erc=True),
            Pin(num='4',name='~RST',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='5',name='TIMEOUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='SET0V',do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MAX5092AATE',dest=TEMPLATE,tool=SKIDL,keywords='High Voltage 72V Input LDO Boost Preregulator 250mA 5V',description='4V to 72V Input LDOs with Boost Preregulator, 250mA Output, 5V Preset Vout, TQFN-16',ref_prefix='U',num_units=1,fplist=['TQFN*', 'QFN*'],do_erc=True,aliases=['MAX5092BATE', 'MAX5093AATE', 'MAX5093BATE'],pins=[
            Pin(num='1',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='EN',do_erc=True),
            Pin(num='3',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~HOLD~',do_erc=True),
            Pin(num='5',name='PGND_LDO',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='SET',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='OUT_SENSE',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='9',name='BSOUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='10',name='LX',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='LX',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='PGND_BST',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='BSFB',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='VL',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='CT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='~RESET~',func=Pin.OPENCOLL,do_erc=True)]),
        Part(name='MAX603CPA',dest=TEMPLATE,tool=SKIDL,keywords='Linear LDO Regulator 500mA 3.3V',description='500mA Linear LDO Regulator, Fixed Output 3.3V, PDIP-8',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*'],do_erc=True,aliases=['MAX604CPA'],pins=[
            Pin(num='1',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~OFF',do_erc=True),
            Pin(num='5',name='SET',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='OUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='MAX603CSA',dest=TEMPLATE,tool=SKIDL,keywords='Linear LDO Regulator 500mA 3.3V',description='500mA Linear LDO Regulator, Fixed Output 3.3V, SO-8',ref_prefix='U',num_units=1,fplist=['SO*', 'SOIC*'],do_erc=True,aliases=['MAX604CSA'],pins=[
            Pin(num='1',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~OFF',do_erc=True),
            Pin(num='5',name='SET',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='OUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='MAX666',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='MAX874',dest=TEMPLATE,tool=SKIDL,description='Voltage reference',ref_prefix='U',num_units=1,do_erc=True,aliases=['MAX872'],pins=[
            Pin(num='2',name='VIN',do_erc=True),
            Pin(num='3',name='Temper',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='TRIM',do_erc=True),
            Pin(num='6',name='VOUT',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='MAX882CPA',dest=TEMPLATE,tool=SKIDL,keywords='Linear LDO Regulator',description='200mA Linear LDO Regulator, Fixed Output 3.3V or Adjustable with Shutdown Mode, -40C to +85C, DIP8',ref_prefix='U',num_units=1,fplist=['DIP*'],do_erc=True,aliases=['MAX882EPA', 'MAX883CPA', 'MAX883EPA', 'MAX884CPA', 'MAX884EPA'],pins=[
            Pin(num='1',name='~LBO',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='2',name='SET',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='5',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='~OFF',do_erc=True),
            Pin(num='8',name='~LBI',do_erc=True)]),
        Part(name='MAX882CSA',dest=TEMPLATE,tool=SKIDL,keywords='Linear LDO Regulator',description='200mA Linear LDO Regulator, Fixed Output 3.3V or Adjustable with Shutdown Mode, -40C to +85C, SOIC8',ref_prefix='U',num_units=1,fplist=['SOIC*'],do_erc=True,aliases=['MAX882ESA', 'MAX883CSA', 'MAX883ESA', 'MAX884CSA', 'MAX884ESA'],pins=[
            Pin(num='1',name='~LBO',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='2',name='SET',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='5',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='~OFF',do_erc=True),
            Pin(num='8',name='~LBI',do_erc=True)]),
        Part(name='MC78L05ACD',dest=TEMPLATE,tool=SKIDL,keywords='Voltage Regulator 100mA Positive',description='Positive 100mA 30V Linear Regulator, Fixed Output 12V, SO-8',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,aliases=['MC78L08ACD', 'MC78L12ACD'],pins=[
            Pin(num='1',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='8',name='IN',do_erc=True)]),
        Part(name='MC78L05ACH',dest=TEMPLATE,tool=SKIDL,keywords='Voltage Regulator 100mA Positive',description='Positive 100mA 30V Linear Regulator, Fixed Output 12V, SOT-89',ref_prefix='U',num_units=1,fplist=['SOT*'],do_erc=True,aliases=['MC78L08ACH', 'MC78L12ACH'],pins=[
            Pin(num='1',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='IN',do_erc=True)]),
        Part(name='MC78M05CDT',dest=TEMPLATE,tool=SKIDL,keywords='Voltage Regulator 0.5A Positive',description='Positive 0.5A 35V Linear Regulator, Fixed Output 5V, TO-252 (D-PAK)',ref_prefix='U',num_units=1,fplist=['TO*'],do_erc=True,pins=[
            Pin(num='1',name='IN',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='OUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='MC79L05ACD',dest=TEMPLATE,tool=SKIDL,keywords='Voltage Regulator 100mA Negative',description='Negative 100mA -35V Linear Regulator, Fixed Output -15V, SO-8',ref_prefix='U',num_units=1,fplist=['SOIC?8*3.9X4.9mm*Pitch1.27mm*'],do_erc=True,aliases=['MC79L12ACD', 'MC79L15CD'],pins=[
            Pin(num='1',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='IN',do_erc=True),
            Pin(num='3',name='IN',do_erc=True),
            Pin(num='4',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='IN',do_erc=True),
            Pin(num='7',name='IN',do_erc=True),
            Pin(num='8',name='NC',func=Pin.NOCONNECT,do_erc=True)]),
        Part(name='MCP1700T-3002E/TT',dest=TEMPLATE,tool=SKIDL,keywords='regulator linear ldo',description='250mA Low Quiscent Current LDO, 3.0V output, SOT-23-3 package',ref_prefix='U',num_units=1,fplist=['SOT-23*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VO',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='VI',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP1703A-3302/MB',dest=TEMPLATE,tool=SKIDL,keywords='REGULATOR LDO',description='Low Quiescent Current LDO Regulator, 5.0V, 250 mA, Vin<=16V, extended temp. range',ref_prefix='U',num_units=1,fplist=['SOT89*'],do_erc=True,aliases=['MCP1703A-3302E/MB', 'MCP1703A-1202/MB', 'MCP1703A-1502/MB', 'MCP1703A-1802/MB', 'MCP1703A-2502/MB', 'MCP1703A-2802/MB', 'MCP1703A-3002/MB', 'MCP1703A-4002/MB', 'MCP1703A-5002/MB', 'MCP1703A-1202E/MB', 'MCP1703A-1502E/MB', 'MCP1703A-1802E/MB', 'MCP1703A-2502E/MB', 'MCP1703A-2802E/MB', 'MCP1703A-3002E/MB', 'MCP1703A-4002E/MB', 'MCP1703A-5002E/MB'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VI',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VO',func=Pin.PWROUT,do_erc=True)]),
        Part(name='MCP1754ST-5002E/MB',dest=TEMPLATE,tool=SKIDL,keywords='REGULATOR LDO',description='MCP1754ST, Fixed 150mA Low Dropout Voltage Regulator, Positive',ref_prefix='U',num_units=1,fplist=['SOT-89*'],do_erc=True,aliases=['MCP1754ST-1802E/MB', 'MCP1754ST-3302E/MB'],pins=[
            Pin(num='1',name='VI',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VO',func=Pin.PWROUT,do_erc=True)]),
        Part(name='MCP1826S',dest=TEMPLATE,tool=SKIDL,keywords='regulator linear ldo',description='1000 mA, Low-Voltage, Low Quiescent Current LDO Regulator',ref_prefix='U',num_units=1,fplist=['SOT?223*TabPin2*', 'TO?220*', 'TO?263*'],do_erc=True,pins=[
            Pin(num='1',name='Vin',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Vout',func=Pin.PWROUT,do_erc=True)]),
        Part(name='MIC4690',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='MIC5219-3.3BM5',dest=TEMPLATE,tool=SKIDL,keywords='linear low dropout Regulator fixed ultra-low-noise',description='500mA LDO fixed output voltage 5.0V ultra-low-noise',ref_prefix='U',num_units=1,fplist=['SOT-23*'],do_erc=True,aliases=['MIC5219-2.5BM5', 'MIC5219-2.6BM5', 'MIC5219-2.7BM5', 'MIC5219-2.8BM5', 'MIC5219-2.9BM5', 'MIC5219-3.1BM5', 'MIC5219-3.0BM5', 'MIC5219-3.6BM5', 'MIC5219-5.0BM5'],pins=[
            Pin(num='1',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='EN',do_erc=True),
            Pin(num='4',name='BYP',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='VOUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='NCP1117DTAG',dest=TEMPLATE,tool=SKIDL,keywords='REGULATOR LDO ADJUSTABLE',description='1A Low drop-out regulator, Adjustable Output 1.25 - 18.8V, DPAK',ref_prefix='U',num_units=1,fplist=['TO-263-3*'],do_erc=True,aliases=['NCP1117DT12G', 'NCP1117DT15G', 'NCP1117DT18G', 'NCP1117DT19G', 'NCP1117DT20G', 'NCP1117DT25G', 'NCP1117DT285G', 'NCP1117DT33G', 'NCP1117DT50G'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VO',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='VI',func=Pin.PWRIN,do_erc=True)]),
        Part(name='NCP1117DTAG_MountingTab',dest=TEMPLATE,tool=SKIDL,keywords='REGULATOR LDO ADJUSTABLE',description='1A Low drop-out regulator, Adjustable Output 1.25 - 18.8V, DPAK',ref_prefix='U',num_units=1,fplist=['TO-263-3*'],do_erc=True,aliases=['NCP1117DT12G_MountingTab', 'NCP1117DT15G_MountingTab', 'NCP1117DT18G_MountingTab', 'NCP1117DT19G_MountingTab', 'NCP1117DT20G_MountingTab', 'NCP1117DT25G_MountingTab', 'NCP1117DT285G_MountingTab', 'NCP1117DT33G_MountingTab', 'NCP1117DT50G_MountingTab'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VO',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='VI',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VO',do_erc=True)]),
        Part(name='NCP1117STAT3G',dest=TEMPLATE,tool=SKIDL,keywords='REGULATOR LDO 12V',description='1A Low drop-out regulator, Adjustable Output 1.25 - 18.8V, SOT223',ref_prefix='U',num_units=1,fplist=['SOT-223*'],do_erc=True,aliases=['NCP1117ST12T3G', 'NCP1117ST15T3G', 'NCP1117ST18T3G', 'NCP1117ST20T3G', 'NCP1117ST25T3G', 'NCP1117ST285T3G', 'NCP1117ST33T3G', 'NCP1117ST50T3G'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VO',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='VI',func=Pin.PWRIN,do_erc=True)]),
        Part(name='NCP1117STAT3G_MountingTab',dest=TEMPLATE,tool=SKIDL,keywords='REGULATOR LDO 12V',description='1A Low drop-out regulator, Adjustable Output 1.25 - 18.8V, SOT223',ref_prefix='U',num_units=1,fplist=['SOT-223*'],do_erc=True,aliases=['NCP1117ST12T3G_MountingTab', 'NCP1117ST15T3G_MountingTab', 'NCP1117ST18T3G_MountingTab', 'NCP1117ST20T3G_MountingTab', 'NCP1117ST25T3G_MountingTab', 'NCP1117ST285T3G_MountingTab', 'NCP1117ST33T3G_MountingTab', 'NCP1117ST50T3G_MountingTab'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VO',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='VI',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VO',do_erc=True)]),
        Part(name='PT6100',dest=TEMPLATE,tool=SKIDL,description='REG.ADJ.1A',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='INH',do_erc=True),
            Pin(num='2',name='VI',do_erc=True),
            Pin(num='3',name='VI',do_erc=True),
            Pin(num='4',name='VI',do_erc=True),
            Pin(num='5',name='GND',do_erc=True),
            Pin(num='6',name='GND',do_erc=True),
            Pin(num='7',name='GND',do_erc=True),
            Pin(num='8',name='GND',do_erc=True),
            Pin(num='9',name='VO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='VO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='VO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='ADJ',do_erc=True)]),
        Part(name='SPX2920M3-3.3',dest=TEMPLATE,tool=SKIDL,keywords='REGULATOR LDO 5V',description='400mA Low drop-out regulator, Fixed Output 5V, SOT223',ref_prefix='U',num_units=1,fplist=['SOT223'],do_erc=True,aliases=['SPX2920M3-5.0'],pins=[
            Pin(num='1',name='VI',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VO',func=Pin.PWROUT,do_erc=True)]),
        Part(name='SPX2920S-3.3',dest=TEMPLATE,tool=SKIDL,keywords='LDO Voltage Regulator 400mA 5V Adjustable',description='400mA Fixed/Adjustable 1.2-20V Low Drop-out Voltage Regualtor, SO-8',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,aliases=['SPX2920S-5.0'],pins=[
            Pin(num='1',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='SENSE',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='~SD~',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='~ERROR~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='TAP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='FB',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='IN',func=Pin.PWRIN,do_erc=True)]),
        Part(name='SPX2920T-3.3',dest=TEMPLATE,tool=SKIDL,keywords='REGULATOR LDO 5V',description='400mA Low drop-out regulator, Fixed Output 5V, TO-263',ref_prefix='U',num_units=1,fplist=['TO*'],do_erc=True,aliases=['SPX2920T-5.0'],pins=[
            Pin(num='1',name='VI',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VO',func=Pin.PWROUT,do_erc=True)]),
        Part(name='SPX2920U-3.3',dest=TEMPLATE,tool=SKIDL,keywords='REGULATOR LDO 5V',description='400mA Low drop-out regulator, Fixed Output 5V, TO-220',ref_prefix='U',num_units=1,fplist=['TO*'],do_erc=True,aliases=['SPX2920U-5.0'],pins=[
            Pin(num='1',name='VI',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VO',func=Pin.PWROUT,do_erc=True)]),
        Part(name='TC1054',dest=TEMPLATE,tool=SKIDL,keywords='LDO regulator voltage',description='150mA Low Dropout Regulator with ERROR output in 5-Pin SOT-23 package',ref_prefix='U',num_units=1,do_erc=True,aliases=['TC1055', 'TC1186'],pins=[
            Pin(num='1',name='Vin',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~SHDN',do_erc=True),
            Pin(num='4',name='~ERROR',do_erc=True),
            Pin(num='5',name='Vout',func=Pin.PWROUT,do_erc=True)]),
        Part(name='TC1262-33VDB',dest=TEMPLATE,tool=SKIDL,keywords='Voltage Regulator 5.0V 500mA Positive CMOS LDO Microchip',description='500mA Low Dropout CMOS Voltage Regulator, Fixed Output 5.0V, SOT-223',ref_prefix='U',num_units=1,fplist=['SOT-223*'],do_erc=True,aliases=['TC1262-25VDB', 'TC1262-28VDB', 'TC1262-30VDB', 'TC1262-50VDB'],pins=[
            Pin(num='1',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VOUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TLV70012DCK',dest=TEMPLATE,tool=SKIDL,keywords='200mA LDO Regulator Fixed Positive',description='200 mA Low Dropout Voltage Regulator, Fixed Output 3.3V, SC70-5',ref_prefix='U',num_units=1,fplist=['SC*'],do_erc=True,aliases=['TLV70015DCK', 'TLV70018DCK', 'TLV70025DCK', 'TLV70028DCK', 'TLV70030DCK', 'TLV70033DCK'],pins=[
            Pin(num='1',name='IN',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='EN',do_erc=True),
            Pin(num='5',name='OUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='TLV70012DDC',dest=TEMPLATE,tool=SKIDL,keywords='200mA LDO Regulator Fixed Positive',description='200 mA Low Dropout Voltage Regulator, Fixed Output 3.6V, SOT-23-5',ref_prefix='U',num_units=1,fplist=['SOT*'],do_erc=True,aliases=['TLV70013DDC', 'TLV70015DDC', 'TLV70018DDC', 'TLV70019DDC', 'TLV70025DDC', 'TLV70030DDC', 'TLV70032DDC', 'TLV70033DDC', 'TLV70036DDC'],pins=[
            Pin(num='1',name='IN',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='EN',do_erc=True),
            Pin(num='5',name='OUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='TLV70012DSE',dest=TEMPLATE,tool=SKIDL,keywords='200mA LDO Regulator Fixed Positive',description='200 mA Low Dropout Voltage Regulator, Fixed Output 3.6V, WSON6',ref_prefix='U',num_units=1,fplist=['WSON*', 'SON*'],do_erc=True,aliases=['TLV70015DSE', 'TLV70018DSE', 'TLV70025DSE', 'TLV70028DSE', 'TLV70029DSE', 'TLV70030DSE', 'TLV70031DSE', 'TLV70033DSE', 'TLV70036DSE'],pins=[
            Pin(num='1',name='IN',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='EN',do_erc=True)]),
        Part(name='TLV70212DBV',dest=TEMPLATE,tool=SKIDL,keywords='300mA LDO Regulator Fixed Positive',description='300 mA Low Dropout Voltage Regulator, Fixed Output 4.75V, SOT-23-5',ref_prefix='U',num_units=1,fplist=['SOT*'],do_erc=True,aliases=['TLV70215DBV', 'TLV70218DBV', 'TLV70225DBV', 'TLV70228DBV', 'TLV70230DBV', 'TLV70231DBV', 'TLV70233DBV', 'TLV70235DBV', 'TLV70237DBV', 'TLV70245DBV', 'TLV702475DBV'],pins=[
            Pin(num='1',name='IN',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='EN',do_erc=True),
            Pin(num='5',name='OUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='TLV70225DSE',dest=TEMPLATE,tool=SKIDL,keywords='300mA LDO Regulator Fixed Positive',description='300 mA Low Dropout Voltage Regulator, Fixed Output 4.2V, WSON6',ref_prefix='U',num_units=1,fplist=['WSON*', 'SON*'],do_erc=True,aliases=['TLV70228DSE', 'TLV70229DSE', 'TLV70233DSE', 'TLV70236DSE', 'TLV70237DSE', 'TLV70242PDSE'],pins=[
            Pin(num='1',name='IN',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='EN',do_erc=True)]),
        Part(name='TLV71209DBV',dest=TEMPLATE,tool=SKIDL,keywords='LDO Regulator Fixed Positive',description='150mA Low Dropout Voltage Regulator, Fixed Output 3.3V, SOT-23-5',ref_prefix='U',num_units=1,fplist=['SOT-23*'],do_erc=True,aliases=['TLV71210DBV', 'TLV71211DBV', 'TLV71310PDBV', 'TLV71311PDBV', 'TLV71312PDBV', 'TLV71315PDBV', 'TLV71318PDBV', 'TLV713185PDBV', 'TLV71325PDBV', 'TLV71328PDBV', 'TLV713285PDBV', 'TLV71330PDBV', 'TLV71333PDBV'],pins=[
            Pin(num='1',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='EN',do_erc=True),
            Pin(num='4',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='5',name='OUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='TPS70202PWP',dest=TEMPLATE,tool=SKIDL,keywords='Dual LDO Adjustable Regulator 500mA 250mA Voltage Supervisor',description='500mA/250mA Dual Adjustable Low Drop-out Regulator with Voltage Supervisor, PowerPAD TSSOP-20',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='2',name='VIN1',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VIN1',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~MR~',do_erc=True),
            Pin(num='5',name='~EN1~',do_erc=True),
            Pin(num='6',name='~EN2~',do_erc=True),
            Pin(num='7',name='~RESET~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VIN2',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='VIN2',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VOUT2',func=Pin.PWROUT,do_erc=True),
            Pin(num='13',name='VOUT2',func=Pin.PWROUT,do_erc=True),
            Pin(num='14',name='FB2',do_erc=True),
            Pin(num='15',name='PG2',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='16',name='PG1',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='17',name='FB1',do_erc=True),
            Pin(num='18',name='VOUT1',func=Pin.PWROUT,do_erc=True),
            Pin(num='19',name='VOUT1',func=Pin.PWROUT,do_erc=True)]),
        Part(name='TPS70245PWP',dest=TEMPLATE,tool=SKIDL,keywords='Dual 3.3V 2.5V LDO Regulator 500mA 250mA Voltage Supervisor',description='3.3V 500mA/2.5V 250mA Dual Low Drop-out Regulator with Voltage Supervisor, PowerPAD TSSOP-20',ref_prefix='U',num_units=1,do_erc=True,aliases=['TPS70248PWP', 'TPS70251PWP', 'TPS70258PWP'],pins=[
            Pin(num='2',name='VIN1',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VIN1',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~MR~',do_erc=True),
            Pin(num='5',name='~EN1~',do_erc=True),
            Pin(num='6',name='~EN2~',do_erc=True),
            Pin(num='7',name='~RESET~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VIN2',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='VIN2',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VOUT2',func=Pin.PWROUT,do_erc=True),
            Pin(num='13',name='VOUT2',func=Pin.PWROUT,do_erc=True),
            Pin(num='14',name='VSENS2',do_erc=True),
            Pin(num='15',name='PG2',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='16',name='PG1',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='17',name='VSENS1',do_erc=True),
            Pin(num='18',name='VOUT1',func=Pin.PWROUT,do_erc=True),
            Pin(num='19',name='VOUT1',func=Pin.PWROUT,do_erc=True)]),
        Part(name='TPS7101QD',dest=TEMPLATE,tool=SKIDL,keywords='LDO Voltage Regulator 500mA Adjustable',description='500mA Adjustable 1.2-9.75V Low Drop-out Voltage Regualtor, SO-8',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='~EN~',do_erc=True),
            Pin(num='3',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='7',name='FB',do_erc=True),
            Pin(num='8',name='PG',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='TPS7101QP',dest=TEMPLATE,tool=SKIDL,keywords='LDO Voltage Regulator 500mA Adjustable',description='500mA Adjustable 1.2-9.75V Low Drop-out Voltage Regualtor, DIP-8',ref_prefix='U',num_units=1,fplist=['DIP*', 'DIL*'],do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='~EN~',do_erc=True),
            Pin(num='3',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='7',name='FB',do_erc=True),
            Pin(num='8',name='PG',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='TPS7150QD',dest=TEMPLATE,tool=SKIDL,keywords='LDO Voltage Regulator 500mA',description='500mA Low Drop-out Voltage Regualtor, Fixed Output 5V, SO-8',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,aliases=['TPS7148QD', 'TPS7133QD'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='~EN~',do_erc=True),
            Pin(num='3',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='7',name='SENSE',do_erc=True),
            Pin(num='8',name='PG',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='TPS7150QP',dest=TEMPLATE,tool=SKIDL,keywords='LDO Voltage Regulator 500mA',description='500mA Low Drop-out Voltage Regualtor, Fixed Output 5V, DIP-8',ref_prefix='U',num_units=1,fplist=['DIP*', 'DIL*'],do_erc=True,aliases=['TPS7148QP', 'TPS7133QP'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='~EN~',do_erc=True),
            Pin(num='3',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='7',name='SENSE',do_erc=True),
            Pin(num='8',name='PG',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='TPS71518DCKR',dest=TEMPLATE,tool=SKIDL,keywords='LDO regulator voltage',description='Low-drop Voltage Regulator, Io up to 50mA, Fixed Vo 5V, Ignd 3.2uA , SC70.',ref_prefix='U',num_units=1,fplist=['SC-70*'],do_erc=True,aliases=['TPS71519DCKR', 'TPS71523DCKR', 'TPS71525DCKR', 'TPS71530DCKR', 'TPS71533DCKR', 'TPS715345DCKR', 'TPS71550DCKR'],pins=[
            Pin(num='1',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='OUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='TPS75005RGW',dest=TEMPLATE,tool=SKIDL,keywords='Dual LDO Regulator Dual Integrated Power SVS Supervisor',description='Integrated MCU Power Solution, Dual Low Drop-Out Regulator 500mA with Supervisor, VQFN20',ref_prefix='U',num_units=1,fplist=['*QFN*'],do_erc=True,pins=[
            Pin(num='1',name='OUT2',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='OUT2_S',do_erc=True),
            Pin(num='3',name='CT2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='SS2',do_erc=True),
            Pin(num='5',name='VDET',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='SEQ',do_erc=True),
            Pin(num='9',name='VSET',do_erc=True),
            Pin(num='10',name='PG',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='TEST',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='SS1',do_erc=True),
            Pin(num='13',name='CT1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='OUT1_S',do_erc=True),
            Pin(num='15',name='OUT1',func=Pin.PWROUT,do_erc=True),
            Pin(num='16',name='VMON',do_erc=True),
            Pin(num='17',name='EN',do_erc=True),
            Pin(num='18',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='IN',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TPS76301',dest=TEMPLATE,tool=SKIDL,keywords='linear low dropout Regulator fixed',description='Low power 150mA LDO 5.0V fixed output voltage',ref_prefix='U',num_units=1,fplist=['SOT*'],do_erc=True,aliases=['TPS76316', 'TPS76318', 'TPS76325', 'TPS76327', 'TPS76329', 'TPS76330', 'TPS76333', 'TPS76338', 'TPS76350'],pins=[
            Pin(num='1',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='EN',do_erc=True),
            Pin(num='4',name='FB',do_erc=True),
            Pin(num='5',name='VOUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='TPS769XX',dest=TEMPLATE,tool=SKIDL,keywords='Ultra Low Power Fixed Adjustable LDO 100mA',description='TPS769xx-Q1, Ultra Low Power 100mA Low Drop Out Regulator 1.2...5V, SOT-23-5',ref_prefix='U',num_units=1,fplist=['SOT-23*', 'SOT-23*'],do_erc=True,pins=[
            Pin(num='1',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='~EN~',do_erc=True),
            Pin(num='4',name='NC/FB',do_erc=True),
            Pin(num='5',name='OUT',func=Pin.PWROUT,do_erc=True)]),
        Part(name='TPS77701D',dest=TEMPLATE,tool=SKIDL,keywords='750mA LDO Regulator Fixed Positive',description='750 mA Fast-Transient Low Dropout Voltage Regulator, Fixed Output 3.3V, SOIC8',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,aliases=['TPS77715D', 'TPS77718D', 'TPS77725D', 'TPS77733D'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='~EN~',do_erc=True),
            Pin(num='3',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VOUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='VOUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='7',name='NC/FB',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='~RESET~',func=Pin.OPENCOLL,do_erc=True)]),
        Part(name='TPS77701PWP',dest=TEMPLATE,tool=SKIDL,keywords='750mA LDO Regulator Fixed Positive',description='750 mA Fast-Transient Low Dropout Voltage Regulator, Fixed Output 3.3V, HTSSOP20',ref_prefix='U',num_units=1,fplist=['HTSSOP*'],do_erc=True,aliases=['TPS77715PWP', 'TPS77718PWP', 'TPS77725PWP', 'TPS77733PWP'],pins=[
            Pin(num='1',name='GND/HS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND/HS',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='~EN~',do_erc=True),
            Pin(num='6',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='GND/HS',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='GND/HS',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='GND/HS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='GND/HS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='GND/HS',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VOUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='14',name='VOUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='15',name='NC/FB',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='~RESET~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='19',name='GND/HS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TPS77801D',dest=TEMPLATE,tool=SKIDL,keywords='750mA LDO Regulator Fixed Positive',description='750 mA Fast-Transient Low Dropout Voltage Regulator, Fixed Output 3.3V, SOIC8',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,aliases=['TPS77815D', 'TPS77818D', 'TPS77825D', 'TPS77833D'],pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='~EN~',do_erc=True),
            Pin(num='3',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VOUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='VOUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='7',name='NC/FB',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='PG',func=Pin.OPENCOLL,do_erc=True)]),
        Part(name='TPS77801PWP',dest=TEMPLATE,tool=SKIDL,keywords='750mA LDO Regulator Fixed Positive',description='750 mA Fast-Transient Low Dropout Voltage Regulator, Fixed Output 3.3V, HTSSOP20',ref_prefix='U',num_units=1,fplist=['HTSSOP*'],do_erc=True,aliases=['TPS77815PWP', 'TPS77818PWP', 'TPS77825PWP', 'TPS77833PWP'],pins=[
            Pin(num='1',name='GND/HS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND/HS',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='~EN~',do_erc=True),
            Pin(num='6',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='GND/HS',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='GND/HS',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='GND/HS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='GND/HS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='GND/HS',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VOUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='14',name='VOUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='15',name='NC/FB',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='PG',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='19',name='GND/HS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TPS79318-EP',dest=TEMPLATE,tool=SKIDL,keywords='LDO Voltage Regulator 200mA',description='200mA UltraLow-Noise, High-Precision, Fast RF, Low Drop-out Voltage Regualtor, Fixed Output 4.75V, SOT-23',ref_prefix='U',num_units=1,fplist=['*SOT-23-5*'],do_erc=True,aliases=['TPS79325-EP', 'TPS79328-EP', 'TPS793285-EP', 'TPS79330-EP', 'TPS793333-EP', 'TPS793475-EP'],pins=[
            Pin(num='1',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='CE',do_erc=True),
            Pin(num='4',name='BYPASS',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='OUT',func=Pin.PWROUT,do_erc=True)])])
