from skidl import SKIDL, TEMPLATE, Part, Pin, SchLib

SKIDL_lib_version = '0.0.1'

xilinx = SchLib(tool=SKIDL).add_parts(*[
        Part(name='4003APG120',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['4003PG120']),
        Part(name='4003HPQ208',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='4005HMQ240',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='4013PQ240',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='XC1736APD8',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='XC18V01SO20',dest=TEMPLATE,tool=SKIDL,ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='D0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='D2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='CLK',do_erc=True),
            Pin(num='4',name='TDI',do_erc=True),
            Pin(num='5',name='TMS',do_erc=True),
            Pin(num='6',name='TCK',do_erc=True),
            Pin(num='7',name='D4/CF',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='8',name='OE/RESET',do_erc=True),
            Pin(num='9',name='D6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='CE',do_erc=True),
            Pin(num='20',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='D7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='CEO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='D5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='D3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='D1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='TDO',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='18',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='VCCO',func=Pin.PWRIN,do_erc=True)]),
        Part(name='XC2018-PC68',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['XC2064-PC68']),
        Part(name='XC2018-PC84',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='XC2C256-TQ144',dest=TEMPLATE,tool=SKIDL,keywords='CPLD',description='CoolRunner-II CPLD, 256 macrocells',ref_prefix='U',num_units=1,fplist=['TQFP*20x20mm*Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GTS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='GTS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P4',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='GTS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='GTS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='P7',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VCCAUX',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='P9',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P10',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='P20',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='GCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='P40',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='P50',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='P60',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='P70',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='P80',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='P11',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='P21',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='P31',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='P41',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='P51',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='P61',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='P71',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='P81',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='P91',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P12',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='P22',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='GCK1',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='P42',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='P52',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='72',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='82',name='P82',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='P92',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P13',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='P23',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='P33',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='P43',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='P53',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='TDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='VCCIO1',func=Pin.PWRIN,do_erc=True),
            Pin(num='83',name='P83',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='VCCIO1',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='P14',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='P24',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='P34',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='P44',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='P54',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='P64',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='P74',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='94',name='P94',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='P15',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='P25',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='CDRST',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='P45',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='VCCIO1',func=Pin.PWRIN,do_erc=True),
            Pin(num='65',name='TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='P75',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='P85',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='P95',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='P16',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='P26',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='46',name='P46',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='P56',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='P66',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='P76',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='P86',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='P96',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='P17',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='VCCIO1',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='57',name='P57',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='P77',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='P87',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='P97',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='P18',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='P28',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='GCK2',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='P48',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='P58',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='P68',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='P78',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='P88',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='P98',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P19',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='DGE',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='P49',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='P59',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='P69',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='P79',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='100',name='P100',func=Pin.BIDIR,do_erc=True),
            Pin(num='110',name='P110',func=Pin.BIDIR,do_erc=True),
            Pin(num='120',name='P120',func=Pin.BIDIR,do_erc=True),
            Pin(num='130',name='P130',func=Pin.BIDIR,do_erc=True),
            Pin(num='140',name='P140',func=Pin.BIDIR,do_erc=True),
            Pin(num='101',name='P101',func=Pin.BIDIR,do_erc=True),
            Pin(num='111',name='P111',func=Pin.BIDIR,do_erc=True),
            Pin(num='121',name='P121',func=Pin.BIDIR,do_erc=True),
            Pin(num='131',name='P131',func=Pin.BIDIR,do_erc=True),
            Pin(num='141',name='VCCIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='102',name='P102',func=Pin.BIDIR,do_erc=True),
            Pin(num='112',name='P112',func=Pin.BIDIR,do_erc=True),
            Pin(num='122',name='TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='132',name='P132',func=Pin.BIDIR,do_erc=True),
            Pin(num='142',name='P142',func=Pin.BIDIR,do_erc=True),
            Pin(num='103',name='P103',func=Pin.BIDIR,do_erc=True),
            Pin(num='113',name='P113',func=Pin.BIDIR,do_erc=True),
            Pin(num='123',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='133',name='P133',func=Pin.BIDIR,do_erc=True),
            Pin(num='143',name='GSR',func=Pin.BIDIR,do_erc=True),
            Pin(num='104',name='P104',func=Pin.BIDIR,do_erc=True),
            Pin(num='114',name='P114',func=Pin.BIDIR,do_erc=True),
            Pin(num='124',name='P124',func=Pin.BIDIR,do_erc=True),
            Pin(num='134',name='P134',func=Pin.BIDIR,do_erc=True),
            Pin(num='144',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='105',name='P105',func=Pin.BIDIR,do_erc=True),
            Pin(num='115',name='P115',func=Pin.BIDIR,do_erc=True),
            Pin(num='125',name='P125',func=Pin.BIDIR,do_erc=True),
            Pin(num='135',name='P135',func=Pin.BIDIR,do_erc=True),
            Pin(num='106',name='P106',func=Pin.BIDIR,do_erc=True),
            Pin(num='116',name='P116',func=Pin.BIDIR,do_erc=True),
            Pin(num='126',name='P126',func=Pin.BIDIR,do_erc=True),
            Pin(num='136',name='P136',func=Pin.BIDIR,do_erc=True),
            Pin(num='107',name='P107',func=Pin.BIDIR,do_erc=True),
            Pin(num='117',name='P117',func=Pin.BIDIR,do_erc=True),
            Pin(num='127',name='VCCIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='137',name='P137',func=Pin.BIDIR,do_erc=True),
            Pin(num='108',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='118',name='P118',func=Pin.BIDIR,do_erc=True),
            Pin(num='128',name='P128',func=Pin.BIDIR,do_erc=True),
            Pin(num='138',name='P138',func=Pin.BIDIR,do_erc=True),
            Pin(num='109',name='VCCIO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='119',name='P119',func=Pin.BIDIR,do_erc=True),
            Pin(num='129',name='P129',func=Pin.BIDIR,do_erc=True),
            Pin(num='139',name='P139',func=Pin.BIDIR,do_erc=True)]),
        Part(name='XC2C256-VQ100',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='XC2S100TQ144',dest=TEMPLATE,tool=SKIDL,keywords='FPGA',description='spartan 2',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TCK',do_erc=True),
            Pin(num='3',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='IO/VREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='IO/VREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='IO7P10',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='/WR',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='IO/D5',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='80',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='IO/VREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='/CS',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='IO/IRDY',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='71',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='81',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='91',name='I/GCK1',do_erc=True),
            Pin(num='12',name='IO/VREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='TDI',do_erc=True),
            Pin(num='42',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='62',name='IO/D6',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='DONE',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='82',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='43',name='IO/VREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='IO/VREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='83',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='TDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='44',name='IO/D1',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='IO/TRDY',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='IO/VREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='I/GCK3',do_erc=True),
            Pin(num='25',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='45',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='65',name='IO/VREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='46',name='IO/D2',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='IO/VREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='CCLK',do_erc=True),
            Pin(num='47',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='IO/D4',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='IO/D7',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='IO/VREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='I/GCK2',do_erc=True),
            Pin(num='28',name='IO/REF',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='BUSY/DOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='48',name='IO/VREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='IO/VREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='INIT/IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='I/CCK0',do_erc=True),
            Pin(num='98',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='D0/DIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='IO/D3',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='PROG',do_erc=True),
            Pin(num='79',name='IO/VREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='IO/VREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='110',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='120',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='130',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='140',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='101',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='111',name='M1',do_erc=True),
            Pin(num='121',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='131',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='141',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='102',name='IO/VREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='112',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='122',name='IO/VREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='132',name='IO/VREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='142',name='TMS',do_erc=True),
            Pin(num='103',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='113',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='123',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='133',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='143',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='114',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='124',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='134',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='144',name='VCCO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='115',name='IO/VREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='125',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='135',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='106',name='M2',do_erc=True),
            Pin(num='116',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='126',name='IO/TRDY',func=Pin.BIDIR,do_erc=True),
            Pin(num='136',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='107',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='117',name='IO/VREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='127',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='137',name='139/VREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='108',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='118',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='128',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='138',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='109',name='M0',do_erc=True),
            Pin(num='119',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='129',name='IO/IRDY',func=Pin.BIDIR,do_erc=True),
            Pin(num='139',name='IO/VREF',func=Pin.BIDIR,do_erc=True)]),
        Part(name='XC2S150PQ208',dest=TEMPLATE,tool=SKIDL,keywords='FPGA',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='IO7P3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='IO7P4',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='IO7P5',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='IO7VRP6',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='IO7P7',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='IO7P8',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='IO7P9',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='IO7P10',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='IO7VRP20',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='IO6P30',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='M1',do_erc=True),
            Pin(num='60',name='IO5P60',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='IO5P70',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='GCK0',do_erc=True),
            Pin(num='90',name='IO4P90',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='IO7P21',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='IO6VRP31',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='IO6P41',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='IO5P61',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='IO5P71',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='IO4P81',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='IO7P22',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='42',name='IO6P42',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='M0',do_erc=True),
            Pin(num='62',name='IO5P62',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='82',name='IO4P82',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='IO7P23',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='IO6P33',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='IO6P43',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='IO5P63',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='IO5VRP73',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='IO4P83',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='IO7P14',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='IRDY7',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IO6P34',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='IO6P44',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='M2',do_erc=True),
            Pin(num='64',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='IO5P74',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='IO4VRP84',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='IO4P94',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='IO7P15',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='IO6P35',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='IO6VRP45',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='85',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='95',name='IO4P95',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='IO7P16',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='IO6P36',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='IO6P46',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='76',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='86',name='IO4P86',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='IO4P96',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='IO7P17',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='TRDY6',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='IO6P37',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='IO6P47',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='IO5P57',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='IO5P67',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='GCK1',do_erc=True),
            Pin(num='87',name='IO4P87',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='IO4P97',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='IO7P18',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='IO6P48',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='IO5P58',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='IO5P68',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='88',name='IO4P88',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='IO4VRP98',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='IO6P29',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='IO6P49',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='IO5VRP59',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='IO5P69',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='89',name='IO4P89',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='IO4P99',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='IO4P100',func=Pin.BIDIR,do_erc=True),
            Pin(num='200',name='IO0P200',func=Pin.BIDIR,do_erc=True),
            Pin(num='110',name='IO3P110',func=Pin.BIDIR,do_erc=True),
            Pin(num='120',name='IO3P120',func=Pin.BIDIR,do_erc=True),
            Pin(num='130',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='140',name='IO2P140',func=Pin.BIDIR,do_erc=True),
            Pin(num='150',name='IO2VRP150',func=Pin.BIDIR,do_erc=True),
            Pin(num='160',name='/CS',func=Pin.BIDIR,do_erc=True),
            Pin(num='170',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='180',name='IO1P180',func=Pin.BIDIR,do_erc=True),
            Pin(num='190',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='101',name='IO4P101',func=Pin.BIDIR,do_erc=True),
            Pin(num='201',name='IO0P201',func=Pin.BIDIR,do_erc=True),
            Pin(num='111',name='IO3VRP111',func=Pin.BIDIR,do_erc=True),
            Pin(num='121',name='IO3P121',func=Pin.BIDIR,do_erc=True),
            Pin(num='131',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='141',name='IO2P141',func=Pin.BIDIR,do_erc=True),
            Pin(num='151',name='IO2P151',func=Pin.BIDIR,do_erc=True),
            Pin(num='161',name='/WR',func=Pin.BIDIR,do_erc=True),
            Pin(num='171',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='181',name='IO1P181',func=Pin.BIDIR,do_erc=True),
            Pin(num='191',name='IO0P191',func=Pin.BIDIR,do_erc=True),
            Pin(num='102',name='IO4P102',func=Pin.BIDIR,do_erc=True),
            Pin(num='202',name='IO0P202',func=Pin.BIDIR,do_erc=True),
            Pin(num='112',name='IO3P112',func=Pin.BIDIR,do_erc=True),
            Pin(num='122',name='IO3P122',func=Pin.BIDIR,do_erc=True),
            Pin(num='132',name='IRDY2',func=Pin.BIDIR,do_erc=True),
            Pin(num='142',name='IO2/D2P142',func=Pin.BIDIR,do_erc=True),
            Pin(num='152',name='IO2P152',func=Pin.BIDIR,do_erc=True),
            Pin(num='162',name='IO1P162',func=Pin.BIDIR,do_erc=True),
            Pin(num='172',name='IO1P172',func=Pin.BIDIR,do_erc=True),
            Pin(num='182',name='GCK2',do_erc=True),
            Pin(num='192',name='IO0P192',func=Pin.BIDIR,do_erc=True),
            Pin(num='103',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='203',name='IO0VRP203',func=Pin.BIDIR,do_erc=True),
            Pin(num='113',name='IO3P113',func=Pin.BIDIR,do_erc=True),
            Pin(num='123',name='IO3P123',func=Pin.BIDIR,do_erc=True),
            Pin(num='133',name='IO2P133',func=Pin.BIDIR,do_erc=True),
            Pin(num='143',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='153',name='D0/DIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='163',name='IO1P163',func=Pin.BIDIR,do_erc=True),
            Pin(num='173',name='IO1P173',func=Pin.BIDIR,do_erc=True),
            Pin(num='183',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='193',name='IO0P193',func=Pin.BIDIR,do_erc=True),
            Pin(num='104',name='DONE',func=Pin.BIDIR,do_erc=True),
            Pin(num='204',name='IO0P204',func=Pin.BIDIR,do_erc=True),
            Pin(num='114',name='IO3P114',func=Pin.BIDIR,do_erc=True),
            Pin(num='124',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='134',name='IO2P134',func=Pin.BIDIR,do_erc=True),
            Pin(num='144',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='154',name='BUSY/DOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='164',name='IO1VRP164',func=Pin.BIDIR,do_erc=True),
            Pin(num='174',name='IO1P174',func=Pin.BIDIR,do_erc=True),
            Pin(num='184',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='194',name='IO0P194',func=Pin.BIDIR,do_erc=True),
            Pin(num='105',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='205',name='IO0P205',func=Pin.BIDIR,do_erc=True),
            Pin(num='115',name='IO3/D6P115',func=Pin.BIDIR,do_erc=True),
            Pin(num='125',name='IO3VRP125',func=Pin.BIDIR,do_erc=True),
            Pin(num='135',name='IO2/D3P135',func=Pin.BIDIR,do_erc=True),
            Pin(num='145',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='155',name='CCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='165',name='IO1P165',func=Pin.BIDIR,do_erc=True),
            Pin(num='175',name='IO1P175',func=Pin.BIDIR,do_erc=True),
            Pin(num='185',name='GCK3',do_erc=True),
            Pin(num='195',name='IO0P195',func=Pin.BIDIR,do_erc=True),
            Pin(num='106',name='/PROG',do_erc=True),
            Pin(num='206',name='IO0P206',func=Pin.BIDIR,do_erc=True),
            Pin(num='116',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='126',name='IO3/D4P126',func=Pin.BIDIR,do_erc=True),
            Pin(num='136',name='IO2VRP136',func=Pin.BIDIR,do_erc=True),
            Pin(num='146',name='IO2/D1P46',func=Pin.BIDIR,do_erc=True),
            Pin(num='156',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='166',name='IO1P166',func=Pin.BIDIR,do_erc=True),
            Pin(num='176',name='IO1P176',func=Pin.BIDIR,do_erc=True),
            Pin(num='186',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='196',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='107',name='/INIT',func=Pin.BIDIR,do_erc=True),
            Pin(num='207',name='TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='117',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='127',name='IO3P127',func=Pin.BIDIR,do_erc=True),
            Pin(num='137',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='147',name='IO2P147',func=Pin.BIDIR,do_erc=True),
            Pin(num='157',name='TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='167',name='IO1P167',func=Pin.BIDIR,do_erc=True),
            Pin(num='177',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='187',name='IO0P187',func=Pin.BIDIR,do_erc=True),
            Pin(num='197',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='108',name='IO3/D7P108',func=Pin.BIDIR,do_erc=True),
            Pin(num='208',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='118',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='128',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='138',name='IO2P138',func=Pin.BIDIR,do_erc=True),
            Pin(num='148',name='IO2P148',func=Pin.BIDIR,do_erc=True),
            Pin(num='158',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='168',name='IO1P168',func=Pin.BIDIR,do_erc=True),
            Pin(num='178',name='IO1VRP178',func=Pin.BIDIR,do_erc=True),
            Pin(num='188',name='IO0P188',func=Pin.BIDIR,do_erc=True),
            Pin(num='198',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='109',name='IO3P109',func=Pin.BIDIR,do_erc=True),
            Pin(num='119',name='IO3/D5P119',func=Pin.BIDIR,do_erc=True),
            Pin(num='129',name='TRDY3',func=Pin.BIDIR,do_erc=True),
            Pin(num='139',name='IO2P139',func=Pin.BIDIR,do_erc=True),
            Pin(num='149',name='IO2P149',func=Pin.BIDIR,do_erc=True),
            Pin(num='159',name='TDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='169',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='179',name='IO1P179',func=Pin.BIDIR,do_erc=True),
            Pin(num='189',name='IO0VRP189',func=Pin.BIDIR,do_erc=True),
            Pin(num='199',name='IO0P199',func=Pin.BIDIR,do_erc=True)]),
        Part(name='XC2S200PQ208',dest=TEMPLATE,tool=SKIDL,keywords='FPGA',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='IO7P3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='IO7VRP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='IO7P5',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='IO7VRP6',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='IO7P7',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='IO7P8',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='IO7VRP9',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='IO7P10',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='IO7VRP20',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='IO6P30',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='50',name='M1',do_erc=True),
            Pin(num='60',name='IO5P60',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='IO5P70',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='GCK0',do_erc=True),
            Pin(num='90',name='IO4P90',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='IO7P21',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='IO6VRP31',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='IO6P41',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='61',name='IO5P61',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='IO5P71',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='IO4P81',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='VCCINT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='VCCO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='IO7P22',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='42',name='IO6VRP42',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='M0',do_erc=True),
            Pin(num='62',name='IO5VRP62',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='82',name='IO4P82',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='VCCO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='VCCINT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='IO7P23',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='IO6P33',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='IO6P43',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='VCCO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='63',name='IO5P63',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='IO5VRP73',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='IO4P83',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='IO7P14',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='IRDY7',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IO6P34',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='IO6P44',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='M2',do_erc=True),
            Pin(num='64',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='74',name='IO5P74',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='IO4VRP84',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='IO4P94',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='IO7P15',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='IO6P35',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='IO6VRP45',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='VCCO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='75',name='IO5P75',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='95',name='IO4VRP95',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='IO7P16',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='VCCO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='IO6P36',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='IO6P46',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='VCCINT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='76',name='VCCINT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='86',name='IO4P86',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='IO4P96',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='IO7P17',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='TRDY6',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='IO6P37',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='IO6VRP47',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='IO5VRP57',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='IO5P67',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='GCK1',do_erc=True),
            Pin(num='87',name='IO4P87',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='IO4P97',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='IO7P18',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='VCCINT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='VCCINT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='48',name='IO6P48',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='IO5P58',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='IO5P68',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='VCCO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='88',name='IO4P88',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='IO4VRP98',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='IO6P29',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='VCCO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='49',name='IO6P49',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='IO5VRP59',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='IO5P69',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='89',name='IO4P89',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='IO4P99',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='IO4VRP100',func=Pin.BIDIR,do_erc=True),
            Pin(num='200',name='IO0VRP200',func=Pin.BIDIR,do_erc=True),
            Pin(num='110',name='IO3P110',func=Pin.BIDIR,do_erc=True),
            Pin(num='120',name='IO3P120',func=Pin.BIDIR,do_erc=True),
            Pin(num='130',name='VCCO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='140',name='IO2P140',func=Pin.BIDIR,do_erc=True),
            Pin(num='150',name='IO2VRP150',func=Pin.BIDIR,do_erc=True),
            Pin(num='160',name='/CS',func=Pin.BIDIR,do_erc=True),
            Pin(num='170',name='VCCO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='180',name='IO1P180',func=Pin.BIDIR,do_erc=True),
            Pin(num='190',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='101',name='IO4P101',func=Pin.BIDIR,do_erc=True),
            Pin(num='201',name='IO0P201',func=Pin.BIDIR,do_erc=True),
            Pin(num='111',name='IO3VRP111',func=Pin.BIDIR,do_erc=True),
            Pin(num='121',name='IO3P121',func=Pin.BIDIR,do_erc=True),
            Pin(num='131',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='141',name='IO2P141',func=Pin.BIDIR,do_erc=True),
            Pin(num='151',name='IO2P151',func=Pin.BIDIR,do_erc=True),
            Pin(num='161',name='/WR',func=Pin.BIDIR,do_erc=True),
            Pin(num='171',name='VCCINT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='181',name='IO1P181',func=Pin.BIDIR,do_erc=True),
            Pin(num='191',name='IO0P191',func=Pin.BIDIR,do_erc=True),
            Pin(num='102',name='IO4P102',func=Pin.BIDIR,do_erc=True),
            Pin(num='202',name='IO0P202',func=Pin.BIDIR,do_erc=True),
            Pin(num='112',name='IO3P112',func=Pin.BIDIR,do_erc=True),
            Pin(num='122',name='IO3P122',func=Pin.BIDIR,do_erc=True),
            Pin(num='132',name='IRDY2',func=Pin.BIDIR,do_erc=True),
            Pin(num='142',name='IO2/D2P142',func=Pin.BIDIR,do_erc=True),
            Pin(num='152',name='IO2VRP152',func=Pin.BIDIR,do_erc=True),
            Pin(num='162',name='IO1VRP162',func=Pin.BIDIR,do_erc=True),
            Pin(num='172',name='IO1P172',func=Pin.BIDIR,do_erc=True),
            Pin(num='182',name='GCK2',do_erc=True),
            Pin(num='192',name='IO0P192',func=Pin.BIDIR,do_erc=True),
            Pin(num='103',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='203',name='IO0VRP203',func=Pin.BIDIR,do_erc=True),
            Pin(num='113',name='IO3P113',func=Pin.BIDIR,do_erc=True),
            Pin(num='123',name='IO3P123',func=Pin.BIDIR,do_erc=True),
            Pin(num='133',name='IO2P133',func=Pin.BIDIR,do_erc=True),
            Pin(num='143',name='VCCINT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='153',name='D0/DIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='163',name='IO1P163',func=Pin.BIDIR,do_erc=True),
            Pin(num='173',name='IO1P173',func=Pin.BIDIR,do_erc=True),
            Pin(num='183',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='193',name='IO0P193',func=Pin.BIDIR,do_erc=True),
            Pin(num='104',name='DONE',func=Pin.BIDIR,do_erc=True),
            Pin(num='204',name='IO0P204',func=Pin.BIDIR,do_erc=True),
            Pin(num='114',name='IO3VRP114',func=Pin.BIDIR,do_erc=True),
            Pin(num='124',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='134',name='IO2P134',func=Pin.BIDIR,do_erc=True),
            Pin(num='144',name='VCCO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='154',name='BUSY/DOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='164',name='IO1VRP164',func=Pin.BIDIR,do_erc=True),
            Pin(num='174',name='IO1P174',func=Pin.BIDIR,do_erc=True),
            Pin(num='184',name='VCCO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='194',name='IO0P194',func=Pin.BIDIR,do_erc=True),
            Pin(num='105',name='VCCO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='205',name='IO0VRP205',func=Pin.BIDIR,do_erc=True),
            Pin(num='115',name='IO3/D6P115',func=Pin.BIDIR,do_erc=True),
            Pin(num='125',name='IO3VRP125',func=Pin.BIDIR,do_erc=True),
            Pin(num='135',name='IO2/D3P135',func=Pin.BIDIR,do_erc=True),
            Pin(num='145',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='155',name='CCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='165',name='IO1P165',func=Pin.BIDIR,do_erc=True),
            Pin(num='175',name='IO1P175',func=Pin.BIDIR,do_erc=True),
            Pin(num='185',name='GCK3',do_erc=True),
            Pin(num='195',name='IO0P195',func=Pin.BIDIR,do_erc=True),
            Pin(num='106',name='/PROG',do_erc=True),
            Pin(num='206',name='IO0P206',func=Pin.BIDIR,do_erc=True),
            Pin(num='116',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='126',name='IO3/D4P126',func=Pin.BIDIR,do_erc=True),
            Pin(num='136',name='IO2VRP136',func=Pin.BIDIR,do_erc=True),
            Pin(num='146',name='IO2/D1P46',func=Pin.BIDIR,do_erc=True),
            Pin(num='156',name='VCCO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='166',name='IO1P166',func=Pin.BIDIR,do_erc=True),
            Pin(num='176',name='IO1P176',func=Pin.BIDIR,do_erc=True),
            Pin(num='186',name='VCCINT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='196',name='VCCINT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='107',name='/INIT',func=Pin.BIDIR,do_erc=True),
            Pin(num='207',name='TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='117',name='VCCO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='127',name='IO3P127',func=Pin.BIDIR,do_erc=True),
            Pin(num='137',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='147',name='IO2VRP147',func=Pin.BIDIR,do_erc=True),
            Pin(num='157',name='TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='167',name='IO1VRP167',func=Pin.BIDIR,do_erc=True),
            Pin(num='177',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='187',name='IO0P187',func=Pin.BIDIR,do_erc=True),
            Pin(num='197',name='VCCO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='108',name='IO3/D7P108',func=Pin.BIDIR,do_erc=True),
            Pin(num='208',name='VCCO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='118',name='VCCINT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='128',name='VCCINT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='138',name='IO2P138',func=Pin.BIDIR,do_erc=True),
            Pin(num='148',name='IO2P148',func=Pin.BIDIR,do_erc=True),
            Pin(num='158',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='168',name='IO1P168',func=Pin.BIDIR,do_erc=True),
            Pin(num='178',name='IO1VRP178',func=Pin.BIDIR,do_erc=True),
            Pin(num='188',name='IO0P188',func=Pin.BIDIR,do_erc=True),
            Pin(num='198',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='109',name='IO3VRP109',func=Pin.BIDIR,do_erc=True),
            Pin(num='119',name='IO3/D5P119',func=Pin.BIDIR,do_erc=True),
            Pin(num='129',name='TRDY3',func=Pin.BIDIR,do_erc=True),
            Pin(num='139',name='IO2P139',func=Pin.BIDIR,do_erc=True),
            Pin(num='149',name='IO2P149',func=Pin.BIDIR,do_erc=True),
            Pin(num='159',name='TDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='169',name='GND',func=Pin.PASSIVE,do_erc=True),
            Pin(num='179',name='IO1P179',func=Pin.BIDIR,do_erc=True),
            Pin(num='189',name='IO0VRP189',func=Pin.BIDIR,do_erc=True),
            Pin(num='199',name='IO0P199',func=Pin.BIDIR,do_erc=True)]),
        Part(name='XC2S300PQ208',dest=TEMPLATE,tool=SKIDL,ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='IO7P3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='IO7VRP4',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='IO7P5',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='IO7VRP6',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='IO7P7',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='IO7P8',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='IO7VRP9',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='IO7VRP10',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='IO7VRP20',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='IO6P30',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='IO6P40',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='M1',do_erc=True),
            Pin(num='60',name='IO5P60',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='IO5P70',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='GCK0',do_erc=True),
            Pin(num='90',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='IO7P11',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='IO7P21',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='IO6VRP31',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='IO6VRP41',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='IO5P61',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='IO5P71',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='IO4P81',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='IO7P22',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='42',name='IO6P42',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='M0',do_erc=True),
            Pin(num='62',name='IO5P62',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='82',name='IO4P82',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='IO7P23',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='IO6P33',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='IO6P43',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='IO5VRP63',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='IO5VRP73',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='IO4P83',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='IO4P93',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='IRDY7',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='IO6P34',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='IO6P44',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='M2',do_erc=True),
            Pin(num='64',name='IO5P64',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='IO5P74',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='IO4VRP84',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='IO4VRP94',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='IO7P15',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='IO6P35',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='IO6VRP45',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='IO5P55',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='75',name='IO5P75',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='95',name='IO4P95',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='IO7P16',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='IO6P36',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='IO6P46',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='IO5P56',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='76',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='86',name='IO4P86',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='IO4P96',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='IO7P17',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='TRDY6',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='IO6VRP47',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='IO5VRP57',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='77',name='GCK1',do_erc=True),
            Pin(num='87',name='IO4P87',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='IO4P97',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='IO7P18',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='IO6P48',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='IO5P58',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='IO5P68',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='88',name='IO4P88',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='IO4VRP98',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='IO6P29',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='IO6P49',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='IO5VRP59',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='IO5P69',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='89',name='IO4P89',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='IO4P99',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='IO4VRP100',func=Pin.BIDIR,do_erc=True),
            Pin(num='200',name='IO0P200',func=Pin.BIDIR,do_erc=True),
            Pin(num='110',name='IO3P110',func=Pin.BIDIR,do_erc=True),
            Pin(num='120',name='IO3/D5P120',func=Pin.BIDIR,do_erc=True),
            Pin(num='130',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='140',name='IO2P140',func=Pin.BIDIR,do_erc=True),
            Pin(num='150',name='IO2VRP150',func=Pin.BIDIR,do_erc=True),
            Pin(num='160',name='/CS',func=Pin.BIDIR,do_erc=True),
            Pin(num='170',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='180',name='IO1P180',func=Pin.BIDIR,do_erc=True),
            Pin(num='190',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='101',name='IO4P101',func=Pin.BIDIR,do_erc=True),
            Pin(num='201',name='IO0P201',func=Pin.BIDIR,do_erc=True),
            Pin(num='111',name='IO3VRP111',func=Pin.BIDIR,do_erc=True),
            Pin(num='121',name='IO3P121',func=Pin.BIDIR,do_erc=True),
            Pin(num='131',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='141',name='IO2/D2P141',func=Pin.BIDIR,do_erc=True),
            Pin(num='151',name='IO2P151',func=Pin.BIDIR,do_erc=True),
            Pin(num='161',name='/WR',func=Pin.BIDIR,do_erc=True),
            Pin(num='171',name='VCCO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='181',name='IO1P181',func=Pin.BIDIR,do_erc=True),
            Pin(num='191',name='IO0P191',func=Pin.BIDIR,do_erc=True),
            Pin(num='102',name='IO4P102',func=Pin.BIDIR,do_erc=True),
            Pin(num='202',name='IO0P202',func=Pin.BIDIR,do_erc=True),
            Pin(num='112',name='IO3P112',func=Pin.BIDIR,do_erc=True),
            Pin(num='122',name='IO3P122',func=Pin.BIDIR,do_erc=True),
            Pin(num='132',name='IRDY2',func=Pin.BIDIR,do_erc=True),
            Pin(num='142',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='152',name='IO2VRP152',func=Pin.BIDIR,do_erc=True),
            Pin(num='162',name='IO1VRP162',func=Pin.BIDIR,do_erc=True),
            Pin(num='172',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='182',name='GCK2',do_erc=True),
            Pin(num='192',name='IO0P192',func=Pin.BIDIR,do_erc=True),
            Pin(num='103',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='203',name='IO0VRP203',func=Pin.BIDIR,do_erc=True),
            Pin(num='113',name='IO3P113',func=Pin.BIDIR,do_erc=True),
            Pin(num='123',name='IO3P123',func=Pin.BIDIR,do_erc=True),
            Pin(num='133',name='IO2P133',func=Pin.BIDIR,do_erc=True),
            Pin(num='143',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='153',name='D0/DIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='163',name='IO1P163',func=Pin.BIDIR,do_erc=True),
            Pin(num='173',name='IO1P173',func=Pin.BIDIR,do_erc=True),
            Pin(num='183',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='193',name='IO0P193',func=Pin.BIDIR,do_erc=True),
            Pin(num='104',name='DONE',func=Pin.BIDIR,do_erc=True),
            Pin(num='204',name='IO0P204',func=Pin.BIDIR,do_erc=True),
            Pin(num='114',name='IO3P114',func=Pin.BIDIR,do_erc=True),
            Pin(num='124',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='134',name='IO2P134',func=Pin.BIDIR,do_erc=True),
            Pin(num='144',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='154',name='BUSY/DOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='164',name='IO1VRP164',func=Pin.BIDIR,do_erc=True),
            Pin(num='174',name='IO1P174',func=Pin.BIDIR,do_erc=True),
            Pin(num='184',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='194',name='IO0P194',func=Pin.BIDIR,do_erc=True),
            Pin(num='105',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='205',name='IO0VRP205',func=Pin.BIDIR,do_erc=True),
            Pin(num='115',name='IO3VRP115',func=Pin.BIDIR,do_erc=True),
            Pin(num='125',name='IO3VRP125',func=Pin.BIDIR,do_erc=True),
            Pin(num='135',name='IO2/D3P135',func=Pin.BIDIR,do_erc=True),
            Pin(num='145',name='IO2/D1P145',func=Pin.BIDIR,do_erc=True),
            Pin(num='155',name='CCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='165',name='IO1P165',func=Pin.BIDIR,do_erc=True),
            Pin(num='175',name='IO1P175',func=Pin.BIDIR,do_erc=True),
            Pin(num='185',name='GCK3',do_erc=True),
            Pin(num='195',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='106',name='/PROG',do_erc=True),
            Pin(num='206',name='IO0P206',func=Pin.BIDIR,do_erc=True),
            Pin(num='116',name='IO3/D6P116',func=Pin.BIDIR,do_erc=True),
            Pin(num='126',name='IO3/D4P126',func=Pin.BIDIR,do_erc=True),
            Pin(num='136',name='IO2VRP136',func=Pin.BIDIR,do_erc=True),
            Pin(num='146',name='IO2VRP146',func=Pin.BIDIR,do_erc=True),
            Pin(num='156',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='166',name='IO1P166',func=Pin.BIDIR,do_erc=True),
            Pin(num='176',name='IO1P176',func=Pin.BIDIR,do_erc=True),
            Pin(num='186',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='196',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='107',name='/INIT',func=Pin.BIDIR,do_erc=True),
            Pin(num='207',name='TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='117',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='127',name='IO3P127',func=Pin.BIDIR,do_erc=True),
            Pin(num='137',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='147',name='IO2P147',func=Pin.BIDIR,do_erc=True),
            Pin(num='157',name='TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='167',name='IO1P167',func=Pin.BIDIR,do_erc=True),
            Pin(num='177',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='187',name='IO0P187',func=Pin.BIDIR,do_erc=True),
            Pin(num='197',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='108',name='IO3/D7P108',func=Pin.BIDIR,do_erc=True),
            Pin(num='208',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='118',name='VCCO',func=Pin.PWRIN,do_erc=True),
            Pin(num='128',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='138',name='IO2P138',func=Pin.BIDIR,do_erc=True),
            Pin(num='148',name='IO2P148',func=Pin.BIDIR,do_erc=True),
            Pin(num='158',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='168',name='IO1VRP168',func=Pin.BIDIR,do_erc=True),
            Pin(num='178',name='IO1VRP178',func=Pin.BIDIR,do_erc=True),
            Pin(num='188',name='IO0P188',func=Pin.BIDIR,do_erc=True),
            Pin(num='198',name='IO0P198',func=Pin.BIDIR,do_erc=True),
            Pin(num='109',name='IO3VRP109',func=Pin.BIDIR,do_erc=True),
            Pin(num='119',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='129',name='TRDY3',func=Pin.BIDIR,do_erc=True),
            Pin(num='139',name='IO2P139',func=Pin.BIDIR,do_erc=True),
            Pin(num='149',name='IO2P149',func=Pin.BIDIR,do_erc=True),
            Pin(num='159',name='TDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='169',name='IO1P169',func=Pin.BIDIR,do_erc=True),
            Pin(num='179',name='IO1P179',func=Pin.BIDIR,do_erc=True),
            Pin(num='189',name='IO0VRP189',func=Pin.BIDIR,do_erc=True),
            Pin(num='199',name='IO0VRP199',func=Pin.BIDIR,do_erc=True)]),
        Part(name='XC2S400FT256',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='XC2S50-PQ208',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='XC2S64A-xQFG48',dest=TEMPLATE,tool=SKIDL,description='Xilinx CoolRunner',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='GTS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='GTS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='VCCjtag',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='B1',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='B2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='B3',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='B4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='B5',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='D7',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='D16',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='TDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='GCK0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='TDI',do_erc=True),
            Pin(num='31',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='GCK1',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='TMS',do_erc=True),
            Pin(num='32',name='C15',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='VCCio2',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='GCK2',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='TCK',do_erc=True),
            Pin(num='33',name='C14',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='C3',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='B12',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='D10',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='C12',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='C2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='B13',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='D11',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='C11',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='C1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='D12',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='C10',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='GSR',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='D1',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='D13',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='C9',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='GTS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='D2',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='D13',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='C6',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='GTS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VCCio1',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='VCCint',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='C5',func=Pin.BIDIR,do_erc=True)]),
        Part(name='XC3020-PC68',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['XC3030-PC68']),
        Part(name='XC3030-PC44',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='XC3030-PC84',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['XC3042-PC84']),
        Part(name='XC3030-VQ100',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='XC3042-VQ100',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='XC3S1400A/FG484',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='XC3S200AN/FT256',dest=TEMPLATE,tool=SKIDL,description='BGA256/1mm',ref_prefix='U',num_units=1,fplist=['BGA256'],do_erc=True,pins=[
            Pin(num='A1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B1',name='TDI',do_erc=True),
            Pin(num='C1',name='IO_L01N_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='IO_L03P_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='IO_L03N_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='F1',name='IO_L08P_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='IO_L08N_3/VREF_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H1',name='IO_L11N_3/LHCLK1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J1',name='IO_L14N_3/LHCLK5',func=Pin.BIDIR,do_erc=True),
            Pin(num='K1',name='IO_L15N_3/LHCLK7',func=Pin.BIDIR,do_erc=True),
            Pin(num='L1',name='IO_L16P_3/VREF_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M1',name='IO_L20P_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='N1',name='IO_L20N_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='P1',name='IO_L22N_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='R1',name='IO_L23P_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='T1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A2',name='/PROG',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='TMS',do_erc=True),
            Pin(num='C2',name='IO_L01P_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='D2',name='VCCO3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='E2',name='IO_L05N_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G2',name='IO_L11P_3/LHCLK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='H2',name='VCCO3',func=Pin.PWRIN,do_erc=True),
            Pin(num='J2',name='IO_L14P_3/LHCLK4',func=Pin.BIDIR,do_erc=True),
            Pin(num='K2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='L2',name='IO_L16N_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M2',name='VCCO3',func=Pin.PWRIN,do_erc=True),
            Pin(num='N2',name='IO_L22P_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='P2',name='IO_L23N_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='R2',name='IO_L02P_2/M2',func=Pin.BIDIR,do_erc=True),
            Pin(num='T2',name='IO_L02N_2/CSO_B',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='IO_L19P_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='IO_L19N_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='D3',name='IO_L02N_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='IO_L05P_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='IO_L07P_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='IO_L09P_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='IO_L12P_3/LHCLK2',func=Pin.BIDIR,do_erc=True),
            Pin(num='J3',name='IO_L12N_3/IRDY2/LHCLK3',func=Pin.BIDIR,do_erc=True),
            Pin(num='K3',name='IO_L15P_3/TRDY2/LHCLK6',func=Pin.BIDIR,do_erc=True),
            Pin(num='L3',name='IO_L18N_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M3',name='IO_L19P_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='N3',name='IO_L24P_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='P3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R3',name='IO_L03P_2/RDWR_B',func=Pin.BIDIR,do_erc=True),
            Pin(num='T3',name='IO_L03N_2/VS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='IO_L18P_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='IO_L18N_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C4',name='IO_L20P_0/VREF_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='D4',name='IO_L02P_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='E4',name='IP_L04P_3',do_erc=True),
            Pin(num='F4',name='IP_L04N_3/VREF_3',do_erc=True),
            Pin(num='G4',name='IO_L07N_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H4',name='IO_L09N_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='J4',name='IO_L17P_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='K4',name='IO_L18P_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='L4',name='IO_L19N_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M4',name='IO_L24N_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='N4',name='IO_L01P_2/M1',func=Pin.BIDIR,do_erc=True),
            Pin(num='P4',name='IO_L01N_2/M0',func=Pin.BIDIR,do_erc=True),
            Pin(num='R4',name='VCCO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='T4',name='IO_L05P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='IO_L17P_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B5',name='VCCO0',func=Pin.PWRIN,do_erc=True),
            Pin(num='C5',name='IO_L17N_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='D5',name='IO_L20N_0/PUDC_B',func=Pin.BIDIR,do_erc=True),
            Pin(num='E5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F5',name='VCCAUX',func=Pin.PWRIN,do_erc=True),
            Pin(num='G5',name='IP_L06N_3/VREF_3',do_erc=True),
            Pin(num='H5',name='IO_L10N_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='J5',name='VCCO3',func=Pin.PWRIN,do_erc=True),
            Pin(num='K5',name='IP_L21P_3',do_erc=True),
            Pin(num='L5',name='IP_L25P_3',do_erc=True),
            Pin(num='M5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N5',name='IP_2/VREF_2',do_erc=True),
            Pin(num='P5',name='IO_L04N_2/VS0',func=Pin.BIDIR,do_erc=True),
            Pin(num='R5',name='IO_L05N_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='T5',name='IO_L06P_2/D7',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='IO_L15P_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B6',name='IO_L15N_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C6',name='IO_L16N_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='D6',name='IP_0',do_erc=True),
            Pin(num='E6',name='IP_0',do_erc=True),
            Pin(num='F6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G6',name='IP_L06P_3',do_erc=True),
            Pin(num='H6',name='IO_L10P_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='J6',name='IO_L17N_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='K6',name='IP_L21N_3',do_erc=True),
            Pin(num='L6',name='IP_L25N_3/VREF_3',do_erc=True),
            Pin(num='M6',name='VCCAUX',func=Pin.PWRIN,do_erc=True),
            Pin(num='N6',name='IO_L04P_2/VS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='P6',name='IO_L07N_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='R6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='T6',name='IO_L06N_2/D6',func=Pin.BIDIR,do_erc=True),
            Pin(num='A7',name='IO_L13P_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='C7',name='IO_L13N_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='D7',name='IO_L16P_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='E7',name='IO_L14N_0/VREF_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F7',name='IP_0',do_erc=True),
            Pin(num='G7',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='H7',name='IP_L13P_3',do_erc=True),
            Pin(num='J7',name='IP_L13N_3',do_erc=True),
            Pin(num='K7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='L7',name='IP_2',do_erc=True),
            Pin(num='M7',name='IP_2/VREF_2',do_erc=True),
            Pin(num='N7',name='IO_L07P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='P7',name='IO_L08P_2/D5',func=Pin.BIDIR,do_erc=True),
            Pin(num='R7',name='IO_L09P_2/GCLK12',func=Pin.BIDIR,do_erc=True),
            Pin(num='T7',name='IO_L09N_2/GCLK13',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='IO_L12P_0/GCLK10',func=Pin.BIDIR,do_erc=True),
            Pin(num='B8',name='IO_L12N_0/GCLK11',func=Pin.BIDIR,do_erc=True),
            Pin(num='C8',name='IO_L11P_0/GCLK8',func=Pin.BIDIR,do_erc=True),
            Pin(num='D8',name='IO_L11N_0/GCLK9',func=Pin.BIDIR,do_erc=True),
            Pin(num='E8',name='VCCO0',func=Pin.PWRIN,do_erc=True),
            Pin(num='F8',name='IO_L14P_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H8',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='J8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='K8',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='L8',name='IP_2',do_erc=True),
            Pin(num='M8',name='IP_2/VREF_2',do_erc=True),
            Pin(num='N8',name='IO_L08N_2/D4',func=Pin.BIDIR,do_erc=True),
            Pin(num='P8',name='IO_L10P_2/GCLK14',func=Pin.BIDIR,do_erc=True),
            Pin(num='R8',name='VCCO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='T8',name='IO_L10N_2/GCLK15',func=Pin.BIDIR,do_erc=True),
            Pin(num='A9',name='IO_L10N_0/GCLK7',func=Pin.BIDIR,do_erc=True),
            Pin(num='B9',name='VCCO0',func=Pin.PWRIN,do_erc=True),
            Pin(num='C9',name='IO_L10P_0/GCLK6',func=Pin.BIDIR,do_erc=True),
            Pin(num='D9',name='IO_L09N_0/GCLK5',func=Pin.BIDIR,do_erc=True),
            Pin(num='E9',name='IP_0/VREF_0',do_erc=True),
            Pin(num='F9',name='IP_0',do_erc=True),
            Pin(num='G9',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='H9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J9',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='K9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='L9',name='IP_2/VREF_2',do_erc=True),
            Pin(num='M9',name='VCCO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='N9',name='IO_L11P_2/GCLK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='P9',name='IO_L11N_2/GCLK1',func=Pin.BIDIR,do_erc=True),
            Pin(num='R9',name='IO_L12P_2/GCLK2',func=Pin.BIDIR,do_erc=True),
            Pin(num='T9',name='IO_L12N_2/GCLK3',func=Pin.BIDIR,do_erc=True),
            Pin(num='A10',name='IO_L08N_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B10',name='IO_L08P_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C10',name='IO_L09P_0/GCLK4',func=Pin.BIDIR,do_erc=True),
            Pin(num='D10',name='IO_L06P_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='E10',name='IO_L06N_0/VREF_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F10',name='IP_0',do_erc=True),
            Pin(num='G10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H10',name='IP_L13P_1',do_erc=True),
            Pin(num='J10',name='IP_L09P_1/VREF_1',do_erc=True),
            Pin(num='K10',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='L10',name='IP_2/VREF_2',do_erc=True),
            Pin(num='M10',name='IO_L13N_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='N10',name='IO_L13P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='P10',name='IO_L14N_2/MOSI/CSI_B',func=Pin.BIDIR,do_erc=True),
            Pin(num='R10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='T10',name='IO_L14P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A11',name='IO_L07N_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='C11',name='IO_L07P_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='D11',name='IO_L03N_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='E11',name='VCCAUX',func=Pin.PWRIN,do_erc=True),
            Pin(num='F11',name='IP_L25N_1',do_erc=True),
            Pin(num='G11',name='IP_L21N_1',do_erc=True),
            Pin(num='H11',name='IP_L13N_1',do_erc=True),
            Pin(num='J11',name='IP_L09N_1',do_erc=True),
            Pin(num='K11',name='IP_L04P_1',do_erc=True),
            Pin(num='L11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='M11',name='IP_2/VREF_2',do_erc=True),
            Pin(num='N11',name='IO_L16N_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='P11',name='IO_L16P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='R11',name='IO_L15N_2/DOUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='T11',name='IO_L15P_2/AWAKE',func=Pin.BIDIR,do_erc=True),
            Pin(num='A12',name='IO_L05N_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B12',name='IO_L05P_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C12',name='IO_L03P_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='D12',name='IP_0',do_erc=True),
            Pin(num='E12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F12',name='IP_L25P_1/VREF_1',do_erc=True),
            Pin(num='G12',name='IP_L21P_1/VREF_1',do_erc=True),
            Pin(num='H12',name='VCCO1',func=Pin.PWRIN,do_erc=True),
            Pin(num='J12',name='IO_L10P_1/A8',func=Pin.BIDIR,do_erc=True),
            Pin(num='K12',name='IP_L04N_1/VREF_1',do_erc=True),
            Pin(num='L12',name='VCCAUX',func=Pin.PWRIN,do_erc=True),
            Pin(num='M12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N12',name='IO_L19P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='P12',name='IO_L17N_2/D3',func=Pin.BIDIR,do_erc=True),
            Pin(num='R12',name='VCCO2',func=Pin.PWRIN,do_erc=True),
            Pin(num='T12',name='IO_L17P_2/INIT_B',func=Pin.BIDIR,do_erc=True),
            Pin(num='A13',name='IO_L04N_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B13',name='VCCO0',func=Pin.PWRIN,do_erc=True),
            Pin(num='C13',name='IO_L01N_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='D13',name='IO_L01P_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='E13',name='IO_L23P_1/A22',func=Pin.BIDIR,do_erc=True),
            Pin(num='F13',name='IO_L20N_1/A19',func=Pin.BIDIR,do_erc=True),
            Pin(num='G13',name='IO_L19P_1/A16',func=Pin.BIDIR,do_erc=True),
            Pin(num='H13',name='IO_L17P_1/A12',func=Pin.BIDIR,do_erc=True),
            Pin(num='J13',name='IO_L10N_1/A9',func=Pin.BIDIR,do_erc=True),
            Pin(num='K13',name='IO_L06N_1/A3',func=Pin.BIDIR,do_erc=True),
            Pin(num='L13',name='IO_L06P_1/A2',func=Pin.BIDIR,do_erc=True),
            Pin(num='M13',name='IO_L05P_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='N13',name='IO_L01P_1/HDC',func=Pin.BIDIR,do_erc=True),
            Pin(num='P13',name='IO_L19N_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='R13',name='IO_L18N_2/D1',func=Pin.BIDIR,do_erc=True),
            Pin(num='T13',name='IO_L18P_2/D2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A14',name='IO_L04P_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B14',name='IO_L02N_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='D14',name='IO_L23N_1/A23',func=Pin.BIDIR,do_erc=True),
            Pin(num='E14',name='IO_L20P_1/A18',func=Pin.BIDIR,do_erc=True),
            Pin(num='F14',name='IO_L19N_1/A17',func=Pin.BIDIR,do_erc=True),
            Pin(num='G14',name='IO_L17N_1/A13',func=Pin.BIDIR,do_erc=True),
            Pin(num='H14',name='IO_L14N_1/RHCLK5',func=Pin.BIDIR,do_erc=True),
            Pin(num='J14',name='IO_L14P_1/RHCLK4',func=Pin.BIDIR,do_erc=True),
            Pin(num='K14',name='IO_L11N_1/RHCLK1',func=Pin.BIDIR,do_erc=True),
            Pin(num='L14',name='IO_L08P_1/A6',func=Pin.BIDIR,do_erc=True),
            Pin(num='M14',name='IO_L05N_1/VREF_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='N14',name='IO_L01N_1/LDC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='P14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R14',name='IO_L20N_2/CCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='T14',name='IO_L20P_2/D0/DIN/MISO',func=Pin.BIDIR,do_erc=True),
            Pin(num='A15',name='TCK',do_erc=True),
            Pin(num='B15',name='IO_L02P_0/VREF_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C15',name='IO_L24N_1/A25',func=Pin.BIDIR,do_erc=True),
            Pin(num='D15',name='IO_L22N_1/A21',func=Pin.BIDIR,do_erc=True),
            Pin(num='E15',name='VCCO1',func=Pin.PWRIN,do_erc=True),
            Pin(num='F15',name='IO_L18N_1/A15',func=Pin.BIDIR,do_erc=True),
            Pin(num='G15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H15',name='IO_L15P_1/IRDY1/RHCLK6',func=Pin.BIDIR,do_erc=True),
            Pin(num='J15',name='VCCO1',func=Pin.PWRIN,do_erc=True),
            Pin(num='K15',name='IO_L11P_1/RHCLK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='L15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='M15',name='IO_L07P_1/A4',func=Pin.BIDIR,do_erc=True),
            Pin(num='N15',name='VCCO1',func=Pin.PWRIN,do_erc=True),
            Pin(num='P15',name='IO_L02N_1/LDC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='R15',name='IO_L02P_1/LDC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='T15',name='DONE',func=Pin.BIDIR,do_erc=True),
            Pin(num='A16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B16',name='TDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='C16',name='IO_L24P_1/A24',func=Pin.BIDIR,do_erc=True),
            Pin(num='D16',name='IO_L22P_1/A20',func=Pin.BIDIR,do_erc=True),
            Pin(num='E16',name='IO_L18P_1/A14',func=Pin.BIDIR,do_erc=True),
            Pin(num='F16',name='IO_L16N_1/A11',func=Pin.BIDIR,do_erc=True),
            Pin(num='G16',name='IO_L16P_1/A10',func=Pin.BIDIR,do_erc=True),
            Pin(num='H16',name='IO_L15N_1/RHCLK7',func=Pin.BIDIR,do_erc=True),
            Pin(num='J16',name='IO_L12N_1/TRDY1/RHCLK3',func=Pin.BIDIR,do_erc=True),
            Pin(num='K16',name='IO_L12P_1/RHCLK2',func=Pin.BIDIR,do_erc=True),
            Pin(num='L16',name='IO_L08N_1/A7',func=Pin.BIDIR,do_erc=True),
            Pin(num='M16',name='IO_L07N_1/A5',func=Pin.BIDIR,do_erc=True),
            Pin(num='N16',name='IO_L03N_1/A1',func=Pin.BIDIR,do_erc=True),
            Pin(num='P16',name='IO_L03P_1/A0',func=Pin.BIDIR,do_erc=True),
            Pin(num='R16',name='SUSPEND',do_erc=True),
            Pin(num='T16',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='XC3S400-FG320',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='XC3S400-PQ208',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='XC3S50-VQ100',dest=TEMPLATE,tool=SKIDL,keywords='FPGA',description='spartan 2',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='IO-VRN',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='IO-VRP',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VCCO_7',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VCCAUX(2.5V)',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='IO/D7',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='IO/DOUT/BUSY',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='VCCO_2',func=Pin.PWRIN,do_erc=True),
            Pin(num='80',name='IO-VRP',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='IO/GCK7',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='VCCO_5',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='51',name='DONE',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='61',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='IO/VREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='IO/VREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='IO-VRN',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='IO/D6',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='IO/INIT',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='CCLK',do_erc=True),
            Pin(num='62',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='92',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='IO-VREF',do_erc=True),
            Pin(num='23',name='IO-VRP',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='VCCAUX(2.5V)',func=Pin.PWRIN,do_erc=True),
            Pin(num='43',name='IO/D3',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='IO-VRN',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='IO/VREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='83',name='VCCO_1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='93',name='VCCINT(1.2V)',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='M1',do_erc=True),
            Pin(num='34',name='IO/D5',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='IO/D2',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='IO-VRP',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='IO/VREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='IO-VRN',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='VCCAUX(2.5V)',func=Pin.PWRIN,do_erc=True),
            Pin(num='94',name='VCCO_0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='M0',do_erc=True),
            Pin(num='35',name='IO/D4',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='VCCINT(1.2V)',func=Pin.PWRIN,do_erc=True),
            Pin(num='55',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='IO-VRP',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='IO/VREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='M2',do_erc=True),
            Pin(num='36',name='IO/GCK2',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='VCCO_4',func=Pin.PWRIN,do_erc=True),
            Pin(num='66',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='76',name='TDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='86',name='IO/VREF',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='IO-VRN',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='IO/CS',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='IO/GCK3',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='IO/D1',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='VCCO_3',func=Pin.PWRIN,do_erc=True),
            Pin(num='67',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='TCK',do_erc=True),
            Pin(num='87',name='IO/GCLK4',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='IO-VRP',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='VCCINT(1.2V)',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='IO/RDWR',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='IO/GCK0',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='IO/D0/DIN',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='VCCAUX(2.5V)',func=Pin.PWRIN,do_erc=True),
            Pin(num='68',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='TMS',do_erc=True),
            Pin(num='88',name='IO/GCLK5',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='HSWAP_EN',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VCCO_6',func=Pin.PWRIN,do_erc=True),
            Pin(num='29',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='IO/GCK1',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='IO',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='VCCINT(1.2V)',func=Pin.PWRIN,do_erc=True),
            Pin(num='79',name='IO-VRN',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='IO/GCK6',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='PROG',do_erc=True),
            Pin(num='100',name='TDI',do_erc=True)]),
        Part(name='XC3S50AN/TQG144',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='XC4003-PC84',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['XC4005-PC84']),
        Part(name='XC4003-VQ100',dest=TEMPLATE,tool=SKIDL,ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='PGCK1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='P/A17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='P/TDI',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='P/TCK',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='P/A3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='P7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='P8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='P/A15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='P/A4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='P20',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='P/LDC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='P40',func=Pin.PASSIVE,do_erc=True),
            Pin(num='50',name='DONE',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='60',name='P60',func=Pin.PASSIVE,do_erc=True),
            Pin(num='70',name='P70',func=Pin.PASSIVE,do_erc=True),
            Pin(num='80',name='P80',func=Pin.PASSIVE,do_erc=True),
            Pin(num='90',name='P90',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='SGCK2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='P31',func=Pin.PASSIVE,do_erc=True),
            Pin(num='41',name='P41',func=Pin.PASSIVE,do_erc=True),
            Pin(num='51',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='P61',func=Pin.PASSIVE,do_erc=True),
            Pin(num='71',name='P71/RDY',func=Pin.PASSIVE,do_erc=True),
            Pin(num='81',name='P81',func=Pin.PASSIVE,do_erc=True),
            Pin(num='91',name='P91',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='M1/RD',do_erc=True),
            Pin(num='32',name='P32',func=Pin.PASSIVE,do_erc=True),
            Pin(num='42',name='P42',func=Pin.PASSIVE,do_erc=True),
            Pin(num='52',name='PROG',do_erc=True),
            Pin(num='62',name='P62',func=Pin.PASSIVE,do_erc=True),
            Pin(num='72',name='DIN',func=Pin.PASSIVE,do_erc=True),
            Pin(num='82',name='P82',func=Pin.PASSIVE,do_erc=True),
            Pin(num='92',name='P92',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='P13',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='P33',func=Pin.PASSIVE,do_erc=True),
            Pin(num='43',name='P43',func=Pin.PASSIVE,do_erc=True),
            Pin(num='53',name='P53',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='73',name='DOUT/SGCK4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='83',name='P83',func=Pin.PASSIVE,do_erc=True),
            Pin(num='93',name='P93',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='P14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='M0/RT',do_erc=True),
            Pin(num='34',name='P34',func=Pin.PASSIVE,do_erc=True),
            Pin(num='44',name='P44',func=Pin.PASSIVE,do_erc=True),
            Pin(num='54',name='PGCK3',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='CCLK',do_erc=True),
            Pin(num='84',name='P84',func=Pin.PASSIVE,do_erc=True),
            Pin(num='94',name='P94',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='P15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='35',name='P35',func=Pin.PASSIVE,do_erc=True),
            Pin(num='45',name='P45',func=Pin.PASSIVE,do_erc=True),
            Pin(num='55',name='P55',func=Pin.PASSIVE,do_erc=True),
            Pin(num='65',name='P65',func=Pin.PASSIVE,do_erc=True),
            Pin(num='75',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='85',name='P85',func=Pin.PASSIVE,do_erc=True),
            Pin(num='95',name='P91',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='P16',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='M2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='P36/INIT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='46',name='P46',func=Pin.PASSIVE,do_erc=True),
            Pin(num='56',name='P56',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='P66',func=Pin.PASSIVE,do_erc=True),
            Pin(num='76',name='TDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='86',name='P86',func=Pin.PASSIVE,do_erc=True),
            Pin(num='96',name='P96',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='P17',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='PGCK2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='P47',func=Pin.PASSIVE,do_erc=True),
            Pin(num='57',name='P57',func=Pin.PASSIVE,do_erc=True),
            Pin(num='67',name='P67',func=Pin.PASSIVE,do_erc=True),
            Pin(num='77',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='87',name='P87',func=Pin.PASSIVE,do_erc=True),
            Pin(num='97',name='P97',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='P18',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='P/HDC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='SGCK3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='58',name='P58',func=Pin.PASSIVE,do_erc=True),
            Pin(num='68',name='P68',func=Pin.PASSIVE,do_erc=True),
            Pin(num='78',name='P78',func=Pin.PASSIVE,do_erc=True),
            Pin(num='88',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='98',name='P98',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P19',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='P29',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='P39',func=Pin.PASSIVE,do_erc=True),
            Pin(num='49',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='59',name='P59',func=Pin.PASSIVE,do_erc=True),
            Pin(num='69',name='P69',func=Pin.PASSIVE,do_erc=True),
            Pin(num='79',name='PGCK4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='89',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='SGCK1',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='XC4004-PQ160',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='XC4005-PG156',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='XC4005-PQ100',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='XC4005-PQ160',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='XC6SLX25T-BG484',dest=TEMPLATE,tool=SKIDL,description='SPARTAN-6 FG484',ref_prefix='U',num_units=3,do_erc=True,pins=[
            Pin(num='A2',name='IO_L3N_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B2',name='IO_L3P_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='A3',name='IO_L5N_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B3',name='IO_L5P_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C3',name='IO_L1P_HSWAPEN_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='D3',name='IO_L1N_VREF_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='A4',name='IO_L6N_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B4',name='VCCO_0',func=Pin.PWRIN,do_erc=True),
            Pin(num='C4',name='IO_L6P_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='D4',name='IO_L2P_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='A5',name='IO_L8N_VREF_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C5',name='IO_L8P_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='D5',name='IO_L2N_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='E5',name='IO_L4P_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='A6',name='MGTTXN0_101',func=Pin.OUTPUT,do_erc=True),
            Pin(num='B6',name='MGTTXP0_101',func=Pin.OUTPUT,do_erc=True),
            Pin(num='E6',name='IO_L4N_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F6',name='VCCO_0',func=Pin.PWRIN,do_erc=True),
            Pin(num='A7',name='MGTAVTTTX_101',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C7',name='MGTRXN0_101',do_erc=True),
            Pin(num='D7',name='MGTRXP0_101',do_erc=True),
            Pin(num='F7',name='IO_L7P_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='A8',name='MGTTXN1_101',func=Pin.OUTPUT,do_erc=True),
            Pin(num='B8',name='MGTTXP1_101',func=Pin.OUTPUT,do_erc=True),
            Pin(num='D8',name='MGTAVTTRX_101',func=Pin.PASSIVE,do_erc=True),
            Pin(num='E8',name='MGTAVTTRCAL_101',func=Pin.PASSIVE,do_erc=True),
            Pin(num='F8',name='IO_L7N_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G8',name='IO_L32P_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B9',name='MGTAVCCPLL0_101',func=Pin.PASSIVE,do_erc=True),
            Pin(num='C9',name='MGTRXN1_101',do_erc=True),
            Pin(num='D9',name='MGTRXP1_101',do_erc=True),
            Pin(num='E9',name='MGTRREF_101',do_erc=True),
            Pin(num='F9',name='IO_L32N_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G9',name='IO_L34P_GCLK19_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='A10',name='MGTREFCLK0P_101',do_erc=True),
            Pin(num='B10',name='MGTREFCLK0N_101',do_erc=True),
            Pin(num='C10',name='MGTAVCC_101',func=Pin.PASSIVE,do_erc=True),
            Pin(num='F10',name='IO_L34N_GCLK18_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G10',name='VCCO_0',func=Pin.PWRIN,do_erc=True),
            Pin(num='H10',name='IO_L33P_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='A20',name='IO_L65N_SCP2_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B20',name='IO_L65P_SCP3_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C20',name='IO_L20P_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='D20',name='TMS',do_erc=True),
            Pin(num='E20',name='IO_L32P_A17_M1A8_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='F20',name='IO_L29N_A22_M1A14_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G20',name='IO_L35P_A11_M1A7_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='H20',name='IO_L33N_A14_M1A4_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J20',name='IO_L39P_M1A3_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='K20',name='IO_L38P_A5_M1CLK_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='L20',name='IO_L43P_GCLK5_M1DQ4_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='M20',name='IO_L40P_GCLK11_M1A5_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='N20',name='IO_L45P_A1_M1LDQS_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='P20',name='IO_L42P_GCLK7_M1UDM_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='R20',name='IO_L47P_FWE_B_M1DQ0_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='T20',name='IO_L59N_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='U20',name='IO_L49P_M1DQ10_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='V20',name='IO_L74N_DOUT_BUSY_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='W20',name='IO_L51P_M1DQ12_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='C11',name='MGTREFCLK1P_101',do_erc=True),
            Pin(num='D11',name='MGTREFCLK1N_101',do_erc=True),
            Pin(num='G11',name='IO_L35N_GCLK16_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='H11',name='IO_L33N_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='A21',name='TCK',do_erc=True),
            Pin(num='C21',name='VCCO_1',func=Pin.PWRIN,do_erc=True),
            Pin(num='F21',name='IO_L31P_A19_M1CKE_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G21',name='VCCO_1',func=Pin.PWRIN,do_erc=True),
            Pin(num='H21',name='IO_L37P_A7_M1A0_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='K21',name='IO_L41P_GCLK9_IRDY1_M1RASN_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='L21',name='VCCO_1',func=Pin.PWRIN,do_erc=True),
            Pin(num='M21',name='IO_L44P_A3_M1DQ6_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='P21',name='IO_L46P_FCS_B_M1DQ2_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='R21',name='VCCO_1',func=Pin.PWRIN,do_erc=True),
            Pin(num='T21',name='IO_L48P_HDC_M1DQ8_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='V21',name='IO_L50P_M1UDQS_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='W21',name='VCCO_1',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y21',name='IO_L52P_M1DQ14_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='D12',name='MGTAVCCPLL1_101',func=Pin.PASSIVE,do_erc=True),
            Pin(num='H12',name='IO_L35P_GCLK17_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C22',name='IO_L20N_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='E22',name='IO_L32N_A16_M1A9_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='F22',name='IO_L31N_A18_M1A12_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G22',name='IO_L35N_A10_M1A2_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='H22',name='IO_L37N_A6_M1A1_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J22',name='IO_L39N_M1ODT_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='K22',name='IO_L41N_GCLK8_M1CASN_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='L22',name='IO_L43N_CLK4_M1DQ5_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='M22',name='IO_L44N_A2_M1DQ7_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='N22',name='IO_L45N_A0_M1LDQSN_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='P22',name='IO_L46N_FOE_B_M1DQ3_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='R22',name='IO_L47N_LDC_M1DQ1_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='T22',name='IO_L48N_M1DQ9_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='U22',name='IO_L49N_M1DQ11_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='V22',name='IO_L50N_M1UDQSN_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='W22',name='IO_L51N_M1DQ13_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='Y22',name='IO_L52N_M1DQ15_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G13',name='IO_L38N_VREF_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='H13',name='IO_L38P_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F14',name='IO_L36P_GCLK15_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G14',name='VCCO_0',func=Pin.PWRIN,do_erc=True),
            Pin(num='H14',name='IO_L49P_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F15',name='IO_L36N_GCLK14_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G15',name='IO_L49N_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='E16',name='IO_L37P_GCLK13_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='F16',name='IO_L37N_GCLK12_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G16',name='IO_L51P_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='J16',name='IO_L19P_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='L16',name='VCCO_1',func=Pin.PWRIN,do_erc=True),
            Pin(num='N16',name='IO_L60P_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='P16',name='IO_L60N_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A17',name='IO_L50N_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C17',name='IO_L50P_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='D17',name='IO_L66P_SCP1_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='E17',name='VCCO_0',func=Pin.PWRIN,do_erc=True),
            Pin(num='F17',name='IO_L51N_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='G17',name='TDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='J17',name='IO_L19N_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='K17',name='IO_L36P_A9_M1BA0_1',do_erc=True),
            Pin(num='L17',name='IO_L36N_A8_M1BA1_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='M17',name='IO_L61P_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='A18',name='IO_L63N_SCP6_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B18',name='IO_L63P_SCP7_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='C18',name='IO_L66N_SCP0_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='D18',name='IO_L62P_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='E18',name='TDI',do_erc=True),
            Pin(num='F18',name='IO_L1P_A25_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='H18',name='IO_L30P_A21_M1RESET_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J18',name='VCCO_1',func=Pin.PWRIN,do_erc=True),
            Pin(num='K18',name='IO_L34N_A12_M1BA2_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='M18',name='IO_L61N_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='N18',name='VCCO_1',func=Pin.PWRIN,do_erc=True),
            Pin(num='U18',name='VCCO_1',func=Pin.PWRIN,do_erc=True),
            Pin(num='A19',name='IO_L46N_SCP4_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='B19',name='VCCO_0',func=Pin.PWRIN,do_erc=True),
            Pin(num='C19',name='IO_L64P_SCP5_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='D19',name='IO_L62N_VREF_0',func=Pin.BIDIR,do_erc=True),
            Pin(num='E19',name='VCCO_1',func=Pin.PWRIN,do_erc=True),
            Pin(num='F19',name='IO_L1N_A24_VREF_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='G19',name='IO_L29P_A23_M1A13_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='H19',name='IO_L30N_A20_M1A11_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='J19',name='IO_L33P_A15_M1A10_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='K19',name='IO_L34P_A13_M1WE_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='L19',name='IO_L38N_A4_M1CLKN_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='M19',name='IO_L40N_GCLK10_M1A6_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='N19',name='IO_L42N_GCLK6_TRDY1_M1LDM_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='P19',name='IO_L53P_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='R19',name='IO_L53N_VREF_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='U19',name='IO_L59P_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='V19',name='IO_L74P_AWAKE_1',func=Pin.BIDIR,do_erc=True),
            Pin(num='B1',name='IO_L83N_VREF_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='C1',name='IO_L83P_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='D1',name='IO_L59N_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='E1',name='IO_L54N_M3A11_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='F1',name='IO_L53N_M3A12_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G1',name='IO_L52N_M3A9_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H1',name='IO_L50N_M3BA2_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='J1',name='IO_L48N_M3BA1_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='K1',name='IO_L47N_M3A1_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='L1',name='IO_L41N_GCLK26_M3DQ5_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M1',name='IO_L40N_M3DQ7_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='N1',name='IO_L39N_M3LDQSN_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='P1',name='IO_L38N_M3DQ3_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='R1',name='IO_L37N_M3DQ1_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='T1',name='IO_L36N_M3DQ9_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='U1',name='IO_L35N_M3DQ11_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='V1',name='IO_L34N_M3UDQSN_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='W1',name='IO_L33N_M3DQ13_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='Y1',name='IO_L32N_M3DQ15_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='C2',name='VCCO_3',func=Pin.PWRIN,do_erc=True),
            Pin(num='D2',name='IO_L59P_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='F2',name='IO_L53P_M3CKE_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G2',name='VCCO_3',func=Pin.PWRIN,do_erc=True),
            Pin(num='H2',name='IO_L50P_M3WE_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='K2',name='IO_L47P_M3A0_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='L2',name='VCCO_3',func=Pin.PWRIN,do_erc=True),
            Pin(num='M2',name='IO_L40P_M3DQ6_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='P2',name='IO_L38P_M3DQ2_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='R2',name='VCCO_3',func=Pin.PWRIN,do_erc=True),
            Pin(num='T2',name='IO_L36P_M3DQ8_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='V2',name='IO_L34P_M3UDQS_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='W2',name='VCCO_3',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y2',name='IO_L32P_M3DQ14_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='E3',name='IO_L54P_M3RESET_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='F3',name='IO_L60P_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='G3',name='IO_L52P_M3A8_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='H3',name='IO_L51N_M3A4_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='J3',name='IO_L48P_M3BA0_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='K3',name='IO_L46N_M3CLKN_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='L3',name='IO_L41P_GCLK27_M3DQ4_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M3',name='IO_L44P_GCLK21_M3A5_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='N3',name='IO_L39P_M3LDQS_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='P3',name='IO_L42P_GCLK25_TRDY2_M3UDM_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='R3',name='IO_L37P_M3DQ0_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='U3',name='IO_L35P_M3DQ10_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='W3',name='IO_L33P_M3DQ12_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='Y3',name='IO_L2N_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='E4',name='IO_L60N_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='F4',name='VCCO_3',func=Pin.PWRIN,do_erc=True),
            Pin(num='J4',name='IO_L51P_M3A10_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='K4',name='IO_L46P_M3CLK_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='L4',name='IO_L44N_GCLK207_M3A6_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M4',name='IO_L43N_GCLK22_TRDY2_M3CASN_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='N4',name='IO_L42N_GCLK24_M3LDM_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='P4',name='IO_L9N_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='W4',name='IO_L2P_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='Y4',name='IO_L65P_INIT_B_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='H5',name='IO_L55N_M3A14_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='J5',name='VCCO_3',func=Pin.PWRIN,do_erc=True),
            Pin(num='K5',name='IO_L49N_M3A2_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M5',name='IO_L43P_GCLK23_M3RASN_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='N5',name='VCCO_3',func=Pin.PWRIN,do_erc=True),
            Pin(num='P5',name='IO_L9P_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='U5',name='VCCO_3',func=Pin.PWRIN,do_erc=True),
            Pin(num='W5',name='VCCO_2',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y5',name='IO_L62P_D5_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='J6',name='IO_L55P_M3A13_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='K6',name='IO_L49P_M3A7_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='L6',name='IO_L45N_M3ODT_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='M6',name='IO_L45P_M3A3_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='U6',name='IO_L64N_D9_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='W6',name='IO_L60P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='Y6',name='IO_L60N_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='L7',name='VCCO_3',func=Pin.PWRIN,do_erc=True),
            Pin(num='M7',name='IO_L31P_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='R7',name='IO_L1P_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='T7',name='IO_L64P_D8_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='V7',name='IO_L58P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='Y7',name='IO_L47P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='M8',name='IO_L31N_VREF_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='P8',name='IO_L1N_VREF_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='R8',name='IO_L59N_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='T8',name='IO_L57P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='U8',name='IO_L57N_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='V8',name='VCCO_2',func=Pin.PWRIN,do_erc=True),
            Pin(num='W8',name='IO_L58N_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='Y8',name='IO_L48N_RDWR_B_VREF_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='R9',name='IO_L59P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='T9',name='VCCO_2',func=Pin.PWRIN,do_erc=True),
            Pin(num='U9',name='IO_L50P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='V9',name='IO_L50N_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='W9',name='IO_L48P_D7_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='Y9',name='IO_L43P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='T10',name='IO_L46P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='U10',name='IO_L46N_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='W10',name='IO_L44P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='Y10',name='IO_L44N_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='Y20',name='IO_L1P_CCLK_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='V11',name='IO_L42P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='W11',name='IO_L42N_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='Y11',name='IO_L32P_GCLK29_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA1',name='IO_L10N_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='T12',name='IO_L29P_GCLK3_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='U12',name='IO_L29N_GCLK2_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='V12',name='VCCO_2',func=Pin.PWRIN,do_erc=True),
            Pin(num='W12',name='IO_L40P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='Y12',name='IO_L40N_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA2',name='IO_L10P_3',func=Pin.BIDIR,do_erc=True),
            Pin(num='AB2',name='PROGRAM_B_2',do_erc=True),
            Pin(num='R13',name='IO_L12P_D1_MISO2_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='T13',name='VCCO_2',func=Pin.PWRIN,do_erc=True),
            Pin(num='U13',name='IO_L16N_VREF_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='V13',name='IO_L18P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='W13',name='IO_L18N_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='Y13',name='IO_L30P_GCLK1_D13_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA3',name='IO_L65N_CSO_B_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AB3',name='VCCO_2',func=Pin.PWRIN,do_erc=True),
            Pin(num='T14',name='IO_L12N_D2_MISO3_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='U14',name='IO_L16P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='W14',name='IO_L20P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='Y14',name='IO_L20N_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA4',name='IO_L63P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AB4',name='IO_L63N_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='W15',name='IO_L17N_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='Y15',name='IO_L21P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AB5',name='IO_L62N_D6_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='V16',name='VCCO_2',func=Pin.PWRIN,do_erc=True),
            Pin(num='Y16',name='IO_L17P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA6',name='IO_L49P_D3_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AB6',name='IO_L49N_D4_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='V17',name='IO_L2P_CMPCLK_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='W17',name='IO_L5P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='Y17',name='IO_L15P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA7',name='VCCO_2',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB7',name='IO_L47N_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='V18',name='CMPCS_B_2',do_erc=True),
            Pin(num='W18',name='IO_L2N_CMPMOSI_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='Y18',name='IO_L5N_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA8',name='IO_L45P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AB8',name='IO_L45N_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='Y19',name='IO_L13P_M1_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AB9',name='IO_L43N_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA10',name='IO_L41P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AB10',name='IO_L41N_VREF_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA20',name='IO_L3P_D0_DIN_MISO_MISO1_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AB20',name='IO_L3N_MOSI_CSI_B_MISO0_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA11',name='VCCO_2',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB11',name='IO_L32N_GCLK28_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA21',name='IO_L1N_M0_CMPMISO_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AB21',name='DONE_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA12',name='IO_L31P_GCLK31_D14_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AB12',name='IO_L31N_GCLK30_D15_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA22',name='SUSPEND',do_erc=True),
            Pin(num='AB13',name='IO_L30N_GCLK0_USERCCLK_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA14',name='IO_L6P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AB14',name='IO_L6N_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA15',name='VCCO_2',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB15',name='IO_L21N_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA16',name='IO_L19P_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AB16',name='IO_L19N_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AB17',name='IO_L15N_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA18',name='IO_L14P_D11_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AB18',name='IO_L14N_D12_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='AA19',name='VCCO_2',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB19',name='IO_L13N_D10_2',func=Pin.BIDIR,do_erc=True),
            Pin(num='A1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='E2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='U2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='V4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='L5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='C6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='D6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R6',name='VCCAUX',func=Pin.PWRIN,do_erc=True),
            Pin(num='V6',name='VCCAUX',func=Pin.PWRIN,do_erc=True),
            Pin(num='B7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='E7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='U7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='W7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='C8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J8',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='L8',name='VCCAUX',func=Pin.PWRIN,do_erc=True),
            Pin(num='N8',name='VCCAUX',func=Pin.PWRIN,do_erc=True),
            Pin(num='A9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H9',name='VCCAUX',func=Pin.PWRIN,do_erc=True),
            Pin(num='J9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='K9',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='L9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='M9',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='N9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='P9',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='D10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J10',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='K10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='L10',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='M10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N10',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='P10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R10',name='VCCAUX',func=Pin.PWRIN,do_erc=True),
            Pin(num='V10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='E11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F11',name='VCCAUX',func=Pin.PWRIN,do_erc=True),
            Pin(num='J11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='K11',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='L11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='M11',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='N11',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='P11',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='U11',name='VCCAUX',func=Pin.PWRIN,do_erc=True),
            Pin(num='E21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='U21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='C12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G12',name='VCCAUX',func=Pin.PWRIN,do_erc=True),
            Pin(num='J12',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='K12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='L12',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='M12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N12',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='P12',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R12',name='VCCAUX',func=Pin.PWRIN,do_erc=True),
            Pin(num='A22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='A13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='F13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='K13',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='L13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='M13',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='N13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='P13',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='C14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='E14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='J14',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='K14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='L14',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='M14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N14',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='P14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R14',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='V14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='E15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='H15',name='VCCAUX',func=Pin.PWRIN,do_erc=True),
            Pin(num='J15',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='K15',name='VCCAUX',func=Pin.PWRIN,do_erc=True),
            Pin(num='M15',name='VCCAUX',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='C16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='D16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='W16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='B17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='N17',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='G18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='L18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='R18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='W19',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AB22',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='AA17',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='XC7336',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='XC95108PC84',dest=TEMPLATE,tool=SKIDL,ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='P1',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='P2',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='P3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P4',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='P5',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='P6',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='P7',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='I/O/GCK1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='I/O/GCK2',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='P20',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='TCK',do_erc=True),
            Pin(num='40',name='P40',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='P50',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='70',name='P70',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='P80',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P11',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='P21',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='P31',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='P41',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='P51',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='P61',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='P71',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='P81',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='I/O/GCK3',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='P32',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='52',name='P52',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='P62',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='P72',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='P82',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P13',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='P23',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='P33',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='P43',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='P53',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='P63',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='83',name='P83',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P14',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='P24',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='P34',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='P44',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='P54',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='I/O/GSR',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='P84',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='P15',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='P25',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='P35',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='P45',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='P55',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='P65',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='P75',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='P26',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='P36',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='P46',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='P56',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='P66',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='I/O/GTS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='P17',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='37',name='P37',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='P47',func=Pin.BIDIR,do_erc=True),
            Pin(num='57',name='P57',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='P67',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='I/O/GTS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='P18',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='TDI',do_erc=True),
            Pin(num='38',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='P48',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='P58',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='P68',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='P19',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='TMS',do_erc=True),
            Pin(num='39',name='P39',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='59',name='TDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='69',name='P69',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='P79',func=Pin.BIDIR,do_erc=True)]),
        Part(name='XC95108PQ100',dest=TEMPLATE,tool=SKIDL,ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='I/O/GSR',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='P3',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P4',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='I/O/GTS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='I/O/GTS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='P8',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P9',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P10',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='P20',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='P30',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='50',name='TCK',do_erc=True),
            Pin(num='60',name='P60',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='P70',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='P80',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='P11',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='P21',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='P31',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='P41',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='P51',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='P61',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='81',name='P81',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='P91',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P12',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='P22',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='P32',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='P42',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='P52',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='P62',func=Pin.BIDIR,do_erc=True),
            Pin(num='72',name='P72',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='P82',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='P92',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P13',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='43',name='P43',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='P63',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='P73',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='P83',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='P93',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P14',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='I/O/GCK1',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='P34',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='P44',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='P54',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='74',name='P74',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='P84',func=Pin.BIDIR,do_erc=True),
            Pin(num='94',name='P94',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='P15',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='I/O/GCK2',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='P35',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='P45',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='P55',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='P65',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='P75',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='TDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='95',name='P95',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='P16',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='P26',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='P36',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='56',name='P56',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='P66',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='P76',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='96',name='P96',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='P17',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='P27',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='P37',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='TDI',do_erc=True),
            Pin(num='57',name='P57',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='P67',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='87',name='P87',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='P97',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='P18',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='P38',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='P48',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='P58',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='P68',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='P78',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='P88',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='P98',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P19',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='I/O/GCK3',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='P39',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='TMS',do_erc=True),
            Pin(num='59',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='69',name='P69',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='P79',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='P89',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='P99',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='XC95144PQ100',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='XC95144XL-TQ100',dest=TEMPLATE,tool=SKIDL,keywords='CPLD',description='CPLD, 144 macrocells, 3200 usable gates',ref_prefix='U',num_units=1,fplist=['TQFP*14x14mm*Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='I/O/GTS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='I/O/GTS4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='I/O/GTS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='I/O/GTS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='P6',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='P7',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='P8',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P9',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P10',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='P20',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='P30',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='P40',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='P50',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='P60',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='P70',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='P80',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='P90',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P11',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='P41',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='P61',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='P71',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='P81',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='P91',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P12',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='I/O/GCK1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='P32',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='P42',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='P52',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='72',name='P72',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='P82',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='P92',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P13',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='I/O/GCK2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='P33',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='P43',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='P53',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='P63',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='P73',func=Pin.BIDIR,do_erc=True),
            Pin(num='83',name='TDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='93',name='P93',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P14',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='P24',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='P34',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='54',name='P54',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='P64',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='P74',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='94',name='P94',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='P15',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='P25',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='P35',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='TDI',do_erc=True),
            Pin(num='55',name='P55',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='P65',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='85',name='P85',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='P95',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='P16',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='P36',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='P46',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='P56',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='P66',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='P76',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='P86',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='P96',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='P17',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='I/O/GCK3',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='P37',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='TMS',do_erc=True),
            Pin(num='57',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='67',name='P67',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='P77',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='P87',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='P97',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='P18',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='P28',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='TCK',do_erc=True),
            Pin(num='58',name='P58',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='P68',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='P78',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='98',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='P19',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='P29',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='P39',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='P49',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='P59',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='79',name='P79',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='P89',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='I/O/GSR',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='XC95144XL-TQ144',dest=TEMPLATE,tool=SKIDL,keywords='CPLD',description='CPLD, 144 macrocells, 3200 usable gates',ref_prefix='U',num_units=1,fplist=['TQFP*20x20mm*Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='I/O/GTS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='I/O/GTS4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='P4',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='I/O/GTS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='I/O/GTS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='P7',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='P9',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P10',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='P20',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='I/O/GCK1',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='P40',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='P50',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='P60',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='P70',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='P80',func=Pin.BIDIR,do_erc=True),
            Pin(num='90',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='P11',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='P21',func=Pin.BIDIR,do_erc=True),
            Pin(num='31',name='P31',func=Pin.BIDIR,do_erc=True),
            Pin(num='41',name='P41',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='P51',func=Pin.BIDIR,do_erc=True),
            Pin(num='61',name='P61',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='P71',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='P81',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='P91',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P12',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='P22',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='I/O/GCK2',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='52',name='P52',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='72',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='82',name='P82',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='P92',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P13',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='P23',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='P33',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='P43',func=Pin.BIDIR,do_erc=True),
            Pin(num='53',name='P53',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='TDI',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='83',name='P83',func=Pin.BIDIR,do_erc=True),
            Pin(num='93',name='P93',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P14',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='P24',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='P34',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='P44',func=Pin.BIDIR,do_erc=True),
            Pin(num='54',name='P54',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='P64',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='P74',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='94',name='P94',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='P15',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='P25',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='P35',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='P45',func=Pin.BIDIR,do_erc=True),
            Pin(num='55',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='65',name='TMS',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='P75',func=Pin.BIDIR,do_erc=True),
            Pin(num='85',name='P85',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='P95',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='P16',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='P26',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='46',name='P46',func=Pin.BIDIR,do_erc=True),
            Pin(num='56',name='P56',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='P66',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='P76',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='P86',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='P96',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='P17',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='P27',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='57',name='P57',func=Pin.BIDIR,do_erc=True),
            Pin(num='67',name='TCK',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='P77',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='P87',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='P97',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='P28',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='I/O/GCK3',func=Pin.BIDIR,do_erc=True),
            Pin(num='48',name='P48',func=Pin.BIDIR,do_erc=True),
            Pin(num='58',name='P58',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='P68',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='P78',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='P88',func=Pin.BIDIR,do_erc=True),
            Pin(num='98',name='P98',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='P19',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='P39',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='P49',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='P59',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='P69',func=Pin.BIDIR,do_erc=True),
            Pin(num='79',name='P79',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='99',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='100',name='P100',func=Pin.BIDIR,do_erc=True),
            Pin(num='110',name='P110',func=Pin.BIDIR,do_erc=True),
            Pin(num='120',name='P120',func=Pin.BIDIR,do_erc=True),
            Pin(num='130',name='P130',func=Pin.BIDIR,do_erc=True),
            Pin(num='140',name='P140',func=Pin.BIDIR,do_erc=True),
            Pin(num='101',name='P101',func=Pin.BIDIR,do_erc=True),
            Pin(num='111',name='P111',func=Pin.BIDIR,do_erc=True),
            Pin(num='121',name='P121',func=Pin.BIDIR,do_erc=True),
            Pin(num='131',name='P131',func=Pin.BIDIR,do_erc=True),
            Pin(num='141',name='VCCINT',func=Pin.PWRIN,do_erc=True),
            Pin(num='102',name='P102',func=Pin.BIDIR,do_erc=True),
            Pin(num='112',name='P112',func=Pin.BIDIR,do_erc=True),
            Pin(num='122',name='TDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='132',name='P132',func=Pin.BIDIR,do_erc=True),
            Pin(num='142',name='P142',func=Pin.BIDIR,do_erc=True),
            Pin(num='103',name='P103',func=Pin.BIDIR,do_erc=True),
            Pin(num='113',name='P113',func=Pin.BIDIR,do_erc=True),
            Pin(num='123',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='133',name='P133',func=Pin.BIDIR,do_erc=True),
            Pin(num='143',name='I/O/GSR',func=Pin.BIDIR,do_erc=True),
            Pin(num='104',name='P104',func=Pin.BIDIR,do_erc=True),
            Pin(num='114',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='124',name='P124',func=Pin.BIDIR,do_erc=True),
            Pin(num='134',name='P134',func=Pin.BIDIR,do_erc=True),
            Pin(num='144',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='105',name='P105',func=Pin.BIDIR,do_erc=True),
            Pin(num='115',name='P115',func=Pin.BIDIR,do_erc=True),
            Pin(num='125',name='P125',func=Pin.BIDIR,do_erc=True),
            Pin(num='135',name='P135',func=Pin.BIDIR,do_erc=True),
            Pin(num='106',name='P106',func=Pin.BIDIR,do_erc=True),
            Pin(num='116',name='P116',func=Pin.BIDIR,do_erc=True),
            Pin(num='126',name='P126',func=Pin.BIDIR,do_erc=True),
            Pin(num='136',name='P136',func=Pin.BIDIR,do_erc=True),
            Pin(num='107',name='P107',func=Pin.BIDIR,do_erc=True),
            Pin(num='117',name='P117',func=Pin.BIDIR,do_erc=True),
            Pin(num='127',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='137',name='P137',func=Pin.BIDIR,do_erc=True),
            Pin(num='108',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='118',name='P118',func=Pin.BIDIR,do_erc=True),
            Pin(num='128',name='P128',func=Pin.BIDIR,do_erc=True),
            Pin(num='138',name='P138',func=Pin.BIDIR,do_erc=True),
            Pin(num='109',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='119',name='P119',func=Pin.BIDIR,do_erc=True),
            Pin(num='129',name='P129',func=Pin.BIDIR,do_erc=True),
            Pin(num='139',name='P139',func=Pin.BIDIR,do_erc=True)]),
        Part(name='XC9536PC44',dest=TEMPLATE,tool=SKIDL,ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='M1',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='M1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='M2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='M4',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='I/O/GCK1',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='I/O/GCK2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='I/O/GCK3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='M6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='M8',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='M15',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='TDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='40',name='I/O/GTS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='M9',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='M10',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='M16',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='42',name='I/O/GTS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='M11',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='M12',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='M4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='M12',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='M17',func=Pin.BIDIR,do_erc=True),
            Pin(num='34',name='M11',func=Pin.BIDIR,do_erc=True),
            Pin(num='44',name='M2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='TDI',do_erc=True),
            Pin(num='25',name='M17',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='M10',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='TMS',do_erc=True),
            Pin(num='26',name='M16',func=Pin.BIDIR,do_erc=True),
            Pin(num='36',name='M9',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='TCK',do_erc=True),
            Pin(num='27',name='M15',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='M8',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='M13',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='M14',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='M7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='M14',func=Pin.BIDIR,do_erc=True),
            Pin(num='29',name='M13',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='I/O/GSR',func=Pin.BIDIR,do_erc=True)]),
        Part(name='XC9572XL-TQ100',dest=TEMPLATE,tool=SKIDL,keywords='CPLD',description='CPLD, 72 macrocells, 1600 usable gates',ref_prefix='U',num_units=1,fplist=['TQFP*14x14mm*Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='I/O/GTS3',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='I/O/GTS1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='I/O/GTS2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='P6',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='8',name='P8',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='P9',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='P10',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='P20',func=Pin.BIDIR,do_erc=True),
            Pin(num='30',name='P30',func=Pin.BIDIR,do_erc=True),
            Pin(num='40',name='P40',func=Pin.BIDIR,do_erc=True),
            Pin(num='50',name='P50',func=Pin.BIDIR,do_erc=True),
            Pin(num='60',name='P60',func=Pin.BIDIR,do_erc=True),
            Pin(num='70',name='P70',func=Pin.BIDIR,do_erc=True),
            Pin(num='80',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='90',name='P90',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P11',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='41',name='P41',func=Pin.BIDIR,do_erc=True),
            Pin(num='51',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='P61',func=Pin.BIDIR,do_erc=True),
            Pin(num='71',name='P71',func=Pin.BIDIR,do_erc=True),
            Pin(num='81',name='P81',func=Pin.BIDIR,do_erc=True),
            Pin(num='91',name='P91',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P12',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='I/O/GCK1',func=Pin.BIDIR,do_erc=True),
            Pin(num='32',name='P32',func=Pin.BIDIR,do_erc=True),
            Pin(num='42',name='P42',func=Pin.BIDIR,do_erc=True),
            Pin(num='52',name='P52',func=Pin.BIDIR,do_erc=True),
            Pin(num='62',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='72',name='P72',func=Pin.BIDIR,do_erc=True),
            Pin(num='82',name='P82',func=Pin.BIDIR,do_erc=True),
            Pin(num='92',name='P92',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P13',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='I/O/GCK2',func=Pin.BIDIR,do_erc=True),
            Pin(num='33',name='P33',func=Pin.BIDIR,do_erc=True),
            Pin(num='43',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='53',name='P53',func=Pin.BIDIR,do_erc=True),
            Pin(num='63',name='P63',func=Pin.BIDIR,do_erc=True),
            Pin(num='73',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='83',name='TDO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='93',name='P93',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P14',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='34',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='44',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='54',name='P54',func=Pin.BIDIR,do_erc=True),
            Pin(num='64',name='P64',func=Pin.BIDIR,do_erc=True),
            Pin(num='74',name='P74',func=Pin.BIDIR,do_erc=True),
            Pin(num='84',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='94',name='P94',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='P15',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='P25',func=Pin.BIDIR,do_erc=True),
            Pin(num='35',name='P35',func=Pin.BIDIR,do_erc=True),
            Pin(num='45',name='TDI',do_erc=True),
            Pin(num='55',name='P55',func=Pin.BIDIR,do_erc=True),
            Pin(num='65',name='P65',func=Pin.BIDIR,do_erc=True),
            Pin(num='75',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='85',name='P85',func=Pin.BIDIR,do_erc=True),
            Pin(num='95',name='P95',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='P16',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='P36',func=Pin.BIDIR,do_erc=True),
            Pin(num='46',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='56',name='P56',func=Pin.BIDIR,do_erc=True),
            Pin(num='66',name='P66',func=Pin.BIDIR,do_erc=True),
            Pin(num='76',name='P76',func=Pin.BIDIR,do_erc=True),
            Pin(num='86',name='P86',func=Pin.BIDIR,do_erc=True),
            Pin(num='96',name='P96',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='P17',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='I/O/GCK3',func=Pin.BIDIR,do_erc=True),
            Pin(num='37',name='P37',func=Pin.BIDIR,do_erc=True),
            Pin(num='47',name='TMS',do_erc=True),
            Pin(num='57',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='67',name='P67',func=Pin.BIDIR,do_erc=True),
            Pin(num='77',name='P77',func=Pin.BIDIR,do_erc=True),
            Pin(num='87',name='P87',func=Pin.BIDIR,do_erc=True),
            Pin(num='97',name='P97',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='P18',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='P28',func=Pin.BIDIR,do_erc=True),
            Pin(num='38',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='TCK',do_erc=True),
            Pin(num='58',name='P58',func=Pin.BIDIR,do_erc=True),
            Pin(num='68',name='P68',func=Pin.BIDIR,do_erc=True),
            Pin(num='78',name='P78',func=Pin.BIDIR,do_erc=True),
            Pin(num='88',name='VCCIO',func=Pin.PWRIN,do_erc=True),
            Pin(num='98',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='29',name='P29',func=Pin.BIDIR,do_erc=True),
            Pin(num='39',name='P39',func=Pin.BIDIR,do_erc=True),
            Pin(num='49',name='P49',func=Pin.BIDIR,do_erc=True),
            Pin(num='59',name='P59',func=Pin.BIDIR,do_erc=True),
            Pin(num='69',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='79',name='P79',func=Pin.BIDIR,do_erc=True),
            Pin(num='89',name='P89',func=Pin.BIDIR,do_erc=True),
            Pin(num='99',name='I/O/GSR',func=Pin.BIDIR,do_erc=True),
            Pin(num='100',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='XCF08P',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='XCR3064-VQ100',dest=TEMPLATE,tool=SKIDL,description='Xilinx CoolRunner',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='3',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='B8/TDI',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='B9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='B10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='B11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='B12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='D4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='D9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='C15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='60',name='C2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='80',name='A4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='90',name='CLK0/IN0',do_erc=True),
            Pin(num='11',name='PORT_EN',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='D5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='D10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='41',name='C14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='51',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='C1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='71',name='A9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='81',name='A3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='91',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='B13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='D11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='42',name='C13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='52',name='C7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='62',name='C0/TCK',func=Pin.PASSIVE,do_erc=True),
            Pin(num='82',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='92',name='B0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='B14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='D6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='D12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='43',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='63',name='A15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='73',name='A8/TDO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='83',name='A2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='93',name='B1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='B15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='C12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='54',name='C6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='64',name='A14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='74',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='84',name='A1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='94',name='B2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='D0/TMS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='D7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='D13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='45',name='C11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='65',name='A13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='75',name='A7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='85',name='A0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='95',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='D1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='D14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='46',name='C10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='56',name='C5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='66',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='76',name='A6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='86',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='96',name='B3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='D2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='D15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='47',name='C9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='57',name='C4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='67',name='A12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='87',name='CLK3/IN3',do_erc=True),
            Pin(num='97',name='B4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='C8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='58',name='C3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='68',name='A11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='88',name='CLK2/IN2',do_erc=True),
            Pin(num='98',name='B5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='D3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='D8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='59',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='69',name='A10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='79',name='A5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='89',name='CLK1/IN1',do_erc=True),
            Pin(num='99',name='B6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='100',name='B7',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='XCR3064-VQ44',dest=TEMPLATE,tool=SKIDL,description='Xilinx CoolRunner',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='TDI',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='B9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='B10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='PORT_EN',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='B13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='B14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='TMS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='D1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='D3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='C10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='A10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='CLC0/IN0',do_erc=True),
            Pin(num='11',name='D4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='C9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='A9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='41',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='D8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='C8',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='TDO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='42',name='B0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='D9',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='C3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='A7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='43',name='B1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='D10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='A1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='44',name='B2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='D11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='C1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='A0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='26',name='TCK',func=Pin.PASSIVE,do_erc=True),
            Pin(num='36',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='27',name='A14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='CLK3/IN3',do_erc=True),
            Pin(num='18',name='C12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='28',name='A13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='CLK2/IN2',do_erc=True),
            Pin(num='19',name='C11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='39',name='CLK1/IN1',do_erc=True)]),
        Part(name='XCR3128-VQ100',dest=TEMPLATE,tool=SKIDL,description='Xilinx CoolRunner',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='E1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='E0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='F1/TDI',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='F2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='F3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='F4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='8',name='F5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='F6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='F10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='20',name='H6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='30',name='G10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='40',name='D1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='50',name='D13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='60',name='C3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='70',name='A4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='80',name='B5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='90',name='CLK0/IN0',do_erc=True),
            Pin(num='11',name='PORT_EN',func=Pin.PASSIVE,do_erc=True),
            Pin(num='21',name='H10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='31',name='G6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='41',name='D2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='51',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='61',name='C2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='71',name='A3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='81',name='B6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='91',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='F13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='22',name='H11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='32',name='G5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='42',name='D3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='52',name='C14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='62',name='C1/TCK',func=Pin.PASSIVE,do_erc=True),
            Pin(num='72',name='A2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='82',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='92',name='E14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='F14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='23',name='H12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='33',name='G4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='43',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='53',name='C13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='63',name='A14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='73',name='A1/TDO',func=Pin.PASSIVE,do_erc=True),
            Pin(num='83',name='B10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='93',name='E13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='F15',func=Pin.PASSIVE,do_erc=True),
            Pin(num='24',name='H13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='34',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='44',name='D4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='54',name='C12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='64',name='A13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='74',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='84',name='B11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='94',name='E12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='H1/TMS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='25',name='H14',func=Pin.PASSIVE,do_erc=True),
            Pin(num='35',name='G3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='45',name='D5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='55',name='C11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='65',name='A12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='75',name='B0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='85',name='B12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='95',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='H2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='26',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='36',name='G2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='46',name='D6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='56',name='C10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='66',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='76',name='B1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='86',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='96',name='E6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='17',name='H3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='27',name='G13',func=Pin.PASSIVE,do_erc=True),
            Pin(num='37',name='G1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='47',name='D10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='57',name='C6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='67',name='A10',func=Pin.PASSIVE,do_erc=True),
            Pin(num='77',name='B2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='87',name='CLK3/IN3',do_erc=True),
            Pin(num='97',name='E5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='28',name='G12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='38',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='D11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='58',name='C5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='68',name='A6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='78',name='B3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='88',name='CLK2/IN2',do_erc=True),
            Pin(num='98',name='E4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='19',name='H5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='29',name='G11',func=Pin.PASSIVE,do_erc=True),
            Pin(num='39',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='49',name='D12',func=Pin.PASSIVE,do_erc=True),
            Pin(num='59',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='69',name='A5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='79',name='B4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='89',name='CLK1/IN1',do_erc=True),
            Pin(num='99',name='E3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='100',name='E2',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='XCR3256-TQ144',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='XCV150_BG352',dest=TEMPLATE,tool=SKIDL,do_erc=True)])
