"""Constants for Roku."""

VALID_REMOTE_KEYS = {
    # Standard Keys
    "home": "Home",
    "reverse": "Rev",
    "forward": "Fwd",
    "play": "Play",
    "select": "Select",
    "left": "Left",
    "right": "Right",
    "down": "Down",
    "up": "Up",
    "back": "Back",
    "replay": "InstantReplay",
    "info": "Info",
    "backspace": "Backspace",
    "search": "Search",
    "enter": "Enter",
    # For devices that support "Find Remote"
    "find_remote": "FindRemote",
    # For Roku TV
    "volume_down": "VolumeDown",
    "volume_up": "VolumeUp",
    "volume_mute": "VolumeMute",
    # For Roku TV while on TV tuner channel
    "channel_up": "ChannelUp",
    "channel_down": "ChannelDown",
    # For Roku TV current input
    "input_tuner": "InputTuner",
    "input_hdmi1": "InputHDMI1",
    "input_hdmi2": "InputHDMI2",
    "input_hdmi3": "InputHDMI3",
    "input_hdmi4": "InputHDMI4",
    "input_av1": "InputAV1",
    # For devices that support being turned on/off
    "power": "Power",
    "poweroff": "PowerOff",
    "poweron": "PowerOn",
}
