# -*- coding: utf-8 -*-
# Generated by Django 1.10.2 on 2016-12-20 08:10
from __future__ import unicode_literals

from django.db import migrations, models


UNIQUE_SLUG_MODELS = ['Continent', 'Country', 'Region', 'Subregion', 'District',
                      'City', 'PostalCode', 'AlternativeName']


class Migration(migrations.Migration):

    dependencies = [
        ('cities', '0009_add_slug_fields_to_models'),
    ]

    operations = [
        migrations.AlterField(
            model_name='country',
            name='code',
            field=models.CharField(db_index=True, max_length=2, unique=True),
        ),
        migrations.AlterField(
            model_name='country',
            name='code3',
            field=models.CharField(db_index=True, max_length=3, unique=True),
        ),
        migrations.AlterUniqueTogether(
            name='city',
            unique_together=set([('country', 'region', 'subregion', 'id', 'name')]),
        ),
        migrations.AlterUniqueTogether(
            name='district',
            unique_together=set([('city', 'name')]),
        ),
        migrations.AlterUniqueTogether(
            name='postalcode',
            unique_together=set([
                ('country', 'region_name', 'subregion_name', 'district_name', 'name', 'id', 'code'),
                ('country', 'region', 'subregion', 'city', 'district', 'name', 'id', 'code'),
            ]),
        ),
        migrations.AlterUniqueTogether(
            name='region',
            unique_together=set([('country', 'name')]),
        ),
        migrations.AlterUniqueTogether(
            name='subregion',
            unique_together=set([('region', 'id', 'name')]),
        ),
    ]

    # The previous migration created the slug field as
    #
    # CharField(max_length=255, unique=True)
    #
    # but I removed the unique=True for new users. This checks the previous
    # state of the slug field on the models, and if the field has unique=True
    # (eg: existing users), it removes the unique attribute. For slug fields
    # that don't have unique=True (eg: new users), it skips them.
    def database_forwards(self, app_label, schema_editor, from_state, to_state):
        # Before we do any database operations, add the appropriate slug field
        # modifications to the migration operations.
        self.operations + [
            migrations.AlterField(
                model_name=model_name.lower(),
                name='slug',
                field=models.CharField(max_length=255))
            for model_name in UNIQUE_SLUG_MODELS
            # This is the check that matters. It checks the result of the
            # previous 0009 migration (which may or may not have unique=True
            # set on slug fields) for the unique attribute, and skips it if
            # they don't.
            if from_state.apps.get_model(app_label, self.model_name)._meta.get_field('slug').unique
        ]

        super(Migration, self).database_forwards(app_label, schema_editor, from_state, to_state)
