from __future__ import annotations

from typing import *

Unknown = Any

def aaf2fcp(deleteFile: bool = ..., dstPath: str = ..., getFileName: int = ..., progress: int = ..., srcFile: str = ..., terminate: int = ..., waitCompletion: int = ...) -> str:
    """This command is used to convert an aff file to a Final Cut Pro (fcp) xml file
    The conversion process can take several seconds to complete and the command is meant
    to be run asynchronouslyutility, aaf, fcp
    Args:
        deleteFile (bool?): Delete temporary file. Can only be used with the terminate option
                Properties: create
        dstPath (str?): Specifiy a destination path
                Properties: create
        getFileName (int?): Query output file name
                Properties: create
        progress (int?): Request progress report
                Properties: create
        srcFile (str?): Specifiy a source file
                Properties: create
        terminate (int?): Complete the task
                Properties: create
        waitCompletion (int?): Wait for the conversion process to complete
                Properties: create

    Returns:
        str: Command result

    Example:
    """

def about(apiVersion: bool = ..., application: bool = ..., batch: bool = ..., buildDirectory: bool = ..., buildVariant: bool = ..., codeset: bool = ..., compositingManager: bool = ..., connected: bool = ..., ctime: bool = ..., currentDate: bool = ..., currentTime: bool = ..., customVersion: bool = ..., customVersionClient: bool = ..., customVersionMajor: bool = ..., customVersionMinor: bool = ..., customVersionString: bool = ..., cutIdentifier: bool = ..., date: bool = ..., environmentFile: bool = ..., evalVersion: bool = ..., file: bool = ..., fontInfo: bool = ..., helpDataDirectory: bool = ..., installedVersion: bool = ..., ioVersion: bool = ..., irix: bool = ..., is64: bool = ..., languageResources: bool = ..., linux: bool = ..., linux64: bool = ..., liveUpdate: bool = ..., localizedResourceLocation: bool = ..., ltVersion: bool = ..., macOS: bool = ..., macOSppc: bool = ..., macOSx86: bool = ..., majorVersion: bool = ..., minorVersion: bool = ..., ntOS: bool = ..., operatingSystem: bool = ..., operatingSystemVersion: bool = ..., patchVersion: bool = ..., preferences: bool = ..., product: bool = ..., qtVersion: bool = ..., tablet: bool = ..., tabletMode: bool = ..., uiLanguage: bool = ..., uiLanguageForStartup: bool = ..., uiLanguageIsLocalized: bool = ..., uiLocaleLanguage: bool = ..., version: bool = ..., win64: bool = ..., windowManager: bool = ..., windows: bool = ...) -> str:
    """This command displays version information about the application if it is
    executed without flags.  If one of the above flags is specified
    then the specified version information is returned.
    Args:
        apiVersion (bool?): Returns the api version.
                Properties: create
        application (bool?): Returns the application name string.
                Properties: create
        batch (bool?): Returns true if application is in batch mode.
                Properties: create
        buildDirectory (bool?): Returns the build directory string.
                Properties: create
        buildVariant (bool?): Returns the build variant string.
                Properties: create
        codeset (bool?): Returns a string identifying the codeset (codepage) of the
                locale that Maya is running in.
                Example return values include "UTF-8", "ISO-8859. 1", "1252".
                Note that the codeset values and naming conventions
                are highly platform dependent.  They may differ in format
                even if they have the same meaning (e.g. "utf8" vs. "UTF-8").
                Properties: create
        compositingManager (bool?): On Linux, returns true if there is a compositing manager running; on
                all other platforms, it always returns true.
                Properties: create
        connected (bool?): Return whether the user is connected or not to the Internet.
                Properties: create
        ctime (bool?): Returns the current time in the format Wed Jan 02 02. 03. 55 1980
                Properties: create
        currentDate (bool?): Returns the current date in the format yyyy/mm/dd, e.g. 2003/05/04.
                Properties: create
        currentTime (bool?): Returns the current time in the format hh:mm:ss, e.g. 14. 27. 53.
                Properties: create
        customVersion (bool?): Returns true if this is a custom version of Maya.
                Properties: create
        customVersionClient (bool?): Returns the custom client version string for Maya
                or an empty string if this is not a custom version.
                Properties: create
        customVersionMajor (bool?): Returns the custom major version of Maya
                or 0 if this is not a custom version.
                Properties: create
        customVersionMinor (bool?): Returns the custom minor version of Maya
                or 0 if this is not a custom version.
                Properties: create
        customVersionString (bool?): Returns the custom version string for Maya
                or an empty string if this is not a custom version.
                Properties: create
        cutIdentifier (bool?): Returns the cut string.
                Properties: create
        date (bool?): Returns the build date string.
                Properties: create
        environmentFile (bool?): Returns the location of the application defaults file.
                Properties: create
        evalVersion (bool?): This flag is now deprecated. Always returns false, as the eval version is no longer supported.
                Properties: create
        file (bool?): Returns the file version string.
                Properties: create
        fontInfo (bool?): Returns a string of the specifications of the
                fonts requested, and the specifications of the
                fonts that are actually being used.
                Properties: create
        helpDataDirectory (bool?): Returns the help data directory.
                Properties: create
        installedVersion (bool?): Returns the product version string.
                Properties: create
        ioVersion (bool?): Returns true if this is the Maya IO version of the application.
                Properties: create
        irix (bool?): Returns true if the operating system is Irix.
                Always false with support for Irix removed.
                Properties: create
        is64 (bool?): Returns true if the application is 64 bit.
                Properties: create
        languageResources (bool?): Returns a string array of the currently installed language resources.
                Each string entry consists of three elements delimited with a colon (':').
                The first token is the locale code (ISO 639. 1 language code followed by ISO 3166. 1 country code).  The second token is the language name in English.
                This third token is the alpha-3 code (ISO 639. 2).  For example English is
                represented as "en_US:English:enu".
                Properties: create
        linux (bool?): Returns true if the operating system is Linux.
                Properties: create
        linux64 (bool?): Returns true if the operating system is Linux 64 bit.
                Properties: create
        liveUpdate (bool?): This flag is deprecated(2019) and may be removed in future releases of Maya.
                Returns Autodesk formatted product information.
                Properties: create
        localizedResourceLocation (bool?): Returns the path to the top level of the localized resource
                directory, if we are running in an alternate language.
                Returns an empty string if we are running in the default
                language.
                Properties: create
        ltVersion (bool?): Returns true if this is the Maya LT version of the application.
                Properties: create
        macOS (bool?): Returns true if the operating system is Macintosh.
                Properties: create
        macOSppc (bool?): Returns true if the operating system is a PowerPC Macintosh.
                Properties: create
        macOSx86 (bool?): Returns true if the operating system is an Intel Macintosh.
                Properties: create
        majorVersion (bool?): Returns the major version of Maya.
                Properties: create
        minorVersion (bool?): Returns the minor version of Maya.
                Properties: create
        ntOS (bool?): Returns true if the operating system is Windows.
                Properties: create
        operatingSystem (bool?): Returns the operating system type. Valid return types are
                "nt", "win64", "mac", "linux" and "linux64"
                Properties: create
        operatingSystemVersion (bool?): Returns the operating system version.
                on Linux this returns the equivalent of uname -srvm
                Properties: create
        patchVersion (bool?): Returns the patch version of Maya.
                Properties: create
        preferences (bool?): Returns the location of the preferences directory.
                Properties: create
        product (bool?): Returns the license product name.
                Properties: create
        qtVersion (bool?): Returns Qt version string.
                Properties: create
        tablet (bool?): Windows only.  Returns true if the PC is a Tablet PC.
                Properties: create
        tabletMode (bool?): Windows 8 (and above) only.  If your device is a Tablet PC, then the convertible
                mode the device is currently running in.  Returns  either: tablet or laptop (keyboard attached).
                See the tablet flag.
                Properties: create
        uiLanguage (bool?): Returns the language that Maya's running in.  Example return
                values include "en_US" for English and "ja_JP" for Japanese.
                Properties: create
        uiLanguageForStartup (bool?): Returns the language that is used for Maya's next start up.
                This is read from config file and is rewritten after setting
                ui language in preference.
                Properties: create
        uiLanguageIsLocalized (bool?): Returns true if we are running in an alternate
                language, not the default (English).
                Properties: create
        uiLocaleLanguage (bool?): Returns the language locale of the OS. English is default.
                Properties: create
        version (bool?): Returns the version string.
                Properties: create
        win64 (bool?): Returns true if the operating system is Windows x64 based.
                Properties: create
        windowManager (bool?): Returns the name of the Window Manager that is
                assumed to be running.
                Properties: create
        windows (bool?): Returns true if the operating system is Windows based.
                Properties: create

    Returns:
        str: The application's version information.

    Example:
    """

def addAttr(*args: str, attributeType: str = ..., binaryTag: str = ..., cachedInternally: bool = ..., category: str = ..., dataType: str = ..., defaultValue: float = ..., disconnectBehaviour: Unknown = ..., enumName: str = ..., exists: bool = ..., fromPlugin: bool = ..., hasMaxValue: bool = ..., hasMinValue: bool = ..., hasSoftMaxValue: bool = ..., hasSoftMinValue: bool = ..., hidden: bool = ..., indexMatters: bool = ..., internalSet: bool = ..., keyable: bool = ..., longName: str = ..., maxValue: float = ..., minValue: float = ..., multi: bool = ..., niceName: str = ..., numberOfChildren: Unknown = ..., parent: str = ..., proxy: str = ..., readable: bool = ..., shortName: str = ..., softMaxValue: float = ..., softMinValue: float = ..., storable: bool = ..., usedAsColor: bool = ..., usedAsFilename: bool = ..., usedAsProxy: bool = ..., worldSpace: bool = ..., writable: bool = ...) -> bool:
    """This command is used to add a dynamic attribute to a node or nodes.
    Either the longName or the shortName or both must be specified.
    If neither a dataType nor an attributeType is specified, a double
    attribute will be added.  The dataType flag can be specified more than
    once indicating that any of the supplied types will be accepted (logical-or).To add a non-double attribute the following criteria
    can be used to determine whether the dataType or the attributeType
    flag is appropriate.  Some types, such ascan use either.
    In these cases theflag should be used when you only wish to
    access the data as an atomic entity (eg. you never want to access the
    three individual values that make up a).  In general it
    is best to use thein these cases for maximum flexibility.
    In most cases theversion will not display in the attribute
    editor as it is an atomic type and you are not allowed to change
    individual parts of it.All attributes flagged as "(compound)" below or the compound attribute itself
    are not actually added to the node until all of the children are defined
    (using the "-p" flag to set their parent to the compound being created).  See
    the EXAMPLES section for more details.attribute, dependency, graph, add, dynamic, create
    Args:
        attributeType (str?): Specifies the attribute type, see above table for more details.
                Note that the attribute types "float", "matrix" and "string"
                are also MEL keywords and must be enclosed in quotes.
                Properties: create, query
        binaryTag (str?): This flag is obsolete and does not do anything any more
                Properties: create, query
        cachedInternally (bool?): Whether or not attribute data is cached internally in the node.
                This flag defaults to true for writable attributes and false
                for non-writable attributes. A warning will be issued if
                users attempt to force a writable attribute to be uncached as
                this will make it impossible to set keyframes.
                Properties: create, query
        category (str?): An attribute category is a string associated with the attribute to identify it.
                (e.g. the name of a plugin that created the attribute, version information, etc.)
                Any attribute can be associated with an arbitrary number of categories however
                categories can not be removed once associated.
                Properties: create, query, edit, multiuse
        dataType (str?): Specifies the data type.  See "setAttr" for
                more information on data type names.
                Properties: create, query, multiuse
        defaultValue (float?): Specifies the default value for the attribute
                (can only be used for numeric attributes).
                Properties: create, query, edit
        disconnectBehaviour (Unknown?): defines the Disconnect Behaviour 2 Nothing, 1 Reset, 0 Delete
                Properties: create, query
        enumName (str?): Flag used to specify the ui names corresponding to the enum values. The specified string should contain a colon-separated list of the names, with optional values. If values are not specified, they will treated as sequential integers starting with 0. For example: -enumName "A:B:C" would produce options: A,B,C with values of 0,1,2; -enumName "zero:one:two:thousand=1000" would produce four options with values 0,1,2,1000; and -enumName "solo=1. triplet=3. quintet=5" would produce three options with values 1,3,5.  (Note that there is a current limitation of the Channel Box that will sometimes incorrectly display an enumerated attribute's pull-down menu.  Extra menu items can appear that represent the numbers inbetween non-sequential option values.  To avoid this limitation, specify sequential values for the options of any enumerated attributes that will appear in the Channel Box.  For example: "solo=1. triplet=2. quintet=3".)
                Properties: create, query, edit
        exists (bool?): Returns true if the attribute queried is a user-added, dynamic attribute; false if not.
                Properties: create, query
        fromPlugin (bool?): Was the attribute originally created by a plugin? Normally set
                automatically when the API call is made - only added here to support
                storing it in a file independently from the creating plugin.
                Properties: create, query
        hasMaxValue (bool?): Flag indicating whether an attribute has a maximum value.
                (can only be used for numeric attributes).
                Properties: create, query, edit
        hasMinValue (bool?): Flag indicating whether an attribute has a minimum value.
                (can only be used for numeric attributes).
                Properties: create, query, edit
        hasSoftMaxValue (bool?): Flag indicating whether a numeric attribute has a soft maximum.
                Properties: create, query
        hasSoftMinValue (bool?): Flag indicating whether a numeric attribute has a soft minimum.
                Properties: create, query
        hidden (bool?): Will this attribute be hidden from the UI?
                Properties: create, query
        indexMatters (bool?): Sets whether an index must be used when connecting
                to this multi-attribute. Setting indexMatters to false forces the
                attribute to non-readable.
                Properties: create, query
        internalSet (bool?): Whether or not the internal cached value is set when
                this attribute value is changed.  This is an internal flag
                used for updating UI elements.
                Properties: create, query
        keyable (bool?): Is the attribute keyable by default?
                Properties: create, query
        longName (str?): Sets the long name of the attribute.
                Properties: create, query
        maxValue (float?): Specifies the maximum value for the attribute
                (can only be used for numeric attributes).
                Properties: create, query, edit
        minValue (float?): Specifies the minimum value for the attribute
                (can only be used for numeric attributes).
                Properties: create, query, edit
        multi (bool?): Makes the new attribute a multi-attribute.
                Properties: create, query
        niceName (str?): Sets the nice name of the attribute for display in the UI.  Setting the
                attribute's nice name to a non-empty string overrides the default
                behaviour of looking up the nice name from Maya's
                string catalog.   (Use the MEL commands
                "attributeNiceName" and "attributeQuery -niceName" to lookup an attribute's
                nice name in the catalog.)
                Properties: create, query, edit
        numberOfChildren (Unknown?): How many children will the new attribute have?
                Properties: create, query
        parent (str?): Attribute that is to be the new attribute's parent.
                Properties: create, query
        proxy (str?): Proxy another node's attribute. Proxied plug will be connected as source. The UsedAsProxy flag is automatically set in this case.
                Properties: create, query
        readable (bool?): Can outgoing connections be made from this attribute?
                Properties: create, query
        shortName (str?): Sets the short name of the attribute.
                Properties: create, query
        softMaxValue (float?): Soft maximum, valid for numeric attributes only.  Specifies the
                upper default limit used in sliders for this attribute.
                Properties: create, query, edit
        softMinValue (float?): Soft minimum, valid for numeric attributes only.  Specifies the
                lower default limit used in sliders for this attribute.
                Properties: create, query, edit
        storable (bool?): Can the attribute be stored out to a file?
                Properties: create, query
        usedAsColor (bool?): Is the attribute to be used as a color definition?
                Must have 3 DOUBLE or 3 FLOAT children to use this
                flag.  The attribute type "-at" should be "double3"
                or "float3" as appropriate.  It can also be used to
                less effect with data types "-dt" as "double3" or
                "float3" as well but some parts of the code do not
                support this alternative.  The special attribute
                types/data "spectrum" and "reflectance" also support
                the color flag and on them it is set by default.
                Properties: create, query
        usedAsFilename (bool?): Is the attribute to be treated as a filename definition?
                This flag is only supported on attributes with data type "-dt" of "string".
                Properties: create, query
        usedAsProxy (bool?): Set if the specified attribute should be treated as a proxy to another attributes.
                Properties: create, query
        worldSpace (bool?): Sets whether this attribute should be treated as worldspace.
                Being worldspace indicates the attribute is dependent on the worldSpace
                transformation of this node, and will be marked dirty by any attribute
                changes in the hierarchy that affects the worldSpace transformation. The
                attribute needs to be an array since during instancing there are
                multiple worldSpace paths to the node and Maya requires one array element
                per path for worldSpace attributes. Remarks:
                1. Can only be used on array attributes.
                2. This property is ignored on non-dag nodes.
                3. The attribute should be affected by another attribute or have a connection.
                   Otherwise, the attribute will not get computed and will not get dirty again.
                Properties: create, query
        writable (bool?): Can incoming connections be made to this attribute?
                Properties: create, query

    Returns:
        bool: In query mode, return type is based on queried flag.

    Example:
    """

def addDynamic(*args: str) -> str:
    """Makes the "object" specified as second argument the source of an
    existing field or emitter specified as the first argument. In
    practical terms, what this means is that a field will emanate its
    force from its owner object, and an emitter will emit from its owner
    object.addDynamic makes the specified field or emitter a child of
    the owner's transform (adding it to the model if it was not already
    there), and makes the necessary attribute connections.If either of the arguments is omitted, addDynamic searches the
    selection list for objects to use instead. If more than one possible
    owner or field/emitter is selected, addDynamic will do
    nothing.If the specified field/emitter already has a source, addDynamic will
    remove the current source and replace it with the newly specified
    source.If a subset of the owner object's cvs/particles/vertices is selected,
    addDynamic will add the field/emitter to that subset only.
    Returns:
        str: The name of the source object and the field or emitter which was
            attached to it.

    Example:
    """

def addDynamicAttribute() -> None: ...
def addExtension(nodeType: str = ..., attributeType: str = ..., binaryTag: str = ..., cachedInternally: bool = ..., category: str = ..., dataType: str = ..., defaultValue: float = ..., disconnectBehaviour: Unknown = ..., enumName: str = ..., exists: bool = ..., fromPlugin: bool = ..., hasMaxValue: bool = ..., hasMinValue: bool = ..., hasSoftMaxValue: bool = ..., hasSoftMinValue: bool = ..., hidden: bool = ..., indexMatters: bool = ..., internalSet: bool = ..., keyable: bool = ..., longName: str = ..., maxValue: float = ..., minValue: float = ..., multi: bool = ..., niceName: str = ..., numberOfChildren: Unknown = ..., parent: str = ..., proxy: str = ..., readable: bool = ..., shortName: str = ..., softMaxValue: float = ..., softMinValue: float = ..., storable: bool = ..., usedAsColor: bool = ..., usedAsFilename: bool = ..., usedAsProxy: bool = ..., worldSpace: bool = ..., writable: bool = ...) -> bool:
    """This command is used to add an extension attribute to a node type.
    Either the longName or the shortName or both must be specified.
    If neither a dataType nor an attributeType is specified, a double
    attribute will be added.  The dataType flag can be specified more than
    once indicating that any of the supplied types will be accepted (logical-or).To add a non-double attribute the following criteria
    can be used to determine whether the dataType or the attributeType
    flag is appropriate.  Some types, such ascan use either.
    In these cases theflag should be used when you only wish to
    access the data as an atomic entity (eg. you never want to access the
    three individual values that make up a).  In general it
    is best to use thein these cases for maximum flexibility.
    In most cases theversion will not display in the attribute
    editor as it is an atomic type and you are not allowed to change
    individual parts of it.All attributes flagged as "(compound)" below or the compound attribute itself
    are not actually added to the node until all of the children are defined
    (using the "-p" flag to set their parent to the compound being created).  See
    the EXAMPLES section for more details.attribute, dependency, graph, add, dynamic, create
    Args:
        nodeType (str?): Specifies the type of node to which the attribute will be added.
                See the nodeType command for the names of different node types.
                Properties: create, query, edit
        attributeType (str?): Specifies the attribute type, see above table for more details.
                Note that the attribute types "float", "matrix" and "string"
                are also MEL keywords and must be enclosed in quotes.
                Properties: create, query
        binaryTag (str?): This flag is obsolete and does not do anything any more
                Properties: create, query
        cachedInternally (bool?): Whether or not attribute data is cached internally in the node.
                This flag defaults to true for writable attributes and false
                for non-writable attributes. A warning will be issued if
                users attempt to force a writable attribute to be uncached as
                this will make it impossible to set keyframes.
                Properties: create, query
        category (str?): An attribute category is a string associated with the attribute to identify it.
                (e.g. the name of a plugin that created the attribute, version information, etc.)
                Any attribute can be associated with an arbitrary number of categories however
                categories can not be removed once associated.
                Properties: create, query, edit, multiuse
        dataType (str?): Specifies the data type.  See "setAttr" for
                more information on data type names.
                Properties: create, query, multiuse
        defaultValue (float?): Specifies the default value for the attribute
                (can only be used for numeric attributes).
                Properties: create, query, edit
        disconnectBehaviour (Unknown?): defines the Disconnect Behaviour 2 Nothing, 1 Reset, 0 Delete
                Properties: create, query
        enumName (str?): Flag used to specify the ui names corresponding to the enum values. The specified string should contain a colon-separated list of the names, with optional values. If values are not specified, they will treated as sequential integers starting with 0. For example: -enumName "A:B:C" would produce options: A,B,C with values of 0,1,2; -enumName "zero:one:two:thousand=1000" would produce four options with values 0,1,2,1000; and -enumName "solo=1. triplet=3. quintet=5" would produce three options with values 1,3,5.  (Note that there is a current limitation of the Channel Box that will sometimes incorrectly display an enumerated attribute's pull-down menu.  Extra menu items can appear that represent the numbers inbetween non-sequential option values.  To avoid this limitation, specify sequential values for the options of any enumerated attributes that will appear in the Channel Box.  For example: "solo=1. triplet=2. quintet=3".)
                Properties: create, query, edit
        exists (bool?): Returns true if the attribute queried is a user-added, dynamic attribute; false if not.
                Properties: create, query
        fromPlugin (bool?): Was the attribute originally created by a plugin? Normally set
                automatically when the API call is made - only added here to support
                storing it in a file independently from the creating plugin.
                Properties: create, query
        hasMaxValue (bool?): Flag indicating whether an attribute has a maximum value.
                (can only be used for numeric attributes).
                Properties: create, query, edit
        hasMinValue (bool?): Flag indicating whether an attribute has a minimum value.
                (can only be used for numeric attributes).
                Properties: create, query, edit
        hasSoftMaxValue (bool?): Flag indicating whether a numeric attribute has a soft maximum.
                Properties: create, query
        hasSoftMinValue (bool?): Flag indicating whether a numeric attribute has a soft minimum.
                Properties: create, query
        hidden (bool?): Will this attribute be hidden from the UI?
                Properties: create, query
        indexMatters (bool?): Sets whether an index must be used when connecting
                to this multi-attribute. Setting indexMatters to false forces the
                attribute to non-readable.
                Properties: create, query
        internalSet (bool?): Whether or not the internal cached value is set when
                this attribute value is changed.  This is an internal flag
                used for updating UI elements.
                Properties: create, query
        keyable (bool?): Is the attribute keyable by default?
                Properties: create, query
        longName (str?): Sets the long name of the attribute.
                Properties: create, query
        maxValue (float?): Specifies the maximum value for the attribute
                (can only be used for numeric attributes).
                Properties: create, query, edit
        minValue (float?): Specifies the minimum value for the attribute
                (can only be used for numeric attributes).
                Properties: create, query, edit
        multi (bool?): Makes the new attribute a multi-attribute.
                Properties: create, query
        niceName (str?): Sets the nice name of the attribute for display in the UI.  Setting the
                attribute's nice name to a non-empty string overrides the default
                behaviour of looking up the nice name from Maya's
                string catalog.   (Use the MEL commands
                "attributeNiceName" and "attributeQuery -niceName" to lookup an attribute's
                nice name in the catalog.)
                Properties: create, query, edit
        numberOfChildren (Unknown?): How many children will the new attribute have?
                Properties: create, query
        parent (str?): Attribute that is to be the new attribute's parent.
                Properties: create, query
        proxy (str?): Proxy another node's attribute. Proxied plug will be connected as source. The UsedAsProxy flag is automatically set in this case.
                Properties: create, query
        readable (bool?): Can outgoing connections be made from this attribute?
                Properties: create, query
        shortName (str?): Sets the short name of the attribute.
                Properties: create, query
        softMaxValue (float?): Soft maximum, valid for numeric attributes only.  Specifies the
                upper default limit used in sliders for this attribute.
                Properties: create, query, edit
        softMinValue (float?): Soft minimum, valid for numeric attributes only.  Specifies the
                lower default limit used in sliders for this attribute.
                Properties: create, query, edit
        storable (bool?): Can the attribute be stored out to a file?
                Properties: create, query
        usedAsColor (bool?): Is the attribute to be used as a color definition?
                Must have 3 DOUBLE or 3 FLOAT children to use this
                flag.  The attribute type "-at" should be "double3"
                or "float3" as appropriate.  It can also be used to
                less effect with data types "-dt" as "double3" or
                "float3" as well but some parts of the code do not
                support this alternative.  The special attribute
                types/data "spectrum" and "reflectance" also support
                the color flag and on them it is set by default.
                Properties: create, query
        usedAsFilename (bool?): Is the attribute to be treated as a filename definition?
                This flag is only supported on attributes with data type "-dt" of "string".
                Properties: create, query
        usedAsProxy (bool?): Set if the specified attribute should be treated as a proxy to another attributes.
                Properties: create, query
        worldSpace (bool?): Sets whether this attribute should be treated as worldspace.
                Being worldspace indicates the attribute is dependent on the worldSpace
                transformation of this node, and will be marked dirty by any attribute
                changes in the hierarchy that affects the worldSpace transformation. The
                attribute needs to be an array since during instancing there are
                multiple worldSpace paths to the node and Maya requires one array element
                per path for worldSpace attributes. Remarks:
                1. Can only be used on array attributes.
                2. This property is ignored on non-dag nodes.
                3. The attribute should be affected by another attribute or have a connection.
                   Otherwise, the attribute will not get computed and will not get dirty again.
                Properties: create, query
        writable (bool?): Can incoming connections be made to this attribute?
                Properties: create, query

    Returns:
        bool: In query mode, return type is based on queried flag.

    Example:
    """

def addMetadata(*args: str, channelName: str = ..., channelType: str = ..., indexType: str = ..., scene: bool = ..., streamName: str = ..., structure: str = ...) -> List[str]:
    """Defines the attachment of a metadata structure to one or more selected
    objects. This creates a placeholder with an empty metadata Stream for
    later population through thecommand. It's similar
    in concept to thecommand for nodes - a data description
    is added but no data is actually set.When assigning a metadata structure you must specify these flags
    -is the metadata channel type (e.g. "vertex"),is the name of the metadata stream to be created,
    andis the name of the structure type defining the
    contents of the metadata. Theflag is optional.
    If it is not present then the index will be presumed to be a standard
    numerical value.You can query metadata information at a variety of levels. See the
    table below for a full list of the queryable arguments. In each case
    the specification of any of the non-queried arguments filters the list
    of metadata to be examined during the query. For all queries a single
    object must be selected for querying.For example querying theflag with no other
    arguments will return the list of all Channel types on the selected
    object that contain any metadata. Querying theflag
    with theflag specified will return only those
    channel types containing metadata streams that use that particular
    type of index.Flag Combinations:metadata, component, stream, channel, association
    Args:
        channelName (str?): Name of the Channel type to which the structure is to be added (e.g. "vertex").
                			In query mode, this flag can accept a value.
                Properties: create, query
        channelType (str?): Obsolete - use the 'channelName' flag instead.
                			In query mode, this flag can accept a value.
                Properties: create, query
        indexType (str?): Name of the index type the new Channel should be using. If not specified this defaults
                to a simple numeric index. Of the native types only a mesh "vertexFace" channel is
                different, using a "pair" index type.
                			In query mode, this flag can accept a value.
                Properties: create, query
        scene (bool?): Use this flag when you want to add metadata to the scene as a whole rather than to
                any individual nodes. If you use this flag and have nodes selected the nodes will
                be ignored and a warning will be displayed.
                Properties: create, query
        streamName (str?): Name of the empty stream being created. In query mode not specifying a value will
                return a list of streams on the named channel type.
                			In query mode, this flag can accept a value.
                Properties: create, query
        structure (str?): Name of the structure which defines the metadata to be attached to the object.
                In query mode this will return the name of the structure attached at a given
                stream.
                			In query mode, this flag can accept a value.
                Properties: create, query

    Returns:
        List[str]: List of nodes to which a new Stream was successfully added (create mode)

    Example:
    """

def addPP(*args: str, attribute: str = ...) -> List[str]:
    """Adds per-point (per-cv, per-vertex, or per-particle) attribute
    capability for an attribute of an emitter or field.  The -atr flag
    identifies the attribute.  If no attribute is named, addPP returns a
    warning and does nothing.The command adds any other necessary attributes wherever they are
    needed, and makes all necessary connections.  If any of the attributes
    already exist, the command simply connects to them.  The command also
    toggles any relevant attributes in the emitter or field to indicate
    that per-point capability is being used.The command adds a separate per-point attribute to the owning object
    for each emitter/field.  For example, for emission rate, there is a
    separate ratePP for each emitter.  These attributes are named
    according to the convention <emitter/field name><attr
    name>PP.  For example, if a particle shape owned an emitter
    "smoke", that shape would get attribute "smokeRatePP."The name of the object must be the emitter or field for which
    per-point capability is to be added (or the name of its parent
    transform).  The addPP command adds the per-point capability for that
    emitter or field but not for any others owned by the same object.  If
    per-point capability is not supported for a named object, the command
    will trigger a warning, but will continue executing for any other
    objects which were valid.If no objects are named, addPP uses any objects in the current
    selection list for which the specified attribute is applicable.  (For
    example, it would add per-point rate for all selected emitters.)If addPP detects that the owner object has left-over attributes from a
    deleted emitter, it will remove those attributes before adding the new
    ones.  Thus, you can delete the emitter, make a new one, and run addPP
    again, and addPP will clean up after the deleted emitter.  This is
    most commonly used if you have a geometry emitter and then decide to
    change the geometry.  Likewise, if addPP detects that some cvs or
    vertices have been added to the geometry, then it will expand the
    corresponding multi-attributes as necessary.  However, if it detects
    that some cvs/vertices have been removed, it will not remove any
    entries from the multi.  See the user manual for more discussion.
    Args:
        attribute (str?): Name of attribute to which you wish to add PP capability.
                Currently the only attribute supported is rate (for emitters).
                Properties: create

    Returns:
        List[str]: Returns names of emitters/fields for which the per-point
            capability was added for the specified attribute.

    Example:
    """

def adpAnalyticsDialog(activeNotification: bool = ..., desktopAnalytics: bool = ...) -> None: ...
def adpWaypoint(name: str = ..., property: List[str] = ...) -> None: ...
def adskAsset(arg0: Tuple[str], query: bool = ..., assetID: str = ..., library: str = ..., resolved: bool = ...) -> None: ...
def adskAssetLibrary(*args: str, unloadAll: bool = ..., unload: bool = ...) -> None: ...
def adskAssetList(infoType: str = ...) -> None: ...
def adskAssetListUI(query: bool = ..., commandSuffix: str = ..., materialLoaded: bool = ..., uiCommand: str = ...) -> None: ...
def affectedNet(*args: str, type: str = ...) -> bool:
    """This command gets the list of attributes on a node or node type and
    creates nodes of type TdnAffect, one for each attribute, that are
    connected iff the source node's attribute affects the destination node's
    attribute.
    Args:
        type (str?): Get information from the given node type instead of one node
                Properties: create

    Returns:
        bool: In query mode, return type is based on queried flag.

    Example:
    """

def affects(*args: Unknown, by: bool = ..., type: str = ...) -> str:
    """This command returns the list of attributes on a node or node type which
    affect the named attribute.attribute, node, class, dg
    Args:
        by (bool?): Show attributes that are affected by the given one rather than the
                ones that affect it.
                Properties: create
        type (str?): static node type from which to get 'affects' information
                Properties: create

    Returns:
        str: List of affected/affecting attributes

    Example:
    """

def agFormatIn(file: str = ..., name: str = ...) -> None: ...
def agFormatOut(*args: str, file: str = ...) -> None: ...
def aimConstraint(*args: str, aimVector: Tuple[float, float, float] = ..., layer: str = ..., maintainOffset: bool = ..., name: str = ..., offset: Tuple[float, float, float] = ..., remove: bool = ..., skip: str = ..., targetList: bool = ..., upVector: Tuple[float, float, float] = ..., weight: float = ..., weightAliasList: bool = ..., worldUpObject: str = ..., worldUpType: str = ..., worldUpVector: Tuple[float, float, float] = ...) -> List[str]:
    """Constrain an object's orientation to point at a target object or
    at the average position of a number of targets.An aimConstraint takes as input one or more "target" DAG transform
    nodes at which to aim the single "constraint object" DAG transform
    node.  The aimConstraint orients the constrained object such that
    the aimVector (in the object's local coordinate system) points to
    the in weighted average of the world space position target
    objects.  The upVector (again the the object's local coordinate
    system) is aligned in world space with the worldUpVector.
    Args:
        aimVector (Tuple[float, float, float]?): Set the aim vector.  This is the vector in local
                coordinates that points at the target.  If not given at creation
                time, the default value of (1.0, 0.0, 0.0) is used.
                Properties: create, query, edit
        layer (str?): Specify the name of the animation layer where the constraint should be added.
                Properties: create, edit
        maintainOffset (bool?): The offset necessary to preserve the constrained
                object's initial rotation will be calculated and used as the
                offset.
                Properties: create
        name (str?): Sets the name of the constraint node to the specified
                name.  Default name is constrainedObjectName_constraintType
                Properties: create, query, edit
        offset (Tuple[float, float, float]?): Sets or queries the value of the offset. Default is 0,0,0.
                Properties: create, query, edit
        remove (bool?): removes the listed target(s) from the constraint.
                Properties: edit
        skip (str?): Specify the axis to be skipped. Valid values are "x", "y", "z" and
                "none". During creation, "none" is the default.
                Properties: create, edit, multiuse
        targetList (bool?): Return the list of target objects.
                Properties: query
        upVector (Tuple[float, float, float]?): Set local up vector.  This is the vector in local
                coordinates that aligns with the world up vector.  If not given
                at creation time, the default value of (0.0, 1.0, 0.0) is used.
                Properties: create, query, edit
        weight (float?): Sets the weight value for the specified target(s).
                If not given at creation time, the default value of 1.0 is used.
                Properties: create, query, edit
        weightAliasList (bool?): Returns the names of the attributes that control the weight
                of the target objects. Aliases are returned in the same order
                as the targets are returned by the targetList flag
                Properties: query
        worldUpObject (str?): Set the DAG object use for worldUpType "object" and
                "objectrotation". See worldUpType for greater detail.
                The default value is no up object, which is interpreted
                as world space.
                Properties: create, query, edit
        worldUpType (str?): Set the type of the world up vector computation.
                The worldUpType can have one of 5 values: "scene",
                "object", "objectrotation", "vector", or "none".
                If the value is "scene", the upVector is
                aligned with the up axis of the scene and
                worldUpVector and worldUpObject are ignored.
                If the value is "object", the upVector is
                aimed as closely as possible to the
                origin of the space of the worldUpObject and
                the worldUpVector is ignored.
                If the value is "objectrotation" then the
                worldUpVector is interpreted as being in
                the coordinate space of the worldUpObject, transformed into
                world space and the upVector is aligned as
                closely as possible to the result.
                If the value is "vector", the upVector
                is aligned with worldUpVector as closely as
                possible and worldUpMatrix is ignored.
                Finally, if the value is "none" no twist calculation
                is performed by the constraint, with the resulting "upVector"
                orientation based previous orientation of the
                constrained object, and the "great circle" rotation needed
                to align the aim vector with its constraint.
                The default worldUpType is "vector".
                Properties: create, query, edit
        worldUpVector (Tuple[float, float, float]?): Set world up vector.  This is the vector in world
                coordinates that up vector should align with.
                See -wut/worldUpType (below)for greater detail.
                If not given at creation time, the default
                value of (0.0, 1.0, 0.0) is used.
                Properties: create, query, edit

    Returns:
        List[str]: name of the created constraint node

    Example:
    """

def air(*args: str, attenuation: float = ..., directionX: float = ..., directionY: float = ..., directionZ: float = ..., enableSpread: bool = ..., fanSetup: bool = ..., inheritRotation: bool = ..., inheritVelocity: float = ..., magnitude: float = ..., maxDistance: Unknown = ..., name: str = ..., perVertex: bool = ..., position: Tuple[Unknown, Unknown, Unknown] = ..., speed: float = ..., spread: float = ..., torusSectionRadius: Unknown = ..., velocityComponentOnly: bool = ..., volumeExclusion: bool = ..., volumeOffset: Tuple[Unknown, Unknown, Unknown] = ..., volumeShape: str = ..., volumeSweep: float = ..., wakeSetup: bool = ..., windSetup: bool = ...) -> str:
    """For each listed object, the command creates a new field.
    The field has a shape which lives in the DAG and it has an associated
    dependency node. The field is added to the list of fields owned
    by the object. Use connectDynamic to cause the field to affect a dynamic
    object. Note that if more than one object is listed, a separate field is
    created for each object.If fields are created, this command returns the names of each
    owning shape and of the field shapes themselves. If a field was queried,
    the results of the query are returned. If a field was edited, the field
    name is returned.If no object names are provided but the active selection list is non-empty,
    the command creates a field for every object in the list. If the
    list is empty, the command defaults to -pos 0 0 0.
    The air field simulates the effects of moving air. The affected objects
    will be accelerated or decelerated so that their velocities match that
    of the air.With the '-vco true' flag thrown, only accelerations are applied.
    By parenting an air field to a moving part of an object (ie. a foot of a
    character) and using '-i 1 -m 0 -s .5 -vco true' flags, one can simulate
    the movement of air around the
    foot as it moves, since the TOTAL velocity vector of the field would be
    only based on the
    movement of the foot. This can be done while the character walks through
    leaves or dust on the ground.For each listed object, the command creates a new field.
    The transform is the associated dependency node.
    Use connectDynamic to cause the field to affect a dynamic object.If fields are created,  this command returns the field names. If
    a field was queried, the results of the query are returned. If a field
    was edited, the field name is returned.If the -pos flag is specified, a field is created at the position specified.
    If not, if object names are provided or the active selection list is
    non-empty, the command creates a field for every object in the list and
    calls addDynamic to add it to the object; otherwise the command defaults
    to -pos 0 0 0.Setting the -pos flag with objects named on the command line is an error.
    Args:
        attenuation (float?): Attentuation rate of field
                Properties: query, edit
        directionX (float?):
                Properties: query, edit
        directionY (float?):
                Properties: query, edit
        directionZ (float?): Direction that the air will try to match the affected
                particles' velocity to. NOTE: This is not the velocity; this is only
                the direction. Use the -s flag to set the speed.
                Properties: query, edit
        enableSpread (bool?): This tells the system whether or not to use the spread
                angle given by '-sp'. If this is 'false' then all connected objectswithin the maximum distance will
                be affected. Also, if this is set to 'false', all affected objects are forced to match their velocities
                along the direction vector. If this is set to 'true' and spread is used, then the direction of the force
                is along the direction from the field to the object.
                Properties: query, edit
        fanSetup (bool?): Similar to 'windSetup' except that the effects of a fan or
                a person blowing air are approximated. The user can pass the same
                flags on the command line to adjust them from the defaults. These are
                the values that get set to approximate a 'fan':
                inheritVelocity 1.0
                inheritRotation true
                componentOnly false
                enableSpread true
                spread .5 (45 degrees from center )
                Properties: edit
        inheritRotation (bool?): If this is set to 'true', then the direction vector
                described with -dx, -dy, and -dz will be considered local to the owning object. Therefore, if the
                owning object's transform undergoes any rotation (by itself or one of its parents), the direction
                vector of the air field will undergo that same rotation.
                Properties: query, edit
        inheritVelocity (float?): Amount (from 0 to 1) of the field-owner's velocity added to the
                vector determined by the direction and speed flags. The combination
                of these two vectors makes
                up the TOTAL velocity vector for the air field. This allows the air
                to be determined directly by the motion of the owning object.
                Properties: query, edit
        magnitude (float?): Strength of field.
                Properties: query, edit
        maxDistance (Unknown?): Maximum distance at which field is exerted.
                -1 indicates that the field has no maximum distance.
                Properties: query, edit
        name (str?): name of field
                Properties: query, edit
        perVertex (bool?): Per-vertex application. If this flag is set true, then each
                individual point (CV, particle, vertex,etc.) of the chosen object
                exerts an identical copy of the force field. If this flag is set to
                false, then the froce is exerted only from the geometric center of
                the set of points.
                Properties: query, edit
        position (Tuple[Unknown, Unknown, Unknown]?): Position in space (x,y,z) where you want to place a gravity field.
                The gravity then emanates from this position in space rather
                than from an object. Note that you can both use -pos
                (creating a field at a position) and also provide object names.
                Properties: query, edit, multiuse
        speed (float?): How fast the affected objects' speed reaches the speed (based on the -mag, -dx, -dy, -dz flags) of the air field.
                This value gets clamped internally to be between 0.0 and 1.0.  A value of 0.0 will make the air field have no effect.
                A value of 1.0 will try to match the air field's speed much quicker, but not necessarily immediately.
                Properties: query, edit
        spread (float?): This represents the angle from the direction vector within which
                objects will be affected. The values are in the range of 0 to 1.
                A value of 0 will result in an effect only
                exactly in front of the air field along the direction vector. A
                value of 1 will result in any object in front of the owning object, 90
                degrees in all direction from the direction vector.
                Properties: query, edit
        torusSectionRadius (Unknown?): Section radius for a torus volume.  Applies only to torus.
                Similar to the section radius in the torus modelling primitive.
                Properties: query, edit
        velocityComponentOnly (bool?): If this is 'false', the air will accelerate or decelerate
                the affected objects so that their velocities will eventually match
                the TOTAL velocity vector of the air field. If this is 'true',
                only ACCELERTION is applied to the affected objects so that their
                velocity component along the TOTAL velocity vector matches or is
                greater in magnitude than the TOTAL velocity vector. This will not
                slow objects down to match velocities, only speed them up
                to match components. This is most useful when using the -iv flag
                with a value >0.
                Properties: query, edit
        volumeExclusion (bool?): Volume exclusion of the field.  If true, points outside the
                volume (defined by the volume shape attribute) are affected,  If false,
                points inside the volume are affected.  Has no effect if volumeShape
                is set to "none."
                Properties: query, edit
        volumeOffset (Tuple[Unknown, Unknown, Unknown]?): Volume offset of the field.  Volume offset translates
                the field's volume by the specified amount from the actual
                field location. This is in the field's local space.
                Properties: query, edit
        volumeShape (str?): Volume shape of the field.  Sets/edits/queries the
                field's volume shape attribute.  If set to any value other
                than "none", determines a 3. D volume within which the field has effect.
                Values are: "none," "cube," "sphere," "cylinder," "cone," "torus."
                Properties: query, edit
        volumeSweep (float?): Volume sweep of the field.  Applies only to sphere, cone,
                cylinder, and torus.  Similar effect to the sweep attribute
                in modelling.
                Properties: query, edit
        wakeSetup (bool?): Like the 'windSetup' and 'fanSetup', 'wakeSetup'
                sets certain values in the field to approximate the movement of air
                near a moving object, such as  a character's foot or hand.
                The values that are set are:
                inheritVelocity 1.0
                inheritRotation false
                componentOnly true
                enableSpread false
                speed 0.0
                Properties: edit
        windSetup (bool?): This will set some of the values above in a way that
                approximates the effects of a basic wind. This allows the user to then change certain values as
                he/she wishes on the same command line. First the preset values get set, and then any other flags
                that were passed get taken into account. These are the values that get set to approximate 'wind':
                inheritVelocity 0.0
                inheritRotation true
                componentOnly false
                enableSpread false
                Properties: edit

    Returns:
        str: Command result

    Example:
    """

def aliasAttr(*args: str, remove: bool = ...) -> List[str]:
    """Allows aliases (alternate names) to be defined for any attribute of
    a specified node. When an attribute is aliased, the alias will be
    used by the system to display information about the attribute.
    The user may, however, freely use either the alias or the original
    name of the attribute. Only a single alias can be specified for an
    attribute so setting an alias on an already-aliased attribute destroys
    the old alias.dg, dependency, graph, alias, attribute, name
    Args:
        remove (bool?): Specifies that aliases listed should be removed (otherwise new aliases
                are added).
                Properties: create

    Returns:
        List[str]: in query mode.

    Example:
    """

def align(*args: str, alignToLead: bool = ..., coordinateSystem: str = ..., xAxis: str = ..., yAxis: str = ..., zAxis: str = ...) -> bool:
    """Align or spread objects along X Y and Z axis.objects, move, align
    Args:
        alignToLead (bool?): When set, the min, center or max values are computed from the
                lead object. Otherwise, the values are averaged for all objects.
                Default is false
                Properties: create
        coordinateSystem (str?): Defines the X, Y, and Z coordinates. Default is the world coordinates
                Properties: create
        xAxis (str?): Any of none, min, mid, max, dist, stack.
                This defines the kind of alignment to perfom, default is none.
                Properties: create
        yAxis (str?): Any of none, min, mid, max, dist, stack.
                This defines the kind of alignment to perfom, default is none.
                Properties: create
        zAxis (str?): Any of none, min, mid, max, dist, stack.
                This defines the kind of alignment to perfom, default is none.
                Properties: create

    Returns:
        bool: true/false

    Example:
    """

def alignCtx(arg0: str, /, align: bool = ..., anchorFirstObject: bool = ..., distribute: bool = ..., exists: bool = ..., history: bool = ..., image1: str = ..., image2: str = ..., image3: str = ..., name: str = ..., showAlignTouch: bool = ...) -> str:
    """The alignCtx command creates a tool for aligning and
    distributing objects.
    Args:
        align (bool?): Align objects
                Properties: create, query, edit
        anchorFirstObject (bool?): Anchor first or last selected object. Default false.
                Only applicable when aligning objects.
                Properties: create, query, edit
        distribute (bool?): Distribute objects
                Properties: create, query, edit
        exists (bool?): Returns true or false depending upon whether the
                specified object exists. Other flags are ignored.
                Properties: create
        history (bool?): If this is a tool command, turn the construction history on
                for the tool in question.
                Properties: create
        image1 (str?): First of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        image2 (str?): Second of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        image3 (str?): Third of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        name (str?): If this is a tool command, name the tool appropriately.
                Properties: create
        showAlignTouch (bool?): Show or hide align touching handles. Default true.
                Only applicable when aligning objects.
                Properties: create, query, edit

    Returns:
        str: (name of the new context)

    Example:
    """

def alignCurve(arg0: str, arg1: str, /, caching: bool = ..., curvatureContinuity: bool = ..., curvatureScale1: float = ..., curvatureScale2: float = ..., joinParameter: float = ..., nodeState: int = ..., positionalContinuity: bool = ..., positionalContinuityType: int = ..., reverse1: bool = ..., reverse2: bool = ..., tangentContinuity: bool = ..., tangentContinuityType: int = ..., tangentScale1: float = ..., tangentScale2: float = ..., attach: bool = ..., constructionHistory: bool = ..., keepMultipleKnots: bool = ..., name: str = ..., object: bool = ..., replaceOriginal: bool = ...) -> List[str]:
    """The curve align command is used to align curves in maya. The main
    alignment options are positional, tangent and curvature continuity.
    Curvature continuity implies tangent continuity.Positional continuity means the curves (move) or the ends of the
    curves (modify) are changed.Tangent continuity means one of the curves is modified to be tangent
    at the points where they meet.Curvature continuity means one of the curves is modified to be
    curvature continuous as well as tangent.The default behaviour, when no curves or flags are passed, is to only
    do positional and tangent continuity on the active list with the end
    of the first curve and the start of the other curve used for alignment.
    Args:
        caching (bool?): Toggle caching for all attributes so that no recomputation is needed
                Properties: create, query, edit
        curvatureContinuity (bool?): Curvature continuity is on if true and off otherwise.
                Default: false
                Properties: create, query, edit
        curvatureScale1 (float?): Curvature scale applied to curvature of first curve for curvature continuity.
                Default: 0.0
                Properties: create, query, edit
        curvatureScale2 (float?): Curvature scale applied to curvature of second curve for curvature continuity.
                Default: 0.0
                Properties: create, query, edit
        joinParameter (float?): Parameter on reference curve where modified curve is to be aligned to.
                Default: 123456.0
                Properties: create, query, edit
        nodeState (int?): Maya dependency nodes have 6 possible states.
                The Normal (0), HasNoEffect (1), and Blocking (2) states can be
                used to alter how the graph is evaluated.



                The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)
                are for internal use only. They temporarily shut off parts of the graph during interaction
                (e.g., manipulation). The understanding is that once the operation is done,
                the state will be reset appropriately, e.g. Waiting-Blocking will reset
                back to Blocking.



                The Normal and Blocking cases apply to all nodes, while
                HasNoEffect is node specific; many nodes do not support this option.
                Plug-ins store state in the MPxNode::state attribute. Anyone can set
                it or check this attribute.  Additional details about each of these 3 states follow.




                State
                Description


                Normal
                The normal node state. This is the default.


                HasNoEffect


                The HasNoEffect option (a.k.a. pass-through), is used in cases where
                there is an operation on an input producing an output of the same data type.
                Nearly all deformers support this state, as do a few other nodes.
                As stated earlier, it is not supported by all nodes.


                Itâ€™s typical to implement support for the HasNoEffect state in
                the nodeâ€™s compute method and to perform appropriate operations.
                Plug-ins can also support HasNoEffect.


                The usual implementation of this state is to copy the input directly to the
                matching output without applying the algorithm in the node. For deformers,
                applying this state leaves the input geometry undeformed on the output.




                Blocking


                This is implemented in the depend node base class and applies to all nodes.
                Blocking is applied during the evaluation phase to connections.
                An evaluation request to a blocked connection will return as failures,
                causing the destination plug to retain its current value. Dirty propagation
                is indirectly affected by this state since blocked connections are never cleaned.


                When a node is set to Blocking the behavior is supposed to be the same as
                if all outgoing connections were broken. As long as nobody requests evaluation
                of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked
                node will still respond to getAttr requests but a getAttr on a
                downstream node will not reevaluate the blocked node.


                Setting the root transform of a hierarchy to Blocking wonâ€™t automatically
                influence child transforms in the hierarchy. To do this, youâ€™d need to
                explicitly set all child nodes to the Blocking state.


                For example, to set all child transforms to Blocking, you could use the
                following script.



                import maya.cmds as cmds
                def blockTree(root):
                nodesToBlock = []
                for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys():
                nodesToBlock += cmds.listConnections(node, source=True, destination=True )
                for node in {source:1 for source in nodesToBlock}.keys():
                cmds.setAttr( '%s.nodeState' % node, 2 )



                Applying this script would continue to draw objects but things would not be animated.




                Default: kdnNormal
                Properties: create, query, edit
        positionalContinuity (bool?): Positional continuity is on if true and off otherwise.
                Default: true
                Properties: create, query, edit
        positionalContinuityType (int?): Positional continuity type legal values:
                1. move first curve,
                2. move second curve,
                3. move both curves,
                4. modify first curve,
                5. modify second curve,
                6. modify both curves
                Default: 1
                Properties: create, query, edit
        reverse1 (bool?): If true, reverse the first input curve before doing align. Otherwise, do nothing to the first input curve before aligning. NOTE: setting this attribute to random values will cause unpredictable results and is not supported.
                Default: false
                Properties: create, query, edit
        reverse2 (bool?): If true, reverse the second input curve before doing align. Otherwise, do nothing to the second input curve before aligning. NOTE: setting this attribute to random values will cause unpredictable results and is not supported.
                Default: false
                Properties: create, query, edit
        tangentContinuity (bool?): Tangent continuity is on if true and off otherwise.
                Default: true
                Properties: create, query, edit
        tangentContinuityType (int?): Tangent continuity type legal values:
                1. do tangent continuity on first curve,
                2. do tangent continuity on second curve
                Default: 1
                Properties: create, query, edit
        tangentScale1 (float?): Tangent scale applied to tangent of first curve for tangent continuity.
                Default: 1.0
                Properties: create, query, edit
        tangentScale2 (float?): Tangent scale applied to tangent of second curve for tangent continuity.
                Default: 1.0
                Properties: create, query, edit
        attach (bool?): True if the curve is to be attached
                Properties: create
        constructionHistory (bool?): Turn the construction history on or off.
                Properties: create
        keepMultipleKnots (bool?): True if multiple knots should be left as-is.
                Properties: create
        name (str?): Sets the name of the newly-created node. If it contains
                namespace path, the new node will be created under the
                specified namespace; if the namespace does not exist, it
                will be created.
                Properties: create
        object (bool?): Create the result, or just the dependency node.
                Properties: create
        replaceOriginal (bool?): Create "in place" (i.e., replace).
                Properties: create

    Returns:
        List[str]: Object name and node name

    Example:
    """

def alignSurface(arg0: str, arg1: str, /, caching: bool = ..., curvatureContinuity: bool = ..., curvatureScale1: float = ..., curvatureScale2: float = ..., directionU: bool = ..., joinParameter: float = ..., nodeState: int = ..., positionalContinuity: bool = ..., positionalContinuityType: int = ..., reverse1: bool = ..., reverse2: bool = ..., swap1: bool = ..., swap2: bool = ..., tangentContinuity: bool = ..., tangentContinuityType: int = ..., tangentScale1: float = ..., tangentScale2: float = ..., twist: bool = ..., attach: bool = ..., constructionHistory: bool = ..., keepMultipleKnots: bool = ..., name: str = ..., object: bool = ..., replaceOriginal: bool = ...) -> List[str]:
    """The surface align command is used to align surfaces in maya. The main
    alignment options are positional, tangent and curvature continuity.
    Curvature continuity implies tangent continuity.NOTE: this tool is based on Studio's align tool.Positional continuity means the surfaces (move) or the ends of the
    surfaces (modify) are changed.Tangent continuity means one of the surfaces is modified to be tangent
    at the points where they meet.Curvature continuity means one of the surfaces is modified to be
    curvature continuous as well as tangent.The default behaviour, when no surfaces or flags are passed, is to only
    do positional and tangent continuity on the active list with the end
    of the first surface and the start of the other surface used for
    alignment.
    Args:
        caching (bool?): Toggle caching for all attributes so that no recomputation is needed
                Properties: create, query, edit
        curvatureContinuity (bool?): Curvature continuity is on if true and off otherwise.
                Default: false
                Properties: create, query, edit
        curvatureScale1 (float?): Curvature scale applied to curvature of first surface for curvature continuity.
                Default: 0.0
                Properties: create, query, edit
        curvatureScale2 (float?): Curvature scale applied to curvature of second surface for curvature continuity.
                Default: 0.0
                Properties: create, query, edit
        directionU (bool?): If true use U direction of surface and V direction otherwise.
                Default: true
                Properties: create, query, edit
        joinParameter (float?): Parameter on reference surface where modified surface is to be aligned to.
                Default: 123456.0
                Properties: create, query, edit
        nodeState (int?): Maya dependency nodes have 6 possible states.
                The Normal (0), HasNoEffect (1), and Blocking (2) states can be
                used to alter how the graph is evaluated.



                The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)
                are for internal use only. They temporarily shut off parts of the graph during interaction
                (e.g., manipulation). The understanding is that once the operation is done,
                the state will be reset appropriately, e.g. Waiting-Blocking will reset
                back to Blocking.



                The Normal and Blocking cases apply to all nodes, while
                HasNoEffect is node specific; many nodes do not support this option.
                Plug-ins store state in the MPxNode::state attribute. Anyone can set
                it or check this attribute.  Additional details about each of these 3 states follow.




                State
                Description


                Normal
                The normal node state. This is the default.


                HasNoEffect


                The HasNoEffect option (a.k.a. pass-through), is used in cases where
                there is an operation on an input producing an output of the same data type.
                Nearly all deformers support this state, as do a few other nodes.
                As stated earlier, it is not supported by all nodes.


                Itâ€™s typical to implement support for the HasNoEffect state in
                the nodeâ€™s compute method and to perform appropriate operations.
                Plug-ins can also support HasNoEffect.


                The usual implementation of this state is to copy the input directly to the
                matching output without applying the algorithm in the node. For deformers,
                applying this state leaves the input geometry undeformed on the output.




                Blocking


                This is implemented in the depend node base class and applies to all nodes.
                Blocking is applied during the evaluation phase to connections.
                An evaluation request to a blocked connection will return as failures,
                causing the destination plug to retain its current value. Dirty propagation
                is indirectly affected by this state since blocked connections are never cleaned.


                When a node is set to Blocking the behavior is supposed to be the same as
                if all outgoing connections were broken. As long as nobody requests evaluation
                of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked
                node will still respond to getAttr requests but a getAttr on a
                downstream node will not reevaluate the blocked node.


                Setting the root transform of a hierarchy to Blocking wonâ€™t automatically
                influence child transforms in the hierarchy. To do this, youâ€™d need to
                explicitly set all child nodes to the Blocking state.


                For example, to set all child transforms to Blocking, you could use the
                following script.



                import maya.cmds as cmds
                def blockTree(root):
                nodesToBlock = []
                for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys():
                nodesToBlock += cmds.listConnections(node, source=True, destination=True )
                for node in {source:1 for source in nodesToBlock}.keys():
                cmds.setAttr( '%s.nodeState' % node, 2 )



                Applying this script would continue to draw objects but things would not be animated.




                Default: kdnNormal
                Properties: create, query, edit
        positionalContinuity (bool?): Positional continuity is on if true and off otherwise.
                Default: true
                Properties: create, query, edit
        positionalContinuityType (int?): Positional continuity type legal values:
                1. move first surface,
                2. move second surface,
                3. move both surfaces,
                4. modify first surface,
                5. modify second surface,
                6. modify both surfaces
                Default: 1
                Properties: create, query, edit
        reverse1 (bool?): If true, reverse the direction (specified by directionU) of the first input surface before doing align. Otherwise, do nothing to the first input surface before aligning. NOTE: setting this attribute to random values will cause unpredictable results and is not supported.
                Default: false
                Properties: create, query, edit
        reverse2 (bool?): If true, reverse the direction (specified by directionU) of the second input surface before doing align. Otherwise, do nothing to the second input surface before aligning. NOTE: setting this attribute to random values will cause unpredictable results and is not supported.
                Default: false
                Properties: create, query, edit
        swap1 (bool?): If true, swap the UV directions of the first input surface before doing align. Otherwise, do nothing to the first input surface before aligning. NOTE: setting this attribute to random values will cause unpredictable results and is not supported.
                Default: false
                Properties: create, query, edit
        swap2 (bool?): If true, swap the UV directions of the second input surface before doing align. Otherwise, do nothing to the second input surface before aligning. NOTE: setting this attribute to random values will cause unpredictable results and is not supported.
                Default: false
                Properties: create, query, edit
        tangentContinuity (bool?): Tangent continuity is on if true and off otherwise.
                Default: true
                Properties: create, query, edit
        tangentContinuityType (int?): Tangent continuity type legal values:
                1. do tangent continuity on first surface,
                2. do tangent continuity on second surface
                Default: 1
                Properties: create, query, edit
        tangentScale1 (float?): Tangent scale applied to tangent of first surface for tangent continuity.
                Default: 1.0
                Properties: create, query, edit
        tangentScale2 (float?): Tangent scale applied to tangent of second surface for tangent continuity.
                Default: 1.0
                Properties: create, query, edit
        twist (bool?): If true, reverse the second surface in the opposite direction (specified by directionU) before doing align. This will avoid twists in the aligned surfaces. Otherwise, do nothing to the second input surface before aligning. NOTE: setting this attribute to random values will cause unpredictable results and is not supported.
                Default: false
                Properties: create, query, edit
        attach (bool?): Should surfaces be attached after alignment?
                Properties: create
        constructionHistory (bool?): Turn the construction history on or off.
                Properties: create
        keepMultipleKnots (bool?): Should multiple knots be kept?
                Properties: create
        name (str?): Sets the name of the newly-created node. If it contains
                namespace path, the new node will be created under the
                specified namespace; if the namespace does not exist, it
                will be created.
                Properties: create
        object (bool?): Create the result, or just the dependency node.
                Properties: create
        replaceOriginal (bool?): Create "in place" (i.e., replace).
                Properties: create

    Returns:
        List[str]: Object name and node name

    Example:
    """

def allNodeTypes(includeAbstract: bool = ...) -> List[str]:
    """This command returns a list containing the type names of every kind of
    creatable node registered with the system. Note that some node types are
    abstract and cannot be created. These will not show up on this list.
    (e.g. transform and polyShape both inherit from dagObject, but dagObject
     cannot be created directly so it will not appear on this list.)debug, node, type, graph
    Args:
        includeAbstract (bool?): Show every node type, even the abstract ones which cannot be created
                via the 'createNode' command. These will have the suffix "(abstract)" appended
                to them in the list.
                Properties: create

    Returns:
        List[str]: List of node types

    Example:
    """

def ambientLight(*args: str, ambientShade: float = ..., discRadius: Unknown = ..., exclusive: bool = ..., intensity: float = ..., name: str = ..., position: Tuple[Unknown, Unknown, Unknown] = ..., rgb: Tuple[float, float, float] = ..., rotation: Tuple[float, float, float] = ..., shadowColor: Tuple[float, float, float] = ..., shadowDither: float = ..., shadowSamples: int = ..., softShadow: bool = ..., useRayTraceShadows: bool = ...) -> List[Unknown]:
    """TlightCmd is the base class for other light commands.
    The ambientLight command is used to edit the parameters of
    existing ambientLights, or to create new ones. The default
    behaviour is to create a new ambientlight.This is the commmand that instantiates an ambientLight
    or edits the parameters of an existing one.
    TambientLightCmd inherits from TlightCmd which defines
    common flags like intensity, colour etc.
    See TlightCmd for a global picture of the light commands.
    Note that the flag fAmbientLightUsed indicates whether
    the command uses any ambient specific flags.
    That is, if a command doesn't use flags
    defined here, the boolean fAmbientLightUsed is set to
    false and thus the undo/redo information is not saved
    at this level.TambientLightCmd behaves like any other command, it
    has flags, saves undo information etc. the only slightly
    different behaviour is that it calls up to TlightCmd to
    complete the functionality of the command.
    Example	parseArgs:  TambientLightCmd defines
    ambientLight specific parameters like -ambientShade
    however, several other parameters are available in
    TlightCmd such as -intensity etc.  So when parsing
    the arguments, a call is made to TlightCmd::parseArgs
    to parse common parameters (like Intensity).
    Args:
        ambientShade (float?): ambientShade
                Properties: create, query, edit
        discRadius (Unknown?): radius of the disc around the light
                Properties: create, query, edit
        exclusive (bool?): True if the light is exclusively assigned
                Properties: create, query
        intensity (float?): Intensity of the light
                Properties: create, query
        name (str?): Name of the light
                Properties: create, query
        position (Tuple[Unknown, Unknown, Unknown]?): Position of the light
                Properties: create, query
        rgb (Tuple[float, float, float]?): RGB colour of the light
                Properties: create, query
        rotation (Tuple[float, float, float]?): Rotation of the light for orientation, where applicable
                Properties: create, query
        shadowColor (Tuple[float, float, float]?): Color of the light's shadow
                Properties: create, query
        shadowDither (float?): dither the shadow
                Properties: create, query, edit
        shadowSamples (int?): number of shadow samples.
                Properties: create, query, edit
        softShadow (bool?): soft shadow
                Properties: create, query, edit
        useRayTraceShadows (bool?): True if ray trace shadows are to be used
                Properties: create, query

    Returns:
        List[Unknown]: when querying the rgb or shadowColor flags
            double when querying the intensity flag
            boolean when querying the useRayTraceShadows or exclusive flags
            linear[] when querying the position flag
            angle[] when querying the rotation flag
            string when querying the name flag

    Example:
    """

def angleBetween(caching: bool = ..., constructionHistory: bool = ..., euler: bool = ..., nodeState: int = ..., vector1: Tuple[Unknown, Unknown, Unknown] = ..., vector1X: Unknown = ..., vector1Y: Unknown = ..., vector1Z: Unknown = ..., vector2: Tuple[Unknown, Unknown, Unknown] = ..., vector2X: Unknown = ..., vector2Y: Unknown = ..., vector2Z: Unknown = ...) -> List[float]:
    """Returns the axis and angle required to rotate one vector onto another.
    If the construction history () flag is ON, then the name of
    the new dependency node is returned.
    Args:
        caching (bool?): Toggle caching for all attributes so that no recomputation is needed
                Properties: create
        constructionHistory (bool?): Turn the construction history on or off.
                Properties: create
        euler (bool?): return the rotation as 3 Euler angles instead of axis + angle
                Properties: create
        nodeState (int?): Maya dependency nodes have 6 possible states.
                The Normal (0), HasNoEffect (1), and Blocking (2) states can be
                used to alter how the graph is evaluated.



                The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)
                are for internal use only. They temporarily shut off parts of the graph during interaction
                (e.g., manipulation). The understanding is that once the operation is done,
                the state will be reset appropriately, e.g. Waiting-Blocking will reset
                back to Blocking.



                The Normal and Blocking cases apply to all nodes, while
                HasNoEffect is node specific; many nodes do not support this option.
                Plug-ins store state in the MPxNode::state attribute. Anyone can set
                it or check this attribute.  Additional details about each of these 3 states follow.




                State
                Description


                Normal
                The normal node state. This is the default.


                HasNoEffect


                The HasNoEffect option (a.k.a. pass-through), is used in cases where
                there is an operation on an input producing an output of the same data type.
                Nearly all deformers support this state, as do a few other nodes.
                As stated earlier, it is not supported by all nodes.


                Itâ€™s typical to implement support for the HasNoEffect state in
                the nodeâ€™s compute method and to perform appropriate operations.
                Plug-ins can also support HasNoEffect.


                The usual implementation of this state is to copy the input directly to the
                matching output without applying the algorithm in the node. For deformers,
                applying this state leaves the input geometry undeformed on the output.




                Blocking


                This is implemented in the depend node base class and applies to all nodes.
                Blocking is applied during the evaluation phase to connections.
                An evaluation request to a blocked connection will return as failures,
                causing the destination plug to retain its current value. Dirty propagation
                is indirectly affected by this state since blocked connections are never cleaned.


                When a node is set to Blocking the behavior is supposed to be the same as
                if all outgoing connections were broken. As long as nobody requests evaluation
                of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked
                node will still respond to getAttr requests but a getAttr on a
                downstream node will not reevaluate the blocked node.


                Setting the root transform of a hierarchy to Blocking wonâ€™t automatically
                influence child transforms in the hierarchy. To do this, youâ€™d need to
                explicitly set all child nodes to the Blocking state.


                For example, to set all child transforms to Blocking, you could use the
                following script.



                import maya.cmds as cmds
                def blockTree(root):
                nodesToBlock = []
                for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys():
                nodesToBlock += cmds.listConnections(node, source=True, destination=True )
                for node in {source:1 for source in nodesToBlock}.keys():
                cmds.setAttr( '%s.nodeState' % node, 2 )



                Applying this script would continue to draw objects but things would not be animated.




                Default: kdnNormal
                Properties: create
        vector1 (Tuple[Unknown, Unknown, Unknown]?): vector from which to compute the rotation
                Properties: create
        vector1X (Unknown?): X coordinate of the vector from which to compute the rotation
                Properties: create
        vector1Y (Unknown?): Y coordinate of the vector from which to compute the rotation
                Properties: create
        vector1Z (Unknown?): Z coordinate of the vector from which to compute the rotation
                Properties: create
        vector2 (Tuple[Unknown, Unknown, Unknown]?): vector to which to compute the rotation
                Properties: create
        vector2X (Unknown?): X coordinate of the vector to which to compute the rotation
                Properties: create
        vector2Y (Unknown?): Y coordinate of the vector to which to compute the rotation
                Properties: create
        vector2Z (Unknown?): Z coordinate of the vector to which to compute the rotation
                Properties: create

    Returns:
        List[float]: 3 Euler angles or axis and angle

    Example:
    """

def animCurveEditor(arg0: str, /, areCurvesSelected: bool = ..., autoFit: str = ..., autoFitTime: str = ..., classicMode: bool = ..., clipTime: str = ..., constrainDrag: Unknown = ..., control: bool = ..., curvesShown: bool = ..., curvesShownForceUpdate: bool = ..., defineTemplate: str = ..., denormalizeCurvesCommand: str = ..., displayActiveKeyTangents: str = ..., displayActiveKeys: str = ..., displayInfinities: str = ..., displayKeys: str = ..., displayNormalized: bool = ..., displayTangents: str = ..., displayValues: str = ..., docTag: str = ..., exists: bool = ..., filter: str = ..., forceMainConnection: str = ..., highlightAffectedCurves: bool = ..., highlightConnection: str = ..., keyMinScale: float = ..., keyScale: float = ..., keyingTime: str = ..., lockMainConnection: bool = ..., lockPlayRangeShades: str = ..., lookAt: str = ..., mainListConnection: str = ..., menu: Callable = ..., normalizeCurvesCommand: str = ..., outliner: str = ..., panel: str = ..., parent: str = ..., preSelectionHighlight: bool = ..., renormalizeCurves: bool = ..., resultSamples: int = ..., resultScreenSamples: int = ..., resultUpdate: str = ..., selectionConnection: str = ..., showActiveCurveNames: bool = ..., showBufferCurves: str = ..., showCurveNames: bool = ..., showPlayRangeShades: str = ..., showResults: str = ..., showUpstreamCurves: bool = ..., simpleKeyView: bool = ..., smoothness: str = ..., snapTime: str = ..., snapValue: str = ..., stackedCurves: bool = ..., stackedCurvesMax: float = ..., stackedCurvesMin: float = ..., stackedCurvesSpace: float = ..., stateString: bool = ..., timelinePositionTop: bool = ..., unParent: bool = ..., unlockMainConnection: bool = ..., updateMainConnection: bool = ..., useTemplate: str = ..., valueLinesToggle: str = ...) -> str:
    """Edit a characteristic of a graph editor
    Args:
        areCurvesSelected (bool?): Returns a boolean to know if at least one curve is selected in the graph editor.
                Properties: query
        autoFit (str?): on | off | tgl
                Auto fit-to-view.
                Properties: query, edit
        autoFitTime (str?): on | off | tgl
                Auto fit-to-view along the time axis, as well.
                Properties: query, edit
        classicMode (bool?): When on, the graph editor is displayed in "Classic Mode", otherwise "Suites Mode" is used.
                Properties: query, edit
        clipTime (str?): Valid values: "on" "off"
                Display the clips with their offset and scale
                applied to the anim curves in the clip.
                Properties: query, edit
        constrainDrag (Unknown?): Constrains all Graph Editor animation curve drag operations
                to either the X-axis, the Y-axis, or to neither of those axes.
                Values to supply are: 0 for not constraining any axis,
                1 for constraing the X-axis, or 2 for constraining the Y-axis.
                When used in queries, this flag returns the latter values and
                these values have the same interpretation as above.
                Note: when the shift key is pressed before dragging the animation
                curve, the first mouse movement will instead determine (and override)
                any prior set constrained axis.
                Properties: create, query, edit
        control (bool?): Query only. Returns the top level control for this editor.
                Usually used for getting a parent to attach popup menus.
                Caution: It is possible for an editor to exist without a
                control. The query will return "NONE" if no control is present.
                Properties: query
        curvesShown (bool?): Returns a string array containing the names of the animCurve nodes
                currently displayed in the graph editor.
                Properties: query
        curvesShownForceUpdate (bool?): Returns a string array containing the names of the animCurve nodes
                currently displayed in the graph editor. Unlike the curvesShown flag,
                this will force an update of the graph editor for the case where
                the mainListConnection has been modified since the last refresh.
                Properties: query
        defineTemplate (str?): Puts the command in a mode where any other flags and arguments are
                parsed and added to the command template specified in the argument.
                They will be used as default arguments in any subsequent
                invocations of the command when templateName is set as the
                current template.
                Properties: create
        denormalizeCurvesCommand (str?): Sets the script that is run to denormalize curves in the graph editor.
                This is intended for internal use only.
                Properties: create, edit
        displayActiveKeyTangents (str?): on | off | tgl
                Display active key tangents in the editor.
                Properties: edit
        displayActiveKeys (str?): on | off | tgl
                Display active keys in the editor.
                Properties: edit
        displayInfinities (str?): on | off | tgl
                Display infinities in the editor.
                Properties: edit
        displayKeys (str?): on | off | tgl
                Display keyframes in the editor.
                Properties: edit
        displayNormalized (bool?): When on, display all curves normalized to the range -1 to +1.
                Properties: query, edit
        displayTangents (str?): on | off | tgl
                Display tangents in the editor.
                Properties: edit
        displayValues (str?): on | off | tgl
                Display active keys and tangents values in the editor.
                Properties: edit
        docTag (str?): Attaches a tag to the editor.
                Properties: create, query, edit
        exists (bool?): Returns whether the
                specified object exists or not. Other flags are ignored.
                Properties: create
        filter (str?): Specifies the name of an itemFilter object to be used with this editor.
                This filters the information coming onto the main list
                of the editor.
                Properties: create, query, edit
        forceMainConnection (str?): Specifies the name of a selectionConnection object that the
                editor will use as its source of content. The editor will only
                display items contained in the selectionConnection object. This is
                a variant of the -mainListConnection flag in that it will force a
                change even when the connection is locked. This flag is used to
                reduce the overhead when using the -unlockMainConnection
                , -mainListConnection, -lockMainConnection flags in immediate
                succession.
                Properties: create, query, edit
        highlightAffectedCurves (bool?): When on, highlights the curve segment affected by the selected key/tangent
                Properties: query, edit
        highlightConnection (str?): Specifies the name of a selectionConnection object that
                the editor will synchronize with its highlight list. Not all
                editors have a highlight list. For those that do, it is a secondary
                selection list.
                Properties: create, query, edit
        keyMinScale (float?): The minimum key selection size in the graph editor.
                A value of 0.0 means there is no minimum size.
                A value of 1.0 means the minimum size is the size of a key with keyScale set to 1.0
                Properties: query, edit
        keyScale (float?): Scales the key size in the graph editor
                Properties: query, edit
        keyingTime (str?): The current time in the given curve to be keyed in the graph editor.
                Properties: query
        lockMainConnection (bool?): Locks the current list of objects within the mainConnection,
                so that only those objects are displayed within the editor.
                Further changes to the original mainConnection are ignored.
                Properties: create, edit
        lockPlayRangeShades (str?): Valid values: "on" "off" "tgl"
                Lock Play Range Shades.
                Properties: query, edit
        lookAt (str?): all | selected | currentTime
                FitView helpers.
                Properties: edit
        mainListConnection (str?): Specifies the name of a selectionConnection object that the
                editor will use as its source of content. The editor will
                only display items contained in the selectionConnection object.
                Properties: create, query, edit
        menu (Callable?): Specify a script to be run when the editor
                is created.  The function will be passed one string
                argument which is the new editor's name.
                Properties: create
        normalizeCurvesCommand (str?): Sets the script that is run to normalize curves in the graph editor.
                This is intended for internal use only.
                Properties: create, edit
        outliner (str?): The name of the outliner that is associated with the graph editor.
                Properties: query, edit
        panel (str?): Specifies the panel for this editor. By default if
                an editor is created in the create callback of a scripted panel it
                will belong to that panel. If an editor does not belong to a panel
                it will be deleted when the window that it is in is deleted.
                Properties: create, query
        parent (str?): Specifies the parent layout for this editor. This flag will only
                have an effect if the editor is currently un-parented.
                Properties: create, query, edit
        preSelectionHighlight (bool?): When on, the curve/key/tangent under the mouse pointer is highlighted
                to ease selection.
                Properties: query, edit
        renormalizeCurves (bool?): This flag causes the curve normalization factors to be recalculated.
                Properties: edit
        resultSamples (int?): Specify the sampling for result curves
                Note: the smaller this number is, the longer it will
                take to update the display.
                Properties: query, edit
        resultScreenSamples (int?): Specify the screen base result sampling for result curves.
                If 0, then results are sampled in time.
                Properties: query, edit
        resultUpdate (str?): Valid values: "interactive" "delayed"
                Controls how changes to animCurves are reflected in the
                result curves (if results are being shown).  If resultUpdate
                is "interactive", then as interactive changes are being made
                to the animCurve, the result curves will be updated.  If
                modelUpdate is delayed (which is the default setting), then
                result curves are updated once the final change to an
                animCurve has been made.
                Properties: query, edit
        selectionConnection (str?): Specifies the name of a selectionConnection object that the
                editor will synchronize with its own selection list. As the user
                selects things in this editor, they will be selected in the
                selectionConnection object. If the object undergoes changes, the
                editor updates to show the changes.
                Properties: create, query, edit
        showActiveCurveNames (bool?): Display the active curve(s)'s name.
                Properties: query, edit
        showBufferCurves (str?): Valid values: "on" "off" "tgl"
                Display buffer curves.
                Properties: query, edit
        showCurveNames (bool?): Display the curves's name.
                Properties: query, edit
        showPlayRangeShades (str?): Valid values: "on" "off" "tgl"
                Display Play Range Shades.
                Properties: query, edit
        showResults (str?): Valid values: "on" "off" "tgl"
                Display result curves from expression or other non-keyed
                action.
                Properties: query, edit
        showUpstreamCurves (bool?): If true, the dependency graph is searched upstream for all curves
                that drive the selected plugs (showing multiple curves for example
                in a typical driven key setup, where first the driven key curve is
                encountered, followed by the actual animation curve that drives the
                source object). If false, only the first curves encountered
                will be shown. Note that, even if false, multiple curves can be shown
                if e.g. a blendWeighted node is being used to combine multiple curves.
                Properties: query, edit
        simpleKeyView (bool?): on | off
                Display simpler and smaller key.
                Properties: query, edit
        smoothness (str?): Valid values: "coarse" "rough" "medium" "fine"
                Specify the display smoothness of animation curves.
                Properties: query, edit
        snapTime (str?): none | integer | keyframe
                Keyframe move snap in time.
                Properties: query, edit
        snapValue (str?): none | integer | keyframe
                Keyframe move snap in values.
                Properties: query, edit
        stackedCurves (bool?): Switches the display mode between normal (all curves sharing one set of axes)
                to stacked (each curve on its own value axis, stacked vertically).
                Properties: query, edit
        stackedCurvesMax (float?): Sets the maximum value on the per-curve value axis when in stacked mode.
                Properties: query, edit
        stackedCurvesMin (float?): Sets the minimum value on the per-curve value axis when in stacked mode.
                Properties: query, edit
        stackedCurvesSpace (float?): Sets the spacing between curves when in stacked mode.
                Properties: query, edit
        stateString (bool?): Query only flag. Returns the MEL command that will create an
                editor to match the current editor state. The returned command string
                uses the string variable $editorName in place of a specific name.
                Properties: query
        timelinePositionTop (bool?): on | off | tgl
                Display timeline either at the top or bottom.
                Properties: query, edit
        unParent (bool?): Specifies that the editor should be removed from its layout.
                This cannot be used in query mode.
                Properties: create, edit
        unlockMainConnection (bool?): Unlocks the mainConnection, effectively restoring the original
                mainConnection (if it is still available), and dynamic updates.
                Properties: create, edit
        updateMainConnection (bool?): Causes a locked mainConnection to be updated from the orginal
                mainConnection, but preserves the lock state.
                Properties: create, edit
        useTemplate (str?): Forces the command to use a command template other than
                the current one.
                Properties: create
        valueLinesToggle (str?): on | off | tgl
                Display the value lines for high/low/zero of selected curves in the editor
                Properties: edit

    Returns:
        str: Editor name

    Example:
    """

def animDisplay(modelUpdate: str = ..., refAnimCurvesEditable: bool = ..., timeCode: str = ..., timeCodeOffset: str = ...) -> bool:
    """This command changes certain display options used by
    animation windows.
    Args:
        modelUpdate (str?): Controls how changes to animCurves are propagated through the
                dependency graph. Valid modes are "none", "interactive" or
                "delayed". If modelUpdate is "none" then changing an
                animCurve will not cause the model to be updated (change currentTime
                in order to update the model).  If modelUpdate is "interactive" (which
                is the default setting), then as interactive changes are being made
                to the animCurve, the model will be updated.  If modelUpdate is
                delayed, then the model is updated once the final change to an
                animCurve has been made.  With modelUpdate set to
                either "interactive" or "delayed", changes
                to animCurves made via commands will also cause the
                model to be updated.
                Properties: create, query, edit
        refAnimCurvesEditable (bool?): Specify if animation curves from referenced files are
                editable.
                Properties: create, query, edit
        timeCode (str?): Controls how time value are display. Valid values are "frame", "timecode", "fulltimecode".
                If the value is "frame" maya will display time in frame everywhere.
                If the value is "timecode" maya will display time in timecode in time
                slider, graph editor and dope sheet.
                If the value is "fulltimecode" maya will display time in timecode everywhere.
                Properties: create, query, edit
        timeCodeOffset (str?): This flag has now been deprecated.  It still exists to not break
                legacy scripts, but it will now do nothing.  See the new timeCode
                command to set and query timeCodes.
                Properties: create, query, edit

    Returns:
        bool: In query mode, return type is based on queried flag.

    Example:
    """

def animLayer(*args: Unknown, addRelatedKG: bool = ..., addSelectedObjects: bool = ..., affectedLayers: bool = ..., animCurves: bool = ..., attribute: str = ..., baseAnimCurves: bool = ..., bestAnimLayer: bool = ..., bestLayer: bool = ..., blendNodes: bool = ..., children: str = ..., collapse: bool = ..., copy: str = ..., copyAnimation: str = ..., copyNoAnimation: str = ..., excludeBoolean: bool = ..., excludeDynamic: bool = ..., excludeEnum: bool = ..., excludeRotate: bool = ..., excludeScale: bool = ..., excludeTranslate: bool = ..., excludeVisibility: bool = ..., exists: bool = ..., extractAnimation: str = ..., findCurveForPlug: str = ..., forceUIRebuild: bool = ..., forceUIRefresh: bool = ..., layeredPlug: str = ..., lock: bool = ..., maxLayers: bool = ..., moveLayerAfter: str = ..., moveLayerBefore: str = ..., mute: bool = ..., override: bool = ..., parent: str = ..., passthrough: bool = ..., preferred: bool = ..., removeAllAttributes: bool = ..., removeAttribute: str = ..., root: str = ..., selected: bool = ..., solo: bool = ..., weight: float = ..., writeBlendnodeDestinations: bool = ...) -> str:
    """This command creates and edits animation layers.layer, animation, additive, override
    Args:
        addRelatedKG (bool?): Used adding attributes to a layer. Determines if associated keying groups
                should be added or not to the layer.
                Properties: create, query, edit
        addSelectedObjects (bool?): Adds selected object(s) to the layer.
                Properties: create, query, edit
        affectedLayers (bool?): Return the layers that the currently selected object(s) are members of
                Properties: query
        animCurves (bool?): In query mode returns the anim curves associated with this layer
                Properties: create, query, edit
        attribute (str?): Adds a specific attribute on a object to the layer.
                Properties: create, query, edit, multiuse
        baseAnimCurves (bool?): In query mode returns the base layer anim curves associated with this layer, if any.
                Properties: create, query, edit
        bestAnimLayer (bool?): In query mode returns the best anim layers for keying for the selected
                objects. If used in conjunction with -at, will return the best anim layers
                for keying for the specific plugs (attributes) specified.
                Properties: create, query, edit
        bestLayer (bool?): Return the layer that will be keyed for specified attribute.
                Properties: query
        blendNodes (bool?): In query mode returns the blend nodes associated with this layer
                Properties: create, query, edit
        children (str?): Get the list of children layers. Return value is a string array.
                Properties: query
        collapse (bool?): Determine if a layer is collapse in the layer editor.
                Properties: create, query, edit
        copy (str?): Copy from layer.
                Properties: edit
        copyAnimation (str?): Copy animation from specified layer to destination layer, only animation that are on attribute layered by both layer that are concerned.
                Properties: create, edit
        copyNoAnimation (str?): Copy from layer without the animation curves.
                Properties: edit
        excludeBoolean (bool?): When adding selected object(s) to the layer, excludes any boolean attributes.
                Properties: create, query, edit
        excludeDynamic (bool?): When adding selected object(s) to the layer, excludes any dynamic attributes.
                Properties: create, query, edit
        excludeEnum (bool?): When adding selected object(s) to the layer, excludes any enum attributes.
                Properties: create, query, edit
        excludeRotate (bool?): When adding selected object(s) to the layer, exclude the rotate attribute.
                Properties: create, query, edit
        excludeScale (bool?): When adding selected object(s) to the layer, exclude the scale attribute.
                Properties: create, query, edit
        excludeTranslate (bool?): When adding selected object(s) to the layer, excludes the translate attribute.
                Properties: create, query, edit
        excludeVisibility (bool?): When adding selected object(s) to the layer, exclude the visibility attribute.
                Properties: create, query, edit
        exists (bool?): Determine if an layer exists.
                Properties: query
        extractAnimation (str?): Transfer animation from specified layer to destination layer, only animation that are on attribute layered by both layer that are concerned.
                Properties: create, edit
        findCurveForPlug (str?): Finds the parameter curve containing the animation data for the specified plug on the given layer.
                			In query mode, this flag needs a value.
                Properties: query, edit
        forceUIRebuild (bool?): Rebuilds the animation layers user interface.
                Properties: create
        forceUIRefresh (bool?): Refreshes the animation layers user interface.
                Properties: create
        layeredPlug (str?): Returns the plug on the blend node corresponding to the specified layer
                			In query mode, this flag needs a value.
                Properties: query
        lock (bool?): Set the lock state of the specified layer. A locked layer cannot receive key. Default is false.
                Properties: create, query, edit
        maxLayers (bool?): Returns the maximum number of anim layers supported by this product.
                Properties: query
        moveLayerAfter (str?): Move layer after the specified layer
                Properties: edit
        moveLayerBefore (str?): Move layer before the specified layer
                Properties: edit
        mute (bool?): Set the mute state of the specified layer. Default is false.
                Properties: create, query, edit
        override (bool?): Set the overide state of the specified layer. Default is false.
                Properties: create, query, edit
        parent (str?): Set the parent of the specified layer. Default is the animation layer root.
                Properties: create, query, edit
        passthrough (bool?): Set the passthrough state of the specified layer. Default is true.
                Properties: create, query, edit
        preferred (bool?): Determine if a layer is a preferred layer, the best layer algorithm will try to set keyframe in preferred layer first.
                Properties: create, query, edit
        removeAllAttributes (bool?): Remove all objects from layer.
                Properties: edit
        removeAttribute (str?): Remove object from layer.
                Properties: edit, multiuse
        root (str?): Return the base layer if it exist
                Properties: query
        selected (bool?): Determine if a layer is selected, a selected layer will be show in the timecontrol, graph editor.
                Properties: create, query, edit
        solo (bool?): Set the solo state of the specified layer. Default is false.
                Properties: create, query, edit
        weight (float?): Set the weight of the specified layer between 0.0 and 1.0. Default is 1.
                Properties: create, query, edit
        writeBlendnodeDestinations (bool?): In edit mode writes the destination plugs of the blend nodes that belong to the layer
                into the blend node. This is used for layer import/export purposes and is not for
                general use.
                Properties: edit

    Returns:
        str: Return values currently not documented.

    Example:
    """

def animView(arg0: str, /, endTime: int = ..., maxValue: float = ..., minValue: float = ..., nextView: bool = ..., previousView: bool = ..., startTime: int = ...) -> bool:
    """This command allows you to specify the current view range within
    an animation editor.
    Args:
        endTime (int?): End time to display within the editor
        maxValue (float?): Upper value to display within the editor
        minValue (float?): Lower value to display within the editor
        nextView (bool?): Switches to the next view.
                Properties: edit
        previousView (bool?): Switches to the previous view.
                Properties: edit
        startTime (int?): Start time to display within the editor

    Returns:
        bool: In query mode, return type is based on queried flag.

    Example:
    """

def annotate(*args: str, point: Tuple[Unknown, Unknown, Unknown] = ..., text: str = ...) -> str:
    """This command is used to create an annotation to be attached to the
    specified objects at the specified point.
    Args:
        point (Tuple[Unknown, Unknown, Unknown]?): Specifies the point about which the annotation text is to be
                centered.
                Properties: create
        text (str?): Specifies the annotation text.
                Properties: create

    Returns:
        str: Annotation added

    Example:
    """

def appHome(iconVisible: bool = ..., instrument: str = ..., setTab: str = ..., toggleVisibility: bool = ..., updateRecentFiles: bool = ..., visible: bool = ...) -> bool:
    """Used for displaying and hiding application home.
    Args:
        iconVisible (bool?): Query or set application home icon visibility preference.

                Note: Icon visibility cannot be modified if the MAYA_NO_HOME_ICON
                environment variable is defined.
                Properties: create, query, edit
        instrument (str?): Instrument the app home command with the given string.
                Properties: create
        setTab (str?): Navigate app home to the specified tab.

                Available tabs are:
                Recent
                GettingStarted
                Learning
                WhatsNew
                Community
                Properties: create, edit
        toggleVisibility (bool?): Toggle application home widget visibility.
                Properties: create, edit
        updateRecentFiles (bool?): Update the recent file list data.
                Properties: create, edit
        visible (bool?): Query or set application home widget visibility.
                Properties: create, query, edit

    Returns:
        bool: In query mode, return type is based on queried flag.

    Example:
    """

def appendListItem() -> None: ...
def applyAttrPattern(*args: str, nodeType: str = ..., patternName: str = ...) -> int:
    """Take the attribute structure described by a pre-defined pattern and apply it either to a
    node (as dynamic attributes) or a node type (as extension attributes). The same pattern
    can be applied more than once to different nodes or node types as the operation duplicates
    the attribute structure described by the pattern.  See the 'createAttrPatterns' command
    for a description of how to create a pattern.attribute, pattern
    Args:
        nodeType (str?): Name of the node type to which the attribute pattern is to be applied. This flag
                will cause a new extension attribute tree to be created, making the new attributes
                available on all nodes of the given type. If it is not specified then either a node
                name must be specified or a node must be selected for application of dynamic
                attributes.
                Properties: create
        patternName (str?): The name of the pattern to apply. The pattern with this name must have been previously created using the createAttrPatterns command.
                Properties: create

    Returns:
        int: Number of nodes or node types to which the attribute were added

    Example:
    """

def applyMetadata(arg0: Tuple[str], /, format: str = ..., scene: bool = ..., value: str = ...) -> bool:
    """Define the values of a particular set of metadata on selected objects.
    This command is used in preservation of metadata through Maya file formats
    (.ma/.mb). If any metadata already exists it will be kept and merged with
    the new metadata, overwriting duplicate entries. (i.e. if this command
    specifies data at index N and you already have a value at index N then
    the one this command specifies will be the new value and the old one
    will cease to exist.)Unlike thecommand it is not necessary to first use
    thecommand or API equivalent to attach a metadata
    stream to the object, this command will do both assignment of structure
    and of metadata values. You do have to use thecommand or API equivalent to create the structure being assigned first
    though.The formatted input will be in a form expected by the data
    associations serializer (see adsk::Data::AssociationsSerializer for
    more information). The specific serialization type will be the default
    'raw' if theflag is not used.For example the "raw" format input string
    "channel face\n[STREAMDATA]\nendChannels\nendAssociations"
    with no flags is equivalent to the input "[STREAMDATA]\nendChannels" with
    theflag set to 'face'metadata, component, stream, channel, association
    Args:
        format (str?): Name of the data association format type to use in the value flag parsing.
                Default value is "raw".
                Properties: create
        scene (bool?): Use this flag when you want to apply metadata to the scene as a whole
                rather than to any individual nodes. If you use this flag and have
                nodes selected the nodes will be ignored and a warning will be displayed.
                Scene metadata is incompatible with referenced scenes. Node associated
                metadata from referenced files will still be readable from master scenes
                but scene specific metadata of referenced files will not be accessible
                from a any master scene. This will ensure that referenced files metadata
                will not end up corrupting the master file scene-metadata.
                Properties: create
        value (str?): String containing all of the metadata to be assigned to the selected
                object.
                Properties: create

    Returns:
        bool: True if the application succeeded

    Example:
    """

def applyTake(*args: Any, channel: str = ..., device: str = ..., filter: str = ..., preview: bool = ..., recurseChannel: bool = ..., reset: bool = ..., specifyChannel: bool = ..., startTime: int = ...) -> bool:
    """This command takes data in a device (refered to as a take) and converts
    it into a form that may be played back and reviewed. The take can either
    be imported through the readTake action, or recorded by the recordDevice
    action. The take is either converted into animation curves or if the
    -preview flag is used, into blendDevice nodes.The command looks for animation curves attached to the target attributes
    of a device attachment. If animation curves exist, the take is
    pasted over the existing curves. If the curves do not exist, new
    animation curves are created.If devices are not specified, all of the devices with take data and that
    are enabled for applyTake, will have their data applied.See also: recordDevice, enableDevice, readTake, writeTake
    Args:
        channel (str?): This flag overrides the set channel enable value.
                If a channel is specified, it will be enabled.
                C: The default is all applyTake enabled channels for the device(s).
                Properties: create, multiuse
        device (str?): Specifies which device contains the take.
                C: The default is all applyTake enabled devices.
                Properties: create, multiuse
        filter (str?): This flag specifies the filters to use during the
                applyTake. If this flag is used multiple times, the ordering
                of the filters is from left to right.
                C: The default is no filters.
                Properties: create, multiuse
        preview (bool?): Applies the take to blendDevice nodes attached to the target
                attributes connected to the device attachments. Animation curves
                attached to the attributes will not be altered, but for the time
                that preview data is defined, the preview data will be the data
                used during playback.
                C: The default is to not preview.
                Properties: create
        recurseChannel (bool?): When this flag is used, the children of the channel(s)
                specified by -c/channel are also applied.
                C: The default is all of the enabled channels.
                Properties: create
        reset (bool?): Resets the blendDevice nodes affected by -preview. The preview data
                is removed and if animation curves exist, they are used during
                playback.
                Properties: create
        specifyChannel (bool?): This flag is used with -c/channel flag. When used, applyTake
                will only work on the channels listed with the -c/channel flag.
                C: The default is all of the enabled channels.
                Properties: create
        startTime (int?): The default start time for a take is determined at record time.
                The startTime option sets the starting time of the take in the
                current animation units.
                C: The default is the first time stamp of the take. If a time
                stamp does not exist for the take, 0 is used.
                Properties: create

    Returns:
        bool:

    Example:
    """

def arcLenDimContext(arg0: str, /, exists: bool = ..., history: bool = ..., image1: str = ..., image2: str = ..., image3: str = ..., name: str = ...) -> str:
    """Command used to register the arcLenDimCtx tool.
    Args:
        exists (bool?): Returns true or false depending upon whether the
                specified object exists. Other flags are ignored.
                Properties: create
        history (bool?): If this is a tool command, turn the construction history on
                for the tool in question.
                Properties: create
        image1 (str?): First of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        image2 (str?): Second of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        image3 (str?): Third of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        name (str?): If this is a tool command, name the tool appropriately.
                Properties: create

    Returns:
        str: : name of the context created

    Example:
    """

def arcLengthDimension(*args: str) -> str:
    """This command is used to create an arcLength dimension to display the
    arcLength of a curve/surface at a specified point on the curve/surface.
    Returns:
        str: Name of the arcLengthDimension node created

    Example:
    """

def arclen(arg0: Tuple[str], /, caching: bool = ..., constructionHistory: bool = ..., nodeState: int = ...) -> float:
    """This command returns the arclength of a curve if the history
    flag is not set (the default).  If the history flag is set, a node
    is created that can produce the arclength, and is connected and
    its name returned.  Having the construction history option on
    makes this command useful for expressions.
    Args:
        caching (bool?): Toggle caching for all attributes so that no recomputation is needed
                Properties: create, query, edit
        constructionHistory (bool?): Turn the construction history on or off.
                Properties: create
        nodeState (int?): Maya dependency nodes have 6 possible states.
                The Normal (0), HasNoEffect (1), and Blocking (2) states can be
                used to alter how the graph is evaluated.



                The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)
                are for internal use only. They temporarily shut off parts of the graph during interaction
                (e.g., manipulation). The understanding is that once the operation is done,
                the state will be reset appropriately, e.g. Waiting-Blocking will reset
                back to Blocking.



                The Normal and Blocking cases apply to all nodes, while
                HasNoEffect is node specific; many nodes do not support this option.
                Plug-ins store state in the MPxNode::state attribute. Anyone can set
                it or check this attribute.  Additional details about each of these 3 states follow.




                State
                Description


                Normal
                The normal node state. This is the default.


                HasNoEffect


                The HasNoEffect option (a.k.a. pass-through), is used in cases where
                there is an operation on an input producing an output of the same data type.
                Nearly all deformers support this state, as do a few other nodes.
                As stated earlier, it is not supported by all nodes.


                Itâ€™s typical to implement support for the HasNoEffect state in
                the nodeâ€™s compute method and to perform appropriate operations.
                Plug-ins can also support HasNoEffect.


                The usual implementation of this state is to copy the input directly to the
                matching output without applying the algorithm in the node. For deformers,
                applying this state leaves the input geometry undeformed on the output.




                Blocking


                This is implemented in the depend node base class and applies to all nodes.
                Blocking is applied during the evaluation phase to connections.
                An evaluation request to a blocked connection will return as failures,
                causing the destination plug to retain its current value. Dirty propagation
                is indirectly affected by this state since blocked connections are never cleaned.


                When a node is set to Blocking the behavior is supposed to be the same as
                if all outgoing connections were broken. As long as nobody requests evaluation
                of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked
                node will still respond to getAttr requests but a getAttr on a
                downstream node will not reevaluate the blocked node.


                Setting the root transform of a hierarchy to Blocking wonâ€™t automatically
                influence child transforms in the hierarchy. To do this, youâ€™d need to
                explicitly set all child nodes to the Blocking state.


                For example, to set all child transforms to Blocking, you could use the
                following script.



                import maya.cmds as cmds
                def blockTree(root):
                nodesToBlock = []
                for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys():
                nodesToBlock += cmds.listConnections(node, source=True, destination=True )
                for node in {source:1 for source in nodesToBlock}.keys():
                cmds.setAttr( '%s.nodeState' % node, 2 )



                Applying this script would continue to draw objects but things would not be animated.




                Default: kdnNormal
                Properties: create, query, edit

    Returns:
        float: Length in non history mode.

    Example:
    """

def arrayMapper(destAttr: str = ..., inputU: str = ..., inputV: str = ..., mapTo: str = ..., target: str = ..., type: str = ...) -> List[str]:
    """Create an arrayMapper node and connect it to a target object.
    If the -type flag is used, then this command also creates an external
    node used for computing the output values. If the input attribute
    does not already exist, it will be created. The output attribute
    must exists. If    a flag is omitted, the selection list will be used
    to supply the needed objects. If none are found, that action is omitted.
    Args:
        destAttr (str?): Specifies the attribute which will be the downstream
                connection for the output data from the mapper node. The
                attribute type will be used to determine which output attribute
                to use: float array gets outValuePP, vector array gets outColorPP.
                If the flag is omitted, no output connection is made.
                Properties: create
        inputU (str?): Specifies the upstream attribute to connect to the mapper's
                uCoordPP attribute. If the flag is omitted, no input connection
                is made.
                Properties: create
        inputV (str?): Specifies the upstream attribute to connect to the mapper's
                vCoordPP attribute. If the flag is omitted, no input connection
                is made.
                Properties: create
        mapTo (str?): Specifies an existing node to be used to compute the output values.
                This node must be of the appropriate type. Currently, only ramp nodes
                may be used.
                Properties: create
        target (str?): Specifies the target object to be connected to.
                Properties: create, multiuse
        type (str?): Specifies the node type to create which will be used to compute
                the output values. Currently, only ramp is valid. If the flag is
                omitted, no connection is made and the external node is not created.
                Properties: create

    Returns:
        List[str]: Names of created arrayMapper nodes.

    Example:
    """

def art3dPaintCtx(*args: Any, accopacity: bool = ..., afterStrokeCmd: str = ..., alphablendmode: str = ..., assigntxt: bool = ..., attrnames: str = ..., beforeStrokeCmd: str = ..., brushalignment: bool = ..., brushdepth: float = ..., brushfeedback: bool = ..., brushtype: str = ..., clear: bool = ..., commonattr: str = ..., dragSlider: str = ..., dynclonemode: bool = ..., exists: bool = ..., expandfilename: bool = ..., extendFillColor: bool = ..., fileformat: str = ..., filetxtaspectratio: float = ..., filetxtsizex: int = ..., filetxtsizey: int = ..., floodOpacity: float = ..., floodall: bool = ..., floodselect: bool = ..., history: bool = ..., image1: str = ..., image2: str = ..., image3: str = ..., keepaspectratio: bool = ..., lastRecorderCmd: str = ..., lastStampName: str = ..., lowerradius: float = ..., makeStroke: Unknown = ..., mappressure: str = ..., name: str = ..., opacity: float = ..., outline: bool = ..., outwhilepaint: bool = ..., paintmode: str = ..., paintoperationtype: str = ..., painttxtattr: str = ..., painttxtattrname: str = ..., pfxScale: float = ..., pfxWidth: float = ..., pickColor: bool = ..., pickValue: bool = ..., playbackCursor: Tuple[float, float] = ..., playbackPressure: float = ..., preserveclonesource: bool = ..., pressureMapping1: int = ..., pressureMapping2: int = ..., pressureMapping3: int = ..., pressureMax1: float = ..., pressureMax2: float = ..., pressureMax3: float = ..., pressureMin1: float = ..., pressureMin2: float = ..., pressureMin3: float = ..., profileShapeFile: str = ..., projective: bool = ..., radius: float = ..., record: bool = ..., reflection: bool = ..., reflectionaboutorigin: bool = ..., reflectionaxis: str = ..., reloadtexfile: bool = ..., resizeratio: float = ..., resizetxt: bool = ..., rgbcolor: Tuple[float, float, float] = ..., rgbflood: Tuple[float, float, float] = ..., saveTextureOnStroke: bool = ..., saveonstroke: bool = ..., savetexture: bool = ..., screenRadius: float = ..., selectclonesource: bool = ..., shadernames: str = ..., shapeattr: bool = ..., shapenames: str = ..., showactive: bool = ..., soloAsDiffuse: bool = ..., stampDepth: float = ..., stampProfile: str = ..., stampSpacing: float = ..., strokesmooth: str = ..., surfaceConformedBrushVertices: bool = ..., tablet: bool = ..., tangentOutline: bool = ..., textureFilenames: bool = ..., updateEraseTex: bool = ..., usepressure: bool = ..., worldRadius: float = ...) -> bool:
    """This is a tool context command for 3d Paint tool.
    Args:
        accopacity (bool?): Sets opacity accumulation on/off.
                C: Default is false (Except for sculpt tool for which it is true by default).
                Q: When queried, it returns a boolean.
                Properties: create, query, edit
        afterStrokeCmd (str?): The passed string is executed as a MEL command
                immediately after the end of a stroke.
                C: Default is no command. Q: When queried, it returns
                the current command
                Properties: create, query, edit
        alphablendmode (str?): Specifies the blend mode used while painting
                RGB channel. Currently, we support the following blend modes:
                "Default" "Lighten" "Darken" "Difference" "Exclusion"
                "Hard Light" "Soft Light" "Multiply" "Screen" "Overlay" "Constant"
                Default is "Default".
                Properties: create, query, edit
        assigntxt (bool?): Sends a request to the tool to allocate and assign
                file textures to the specified attibute on the selected
                shaders.
                Properties: edit
        attrnames (str?): Name of attributes
                Properties: create, query, edit
        beforeStrokeCmd (str?): The passed string is executed as a MEL command
                immediately before the start of a stroke.
                C: Default is no command. Q: When queried, it returns the
                current command
                Properties: create, query, edit
        brushalignment (bool?): Specifies the path brush alignemnt. If true,
                the brush will align to stroke path, otherwise it will
                align to up vector.
                C: Default is true. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        brushdepth (float?): Depth of the brush
                Properties: create, query, edit
        brushfeedback (bool?): Specifies if the brush additional feedback should
                be drawn.
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        brushtype (str?): Name of the brush type
                Properties: create, query, edit
        clear (bool?): Floods all cvs/vertices to the current value.
                Properties: create, edit
        commonattr (str?): Returns a string with the names of all common to
                all the shaders paintable attributes and supported by the
                Paint Texture Tool.
                Properties: query
        dragSlider (str?): Sets the current brush drag state for resizing or
                offsetting the brush (like the 'b' and 'm' default hotkeys).
                The string argument is one of: "radius", "lowradius",
                "opacity", "value", "depth", "displacement", "uvvector"
                or "none".
                C: Default is "none".
                Properties: create, edit
        dynclonemode (bool?): Enable or disable dynamic clone mode.
                Properties: create, query, edit
        exists (bool?): Returns true or false depending upon whether the
                specified object exists. Other flags are ignored.
                Properties: create
        expandfilename (bool?): If true, it will expand the name of the export file
                and concatenate it with the surface name. Otherwise it
                will take the name as it is.
                C: Default is true.
                Properties: create, edit
        extendFillColor (bool?): States if the painted textures will be automatically
                postprocessed on each stroke to fill in the background color.
                Default is true.
                Properties: create, query, edit
        fileformat (str?): Name of the file format
                Properties: create, query, edit
        filetxtaspectratio (float?): Specifies the aspect ration of the texture
                width and height.
                Default is 1.
                Properties: create, query, edit
        filetxtsizex (int?): Specifies the width of the texture.
                Default is 256.
                Properties: create, query, edit
        filetxtsizey (int?): Specifies the height of the texture.
                Default is 256.
                Properties: create, query, edit
        floodOpacity (float?): Value of the flood opacity
                Properties: create, query, edit
        floodall (bool?): Turn on to flood everything
                Properties: create, query, edit
        floodselect (bool?): Should the selected area be flooded?
                Properties: create, query, edit
        history (bool?): If this is a tool command, turn the construction history on
                for the tool in question.
                Properties: create
        image1 (str?): First of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        image2 (str?): Second of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        image3 (str?): Third of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        keepaspectratio (bool?): States if the aspect ratio of the file texture
                sizes should remain constant.
                Default is true.
                boolean.
                Properties: create, query, edit
        lastRecorderCmd (str?): Value of last recorded command.
                Properties: create, query, edit
        lastStampName (str?): Value of the last stamp name.
                Properties: create, query, edit
        lowerradius (float?): Sets the lower size of the brush (only apply on tablet).
                Properties: create, query, edit
        makeStroke (Unknown?): Stroke point values.
                Properties: create, query, edit, multiuse
        mappressure (str?): Sets the tablet pressure mapping when the table
                is used. There are three options:
                "Opacity" - the pressure is mapped to the opacity,
                "Radius" - the is mapped to modify the radius of the brush,
                "Both" - the pressure modifies both the opacity and the radius.
                C: Default is "Opacity". Q: When queried, it returns a string.
                Properties: create, query, edit
        name (str?): If this is a tool command, name the tool appropriately.
                Properties: create
        opacity (float?): Sets the brush opacity.
                C: Default is 1.0. Q: When queried, it returns a float.
                Properties: create, query, edit
        outline (bool?): Specifies if the brush should be drawn.
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        outwhilepaint (bool?): Specifies if the brush outline should be drawn
                while painting.
                C: Default is FALSE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        paintmode (str?): Specifies the paint mode. There are two
                possibilities: "screen" and "tangent".
                C: Default is "screen". Q: When queried, it returns a string.
                Properties: create, query, edit
        paintoperationtype (str?): Specifies the operation type used by the
                Paint Tool.  Currently, we support the following
                paint modes: "Paint", "Smear", "Blur", "Erase"
                and "Clone".
                Default is "Paint".
                Properties: create, query, edit
        painttxtattr (str?): Specifies the attribute on the shader which
                the user wants to paint. Currently, we support the following
                attributes: "Color", "Transparency", "Ambient", "Incandescence",
                "BumpMap", "Diffuse", "Translucence" "Eccentricity"
                "SpecularColor", "Reflectivity", "ReflectedColor", and
                user-defined float, float3, double, and double3 attributes.
                Default is "Color".
                Properties: create, query, edit
        painttxtattrname (str?): Returns a string with the names of all paintable
                attributes supported by the Paint Texture Tool.
                Properties: query, edit
        pfxScale (float?): Specifies the scale for Paint Effect brushes.
                Properties: query, edit
        pfxWidth (float?): Specifies the width for Paint Effect brushes.
                Properties: query, edit
        pickColor (bool?): Set pick color mode on or off
                Properties: create, query, edit
        pickValue (bool?): Toggle for picking
                Properties: create, query, edit
        playbackCursor (Tuple[float, float]?): Values for the playback cursor.
                Properties: create, query, edit, multiuse
        playbackPressure (float?): Valus for the playback pressure.
                Properties: create, query, edit, multiuse
        preserveclonesource (bool?): Whether or not to preserve a clone source.
                Properties: create, query, edit
        pressureMapping1 (int?): First pressure mapping value
                Properties: create, query, edit
        pressureMapping2 (int?): Second pressure mapping value
                Properties: create, query, edit
        pressureMapping3 (int?): Third pressure mapping value
                Properties: create, query, edit
        pressureMax1 (float?): First pressure maximum value
                Properties: create, query, edit
        pressureMax2 (float?): Second pressure maximum value
                Properties: create, query, edit
        pressureMax3 (float?): Third pressure maximum value
                Properties: create, query, edit
        pressureMin1 (float?): First pressure minimum value
                Properties: create, query, edit
        pressureMin2 (float?): Second pressure minimum value
                Properties: create, query, edit
        pressureMin3 (float?): Third pressure minimum value
                Properties: create, query, edit
        profileShapeFile (str?): Passes a name of the image file for the stamp shape
                profile.
                Properties: query, edit
        projective (bool?): Specifies the projective paint mode.
                C: Default is 'false'. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        radius (float?): Sets the size of the brush.
                C: Default is 1.0 cm. Q: When queried, it returns a float.
                Properties: create, query, edit
        record (bool?): Toggle on for recording.
                Properties: create, query, edit
        reflection (bool?): Specifies the reflection mode.
                C: Default is 'false'. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        reflectionaboutorigin (bool?): Toggle on to reflect about the origin
                Properties: create, query, edit
        reflectionaxis (str?): Specifies the reflection axis. There are three
                possibilities: "x", "y" and "z".
                C: Default is "x". Q: When queried, it returns a string.
                Properties: create, query, edit
        reloadtexfile (bool?): Sends a request to the tool to reload the texture
                from the disc.
                Properties: edit
        resizeratio (float?): Specifies the scale by which to resize the
                current textures.
                Properties: query, edit
        resizetxt (bool?): Sends a request to the tool to resize all the
                currently in use textures.
                Properties: edit
        rgbcolor (Tuple[float, float, float]?): Colour value
                Properties: create, query, edit
        rgbflood (Tuple[float, float, float]?): Color of the flood
                Properties: create, query, edit
        saveTextureOnStroke (bool?): States if the original texture will be automatically saved
                on each stroke.
                Default is false.
                Properties: create, query, edit
        saveonstroke (bool?): States if the temporary texture will be automatically saved
                on each stroke.
                Default is false.
                Properties: create, query, edit
        savetexture (bool?): Sends a request to the tool to save the texture
                to the disc.
                Properties: edit
        screenRadius (float?): Brush radius on the screen
                Properties: create, query, edit
        selectclonesource (bool?): Toggle on to select the clone source
                Properties: create, query, edit
        shadernames (str?): Returns a string with the names of all shaders assigned
                to selected surfaces.
                Properties: query
        shapeattr (bool?): States if the attribute to paint is an attribute of the shape and not the shader.
                Default is false.
                Properties: query, edit
        shapenames (str?): Returns a string with the names of all surfaces
                which are being painted on.
                Properties: query
        showactive (bool?): Sets on/off the display of the surface isoparms.
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        soloAsDiffuse (bool?): States if the currently paintable texture will be rendered as
                as diffuse texture in the viewport.
                Default is false.
                Properties: query, edit
        stampDepth (float?): Depth of the stamps
                Properties: create, query, edit
        stampProfile (str?): Sets the brush profile of the current stamp.
                Currently, the following profiles are supported:
                "gaussian", "poly", "solid" and "square".
                C: Default is gaussian. Q: When queried, it returns a string.
                Properties: create, query, edit
        stampSpacing (float?): Specifies the stamp spacing. Default is 1.0.
                Properties: create, query, edit
        strokesmooth (str?): Stroke smoothing type name
                Properties: create, query, edit
        surfaceConformedBrushVertices (bool?): Enables/disables the the display of the effective brush area
                as affected vertices.
                Properties: create, query, edit
        tablet (bool?): Returns true if the tablet device is present, false if it is absent
                Properties: query
        tangentOutline (bool?): Enables/disables the display of the brush circle tangent to
                the surface.
                Properties: create, query, edit
        textureFilenames (bool?): Returns a string array with the names of all the painted
                file textures.
                Properties: query
        updateEraseTex (bool?): Should the erase texture update?
                Properties: create, query, edit
        usepressure (bool?): Sets the tablet pressure on/off.
                C: Default is false. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        worldRadius (float?): Radius in worldspace
                Properties: create, query, edit

    Returns:
        bool: In query mode, return type is based on queried flag.

    Example:
    """

def artAttr(*args: str) -> None: ...
def artAttrCtx(*args: Any, accopacity: bool = ..., activeListChangedProc: str = ..., afterStrokeCmd: str = ..., alphaclamp: str = ..., alphaclamplower: float = ..., alphaclampupper: float = ..., attrSelected: str = ..., beforeStrokeCmd: str = ..., brushalignment: bool = ..., brushfeedback: bool = ..., clamp: str = ..., clamplower: float = ..., clampupper: float = ..., clear: bool = ..., colorAlphaValue: float = ..., colorRGBAValue: Tuple[float, float, float, float] = ..., colorRGBValue: Tuple[float, float, float] = ..., colorRamp: str = ..., colorfeedback: bool = ..., colorfeedbackOverride: bool = ..., colorrangelower: float = ..., colorrangeupper: float = ..., dataTypeIndex: int = ..., disablelighting: bool = ..., dragSlider: str = ..., duringStrokeCmd: str = ..., dynclonemode: bool = ..., exists: bool = ..., expandfilename: bool = ..., exportaspectratio: float = ..., exportfilemode: str = ..., exportfilesave: str = ..., exportfilesizex: int = ..., exportfilesizey: int = ..., exportfiletype: str = ..., filterNodes: bool = ..., history: bool = ..., image1: str = ..., image2: str = ..., image3: str = ..., importfileload: str = ..., importfilemode: str = ..., importreassign: bool = ..., interactiveUpdate: bool = ..., lastRecorderCmd: str = ..., lastStampName: str = ..., lowerradius: float = ..., makeStroke: Unknown = ..., mappressure: str = ..., maxvalue: float = ..., minvalue: float = ..., name: str = ..., objattrArray: str = ..., opacity: float = ..., outline: bool = ..., outwhilepaint: bool = ..., paintNodeArray: str = ..., paintattrselected: str = ..., paintmode: str = ..., paintoperationtype: str = ..., pickColor: bool = ..., pickValue: bool = ..., playbackCursor: Tuple[float, float] = ..., playbackPressure: float = ..., preserveclonesource: bool = ..., profileShapeFile: str = ..., projective: bool = ..., radius: float = ..., rampMaxColor: Tuple[float, float, float] = ..., rampMinColor: Tuple[float, float, float] = ..., record: bool = ..., reflection: bool = ..., reflectionaboutorigin: bool = ..., reflectionaxis: str = ..., screenRadius: float = ..., selectclonesource: bool = ..., selectedattroper: str = ..., showactive: bool = ..., stampDepth: float = ..., stampProfile: str = ..., stampSpacing: float = ..., strokesmooth: str = ..., surfaceConformedBrushVertices: bool = ..., tablet: bool = ..., tangentOutline: bool = ..., toolOffProc: str = ..., toolOnProc: str = ..., useColorRamp: bool = ..., useMaxMinColor: bool = ..., usepressure: bool = ..., value: float = ..., whichTool: str = ..., worldRadius: float = ...) -> str:
    """This is a context command to set the flags on the artAttrContext,
    which is the base context for attribute painting operations. All
    commands require the name of the context as the last argument as
    this provides the name of the context to create, edit or query.This is a context command to set the flags on the
    Attribute Paint Tool context.
    Args:
        accopacity (bool?): Sets opacity accumulation on/off.
                C: Default is false (Except for sculpt tool for which it is true by default).
                Q: When queried, it returns a boolean.
                Properties: create, query, edit
        activeListChangedProc (str?): Accepts a string that contains a MEL command that is
                invoked whenever the active list changes. There may be some
                situations where the UI, for example, needs to be updated,
                when objects are selected/deselected in the scene. In query
                mode, the name of the currently registered MEL command is
                returned and this will be an empty string if none is defined.
                Properties: create, query, edit
        afterStrokeCmd (str?): The passed string is executed as a MEL command
                immediately after the end of a stroke.
                C: Default is no command. Q: When queried, it returns
                the current command
                Properties: create, query, edit
        alphaclamp (str?): Specifies if the weight value should be alpha clamped to
                the lower and upper bounds. There are four options here:
                "none" - no clamping is performed, "lower" - clamps only to
                the lower bound, "upper" - clamps only to the upper bounds,
                "both" - clamps to the lower and upper bounds.
                C: Default is "none".  Q: When queried, it returns a string.
                Properties: create, query, edit
        alphaclamplower (float?): Specifies the lower bound for the alpha values.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        alphaclampupper (float?): Specifies the upper bound for the alpha values.
                C: Default is 1.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        attrSelected (str?): Returns a name of the currently selected attribute.
                Q: When queried, it returns a string.
                Properties: query
        beforeStrokeCmd (str?): The passed string is executed as a MEL command
                immediately before the start of a stroke.
                C: Default is no command. Q: When queried, it returns the
                current command
                Properties: create, query, edit
        brushalignment (bool?): Specifies the path brush alignemnt. If true,
                the brush will align to stroke path, otherwise it will
                align to up vector.
                C: Default is true. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        brushfeedback (bool?): Specifies if the brush additional feedback should
                be drawn.
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        clamp (str?): Specifies if the weight value should be clamped to
                the lower and upper bounds. There are four options here:
                "none" - no clamping is performed, "lower" - clamps only to
                the lower bound, "upper" - clamps only to the upper bounds,
                "both" - clamps to the lower and upper bounds.
                C: Default is "none".  Q: When queried, it returns a string.
                Properties: create, query, edit
        clamplower (float?): Specifies the lower bound for the values.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        clampupper (float?): Specifies the upper bound for the values.
                C: Default is 1.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        clear (bool?): Floods all cvs/vertices to the current value.
                Properties: create, edit
        colorAlphaValue (float?): The Alpha value of the color.
                Properties: create, query, edit
        colorRGBAValue (Tuple[float, float, float, float]?): The RGBA value of the color.
                Properties: create, query, edit
        colorRGBValue (Tuple[float, float, float]?): The RGB value of the color.
                Properties: create, query, edit
        colorRamp (str?): Allows a user defined color ramp to be used to map values to colors.
                Properties: create, query, edit
        colorfeedback (bool?): Sets on/off the color feedback display.
                C: Default is FALSE.  Q: When queried, it returns a boolean.
                Properties: create, query, edit
        colorfeedbackOverride (bool?): Sets on/off the color feedback override.
                C: Default is FALSE.  Q: When queried, it returns a boolean.
                Properties: create, query, edit
        colorrangelower (float?): Specifies the value that maps to black when
                color feedback mode is on.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        colorrangeupper (float?): Specifies the value that maps to the maximum
                color when color feedback mode is on.
                C: Default is 1.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        dataTypeIndex (int?): When the selected paintable attribute is a vectorArray,
                it specifies which field to paint on.
                Properties: query, edit
        disablelighting (bool?): If color feedback is on, this flag determines whether
                lighting is disabled or not for the surfaces that are
                affected.
                C: Default is FALSE.  Q: When queried, it returns a boolean.
                Properties: create, query, edit
        dragSlider (str?): Sets the current brush drag state for resizing or
                offsetting the brush (like the 'b' and 'm' default hotkeys).
                The string argument is one of: "radius", "lowradius",
                "opacity", "value", "depth", "displacement", "uvvector"
                or "none".
                C: Default is "none".
                Properties: create, edit
        duringStrokeCmd (str?): The passed string is executed as a MEL command
                during the stroke, each time the mouse is dragged.
                C: Default is no command. Q: When queried, it returns
                the current command
                Properties: create, query, edit
        dynclonemode (bool?): Enable or disable dynamic clone mode.
                Properties: create, query, edit
        exists (bool?): Returns true or false depending upon whether the
                specified object exists. Other flags are ignored.
                Properties: create
        expandfilename (bool?): If true, it will expand the name of the export file
                and concatenate it with the surface name. Otherwise it
                will take the name as it is.
                C: Default is true.
                Properties: create, edit
        exportaspectratio (float?): Value of aspect ratio for export
                Properties: create, query, edit
        exportfilemode (str?): Specifies the export channel.The valid
                entries here are: "alpha", "luminance", "rgb", "rgba".
                C: Default is "luminance/rgb".
                Q: When queried, it returns a string.
                Properties: create, query, edit
        exportfilesave (str?): Exports the attribute map and saves to a specified file.
                Properties: edit
        exportfilesizex (int?): Specifies the width of the attribute map to export.
                C: Default width is 256. Q: When queried, it returns an integer.
                Properties: create, query, edit
        exportfilesizey (int?): Specifies the width of the attribute map to export.
                C: Default width is 256. Q: When queried, it returns an integer.
                Properties: create, query, edit
        exportfiletype (str?): Specifies the image file format. It can be one of
                the following: "iff", "tiff", "jpeg", "alias", "rgb", "fit"
                "postScriptEPS", "softimage", "wavefrontRLA", "wavefrontEXP".
                C: default is tiff. Q: When queried, it returns a string.
                Properties: create, query, edit
        filterNodes (bool?): Sets the node filter.
                Properties: edit
        history (bool?): If this is a tool command, turn the construction history on
                for the tool in question.
                Properties: create
        image1 (str?): First of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        image2 (str?): Second of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        image3 (str?): Third of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        importfileload (str?): Load the attribute map a specified file.
                Properties: edit
        importfilemode (str?): Specifies the channel to import. The valid
                entries here are: "alpha", "luminance", "red", "green",
                "blue", and "rgb"
                C: Default is "alpha". Q: When queried, it returns a string.
                Properties: create, query, edit
        importreassign (bool?): Specifies if the multiply atrribute maps are to be
                reassigned while importing. Only maps previously exported from
                within Artisan can be reassigned.
                C: Default is FALSE. Q: When queried, it returns a  boolean.
                Properties: create, query, edit
        interactiveUpdate (bool?): Specifies how often to transfer the painted values
                into the attribute.
                TRUE: transfer them "continuously" (many times per stroke)
                FALSE: transfer them only at the end of a stroke (on mouse
                button release).
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        lastRecorderCmd (str?): Value of last recorded command.
                Properties: create, query, edit
        lastStampName (str?): Value of the last stamp name.
                Properties: create, query, edit
        lowerradius (float?): Sets the lower size of the brush (only apply on tablet).
                Properties: create, query, edit
        makeStroke (Unknown?): Stroke point values.
                Properties: create, query, edit, multiuse
        mappressure (str?): Sets the tablet pressure mapping when the table
                is used. There are three options:
                "Opacity" - the pressure is mapped to the opacity,
                "Radius" - the is mapped to modify the radius of the brush,
                "Both" - the pressure modifies both the opacity and the radius.
                C: Default is "Opacity". Q: When queried, it returns a string.
                Properties: create, query, edit
        maxvalue (float?): Specifies the maximum value for each attribute.
                C: Default is 1.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        minvalue (float?): Specifies the minimum value for each attribute.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        name (str?): If this is a tool command, name the tool appropriately.
                Properties: create
        objattrArray (str?): An array of all paintable attributes. Each element of
                the array is a string with the following information:
                NodeType.NodeName.AttributeName.MenuType.
                *MenuType: type (level) of the item in the Menu (UI).
                Q: When queried, it returns a string.
                Properties: query
        opacity (float?): Sets the brush opacity.
                C: Default is 1.0. Q: When queried, it returns a float.
                Properties: create, query, edit
        outline (bool?): Specifies if the brush should be drawn.
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        outwhilepaint (bool?): Specifies if the brush outline should be drawn
                while painting.
                C: Default is FALSE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        paintNodeArray (str?): An array of paintable nodes.
                Q: When queried, it returns a string.
                Properties: query
        paintattrselected (str?): An array of selected paintable attributes.
                Each element of the array is a string with the
                following information:
                NodeType.NodeName.AttributeName.
                Properties: edit
        paintmode (str?): Specifies the paint mode. There are two
                possibilities: "screen" and "tangent".
                C: Default is "screen". Q: When queried, it returns a string.
                Properties: create, query, edit
        paintoperationtype (str?): Specifies the operation type used by the
                Paint Tool.  Currently, we support the following
                paint modes: "Paint", "Smear", "Blur", "Erase"
                and "Clone".
                Default is "Paint".
                Properties: create, query, edit
        pickColor (bool?): Set pick color mode on or off
                Properties: create, query, edit
        pickValue (bool?): Toggle for picking
                Properties: create, query, edit
        playbackCursor (Tuple[float, float]?): Values for the playback cursor.
                Properties: create, query, edit, multiuse
        playbackPressure (float?): Valus for the playback pressure.
                Properties: create, query, edit, multiuse
        preserveclonesource (bool?): Whether or not to preserve a clone source.
                Properties: create, query, edit
        profileShapeFile (str?): Passes a name of the image file for the stamp shape
                profile.
                Properties: query, edit
        projective (bool?): Specifies the projective paint mode.
                C: Default is 'false'. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        radius (float?): Sets the size of the brush.
                C: Default is 1.0 cm. Q: When queried, it returns a float.
                Properties: create, query, edit
        rampMaxColor (Tuple[float, float, float]?): Defines a special color to be used when the value is greater than or equal to
                the maximum value.
                Properties: create, query, edit
        rampMinColor (Tuple[float, float, float]?): Defines a special color to be used when the value is less than or equal to the
                minimum value.
                Properties: create, query, edit
        record (bool?): Toggle on for recording.
                Properties: create, query, edit
        reflection (bool?): Specifies the reflection mode.
                C: Default is 'false'. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        reflectionaboutorigin (bool?): Toggle on to reflect about the origin
                Properties: create, query, edit
        reflectionaxis (str?): Specifies the reflection axis. There are three
                possibilities: "x", "y" and "z".
                C: Default is "x". Q: When queried, it returns a string.
                Properties: create, query, edit
        screenRadius (float?): Brush radius on the screen
                Properties: create, query, edit
        selectclonesource (bool?): Toggle on to select the clone source
                Properties: create, query, edit
        selectedattroper (str?): Sets the edit weight operation. Four edit weights
                operations are provided : "absolute" - the value of the weight
                is replaced by the current one, "additive" - the value of the
                weight is added to the current one, "scale" - the value of the
                weight is multiplied by the current one, "smooth" - the value
                of the weight is divided by the current one.
                C: Default is "absolute".  Q: When queried, it returns a string.
                Properties: create, query, edit
        showactive (bool?): Sets on/off the display of the surface isoparms.
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        stampDepth (float?): Depth of the stamps
                Properties: create, query, edit
        stampProfile (str?): Sets the brush profile of the current stamp.
                Currently, the following profiles are supported:
                "gaussian", "poly", "solid" and "square".
                C: Default is gaussian. Q: When queried, it returns a string.
                Properties: create, query, edit
        stampSpacing (float?): Specifies the stamp spacing. Default is 1.0.
                Properties: create, query, edit
        strokesmooth (str?): Stroke smoothing type name
                Properties: create, query, edit
        surfaceConformedBrushVertices (bool?): Enables/disables the the display of the effective brush area
                as affected vertices.
                Properties: create, query, edit
        tablet (bool?): Returns true if the tablet device is present, false if it is absent
                Properties: query
        tangentOutline (bool?): Enables/disables the display of the brush circle tangent to
                the surface.
                Properties: create, query, edit
        toolOffProc (str?): Accepts a strings describing the name of a MEL
                procedure that is invoked whenever the tool is turned off.
                For example, cloth invokes "clothPaintToolOff" when the cloth
                paint tool is turned on. Define this callback if your tool
                requires special functionality when your tool is deactivated.
                It is typical that if you implement a toolOffProc you will
                want to implement a toolOnProc as well (see the -toolOnProc
                flag. In query mode, the name of the currently registered MEL
                command is returned and this will be an empty string if none
                is defined.
                Properties: create, query, edit
        toolOnProc (str?): Accepts a strings describing the name of a MEL
                procedure that is invoked whenever the tool is turned on.
                For example, cloth invokes "clothPaintToolOn" when the cloth
                paint tool is turned on. Define this callback if your tool
                requires special functionality when your tool is activated.
                It is typical that if you implement a toolOnProc you will
                want to implement a toolOffProc as well (see the -toolOffProc
                flag. In query mode, the name of the currently registered MEL
                command is returned and this will be an empty string if none
                is defined.
                Properties: create, query, edit
        useColorRamp (bool?): Specifies whether the user defined color ramp should be used to map values
                from to colors.  If this is turned off, the default greyscale feedback
                will be used.
                Properties: create, query, edit
        useMaxMinColor (bool?): Specifies whether the out of range colors should be used.  See rampMinColor
                and rampMaxColor flags for further details.
                Properties: create, query, edit
        usepressure (bool?): Sets the tablet pressure on/off.
                C: Default is false. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        value (float?): Specifies the value for each attribute.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        whichTool (str?): The string defines the name of the tool to be
                used for the Artisan context. An example is "artClothPaint".
                In query mode, the tool name for the given context is returned.
                Note: due to the way MEL works, always specify the -query flag
                last when specifying a flag that takes arguments.
                Properties: create, query, edit
        worldRadius (float?): Radius in worldspace
                Properties: create, query, edit

    Returns:
        str: The name of the context created.

    Example:
    """

def artAttrPaintVertexCtx(*args: Any, accopacity: bool = ..., activeListChangedProc: str = ..., afterStrokeCmd: str = ..., alphaclamp: str = ..., alphaclamplower: float = ..., alphaclampupper: float = ..., attrSelected: str = ..., beforeStrokeCmd: str = ..., brushalignment: bool = ..., brushfeedback: bool = ..., clamp: str = ..., clamplower: float = ..., clampupper: float = ..., clear: bool = ..., colorAlphaValue: float = ..., colorRGBAValue: Tuple[float, float, float, float] = ..., colorRGBValue: Tuple[float, float, float] = ..., colorRamp: str = ..., colorfeedback: bool = ..., colorfeedbackOverride: bool = ..., colorrangelower: float = ..., colorrangeupper: float = ..., dataTypeIndex: int = ..., disablelighting: bool = ..., dragSlider: str = ..., duringStrokeCmd: str = ..., dynclonemode: bool = ..., exists: bool = ..., expandfilename: bool = ..., exportaspectratio: float = ..., exportfilemode: str = ..., exportfilesave: str = ..., exportfilesizex: int = ..., exportfilesizey: int = ..., exportfiletype: str = ..., filterNodes: bool = ..., history: bool = ..., image1: str = ..., image2: str = ..., image3: str = ..., importfileload: str = ..., importfilemode: str = ..., importreassign: bool = ..., interactiveUpdate: bool = ..., lastRecorderCmd: str = ..., lastStampName: str = ..., lowerradius: float = ..., makeStroke: Unknown = ..., mappressure: str = ..., maxvalue: float = ..., minvalue: float = ..., name: str = ..., objattrArray: str = ..., opacity: float = ..., outline: bool = ..., outwhilepaint: bool = ..., paintChannel: str = ..., paintComponent: int = ..., paintNodeArray: str = ..., paintNumChannels: int = ..., paintRGBA: bool = ..., paintVertexFace: bool = ..., paintattrselected: str = ..., paintmode: str = ..., paintoperationtype: str = ..., pickColor: bool = ..., pickValue: bool = ..., playbackCursor: Tuple[float, float] = ..., playbackPressure: float = ..., preserveclonesource: bool = ..., profileShapeFile: str = ..., projective: bool = ..., radius: float = ..., rampMaxColor: Tuple[float, float, float] = ..., rampMinColor: Tuple[float, float, float] = ..., record: bool = ..., reflection: bool = ..., reflectionaboutorigin: bool = ..., reflectionaxis: str = ..., screenRadius: float = ..., selectclonesource: bool = ..., selectedattroper: str = ..., showactive: bool = ..., stampDepth: float = ..., stampProfile: str = ..., stampSpacing: float = ..., strokesmooth: str = ..., surfaceConformedBrushVertices: bool = ..., tablet: bool = ..., tangentOutline: bool = ..., toolOffProc: str = ..., toolOnProc: str = ..., useColorRamp: bool = ..., useMaxMinColor: bool = ..., usepressure: bool = ..., value: float = ..., vertexColorRange: bool = ..., vertexColorRangeLower: float = ..., vertexColorRangeUpper: float = ..., whichTool: str = ..., worldRadius: float = ...) -> bool:
    """This is a context command to set the flags on the artAttrContext,
    which is the base context for attribute painting operations. All
    commands require the name of the context as the last argument as
    this provides the name of the context to create, edit or query.This is a context command to set the flags on the
    Paint color on vertex Tool context.
    Args:
        accopacity (bool?): Sets opacity accumulation on/off.
                C: Default is false (Except for sculpt tool for which it is true by default).
                Q: When queried, it returns a boolean.
                Properties: create, query, edit
        activeListChangedProc (str?): Accepts a string that contains a MEL command that is
                invoked whenever the active list changes. There may be some
                situations where the UI, for example, needs to be updated,
                when objects are selected/deselected in the scene. In query
                mode, the name of the currently registered MEL command is
                returned and this will be an empty string if none is defined.
                Properties: create, query, edit
        afterStrokeCmd (str?): The passed string is executed as a MEL command
                immediately after the end of a stroke.
                C: Default is no command. Q: When queried, it returns
                the current command
                Properties: create, query, edit
        alphaclamp (str?): Specifies if the weight value should be alpha clamped to
                the lower and upper bounds. There are four options here:
                "none" - no clamping is performed, "lower" - clamps only to
                the lower bound, "upper" - clamps only to the upper bounds,
                "both" - clamps to the lower and upper bounds.
                C: Default is "none".  Q: When queried, it returns a string.
                Properties: create, query, edit
        alphaclamplower (float?): Specifies the lower bound for the alpha values.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        alphaclampupper (float?): Specifies the upper bound for the alpha values.
                C: Default is 1.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        attrSelected (str?): Returns a name of the currently selected attribute.
                Q: When queried, it returns a string.
                Properties: query
        beforeStrokeCmd (str?): The passed string is executed as a MEL command
                immediately before the start of a stroke.
                C: Default is no command. Q: When queried, it returns the
                current command
                Properties: create, query, edit
        brushalignment (bool?): Specifies the path brush alignemnt. If true,
                the brush will align to stroke path, otherwise it will
                align to up vector.
                C: Default is true. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        brushfeedback (bool?): Specifies if the brush additional feedback should
                be drawn.
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        clamp (str?): Specifies if the weight value should be clamped to
                the lower and upper bounds. There are four options here:
                "none" - no clamping is performed, "lower" - clamps only to
                the lower bound, "upper" - clamps only to the upper bounds,
                "both" - clamps to the lower and upper bounds.
                C: Default is "none".  Q: When queried, it returns a string.
                Properties: create, query, edit
        clamplower (float?): Specifies the lower bound for the values.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        clampupper (float?): Specifies the upper bound for the values.
                C: Default is 1.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        clear (bool?): Floods all cvs/vertices to the current value.
                Properties: create, edit
        colorAlphaValue (float?): The Alpha value of the color.
                Properties: create, query, edit
        colorRGBAValue (Tuple[float, float, float, float]?): The RGBA value of the color.
                Properties: create, query, edit
        colorRGBValue (Tuple[float, float, float]?): The RGB value of the color.
                Properties: create, query, edit
        colorRamp (str?): Allows a user defined color ramp to be used to map values to colors.
                Properties: create, query, edit
        colorfeedback (bool?): Sets on/off the color feedback display.
                C: Default is FALSE.  Q: When queried, it returns a boolean.
                Properties: create, query, edit
        colorfeedbackOverride (bool?): Sets on/off the color feedback override.
                C: Default is FALSE.  Q: When queried, it returns a boolean.
                Properties: create, query, edit
        colorrangelower (float?): Specifies the value that maps to black when
                color feedback mode is on.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        colorrangeupper (float?): Specifies the value that maps to the maximum
                color when color feedback mode is on.
                C: Default is 1.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        dataTypeIndex (int?): When the selected paintable attribute is a vectorArray,
                it specifies which field to paint on.
                Properties: query, edit
        disablelighting (bool?): If color feedback is on, this flag determines whether
                lighting is disabled or not for the surfaces that are
                affected.
                C: Default is FALSE.  Q: When queried, it returns a boolean.
                Properties: create, query, edit
        dragSlider (str?): Sets the current brush drag state for resizing or
                offsetting the brush (like the 'b' and 'm' default hotkeys).
                The string argument is one of: "radius", "lowradius",
                "opacity", "value", "depth", "displacement", "uvvector"
                or "none".
                C: Default is "none".
                Properties: create, edit
        duringStrokeCmd (str?): The passed string is executed as a MEL command
                during the stroke, each time the mouse is dragged.
                C: Default is no command. Q: When queried, it returns
                the current command
                Properties: create, query, edit
        dynclonemode (bool?): Enable or disable dynamic clone mode.
                Properties: create, query, edit
        exists (bool?): Returns true or false depending upon whether the
                specified object exists. Other flags are ignored.
                Properties: create
        expandfilename (bool?): If true, it will expand the name of the export file
                and concatenate it with the surface name. Otherwise it
                will take the name as it is.
                C: Default is true.
                Properties: create, edit
        exportaspectratio (float?): Value of aspect ratio for export
                Properties: create, query, edit
        exportfilemode (str?): Specifies the export channel.The valid
                entries here are: "alpha", "luminance", "rgb", "rgba".
                C: Default is "luminance/rgb".
                Q: When queried, it returns a string.
                Properties: create, query, edit
        exportfilesave (str?): Exports the attribute map and saves to a specified file.
                Properties: edit
        exportfilesizex (int?): Specifies the width of the attribute map to export.
                C: Default width is 256. Q: When queried, it returns an integer.
                Properties: create, query, edit
        exportfilesizey (int?): Specifies the width of the attribute map to export.
                C: Default width is 256. Q: When queried, it returns an integer.
                Properties: create, query, edit
        exportfiletype (str?): Specifies the image file format. It can be one of
                the following: "iff", "tiff", "jpeg", "alias", "rgb", "fit"
                "postScriptEPS", "softimage", "wavefrontRLA", "wavefrontEXP".
                C: default is tiff. Q: When queried, it returns a string.
                Properties: create, query, edit
        filterNodes (bool?): Sets the node filter.
                Properties: edit
        history (bool?): If this is a tool command, turn the construction history on
                for the tool in question.
                Properties: create
        image1 (str?): First of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        image2 (str?): Second of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        image3 (str?): Third of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        importfileload (str?): Load the attribute map a specified file.
                Properties: edit
        importfilemode (str?): Specifies the channel to import. The valid
                entries here are: "alpha", "luminance", "red", "green",
                "blue", and "rgb"
                C: Default is "alpha". Q: When queried, it returns a string.
                Properties: create, query, edit
        importreassign (bool?): Specifies if the multiply atrribute maps are to be
                reassigned while importing. Only maps previously exported from
                within Artisan can be reassigned.
                C: Default is FALSE. Q: When queried, it returns a  boolean.
                Properties: create, query, edit
        interactiveUpdate (bool?): Specifies how often to transfer the painted values
                into the attribute.
                TRUE: transfer them "continuously" (many times per stroke)
                FALSE: transfer them only at the end of a stroke (on mouse
                button release).
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        lastRecorderCmd (str?): Value of last recorded command.
                Properties: create, query, edit
        lastStampName (str?): Value of the last stamp name.
                Properties: create, query, edit
        lowerradius (float?): Sets the lower size of the brush (only apply on tablet).
                Properties: create, query, edit
        makeStroke (Unknown?): Stroke point values.
                Properties: create, query, edit, multiuse
        mappressure (str?): Sets the tablet pressure mapping when the table
                is used. There are three options:
                "Opacity" - the pressure is mapped to the opacity,
                "Radius" - the is mapped to modify the radius of the brush,
                "Both" - the pressure modifies both the opacity and the radius.
                C: Default is "Opacity". Q: When queried, it returns a string.
                Properties: create, query, edit
        maxvalue (float?): Specifies the maximum value for each attribute.
                C: Default is 1.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        minvalue (float?): Specifies the minimum value for each attribute.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        name (str?): If this is a tool command, name the tool appropriately.
                Properties: create
        objattrArray (str?): An array of all paintable attributes. Each element of
                the array is a string with the following information:
                NodeType.NodeName.AttributeName.MenuType.
                *MenuType: type (level) of the item in the Menu (UI).
                Q: When queried, it returns a string.
                Properties: query
        opacity (float?): Sets the brush opacity.
                C: Default is 1.0. Q: When queried, it returns a float.
                Properties: create, query, edit
        outline (bool?): Specifies if the brush should be drawn.
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        outwhilepaint (bool?): Specifies if the brush outline should be drawn
                while painting.
                C: Default is FALSE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        paintChannel (str?): Channel to paint - RGB, RGBA, R, G, B, A
                Properties: create, query, edit
        paintComponent (int?): Specifies whether face or vertex or vertex face is being painted.
                1. Vertex
                2. VertexFace
                3. Face
                C: Default is Vertex.  Q: When queried, it returns a int.
                Properties: create, query, edit
        paintNodeArray (str?): An array of paintable nodes.
                Q: When queried, it returns a string.
                Properties: query
        paintNumChannels (int?): Number of channels to paint - 1 (alpha), 3 (RGB), or 4 (RGBA)
                Properties: create, query, edit
        paintRGBA (bool?): Specifies whether RGB or RGBA channels are being painted.
                TRUE: RGBA channels.
                FALSE: RGB channels. Alpha channel remains unaffected.
                C: Default is FALSE (Painting RGB channels).
                Q: When queried, it returns a int.
                Properties: create, query, edit
        paintVertexFace (bool?): Specifies whether vertex face is being painted.
                TRUE: Vertex face being painted. (Allows each face connected to the vertex
                to be painted)
                FALSE: Vertex being painted.(affects all connected faces)
                C: Default is FALSE.  Q: When queried, it returns a int.
                Properties: create, query, edit
        paintattrselected (str?): An array of selected paintable attributes.
                Each element of the array is a string with the
                following information:
                NodeType.NodeName.AttributeName.
                Properties: edit
        paintmode (str?): Specifies the paint mode. There are two
                possibilities: "screen" and "tangent".
                C: Default is "screen". Q: When queried, it returns a string.
                Properties: create, query, edit
        paintoperationtype (str?): Specifies the operation type used by the
                Paint Tool.  Currently, we support the following
                paint modes: "Paint", "Smear", "Blur", "Erase"
                and "Clone".
                Default is "Paint".
                Properties: create, query, edit
        pickColor (bool?): Set pick color mode on or off
                Properties: create, query, edit
        pickValue (bool?): Toggle for picking
                Properties: create, query, edit
        playbackCursor (Tuple[float, float]?): Values for the playback cursor.
                Properties: create, query, edit, multiuse
        playbackPressure (float?): Valus for the playback pressure.
                Properties: create, query, edit, multiuse
        preserveclonesource (bool?): Whether or not to preserve a clone source.
                Properties: create, query, edit
        profileShapeFile (str?): Passes a name of the image file for the stamp shape
                profile.
                Properties: query, edit
        projective (bool?): Specifies the projective paint mode.
                C: Default is 'false'. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        radius (float?): Sets the size of the brush.
                C: Default is 1.0 cm. Q: When queried, it returns a float.
                Properties: create, query, edit
        rampMaxColor (Tuple[float, float, float]?): Defines a special color to be used when the value is greater than or equal to
                the maximum value.
                Properties: create, query, edit
        rampMinColor (Tuple[float, float, float]?): Defines a special color to be used when the value is less than or equal to the
                minimum value.
                Properties: create, query, edit
        record (bool?): Toggle on for recording.
                Properties: create, query, edit
        reflection (bool?): Specifies the reflection mode.
                C: Default is 'false'. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        reflectionaboutorigin (bool?): Toggle on to reflect about the origin
                Properties: create, query, edit
        reflectionaxis (str?): Specifies the reflection axis. There are three
                possibilities: "x", "y" and "z".
                C: Default is "x". Q: When queried, it returns a string.
                Properties: create, query, edit
        screenRadius (float?): Brush radius on the screen
                Properties: create, query, edit
        selectclonesource (bool?): Toggle on to select the clone source
                Properties: create, query, edit
        selectedattroper (str?): Sets the edit weight operation. Four edit weights
                operations are provided : "absolute" - the value of the weight
                is replaced by the current one, "additive" - the value of the
                weight is added to the current one, "scale" - the value of the
                weight is multiplied by the current one, "smooth" - the value
                of the weight is divided by the current one.
                C: Default is "absolute".  Q: When queried, it returns a string.
                Properties: create, query, edit
        showactive (bool?): Sets on/off the display of the surface isoparms.
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        stampDepth (float?): Depth of the stamps
                Properties: create, query, edit
        stampProfile (str?): Sets the brush profile of the current stamp.
                Currently, the following profiles are supported:
                "gaussian", "poly", "solid" and "square".
                C: Default is gaussian. Q: When queried, it returns a string.
                Properties: create, query, edit
        stampSpacing (float?): Specifies the stamp spacing. Default is 1.0.
                Properties: create, query, edit
        strokesmooth (str?): Stroke smoothing type name
                Properties: create, query, edit
        surfaceConformedBrushVertices (bool?): Enables/disables the the display of the effective brush area
                as affected vertices.
                Properties: create, query, edit
        tablet (bool?): Returns true if the tablet device is present, false if it is absent
                Properties: query
        tangentOutline (bool?): Enables/disables the display of the brush circle tangent to
                the surface.
                Properties: create, query, edit
        toolOffProc (str?): Accepts a strings describing the name of a MEL
                procedure that is invoked whenever the tool is turned off.
                For example, cloth invokes "clothPaintToolOff" when the cloth
                paint tool is turned on. Define this callback if your tool
                requires special functionality when your tool is deactivated.
                It is typical that if you implement a toolOffProc you will
                want to implement a toolOnProc as well (see the -toolOnProc
                flag. In query mode, the name of the currently registered MEL
                command is returned and this will be an empty string if none
                is defined.
                Properties: create, query, edit
        toolOnProc (str?): Accepts a strings describing the name of a MEL
                procedure that is invoked whenever the tool is turned on.
                For example, cloth invokes "clothPaintToolOn" when the cloth
                paint tool is turned on. Define this callback if your tool
                requires special functionality when your tool is activated.
                It is typical that if you implement a toolOnProc you will
                want to implement a toolOffProc as well (see the -toolOffProc
                flag. In query mode, the name of the currently registered MEL
                command is returned and this will be an empty string if none
                is defined.
                Properties: create, query, edit
        useColorRamp (bool?): Specifies whether the user defined color ramp should be used to map values
                from to colors.  If this is turned off, the default greyscale feedback
                will be used.
                Properties: create, query, edit
        useMaxMinColor (bool?): Specifies whether the out of range colors should be used.  See rampMinColor
                and rampMaxColor flags for further details.
                Properties: create, query, edit
        usepressure (bool?): Sets the tablet pressure on/off.
                C: Default is false. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        value (float?): Specifies the value for each attribute.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        vertexColorRange (bool?): Specifies whether the vertex color range should be applied
                to the currently selected object.
                C: Default is false  Q: When queried, it returns a boolean.
                Properties: create, query, edit
        vertexColorRangeLower (float?): Specifies the min value of the vertex color range.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        vertexColorRangeUpper (float?): Specifies the max value of the vertex color range.
                C: Default is 1.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        whichTool (str?): The string defines the name of the tool to be
                used for the Artisan context. An example is "artClothPaint".
                In query mode, the tool name for the given context is returned.
                Note: due to the way MEL works, always specify the -query flag
                last when specifying a flag that takes arguments.
                Properties: create, query, edit
        worldRadius (float?): Radius in worldspace
                Properties: create, query, edit

    Returns:
        bool: In query mode, return type is based on queried flag.

    Example:
    """

def artAttrSkinPaintCmd(*args: Any, **kwargs: Any) -> None: ...
def artAttrSkinPaintCtx(*args: Any, accopacity: bool = ..., activeListChangedProc: str = ..., afterStrokeCmd: str = ..., alphaclamp: str = ..., alphaclamplower: float = ..., alphaclampupper: float = ..., attrSelected: str = ..., beforeStrokeCmd: str = ..., brushalignment: bool = ..., brushfeedback: bool = ..., clamp: str = ..., clamplower: float = ..., clampupper: float = ..., clear: bool = ..., colorAlphaValue: float = ..., colorRGBAValue: Tuple[float, float, float, float] = ..., colorRGBValue: Tuple[float, float, float] = ..., colorRamp: str = ..., colorfeedback: bool = ..., colorfeedbackOverride: bool = ..., colorrangelower: float = ..., colorrangeupper: float = ..., dataTypeIndex: int = ..., disablelighting: bool = ..., dragSlider: str = ..., duringStrokeCmd: str = ..., dynclonemode: bool = ..., exists: bool = ..., expandfilename: bool = ..., exportaspectratio: float = ..., exportfilemode: str = ..., exportfilesave: str = ..., exportfilesizex: int = ..., exportfilesizey: int = ..., exportfiletype: str = ..., filterNodes: bool = ..., history: bool = ..., image1: str = ..., image2: str = ..., image3: str = ..., importfileload: str = ..., importfilemode: str = ..., importreassign: bool = ..., influence: str = ..., interactiveUpdate: bool = ..., lastRecorderCmd: str = ..., lastStampName: str = ..., lowerradius: float = ..., makeStroke: Unknown = ..., mappressure: str = ..., maxvalue: float = ..., minvalue: float = ..., name: str = ..., objattrArray: str = ..., opacity: float = ..., outline: bool = ..., outwhilepaint: bool = ..., paintNodeArray: str = ..., paintSelectMode: int = ..., paintattrselected: str = ..., paintmode: str = ..., paintoperationtype: str = ..., pickColor: bool = ..., pickValue: bool = ..., playbackCursor: Tuple[float, float] = ..., playbackPressure: float = ..., preserveclonesource: bool = ..., profileShapeFile: str = ..., projective: bool = ..., radius: float = ..., rampMaxColor: Tuple[float, float, float] = ..., rampMinColor: Tuple[float, float, float] = ..., record: bool = ..., reflection: bool = ..., reflectionaboutorigin: bool = ..., reflectionaxis: str = ..., screenRadius: float = ..., selectclonesource: bool = ..., selectedattroper: str = ..., showactive: bool = ..., skinPaintMode: int = ..., stampDepth: float = ..., stampProfile: str = ..., stampSpacing: float = ..., strokesmooth: str = ..., surfaceConformedBrushVertices: bool = ..., tablet: bool = ..., tangentOutline: bool = ..., toolOffProc: str = ..., toolOnProc: str = ..., useColorRamp: bool = ..., useMaxMinColor: bool = ..., usepressure: bool = ..., value: float = ..., whichTool: str = ..., worldRadius: float = ..., xrayJoints: bool = ...) -> bool:
    """This is a context command to set the flags on the artAttrContext,
    which is the base context for attribute painting operations. All
    commands require the name of the context as the last argument as
    this provides the name of the context to create, edit or query.This is a context command to set the flags on the
    Paint skin weights tool context.
    Args:
        accopacity (bool?): Sets opacity accumulation on/off.
                C: Default is false (Except for sculpt tool for which it is true by default).
                Q: When queried, it returns a boolean.
                Properties: create, query, edit
        activeListChangedProc (str?): Accepts a string that contains a MEL command that is
                invoked whenever the active list changes. There may be some
                situations where the UI, for example, needs to be updated,
                when objects are selected/deselected in the scene. In query
                mode, the name of the currently registered MEL command is
                returned and this will be an empty string if none is defined.
                Properties: create, query, edit
        afterStrokeCmd (str?): The passed string is executed as a MEL command
                immediately after the end of a stroke.
                C: Default is no command. Q: When queried, it returns
                the current command
                Properties: create, query, edit
        alphaclamp (str?): Specifies if the weight value should be alpha clamped to
                the lower and upper bounds. There are four options here:
                "none" - no clamping is performed, "lower" - clamps only to
                the lower bound, "upper" - clamps only to the upper bounds,
                "both" - clamps to the lower and upper bounds.
                C: Default is "none".  Q: When queried, it returns a string.
                Properties: create, query, edit
        alphaclamplower (float?): Specifies the lower bound for the alpha values.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        alphaclampupper (float?): Specifies the upper bound for the alpha values.
                C: Default is 1.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        attrSelected (str?): Returns a name of the currently selected attribute.
                Q: When queried, it returns a string.
                Properties: query
        beforeStrokeCmd (str?): The passed string is executed as a MEL command
                immediately before the start of a stroke.
                C: Default is no command. Q: When queried, it returns the
                current command
                Properties: create, query, edit
        brushalignment (bool?): Specifies the path brush alignemnt. If true,
                the brush will align to stroke path, otherwise it will
                align to up vector.
                C: Default is true. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        brushfeedback (bool?): Specifies if the brush additional feedback should
                be drawn.
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        clamp (str?): Specifies if the weight value should be clamped to
                the lower and upper bounds. There are four options here:
                "none" - no clamping is performed, "lower" - clamps only to
                the lower bound, "upper" - clamps only to the upper bounds,
                "both" - clamps to the lower and upper bounds.
                C: Default is "none".  Q: When queried, it returns a string.
                Properties: create, query, edit
        clamplower (float?): Specifies the lower bound for the values.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        clampupper (float?): Specifies the upper bound for the values.
                C: Default is 1.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        clear (bool?): Floods all cvs/vertices to the current value.
                Properties: create, edit
        colorAlphaValue (float?): The Alpha value of the color.
                Properties: create, query, edit
        colorRGBAValue (Tuple[float, float, float, float]?): The RGBA value of the color.
                Properties: create, query, edit
        colorRGBValue (Tuple[float, float, float]?): The RGB value of the color.
                Properties: create, query, edit
        colorRamp (str?): Allows a user defined color ramp to be used to map values to colors.
                Properties: create, query, edit
        colorfeedback (bool?): Sets on/off the color feedback display.
                C: Default is FALSE.  Q: When queried, it returns a boolean.
                Properties: create, query, edit
        colorfeedbackOverride (bool?): Sets on/off the color feedback override.
                C: Default is FALSE.  Q: When queried, it returns a boolean.
                Properties: create, query, edit
        colorrangelower (float?): Specifies the value that maps to black when
                color feedback mode is on.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        colorrangeupper (float?): Specifies the value that maps to the maximum
                color when color feedback mode is on.
                C: Default is 1.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        dataTypeIndex (int?): When the selected paintable attribute is a vectorArray,
                it specifies which field to paint on.
                Properties: query, edit
        disablelighting (bool?): If color feedback is on, this flag determines whether
                lighting is disabled or not for the surfaces that are
                affected.
                C: Default is FALSE.  Q: When queried, it returns a boolean.
                Properties: create, query, edit
        dragSlider (str?): Sets the current brush drag state for resizing or
                offsetting the brush (like the 'b' and 'm' default hotkeys).
                The string argument is one of: "radius", "lowradius",
                "opacity", "value", "depth", "displacement", "uvvector"
                or "none".
                C: Default is "none".
                Properties: create, edit
        duringStrokeCmd (str?): The passed string is executed as a MEL command
                during the stroke, each time the mouse is dragged.
                C: Default is no command. Q: When queried, it returns
                the current command
                Properties: create, query, edit
        dynclonemode (bool?): Enable or disable dynamic clone mode.
                Properties: create, query, edit
        exists (bool?): Returns true or false depending upon whether the
                specified object exists. Other flags are ignored.
                Properties: create
        expandfilename (bool?): If true, it will expand the name of the export file
                and concatenate it with the surface name. Otherwise it
                will take the name as it is.
                C: Default is true.
                Properties: create, edit
        exportaspectratio (float?): Value of aspect ratio for export
                Properties: create, query, edit
        exportfilemode (str?): Specifies the export channel.The valid
                entries here are: "alpha", "luminance", "rgb", "rgba".
                C: Default is "luminance/rgb".
                Q: When queried, it returns a string.
                Properties: create, query, edit
        exportfilesave (str?): Exports the attribute map and saves to a specified file.
                Properties: edit
        exportfilesizex (int?): Specifies the width of the attribute map to export.
                C: Default width is 256. Q: When queried, it returns an integer.
                Properties: create, query, edit
        exportfilesizey (int?): Specifies the width of the attribute map to export.
                C: Default width is 256. Q: When queried, it returns an integer.
                Properties: create, query, edit
        exportfiletype (str?): Specifies the image file format. It can be one of
                the following: "iff", "tiff", "jpeg", "alias", "rgb", "fit"
                "postScriptEPS", "softimage", "wavefrontRLA", "wavefrontEXP".
                C: default is tiff. Q: When queried, it returns a string.
                Properties: create, query, edit
        filterNodes (bool?): Sets the node filter.
                Properties: edit
        history (bool?): If this is a tool command, turn the construction history on
                for the tool in question.
                Properties: create
        image1 (str?): First of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        image2 (str?): Second of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        image3 (str?): Third of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        importfileload (str?): Load the attribute map a specified file.
                Properties: edit
        importfilemode (str?): Specifies the channel to import. The valid
                entries here are: "alpha", "luminance", "red", "green",
                "blue", and "rgb"
                C: Default is "alpha". Q: When queried, it returns a string.
                Properties: create, query, edit
        importreassign (bool?): Specifies if the multiply atrribute maps are to be
                reassigned while importing. Only maps previously exported from
                within Artisan can be reassigned.
                C: Default is FALSE. Q: When queried, it returns a  boolean.
                Properties: create, query, edit
        influence (str?): Specifies which joint has been selected by the user for painting.
                Q: When queried, it returns a string.
                Properties: query, edit
        interactiveUpdate (bool?): Specifies how often to transfer the painted values
                into the attribute.
                TRUE: transfer them "continuously" (many times per stroke)
                FALSE: transfer them only at the end of a stroke (on mouse
                button release).
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        lastRecorderCmd (str?): Value of last recorded command.
                Properties: create, query, edit
        lastStampName (str?): Value of the last stamp name.
                Properties: create, query, edit
        lowerradius (float?): Sets the lower size of the brush (only apply on tablet).
                Properties: create, query, edit
        makeStroke (Unknown?): Stroke point values.
                Properties: create, query, edit, multiuse
        mappressure (str?): Sets the tablet pressure mapping when the table
                is used. There are three options:
                "Opacity" - the pressure is mapped to the opacity,
                "Radius" - the is mapped to modify the radius of the brush,
                "Both" - the pressure modifies both the opacity and the radius.
                C: Default is "Opacity". Q: When queried, it returns a string.
                Properties: create, query, edit
        maxvalue (float?): Specifies the maximum value for each attribute.
                C: Default is 1.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        minvalue (float?): Specifies the minimum value for each attribute.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        name (str?): If this is a tool command, name the tool appropriately.
                Properties: create
        objattrArray (str?): An array of all paintable attributes. Each element of
                the array is a string with the following information:
                NodeType.NodeName.AttributeName.MenuType.
                *MenuType: type (level) of the item in the Menu (UI).
                Q: When queried, it returns a string.
                Properties: query
        opacity (float?): Sets the brush opacity.
                C: Default is 1.0. Q: When queried, it returns a float.
                Properties: create, query, edit
        outline (bool?): Specifies if the brush should be drawn.
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        outwhilepaint (bool?): Specifies if the brush outline should be drawn
                while painting.
                C: Default is FALSE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        paintNodeArray (str?): An array of paintable nodes.
                Q: When queried, it returns a string.
                Properties: query
        paintSelectMode (int?): Specifies whether the paint select tool: adds to selection (1)
                removes from selection (2), toggles selection (3)
                Q: When queried, it returns an int as defined above.
                Properties: query, edit
        paintattrselected (str?): An array of selected paintable attributes.
                Each element of the array is a string with the
                following information:
                NodeType.NodeName.AttributeName.
                Properties: edit
        paintmode (str?): Specifies the paint mode. There are two
                possibilities: "screen" and "tangent".
                C: Default is "screen". Q: When queried, it returns a string.
                Properties: create, query, edit
        paintoperationtype (str?): Specifies the operation type used by the
                Paint Tool.  Currently, we support the following
                paint modes: "Paint", "Smear", "Blur", "Erase"
                and "Clone".
                Default is "Paint".
                Properties: create, query, edit
        pickColor (bool?): Set pick color mode on or off
                Properties: create, query, edit
        pickValue (bool?): Toggle for picking
                Properties: create, query, edit
        playbackCursor (Tuple[float, float]?): Values for the playback cursor.
                Properties: create, query, edit, multiuse
        playbackPressure (float?): Valus for the playback pressure.
                Properties: create, query, edit, multiuse
        preserveclonesource (bool?): Whether or not to preserve a clone source.
                Properties: create, query, edit
        profileShapeFile (str?): Passes a name of the image file for the stamp shape
                profile.
                Properties: query, edit
        projective (bool?): Specifies the projective paint mode.
                C: Default is 'false'. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        radius (float?): Sets the size of the brush.
                C: Default is 1.0 cm. Q: When queried, it returns a float.
                Properties: create, query, edit
        rampMaxColor (Tuple[float, float, float]?): Defines a special color to be used when the value is greater than or equal to
                the maximum value.
                Properties: create, query, edit
        rampMinColor (Tuple[float, float, float]?): Defines a special color to be used when the value is less than or equal to the
                minimum value.
                Properties: create, query, edit
        record (bool?): Toggle on for recording.
                Properties: create, query, edit
        reflection (bool?): Specifies the reflection mode.
                C: Default is 'false'. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        reflectionaboutorigin (bool?): Toggle on to reflect about the origin
                Properties: create, query, edit
        reflectionaxis (str?): Specifies the reflection axis. There are three
                possibilities: "x", "y" and "z".
                C: Default is "x". Q: When queried, it returns a string.
                Properties: create, query, edit
        screenRadius (float?): Brush radius on the screen
                Properties: create, query, edit
        selectclonesource (bool?): Toggle on to select the clone source
                Properties: create, query, edit
        selectedattroper (str?): Sets the edit weight operation. Four edit weights
                operations are provided : "absolute" - the value of the weight
                is replaced by the current one, "additive" - the value of the
                weight is added to the current one, "scale" - the value of the
                weight is multiplied by the current one, "smooth" - the value
                of the weight is divided by the current one.
                C: Default is "absolute".  Q: When queried, it returns a string.
                Properties: create, query, edit
        showactive (bool?): Sets on/off the display of the surface isoparms.
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        skinPaintMode (int?): Specifies whether the skin paint tool is in paint skin weights mode (1)
                Marquee select mode (0), or paint select mode (2)
                Q: When queried, it returns an int as defined above.
                Properties: query, edit
        stampDepth (float?): Depth of the stamps
                Properties: create, query, edit
        stampProfile (str?): Sets the brush profile of the current stamp.
                Currently, the following profiles are supported:
                "gaussian", "poly", "solid" and "square".
                C: Default is gaussian. Q: When queried, it returns a string.
                Properties: create, query, edit
        stampSpacing (float?): Specifies the stamp spacing. Default is 1.0.
                Properties: create, query, edit
        strokesmooth (str?): Stroke smoothing type name
                Properties: create, query, edit
        surfaceConformedBrushVertices (bool?): Enables/disables the the display of the effective brush area
                as affected vertices.
                Properties: create, query, edit
        tablet (bool?): Returns true if the tablet device is present, false if it is absent
                Properties: query
        tangentOutline (bool?): Enables/disables the display of the brush circle tangent to
                the surface.
                Properties: create, query, edit
        toolOffProc (str?): Accepts a strings describing the name of a MEL
                procedure that is invoked whenever the tool is turned off.
                For example, cloth invokes "clothPaintToolOff" when the cloth
                paint tool is turned on. Define this callback if your tool
                requires special functionality when your tool is deactivated.
                It is typical that if you implement a toolOffProc you will
                want to implement a toolOnProc as well (see the -toolOnProc
                flag. In query mode, the name of the currently registered MEL
                command is returned and this will be an empty string if none
                is defined.
                Properties: create, query, edit
        toolOnProc (str?): Accepts a strings describing the name of a MEL
                procedure that is invoked whenever the tool is turned on.
                For example, cloth invokes "clothPaintToolOn" when the cloth
                paint tool is turned on. Define this callback if your tool
                requires special functionality when your tool is activated.
                It is typical that if you implement a toolOnProc you will
                want to implement a toolOffProc as well (see the -toolOffProc
                flag. In query mode, the name of the currently registered MEL
                command is returned and this will be an empty string if none
                is defined.
                Properties: create, query, edit
        useColorRamp (bool?): Specifies whether the user defined color ramp should be used to map values
                from to colors.  If this is turned off, the default greyscale feedback
                will be used.
                Properties: create, query, edit
        useMaxMinColor (bool?): Specifies whether the out of range colors should be used.  See rampMinColor
                and rampMaxColor flags for further details.
                Properties: create, query, edit
        usepressure (bool?): Sets the tablet pressure on/off.
                C: Default is false. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        value (float?): Specifies the value for each attribute.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        whichTool (str?): The string defines the name of the tool to be
                used for the Artisan context. An example is "artClothPaint".
                In query mode, the tool name for the given context is returned.
                Note: due to the way MEL works, always specify the -query flag
                last when specifying a flag that takes arguments.
                Properties: create, query, edit
        worldRadius (float?): Radius in worldspace
                Properties: create, query, edit
        xrayJoints (bool?): Specifies whether joints should be displayed in xray mode while painting
                Q: When queried, it returns a boolean.
                Properties: query, edit

    Returns:
        bool: In query mode, return type is based on queried flag.

    Example:
    """

def artAttrTool(*args: Any, add: str = ..., exists: str = ..., remove: str = ...) -> bool:
    """The artAttrTool command manages the list of tool types which are
            used for attribute painting. This command supports querying the
            list contents as well as adding new tools to the list. Note that
            there is a set of built-in tools. The list of built-ins can
            be queried by starting Maya and doing an "artAttrTool -q".The tools which are managed by this command are all intended for
            attribute painting via Artisan: when you create a new context via
            artAttrCtx you specify the tool name via artAttrCtx'sflag. Typically the user may wish to simply use one of the built-in
            tools. However, if you need to have custom Properties and Values sheets
            asscociated with your tool, you will need to define a custom tool
            via. For an example of a custom
            attribute painting tool, see the devkit example customtoolPaint.mel.artisan, attribute, paint, context
    Args:
        add (str?): Adds the named tool to the internal list of tools.
                Properties: create
        exists (str?): Checks if the named tool exists, returning true if found, and false otherwise.
                Properties: create, query
        remove (str?): Removes the named tool from the internal list of tools.
                Properties: create

    Returns:
        bool: In query mode, return type is based on queried flag.

    Example:
    """

def artBaseCtx(*args: Any, **kwargs: Any) -> None: ...
def artBuildPaintMenu(*args: str) -> bool:
    """??polygons
    Returns:
        bool:

    Example:
    """

def artFluidAttr(*args: Any, **kwargs: Any) -> None: ...
def artFluidAttrCtx(*args: Any, accopacity: bool = ..., activeListChangedProc: str = ..., afterStrokeCmd: str = ..., alphaclamp: str = ..., alphaclamplower: float = ..., alphaclampupper: float = ..., attrSelected: str = ..., autoSave: str = ..., beforeStrokeCmd: str = ..., brushalignment: bool = ..., brushfeedback: bool = ..., clamp: str = ..., clamplower: float = ..., clampupper: float = ..., clear: bool = ..., colorAlphaValue: float = ..., colorRGBAValue: Tuple[float, float, float, float] = ..., colorRGBValue: Tuple[float, float, float] = ..., colorRamp: str = ..., colorfeedback: bool = ..., colorfeedbackOverride: bool = ..., colorrangelower: float = ..., colorrangeupper: float = ..., currentPaintableFluid: str = ..., dataTypeIndex: int = ..., delaySelectionChanged: bool = ..., disablelighting: bool = ..., displayAsRender: bool = ..., displayVelocity: bool = ..., doAutoSave: bool = ..., dragSlider: str = ..., duringStrokeCmd: str = ..., dynclonemode: bool = ..., exists: bool = ..., expandfilename: bool = ..., exportaspectratio: float = ..., exportfilemode: str = ..., exportfilesave: str = ..., exportfilesizex: int = ..., exportfilesizey: int = ..., exportfiletype: str = ..., filterNodes: bool = ..., history: bool = ..., image1: str = ..., image2: str = ..., image3: str = ..., importfileload: str = ..., importfilemode: str = ..., importreassign: bool = ..., interactiveUpdate: bool = ..., lastRecorderCmd: str = ..., lastStampName: str = ..., lowerradius: float = ..., makeStroke: Unknown = ..., mappressure: str = ..., maxvalue: float = ..., minvalue: float = ..., name: str = ..., objattrArray: str = ..., opacity: float = ..., outline: bool = ..., outwhilepaint: bool = ..., paintNodeArray: str = ..., paintattrselected: str = ..., paintmode: str = ..., paintoperationtype: str = ..., pickColor: bool = ..., pickValue: bool = ..., playbackCursor: Tuple[float, float] = ..., playbackPressure: float = ..., preserveclonesource: bool = ..., profileShapeFile: str = ..., projective: bool = ..., property: str = ..., radius: float = ..., rampMaxColor: Tuple[float, float, float] = ..., rampMinColor: Tuple[float, float, float] = ..., record: bool = ..., reflection: bool = ..., reflectionaboutorigin: bool = ..., reflectionaxis: str = ..., rgbValue: Tuple[float, float, float] = ..., screenRadius: float = ..., selectclonesource: bool = ..., selectedattroper: str = ..., showactive: bool = ..., stampDepth: float = ..., stampProfile: str = ..., stampSpacing: float = ..., strokesmooth: str = ..., surfaceConformedBrushVertices: bool = ..., tablet: bool = ..., tangentOutline: bool = ..., toolOffProc: str = ..., toolOnProc: str = ..., useColorRamp: bool = ..., useMaxMinColor: bool = ..., useStrokeDirection: bool = ..., usepressure: bool = ..., value: float = ..., velocity: Tuple[float, float, float] = ..., whichTool: str = ..., worldRadius: float = ...) -> bool:
    """This is a context command to set the flags on the artAttrContext,
    which is the base context for attribute painting operations. All
    commands require the name of the context as the last argument as
    this provides the name of the context to create, edit or query.This command is used to paint properties
    (such as density) of selected fluid volumes.
    Args:
        accopacity (bool?): Sets opacity accumulation on/off.
                C: Default is false (Except for sculpt tool for which it is true by default).
                Q: When queried, it returns a boolean.
                Properties: create, query, edit
        activeListChangedProc (str?): Accepts a string that contains a MEL command that is
                invoked whenever the active list changes. There may be some
                situations where the UI, for example, needs to be updated,
                when objects are selected/deselected in the scene. In query
                mode, the name of the currently registered MEL command is
                returned and this will be an empty string if none is defined.
                Properties: create, query, edit
        afterStrokeCmd (str?): The passed string is executed as a MEL command
                immediately after the end of a stroke.
                C: Default is no command. Q: When queried, it returns
                the current command
                Properties: create, query, edit
        alphaclamp (str?): Specifies if the weight value should be alpha clamped to
                the lower and upper bounds. There are four options here:
                "none" - no clamping is performed, "lower" - clamps only to
                the lower bound, "upper" - clamps only to the upper bounds,
                "both" - clamps to the lower and upper bounds.
                C: Default is "none".  Q: When queried, it returns a string.
                Properties: create, query, edit
        alphaclamplower (float?): Specifies the lower bound for the alpha values.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        alphaclampupper (float?): Specifies the upper bound for the alpha values.
                C: Default is 1.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        attrSelected (str?): Returns a name of the currently selected attribute.
                Q: When queried, it returns a string.
                Properties: query
        autoSave (str?): A MEL command to save the fluid state.  Called
                before an event which could overwrite unsaved values of
                painted fluid properties.  Such events include: changing
                current time, changing the current paintable property, and
                exiting the paint tool.  (To turn auto-save off, pass in
                an empty-valued string argument: e.g., "".)
                Properties: create, query, edit
        beforeStrokeCmd (str?): The passed string is executed as a MEL command
                immediately before the start of a stroke.
                C: Default is no command. Q: When queried, it returns the
                current command
                Properties: create, query, edit
        brushalignment (bool?): Specifies the path brush alignemnt. If true,
                the brush will align to stroke path, otherwise it will
                align to up vector.
                C: Default is true. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        brushfeedback (bool?): Specifies if the brush additional feedback should
                be drawn.
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        clamp (str?): Specifies if the weight value should be clamped to
                the lower and upper bounds. There are four options here:
                "none" - no clamping is performed, "lower" - clamps only to
                the lower bound, "upper" - clamps only to the upper bounds,
                "both" - clamps to the lower and upper bounds.
                C: Default is "none".  Q: When queried, it returns a string.
                Properties: create, query, edit
        clamplower (float?): Specifies the lower bound for the values.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        clampupper (float?): Specifies the upper bound for the values.
                C: Default is 1.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        clear (bool?): Floods all cvs/vertices to the current value.
                Properties: create, edit
        colorAlphaValue (float?): The Alpha value of the color.
                Properties: create, query, edit
        colorRGBAValue (Tuple[float, float, float, float]?): The RGBA value of the color.
                Properties: create, query, edit
        colorRGBValue (Tuple[float, float, float]?): The RGB value of the color.
                Properties: create, query, edit
        colorRamp (str?): Allows a user defined color ramp to be used to map values to colors.
                Properties: create, query, edit
        colorfeedback (bool?): Sets on/off the color feedback display.
                C: Default is FALSE.  Q: When queried, it returns a boolean.
                Properties: create, query, edit
        colorfeedbackOverride (bool?): Sets on/off the color feedback override.
                C: Default is FALSE.  Q: When queried, it returns a boolean.
                Properties: create, query, edit
        colorrangelower (float?): Specifies the value that maps to black when
                color feedback mode is on.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        colorrangeupper (float?): Specifies the value that maps to the maximum
                color when color feedback mode is on.
                C: Default is 1.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        currentPaintableFluid (str?): Query the name of the fluid on which this context is
                currently painting.  Returns string.
                Properties: query
        dataTypeIndex (int?): When the selected paintable attribute is a vectorArray,
                it specifies which field to paint on.
                Properties: query, edit
        delaySelectionChanged (bool?): Internal use only.  Under normal conditions,
                the tool responds to changes to the selection list so it
                can update its list of paintable geometry.  When
                -dsl true is used, the tool will not update its paintable
                list until a corresponding -dsl false is called.
                Properties: create, query, edit
        disablelighting (bool?): If color feedback is on, this flag determines whether
                lighting is disabled or not for the surfaces that are
                affected.
                C: Default is FALSE.  Q: When queried, it returns a boolean.
                Properties: create, query, edit
        displayAsRender (bool?): When true, sets the "Shaded Display" attribute
                of the fluid to "AsRender": all fluid properties displayed
                as hardware rendered.  When false, displays only the
                currently selected paintable attribute of the fluid.
                Properties: create, query, edit
        displayVelocity (bool?): Turns on/off velocity display, independently of the
                above "dar/displayAsRender" setting.  Use this flag
                to enable velocity display while only displaying density, for
                example.
                Properties: create, query, edit
        doAutoSave (bool?): Execute the -autoSave command if there are
                unsaved painted fluid properties.
                Properties: edit
        dragSlider (str?): Sets the current brush drag state for resizing or
                offsetting the brush (like the 'b' and 'm' default hotkeys).
                The string argument is one of: "radius", "lowradius",
                "opacity", "value", "depth", "displacement", "uvvector"
                or "none".
                C: Default is "none".
                Properties: create, edit
        duringStrokeCmd (str?): The passed string is executed as a MEL command
                during the stroke, each time the mouse is dragged.
                C: Default is no command. Q: When queried, it returns
                the current command
                Properties: create, query, edit
        dynclonemode (bool?): Enable or disable dynamic clone mode.
                Properties: create, query, edit
        exists (bool?): Returns true or false depending upon whether the
                specified object exists. Other flags are ignored.
                Properties: create
        expandfilename (bool?): If true, it will expand the name of the export file
                and concatenate it with the surface name. Otherwise it
                will take the name as it is.
                C: Default is true.
                Properties: create, edit
        exportaspectratio (float?): Value of aspect ratio for export
                Properties: create, query, edit
        exportfilemode (str?): Specifies the export channel.The valid
                entries here are: "alpha", "luminance", "rgb", "rgba".
                C: Default is "luminance/rgb".
                Q: When queried, it returns a string.
                Properties: create, query, edit
        exportfilesave (str?): Exports the attribute map and saves to a specified file.
                Properties: edit
        exportfilesizex (int?): Specifies the width of the attribute map to export.
                C: Default width is 256. Q: When queried, it returns an integer.
                Properties: create, query, edit
        exportfilesizey (int?): Specifies the width of the attribute map to export.
                C: Default width is 256. Q: When queried, it returns an integer.
                Properties: create, query, edit
        exportfiletype (str?): Specifies the image file format. It can be one of
                the following: "iff", "tiff", "jpeg", "alias", "rgb", "fit"
                "postScriptEPS", "softimage", "wavefrontRLA", "wavefrontEXP".
                C: default is tiff. Q: When queried, it returns a string.
                Properties: create, query, edit
        filterNodes (bool?): Sets the node filter.
                Properties: edit
        history (bool?): If this is a tool command, turn the construction history on
                for the tool in question.
                Properties: create
        image1 (str?): First of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        image2 (str?): Second of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        image3 (str?): Third of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        importfileload (str?): Load the attribute map a specified file.
                Properties: edit
        importfilemode (str?): Specifies the channel to import. The valid
                entries here are: "alpha", "luminance", "red", "green",
                "blue", and "rgb"
                C: Default is "alpha". Q: When queried, it returns a string.
                Properties: create, query, edit
        importreassign (bool?): Specifies if the multiply atrribute maps are to be
                reassigned while importing. Only maps previously exported from
                within Artisan can be reassigned.
                C: Default is FALSE. Q: When queried, it returns a  boolean.
                Properties: create, query, edit
        interactiveUpdate (bool?): Specifies how often to transfer the painted values
                into the attribute.
                TRUE: transfer them "continuously" (many times per stroke)
                FALSE: transfer them only at the end of a stroke (on mouse
                button release).
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        lastRecorderCmd (str?): Value of last recorded command.
                Properties: create, query, edit
        lastStampName (str?): Value of the last stamp name.
                Properties: create, query, edit
        lowerradius (float?): Sets the lower size of the brush (only apply on tablet).
                Properties: create, query, edit
        makeStroke (Unknown?): Stroke point values.
                Properties: create, query, edit, multiuse
        mappressure (str?): Sets the tablet pressure mapping when the table
                is used. There are three options:
                "Opacity" - the pressure is mapped to the opacity,
                "Radius" - the is mapped to modify the radius of the brush,
                "Both" - the pressure modifies both the opacity and the radius.
                C: Default is "Opacity". Q: When queried, it returns a string.
                Properties: create, query, edit
        maxvalue (float?): Specifies the maximum value for each attribute.
                C: Default is 1.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        minvalue (float?): Specifies the minimum value for each attribute.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        name (str?): If this is a tool command, name the tool appropriately.
                Properties: create
        objattrArray (str?): An array of all paintable attributes. Each element of
                the array is a string with the following information:
                NodeType.NodeName.AttributeName.MenuType.
                *MenuType: type (level) of the item in the Menu (UI).
                Q: When queried, it returns a string.
                Properties: query
        opacity (float?): Sets the brush opacity.
                C: Default is 1.0. Q: When queried, it returns a float.
                Properties: create, query, edit
        outline (bool?): Specifies if the brush should be drawn.
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        outwhilepaint (bool?): Specifies if the brush outline should be drawn
                while painting.
                C: Default is FALSE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        paintNodeArray (str?): An array of paintable nodes.
                Q: When queried, it returns a string.
                Properties: query
        paintattrselected (str?): An array of selected paintable attributes.
                Each element of the array is a string with the
                following information:
                NodeType.NodeName.AttributeName.
                Properties: edit
        paintmode (str?): Specifies the paint mode. There are two
                possibilities: "screen" and "tangent".
                C: Default is "screen". Q: When queried, it returns a string.
                Properties: create, query, edit
        paintoperationtype (str?): Specifies the operation type used by the
                Paint Tool.  Currently, we support the following
                paint modes: "Paint", "Smear", "Blur", "Erase"
                and "Clone".
                Default is "Paint".
                Properties: create, query, edit
        pickColor (bool?): Set pick color mode on or off
                Properties: create, query, edit
        pickValue (bool?): Toggle for picking
                Properties: create, query, edit
        playbackCursor (Tuple[float, float]?): Values for the playback cursor.
                Properties: create, query, edit, multiuse
        playbackPressure (float?): Valus for the playback pressure.
                Properties: create, query, edit, multiuse
        preserveclonesource (bool?): Whether or not to preserve a clone source.
                Properties: create, query, edit
        profileShapeFile (str?): Passes a name of the image file for the stamp shape
                profile.
                Properties: query, edit
        projective (bool?): Specifies the projective paint mode.
                C: Default is 'false'. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        property (str?): Specifies a property to paint on the fluid.
                Valid values are "color", "density", "densityAndColor,"
                "densityAndFuel," "temperature," "fuel", "velocity".
                Properties: create, query, edit
        radius (float?): Sets the size of the brush.
                C: Default is 1.0 cm. Q: When queried, it returns a float.
                Properties: create, query, edit
        rampMaxColor (Tuple[float, float, float]?): Defines a special color to be used when the value is greater than or equal to
                the maximum value.
                Properties: create, query, edit
        rampMinColor (Tuple[float, float, float]?): Defines a special color to be used when the value is less than or equal to the
                minimum value.
                Properties: create, query, edit
        record (bool?): Toggle on for recording.
                Properties: create, query, edit
        reflection (bool?): Specifies the reflection mode.
                C: Default is 'false'. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        reflectionaboutorigin (bool?): Toggle on to reflect about the origin
                Properties: create, query, edit
        reflectionaxis (str?): Specifies the reflection axis. There are three
                possibilities: "x", "y" and "z".
                C: Default is "x". Q: When queried, it returns a string.
                Properties: create, query, edit
        rgbValue (Tuple[float, float, float]?): Specifies the values of the red, green, and
                blue components of the color to
                use when painting the property "color."
                Properties: create, query, edit
        screenRadius (float?): Brush radius on the screen
                Properties: create, query, edit
        selectclonesource (bool?): Toggle on to select the clone source
                Properties: create, query, edit
        selectedattroper (str?): Sets the edit weight operation. Four edit weights
                operations are provided : "absolute" - the value of the weight
                is replaced by the current one, "additive" - the value of the
                weight is added to the current one, "scale" - the value of the
                weight is multiplied by the current one, "smooth" - the value
                of the weight is divided by the current one.
                C: Default is "absolute".  Q: When queried, it returns a string.
                Properties: create, query, edit
        showactive (bool?): Sets on/off the display of the surface isoparms.
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        stampDepth (float?): Depth of the stamps
                Properties: create, query, edit
        stampProfile (str?): Sets the brush profile of the current stamp.
                Currently, the following profiles are supported:
                "gaussian", "poly", "solid" and "square".
                C: Default is gaussian. Q: When queried, it returns a string.
                Properties: create, query, edit
        stampSpacing (float?): Specifies the stamp spacing. Default is 1.0.
                Properties: create, query, edit
        strokesmooth (str?): Stroke smoothing type name
                Properties: create, query, edit
        surfaceConformedBrushVertices (bool?): Enables/disables the the display of the effective brush area
                as affected vertices.
                Properties: create, query, edit
        tablet (bool?): Returns true if the tablet device is present, false if it is absent
                Properties: query
        tangentOutline (bool?): Enables/disables the display of the brush circle tangent to
                the surface.
                Properties: create, query, edit
        toolOffProc (str?): Accepts a strings describing the name of a MEL
                procedure that is invoked whenever the tool is turned off.
                For example, cloth invokes "clothPaintToolOff" when the cloth
                paint tool is turned on. Define this callback if your tool
                requires special functionality when your tool is deactivated.
                It is typical that if you implement a toolOffProc you will
                want to implement a toolOnProc as well (see the -toolOnProc
                flag. In query mode, the name of the currently registered MEL
                command is returned and this will be an empty string if none
                is defined.
                Properties: create, query, edit
        toolOnProc (str?): Accepts a strings describing the name of a MEL
                procedure that is invoked whenever the tool is turned on.
                For example, cloth invokes "clothPaintToolOn" when the cloth
                paint tool is turned on. Define this callback if your tool
                requires special functionality when your tool is activated.
                It is typical that if you implement a toolOnProc you will
                want to implement a toolOffProc as well (see the -toolOffProc
                flag. In query mode, the name of the currently registered MEL
                command is returned and this will be an empty string if none
                is defined.
                Properties: create, query, edit
        useColorRamp (bool?): Specifies whether the user defined color ramp should be used to map values
                from to colors.  If this is turned off, the default greyscale feedback
                will be used.
                Properties: create, query, edit
        useMaxMinColor (bool?): Specifies whether the out of range colors should be used.  See rampMinColor
                and rampMaxColor flags for further details.
                Properties: create, query, edit
        useStrokeDirection (bool?): Applicable only during "velocity"
                painting.  Specifies whether the value of the
                painted velocity should come from the direction
                of the brush stroke, overriding the value specified
                by the -v/-velocity flag.
                Properties: create, query, edit
        usepressure (bool?): Sets the tablet pressure on/off.
                C: Default is false. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        value (float?): Specifies the value for each attribute.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        velocity (Tuple[float, float, float]?): Specifies the values of the x, y, and z
                components of the velocity to use when painting the property
                "velocity".
                Properties: create, query, edit
        whichTool (str?): The string defines the name of the tool to be
                used for the Artisan context. An example is "artClothPaint".
                In query mode, the tool name for the given context is returned.
                Note: due to the way MEL works, always specify the -query flag
                last when specifying a flag that takes arguments.
                Properties: create, query, edit
        worldRadius (float?): Radius in worldspace
                Properties: create, query, edit

    Returns:
        bool: In query mode, return type is based on queried flag.

    Example:
    """

def artPuttyCtx(*args: Any, accopacity: bool = ..., activeListChangedProc: str = ..., afterStrokeCmd: str = ..., alphaclamp: str = ..., alphaclamplower: float = ..., alphaclampupper: float = ..., attrSelected: str = ..., autosmooth: bool = ..., beforeStrokeCmd: str = ..., brushStrength: float = ..., brushalignment: bool = ..., brushfeedback: bool = ..., clamp: str = ..., clamplower: float = ..., clampupper: float = ..., clear: bool = ..., collapsecvtol: float = ..., colorAlphaValue: float = ..., colorRGBAValue: Tuple[float, float, float, float] = ..., colorRGBValue: Tuple[float, float, float] = ..., colorRamp: str = ..., colorfeedback: bool = ..., colorfeedbackOverride: bool = ..., colorrangelower: float = ..., colorrangeupper: float = ..., dataTypeIndex: int = ..., disablelighting: bool = ..., dispdecr: bool = ..., dispincr: bool = ..., dragSlider: str = ..., duringStrokeCmd: str = ..., dynclonemode: bool = ..., erasesrfupd: bool = ..., exists: bool = ..., expandfilename: bool = ..., exportaspectratio: float = ..., exportfilemode: str = ..., exportfilesave: str = ..., exportfilesizex: int = ..., exportfilesizey: int = ..., exportfiletype: str = ..., filterNodes: bool = ..., history: bool = ..., image1: str = ..., image2: str = ..., image3: str = ..., importfileload: str = ..., importfilemode: str = ..., importreassign: bool = ..., interactiveUpdate: bool = ..., invertrefvector: bool = ..., lastRecorderCmd: str = ..., lastStampName: str = ..., lowerradius: float = ..., makeStroke: Unknown = ..., mappressure: str = ..., maxdisp: float = ..., maxvalue: float = ..., minvalue: float = ..., mouldtypehead: str = ..., mouldtypemouse: str = ..., mouldtypetail: str = ..., name: str = ..., objattrArray: str = ..., opacity: float = ..., outline: bool = ..., outwhilepaint: bool = ..., paintNodeArray: str = ..., paintattrselected: str = ..., paintmode: str = ..., paintoperationtype: str = ..., pickColor: bool = ..., pickValue: bool = ..., playbackCursor: Tuple[float, float] = ..., playbackPressure: float = ..., polecv: bool = ..., preserveclonesource: bool = ..., profileShapeFile: str = ..., projective: bool = ..., radius: float = ..., rampMaxColor: Tuple[float, float, float] = ..., rampMinColor: Tuple[float, float, float] = ..., record: bool = ..., reflection: bool = ..., reflectionaboutorigin: bool = ..., reflectionaxis: str = ..., refsurface: bool = ..., refvector: str = ..., refvectoru: float = ..., refvectorv: float = ..., screenRadius: float = ..., selectclonesource: bool = ..., selectedattroper: str = ..., showactive: bool = ..., smoothiters: int = ..., stampDepth: float = ..., stampProfile: str = ..., stampSpacing: float = ..., stitchcorner: bool = ..., stitchedgeflood: bool = ..., stitchtype: str = ..., strokesmooth: str = ..., surfaceConformedBrushVertices: bool = ..., tablet: bool = ..., tangentOutline: bool = ..., toolOffProc: str = ..., toolOnProc: str = ..., updateerasesrf: bool = ..., updaterefsrf: bool = ..., useColorRamp: bool = ..., useMaxMinColor: bool = ..., usepressure: bool = ..., value: float = ..., whichTool: str = ..., worldRadius: float = ...) -> bool:
    """This is a context command to set the flags on the artAttrContext,
    which is the base context for attribute painting operations. All
    commands require the name of the context as the last argument as
    this provides the name of the context to create, edit or query.This command is used to modify NURBS surfaces using a brush based
    interface (Maya Artisan). This is accomplished by moving the control
    vertices (CVs) under the brush in the specified direction.
    Args:
        accopacity (bool?): Sets opacity accumulation on/off.
                C: Default is false (Except for sculpt tool for which it is true by default).
                Q: When queried, it returns a boolean.
                Properties: create, query, edit
        activeListChangedProc (str?): Accepts a string that contains a MEL command that is
                invoked whenever the active list changes. There may be some
                situations where the UI, for example, needs to be updated,
                when objects are selected/deselected in the scene. In query
                mode, the name of the currently registered MEL command is
                returned and this will be an empty string if none is defined.
                Properties: create, query, edit
        afterStrokeCmd (str?): The passed string is executed as a MEL command
                immediately after the end of a stroke.
                C: Default is no command. Q: When queried, it returns
                the current command
                Properties: create, query, edit
        alphaclamp (str?): Specifies if the weight value should be alpha clamped to
                the lower and upper bounds. There are four options here:
                "none" - no clamping is performed, "lower" - clamps only to
                the lower bound, "upper" - clamps only to the upper bounds,
                "both" - clamps to the lower and upper bounds.
                C: Default is "none".  Q: When queried, it returns a string.
                Properties: create, query, edit
        alphaclamplower (float?): Specifies the lower bound for the alpha values.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        alphaclampupper (float?): Specifies the upper bound for the alpha values.
                C: Default is 1.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        attrSelected (str?): Returns a name of the currently selected attribute.
                Q: When queried, it returns a string.
                Properties: query
        autosmooth (bool?): Sets up the auto smoothing option. When the brush
                is in the smooth mode, adjusting the strength will adjust how
                fast the surfaces is smoothed out.
                C: Default is FALSE.  Q: When queried, it returns a boolean.
                Properties: create, query, edit
        beforeStrokeCmd (str?): The passed string is executed as a MEL command
                immediately before the start of a stroke.
                C: Default is no command. Q: When queried, it returns the
                current command
                Properties: create, query, edit
        brushStrength (float?): Sets the strength of the brush. Brush strength is supported
                by the pinch and slide brushes. In pinch mode, adjusting the strength
                will adjust how quickly the surface converges on the brush
                center. In slide mode, the strength scales the motion of the brush.
                C: Default is 1.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        brushalignment (bool?): Specifies the path brush alignemnt. If true,
                the brush will align to stroke path, otherwise it will
                align to up vector.
                C: Default is true. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        brushfeedback (bool?): Specifies if the brush additional feedback should
                be drawn.
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        clamp (str?): Specifies if the weight value should be clamped to
                the lower and upper bounds. There are four options here:
                "none" - no clamping is performed, "lower" - clamps only to
                the lower bound, "upper" - clamps only to the upper bounds,
                "both" - clamps to the lower and upper bounds.
                C: Default is "none".  Q: When queried, it returns a string.
                Properties: create, query, edit
        clamplower (float?): Specifies the lower bound for the values.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        clampupper (float?): Specifies the upper bound for the values.
                C: Default is 1.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        clear (bool?): Floods all cvs/vertices to the current value.
                Properties: create, edit
        collapsecvtol (float?): Specifies the tolerance for the collapse cv detection.
                C: Default is 0.005 cm.  Q: When queried, it returns a float.
                Properties: create, query, edit
        colorAlphaValue (float?): The Alpha value of the color.
                Properties: create, query, edit
        colorRGBAValue (Tuple[float, float, float, float]?): The RGBA value of the color.
                Properties: create, query, edit
        colorRGBValue (Tuple[float, float, float]?): The RGB value of the color.
                Properties: create, query, edit
        colorRamp (str?): Allows a user defined color ramp to be used to map values to colors.
                Properties: create, query, edit
        colorfeedback (bool?): Sets on/off the color feedback display.
                C: Default is FALSE.  Q: When queried, it returns a boolean.
                Properties: create, query, edit
        colorfeedbackOverride (bool?): Sets on/off the color feedback override.
                C: Default is FALSE.  Q: When queried, it returns a boolean.
                Properties: create, query, edit
        colorrangelower (float?): Specifies the value that maps to black when
                color feedback mode is on.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        colorrangeupper (float?): Specifies the value that maps to the maximum
                color when color feedback mode is on.
                C: Default is 1.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        dataTypeIndex (int?): When the selected paintable attribute is a vectorArray,
                it specifies which field to paint on.
                Properties: query, edit
        disablelighting (bool?): If color feedback is on, this flag determines whether
                lighting is disabled or not for the surfaces that are
                affected.
                C: Default is FALSE.  Q: When queried, it returns a boolean.
                Properties: create, query, edit
        dispdecr (bool?): Decreases a maximum displacement by 10%.
                Properties: create, edit
        dispincr (bool?): Increases a maximum displacement by 10%.
                Properties: create, edit
        dragSlider (str?): Sets the current brush drag state for resizing or
                offsetting the brush (like the 'b' and 'm' default hotkeys).
                The string argument is one of: "radius", "lowradius",
                "opacity", "value", "depth", "displacement", "uvvector"
                or "none".
                C: Default is "none".
                Properties: create, edit
        duringStrokeCmd (str?): The passed string is executed as a MEL command
                during the stroke, each time the mouse is dragged.
                C: Default is no command. Q: When queried, it returns
                the current command
                Properties: create, query, edit
        dynclonemode (bool?): Enable or disable dynamic clone mode.
                Properties: create, query, edit
        erasesrfupd (bool?): Toggles the update for the erase surface
                Properties: create, query, edit
        exists (bool?): Returns true or false depending upon whether the
                specified object exists. Other flags are ignored.
                Properties: create
        expandfilename (bool?): If true, it will expand the name of the export file
                and concatenate it with the surface name. Otherwise it
                will take the name as it is.
                C: Default is true.
                Properties: create, edit
        exportaspectratio (float?): Value of aspect ratio for export
                Properties: create, query, edit
        exportfilemode (str?): Specifies the export channel.The valid
                entries here are: "alpha", "luminance", "rgb", "rgba".
                C: Default is "luminance/rgb".
                Q: When queried, it returns a string.
                Properties: create, query, edit
        exportfilesave (str?): Exports the attribute map and saves to a specified file.
                Properties: edit
        exportfilesizex (int?): Specifies the width of the attribute map to export.
                C: Default width is 256. Q: When queried, it returns an integer.
                Properties: create, query, edit
        exportfilesizey (int?): Specifies the width of the attribute map to export.
                C: Default width is 256. Q: When queried, it returns an integer.
                Properties: create, query, edit
        exportfiletype (str?): Specifies the image file format. It can be one of
                the following: "iff", "tiff", "jpeg", "alias", "rgb", "fit"
                "postScriptEPS", "softimage", "wavefrontRLA", "wavefrontEXP".
                C: default is tiff. Q: When queried, it returns a string.
                Properties: create, query, edit
        filterNodes (bool?): Sets the node filter.
                Properties: edit
        history (bool?): If this is a tool command, turn the construction history on
                for the tool in question.
                Properties: create
        image1 (str?): First of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        image2 (str?): Second of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        image3 (str?): Third of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        importfileload (str?): Load the attribute map a specified file.
                Properties: edit
        importfilemode (str?): Specifies the channel to import. The valid
                entries here are: "alpha", "luminance", "red", "green",
                "blue", and "rgb"
                C: Default is "alpha". Q: When queried, it returns a string.
                Properties: create, query, edit
        importreassign (bool?): Specifies if the multiply atrribute maps are to be
                reassigned while importing. Only maps previously exported from
                within Artisan can be reassigned.
                C: Default is FALSE. Q: When queried, it returns a  boolean.
                Properties: create, query, edit
        interactiveUpdate (bool?): Specifies how often to transfer the painted values
                into the attribute.
                TRUE: transfer them "continuously" (many times per stroke)
                FALSE: transfer them only at the end of a stroke (on mouse
                button release).
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        invertrefvector (bool?): Sets the invert of the reference vector option when
                the reflection is ON. If it is true, the reference vector
                for the reflected stroke is negated with respect to the original
                one.
                C: Default is FALSE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        lastRecorderCmd (str?): Value of last recorded command.
                Properties: create, query, edit
        lastStampName (str?): Value of the last stamp name.
                Properties: create, query, edit
        lowerradius (float?): Sets the lower size of the brush (only apply on tablet).
                Properties: create, query, edit
        makeStroke (Unknown?): Stroke point values.
                Properties: create, query, edit, multiuse
        mappressure (str?): Sets the tablet pressure mapping when the table
                is used. There are three options:
                "Opacity" - the pressure is mapped to the opacity,
                "Radius" - the is mapped to modify the radius of the brush,
                "Both" - the pressure modifies both the opacity and the radius.
                C: Default is "Opacity". Q: When queried, it returns a string.
                Properties: create, query, edit
        maxdisp (float?): Defines a maximum displacement
                ( maxDisp in [0.0..5.0] ).
                C: Default is 1.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        maxvalue (float?): Specifies the maximum value for each attribute.
                C: Default is 1.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        minvalue (float?): Specifies the minimum value for each attribute.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        mouldtypehead (str?): Type of type mould to use
                Properties: create, query, edit
        mouldtypemouse (str?): Specifies the putty operations/mode ("push" - pushes CVs
                along the given direction (see refvector flag), "pull" - pulls
                CVs along the specified direction, "smooth" - smooths the sculpt,
                "erase" - erases the paint).
                C: Default is "push".  Q: When queried, it returns a string.
                Properties: create, query, edit
        mouldtypetail (str?): Type of eraser mould to use
                Properties: create, query, edit
        name (str?): If this is a tool command, name the tool appropriately.
                Properties: create
        objattrArray (str?): An array of all paintable attributes. Each element of
                the array is a string with the following information:
                NodeType.NodeName.AttributeName.MenuType.
                *MenuType: type (level) of the item in the Menu (UI).
                Q: When queried, it returns a string.
                Properties: query
        opacity (float?): Sets the brush opacity.
                C: Default is 1.0. Q: When queried, it returns a float.
                Properties: create, query, edit
        outline (bool?): Specifies if the brush should be drawn.
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        outwhilepaint (bool?): Specifies if the brush outline should be drawn
                while painting.
                C: Default is FALSE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        paintNodeArray (str?): An array of paintable nodes.
                Q: When queried, it returns a string.
                Properties: query
        paintattrselected (str?): An array of selected paintable attributes.
                Each element of the array is a string with the
                following information:
                NodeType.NodeName.AttributeName.
                Properties: edit
        paintmode (str?): Specifies the paint mode. There are two
                possibilities: "screen" and "tangent".
                C: Default is "screen". Q: When queried, it returns a string.
                Properties: create, query, edit
        paintoperationtype (str?): Specifies the operation type used by the
                Paint Tool.  Currently, we support the following
                paint modes: "Paint", "Smear", "Blur", "Erase"
                and "Clone".
                Default is "Paint".
                Properties: create, query, edit
        pickColor (bool?): Set pick color mode on or off
                Properties: create, query, edit
        pickValue (bool?): Toggle for picking
                Properties: create, query, edit
        playbackCursor (Tuple[float, float]?): Values for the playback cursor.
                Properties: create, query, edit, multiuse
        playbackPressure (float?): Valus for the playback pressure.
                Properties: create, query, edit, multiuse
        polecv (bool?): Pull all the pole CVs to the same position.
                Properties: create, query, edit
        preserveclonesource (bool?): Whether or not to preserve a clone source.
                Properties: create, query, edit
        profileShapeFile (str?): Passes a name of the image file for the stamp shape
                profile.
                Properties: query, edit
        projective (bool?): Specifies the projective paint mode.
                C: Default is 'false'. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        radius (float?): Sets the size of the brush.
                C: Default is 1.0 cm. Q: When queried, it returns a float.
                Properties: create, query, edit
        rampMaxColor (Tuple[float, float, float]?): Defines a special color to be used when the value is greater than or equal to
                the maximum value.
                Properties: create, query, edit
        rampMinColor (Tuple[float, float, float]?): Defines a special color to be used when the value is less than or equal to the
                minimum value.
                Properties: create, query, edit
        record (bool?): Toggle on for recording.
                Properties: create, query, edit
        reflection (bool?): Specifies the reflection mode.
                C: Default is 'false'. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        reflectionaboutorigin (bool?): Toggle on to reflect about the origin
                Properties: create, query, edit
        reflectionaxis (str?): Specifies the reflection axis. There are three
                possibilities: "x", "y" and "z".
                C: Default is "x". Q: When queried, it returns a string.
                Properties: create, query, edit
        refsurface (bool?): Sets on/off the update of the reference surface.
                If it is true the reference surface is automatically updated
                on the per stroke bases. If it is false, the user has to update
                the reference surface explicitly by pressing the update button
                (see updaterefsrf).
                C: Default is TRUE.  Q: When queried, it returns a boolean.
                Properties: create, query, edit
        refvector (str?): Specifies the direction of the push/pull operation
                ("normal" - sculpt along normals, "firstnormal" - sculpt along
                the first normal of the stroke, "view" - sculpt along the view
                direction, "xaxis", "yaxis", "zaxis" - sculpt along a given
                axis directions, "uisoparm", "visoparm" - sculpt along U or V
                isoparametric lines), "uvvector" - sculpt along an arbitrary
                vector in UV space.
                C: Default is "normal".  Q: When queried, it returns a string.
                Properties: create, query, edit
        refvectoru (float?): Specifies the U component of the UV vector to be used
                when -refVector is set to "uvvector".
                Properties: create, query, edit
        refvectorv (float?): Specifies the V component of the UV vector to be used
                when -refVector is set to "uvvector".
                Properties: create, query, edit
        screenRadius (float?): Brush radius on the screen
                Properties: create, query, edit
        selectclonesource (bool?): Toggle on to select the clone source
                Properties: create, query, edit
        selectedattroper (str?): Sets the edit weight operation. Four edit weights
                operations are provided : "absolute" - the value of the weight
                is replaced by the current one, "additive" - the value of the
                weight is added to the current one, "scale" - the value of the
                weight is multiplied by the current one, "smooth" - the value
                of the weight is divided by the current one.
                C: Default is "absolute".  Q: When queried, it returns a string.
                Properties: create, query, edit
        showactive (bool?): Sets on/off the display of the surface isoparms.
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        smoothiters (int?): Sets the quality of the smoothing operation (number of
                iterations).
                C: Default is 3.  Q: When queried, it returns an int.
                Properties: create, query, edit
        stampDepth (float?): Depth of the stamps
                Properties: create, query, edit
        stampProfile (str?): Sets the brush profile of the current stamp.
                Currently, the following profiles are supported:
                "gaussian", "poly", "solid" and "square".
                C: Default is gaussian. Q: When queried, it returns a string.
                Properties: create, query, edit
        stampSpacing (float?): Specifies the stamp spacing. Default is 1.0.
                Properties: create, query, edit
        stitchcorner (bool?): Sets on/off the stitching corner mode
                C: Default is "off".  Q: When queried, it returns a boolean.
                Properties: create, query, edit
        stitchedgeflood (bool?): Triggers postprocessing stitching edge procedure.
                Properties: edit
        stitchtype (str?): Sets on/off the stitching mode ( "off" - stitching
                is turned off, "position" - position stitching is done without
                taking care about the tangent continuity C0, "tan" - C1
                continuity is preserved).
                C: Default is "position".  Q: When queried, it returns a string.
                Properties: create, query, edit
        strokesmooth (str?): Stroke smoothing type name
                Properties: create, query, edit
        surfaceConformedBrushVertices (bool?): Enables/disables the the display of the effective brush area
                as affected vertices.
                Properties: create, query, edit
        tablet (bool?): Returns true if the tablet device is present, false if it is absent
                Properties: query
        tangentOutline (bool?): Enables/disables the display of the brush circle tangent to
                the surface.
                Properties: create, query, edit
        toolOffProc (str?): Accepts a strings describing the name of a MEL
                procedure that is invoked whenever the tool is turned off.
                For example, cloth invokes "clothPaintToolOff" when the cloth
                paint tool is turned on. Define this callback if your tool
                requires special functionality when your tool is deactivated.
                It is typical that if you implement a toolOffProc you will
                want to implement a toolOnProc as well (see the -toolOnProc
                flag. In query mode, the name of the currently registered MEL
                command is returned and this will be an empty string if none
                is defined.
                Properties: create, query, edit
        toolOnProc (str?): Accepts a strings describing the name of a MEL
                procedure that is invoked whenever the tool is turned on.
                For example, cloth invokes "clothPaintToolOn" when the cloth
                paint tool is turned on. Define this callback if your tool
                requires special functionality when your tool is activated.
                It is typical that if you implement a toolOnProc you will
                want to implement a toolOffProc as well (see the -toolOffProc
                flag. In query mode, the name of the currently registered MEL
                command is returned and this will be an empty string if none
                is defined.
                Properties: create, query, edit
        updateerasesrf (bool?): Updates the erase surface.
                Properties: create, edit
        updaterefsrf (bool?): Updates the reference surface.
                Properties: create, edit
        useColorRamp (bool?): Specifies whether the user defined color ramp should be used to map values
                from to colors.  If this is turned off, the default greyscale feedback
                will be used.
                Properties: create, query, edit
        useMaxMinColor (bool?): Specifies whether the out of range colors should be used.  See rampMinColor
                and rampMaxColor flags for further details.
                Properties: create, query, edit
        usepressure (bool?): Sets the tablet pressure on/off.
                C: Default is false. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        value (float?): Specifies the value for each attribute.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        whichTool (str?): The string defines the name of the tool to be
                used for the Artisan context. An example is "artClothPaint".
                In query mode, the tool name for the given context is returned.
                Note: due to the way MEL works, always specify the -query flag
                last when specifying a flag that takes arguments.
                Properties: create, query, edit
        worldRadius (float?): Radius in worldspace
                Properties: create, query, edit

    Returns:
        bool: In query mode, return type is based on queried flag.

    Example:
    """

def artSelect(*args: str) -> None: ...
def artSelectCtx(*args: Any, accopacity: bool = ..., addselection: bool = ..., afterStrokeCmd: str = ..., beforeStrokeCmd: str = ..., brushalignment: bool = ..., brushfeedback: bool = ..., clear: bool = ..., dragSlider: str = ..., dynclonemode: bool = ..., exists: bool = ..., expandfilename: bool = ..., exportaspectratio: float = ..., exportfilemode: str = ..., exportfilesave: str = ..., exportfilesizex: int = ..., exportfilesizey: int = ..., exportfiletype: str = ..., history: bool = ..., image1: str = ..., image2: str = ..., image3: str = ..., importfileload: str = ..., importfilemode: str = ..., importreassign: bool = ..., importthreshold: float = ..., lastRecorderCmd: str = ..., lastStampName: str = ..., lowerradius: float = ..., makeStroke: Unknown = ..., mappressure: str = ..., name: str = ..., opacity: float = ..., outline: bool = ..., outwhilepaint: bool = ..., paintmode: str = ..., paintoperationtype: str = ..., pickColor: bool = ..., pickValue: bool = ..., playbackCursor: Tuple[float, float] = ..., playbackPressure: float = ..., preserveclonesource: bool = ..., profileShapeFile: str = ..., projective: bool = ..., radius: float = ..., record: bool = ..., reflection: bool = ..., reflectionaboutorigin: bool = ..., reflectionaxis: str = ..., screenRadius: float = ..., selectall: bool = ..., selectclonesource: bool = ..., selectop: str = ..., showactive: bool = ..., stampDepth: float = ..., stampProfile: str = ..., stampSpacing: float = ..., strokesmooth: str = ..., surfaceConformedBrushVertices: bool = ..., tablet: bool = ..., tangentOutline: bool = ..., toggleall: bool = ..., unselectall: bool = ..., usepressure: bool = ..., worldRadius: float = ...) -> bool:
    """This command is used to select/deselect/toggle components on
    selected surfaces using a brush interface (Maya Artisan). Since,
    it selects components of the surface, it only works in the
    component mode.
    Args:
        accopacity (bool?): Sets opacity accumulation on/off.
                C: Default is false (Except for sculpt tool for which it is true by default).
                Q: When queried, it returns a boolean.
                Properties: create, query, edit
        addselection (bool?): If true, each new stroke adds cvs to the active
                list. If false, each stroke replaces the previous selection.
                C: Default is true. Q: When queried, it returns a boole
                Properties: create, query, edit
        afterStrokeCmd (str?): The passed string is executed as a MEL command
                immediately after the end of a stroke.
                C: Default is no command. Q: When queried, it returns
                the current command
                Properties: create, query, edit
        beforeStrokeCmd (str?): The passed string is executed as a MEL command
                immediately before the start of a stroke.
                C: Default is no command. Q: When queried, it returns the
                current command
                Properties: create, query, edit
        brushalignment (bool?): Specifies the path brush alignemnt. If true,
                the brush will align to stroke path, otherwise it will
                align to up vector.
                C: Default is true. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        brushfeedback (bool?): Specifies if the brush additional feedback should
                be drawn.
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        clear (bool?): Floods all cvs/vertices to the current value.
                Properties: create, edit
        dragSlider (str?): Sets the current brush drag state for resizing or
                offsetting the brush (like the 'b' and 'm' default hotkeys).
                The string argument is one of: "radius", "lowradius",
                "opacity", "value", "depth", "displacement", "uvvector"
                or "none".
                C: Default is "none".
                Properties: create, edit
        dynclonemode (bool?): Enable or disable dynamic clone mode.
                Properties: create, query, edit
        exists (bool?): Returns true or false depending upon whether the
                specified object exists. Other flags are ignored.
                Properties: create
        expandfilename (bool?): If true, it will expand the name of the export file
                and concatenate it with the surface name. Otherwise it
                will take the name as it is.
                C: Default is true.
                Properties: create, edit
        exportaspectratio (float?): Value of aspect ratio for export
                Properties: create, query, edit
        exportfilemode (str?): Specifies the export channel.The valid
                entries here are: "alpha", "luminance", "rgb", "rgba".
                C: Default is "luminance/rgb".
                Q: When queried, it returns a string.
                Properties: create, query, edit
        exportfilesave (str?): Exports the attribute map and saves to a specified file.
                Properties: edit
        exportfilesizex (int?): Specifies the width of the attribute map to export.
                C: Default width is 256. Q: When queried, it returns an integer.
                Properties: create, query, edit
        exportfilesizey (int?): Specifies the width of the attribute map to export.
                C: Default width is 256. Q: When queried, it returns an integer.
                Properties: create, query, edit
        exportfiletype (str?): Specifies the image file format. It can be one of
                the following: "iff", "tiff", "jpeg", "alias", "rgb", "fit"
                "postScriptEPS", "softimage", "wavefrontRLA", "wavefrontEXP".
                C: default is tiff. Q: When queried, it returns a string.
                Properties: create, query, edit
        history (bool?): If this is a tool command, turn the construction history on
                for the tool in question.
                Properties: create
        image1 (str?): First of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        image2 (str?): Second of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        image3 (str?): Third of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        importfileload (str?): Load the attribute map a specified file.
                Properties: edit
        importfilemode (str?): Specifies the channel to import. The valid
                entries here are: "alpha", "luminance", "red", "green",
                "blue", and "rgb"
                C: Default is "alpha". Q: When queried, it returns a string.
                Properties: create, query, edit
        importreassign (bool?): Specifies if the multiply atrribute maps are to be
                reassigned while importing. Only maps previously exported from
                within Artisan can be reassigned.
                C: Default is FALSE. Q: When queried, it returns a  boolean.
                Properties: create, query, edit
        importthreshold (float?): Specifies the threshold for the import of
                the attribute maps.
                C: Default is 0.5.  Q: When queried, it returns a float.
                Properties: create, query, edit
        lastRecorderCmd (str?): Value of last recorded command.
                Properties: create, query, edit
        lastStampName (str?): Value of the last stamp name.
                Properties: create, query, edit
        lowerradius (float?): Sets the lower size of the brush (only apply on tablet).
                Properties: create, query, edit
        makeStroke (Unknown?): Stroke point values.
                Properties: create, query, edit, multiuse
        mappressure (str?): Sets the tablet pressure mapping when the table
                is used. There are three options:
                "Opacity" - the pressure is mapped to the opacity,
                "Radius" - the is mapped to modify the radius of the brush,
                "Both" - the pressure modifies both the opacity and the radius.
                C: Default is "Opacity". Q: When queried, it returns a string.
                Properties: create, query, edit
        name (str?): If this is a tool command, name the tool appropriately.
                Properties: create
        opacity (float?): Sets the brush opacity.
                C: Default is 1.0. Q: When queried, it returns a float.
                Properties: create, query, edit
        outline (bool?): Specifies if the brush should be drawn.
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        outwhilepaint (bool?): Specifies if the brush outline should be drawn
                while painting.
                C: Default is FALSE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        paintmode (str?): Specifies the paint mode. There are two
                possibilities: "screen" and "tangent".
                C: Default is "screen". Q: When queried, it returns a string.
                Properties: create, query, edit
        paintoperationtype (str?): Specifies the operation type used by the
                Paint Tool.  Currently, we support the following
                paint modes: "Paint", "Smear", "Blur", "Erase"
                and "Clone".
                Default is "Paint".
                Properties: create, query, edit
        pickColor (bool?): Set pick color mode on or off
                Properties: create, query, edit
        pickValue (bool?): Toggle for picking
                Properties: create, query, edit
        playbackCursor (Tuple[float, float]?): Values for the playback cursor.
                Properties: create, query, edit, multiuse
        playbackPressure (float?): Valus for the playback pressure.
                Properties: create, query, edit, multiuse
        preserveclonesource (bool?): Whether or not to preserve a clone source.
                Properties: create, query, edit
        profileShapeFile (str?): Passes a name of the image file for the stamp shape
                profile.
                Properties: query, edit
        projective (bool?): Specifies the projective paint mode.
                C: Default is 'false'. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        radius (float?): Sets the size of the brush.
                C: Default is 1.0 cm. Q: When queried, it returns a float.
                Properties: create, query, edit
        record (bool?): Toggle on for recording.
                Properties: create, query, edit
        reflection (bool?): Specifies the reflection mode.
                C: Default is 'false'. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        reflectionaboutorigin (bool?): Toggle on to reflect about the origin
                Properties: create, query, edit
        reflectionaxis (str?): Specifies the reflection axis. There are three
                possibilities: "x", "y" and "z".
                C: Default is "x". Q: When queried, it returns a string.
                Properties: create, query, edit
        screenRadius (float?): Brush radius on the screen
                Properties: create, query, edit
        selectall (bool?): Selects all vertices/egdes/faces/uvs.
                Properties: create, edit
        selectclonesource (bool?): Toggle on to select the clone source
                Properties: create, query, edit
        selectop (str?): Specifies the selection operation
                ("select", "unselect", "toggle").
                C: Default is "select". Q: When queried, it returns a string.
                Properties: create, query, edit
        showactive (bool?): Sets on/off the display of the surface isoparms.
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        stampDepth (float?): Depth of the stamps
                Properties: create, query, edit
        stampProfile (str?): Sets the brush profile of the current stamp.
                Currently, the following profiles are supported:
                "gaussian", "poly", "solid" and "square".
                C: Default is gaussian. Q: When queried, it returns a string.
                Properties: create, query, edit
        stampSpacing (float?): Specifies the stamp spacing. Default is 1.0.
                Properties: create, query, edit
        strokesmooth (str?): Stroke smoothing type name
                Properties: create, query, edit
        surfaceConformedBrushVertices (bool?): Enables/disables the the display of the effective brush area
                as affected vertices.
                Properties: create, query, edit
        tablet (bool?): Returns true if the tablet device is present, false if it is absent
                Properties: query
        tangentOutline (bool?): Enables/disables the display of the brush circle tangent to
                the surface.
                Properties: create, query, edit
        toggleall (bool?): Toggle all vertices/egdes/faces/uvs.
                Properties: create, edit
        unselectall (bool?): Unselects all vertices/egdes/faces/uvs.
                Properties: create, edit
        usepressure (bool?): Sets the tablet pressure on/off.
                C: Default is false. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        worldRadius (float?): Radius in worldspace
                Properties: create, query, edit

    Returns:
        bool: In query mode, return type is based on queried flag.

    Example:
    """

def artSetPaint(*args: str) -> None: ...
def artSetPaintCtx(*args: Any, accopacity: bool = ..., afterStrokeCmd: str = ..., beforeStrokeCmd: str = ..., brushalignment: bool = ..., brushfeedback: bool = ..., clear: bool = ..., dragSlider: str = ..., dynclonemode: bool = ..., exists: bool = ..., expandfilename: bool = ..., exportaspectratio: float = ..., exportfilemode: str = ..., exportfilesave: str = ..., exportfilesizex: int = ..., exportfilesizey: int = ..., exportfiletype: str = ..., history: bool = ..., image1: str = ..., image2: str = ..., image3: str = ..., importfileload: str = ..., importfilemode: str = ..., importreassign: bool = ..., lastRecorderCmd: str = ..., lastStampName: str = ..., lowerradius: float = ..., makeStroke: Unknown = ..., mappressure: str = ..., name: str = ..., objectsetnames: str = ..., opacity: float = ..., outline: bool = ..., outwhilepaint: bool = ..., paintmode: str = ..., paintoperationtype: str = ..., pickColor: bool = ..., pickValue: bool = ..., playbackCursor: Tuple[float, float] = ..., playbackPressure: float = ..., preserveclonesource: bool = ..., profileShapeFile: str = ..., projective: bool = ..., radius: float = ..., record: bool = ..., reflection: bool = ..., reflectionaboutorigin: bool = ..., reflectionaxis: str = ..., screenRadius: float = ..., selectclonesource: bool = ..., setcolorfeedback: bool = ..., setdisplaycvs: bool = ..., setopertype: str = ..., settomodify: str = ..., showactive: bool = ..., stampDepth: float = ..., stampProfile: str = ..., stampSpacing: float = ..., strokesmooth: str = ..., surfaceConformedBrushVertices: bool = ..., tablet: bool = ..., tangentOutline: bool = ..., usepressure: bool = ..., worldRadius: float = ...) -> bool:
    """This tool allows the user to modify the set membership
    (add, transfer, remove cvs) on nurbs surfaces using Maya
    Artisan's interface.
    Args:
        accopacity (bool?): Sets opacity accumulation on/off.
                C: Default is false (Except for sculpt tool for which it is true by default).
                Q: When queried, it returns a boolean.
                Properties: create, query, edit
        afterStrokeCmd (str?): The passed string is executed as a MEL command
                immediately after the end of a stroke.
                C: Default is no command. Q: When queried, it returns
                the current command
                Properties: create, query, edit
        beforeStrokeCmd (str?): The passed string is executed as a MEL command
                immediately before the start of a stroke.
                C: Default is no command. Q: When queried, it returns the
                current command
                Properties: create, query, edit
        brushalignment (bool?): Specifies the path brush alignemnt. If true,
                the brush will align to stroke path, otherwise it will
                align to up vector.
                C: Default is true. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        brushfeedback (bool?): Specifies if the brush additional feedback should
                be drawn.
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        clear (bool?): Floods all cvs/vertices to the current value.
                Properties: create, edit
        dragSlider (str?): Sets the current brush drag state for resizing or
                offsetting the brush (like the 'b' and 'm' default hotkeys).
                The string argument is one of: "radius", "lowradius",
                "opacity", "value", "depth", "displacement", "uvvector"
                or "none".
                C: Default is "none".
                Properties: create, edit
        dynclonemode (bool?): Enable or disable dynamic clone mode.
                Properties: create, query, edit
        exists (bool?): Returns true or false depending upon whether the
                specified object exists. Other flags are ignored.
                Properties: create
        expandfilename (bool?): If true, it will expand the name of the export file
                and concatenate it with the surface name. Otherwise it
                will take the name as it is.
                C: Default is true.
                Properties: create, edit
        exportaspectratio (float?): Value of aspect ratio for export
                Properties: create, query, edit
        exportfilemode (str?): Specifies the export channel.The valid
                entries here are: "alpha", "luminance", "rgb", "rgba".
                C: Default is "luminance/rgb".
                Q: When queried, it returns a string.
                Properties: create, query, edit
        exportfilesave (str?): Exports the attribute map and saves to a specified file.
                Properties: edit
        exportfilesizex (int?): Specifies the width of the attribute map to export.
                C: Default width is 256. Q: When queried, it returns an integer.
                Properties: create, query, edit
        exportfilesizey (int?): Specifies the width of the attribute map to export.
                C: Default width is 256. Q: When queried, it returns an integer.
                Properties: create, query, edit
        exportfiletype (str?): Specifies the image file format. It can be one of
                the following: "iff", "tiff", "jpeg", "alias", "rgb", "fit"
                "postScriptEPS", "softimage", "wavefrontRLA", "wavefrontEXP".
                C: default is tiff. Q: When queried, it returns a string.
                Properties: create, query, edit
        history (bool?): If this is a tool command, turn the construction history on
                for the tool in question.
                Properties: create
        image1 (str?): First of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        image2 (str?): Second of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        image3 (str?): Third of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        importfileload (str?): Load the attribute map a specified file.
                Properties: edit
        importfilemode (str?): Specifies the channel to import. The valid
                entries here are: "alpha", "luminance", "red", "green",
                "blue", and "rgb"
                C: Default is "alpha". Q: When queried, it returns a string.
                Properties: create, query, edit
        importreassign (bool?): Specifies if the multiply atrribute maps are to be
                reassigned while importing. Only maps previously exported from
                within Artisan can be reassigned.
                C: Default is FALSE. Q: When queried, it returns a  boolean.
                Properties: create, query, edit
        lastRecorderCmd (str?): Value of last recorded command.
                Properties: create, query, edit
        lastStampName (str?): Value of the last stamp name.
                Properties: create, query, edit
        lowerradius (float?): Sets the lower size of the brush (only apply on tablet).
                Properties: create, query, edit
        makeStroke (Unknown?): Stroke point values.
                Properties: create, query, edit, multiuse
        mappressure (str?): Sets the tablet pressure mapping when the table
                is used. There are three options:
                "Opacity" - the pressure is mapped to the opacity,
                "Radius" - the is mapped to modify the radius of the brush,
                "Both" - the pressure modifies both the opacity and the radius.
                C: Default is "Opacity". Q: When queried, it returns a string.
                Properties: create, query, edit
        name (str?): If this is a tool command, name the tool appropriately.
                Properties: create
        objectsetnames (str?): Default name of object sets
                Properties: create, query, edit
        opacity (float?): Sets the brush opacity.
                C: Default is 1.0. Q: When queried, it returns a float.
                Properties: create, query, edit
        outline (bool?): Specifies if the brush should be drawn.
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        outwhilepaint (bool?): Specifies if the brush outline should be drawn
                while painting.
                C: Default is FALSE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        paintmode (str?): Specifies the paint mode. There are two
                possibilities: "screen" and "tangent".
                C: Default is "screen". Q: When queried, it returns a string.
                Properties: create, query, edit
        paintoperationtype (str?): Specifies the operation type used by the
                Paint Tool.  Currently, we support the following
                paint modes: "Paint", "Smear", "Blur", "Erase"
                and "Clone".
                Default is "Paint".
                Properties: create, query, edit
        pickColor (bool?): Set pick color mode on or off
                Properties: create, query, edit
        pickValue (bool?): Toggle for picking
                Properties: create, query, edit
        playbackCursor (Tuple[float, float]?): Values for the playback cursor.
                Properties: create, query, edit, multiuse
        playbackPressure (float?): Valus for the playback pressure.
                Properties: create, query, edit, multiuse
        preserveclonesource (bool?): Whether or not to preserve a clone source.
                Properties: create, query, edit
        profileShapeFile (str?): Passes a name of the image file for the stamp shape
                profile.
                Properties: query, edit
        projective (bool?): Specifies the projective paint mode.
                C: Default is 'false'. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        radius (float?): Sets the size of the brush.
                C: Default is 1.0 cm. Q: When queried, it returns a float.
                Properties: create, query, edit
        record (bool?): Toggle on for recording.
                Properties: create, query, edit
        reflection (bool?): Specifies the reflection mode.
                C: Default is 'false'. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        reflectionaboutorigin (bool?): Toggle on to reflect about the origin
                Properties: create, query, edit
        reflectionaxis (str?): Specifies the reflection axis. There are three
                possibilities: "x", "y" and "z".
                C: Default is "x". Q: When queried, it returns a string.
                Properties: create, query, edit
        screenRadius (float?): Brush radius on the screen
                Properties: create, query, edit
        selectclonesource (bool?): Toggle on to select the clone source
                Properties: create, query, edit
        setcolorfeedback (bool?): Specifies if the color feedback is on or off.
                C: Default is ON.  Q: When queried, it returns a boolean.
                Properties: create, query, edit
        setdisplaycvs (bool?): Specifies if the active cvs are displayed.
                C: Default is ON. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        setopertype (str?): Specifies the setEdit operation
                ("add", "transfer", "remove").
                C: Default is "add". Q: When queried, it returns a string.
                Properties: create, query, edit
        settomodify (str?): Specifies the name of the set to modify.
                Q: When queried, it returns a string.
                Properties: create, query, edit
        showactive (bool?): Sets on/off the display of the surface isoparms.
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        stampDepth (float?): Depth of the stamps
                Properties: create, query, edit
        stampProfile (str?): Sets the brush profile of the current stamp.
                Currently, the following profiles are supported:
                "gaussian", "poly", "solid" and "square".
                C: Default is gaussian. Q: When queried, it returns a string.
                Properties: create, query, edit
        stampSpacing (float?): Specifies the stamp spacing. Default is 1.0.
                Properties: create, query, edit
        strokesmooth (str?): Stroke smoothing type name
                Properties: create, query, edit
        surfaceConformedBrushVertices (bool?): Enables/disables the the display of the effective brush area
                as affected vertices.
                Properties: create, query, edit
        tablet (bool?): Returns true if the tablet device is present, false if it is absent
                Properties: query
        tangentOutline (bool?): Enables/disables the display of the brush circle tangent to
                the surface.
                Properties: create, query, edit
        usepressure (bool?): Sets the tablet pressure on/off.
                C: Default is false. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        worldRadius (float?): Radius in worldspace
                Properties: create, query, edit

    Returns:
        bool: In query mode, return type is based on queried flag.

    Example:
    """

def artUserPaintCtx(*args: Any, accopacity: bool = ..., activeListChangedProc: str = ..., afterStrokeCmd: str = ..., alphaclamp: str = ..., alphaclamplower: float = ..., alphaclampupper: float = ..., attrSelected: str = ..., beforeStrokeCmd: str = ..., brushalignment: bool = ..., brushfeedback: bool = ..., chunkCommand: str = ..., clamp: str = ..., clamplower: float = ..., clampupper: float = ..., clear: bool = ..., colorAlphaValue: float = ..., colorRGBAValue: Tuple[float, float, float, float] = ..., colorRGBValue: Tuple[float, float, float] = ..., colorRamp: str = ..., colorfeedback: bool = ..., colorfeedbackOverride: bool = ..., colorrangelower: float = ..., colorrangeupper: float = ..., dataTypeIndex: int = ..., disablelighting: bool = ..., dragSlider: str = ..., duringStrokeCmd: str = ..., dynclonemode: bool = ..., exists: bool = ..., expandfilename: bool = ..., exportaspectratio: float = ..., exportfilemode: str = ..., exportfilesave: str = ..., exportfilesizex: int = ..., exportfilesizey: int = ..., exportfiletype: str = ..., filterNodes: bool = ..., finalizeCmd: str = ..., fullpaths: bool = ..., getArrayAttrCommand: str = ..., getSurfaceCommand: str = ..., getValueCommand: str = ..., history: bool = ..., image1: str = ..., image2: str = ..., image3: str = ..., importfileload: str = ..., importfilemode: str = ..., importreassign: bool = ..., initializeCmd: str = ..., interactiveUpdate: bool = ..., lastRecorderCmd: str = ..., lastStampName: str = ..., lowerradius: float = ..., makeStroke: Unknown = ..., mappressure: str = ..., maxvalue: float = ..., minvalue: float = ..., name: str = ..., objattrArray: str = ..., opacity: float = ..., outline: bool = ..., outwhilepaint: bool = ..., paintNodeArray: str = ..., paintattrselected: str = ..., paintmode: str = ..., paintoperationtype: str = ..., pickColor: bool = ..., pickValue: bool = ..., playbackCursor: Tuple[float, float] = ..., playbackPressure: float = ..., preserveclonesource: bool = ..., profileShapeFile: str = ..., projective: bool = ..., radius: float = ..., rampMaxColor: Tuple[float, float, float] = ..., rampMinColor: Tuple[float, float, float] = ..., record: bool = ..., reflection: bool = ..., reflectionaboutorigin: bool = ..., reflectionaxis: str = ..., screenRadius: float = ..., selectclonesource: bool = ..., selectedattroper: str = ..., setArrayValueCommand: str = ..., setValueCommand: str = ..., showactive: bool = ..., stampDepth: float = ..., stampProfile: str = ..., stampSpacing: float = ..., strokesmooth: str = ..., surfaceConformedBrushVertices: bool = ..., tablet: bool = ..., tangentOutline: bool = ..., toolCleanupCmd: str = ..., toolOffProc: str = ..., toolOnProc: str = ..., toolSetupCmd: str = ..., useColorRamp: bool = ..., useMaxMinColor: bool = ..., usepressure: bool = ..., value: float = ..., whichTool: str = ..., worldRadius: float = ...) -> str:
    """This is a context command to set the flags on the artAttrContext,
    which is the base context for attribute painting operations. All
    commands require the name of the context as the last argument as
    this provides the name of the context to create, edit or query.This command executes a scriptable paint (Maya Artisan). It
    allows the user to apply Mel commands/scripts to modify cvs'
    attributes for all cvs under the paint brush.
    Args:
        accopacity (bool?): Sets opacity accumulation on/off.
                C: Default is false (Except for sculpt tool for which it is true by default).
                Q: When queried, it returns a boolean.
                Properties: create, query, edit
        activeListChangedProc (str?): Accepts a string that contains a MEL command that is
                invoked whenever the active list changes. There may be some
                situations where the UI, for example, needs to be updated,
                when objects are selected/deselected in the scene. In query
                mode, the name of the currently registered MEL command is
                returned and this will be an empty string if none is defined.
                Properties: create, query, edit
        afterStrokeCmd (str?): The passed string is executed as a MEL command
                immediately after the end of a stroke.
                C: Default is no command. Q: When queried, it returns
                the current command
                Properties: create, query, edit
        alphaclamp (str?): Specifies if the weight value should be alpha clamped to
                the lower and upper bounds. There are four options here:
                "none" - no clamping is performed, "lower" - clamps only to
                the lower bound, "upper" - clamps only to the upper bounds,
                "both" - clamps to the lower and upper bounds.
                C: Default is "none".  Q: When queried, it returns a string.
                Properties: create, query, edit
        alphaclamplower (float?): Specifies the lower bound for the alpha values.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        alphaclampupper (float?): Specifies the upper bound for the alpha values.
                C: Default is 1.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        attrSelected (str?): Returns a name of the currently selected attribute.
                Q: When queried, it returns a string.
                Properties: query
        beforeStrokeCmd (str?): The passed string is executed as a MEL command
                immediately before the start of a stroke.
                C: Default is no command. Q: When queried, it returns the
                current command
                Properties: create, query, edit
        brushalignment (bool?): Specifies the path brush alignemnt. If true,
                the brush will align to stroke path, otherwise it will
                align to up vector.
                C: Default is true. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        brushfeedback (bool?): Specifies if the brush additional feedback should
                be drawn.
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        chunkCommand (str?): Specifies th name of the Mel script/procedure that is
                called once for every selected surface when a chunk is
                received on that surface.
                Q: When queried, it returns a string.
                Properties: create, query, edit
        clamp (str?): Specifies if the weight value should be clamped to
                the lower and upper bounds. There are four options here:
                "none" - no clamping is performed, "lower" - clamps only to
                the lower bound, "upper" - clamps only to the upper bounds,
                "both" - clamps to the lower and upper bounds.
                C: Default is "none".  Q: When queried, it returns a string.
                Properties: create, query, edit
        clamplower (float?): Specifies the lower bound for the values.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        clampupper (float?): Specifies the upper bound for the values.
                C: Default is 1.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        clear (bool?): Floods all cvs/vertices to the current value.
                Properties: create, edit
        colorAlphaValue (float?): The Alpha value of the color.
                Properties: create, query, edit
        colorRGBAValue (Tuple[float, float, float, float]?): The RGBA value of the color.
                Properties: create, query, edit
        colorRGBValue (Tuple[float, float, float]?): The RGB value of the color.
                Properties: create, query, edit
        colorRamp (str?): Allows a user defined color ramp to be used to map values to colors.
                Properties: create, query, edit
        colorfeedback (bool?): Sets on/off the color feedback display.
                C: Default is FALSE.  Q: When queried, it returns a boolean.
                Properties: create, query, edit
        colorfeedbackOverride (bool?): Sets on/off the color feedback override.
                C: Default is FALSE.  Q: When queried, it returns a boolean.
                Properties: create, query, edit
        colorrangelower (float?): Specifies the value that maps to black when
                color feedback mode is on.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        colorrangeupper (float?): Specifies the value that maps to the maximum
                color when color feedback mode is on.
                C: Default is 1.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        dataTypeIndex (int?): When the selected paintable attribute is a vectorArray,
                it specifies which field to paint on.
                Properties: query, edit
        disablelighting (bool?): If color feedback is on, this flag determines whether
                lighting is disabled or not for the surfaces that are
                affected.
                C: Default is FALSE.  Q: When queried, it returns a boolean.
                Properties: create, query, edit
        dragSlider (str?): Sets the current brush drag state for resizing or
                offsetting the brush (like the 'b' and 'm' default hotkeys).
                The string argument is one of: "radius", "lowradius",
                "opacity", "value", "depth", "displacement", "uvvector"
                or "none".
                C: Default is "none".
                Properties: create, edit
        duringStrokeCmd (str?): The passed string is executed as a MEL command
                during the stroke, each time the mouse is dragged.
                C: Default is no command. Q: When queried, it returns
                the current command
                Properties: create, query, edit
        dynclonemode (bool?): Enable or disable dynamic clone mode.
                Properties: create, query, edit
        exists (bool?): Returns true or false depending upon whether the
                specified object exists. Other flags are ignored.
                Properties: create
        expandfilename (bool?): If true, it will expand the name of the export file
                and concatenate it with the surface name. Otherwise it
                will take the name as it is.
                C: Default is true.
                Properties: create, edit
        exportaspectratio (float?): Value of aspect ratio for export
                Properties: create, query, edit
        exportfilemode (str?): Specifies the export channel.The valid
                entries here are: "alpha", "luminance", "rgb", "rgba".
                C: Default is "luminance/rgb".
                Q: When queried, it returns a string.
                Properties: create, query, edit
        exportfilesave (str?): Exports the attribute map and saves to a specified file.
                Properties: edit
        exportfilesizex (int?): Specifies the width of the attribute map to export.
                C: Default width is 256. Q: When queried, it returns an integer.
                Properties: create, query, edit
        exportfilesizey (int?): Specifies the width of the attribute map to export.
                C: Default width is 256. Q: When queried, it returns an integer.
                Properties: create, query, edit
        exportfiletype (str?): Specifies the image file format. It can be one of
                the following: "iff", "tiff", "jpeg", "alias", "rgb", "fit"
                "postScriptEPS", "softimage", "wavefrontRLA", "wavefrontEXP".
                C: default is tiff. Q: When queried, it returns a string.
                Properties: create, query, edit
        filterNodes (bool?): Sets the node filter.
                Properties: edit
        finalizeCmd (str?): Specifies the name of the Mel script/procedure
                that is called at the end of each stroke.
                Q: When queried, it returns a string.
                Properties: create, query, edit
        fullpaths (bool?): Specifies whether full path names should
                be used when surface names are passed to scripts. If
                false, just the surface name is passed.
                C: Default is false  Q: When queried, it returns a boolean.
                Properties: create, query, edit
        getArrayAttrCommand (str?): Specifies the name of the Mel script/procedure
                that is called once for every surface that is selected for painting.
                This procedure returns a string, which is interpreted
                as a list of names referring to double array attributes on some
                dependency node.
                Q: When queried, it returns a string.
                Properties: create, query, edit
        getSurfaceCommand (str?): Specifies the name of the Mel script/procedure
                that is called once for every dependency node on the selection list,
                whenever Artisan processes the selection list.
                It returns the name of the surface to paint on.
                Q: When queried, it returns a string.
                Properties: create, query, edit
        getValueCommand (str?): Specifies the name of the Mel script/procedure
                that is called every time a value on the surface is needed
                by the scriptable paint tool.
                Q: When queried, it returns a string.
                Properties: create, query, edit
        history (bool?): If this is a tool command, turn the construction history on
                for the tool in question.
                Properties: create
        image1 (str?): First of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        image2 (str?): Second of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        image3 (str?): Third of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        importfileload (str?): Load the attribute map a specified file.
                Properties: edit
        importfilemode (str?): Specifies the channel to import. The valid
                entries here are: "alpha", "luminance", "red", "green",
                "blue", and "rgb"
                C: Default is "alpha". Q: When queried, it returns a string.
                Properties: create, query, edit
        importreassign (bool?): Specifies if the multiply atrribute maps are to be
                reassigned while importing. Only maps previously exported from
                within Artisan can be reassigned.
                C: Default is FALSE. Q: When queried, it returns a  boolean.
                Properties: create, query, edit
        initializeCmd (str?): Specifies the name of the Mel script/procedure
                that is called in the beginning of each stroke.
                Q: When queried, it returns a string.
                Properties: create, query, edit
        interactiveUpdate (bool?): Specifies how often to transfer the painted values
                into the attribute.
                TRUE: transfer them "continuously" (many times per stroke)
                FALSE: transfer them only at the end of a stroke (on mouse
                button release).
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        lastRecorderCmd (str?): Value of last recorded command.
                Properties: create, query, edit
        lastStampName (str?): Value of the last stamp name.
                Properties: create, query, edit
        lowerradius (float?): Sets the lower size of the brush (only apply on tablet).
                Properties: create, query, edit
        makeStroke (Unknown?): Stroke point values.
                Properties: create, query, edit, multiuse
        mappressure (str?): Sets the tablet pressure mapping when the table
                is used. There are three options:
                "Opacity" - the pressure is mapped to the opacity,
                "Radius" - the is mapped to modify the radius of the brush,
                "Both" - the pressure modifies both the opacity and the radius.
                C: Default is "Opacity". Q: When queried, it returns a string.
                Properties: create, query, edit
        maxvalue (float?): Specifies the maximum value for each attribute.
                C: Default is 1.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        minvalue (float?): Specifies the minimum value for each attribute.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        name (str?): If this is a tool command, name the tool appropriately.
                Properties: create
        objattrArray (str?): An array of all paintable attributes. Each element of
                the array is a string with the following information:
                NodeType.NodeName.AttributeName.MenuType.
                *MenuType: type (level) of the item in the Menu (UI).
                Q: When queried, it returns a string.
                Properties: query
        opacity (float?): Sets the brush opacity.
                C: Default is 1.0. Q: When queried, it returns a float.
                Properties: create, query, edit
        outline (bool?): Specifies if the brush should be drawn.
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        outwhilepaint (bool?): Specifies if the brush outline should be drawn
                while painting.
                C: Default is FALSE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        paintNodeArray (str?): An array of paintable nodes.
                Q: When queried, it returns a string.
                Properties: query
        paintattrselected (str?): An array of selected paintable attributes.
                Each element of the array is a string with the
                following information:
                NodeType.NodeName.AttributeName.
                Properties: edit
        paintmode (str?): Specifies the paint mode. There are two
                possibilities: "screen" and "tangent".
                C: Default is "screen". Q: When queried, it returns a string.
                Properties: create, query, edit
        paintoperationtype (str?): Specifies the operation type used by the
                Paint Tool.  Currently, we support the following
                paint modes: "Paint", "Smear", "Blur", "Erase"
                and "Clone".
                Default is "Paint".
                Properties: create, query, edit
        pickColor (bool?): Set pick color mode on or off
                Properties: create, query, edit
        pickValue (bool?): Toggle for picking
                Properties: create, query, edit
        playbackCursor (Tuple[float, float]?): Values for the playback cursor.
                Properties: create, query, edit, multiuse
        playbackPressure (float?): Valus for the playback pressure.
                Properties: create, query, edit, multiuse
        preserveclonesource (bool?): Whether or not to preserve a clone source.
                Properties: create, query, edit
        profileShapeFile (str?): Passes a name of the image file for the stamp shape
                profile.
                Properties: query, edit
        projective (bool?): Specifies the projective paint mode.
                C: Default is 'false'. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        radius (float?): Sets the size of the brush.
                C: Default is 1.0 cm. Q: When queried, it returns a float.
                Properties: create, query, edit
        rampMaxColor (Tuple[float, float, float]?): Defines a special color to be used when the value is greater than or equal to
                the maximum value.
                Properties: create, query, edit
        rampMinColor (Tuple[float, float, float]?): Defines a special color to be used when the value is less than or equal to the
                minimum value.
                Properties: create, query, edit
        record (bool?): Toggle on for recording.
                Properties: create, query, edit
        reflection (bool?): Specifies the reflection mode.
                C: Default is 'false'. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        reflectionaboutorigin (bool?): Toggle on to reflect about the origin
                Properties: create, query, edit
        reflectionaxis (str?): Specifies the reflection axis. There are three
                possibilities: "x", "y" and "z".
                C: Default is "x". Q: When queried, it returns a string.
                Properties: create, query, edit
        screenRadius (float?): Brush radius on the screen
                Properties: create, query, edit
        selectclonesource (bool?): Toggle on to select the clone source
                Properties: create, query, edit
        selectedattroper (str?): Sets the edit weight operation. Four edit weights
                operations are provided : "absolute" - the value of the weight
                is replaced by the current one, "additive" - the value of the
                weight is added to the current one, "scale" - the value of the
                weight is multiplied by the current one, "smooth" - the value
                of the weight is divided by the current one.
                C: Default is "absolute".  Q: When queried, it returns a string.
                Properties: create, query, edit
        setArrayValueCommand (str?): Specifies the name of the Mel script/procedure
                that is called for each paint stamp. A stamp may affect
                one or more values on the surface. This call rolls up
                all the calls that would be made to setValueCommand
                for the stamp into one call with array arguments.
                Q: When queried, it returns a string.
                Properties: create, query, edit
        setValueCommand (str?): Specifies the name of the Mel script/procedure
                that is called every time a value on the surface is changed.
                Q: When queried, it returns a string.
                Properties: create, query, edit
        showactive (bool?): Sets on/off the display of the surface isoparms.
                C: Default is TRUE. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        stampDepth (float?): Depth of the stamps
                Properties: create, query, edit
        stampProfile (str?): Sets the brush profile of the current stamp.
                Currently, the following profiles are supported:
                "gaussian", "poly", "solid" and "square".
                C: Default is gaussian. Q: When queried, it returns a string.
                Properties: create, query, edit
        stampSpacing (float?): Specifies the stamp spacing. Default is 1.0.
                Properties: create, query, edit
        strokesmooth (str?): Stroke smoothing type name
                Properties: create, query, edit
        surfaceConformedBrushVertices (bool?): Enables/disables the the display of the effective brush area
                as affected vertices.
                Properties: create, query, edit
        tablet (bool?): Returns true if the tablet device is present, false if it is absent
                Properties: query
        tangentOutline (bool?): Enables/disables the display of the brush circle tangent to
                the surface.
                Properties: create, query, edit
        toolCleanupCmd (str?): Specifies the name of the Mel script/procedure
                that is called when this tool is exited.
                Q: When queried, it returns a string.
                Properties: create, query, edit
        toolOffProc (str?): Accepts a strings describing the name of a MEL
                procedure that is invoked whenever the tool is turned off.
                For example, cloth invokes "clothPaintToolOff" when the cloth
                paint tool is turned on. Define this callback if your tool
                requires special functionality when your tool is deactivated.
                It is typical that if you implement a toolOffProc you will
                want to implement a toolOnProc as well (see the -toolOnProc
                flag. In query mode, the name of the currently registered MEL
                command is returned and this will be an empty string if none
                is defined.
                Properties: create, query, edit
        toolOnProc (str?): Accepts a strings describing the name of a MEL
                procedure that is invoked whenever the tool is turned on.
                For example, cloth invokes "clothPaintToolOn" when the cloth
                paint tool is turned on. Define this callback if your tool
                requires special functionality when your tool is activated.
                It is typical that if you implement a toolOnProc you will
                want to implement a toolOffProc as well (see the -toolOffProc
                flag. In query mode, the name of the currently registered MEL
                command is returned and this will be an empty string if none
                is defined.
                Properties: create, query, edit
        toolSetupCmd (str?): Specifies the name of the Mel script/procedure
                that is called once for every selected surface when an
                initial click is received on that surface.
                Q: When queried, it returns a string.
                Properties: create, query, edit
        useColorRamp (bool?): Specifies whether the user defined color ramp should be used to map values
                from to colors.  If this is turned off, the default greyscale feedback
                will be used.
                Properties: create, query, edit
        useMaxMinColor (bool?): Specifies whether the out of range colors should be used.  See rampMinColor
                and rampMaxColor flags for further details.
                Properties: create, query, edit
        usepressure (bool?): Sets the tablet pressure on/off.
                C: Default is false. Q: When queried, it returns a boolean.
                Properties: create, query, edit
        value (float?): Specifies the value for each attribute.
                C: Default is 0.0.  Q: When queried, it returns a float.
                Properties: create, query, edit
        whichTool (str?): The string defines the name of the tool to be
                used for the Artisan context. An example is "artClothPaint".
                In query mode, the tool name for the given context is returned.
                Note: due to the way MEL works, always specify the -query flag
                last when specifying a flag that takes arguments.
                Properties: create, query, edit
        worldRadius (float?): Radius in worldspace
                Properties: create, query, edit

    Returns:
        str: The name of the context created.

    Example:
    """

def arubaNurbsToPoly(*args: str, caching: bool = ..., constructionHistory: bool = ..., localSpace: bool = ..., name: str = ..., nodeState: int = ..., object: bool = ..., worldSpace: bool = ...) -> List[str]:
    """This command tesselates a NURBS surface and produces a polygonal surface.
    The name of the new polygonal surface is returned.
    If construction history is ON, then the name of the new dependency
    node is returned as well.
    Args:
        caching (bool?): Toggle caching for all attributes so that no recomputation is needed
                Properties: create, query, edit
        constructionHistory (bool?): Turn the construction history on or off.
                Properties: create
        localSpace (bool?): Tesselate in local space
                Properties: create
        name (str?): Sets the name of the newly-created node. If it contains
                namespace path, the new node will be created under the
                specified namespace; if the namespace does not exist, it
                will be created.
                Properties: create
        nodeState (int?): Maya dependency nodes have 6 possible states.
                The Normal (0), HasNoEffect (1), and Blocking (2) states can be
                used to alter how the graph is evaluated.



                The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)
                are for internal use only. They temporarily shut off parts of the graph during interaction
                (e.g., manipulation). The understanding is that once the operation is done,
                the state will be reset appropriately, e.g. Waiting-Blocking will reset
                back to Blocking.



                The Normal and Blocking cases apply to all nodes, while
                HasNoEffect is node specific; many nodes do not support this option.
                Plug-ins store state in the MPxNode::state attribute. Anyone can set
                it or check this attribute.  Additional details about each of these 3 states follow.




                State
                Description


                Normal
                The normal node state. This is the default.


                HasNoEffect


                The HasNoEffect option (a.k.a. pass-through), is used in cases where
                there is an operation on an input producing an output of the same data type.
                Nearly all deformers support this state, as do a few other nodes.
                As stated earlier, it is not supported by all nodes.


                Itâ€™s typical to implement support for the HasNoEffect state in
                the nodeâ€™s compute method and to perform appropriate operations.
                Plug-ins can also support HasNoEffect.


                The usual implementation of this state is to copy the input directly to the
                matching output without applying the algorithm in the node. For deformers,
                applying this state leaves the input geometry undeformed on the output.




                Blocking


                This is implemented in the depend node base class and applies to all nodes.
                Blocking is applied during the evaluation phase to connections.
                An evaluation request to a blocked connection will return as failures,
                causing the destination plug to retain its current value. Dirty propagation
                is indirectly affected by this state since blocked connections are never cleaned.


                When a node is set to Blocking the behavior is supposed to be the same as
                if all outgoing connections were broken. As long as nobody requests evaluation
                of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked
                node will still respond to getAttr requests but a getAttr on a
                downstream node will not reevaluate the blocked node.


                Setting the root transform of a hierarchy to Blocking wonâ€™t automatically
                influence child transforms in the hierarchy. To do this, youâ€™d need to
                explicitly set all child nodes to the Blocking state.


                For example, to set all child transforms to Blocking, you could use the
                following script.



                import maya.cmds as cmds
                def blockTree(root):
                nodesToBlock = []
                for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys():
                nodesToBlock += cmds.listConnections(node, source=True, destination=True )
                for node in {source:1 for source in nodesToBlock}.keys():
                cmds.setAttr( '%s.nodeState' % node, 2 )



                Applying this script would continue to draw objects but things would not be animated.




                Default: kdnNormal
                Properties: create, query, edit
        object (bool?): Create the result, or just the dependency node.
                Properties: create
        worldSpace (bool?): Tesselate in world space
                Properties: create

    Returns:
        List[str]: The polygon and optionally the dependency node name

    Example:
    """

def assembly(*args: str, active: str = ..., activeLabel: str = ..., canCreate: str = ..., createOptionBoxProc: Callable = ..., createRepresentation: str = ..., defaultType: str = ..., deleteRepresentation: str = ..., deregister: str = ..., input: str = ..., isAType: str = ..., isTrackingMemberEdits: str = ..., label: str = ..., listRepTypes: bool = ..., listRepTypesProc: Callable = ..., listRepresentations: bool = ..., listTypes: bool = ..., name: str = ..., newRepLabel: str = ..., postCreateUIProc: Callable = ..., proc: Callable = ..., renameRepresentation: str = ..., repLabel: str = ..., repName: str = ..., repNamespace: str = ..., repPostCreateUIProc: str = ..., repPreCreateUIProc: str = ..., repType: str = ..., repTypeLabel: str = ..., repTypeLabelProc: Callable = ..., type: str = ...) -> bool:
    """Command to register assemblies for the scene assembly
    framework, to create them, and to edit and query them.
    Assembly nodes are DAG nodes, and are therefore shown in the various
    DAG editors (Outliner, Hypergraph, Node Editor). At assembly creation time,
    the node name defaults to the node type name.
    The assembly command can create any node that is derived from the assembly
    node base class.  It also acts as a registry of these types, so that various
    scripting callbacks can be defined and registered with the assembly
    command.  These callbacks are invoked by Maya during operations on
    assembly nodes, and can be used to customize behavior.When defining a new type of assembly derived from the assembly node
    base class, a number of procedures can be defined through the assembly
    command to properly integrate the new assembly node type into Maya.
    Most of these procedures are used to integrate the assembly type with the
    Maya user interface, and are not required for non-interactive
    scripting use.  For more information, see the MPxAssembly class
    description in the Maya API documentation.
    Some of the important procedures that can be registered through the assembly
    command are the following:representation, assembly
    Args:
        active (str?): Set the active representation by name, or query the name of the active representation.
                Edit mode can be applied to more than one assembly.
                Query mode will return a single string when only a single assembly is specified,
                and will return an array of strings when multiple assemblies are specified.
                Using an empty string as name means to inactivate the currently active representation.
                Properties: query, edit
        activeLabel (str?): Set the active representation by label, or query the label of the active representation.
                Edit mode can be applied to more than one assembly.
                Query mode will return a single string when only a single assembly is specified,
                and will return an array of strings when multiple assemblies are specified.
                Properties: query, edit
        canCreate (str?): Query the representation types the specific assembly can create.
                Properties: query
        createOptionBoxProc (Callable?): Set or query the option box menu procedure for a specific assembly type.
                The assembly type will be the default type, unless
                the -type flag is used to specify an explicit assembly type.
                Properties: query, edit
        createRepresentation (str?): Create and add a specific type of representation for an assembly.
                If the representation type needs additional parameters, they
                must be specified using the "input" flag. For example, the Maya
                scene assembly reference implementation Cache and Scene
                representations need an input file.
                Properties: edit
        defaultType (str?): Set or query the default type of assembly.  When the assembly
                command is used to perform an operation on an assembly type rather
                than on an assembly object, it will be performed on the default
                type, unless the -type flag is used to specify an explicit assembly type.
                Properties: query, edit
        deleteRepresentation (str?): Delete a specific representation from an assembly.
                Properties: edit
        deregister (str?): Deregister a registered assembly type.
                If the deregistered type is the default type,
                the default type will be set to the empty string.
                Properties: edit
        input (str?): Specify the additional parameters of representation creation procedure
                when creating a representation.
                This flag must be used with createRepresentation flag.
                Properties: edit
        isAType (str?): Query whether the given object is of an assembly type.
                Properties: query
        isTrackingMemberEdits (str?): Query whether the given object is tracking member edits.
                Properties: query
        label (str?): Set or query the label for an assembly type. Assembly type is specified
                with flag "type". If no type specified, the default type is used.
                Properties: query, edit
        listRepTypes (bool?): Query the supported representation types for a given assembly type.  The
                assembly type will be the default type, unless the -type flag is used to
                specify an explicit assembly type.
                Properties: query
        listRepTypesProc (Callable?): Set or query the procedure that provides the representation type list which
                an assembly type supports.  This procedure takes no argument, and
                returns a string array of representation types that represents the full set
                of representation types this assembly type can create.  The assembly type
                for which this procedure applies will be the default type, unless the type
                flag is used to specify an explicit assembly type.
                Properties: query, edit
        listRepresentations (bool?): Query the created representations list for a specific assembly.  The -repType
                flag can be used to filter the list and return representations for a
                single representation type.  If the -repType flag is not used, all created
                representations will be returned.
                Properties: query
        listTypes (bool?): Query the supported assembly types.
                Properties: query
        name (str?): Specify the name of the assembly when creating it.
                Properties: create
        newRepLabel (str?): Specify the representation label to set on representation label edit.
                Properties: edit
        postCreateUIProc (Callable?): Set or query the UI post-creation procedure for a given assembly type.
                This procedure will be invoked by Maya immediately after an assembly of the
                specified type is created from the UI, but not through scripting.  It can be
                used to invoke a dialog, to obtain and set initial parameters on a
                newly-created assembly.  The assembly type will be the default type, unless
                the -type flag is used to specify an explicit assembly type.
                Properties: query, edit
        proc (Callable?): Specify the procedure when setting the representation UI post- or
                pre-creation procedure, for a given assembly type.  The assembly
                type will be the default type, unless the -type flag is used to specify
                an explicit assembly type.
                Properties: edit
        renameRepresentation (str?): Renames the representation that is the argument to this flag.  The
                repName flag must be used to provide the new name.
                Properties: edit
        repLabel (str?): Query or edit the label of the representation that is the argument to this
                flag, for a given assembly.  In both query and edit modes, the -repLabel flag
                specifies the name of the representation.  In edit mode, the -newRepLabel flag
                must be used to specify the new representation label.
                			In query mode, this flag needs a value.
                Properties: query, edit
        repName (str?): Specify the representation name to set on representation creation or rename.
                This flag is optional with the createRepresentation flag: if omitted, the
                assembly will name the representation.  It is mandatory with the
                renameRepresentation flag.
                Properties: edit
        repNamespace (str?): Query the representation namespace of this assembly node.
                The value returned is used by Maya for creating the namespace where nodes created
                by the activation of a representation will be added. If a name clash occurs when the
                namespace is added to its parent namespace, Maya will update repNamespace with the new
                name.
                Two namespaces are involved when dealing with an assembly node: the namespace of the
                assembly node itself (which this flag does not affect or query), and the namespace
                of its representations. The representation namespace is a child of its assembly node's
                namespace. The assembly node's namespace is set by its containing assembly, if it
                is nested, or by the top-level file. Either the assembly node's namespace, or the
                representation namespace, or both, can be the empty string.
                It should be noted that if the assembly node is nested, the assembly
                node's namespace will be (by virtue of its nesting) the
                representation namespace of its containing assembly.
                Properties: query
        repPostCreateUIProc (str?): Set or query the UI post-creation procedure for a specific representation type,
                and for a specific assembly type.  This procedure takes two arguments, the
                first the DAG path to the assembly, and the second the name of the
                representation.  It returns no value.  It will be invoked by Maya
                immediately after a representation of the specified type is created
                from the UI, but not through scripting.  It can be used to invoke a
                dialog, to obtain and set initial parameters on a newly-created
                representation.  The representation type is the argument of this flag.
                The -proc flag must be used to specify the procedure name.  The
                assembly type will be the default type, unless the -type flag is used
                to specify an explicit assembly type.
                			In query mode, this flag needs a value.
                Properties: query, edit
        repPreCreateUIProc (str?): Set or query the UI pre-creation procedure for a specific representation type,
                and for a specific assembly type.  This procedure takes no argument, and
                returns a string that is passed as an argument to the -input flag
                when Maya invokes the assembly command with the -createRepresentation flag.
                The representation pre-creation procedure is invoked by Maya
                immediately before creating a representation of the specified type from the
                UI, but not through scripting.  It can be used to invoke a dialog, to obtain
                the creation argument for a new representation.  The representation type is
                the argument of this flag.  The -proc flag must be used to specify the
                procedure name.  The assembly type will be the default type, unless the
                -type flag is used to specify an explicit assembly type.
                			In query mode, this flag needs a value.
                Properties: query, edit
        repType (str?): Specify a representation type to use as a filter for the -listRepresentations
                query.  The representation type is the argument to this flag.
                			In query mode, this flag needs a value.
                Properties: query
        repTypeLabel (str?): Query the label of the specific representation type.
                			In query mode, this flag needs a value.
                Properties: query
        repTypeLabelProc (Callable?): Set or query the procedure that provides the representation type label,
                for a given assembly type.  The procedure takes the representation type as
                its sole argument, and returns a localized representation type label.
                The assembly type for which this procedure applies will be the
                default type, unless the -type flag is used to specify an explicit
                assembly type.
                Properties: query, edit
        type (str?): Set or query properties for the specified registered assembly type.
                			In query mode, this flag needs a value.
                Properties: create, query, edit

    Returns:
        bool: In query mode, return type is based on queried flag.

    Example:
    """

def assignCommand(arg0: int, /, addDivider: str = ..., altModifier: bool = ..., annotation: str = ..., command: Callable = ..., commandModifier: bool = ..., ctrlModifier: bool = ..., data1: str = ..., data2: str = ..., data3: str = ..., delete: int = ..., dividerString: str = ..., enableCommandRepeat: bool = ..., factorySettings: bool = ..., index: int = ..., keyArray: bool = ..., keyString: str = ..., keyUp: bool = ..., name: bool = ..., numDividersPreceding: int = ..., numElements: bool = ..., optionModifier: bool = ..., sortByKey: bool = ..., sourceUserCommands: bool = ...) -> bool:
    """This command allows the user to assign hotkeys and manipulate the internal
    array of named command objects. Each object in the array has an 1-based
    index which is used for referencing. Under expected usage you should
    not need to use this command directly as the Hotkey Editor may be used
    to assign hotkeys.This command is obsolete for setting new hotkeys, instead please use the "hotkey" command.
    Args:
        addDivider (str?): Appends an "annotated divider" item to the end of the list of
                commands.
                Properties: edit
        altModifier (bool?): This flag specifies if an alt modifier is used for the key.
                Properties: edit
        annotation (str?): The string is the english name describing the command.
                Properties: query, edit
        command (Callable?): This is the command that is executed when this object is
                mapped to a key or menuItem.
                Properties: query, edit
        commandModifier (bool?): This flag specifies if a command modifier is used for the key.
                This is only available on systems which support a separate command key.
                Properties: edit
        ctrlModifier (bool?): This flag specifies if a ctrl modifier is used for the key.
                Properties: edit
        data1 (str?): Optional, user-defined data strings may be attached to
                the nameCommand objects.
                Properties: query, edit
        data2 (str?): Optional, user-defined data strings may be attached to
                the nameCommand objects.
                Properties: query, edit
        data3 (str?): Optional, user-defined data strings may be attached to
                the nameCommand objects.
                Properties: query, edit
        delete (int?): This tells the Manager to delete the object at position index.
                Properties: edit
        dividerString (str?): If the passed index corresponds to a "divider" item, then the
                divider's annotation is returned.  Otherwise, a null string is
                returned.
                Properties: query
        enableCommandRepeat (bool?): This flag specifies whether command repeat is enabled.
                Properties: edit
        factorySettings (bool?): This flag sets the manager back to factory settings.
                Properties: edit
        index (int?): The index of the object to operate on. The index value
                ranges from 1 to the number of name command objects.
                Properties: edit
        keyArray (bool?): This flag returns all of the hotkeys on the command.
                Properties: query
        keyString (str?): This specifies a key to assign a command to in edit mode.
                In query mode this flag returns the key string, modifiers and
                indicates if the command is mapped to keyUp or keyDown.
                Properties: query, edit
        keyUp (bool?): This flag specifies if the command is executed on keyUp
                or keyDown.
                Properties: edit
        name (bool?): The name of the command object.
                Properties: query
        numDividersPreceding (int?): If the index of a namedCommand object C is passed in,
                then this flag returns the number of "divider" items preceding
                C when the namedCommands are sorted by category.
                Properties: query
        numElements (bool?): This command returns the number of namedCommands in the system.
                This flag doesn't require the index to be specified.
                Properties: query
        optionModifier (bool?): This flag specifies if an option modifier is used for the key.
                Properties: edit
        sortByKey (bool?): This key tells the manager to sort by key or by order of
                creation.
                Properties: query, edit
        sourceUserCommands (bool?): This command sources the user named command file.
                Properties: edit

    Returns:
        bool: In query mode, return type is based on queried flag.

    Example:
    """

def assignInputDevice(*args: Any, clutch: str = ..., continuous: bool = ..., device: str = ..., immediate: bool = ..., multiple: bool = ...) -> str:
    """This command associates a command string (i.e. a mel script)
    with the input device.  When the device moves or a button on
    the device is pressed, the command string is executed as if
    you typed it into the window.  If the command string contains
    the names of buttons or axes of the device, the current value
    of these buttons/axes are substituted in.  Buttons are reported
    as booleans and axes as doubles.This command is most useful for associating buttons on a device
    with commands.  For using a device to capture continous movements
    it is much more efficient to attach the device directly into
    the dependency graph.
    Args:
        clutch (str?): specify a clutch button.  This button must be down
                for the command string to be executed.
                If no clutch is specified the command string is
                executed everytime the device state changes
                Properties: create
        continuous (bool?): if this flag is set the command string is continously
                (once for everytime the device changes state).  By
                default if a clutch button is specified the command
                string is only executed once when the button is
                pressed.
                Properties: create
        device (str?): specify which device to assign the command string.
                Properties: create
        immediate (bool?): Immediately executes the command, without using the queue.
                Properties: create
        multiple (bool?): if this flag is set the other command strings
                associated with this device are not deleted.
                By default, when a new command string is attached
                to the device, all other command strings are deleted.
                Properties: create

    Returns:
        str: Command result

    Example:
    """

def assignViewportFactories(arg0: str, /, materialFactory: str = ..., nodeType: str = ..., textureFactory: str = ...) -> bool:
    """Sets viewport factories for displays as materials or textures.assignViewportFactories, registration
    Args:
        materialFactory (str?): Set or query the materialFactory for the node type.
                Properties: create, query, edit
        nodeType (str?): The node type.
                Properties: create, query, edit
        textureFactory (str?): Set or query the textureFactory for the node type.
                Properties: create, query, edit

    Returns:
        bool: In query mode, return type is based on queried flag.

    Example:
    """

def attachCache() -> None: ...
def attachCurve(*args: Unknown, blendBias: float = ..., blendKnotInsertion: bool = ..., caching: bool = ..., keepMultipleKnots: bool = ..., method: int = ..., nodeState: int = ..., parameter: float = ..., reverse1: bool = ..., reverse2: bool = ..., constructionHistory: bool = ..., name: str = ..., object: bool = ..., replaceOriginal: bool = ...) -> List[str]:
    """This attach command is used to attach curves. Once the curves are
    attached, there will be multiple knots at the joined point(s). These
    can be kept or removed if the user wishes.If there are two curves, the end of the first curve is attached to the
    start of the second curve. If there are more than two curves, closest
    endpoints are joined.Note: if the command is done with Keep Original off, the first curve
    is replaced by the attached curve. All other curves will remain, the
    command does not delete them.
    Args:
        blendBias (float?): Skew the result toward the first or the second curve depending
                on the blend factory being smaller or larger than 0.5.
                Default: 0.5
                Properties: create, query, edit
        blendKnotInsertion (bool?): If set to true, insert a knot in one of the original curves
                (relative position given by the parameter attribute below)
                in order to produce a slightly different effect.
                Default: false
                Properties: create, query, edit
        caching (bool?): Toggle caching for all attributes so that no recomputation is needed
                Properties: create, query, edit
        keepMultipleKnots (bool?): If true, keep multiple knots at the join parameter.
                Otherwise remove them.
                Default: true
                Properties: create, query, edit
        method (int?): Attach method (connect-0, blend-1)
                Default: 0
                Properties: create, query, edit
        nodeState (int?): Maya dependency nodes have 6 possible states.
                The Normal (0), HasNoEffect (1), and Blocking (2) states can be
                used to alter how the graph is evaluated.



                The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)
                are for internal use only. They temporarily shut off parts of the graph during interaction
                (e.g., manipulation). The understanding is that once the operation is done,
                the state will be reset appropriately, e.g. Waiting-Blocking will reset
                back to Blocking.



                The Normal and Blocking cases apply to all nodes, while
                HasNoEffect is node specific; many nodes do not support this option.
                Plug-ins store state in the MPxNode::state attribute. Anyone can set
                it or check this attribute.  Additional details about each of these 3 states follow.




                State
                Description


                Normal
                The normal node state. This is the default.


                HasNoEffect


                The HasNoEffect option (a.k.a. pass-through), is used in cases where
                there is an operation on an input producing an output of the same data type.
                Nearly all deformers support this state, as do a few other nodes.
                As stated earlier, it is not supported by all nodes.


                Itâ€™s typical to implement support for the HasNoEffect state in
                the nodeâ€™s compute method and to perform appropriate operations.
                Plug-ins can also support HasNoEffect.


                The usual implementation of this state is to copy the input directly to the
                matching output without applying the algorithm in the node. For deformers,
                applying this state leaves the input geometry undeformed on the output.




                Blocking


                This is implemented in the depend node base class and applies to all nodes.
                Blocking is applied during the evaluation phase to connections.
                An evaluation request to a blocked connection will return as failures,
                causing the destination plug to retain its current value. Dirty propagation
                is indirectly affected by this state since blocked connections are never cleaned.


                When a node is set to Blocking the behavior is supposed to be the same as
                if all outgoing connections were broken. As long as nobody requests evaluation
                of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked
                node will still respond to getAttr requests but a getAttr on a
                downstream node will not reevaluate the blocked node.


                Setting the root transform of a hierarchy to Blocking wonâ€™t automatically
                influence child transforms in the hierarchy. To do this, youâ€™d need to
                explicitly set all child nodes to the Blocking state.


                For example, to set all child transforms to Blocking, you could use the
                following script.



                import maya.cmds as cmds
                def blockTree(root):
                nodesToBlock = []
                for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys():
                nodesToBlock += cmds.listConnections(node, source=True, destination=True )
                for node in {source:1 for source in nodesToBlock}.keys():
                cmds.setAttr( '%s.nodeState' % node, 2 )



                Applying this script would continue to draw objects but things would not be animated.




                Default: kdnNormal
                Properties: create, query, edit
        parameter (float?): The parameter value for the positioning of the newly inserted knot.
                Default: 0.1
                Properties: create, query, edit
        reverse1 (bool?): If true, reverse the first input curve before doing attach.
                Otherwise, do nothing to the first input curve before attaching.
                NOTE: setting this attribute to random values will cause
                unpredictable results and is not supported.
                Default: false
                Properties: create, query, edit
        reverse2 (bool?): If true, reverse the second input curve before doing attach.
                Otherwise, do nothing to the second input curve before
                attaching. NOTE: setting this attribute to random values will
                cause unpredictable results and is not supported.
                Default: false
                Properties: create, query, edit
        constructionHistory (bool?): Turn the construction history on or off.
                Properties: create
        name (str?): Sets the name of the newly-created node. If it contains
                namespace path, the new node will be created under the
                specified namespace; if the namespace does not exist, it
                will be created.
                Properties: create
        object (bool?): Create the result, or just the dependency node.
                Properties: create
        replaceOriginal (bool?): Create "in place" (i.e., replace).
                Properties: create

    Returns:
        List[str]: Object name and node name

    Example:
    """

def attachDeviceAttr(*args: Any, attribute: str = ..., axis: str = ..., camera: bool = ..., cameraRotate: bool = ..., cameraTranslate: bool = ..., clutch: str = ..., device: str = ..., selection: bool = ...) -> bool:
    """This command associates a device/axis pair with a node/attribute pair.
    When the device axis moves, the value of the attribute is set to the
    value of the axis. This value can be scaled and offset using
    the setAttrScale command.
    Args:
        attribute (str?): specify the attribute to attach to
                Properties: create, multiuse
        axis (str?): specify the axis to attach from.
                Properties: create
        camera (bool?): This flag attaches the device/axis to the current camera.
                The mapping between device axes and camera controls is
                uses a heuristic based on the device descripton.
                The interaction is a copy of the mouse camera navigation
                controls.
                Properties: create
        cameraRotate (bool?): This flag attaches the device/axis to the current cameras
                rotation controls.
                Properties: create
        cameraTranslate (bool?): This flag attaches the device/axis to the current cameras
                translate controls.
                Properties: create
        clutch (str?): specify a clutch button.  This button must be down
                for the command string to be executed.
                If no clutch is specified the command string is
                executed everytime the device state changes
                Properties: create
        device (str?): specify which device to assign the command string.
                Properties: create
        selection (bool?): This flag attaches to the nodes in the selection list.
                This is different from the default arguments of the command
                since changing the selection will change the attachments.
                Properties: create

    Returns:
        bool: In query mode, return type is based on queried flag.

    Example:
    """

def attachFluidCache() -> None: ...
def attachGeometryCache() -> None: ...
def attachNclothCache() -> None: ...
def attachSurface(arg0: str, arg1: str, /, blendBias: float = ..., blendKnotInsertion: bool = ..., caching: bool = ..., directionU: bool = ..., keepMultipleKnots: bool = ..., method: int = ..., nodeState: int = ..., parameter: float = ..., reverse1: bool = ..., reverse2: bool = ..., swap1: bool = ..., swap2: bool = ..., twist: bool = ..., constructionHistory: bool = ..., name: str = ..., object: bool = ..., replaceOriginal: bool = ...) -> List[str]:
    """This attach command is used to attach surfaces. Once the surfaces are
    attached, there will be multiple knots at the joined point(s). These
    can be kept or removed if the user wishes.The end of the first surface is attached to the start of the second
    surface in the specified direction.Note: if the command is done with Keep Original off there will be an
    extra surface in the model (the second surface). The command does not
    delete it. The first surface is replaced by the attached surface.
    Args:
        blendBias (float?): Skew the result toward the first or the second curve depending on the blend factory being smaller or larger than 0.5.
                Default: 0.5
                Properties: create, query, edit
        blendKnotInsertion (bool?): If set to true, insert a knot in one of the original curves (relative position given by the parameter attribute below) in order to produce a slightly different effect.
                Default: false
                Properties: create, query, edit
        caching (bool?): Toggle caching for all attributes so that no recomputation is needed
                Properties: create, query, edit
        directionU (bool?): If true attach in U direction of surface and V direction otherwise.
                Default: true
                Properties: create, query, edit
        keepMultipleKnots (bool?): If true, keep multiple knots at the join parameter. Otherwise remove them.
                Default: true
                Properties: create, query, edit
        method (int?): Attach method (connect-0, blend-1)
                Default: 0
                Properties: create, query, edit
        nodeState (int?): Maya dependency nodes have 6 possible states.
                The Normal (0), HasNoEffect (1), and Blocking (2) states can be
                used to alter how the graph is evaluated.



                The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)
                are for internal use only. They temporarily shut off parts of the graph during interaction
                (e.g., manipulation). The understanding is that once the operation is done,
                the state will be reset appropriately, e.g. Waiting-Blocking will reset
                back to Blocking.



                The Normal and Blocking cases apply to all nodes, while
                HasNoEffect is node specific; many nodes do not support this option.
                Plug-ins store state in the MPxNode::state attribute. Anyone can set
                it or check this attribute.  Additional details about each of these 3 states follow.




                State
                Description


                Normal
                The normal node state. This is the default.


                HasNoEffect


                The HasNoEffect option (a.k.a. pass-through), is used in cases where
                there is an operation on an input producing an output of the same data type.
                Nearly all deformers support this state, as do a few other nodes.
                As stated earlier, it is not supported by all nodes.


                Itâ€™s typical to implement support for the HasNoEffect state in
                the nodeâ€™s compute method and to perform appropriate operations.
                Plug-ins can also support HasNoEffect.


                The usual implementation of this state is to copy the input directly to the
                matching output without applying the algorithm in the node. For deformers,
                applying this state leaves the input geometry undeformed on the output.




                Blocking


                This is implemented in the depend node base class and applies to all nodes.
                Blocking is applied during the evaluation phase to connections.
                An evaluation request to a blocked connection will return as failures,
                causing the destination plug to retain its current value. Dirty propagation
                is indirectly affected by this state since blocked connections are never cleaned.


                When a node is set to Blocking the behavior is supposed to be the same as
                if all outgoing connections were broken. As long as nobody requests evaluation
                of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked
                node will still respond to getAttr requests but a getAttr on a
                downstream node will not reevaluate the blocked node.


                Setting the root transform of a hierarchy to Blocking wonâ€™t automatically
                influence child transforms in the hierarchy. To do this, youâ€™d need to
                explicitly set all child nodes to the Blocking state.


                For example, to set all child transforms to Blocking, you could use the
                following script.



                import maya.cmds as cmds
                def blockTree(root):
                nodesToBlock = []
                for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys():
                nodesToBlock += cmds.listConnections(node, source=True, destination=True )
                for node in {source:1 for source in nodesToBlock}.keys():
                cmds.setAttr( '%s.nodeState' % node, 2 )



                Applying this script would continue to draw objects but things would not be animated.




                Default: kdnNormal
                Properties: create, query, edit
        parameter (float?): The parameter value for the positioning of the newly inserted knot.
                Default: 0.1
                Properties: create, query, edit
        reverse1 (bool?): If true, reverse the direction (specified by directionU) of the first input surface before doing attach. Otherwise, do nothing to the first input surface before attaching. NOTE: setting this attribute to random values will cause unpredictable results and is not supported.
                Default: false
                Properties: create, query, edit
        reverse2 (bool?): If true, reverse the direction (specified by directionU) of the second input surface before doing attach. Otherwise, do nothing to the second input surface before attaching. NOTE: setting this attribute to random values will cause unpredictable results and is not supported.
                Default: false
                Properties: create, query, edit
        swap1 (bool?): If true, swap the UV directions of the first input surface before doing attach. Otherwise, do nothing to the first input surface before attaching. NOTE: setting this attribute to random values will cause unpredictable results and is not supported.
                Default: false
                Properties: create, query, edit
        swap2 (bool?): If true, swap the UV directions of the second input surface before doing attach. Otherwise, do nothing to the second input surface before attaching. NOTE: setting this attribute to random values will cause unpredictable results and is not supported.
                Default: false
                Properties: create, query, edit
        twist (bool?): If true, reverse the second surface in the opposite direction (specified by directionU) before doing attach. This will avoid twists in the attached surfaces. Otherwise, do nothing to the second input surface before attaching. NOTE: setting this attribute to random values will cause unpredictable results and is not supported.
                Default: false
                Properties: create, query, edit
        constructionHistory (bool?): Turn the construction history on or off.
                Properties: create
        name (str?): Sets the name of the newly-created node. If it contains
                namespace path, the new node will be created under the
                specified namespace; if the namespace does not exist, it
                will be created.
                Properties: create
        object (bool?): Create the result, or just the dependency node.
                Properties: create
        replaceOriginal (bool?): Create "in place" (i.e., replace).
                Properties: create

    Returns:
        List[str]: Object name and node name

    Example:
    """

def attrColorSliderGrp(arg0: str, /, adjustableColumn: int = ..., adjustableColumn2: int = ..., adjustableColumn3: int = ..., adjustableColumn4: int = ..., adjustableColumn5: int = ..., adjustableColumn6: int = ..., alphaValue: float = ..., annotation: str = ..., attrNavDecision: Tuple[str, str] = ..., attribute: str = ..., backgroundColor: Tuple[float, float, float] = ..., columnAlign: Tuple[int, str] = ..., columnAlign2: Tuple[str, str] = ..., columnAlign3: Tuple[str, str, str] = ..., columnAlign4: Tuple[str, str, str, str] = ..., columnAlign5: Tuple[str, str, str, str, str] = ..., columnAlign6: Tuple[str, str, str, str, str, str] = ..., columnAttach: Tuple[int, str, int] = ..., columnAttach2: Tuple[str, str] = ..., columnAttach3: Tuple[str, str, str] = ..., columnAttach4: Tuple[str, str, str, str] = ..., columnAttach5: Tuple[str, str, str, str, str] = ..., columnAttach6: Tuple[str, str, str, str, str, str] = ..., columnOffset2: Tuple[int, int] = ..., columnOffset3: Tuple[int, int, int] = ..., columnOffset4: Tuple[int, int, int, int] = ..., columnOffset5: Tuple[int, int, int, int, int] = ..., columnOffset6: Tuple[int, int, int, int, int, int] = ..., columnWidth: Tuple[int, int] = ..., columnWidth1: int = ..., columnWidth2: Tuple[int, int] = ..., columnWidth3: Tuple[int, int, int] = ..., columnWidth4: Tuple[int, int, int, int] = ..., columnWidth5: Tuple[int, int, int, int, int] = ..., columnWidth6: Tuple[int, int, int, int, int, int] = ..., defineTemplate: str = ..., docTag: str = ..., dragCallback: Callable = ..., dropCallback: Callable = ..., enable: bool = ..., enableBackground: bool = ..., enableKeyboardFocus: bool = ..., exists: bool = ..., fullPathName: bool = ..., height: int = ..., highlightColor: Tuple[float, float, float] = ..., hsvValue: Tuple[float, float, float] = ..., isObscured: bool = ..., label: str = ..., manage: bool = ..., noBackground: bool = ..., numberOfPopupMenus: bool = ..., parent: str = ..., popupMenuArray: bool = ..., preventOverride: bool = ..., rgbValue: Tuple[float, float, float] = ..., rowAttach: Tuple[int, str, int] = ..., showButton: bool = ..., statusBarMessage: str = ..., useTemplate: str = ..., visible: bool = ..., visibleChangeCommand: Callable = ..., width: int = ...) -> str:
    """All of the group commands position their individual controls in columns
    starting at column 1.  The layout of each control (ie. column) can be
    customized using the, andflags.  By default, columns are left aligned
    with no offset and are 100 pixels wide.  Only one column in any group can
    be adjustable.Create a color slider group consisting of a label, a color canvas,
    a slider and a button.  Clicking on the canvas will bring up the
    color editor.  If the button is visible, it will allow you to map
    a texture to the attribute.
    Args:
        adjustableColumn (int?): Specifies which column has an adjustable size that changes with the
                sizing of the layout.  The column value is a 1. based index.
                Passing 0 as argument turns off the previous adjustable column.
                Properties: create, edit
        adjustableColumn2 (int?): Specifies which column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                two columns.
                Properties: create, edit
        adjustableColumn3 (int?): Specifies that the column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                three columns.
                Properties: create, edit
        adjustableColumn4 (int?): Specifies which column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                four columns.
                Properties: create, edit
        adjustableColumn5 (int?): Specifies which column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                five columns.
                Properties: create, edit
        adjustableColumn6 (int?): Specifies which column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                six columns.
                Properties: create, edit
        alphaValue (float?): Alpha (transparency) of the color. Will show the alpha UI.
                Alpha will be set only if RGB or HSV is also set at the same time.
                Properties: create, query, edit
        annotation (str?): Annotate the control with an extra string value.
                Properties: create, query, edit
        attrNavDecision (Tuple[str, str]?): The first argument is the name of an attribute.
                The button will be attached to the attribute so the button
                can be kept in synch with the attribute.  The second
                argument is the navigatorDecisionString that can guide the
                behaviour that the navigator implements.
                Properties: create, query, edit
        attribute (str?): The name of a unique attribute of type 3double.  This newly
                created field will be attached to the attribute, so that
                modifications to one will change the other.
                Properties: create, query, edit
        backgroundColor (Tuple[float, float, float]?): The background color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                When setting backgroundColor, the background is automatically
                enabled, unless enableBackground is also specified with a false
                value.
                Properties: create, query, edit
        columnAlign (Tuple[int, str]?): Arguments are : column number, alignment type.
                Possible alignments are: left | right | center.
                Specifies alignment type for the specified column.
                Properties: create, edit, multiuse
        columnAlign2 (Tuple[str, str]?): Sets the text alignment of both columns.  Ignored if there are not
                exactly two columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAlign3 (Tuple[str, str, str]?): Sets the text alignment for all three columns.  Ignored if there are not
                exactly three columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAlign4 (Tuple[str, str, str, str]?): Sets the text alignment for all four columns.  Ignored if there are not
                exactly four columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAlign5 (Tuple[str, str, str, str, str]?): Sets the text alignment for all five columns.  Ignored if there are not
                exactly five columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAlign6 (Tuple[str, str, str, str, str, str]?): Sets the text alignment for all six columns.  Ignored if there are not
                exactly six columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAttach (Tuple[int, str, int]?): Arguments are : column number, attachment type, and offset.
                Possible attachments are: left | right | both.
                Specifies column attachment types and offets.
                Properties: create, edit, multiuse
        columnAttach2 (Tuple[str, str]?): Sets the attachment type of both columns. Ignored if there are not
                exactly two columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnAttach3 (Tuple[str, str, str]?): Sets the attachment type for all three columns. Ignored if there are not
                exactly three columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnAttach4 (Tuple[str, str, str, str]?): Sets the attachment type for all four columns. Ignored if there are not
                exactly four columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnAttach5 (Tuple[str, str, str, str, str]?): Sets the attachment type for all five columns. Ignored if there are not
                exactly five columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnAttach6 (Tuple[str, str, str, str, str, str]?): Sets the attachment type for all six columns. Ignored if there are not
                exactly six columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnOffset2 (Tuple[int, int]?): This flag is used in conjunction with the -columnAttach2 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the two columns.  The offsets applied are based on the attachments
                specified with the -columnAttach2 flag.  Ignored if there are not exactly
                two columns.
                Properties: create, edit
        columnOffset3 (Tuple[int, int, int]?): This flag is used in conjunction with the -columnAttach3 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the three columns.  The offsets applied are based on the attachments
                specified with the -columnAttach3 flag.  Ignored if there are not exactly
                three columns.
                Properties: create, edit
        columnOffset4 (Tuple[int, int, int, int]?): This flag is used in conjunction with the -columnAttach4 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the four columns.  The offsets applied are based on the attachments
                specified with the -columnAttach4 flag.  Ignored if there are not exactly
                four columns.
                Properties: create, edit
        columnOffset5 (Tuple[int, int, int, int, int]?): This flag is used in conjunction with the -columnAttach5 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the five columns.  The offsets applied are based on the attachments
                specified with the -columnAttach5 flag.  Ignored if there are not exactly
                five columns.
                Properties: create, edit
        columnOffset6 (Tuple[int, int, int, int, int, int]?): This flag is used in conjunction with the -columnAttach6 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the six columns.  The offsets applied are based on the attachments
                specified with the -columnAttach6 flag.  Ignored if there are not exactly
                six columns.
                Properties: create, edit
        columnWidth (Tuple[int, int]?): Arguments are : column number, column width.
                Sets the width of the specified column where the first parameter specifies
                the column (1 based index) and the second parameter specifies the width.
                Properties: create, edit, multiuse
        columnWidth1 (int?): Sets the width of the first column. Ignored if there is not
                exactly one column.
                Properties: create, edit
        columnWidth2 (Tuple[int, int]?): Sets the column widths of both columns. Ignored if there are not
                exactly two columns.
                Properties: create, edit
        columnWidth3 (Tuple[int, int, int]?): Sets the column widths for all 3 columns. Ignored if there are not
                exactly 3 columns.
                Properties: create, edit
        columnWidth4 (Tuple[int, int, int, int]?): Sets the column widths for all 4 columns. Ignored if there are not
                exactly 4 columns.
                Properties: create, edit
        columnWidth5 (Tuple[int, int, int, int, int]?): Sets the column widths for all 5 columns. Ignored if there are not
                exactly 5 columns.
                Properties: create, edit
        columnWidth6 (Tuple[int, int, int, int, int, int]?): Sets the column widths for all 6 columns. Ignored if there are not
                exactly 6 columns.
                Properties: create, edit
        defineTemplate (str?): Puts the command in a mode where any other flags and arguments are
                parsed and added to the command template specified in the argument.
                They will be used as default arguments in any subsequent
                invocations of the command when templateName is set as the
                current template.
                Properties: create
        docTag (str?): Add a documentation flag to the control.  The documentation flag
                has a directory structure.
                (e.g., -dt render/multiLister/createNode/material)
                Properties: create, query, edit
        dragCallback (Callable?): Adds a callback that is called when the middle mouse button
                is pressed.  The MEL version of the callback is of the form:

                global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods)

                The proc returns a string array that is transferred to the drop site.
                By convention the first string in the array describes the user settable
                message type.  Controls that are application defined drag sources may
                ignore the callback. $mods allows testing for the key modifiers CTRL and
                SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL,
                3 == CTRL + SHIFT.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def callbackName( dragControl, x, y, modifiers ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "x", "y", "modifiers".  The
                "dragControl" value is a string and the other values are integers (eg the
                callback string could be "print '%(dragControl)s %(x)d %(y)d %(modifiers)d'")
                Properties: create, edit
        dropCallback (Callable?): Adds a callback that is called when a drag and drop
                operation is released above the drop site.  The MEL version of the callback is
                of the form:

                global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type)

                The proc receives a string array that is transferred from the drag source.
                The first string in the msgs array describes the user defined message type.
                Controls that are application defined drop sites may ignore the
                callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "dropControl", "messages", "x", "y",
                "type".  The "dragControl" value is a string and the other values are integers
                (eg the callback string could be
                "print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'")
                Properties: create, edit
        enable (bool?): The enable state of the control.  By default, this flag is
                set to true and the control is enabled.  Specify false and the control
                will appear dimmed or greyed-out indicating it is disabled.
                Properties: create, query, edit
        enableBackground (bool?): Enables the background color of the control.
                Properties: create, query, edit
        enableKeyboardFocus (bool?): If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse.
                This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls.
                If disabled, text in text fields can still be selected with the mouse but cannot be copied (except on Linux when "Middle Click Paste" is enabled).
                Properties: create, query, edit
        exists (bool?): Returns whether the
                specified object exists or not. Other flags are ignored.
                Properties: create
        fullPathName (bool?): Return the full path name of the widget, which includes all the parents.
                Properties: query
        height (int?): The height of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit
        highlightColor (Tuple[float, float, float]?): The highlight color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                Properties: create, query, edit
        hsvValue (Tuple[float, float, float]?): Specifies the color in hsv style.
                Properties: create, query, edit
        isObscured (bool?): Return whether the control can actually be seen by the user.
                The control will be obscured if its state is invisible, if it is
                blocked (entirely or partially) by some other control, if it or a
                parent layout is unmanaged, or if the control's window is
                invisible or iconified.
                Properties: query
        label (str?): By default, the label of this field will be the name of the
                attribute.  This flag can be used to override that name with
                whatever the user wants.
                Properties: create, query, edit
        manage (bool?): Manage state of the control.  An unmanaged control is
                not visible, nor does it take up any screen real estate.  All
                controls are created managed by default.
                Properties: create, query, edit
        noBackground (bool?): Clear/reset the control's background.
                Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.
                Properties: create, edit
        numberOfPopupMenus (bool?): Return the number of popup menus attached to this control.
                Properties: query
        parent (str?): The parent layout for this control.
                Properties: create, query
        popupMenuArray (bool?): Return the names of all the popup menus attached to this
                control.
                Properties: query
        preventOverride (bool?): If true, this flag prevents overriding the control's
                attribute via the control's right mouse button menu.
                Properties: create, query, edit
        rgbValue (Tuple[float, float, float]?): Specifies the color in rgb style.
                Properties: create, query, edit
        rowAttach (Tuple[int, str, int]?): Arguments are : column, attachment type, offset.
                Possible attachments are: top | bottom | both.
                Specifies attachment types and offsets for the entire row.
                Properties: create, edit, multiuse
        showButton (bool?): Control the display of the texture link button.
                True by default (show it).
                Properties: create, query, edit
        statusBarMessage (str?): Extra string to display in the status bar when the mouse is over the control.
                Properties: create, edit
        useTemplate (str?): Forces the command to use a command template other than
                the current one.
                Properties: create
        visible (bool?): The visible state of the control.  A control is created
                visible by default.  Note that a control's actual appearance is
                also dependent on the visible state of its parent layout(s).
                Properties: create, query, edit
        visibleChangeCommand (Callable?): Command that gets executed when visible state of the control changes.
                Properties: create, query, edit
        width (int?): The width of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit

    Returns:
        str: (the name of the created group)

    Example:
    """

def attrCompatibility(arg0: str, arg1: str, addAttr: bool = ..., clear: bool = ..., dumpTable: bool = ..., enable: bool = ..., nodeRename: str = ..., pluginNode: str = ..., renameAttr: str = ..., removeAttr: bool = ..., type: str = ..., version: str = ...) -> None: ...
def attrControlGrp(arg0: str, /, annotation: str = ..., attribute: str = ..., changeCommand: Callable = ..., enable: bool = ..., exists: bool = ..., handlesAttribute: str = ..., hideMapButton: bool = ..., label: str = ..., preventOverride: bool = ...) -> str:
    """This command creates a control of the type most appropriate for the specified
    attribute, and associates the control with the attribute. Any change to the
    control will cause a change in the attribute value, and any change to the
    attribute value will be reflected in the control. Not all attribute types are
    supported.attribute, control
    Args:
        annotation (str?): Sets or queries the annotation value of the control group.
                Properties: create, query, edit
        attribute (str?): Sets or queries the attribute the control represents. The name of the attribute
                must be fully specified, including the name of the node. Some types of
                attributes are not supported, but most commonly used attribute types are.
                Properties: create, query, edit
        changeCommand (Callable?): Sets or queries the change command of the control group. The change
                command will be executed when the control is used to change the value
                of the attribute.
                Properties: create, query, edit
        enable (bool?): Sets or queries the enable state of the control group. The control is dimmed if
                the enable state is set to false.
                Properties: create, query, edit
        exists (bool?): Returns whether the
                specified object exists or not. Other flags are ignored.
                Properties: create, query, edit
        handlesAttribute (str?): Returns true or false as to whether this command can create a control for the
                specified attribute.
                			In query mode, this flag needs a value.
                Properties: query, edit
        hideMapButton (bool?): Force the map button to remain hidden for this control.
                Properties: create, query, edit
        label (str?): Sets or queries the label of the control group.
                Properties: create, query, edit
        preventOverride (bool?): Sets or queries the prevent adjustment state of the control group. If true,
                the RMB menu for the control will not allow adjustments to be made.
                Properties: create, query, edit

    Returns:
        str: The control name.

    Example:
    """

def attrEnumOptionMenu(arg0: str, /, annotation: str = ..., attribute: str = ..., backgroundColor: Tuple[float, float, float] = ..., changeCommand: Callable = ..., defineTemplate: str = ..., docTag: str = ..., dragCallback: Callable = ..., dropCallback: Callable = ..., enable: bool = ..., enableBackground: bool = ..., enableKeyboardFocus: bool = ..., enumeratedItem: Tuple[int, str] = ..., exists: bool = ..., fullPathName: bool = ..., height: int = ..., highlightColor: Tuple[float, float, float] = ..., isObscured: bool = ..., label: str = ..., manage: bool = ..., noBackground: bool = ..., numberOfPopupMenus: bool = ..., parent: str = ..., popupMenuArray: bool = ..., preventOverride: bool = ..., statusBarMessage: str = ..., useTemplate: str = ..., visible: bool = ..., visibleChangeCommand: Callable = ..., width: int = ...) -> str:
    """This command creates an enumerated attribute control. It is
    usually an option menu.
    Args:
        annotation (str?): Annotate the control with an extra string value.
                Properties: create, query, edit
        attribute (str?): Attribute that the menu controls.
                Properties: create, edit
        backgroundColor (Tuple[float, float, float]?): The background color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                When setting backgroundColor, the background is automatically
                enabled, unless enableBackground is also specified with a false
                value.
                Properties: create, query, edit
        changeCommand (Callable?): The command string is executed when the value of the
                option menu changes.
                Properties: create, edit
        defineTemplate (str?): Puts the command in a mode where any other flags and arguments are
                parsed and added to the command template specified in the argument.
                They will be used as default arguments in any subsequent
                invocations of the command when templateName is set as the
                current template.
                Properties: create
        docTag (str?): Add a documentation flag to the control.  The documentation flag
                has a directory structure.
                (e.g., -dt render/multiLister/createNode/material)
                Properties: create, query, edit
        dragCallback (Callable?): Adds a callback that is called when the middle mouse button
                is pressed.  The MEL version of the callback is of the form:

                global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods)

                The proc returns a string array that is transferred to the drop site.
                By convention the first string in the array describes the user settable
                message type.  Controls that are application defined drag sources may
                ignore the callback. $mods allows testing for the key modifiers CTRL and
                SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL,
                3 == CTRL + SHIFT.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def callbackName( dragControl, x, y, modifiers ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "x", "y", "modifiers".  The
                "dragControl" value is a string and the other values are integers (eg the
                callback string could be "print '%(dragControl)s %(x)d %(y)d %(modifiers)d'")
                Properties: create, edit
        dropCallback (Callable?): Adds a callback that is called when a drag and drop
                operation is released above the drop site.  The MEL version of the callback is
                of the form:

                global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type)

                The proc receives a string array that is transferred from the drag source.
                The first string in the msgs array describes the user defined message type.
                Controls that are application defined drop sites may ignore the
                callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "dropControl", "messages", "x", "y",
                "type".  The "dragControl" value is a string and the other values are integers
                (eg the callback string could be
                "print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'")
                Properties: create, edit
        enable (bool?): The enable state of the control.  By default, this flag is
                set to true and the control is enabled.  Specify false and the control
                will appear dimmed or greyed-out indicating it is disabled.
                Properties: create, query, edit
        enableBackground (bool?): Enables the background color of the control.
                Properties: create, query, edit
        enableKeyboardFocus (bool?): If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse.
                This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls.
                If disabled, text in text fields can still be selected with the mouse but cannot be copied (except on Linux when "Middle Click Paste" is enabled).
                Properties: create, query, edit
        enumeratedItem (Tuple[int, str]?): Enumerated item and the corresponding string.  If this flag is
                not supplied when the control is created, then the command will
                try to read the values from the attribute.
                Properties: create, multiuse
        exists (bool?): Returns whether the
                specified object exists or not. Other flags are ignored.
                Properties: create
        fullPathName (bool?): Return the full path name of the widget, which includes all the parents.
                Properties: query
        height (int?): The height of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit
        highlightColor (Tuple[float, float, float]?): The highlight color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                Properties: create, query, edit
        isObscured (bool?): Return whether the control can actually be seen by the user.
                The control will be obscured if its state is invisible, if it is
                blocked (entirely or partially) by some other control, if it or a
                parent layout is unmanaged, or if the control's window is
                invisible or iconified.
                Properties: query
        label (str?): The label text.
                Properties: create, query, edit
        manage (bool?): Manage state of the control.  An unmanaged control is
                not visible, nor does it take up any screen real estate.  All
                controls are created managed by default.
                Properties: create, query, edit
        noBackground (bool?): Clear/reset the control's background.
                Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.
                Properties: create, edit
        numberOfPopupMenus (bool?): Return the number of popup menus attached to this control.
                Properties: query
        parent (str?): The parent layout for this control.
                Properties: create, query
        popupMenuArray (bool?): Return the names of all the popup menus attached to this
                control.
                Properties: query
        preventOverride (bool?): If true, this flag prevents overriding the control's
                attribute via the control's right mouse button menu.
                Properties: create, query, edit
        statusBarMessage (str?): Extra string to display in the status bar when the mouse is over the control.
                Properties: create, edit
        useTemplate (str?): Forces the command to use a command template other than
                the current one.
                Properties: create
        visible (bool?): The visible state of the control.  A control is created
                visible by default.  Note that a control's actual appearance is
                also dependent on the visible state of its parent layout(s).
                Properties: create, query, edit
        visibleChangeCommand (Callable?): Command that gets executed when visible state of the control changes.
                Properties: create, query, edit
        width (int?): The width of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit

    Returns:
        str: The full name of the control.

    Example:
    """

def attrEnumOptionMenuGrp(arg0: str, /, adjustableColumn: int = ..., adjustableColumn2: int = ..., adjustableColumn3: int = ..., adjustableColumn4: int = ..., adjustableColumn5: int = ..., adjustableColumn6: int = ..., annotation: str = ..., attribute: str = ..., backgroundColor: Tuple[float, float, float] = ..., columnAlign: Tuple[int, str] = ..., columnAlign2: Tuple[str, str] = ..., columnAlign3: Tuple[str, str, str] = ..., columnAlign4: Tuple[str, str, str, str] = ..., columnAlign5: Tuple[str, str, str, str, str] = ..., columnAlign6: Tuple[str, str, str, str, str, str] = ..., columnAttach: Tuple[int, str, int] = ..., columnAttach2: Tuple[str, str] = ..., columnAttach3: Tuple[str, str, str] = ..., columnAttach4: Tuple[str, str, str, str] = ..., columnAttach5: Tuple[str, str, str, str, str] = ..., columnAttach6: Tuple[str, str, str, str, str, str] = ..., columnOffset2: Tuple[int, int] = ..., columnOffset3: Tuple[int, int, int] = ..., columnOffset4: Tuple[int, int, int, int] = ..., columnOffset5: Tuple[int, int, int, int, int] = ..., columnOffset6: Tuple[int, int, int, int, int, int] = ..., columnWidth: Tuple[int, int] = ..., columnWidth1: int = ..., columnWidth2: Tuple[int, int] = ..., columnWidth3: Tuple[int, int, int] = ..., columnWidth4: Tuple[int, int, int, int] = ..., columnWidth5: Tuple[int, int, int, int, int] = ..., columnWidth6: Tuple[int, int, int, int, int, int] = ..., defineTemplate: str = ..., docTag: str = ..., dragCallback: Callable = ..., dropCallback: Callable = ..., enable: bool = ..., enableBackground: bool = ..., enableKeyboardFocus: bool = ..., enumeratedItem: Tuple[int, str] = ..., exists: bool = ..., fullPathName: bool = ..., height: int = ..., highlightColor: Tuple[float, float, float] = ..., isObscured: bool = ..., label: str = ..., manage: bool = ..., noBackground: bool = ..., numberOfPopupMenus: bool = ..., parent: str = ..., popupMenuArray: bool = ..., preventOverride: bool = ..., rowAttach: Tuple[int, str, int] = ..., statusBarMessage: str = ..., useTemplate: str = ..., visible: bool = ..., visibleChangeCommand: Callable = ..., width: int = ...) -> str:
    """All of the group commands position their individual controls in columns
    starting at column 1.  The layout of each control (ie. column) can be
    customized using the, andflags.  By default, columns are left aligned
    with no offset and are 100 pixels wide.  Only one column in any group can
    be adjustable.This command creates a pre-packaged collection of label and option
    menu button associated with an attribute of a node. The attribute
    should be an integer, and this control allows a UI association of
    strings to the integers of the attribute. When a new menu item is
    choosen the corresponding integer will be assigned to the
    attribute.This control will automatically read the enumeration values from
    the attribute if none are provided.
    Args:
        adjustableColumn (int?): Specifies which column has an adjustable size that changes with the
                sizing of the layout.  The column value is a 1. based index.
                Passing 0 as argument turns off the previous adjustable column.
                Properties: create, edit
        adjustableColumn2 (int?): Specifies which column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                two columns.
                Properties: create, edit
        adjustableColumn3 (int?): Specifies that the column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                three columns.
                Properties: create, edit
        adjustableColumn4 (int?): Specifies which column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                four columns.
                Properties: create, edit
        adjustableColumn5 (int?): Specifies which column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                five columns.
                Properties: create, edit
        adjustableColumn6 (int?): Specifies which column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                six columns.
                Properties: create, edit
        annotation (str?): Annotate the control with an extra string value.
                Properties: create, query, edit
        attribute (str?): The name of an attribute.  The button will be attached
                to the attribute so the button can be kept in synch
                with the attribute.
                Properties: create, edit
        backgroundColor (Tuple[float, float, float]?): The background color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                When setting backgroundColor, the background is automatically
                enabled, unless enableBackground is also specified with a false
                value.
                Properties: create, query, edit
        columnAlign (Tuple[int, str]?): Arguments are : column number, alignment type.
                Possible alignments are: left | right | center.
                Specifies alignment type for the specified column.
                Properties: create, edit, multiuse
        columnAlign2 (Tuple[str, str]?): Sets the text alignment of both columns.  Ignored if there are not
                exactly two columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAlign3 (Tuple[str, str, str]?): Sets the text alignment for all three columns.  Ignored if there are not
                exactly three columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAlign4 (Tuple[str, str, str, str]?): Sets the text alignment for all four columns.  Ignored if there are not
                exactly four columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAlign5 (Tuple[str, str, str, str, str]?): Sets the text alignment for all five columns.  Ignored if there are not
                exactly five columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAlign6 (Tuple[str, str, str, str, str, str]?): Sets the text alignment for all six columns.  Ignored if there are not
                exactly six columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAttach (Tuple[int, str, int]?): Arguments are : column number, attachment type, and offset.
                Possible attachments are: left | right | both.
                Specifies column attachment types and offets.
                Properties: create, edit, multiuse
        columnAttach2 (Tuple[str, str]?): Sets the attachment type of both columns. Ignored if there are not
                exactly two columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnAttach3 (Tuple[str, str, str]?): Sets the attachment type for all three columns. Ignored if there are not
                exactly three columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnAttach4 (Tuple[str, str, str, str]?): Sets the attachment type for all four columns. Ignored if there are not
                exactly four columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnAttach5 (Tuple[str, str, str, str, str]?): Sets the attachment type for all five columns. Ignored if there are not
                exactly five columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnAttach6 (Tuple[str, str, str, str, str, str]?): Sets the attachment type for all six columns. Ignored if there are not
                exactly six columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnOffset2 (Tuple[int, int]?): This flag is used in conjunction with the -columnAttach2 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the two columns.  The offsets applied are based on the attachments
                specified with the -columnAttach2 flag.  Ignored if there are not exactly
                two columns.
                Properties: create, edit
        columnOffset3 (Tuple[int, int, int]?): This flag is used in conjunction with the -columnAttach3 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the three columns.  The offsets applied are based on the attachments
                specified with the -columnAttach3 flag.  Ignored if there are not exactly
                three columns.
                Properties: create, edit
        columnOffset4 (Tuple[int, int, int, int]?): This flag is used in conjunction with the -columnAttach4 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the four columns.  The offsets applied are based on the attachments
                specified with the -columnAttach4 flag.  Ignored if there are not exactly
                four columns.
                Properties: create, edit
        columnOffset5 (Tuple[int, int, int, int, int]?): This flag is used in conjunction with the -columnAttach5 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the five columns.  The offsets applied are based on the attachments
                specified with the -columnAttach5 flag.  Ignored if there are not exactly
                five columns.
                Properties: create, edit
        columnOffset6 (Tuple[int, int, int, int, int, int]?): This flag is used in conjunction with the -columnAttach6 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the six columns.  The offsets applied are based on the attachments
                specified with the -columnAttach6 flag.  Ignored if there are not exactly
                six columns.
                Properties: create, edit
        columnWidth (Tuple[int, int]?): Arguments are : column number, column width.
                Sets the width of the specified column where the first parameter specifies
                the column (1 based index) and the second parameter specifies the width.
                Properties: create, edit, multiuse
        columnWidth1 (int?): Sets the width of the first column. Ignored if there is not
                exactly one column.
                Properties: create, edit
        columnWidth2 (Tuple[int, int]?): Sets the column widths of both columns. Ignored if there are not
                exactly two columns.
                Properties: create, edit
        columnWidth3 (Tuple[int, int, int]?): Sets the column widths for all 3 columns. Ignored if there are not
                exactly 3 columns.
                Properties: create, edit
        columnWidth4 (Tuple[int, int, int, int]?): Sets the column widths for all 4 columns. Ignored if there are not
                exactly 4 columns.
                Properties: create, edit
        columnWidth5 (Tuple[int, int, int, int, int]?): Sets the column widths for all 5 columns. Ignored if there are not
                exactly 5 columns.
                Properties: create, edit
        columnWidth6 (Tuple[int, int, int, int, int, int]?): Sets the column widths for all 6 columns. Ignored if there are not
                exactly 6 columns.
                Properties: create, edit
        defineTemplate (str?): Puts the command in a mode where any other flags and arguments are
                parsed and added to the command template specified in the argument.
                They will be used as default arguments in any subsequent
                invocations of the command when templateName is set as the
                current template.
                Properties: create
        docTag (str?): Add a documentation flag to the control.  The documentation flag
                has a directory structure.
                (e.g., -dt render/multiLister/createNode/material)
                Properties: create, query, edit
        dragCallback (Callable?): Adds a callback that is called when the middle mouse button
                is pressed.  The MEL version of the callback is of the form:

                global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods)

                The proc returns a string array that is transferred to the drop site.
                By convention the first string in the array describes the user settable
                message type.  Controls that are application defined drag sources may
                ignore the callback. $mods allows testing for the key modifiers CTRL and
                SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL,
                3 == CTRL + SHIFT.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def callbackName( dragControl, x, y, modifiers ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "x", "y", "modifiers".  The
                "dragControl" value is a string and the other values are integers (eg the
                callback string could be "print '%(dragControl)s %(x)d %(y)d %(modifiers)d'")
                Properties: create, edit
        dropCallback (Callable?): Adds a callback that is called when a drag and drop
                operation is released above the drop site.  The MEL version of the callback is
                of the form:

                global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type)

                The proc receives a string array that is transferred from the drag source.
                The first string in the msgs array describes the user defined message type.
                Controls that are application defined drop sites may ignore the
                callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "dropControl", "messages", "x", "y",
                "type".  The "dragControl" value is a string and the other values are integers
                (eg the callback string could be
                "print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'")
                Properties: create, edit
        enable (bool?): The enable state of the control.  By default, this flag is
                set to true and the control is enabled.  Specify false and the control
                will appear dimmed or greyed-out indicating it is disabled.
                Properties: create, query, edit
        enableBackground (bool?): Enables the background color of the control.
                Properties: create, query, edit
        enableKeyboardFocus (bool?): If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse.
                This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls.
                If disabled, text in text fields can still be selected with the mouse but cannot be copied (except on Linux when "Middle Click Paste" is enabled).
                Properties: create, query, edit
        enumeratedItem (Tuple[int, str]?): Enumerated item and the corresponding string. If this flag is
                not supplied when the control is created, then the command will
                try to read the values from the attribute.
                Properties: create, multiuse
        exists (bool?): Returns whether the
                specified object exists or not. Other flags are ignored.
                Properties: create
        fullPathName (bool?): Return the full path name of the widget, which includes all the parents.
                Properties: query
        height (int?): The height of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit
        highlightColor (Tuple[float, float, float]?): The highlight color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                Properties: create, query, edit
        isObscured (bool?): Return whether the control can actually be seen by the user.
                The control will be obscured if its state is invisible, if it is
                blocked (entirely or partially) by some other control, if it or a
                parent layout is unmanaged, or if the control's window is
                invisible or iconified.
                Properties: query
        label (str?): Text for the control.
                Properties: create, query, edit
        manage (bool?): Manage state of the control.  An unmanaged control is
                not visible, nor does it take up any screen real estate.  All
                controls are created managed by default.
                Properties: create, query, edit
        noBackground (bool?): Clear/reset the control's background.
                Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.
                Properties: create, edit
        numberOfPopupMenus (bool?): Return the number of popup menus attached to this control.
                Properties: query
        parent (str?): The parent layout for this control.
                Properties: create, query
        popupMenuArray (bool?): Return the names of all the popup menus attached to this
                control.
                Properties: query
        preventOverride (bool?): If true, this flag prevents overriding the control's
                attribute via the control's right mouse button menu.
                Properties: create, query, edit
        rowAttach (Tuple[int, str, int]?): Arguments are : column, attachment type, offset.
                Possible attachments are: top | bottom | both.
                Specifies attachment types and offsets for the entire row.
                Properties: create, edit, multiuse
        statusBarMessage (str?): Extra string to display in the status bar when the mouse is over the control.
                Properties: create, edit
        useTemplate (str?): Forces the command to use a command template other than
                the current one.
                Properties: create
        visible (bool?): The visible state of the control.  A control is created
                visible by default.  Note that a control's actual appearance is
                also dependent on the visible state of its parent layout(s).
                Properties: create, query, edit
        visibleChangeCommand (Callable?): Command that gets executed when visible state of the control changes.
                Properties: create, query, edit
        width (int?): The width of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit

    Returns:
        str: The full name of the control on creation.

    Example:
    """

def attrFieldGrp(arg0: str, /, adjustableColumn: int = ..., adjustableColumn2: int = ..., adjustableColumn3: int = ..., adjustableColumn4: int = ..., adjustableColumn5: int = ..., adjustableColumn6: int = ..., annotation: str = ..., attribute: str = ..., backgroundColor: Tuple[float, float, float] = ..., changeCommand: Callable = ..., columnAlign: Tuple[int, str] = ..., columnAlign2: Tuple[str, str] = ..., columnAlign3: Tuple[str, str, str] = ..., columnAlign4: Tuple[str, str, str, str] = ..., columnAlign5: Tuple[str, str, str, str, str] = ..., columnAlign6: Tuple[str, str, str, str, str, str] = ..., columnAttach: Tuple[int, str, int] = ..., columnAttach2: Tuple[str, str] = ..., columnAttach3: Tuple[str, str, str] = ..., columnAttach4: Tuple[str, str, str, str] = ..., columnAttach5: Tuple[str, str, str, str, str] = ..., columnAttach6: Tuple[str, str, str, str, str, str] = ..., columnOffset2: Tuple[int, int] = ..., columnOffset3: Tuple[int, int, int] = ..., columnOffset4: Tuple[int, int, int, int] = ..., columnOffset5: Tuple[int, int, int, int, int] = ..., columnOffset6: Tuple[int, int, int, int, int, int] = ..., columnWidth: Tuple[int, int] = ..., columnWidth1: int = ..., columnWidth2: Tuple[int, int] = ..., columnWidth3: Tuple[int, int, int] = ..., columnWidth4: Tuple[int, int, int, int] = ..., columnWidth5: Tuple[int, int, int, int, int] = ..., columnWidth6: Tuple[int, int, int, int, int, int] = ..., defineTemplate: str = ..., docTag: str = ..., dragCallback: Callable = ..., dropCallback: Callable = ..., enable: bool = ..., enableBackground: bool = ..., enableKeyboardFocus: bool = ..., exists: bool = ..., extraButton: bool = ..., extraButtonCommand: Callable = ..., extraButtonIcon: str = ..., extraLabel: str = ..., forceAddMapButton: bool = ..., fullPathName: bool = ..., height: int = ..., hideMapButton: bool = ..., highlightColor: Tuple[float, float, float] = ..., isObscured: bool = ..., label: str = ..., manage: bool = ..., maxValue: float = ..., minValue: float = ..., noBackground: bool = ..., numberOfFields: int = ..., numberOfPopupMenus: bool = ..., parent: str = ..., popupMenuArray: bool = ..., precision: int = ..., preventOverride: bool = ..., rowAttach: Tuple[int, str, int] = ..., statusBarMessage: str = ..., step: float = ..., useTemplate: str = ..., visible: bool = ..., visibleChangeCommand: Callable = ..., width: int = ...) -> str:
    """All of the group commands position their individual controls in columns
    starting at column 1.  The layout of each control (ie. column) can be
    customized using the, andflags.  By default, columns are left aligned
    with no offset and are 100 pixels wide.  Only one column in any group can
    be adjustable.This command creates a pre-packaged collection of label text, plus two to
    four float fields.  These fields will be attached to the
    specified vector attribute, so that changes in either will be reflected
    in the other.The fields created here are expression fields -- while normally operating
    as a float field, the user can type in any expression starting with
    the character "-".The field also has an automatic menu brought up by the right mouse
    button.  The contents of this menu change depending on the state of
    the attribute being watched by the field.
    Args:
        adjustableColumn (int?): Specifies which column has an adjustable size that changes with the
                sizing of the layout.  The column value is a 1. based index.
                Passing 0 as argument turns off the previous adjustable column.
                Properties: create, edit
        adjustableColumn2 (int?): Specifies which column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                two columns.
                Properties: create, edit
        adjustableColumn3 (int?): Specifies that the column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                three columns.
                Properties: create, edit
        adjustableColumn4 (int?): Specifies which column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                four columns.
                Properties: create, edit
        adjustableColumn5 (int?): Specifies which column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                five columns.
                Properties: create, edit
        adjustableColumn6 (int?): Specifies which column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                six columns.
                Properties: create, edit
        annotation (str?): Annotate the control with an extra string value.
                Properties: create, query, edit
        attribute (str?): The name of a unique attribute of type vector.  This newly
                created field will be attached to the attribute, so that modifications
                to one will change the other.  A "vector" attribute is any
                compound attribute whose children consist of two to four double-valued
                attributes.
                Properties: create, query, edit
        backgroundColor (Tuple[float, float, float]?): The background color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                When setting backgroundColor, the background is automatically
                enabled, unless enableBackground is also specified with a false
                value.
                Properties: create, query, edit
        changeCommand (Callable?): The command string is executed when the value of any of the
                floatFields change.
                Properties: create, edit
        columnAlign (Tuple[int, str]?): Arguments are : column number, alignment type.
                Possible alignments are: left | right | center.
                Specifies alignment type for the specified column.
                Properties: create, edit, multiuse
        columnAlign2 (Tuple[str, str]?): Sets the text alignment of both columns.  Ignored if there are not
                exactly two columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAlign3 (Tuple[str, str, str]?): Sets the text alignment for all three columns.  Ignored if there are not
                exactly three columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAlign4 (Tuple[str, str, str, str]?): Sets the text alignment for all four columns.  Ignored if there are not
                exactly four columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAlign5 (Tuple[str, str, str, str, str]?): Sets the text alignment for all five columns.  Ignored if there are not
                exactly five columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAlign6 (Tuple[str, str, str, str, str, str]?): Sets the text alignment for all six columns.  Ignored if there are not
                exactly six columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAttach (Tuple[int, str, int]?): Arguments are : column number, attachment type, and offset.
                Possible attachments are: left | right | both.
                Specifies column attachment types and offets.
                Properties: create, edit, multiuse
        columnAttach2 (Tuple[str, str]?): Sets the attachment type of both columns. Ignored if there are not
                exactly two columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnAttach3 (Tuple[str, str, str]?): Sets the attachment type for all three columns. Ignored if there are not
                exactly three columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnAttach4 (Tuple[str, str, str, str]?): Sets the attachment type for all four columns. Ignored if there are not
                exactly four columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnAttach5 (Tuple[str, str, str, str, str]?): Sets the attachment type for all five columns. Ignored if there are not
                exactly five columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnAttach6 (Tuple[str, str, str, str, str, str]?): Sets the attachment type for all six columns. Ignored if there are not
                exactly six columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnOffset2 (Tuple[int, int]?): This flag is used in conjunction with the -columnAttach2 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the two columns.  The offsets applied are based on the attachments
                specified with the -columnAttach2 flag.  Ignored if there are not exactly
                two columns.
                Properties: create, edit
        columnOffset3 (Tuple[int, int, int]?): This flag is used in conjunction with the -columnAttach3 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the three columns.  The offsets applied are based on the attachments
                specified with the -columnAttach3 flag.  Ignored if there are not exactly
                three columns.
                Properties: create, edit
        columnOffset4 (Tuple[int, int, int, int]?): This flag is used in conjunction with the -columnAttach4 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the four columns.  The offsets applied are based on the attachments
                specified with the -columnAttach4 flag.  Ignored if there are not exactly
                four columns.
                Properties: create, edit
        columnOffset5 (Tuple[int, int, int, int, int]?): This flag is used in conjunction with the -columnAttach5 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the five columns.  The offsets applied are based on the attachments
                specified with the -columnAttach5 flag.  Ignored if there are not exactly
                five columns.
                Properties: create, edit
        columnOffset6 (Tuple[int, int, int, int, int, int]?): This flag is used in conjunction with the -columnAttach6 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the six columns.  The offsets applied are based on the attachments
                specified with the -columnAttach6 flag.  Ignored if there are not exactly
                six columns.
                Properties: create, edit
        columnWidth (Tuple[int, int]?): Arguments are : column number, column width.
                Sets the width of the specified column where the first parameter specifies
                the column (1 based index) and the second parameter specifies the width.
                Properties: create, edit, multiuse
        columnWidth1 (int?): Sets the width of the first column. Ignored if there is not
                exactly one column.
                Properties: create, edit
        columnWidth2 (Tuple[int, int]?): Sets the column widths of both columns. Ignored if there are not
                exactly two columns.
                Properties: create, edit
        columnWidth3 (Tuple[int, int, int]?): Sets the column widths for all 3 columns. Ignored if there are not
                exactly 3 columns.
                Properties: create, edit
        columnWidth4 (Tuple[int, int, int, int]?): Sets the column widths for all 4 columns. Ignored if there are not
                exactly 4 columns.
                Properties: create, edit
        columnWidth5 (Tuple[int, int, int, int, int]?): Sets the column widths for all 5 columns. Ignored if there are not
                exactly 5 columns.
                Properties: create, edit
        columnWidth6 (Tuple[int, int, int, int, int, int]?): Sets the column widths for all 6 columns. Ignored if there are not
                exactly 6 columns.
                Properties: create, edit
        defineTemplate (str?): Puts the command in a mode where any other flags and arguments are
                parsed and added to the command template specified in the argument.
                They will be used as default arguments in any subsequent
                invocations of the command when templateName is set as the
                current template.
                Properties: create
        docTag (str?): Add a documentation flag to the control.  The documentation flag
                has a directory structure.
                (e.g., -dt render/multiLister/createNode/material)
                Properties: create, query, edit
        dragCallback (Callable?): Adds a callback that is called when the middle mouse button
                is pressed.  The MEL version of the callback is of the form:

                global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods)

                The proc returns a string array that is transferred to the drop site.
                By convention the first string in the array describes the user settable
                message type.  Controls that are application defined drag sources may
                ignore the callback. $mods allows testing for the key modifiers CTRL and
                SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL,
                3 == CTRL + SHIFT.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def callbackName( dragControl, x, y, modifiers ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "x", "y", "modifiers".  The
                "dragControl" value is a string and the other values are integers (eg the
                callback string could be "print '%(dragControl)s %(x)d %(y)d %(modifiers)d'")
                Properties: create, edit
        dropCallback (Callable?): Adds a callback that is called when a drag and drop
                operation is released above the drop site.  The MEL version of the callback is
                of the form:

                global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type)

                The proc receives a string array that is transferred from the drag source.
                The first string in the msgs array describes the user defined message type.
                Controls that are application defined drop sites may ignore the
                callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "dropControl", "messages", "x", "y",
                "type".  The "dragControl" value is a string and the other values are integers
                (eg the callback string could be
                "print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'")
                Properties: create, edit
        enable (bool?): The enable state of the control.  By default, this flag is
                set to true and the control is enabled.  Specify false and the control
                will appear dimmed or greyed-out indicating it is disabled.
                Properties: create, query, edit
        enableBackground (bool?): Enables the background color of the control.
                Properties: create, query, edit
        enableKeyboardFocus (bool?): If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse.
                This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls.
                If disabled, text in text fields can still be selected with the mouse but cannot be copied (except on Linux when "Middle Click Paste" is enabled).
                Properties: create, query, edit
        exists (bool?): Returns whether the
                specified object exists or not. Other flags are ignored.
                Properties: create
        extraButton (bool?): Add an extra icon button to the end of this control (before extra label).
                Properties: create
        extraButtonCommand (Callable?): The command string is executed when the extra button is clicked.
                Properties: create, edit
        extraButtonIcon (str?): The icon file name of the extra button.
                Properties: create, query, edit
        extraLabel (str?): set an optional string that will be positioned to the right of all the fields.
                Properties: create, query, edit
        forceAddMapButton (bool?): Force adding a map button to this control. If this option is true,
                option hideMapButton is suppressed.
                Properties: create
        fullPathName (bool?): Return the full path name of the widget, which includes all the parents.
                Properties: query
        height (int?): The height of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit
        hideMapButton (bool?): Force the map button to remain hidden for this control.
                Properties: create
        highlightColor (Tuple[float, float, float]?): The highlight color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                Properties: create, query, edit
        isObscured (bool?): Return whether the control can actually be seen by the user.
                The control will be obscured if its state is invisible, if it is
                blocked (entirely or partially) by some other control, if it or a
                parent layout is unmanaged, or if the control's window is
                invisible or iconified.
                Properties: query
        label (str?): By default, the label of this field will be the name of the
                attribute.  This flag can be used to override that name with
                whatever the user wants.
                Properties: create, query, edit
        manage (bool?): Manage state of the control.  An unmanaged control is
                not visible, nor does it take up any screen real estate.  All
                controls are created managed by default.
                Properties: create, query, edit
        maxValue (float?): Sets the maximum value for all fields.
                Properties: create, query, edit
        minValue (float?): Sets the minimum value for all fields.
                Properties: create, query, edit
        noBackground (bool?): Clear/reset the control's background.
                Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.
                Properties: create, edit
        numberOfFields (int?): sets the number of fields.  Only allowed values are 2 to 4.  If not
                specified, defaults to 3.  NOTE: if the -at flag is used when this
                widget is created, the number of children in the attribute will determine
                the number of fields.  Also note:  after creation, the number of fields cannot
                be changed with the -e flag.
                Properties: create
        numberOfPopupMenus (bool?): Return the number of popup menus attached to this control.
                Properties: query
        parent (str?): The parent layout for this control.
                Properties: create, query
        popupMenuArray (bool?): Return the names of all the popup menus attached to this
                control.
                Properties: query
        precision (int?): Sets the precision for all fields
                Properties: create, edit
        preventOverride (bool?): If true, this flag prevents overriding the control's
                attribute via the control's right mouse button menu.
                Properties: create, query, edit
        rowAttach (Tuple[int, str, int]?): Arguments are : column, attachment type, offset.
                Possible attachments are: top | bottom | both.
                Specifies attachment types and offsets for the entire row.
                Properties: create, edit, multiuse
        statusBarMessage (str?): Extra string to display in the status bar when the mouse is over the control.
                Properties: create, edit
        step (float?): Sets the increment for all fields
                Properties: create, query, edit
        useTemplate (str?): Forces the command to use a command template other than
                the current one.
                Properties: create
        visible (bool?): The visible state of the control.  A control is created
                visible by default.  Note that a control's actual appearance is
                also dependent on the visible state of its parent layout(s).
                Properties: create, query, edit
        visibleChangeCommand (Callable?): Command that gets executed when visible state of the control changes.
                Properties: create, query, edit
        width (int?): The width of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit

    Returns:
        str: The full name of the control.

    Example:
    """

def attrFieldSliderGrp(arg0: str, /, adjustableColumn: int = ..., adjustableColumn2: int = ..., adjustableColumn3: int = ..., adjustableColumn4: int = ..., adjustableColumn5: int = ..., adjustableColumn6: int = ..., annotation: str = ..., attribute: str = ..., backgroundColor: Tuple[float, float, float] = ..., changeCommand: Callable = ..., columnAlign: Tuple[int, str] = ..., columnAlign2: Tuple[str, str] = ..., columnAlign3: Tuple[str, str, str] = ..., columnAlign4: Tuple[str, str, str, str] = ..., columnAlign5: Tuple[str, str, str, str, str] = ..., columnAlign6: Tuple[str, str, str, str, str, str] = ..., columnAttach: Tuple[int, str, int] = ..., columnAttach2: Tuple[str, str] = ..., columnAttach3: Tuple[str, str, str] = ..., columnAttach4: Tuple[str, str, str, str] = ..., columnAttach5: Tuple[str, str, str, str, str] = ..., columnAttach6: Tuple[str, str, str, str, str, str] = ..., columnOffset2: Tuple[int, int] = ..., columnOffset3: Tuple[int, int, int] = ..., columnOffset4: Tuple[int, int, int, int] = ..., columnOffset5: Tuple[int, int, int, int, int] = ..., columnOffset6: Tuple[int, int, int, int, int, int] = ..., columnWidth: Tuple[int, int] = ..., columnWidth1: int = ..., columnWidth2: Tuple[int, int] = ..., columnWidth3: Tuple[int, int, int] = ..., columnWidth4: Tuple[int, int, int, int] = ..., columnWidth5: Tuple[int, int, int, int, int] = ..., columnWidth6: Tuple[int, int, int, int, int, int] = ..., defineTemplate: str = ..., docTag: str = ..., dragCallback: Callable = ..., dropCallback: Callable = ..., enable: bool = ..., enableBackground: bool = ..., enableKeyboardFocus: bool = ..., exists: bool = ..., extraButton: bool = ..., extraButtonCommand: Callable = ..., extraButtonIcon: str = ..., fieldMaxValue: float = ..., fieldMinValue: float = ..., fieldStep: float = ..., forceAddMapButton: bool = ..., fullPathName: bool = ..., height: int = ..., hideMapButton: bool = ..., highlightColor: Tuple[float, float, float] = ..., isObscured: bool = ..., label: str = ..., manage: bool = ..., maxValue: float = ..., minValue: float = ..., noBackground: bool = ..., numberOfPopupMenus: bool = ..., parent: str = ..., popupMenuArray: bool = ..., precision: int = ..., preventOverride: bool = ..., rowAttach: Tuple[int, str, int] = ..., sliderMaxValue: float = ..., sliderMinValue: float = ..., sliderStep: float = ..., statusBarMessage: str = ..., step: float = ..., useTemplate: str = ..., vertical: bool = ..., visible: bool = ..., visibleChangeCommand: Callable = ..., width: int = ...) -> str:
    """All of the group commands position their individual controls in columns
    starting at column 1.  The layout of each control (ie. column) can be
    customized using the, andflags.  By default, columns are left aligned
    with no offset and are 100 pixels wide.  Only one column in any group can
    be adjustable.This command creates a pre-packaged collection of label text, float
    field and float slider (for values with a min or max specified)
    The group
    also supports the notion of a larger secondary range of possible
    field values.If an attribute is specified for this object, then it will use any
    min and max values defined in the attribute.  The user-specified
    values can reduce the min and max, but cannot expand them.The field created here
    is an expression field -- while normally operating
    as a float field, the user can type in any expression starting with
    the character "=".  This will expand the field to occupy the space
    previously taken by the slider.The field also has
    an automatic menu brought up by the right mouse button.
    The contents of this menu change depending on the state of
    the attribute being watched by the field.
    Args:
        adjustableColumn (int?): Specifies which column has an adjustable size that changes with the
                sizing of the layout.  The column value is a 1. based index.
                Passing 0 as argument turns off the previous adjustable column.
                Properties: create, edit
        adjustableColumn2 (int?): Specifies which column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                two columns.
                Properties: create, edit
        adjustableColumn3 (int?): Specifies that the column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                three columns.
                Properties: create, edit
        adjustableColumn4 (int?): Specifies which column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                four columns.
                Properties: create, edit
        adjustableColumn5 (int?): Specifies which column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                five columns.
                Properties: create, edit
        adjustableColumn6 (int?): Specifies which column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                six columns.
                Properties: create, edit
        annotation (str?): Annotate the control with an extra string value.
                Properties: create, query, edit
        attribute (str?): The name of a unique attribute of type double or int.
                This newly created field will be attached to the attribute, so
                that modifications to one will change the other.
                Properties: create, query, edit
        backgroundColor (Tuple[float, float, float]?): The background color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                When setting backgroundColor, the background is automatically
                enabled, unless enableBackground is also specified with a false
                value.
                Properties: create, query, edit
        changeCommand (Callable?): The command string is executed when the value of the slider
                or floatField changes.  It will be executed only once after a
                drag of the slider.
                Properties: create, edit
        columnAlign (Tuple[int, str]?): Arguments are : column number, alignment type.
                Possible alignments are: left | right | center.
                Specifies alignment type for the specified column.
                Properties: create, edit, multiuse
        columnAlign2 (Tuple[str, str]?): Sets the text alignment of both columns.  Ignored if there are not
                exactly two columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAlign3 (Tuple[str, str, str]?): Sets the text alignment for all three columns.  Ignored if there are not
                exactly three columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAlign4 (Tuple[str, str, str, str]?): Sets the text alignment for all four columns.  Ignored if there are not
                exactly four columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAlign5 (Tuple[str, str, str, str, str]?): Sets the text alignment for all five columns.  Ignored if there are not
                exactly five columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAlign6 (Tuple[str, str, str, str, str, str]?): Sets the text alignment for all six columns.  Ignored if there are not
                exactly six columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAttach (Tuple[int, str, int]?): Arguments are : column number, attachment type, and offset.
                Possible attachments are: left | right | both.
                Specifies column attachment types and offets.
                Properties: create, edit, multiuse
        columnAttach2 (Tuple[str, str]?): Sets the attachment type of both columns. Ignored if there are not
                exactly two columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnAttach3 (Tuple[str, str, str]?): Sets the attachment type for all three columns. Ignored if there are not
                exactly three columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnAttach4 (Tuple[str, str, str, str]?): Sets the attachment type for all four columns. Ignored if there are not
                exactly four columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnAttach5 (Tuple[str, str, str, str, str]?): Sets the attachment type for all five columns. Ignored if there are not
                exactly five columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnAttach6 (Tuple[str, str, str, str, str, str]?): Sets the attachment type for all six columns. Ignored if there are not
                exactly six columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnOffset2 (Tuple[int, int]?): This flag is used in conjunction with the -columnAttach2 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the two columns.  The offsets applied are based on the attachments
                specified with the -columnAttach2 flag.  Ignored if there are not exactly
                two columns.
                Properties: create, edit
        columnOffset3 (Tuple[int, int, int]?): This flag is used in conjunction with the -columnAttach3 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the three columns.  The offsets applied are based on the attachments
                specified with the -columnAttach3 flag.  Ignored if there are not exactly
                three columns.
                Properties: create, edit
        columnOffset4 (Tuple[int, int, int, int]?): This flag is used in conjunction with the -columnAttach4 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the four columns.  The offsets applied are based on the attachments
                specified with the -columnAttach4 flag.  Ignored if there are not exactly
                four columns.
                Properties: create, edit
        columnOffset5 (Tuple[int, int, int, int, int]?): This flag is used in conjunction with the -columnAttach5 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the five columns.  The offsets applied are based on the attachments
                specified with the -columnAttach5 flag.  Ignored if there are not exactly
                five columns.
                Properties: create, edit
        columnOffset6 (Tuple[int, int, int, int, int, int]?): This flag is used in conjunction with the -columnAttach6 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the six columns.  The offsets applied are based on the attachments
                specified with the -columnAttach6 flag.  Ignored if there are not exactly
                six columns.
                Properties: create, edit
        columnWidth (Tuple[int, int]?): Arguments are : column number, column width.
                Sets the width of the specified column where the first parameter specifies
                the column (1 based index) and the second parameter specifies the width.
                Properties: create, edit, multiuse
        columnWidth1 (int?): Sets the width of the first column. Ignored if there is not
                exactly one column.
                Properties: create, edit
        columnWidth2 (Tuple[int, int]?): Sets the column widths of both columns. Ignored if there are not
                exactly two columns.
                Properties: create, edit
        columnWidth3 (Tuple[int, int, int]?): Sets the column widths for all 3 columns. Ignored if there are not
                exactly 3 columns.
                Properties: create, edit
        columnWidth4 (Tuple[int, int, int, int]?): Sets the column widths for all 4 columns. Ignored if there are not
                exactly 4 columns.
                Properties: create, edit
        columnWidth5 (Tuple[int, int, int, int, int]?): Sets the column widths for all 5 columns. Ignored if there are not
                exactly 5 columns.
                Properties: create, edit
        columnWidth6 (Tuple[int, int, int, int, int, int]?): Sets the column widths for all 6 columns. Ignored if there are not
                exactly 6 columns.
                Properties: create, edit
        defineTemplate (str?): Puts the command in a mode where any other flags and arguments are
                parsed and added to the command template specified in the argument.
                They will be used as default arguments in any subsequent
                invocations of the command when templateName is set as the
                current template.
                Properties: create
        docTag (str?): Add a documentation flag to the control.  The documentation flag
                has a directory structure.
                (e.g., -dt render/multiLister/createNode/material)
                Properties: create, query, edit
        dragCallback (Callable?): Adds a callback that is called when the middle mouse button
                is pressed.  The MEL version of the callback is of the form:

                global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods)

                The proc returns a string array that is transferred to the drop site.
                By convention the first string in the array describes the user settable
                message type.  Controls that are application defined drag sources may
                ignore the callback. $mods allows testing for the key modifiers CTRL and
                SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL,
                3 == CTRL + SHIFT.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def callbackName( dragControl, x, y, modifiers ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "x", "y", "modifiers".  The
                "dragControl" value is a string and the other values are integers (eg the
                callback string could be "print '%(dragControl)s %(x)d %(y)d %(modifiers)d'")
                Properties: create, edit
        dropCallback (Callable?): Adds a callback that is called when a drag and drop
                operation is released above the drop site.  The MEL version of the callback is
                of the form:

                global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type)

                The proc receives a string array that is transferred from the drag source.
                The first string in the msgs array describes the user defined message type.
                Controls that are application defined drop sites may ignore the
                callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "dropControl", "messages", "x", "y",
                "type".  The "dragControl" value is a string and the other values are integers
                (eg the callback string could be
                "print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'")
                Properties: create, edit
        enable (bool?): The enable state of the control.  By default, this flag is
                set to true and the control is enabled.  Specify false and the control
                will appear dimmed or greyed-out indicating it is disabled.
                Properties: create, query, edit
        enableBackground (bool?): Enables the background color of the control.
                Properties: create, query, edit
        enableKeyboardFocus (bool?): If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse.
                This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls.
                If disabled, text in text fields can still be selected with the mouse but cannot be copied (except on Linux when "Middle Click Paste" is enabled).
                Properties: create, query, edit
        exists (bool?): Returns whether the
                specified object exists or not. Other flags are ignored.
                Properties: create
        extraButton (bool?): Add an extra icon button to the end of this control.
                Properties: create
        extraButtonCommand (Callable?): The command string is executed when the extra button is clicked.
                Properties: create, edit
        extraButtonIcon (str?): The icon file name of the extra button.
                Properties: create, query, edit
        fieldMaxValue (float?): Set the maximum value for the field.  This flag allows you
                to specify a maximum bound for the field higher than that
                of the slider.   (See note above
                about max and min values.)
                Properties: create, query, edit
        fieldMinValue (float?): Set the minimum value for the field.  This flag allows you
                to specify a minimum bound for the field lower than that of
                the slider.  (See note above
                about max and min values.)
                Properties: create, query, edit
        fieldStep (float?): Sets the increment for the float field.
                Properties: create, query, edit
        forceAddMapButton (bool?): Force adding a map button to this control. If this option is true,
                option hideMapButton is suppressed.
                Properties: create
        fullPathName (bool?): Return the full path name of the widget, which includes all the parents.
                Properties: query
        height (int?): The height of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit
        hideMapButton (bool?): Force the map button to remain hidden for this control.
                Properties: create
        highlightColor (Tuple[float, float, float]?): The highlight color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                Properties: create, query, edit
        isObscured (bool?): Return whether the control can actually be seen by the user.
                The control will be obscured if its state is invisible, if it is
                blocked (entirely or partially) by some other control, if it or a
                parent layout is unmanaged, or if the control's window is
                invisible or iconified.
                Properties: query
        label (str?): By default, the label of this field will be the name of the
                attribute.  This flag can be used to override that name with
                whatever string you want.
                Properties: create, query, edit
        manage (bool?): Manage state of the control.  An unmanaged control is
                not visible, nor does it take up any screen real estate.  All
                controls are created managed by default.
                Properties: create, query, edit
        maxValue (float?): Sets the maximum value for both the slider and the field.
                (See note above about min and max values)
                Properties: create, query, edit
        minValue (float?): Sets the minimum value for both the slider and the field.
                (by default max and min are set according to what is in the
                attribute, if anything.  If no max and min are specified,
                or if only one of the two are specified, then no slider
                is created.)
                Properties: create, query, edit
        noBackground (bool?): Clear/reset the control's background.
                Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.
                Properties: create, edit
        numberOfPopupMenus (bool?): Return the number of popup menus attached to this control.
                Properties: query
        parent (str?): The parent layout for this control.
                Properties: create, query
        popupMenuArray (bool?): Return the names of all the popup menus attached to this
                control.
                Properties: query
        precision (int?): Sets the number of digits to the right of the decimal.
                (If attached to an int attribute, this is automatically
                set to 0 and cannot be overridden.)
                Properties: create, edit
        preventOverride (bool?): If true, this flag prevents overriding the control's
                attribute via the control's right mouse button menu.
                Properties: create, query, edit
        rowAttach (Tuple[int, str, int]?): Arguments are : column, attachment type, offset.
                Possible attachments are: top | bottom | both.
                Specifies attachment types and offsets for the entire row.
                Properties: create, edit, multiuse
        sliderMaxValue (float?): Set the maximum value for the slider.  The slider
                max will be clipped to the field max.
                Properties: create, query, edit
        sliderMinValue (float?): Set the minimum value for the slider.  The slider min
                will be clipped to the field min.
                Properties: create, query, edit
        sliderStep (float?): On Linux the slider step value represents the
                amount the value will increase or decrease when
                you click either side of the slider.
                Properties: create, query, edit
        statusBarMessage (str?): Extra string to display in the status bar when the mouse is over the control.
                Properties: create, edit
        step (float?): Sets the increment for both the slider and float field.
                Properties: create, query, edit
        useTemplate (str?): Forces the command to use a command template other than
                the current one.
                Properties: create
        vertical (bool?): Whether the orientation of the controls in this group
                are horizontal (default) or vertical.
                Properties: create, query
        visible (bool?): The visible state of the control.  A control is created
                visible by default.  Note that a control's actual appearance is
                also dependent on the visible state of its parent layout(s).
                Properties: create, query, edit
        visibleChangeCommand (Callable?): Command that gets executed when visible state of the control changes.
                Properties: create, query, edit
        width (int?): The width of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit

    Returns:
        str: Full path name to the control.

    Example:
    """

def attrNavigationControlGrp(arg0: str, /, adjustableColumn: int = ..., adjustableColumn2: int = ..., adjustableColumn3: int = ..., adjustableColumn4: int = ..., adjustableColumn5: int = ..., adjustableColumn6: int = ..., annotation: str = ..., attrNavDecision: Tuple[str, str] = ..., attribute: str = ..., backgroundColor: Tuple[float, float, float] = ..., columnAlign: Tuple[int, str] = ..., columnAlign2: Tuple[str, str] = ..., columnAlign3: Tuple[str, str, str] = ..., columnAlign4: Tuple[str, str, str, str] = ..., columnAlign5: Tuple[str, str, str, str, str] = ..., columnAlign6: Tuple[str, str, str, str, str, str] = ..., columnAttach: Tuple[int, str, int] = ..., columnAttach2: Tuple[str, str] = ..., columnAttach3: Tuple[str, str, str] = ..., columnAttach4: Tuple[str, str, str, str] = ..., columnAttach5: Tuple[str, str, str, str, str] = ..., columnAttach6: Tuple[str, str, str, str, str, str] = ..., columnOffset2: Tuple[int, int] = ..., columnOffset3: Tuple[int, int, int] = ..., columnOffset4: Tuple[int, int, int, int] = ..., columnOffset5: Tuple[int, int, int, int, int] = ..., columnOffset6: Tuple[int, int, int, int, int, int] = ..., columnWidth: Tuple[int, int] = ..., columnWidth1: int = ..., columnWidth2: Tuple[int, int] = ..., columnWidth3: Tuple[int, int, int] = ..., columnWidth4: Tuple[int, int, int, int] = ..., columnWidth5: Tuple[int, int, int, int, int] = ..., columnWidth6: Tuple[int, int, int, int, int, int] = ..., connectAttrToDropped: Callable = ..., connectNodeToDropped: Callable = ..., connectToExisting: Callable = ..., createNew: Callable = ..., defaultTraversal: Callable = ..., defineTemplate: str = ..., delete: str = ..., disconnect: Callable = ..., docTag: str = ..., dragCallback: Callable = ..., dropCallback: Callable = ..., enable: bool = ..., enableBackground: bool = ..., enableKeyboardFocus: bool = ..., exists: bool = ..., extraButton: bool = ..., extraButtonCommand: Callable = ..., extraButtonIcon: str = ..., fullPathName: bool = ..., height: int = ..., highlightColor: Tuple[float, float, float] = ..., ignore: Callable = ..., ignoreNotSupported: bool = ..., isObscured: bool = ..., label: str = ..., manage: bool = ..., noBackground: bool = ..., noIgnorableMenu: bool = ..., noKeyableMenu: bool = ..., numberOfPopupMenus: bool = ..., parent: str = ..., popupMenuArray: bool = ..., preventOverride: bool = ..., relatedNodes: Callable = ..., rowAttach: Tuple[int, str, int] = ..., statusBarMessage: str = ..., unignore: Callable = ..., useTemplate: str = ..., visible: bool = ..., visibleChangeCommand: Callable = ..., width: int = ...) -> str:
    """All of the group commands position their individual controls in columns
    starting at column 1.  The layout of each control (ie. column) can be
    customized using the, andflags.  By default, columns are left aligned
    with no offset and are 100 pixels wide.  Only one column in any group can
    be adjustable.This command creates a pre-packaged label
    navigation button.The group is used to help the user manage connections to
    a particular attribute.When creating the control you have the opportunity to attach
    scripts to the control that are executed on various
    UI events.  You can define what happens when the navigation
    button is pressed, and when a node is dragged and dropped
    onto this attribute.The navigation button can traverse to the connected node
    or can bring up UI to create new connections to the attribute.
    The button also can show you state information: if there
    already exists a connection/if the connection is ignored.
    Args:
        adjustableColumn (int?): Specifies which column has an adjustable size that changes with the
                sizing of the layout.  The column value is a 1. based index.
                Passing 0 as argument turns off the previous adjustable column.
                Properties: create, edit
        adjustableColumn2 (int?): Specifies which column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                two columns.
                Properties: create, edit
        adjustableColumn3 (int?): Specifies that the column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                three columns.
                Properties: create, edit
        adjustableColumn4 (int?): Specifies which column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                four columns.
                Properties: create, edit
        adjustableColumn5 (int?): Specifies which column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                five columns.
                Properties: create, edit
        adjustableColumn6 (int?): Specifies which column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                six columns.
                Properties: create, edit
        annotation (str?): Annotate the control with an extra string value.
                Properties: create, query, edit
        attrNavDecision (Tuple[str, str]?): The first argument is the name of an attribute.
                The button will be attached to the attribute so the button
                can be kept in synch with the attribute.  The second
                argument is the navigatorDecisionString that can guide the
                behaviour that the navigator implements.
                Properties: create, query, edit
        attribute (str?): The name of an attribute. The button will be attached
                to the attribute so the button can be kept in synch
                with the attribute.
                Properties: create, query, edit
        backgroundColor (Tuple[float, float, float]?): The background color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                When setting backgroundColor, the background is automatically
                enabled, unless enableBackground is also specified with a false
                value.
                Properties: create, query, edit
        columnAlign (Tuple[int, str]?): Arguments are : column number, alignment type.
                Possible alignments are: left | right | center.
                Specifies alignment type for the specified column.
                Properties: create, edit, multiuse
        columnAlign2 (Tuple[str, str]?): Sets the text alignment of both columns.  Ignored if there are not
                exactly two columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAlign3 (Tuple[str, str, str]?): Sets the text alignment for all three columns.  Ignored if there are not
                exactly three columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAlign4 (Tuple[str, str, str, str]?): Sets the text alignment for all four columns.  Ignored if there are not
                exactly four columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAlign5 (Tuple[str, str, str, str, str]?): Sets the text alignment for all five columns.  Ignored if there are not
                exactly five columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAlign6 (Tuple[str, str, str, str, str, str]?): Sets the text alignment for all six columns.  Ignored if there are not
                exactly six columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAttach (Tuple[int, str, int]?): Arguments are : column number, attachment type, and offset.
                Possible attachments are: left | right | both.
                Specifies column attachment types and offets.
                Properties: create, edit, multiuse
        columnAttach2 (Tuple[str, str]?): Sets the attachment type of both columns. Ignored if there are not
                exactly two columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnAttach3 (Tuple[str, str, str]?): Sets the attachment type for all three columns. Ignored if there are not
                exactly three columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnAttach4 (Tuple[str, str, str, str]?): Sets the attachment type for all four columns. Ignored if there are not
                exactly four columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnAttach5 (Tuple[str, str, str, str, str]?): Sets the attachment type for all five columns. Ignored if there are not
                exactly five columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnAttach6 (Tuple[str, str, str, str, str, str]?): Sets the attachment type for all six columns. Ignored if there are not
                exactly six columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnOffset2 (Tuple[int, int]?): This flag is used in conjunction with the -columnAttach2 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the two columns.  The offsets applied are based on the attachments
                specified with the -columnAttach2 flag.  Ignored if there are not exactly
                two columns.
                Properties: create, edit
        columnOffset3 (Tuple[int, int, int]?): This flag is used in conjunction with the -columnAttach3 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the three columns.  The offsets applied are based on the attachments
                specified with the -columnAttach3 flag.  Ignored if there are not exactly
                three columns.
                Properties: create, edit
        columnOffset4 (Tuple[int, int, int, int]?): This flag is used in conjunction with the -columnAttach4 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the four columns.  The offsets applied are based on the attachments
                specified with the -columnAttach4 flag.  Ignored if there are not exactly
                four columns.
                Properties: create, edit
        columnOffset5 (Tuple[int, int, int, int, int]?): This flag is used in conjunction with the -columnAttach5 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the five columns.  The offsets applied are based on the attachments
                specified with the -columnAttach5 flag.  Ignored if there are not exactly
                five columns.
                Properties: create, edit
        columnOffset6 (Tuple[int, int, int, int, int, int]?): This flag is used in conjunction with the -columnAttach6 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the six columns.  The offsets applied are based on the attachments
                specified with the -columnAttach6 flag.  Ignored if there are not exactly
                six columns.
                Properties: create, edit
        columnWidth (Tuple[int, int]?): Arguments are : column number, column width.
                Sets the width of the specified column where the first parameter specifies
                the column (1 based index) and the second parameter specifies the width.
                Properties: create, edit, multiuse
        columnWidth1 (int?): Sets the width of the first column. Ignored if there is not
                exactly one column.
                Properties: create, edit
        columnWidth2 (Tuple[int, int]?): Sets the column widths of both columns. Ignored if there are not
                exactly two columns.
                Properties: create, edit
        columnWidth3 (Tuple[int, int, int]?): Sets the column widths for all 3 columns. Ignored if there are not
                exactly 3 columns.
                Properties: create, edit
        columnWidth4 (Tuple[int, int, int, int]?): Sets the column widths for all 4 columns. Ignored if there are not
                exactly 4 columns.
                Properties: create, edit
        columnWidth5 (Tuple[int, int, int, int, int]?): Sets the column widths for all 5 columns. Ignored if there are not
                exactly 5 columns.
                Properties: create, edit
        columnWidth6 (Tuple[int, int, int, int, int, int]?): Sets the column widths for all 6 columns. Ignored if there are not
                exactly 6 columns.
                Properties: create, edit
        connectAttrToDropped (Callable?): The script to execute when a node is dragged and dropped
                onto an attribute (multilister dnd attribute editor).
                Your script should take in two arguments: the source node
                and destination attribute respectively.
                Properties: create, query, edit
        connectNodeToDropped (Callable?): The script to execute when a node is dragged and dropped
                onto a node (the multilister issues this).  Your script
                should take in two arguments: the source node and
                destination node respectively.
                Properties: create, query, edit
        connectToExisting (Callable?): The script to execute when a connection should be
                made to an existing node.
                Properties: create, query, edit
        createNew (Callable?): The script to execute when a new "connection" is
                requested.
                Properties: create, query, edit
        defaultTraversal (Callable?): The script to execute to find out the name of the default
                traversal node.  The script you attach should be able to
                take in one argument (the attribute) and return the name
                of the node that is the default traversal node.
                Properties: create, query, edit
        defineTemplate (str?): Puts the command in a mode where any other flags and arguments are
                parsed and added to the command template specified in the argument.
                They will be used as default arguments in any subsequent
                invocations of the command when templateName is set as the
                current template.
                Properties: create
        delete (str?): The script to execute when the connection (and the node
                connected to) should be deleted.
                Properties: create, query, edit
        disconnect (Callable?): The script to execute when a "disconnection" is
                requested.
                Properties: create, query, edit
        docTag (str?): Add a documentation flag to the control.  The documentation flag
                has a directory structure.
                (e.g., -dt render/multiLister/createNode/material)
                Properties: create, query, edit
        dragCallback (Callable?): Adds a callback that is called when the middle mouse button
                is pressed.  The MEL version of the callback is of the form:

                global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods)

                The proc returns a string array that is transferred to the drop site.
                By convention the first string in the array describes the user settable
                message type.  Controls that are application defined drag sources may
                ignore the callback. $mods allows testing for the key modifiers CTRL and
                SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL,
                3 == CTRL + SHIFT.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def callbackName( dragControl, x, y, modifiers ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "x", "y", "modifiers".  The
                "dragControl" value is a string and the other values are integers (eg the
                callback string could be "print '%(dragControl)s %(x)d %(y)d %(modifiers)d'")
                Properties: create, edit
        dropCallback (Callable?): Adds a callback that is called when a drag and drop
                operation is released above the drop site.  The MEL version of the callback is
                of the form:

                global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type)

                The proc receives a string array that is transferred from the drag source.
                The first string in the msgs array describes the user defined message type.
                Controls that are application defined drop sites may ignore the
                callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "dropControl", "messages", "x", "y",
                "type".  The "dragControl" value is a string and the other values are integers
                (eg the callback string could be
                "print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'")
                Properties: create, edit
        enable (bool?): The enable state of the control.  By default, this flag is
                set to true and the control is enabled.  Specify false and the control
                will appear dimmed or greyed-out indicating it is disabled.
                Properties: create, query, edit
        enableBackground (bool?): Enables the background color of the control.
                Properties: create, query, edit
        enableKeyboardFocus (bool?): If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse.
                This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls.
                If disabled, text in text fields can still be selected with the mouse but cannot be copied (except on Linux when "Middle Click Paste" is enabled).
                Properties: create, query, edit
        exists (bool?): Returns whether the
                specified object exists or not. Other flags are ignored.
                Properties: create
        extraButton (bool?): Add an extra icon button to the last of this control.
                Properties: create
        extraButtonCommand (Callable?): The command string is executed when the extra button is clicked.
                Properties: create, edit
        extraButtonIcon (str?): The icon file name of the extra button.
                Properties: create, query, edit
        fullPathName (bool?): Return the full path name of the widget, which includes all the parents.
                Properties: query
        height (int?): The height of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit
        highlightColor (Tuple[float, float, float]?): The highlight color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                Properties: create, query, edit
        ignore (Callable?): The script to execute when the connection should be
                ignored.
                Properties: create, query, edit
        ignoreNotSupported (bool?): Obsolete flag; has no effect.
        isObscured (bool?): Return whether the control can actually be seen by the user.
                The control will be obscured if its state is invisible, if it is
                blocked (entirely or partially) by some other control, if it or a
                parent layout is unmanaged, or if the control's window is
                invisible or iconified.
                Properties: query
        label (str?): Text for the control.
                Properties: create, query, edit
        manage (bool?): Manage state of the control.  An unmanaged control is
                not visible, nor does it take up any screen real estate.  All
                controls are created managed by default.
                Properties: create, query, edit
        noBackground (bool?): Clear/reset the control's background.
                Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.
                Properties: create, edit
        noIgnorableMenu (bool?): Not show ignorable related popup menu when right click the label.
                Properties: create, edit
        noKeyableMenu (bool?): Not show keyable related popup menu when right click the label.
                Properties: create, edit
        numberOfPopupMenus (bool?): Return the number of popup menus attached to this control.
                Properties: query
        parent (str?): The parent layout for this control.
                Properties: create, query
        popupMenuArray (bool?): Return the names of all the popup menus attached to this
                control.
                Properties: query
        preventOverride (bool?): If true, this flag prevents overriding the control's
                attribute via the control's right mouse button menu.
                Properties: create, query, edit
        relatedNodes (Callable?): The script to execute to find out what the related
                nodes are.  The script you attach should be able to
                take in one argument (the attribute) and return a list
                of strings that are the name of the nodes that are
                related.
                Properties: create, query, edit
        rowAttach (Tuple[int, str, int]?): Arguments are : column, attachment type, offset.
                Possible attachments are: top | bottom | both.
                Specifies attachment types and offsets for the entire row.
                Properties: create, edit, multiuse
        statusBarMessage (str?): Extra string to display in the status bar when the mouse is over the control.
                Properties: create, edit
        unignore (Callable?): The script to execute when the connection should be
                unignored.
                Properties: create, query, edit
        useTemplate (str?): Forces the command to use a command template other than
                the current one.
                Properties: create
        visible (bool?): The visible state of the control.  A control is created
                visible by default.  Note that a control's actual appearance is
                also dependent on the visible state of its parent layout(s).
                Properties: create, query, edit
        visibleChangeCommand (Callable?): Command that gets executed when visible state of the control changes.
                Properties: create, query, edit
        width (int?): The width of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit

    Returns:
        str: Full path name to the control.

    Example:
    """

def attributeInfo(*args: str, allAttributes: bool = ..., bool: bool = ..., enumerated: bool = ..., hidden: bool = ..., inherited: bool = ..., internal: bool = ..., leaf: bool = ..., logicalAnd: bool = ..., multi: bool = ..., short: bool = ..., userInterface: bool = ..., writable: bool = ..., type: str = ...) -> List[str]:
    """This command lists all of the attributes that are marked with certain
    flags.  Combinations of flags may be specified and all will be considered.
    (The method of combination depends on the state of the "logicalAnd/and" flag.)
    When the "allAttributes/all" flag is specified, attributes of all
    types will be listed.attribute
    Args:
        allAttributes (bool?): Show all attributes associated with the node regardless of type.
                Use of this flag overrides any other attribute type flags and logical operation
                that may be specified on the command.
                Properties: create
        bool (bool?): Show the attributes that are of type boolean.
                Use the 'on' state to get only boolean attributes; the 'off' state
                to ignore boolean attributes.
                Properties: create
        enumerated (bool?): Show the attributes that are of type enumerated.
                Use the 'on' state to get only enumerated attributes; the 'off' state
                to ignore enumerated attributes.
                Properties: create
        hidden (bool?): Show the attributes that are marked as hidden.
                Use the 'on' state to get hidden attributes; the 'off' state
                to get non-hidden attributes.
                Properties: create
        inherited (bool?): Filter the attributes based on whether they belong to the node type directly
                or have been inherited from a root type (e.g. meshShape/direct or
                dagObject/inherited).
                Use the 'on' state to get only inherited attributes, the 'off' state
                to get only directly owned attributes, and leave the flag unspecified to
                get both.
                Properties: create
        internal (bool?): Show the attributes that are marked as internal to the node.
                Use the 'on' state to get internal attributes; the 'off' state
                to get non-internal attributes.
                Properties: create
        leaf (bool?): Show the attributes that are complex leaves (ie. that have parent attributes
                and have no children themselves).
                Use the 'on' state to get leaf attributes; the 'off' state
                to get non-leaf attributes.
                Properties: create
        logicalAnd (bool?): The default is to take the logical 'or' of the above conditions.
                Specifying this flag switches to the logical 'and' instead.
                Properties: create
        multi (bool?): Show the attributes that are multis.
                Use the 'on' state to get multi attributes; the 'off' state
                to get non-multi attributes.
                Properties: create
        short (bool?): Show the short attribute names instead of the long names.
                Properties: create
        userInterface (bool?): Show the UI-friendly attribute names instead of the Maya ASCII names.
                Takes precedence over the -s/-short flag if both are specified.
                Properties: create
        writable (bool?): Show the attributes that are writable (ie. can have input connections).
                Use the 'on' state to get writable attributes; the 'off' state
                to get non-writable attributes.
                Properties: create
        type (str?): static node type from which to get 'affects' information
                Properties: create

    Returns:
        List[str]: List of attributes matching criteria

    Example:
    """

def attributeMenu(*args: Any, beginMenu: bool = ..., editor: str = ..., finishMenu: bool = ..., inputs: bool = ..., plug: str = ..., regPulldownMenuCommand: str = ..., unregPulldownMenuCommand: int = ...) -> str:
    """Action to generate popup connection menus for Hypershade. This command is
    used internally by the Hypershade panel.render, hypergraph, shader, hypershade
    Args:
        beginMenu (bool?): If true the menu will be used to start a connection edit so it will list all
                available attributes for either inputs or outputs.  If false the menu will
                be used to complete a connection so it will list only the attributes
                compatible with the attribute at the other end of the connection.  A
                plug must be supplied in this case.
                Properties: create
        editor (str?): Name of the Hypergraph, Hypershade or Visor editor for which this menu
                is being built.  This argument is no longer mandatory. If it is omitted,
                the inputs flag and the node must be used to specify the search targets.
                This allows attributeMenu to be used in the absence of a hypershade editor.
                Properties: create
        finishMenu (bool?): finishes the menu
                Properties: create
        inputs (bool?): If true only attributes which can be used as inputs will be listed.  If
                false only attributes which can be used as outputs will be listed
                Properties: create
        plug (str?): If inputs is false then we are completing a connection and the name
                of the plug at the other end of the connection must be supplied.
                Properties: create
        regPulldownMenuCommand (str?): This flag will register a callback that allows the user to define their own popup menu
                for a specific node type for use in the Hypershade and Hypergraph editor.
                The command signature should look like this:

                global proc int proc_name>(string $editorName, string $nodeName, string $plug, string $mode, string $menuType)

                The method should return 0 if it does not recognize the node type
                and the default attributeMenu popup menu will be displayed.
                If the callback returns one then the menu is considered built and no other menuItems will be
                added to the popup. The return value from this flag will be the ID to use for the -unregPulldownMenuCommand flag.
                Properties: create
        unregPulldownMenuCommand (int?): This flag will unregister a callback procedure that was registered with the -regPulldownMenuCommand flag.
                The argument should be the integer identifier returned from the -regPulldownMenuCommand flag.
                Properties: create

    Returns:
        str: Command result

    Example:
    """

def attributeName(arg0: Tuple[str], /, leaf: bool = ..., long: bool = ..., nice: bool = ..., short: bool = ...) -> str:
    """This command takes one "node.attribute"-style specifier on the command line
    and returns either the attribute's long, short, or nice name.  (The "nice" name,
    or UI name, is the name used to display the attribute in Maya's interface, and
    may be localized when running Maya in a language other than English.)
    If more than one "node.attribute" specifier is given on the command line,
    only the first valid specifier is processed.query, attribute, nice, name
    Args:
        leaf (bool?): When false, shows parent multi attributes (like
                "controlPoints[2].xValue").  When true, shows only the
                leaf-level attribute name (like "xValue").  Default is true.
                Note that for incomplete attribute strings, like a missing
                multi-parent index ("controlPoints.xValue") or an
                incorrectly named compound (cntrlPnts[2].xValue), this
                flag defaults to true and provides a result as long as the
                named leaf-level attribute is defined for the node.
                Properties: create
        long (bool?): Returns names in "long name" format like "translateX"
                Properties: create
        nice (bool?): Returns names in "nice name" format like "Translate X"
                Properties: create
        short (bool?): Returns names in "short name" format like "tx"
                Properties: create

    Returns:
        str: Command result

    Example:
    """

def attributeQuery(arg0: str, /, affectsAppearance: bool = ..., affectsWorldspace: bool = ..., attributeType: bool = ..., cachedInternally: bool = ..., categories: bool = ..., channelBox: bool = ..., connectable: bool = ..., enum: bool = ..., exists: bool = ..., hidden: bool = ..., indeterminant: bool = ..., indexMatters: bool = ..., internal: bool = ..., internalGet: bool = ..., internalSet: bool = ..., keyable: bool = ..., listChildren: bool = ..., listDefault: bool = ..., listEnum: bool = ..., listParent: bool = ..., listSiblings: bool = ..., localizedListEnum: bool = ..., longName: bool = ..., maxExists: bool = ..., maximum: bool = ..., message: bool = ..., minExists: bool = ..., minimum: bool = ..., multi: bool = ..., niceName: bool = ..., node: str = ..., numberOfChildren: bool = ..., range: bool = ..., rangeExists: bool = ..., readable: bool = ..., renderSource: bool = ..., shortName: bool = ..., softMax: bool = ..., softMaxExists: bool = ..., softMin: bool = ..., softMinExists: bool = ..., softRange: bool = ..., softRangeExists: bool = ..., storable: bool = ..., type: str = ..., typeExact: str = ..., usedAsColor: bool = ..., usedAsFilename: bool = ..., usesMultiBuilder: bool = ..., worldspace: bool = ..., writable: bool = ...) -> List[float]:
    """attributeQuery returns information about the configuration of an attribute.
    It handles both boolean flags, returning true or false, as well as other return values.
    Specifying more than one boolean flag will return the logical "and"
    of all the specified boolean flags.  You may not specify any two flags when both do not
    provide a boolean return type.  (eg. "-internal -hidden" is okay but "-range -hidden" or
    "-range -softRange" is not.)dg, dependency, graph, attribute, query
    Args:
        affectsAppearance (bool?): Return true if the attribute affects the appearance of the node
                Properties: create
        affectsWorldspace (bool?): Return the status of the attribute flag marking attributes affecting worldspace
                Properties: create
        attributeType (bool?): Return the name of the attribute type (will be the same type names as described in the addAttr and addExtension commands).
                Properties: create
        cachedInternally (bool?): Return whether the attribute is cached within the node as well as in the datablock
                Properties: create
        categories (bool?): Return the categories to which the attribute belongs or an empty list if it does not belong to any.
                Properties: create
        channelBox (bool?): Return whether the attribute should show up in the channelBox or not
                Properties: create
        connectable (bool?): Return the connectable status of the attribute
                Properties: create
        enum (bool?): Return true if the attribute is a enum attribute
                Properties: create
        exists (bool?): Return true if the attribute exists
                Properties: create
        hidden (bool?): Return the hidden status of the attribute
                Properties: create
        indeterminant (bool?): Return true if this attribute might be used in evaluation but it's not known for sure until evaluation time
                Properties: create
        indexMatters (bool?): Return the indexMatters status of the attribute
                Properties: create
        internal (bool?): Return true if the attribute is either internalSet or internalGet
                Properties: create
        internalGet (bool?): Return true if the attribute come from getCachedValue
                Properties: create
        internalSet (bool?): Return true if the attribute must be set through setCachedValue
                Properties: create
        keyable (bool?): Return the keyable status of the attribute
                Properties: create
        listChildren (bool?): Return the list of children attributes of the given attribute.
                Properties: create
        listDefault (bool?): Return the default values of numeric and compound numeric attributes.
                Properties: create
        listEnum (bool?): Return the list of enum strings for the given attribute.
                Properties: create
        listParent (bool?): Return the parent of the given attribute.
                Properties: create
        listSiblings (bool?): Return the list of sibling attributes of the given attribute.
                Properties: create
        localizedListEnum (bool?): Return the list of localized enum strings for the given attribute.
                Properties: create
        longName (bool?): Return the long name of the attribute.
                Properties: create
        maxExists (bool?): Return true if the attribute has a hard maximum. A min does not have to be present.
                Properties: create
        maximum (bool?): Return the hard maximum of the attribute's value
                Properties: create
        message (bool?): Return true if the attribute is a message attribute
                Properties: create
        minExists (bool?): Return true if the attribute has a hard minimum. A max does not have to be present.
                Properties: create
        minimum (bool?): Return the hard minimum of the attribute's value
                Properties: create
        multi (bool?): Return true if the attribute is a multi-attribute
                Properties: create
        niceName (bool?): Return the nice name (or "UI name") of the attribute.
                Properties: create
        node (str?): Use all attributes from node named NAME
                Properties: create
        numberOfChildren (bool?): Return the number of children the attribute has
                Properties: create
        range (bool?): Return the hard range of the attribute's value
                Properties: create
        rangeExists (bool?): Return true if the attribute has a hard range. Both min and max must be present.
                Properties: create
        readable (bool?): Return the readable status of the attribute
                Properties: create
        renderSource (bool?): Return whether this attribute is marked as a render source or not
                Properties: create
        shortName (bool?): Return the short name of the attribute.
                Properties: create
        softMax (bool?): Return the soft max (slider range) of the attribute's value
                Properties: create
        softMaxExists (bool?): Return true if the attribute has a soft maximum. A min does not have to be present.
                Properties: create
        softMin (bool?): Return the soft min (slider range) of the attribute's value
                Properties: create
        softMinExists (bool?): Return true if the attribute has a soft minimum. A max does not have to be present.
                Properties: create
        softRange (bool?): Return the soft range (slider range) of the attribute's value
                Properties: create
        softRangeExists (bool?): Return true if the attribute has a soft range. Both min and max must be present.
                Properties: create
        storable (bool?): Return true if the attribute is storable
                Properties: create
        type (str?): Use static attributes from nodes of type TYPE.  Includes attributes inherited from parent class nodes.
                Properties: create
        typeExact (str?): Use static attributes only from nodes of type TYPE.  Does not included inherited attributes.
                Properties: create
        usedAsColor (bool?): Return true if the attribute should bring up a color picker
                Properties: create
        usedAsFilename (bool?): Return true if the attribute should bring up a file browser
                Properties: create
        usesMultiBuilder (bool?): Return true if the attribute is a multi-attribute and it uses the multi-builder to handle its data
                Properties: create
        worldspace (bool?): Return the status of the attribute flag marking worldspace attribute
                Properties: create
        writable (bool?): Return the writable status of the attribute
                Properties: create

    Returns:
        List[float]: when querying ranges or default values

    Example:
    """

def audioTrack(*args: str, insertTrack: Unknown = ..., lock: bool = ..., mute: bool = ..., numTracks: Unknown = ..., removeEmptyTracks: bool = ..., removeTrack: Unknown = ..., solo: bool = ..., swapTracks: Tuple[Unknown, Unknown] = ..., title: str = ..., track: Unknown = ...) -> bool:
    """This command is used for inserting and removing tracks related to the audio clips displayed in the sequencer. It can also be used to modify the track state, for example, to lock or mute a track.shot, audio, sequencer, track
    Args:
        insertTrack (Unknown?): This flag is used to insert a new empty track at the track index specified. Indices are 1. based.
                Properties: create
        lock (bool?): This flag specifies whether all audio clips on the same track as the specified audio node are to be locked at their current location and track.
                Properties: create, query, edit
        mute (bool?): This flag specifies whether all audio clips on the same track as the specified audio node are to be muted or not.
                Properties: create, query, edit
        numTracks (Unknown?): To query the number of audio tracks
                Properties: query
        removeEmptyTracks (bool?): This flag is used to remove all tracks that have no clips.
                Properties: create
        removeTrack (Unknown?): This flag is used to remove the track with the specified index.  The
                track must have no clips on it before it can be removed.
                Properties: create
        solo (bool?): This flag specifies whether all audio clips on the same track as the specified audio node are to be soloed or not.
                Properties: create, query, edit
        swapTracks (Tuple[Unknown, Unknown]?): This flag is used to swap the contents of two specified tracks. Indices are 1. based.
                Properties: create
        title (str?): This flag specifies the title for the track.
                Properties: create, query, edit
        track (Unknown?): Specify the track on which to operate by using the track's trackNumber.
                			In query mode, this flag needs a value.
                Properties: create, query, edit

    Returns:
        bool: In query mode, return type is based on queried flag.

    Example:
    """

def autoKeyframe(addAttr: str = ..., characterOption: str = ..., listAttr: bool = ..., noReset: bool = ..., state: bool = ...) -> int:
    """With no flags, this command will set keyframes on all
    attributes that have been modified since an "autoKeyframe -state on"
    command was issued.  To stop keeping track of modified attributes,
    use "autoKeyframe -state off"autoKeyframe does not create new animation curves.  An attribute
    must have already been keyframed (with the setKeyframe command)
    for autoKeyframe to  add new keyframes for modified attributes.You can also query the current state of autoKeyframing
    with "autoKeyframe -query -state".
    Args:
        addAttr (str?): Add to the list of plugs (node.attribute) that autoKeyframe is currently
                considering for auto keying.  This list is transient and short-lived, and
                is reset as soon as autoKeyframe sets the keyframe or decides that no
                keyframe is to be set, on completion of the next set attribute.
                Properties: edit
        characterOption (str?): Valid options are: "standard", "all". Dictates whether
                when auto-keying characters the auto-key works as usual or whether
                it keys all of the character attributes. Default is "standard".
                Properties: create, query, edit
        listAttr (bool?): Returns the list of plugs (node.attribute) that autoKeyframe is currently
                considering for auto keying.  This list is transient and short-lived, and
                is reset as soon as autoKeyframe sets the keyframe or decides that no
                keyframe is to be set, on completion of the next set attribute.
                Properties: query
        noReset (bool?): Must be used in conjunction with the state/st flag.
                When noReset/nr is specified, the list of plugs to be autokeyed
                is not cleared when the state changes
                Properties: create, edit
        state (bool?): turns on/off remembering of modified attributes
                Properties: create, query, edit

    Returns:
        int: Number of keyframes set.

    Example:
    """

def autoPlace(useMouse: bool = ...) -> List[float]:
    """This command takes a point in the centre of the current
    modeling pane and projects it onto the live surface.
    This produces a point in 3 space which is returned.
    If theflag is set the current mouse position
    is used rather than the centre of the modeling pane.
    Args:
        useMouse (bool?): Use the current mouse position rather than the centre of the
                active view.
                Properties: create

    Returns:
        List[float]: Placement location in 3D space

    Example:
    """

def autoSave(destination: int = ..., destinationFolder: bool = ..., enable: bool = ..., folder: str = ..., interval: float = ..., limitBackups: bool = ..., maxBackups: int = ..., perform: bool = ..., prompt: bool = ...) -> bool:
    """Provides an interface to the auto-save mechanism.
    Args:
        destination (int?): Sets the option for where auto-save files go.
                0. auto-saves go into the workspace autosave folder
                1. auto-saves go into the named folder (set with the -folder flag)
                2. auto-saves go into a folder set by an environment variable (MAYA_AUTOSAVE_FOLDER)
                Properties: create, query
        destinationFolder (bool?): Queries the actual destination folder for auto-saves, based on the current
                setting of the -destination flag, workspace rules and environment variables.
                Resolves environment variables etc. and makes any relative path
                absolute (resolved relative to the workspace root).
                The returned string will end with a trailing separator ('/').
                Properties: query
        enable (bool?): Enables or disables auto-saves.
                Properties: create, query
        folder (str?): Sets the folder for auto-saves used if the destination option is 1.
                Properties: create, query
        interval (float?): Sets the interval between auto-saves (in seconds).
                The default interval is 600 seconds (10 minutes).
                Properties: create, query
        limitBackups (bool?): Sets whether the number of auto-save files is limited.
                Properties: create, query
        maxBackups (int?): Sets the maximum number of auto-save files, if limiting is in effect.
                Properties: create, query
        perform (bool?): Invokes the auto-save process.
                Properties: create
        prompt (bool?): Sets whether the auto-save prompts the user before auto-saving.
                Properties: create, query

    Returns:
        bool: In query mode, return type is based on queried flag.

    Example:
    """

def backgroundEvaluationManager(*args: str, interrupt: bool = ..., mode: str = ..., pause: bool = ..., resume: bool = ...) -> bool:
    """Allows user to pause and restart background evaluations.async, background, time, evaluation, manager, DG, runtime
    Args:
        interrupt (bool?): Enable or disable fast interrupt of background execution during interactive workflow.
                Properties: create, query
        mode (str?): Changes the current evaluation mode in the evaluation manager. Supported values are
                "serial" and "parallel".
                Properties: create, query
        pause (bool?): Pause background evaluation. Will block till background evaluation is fully stopped.
                Can be queried to get the current state.
                Properties: create, query
        resume (bool?): Resume background evaluation. Will start suspended evaluations unless someones else requested it.
                Properties: create

    Returns:
        bool: In query mode, return type is based on queried flag.

    Example:
    """

def bakeClip(*args: str, blend: Tuple[Unknown, Unknown] = ..., clipIndex: Unknown = ..., keepOriginals: bool = ..., name: str = ...) -> str:
    """This command is used to bake clips and blends into a single clip.character, clip, blend, animation, bake
    Args:
        blend (Tuple[Unknown, Unknown]?): Specify the indices of the clips being blended.
                Properties: create
        clipIndex (Unknown?): Specify the index of the clip to bake.
                Properties: create, multiuse
        keepOriginals (bool?): Keep original clips in the trax editor and place the merged clip into the visor. The default is to schedule the merged clip, and to keep the original clips in the visor.
                Properties: create
        name (str?): Specify the name of the new clip to create.
                Properties: create

    Returns:
        str: clip name

    Example:
    """

def bakeDeformer(colorizeSkeleton: bool = ..., customRangeOfMotion: Unknown = ..., dstMeshName: str = ..., dstSkeletonName: str = ..., hierarchy: bool = ..., influences: List[str] = ..., maxInfluences: int = ..., pruneWeights: float = ..., smoothWeights: int = ..., srcMeshName: str = ..., srcSkeletonName: str = ...) -> str:
    """Given a rigged character, whose mesh shape is determined by a set of deformers, bakeDeformer calculates linear blend skin weights most closely approximating observed deformations. To do this, a test set of examples is generated by moving the rig through a range of motion. Results mesh and pose pairs are then used to solve a constrained optimization, solving for skinning weights. bakeDeformer automatically binds and applies resulting weights to the destination geometry. If the source and destination mesh/skeleton are identical, the command will replace the original deformations with a skinCluster and computed weights. See the below examples for sample usage.bake, skinning, deformer
    Args:
        colorizeSkeleton (bool?): The new skin cluster created will have its skeleton colorized. Must be used with the -srcSkeletonName and -dstSkeletonName flags.
                Properties: create
        customRangeOfMotion (Unknown?): When this flag is specified with the frames for the range of motion to be used, the tool will step through
                each frame as a separate pose. Otherwise the tool will use the existing range of motion in the tool
                that rotates each influence 45 degrees.

                    Usage examples:

                 -rom "10. 20" means all frames in the range from 10 to 20, inclusive, in the current time unit.
                 Omitting one end of a range means using either end of the animation range (or both), as in the following examples:
                 -rom "10. " means all frames from time 10 (in the current time unit) onwards to the maximum time in the animation range (on the timeline).
                 -rom ":10" means all frames from the minimum time on the animation range (on the timeline) up to (and including) time 10 (in the current time unit).
                 -rom ":" is a short form to specify all frames, from minimum to maximum time on the current animation range.


                When using this flag, some of the joints in the specified range of motion may not have changed sufficiently.
                To improve bakeDeformer results or avoid algorithm errors, the command will return a list of influences that do not move enough in the specified range of motion.
                To detect these joints, the local transformation of each joint is compared between subsequent frames.
                We consider that a joint has sufficiently changed if any of the below criteria are met:

                There is a rotation of at least 5 degrees, as determined by the shortest rotation between transforms.
                There is a translation of 1% or greater of the size of the largest bounding box containing all joints for each frame.
                There is a scaling change of at least 1%. This percentage represents the smallest scaling value over the largest scaling value (in absolute value).


                    If a joint has not met any of the criteria, it will be added to the warning of joints that have not moved enough.



                The custom range of motion should be considered experimental.
                Properties: create
        dstMeshName (str?): The destination mesh name.
                Properties: create
        dstSkeletonName (str?): The destination skeleton name.
                Properties: create
        hierarchy (bool?): All children of the passed joints that are used in the influences flag are used.
                Properties: create
        influences (List[str]?): A list of joints that are used as the influences to determine new weights.
                Properties: create
        maxInfluences (int?): The maximum number of influences per vertex.
                Properties: create
        pruneWeights (float?): On the newly created skin cluster, set any weight below the given the value to zero (post-processing).
                This will call the skinPercent command as follows: "skinPercent -pruneWeights [value] [skinClusterName] [dstMeshName]"
                where [value] is the value passed into this flag, [skinClusterName] is the name of the new skinCluster node created
                after running this tool, and [dstMeshName] is the mesh provided in the -dstMeshName flag.
                Properties: create
        smoothWeights (int?): The number of smoothing iterations for smoothing weights (post-processing). This also renormalizes the remaining the weights.
                Properties: create
        srcMeshName (str?): The source mesh name.
                Properties: create
        srcSkeletonName (str?): The source skeleton name.
                Properties: create

    Returns:
        str: BakeDeformer name

    Example:
    """

def bakePartialHistory(*args: str, allShapes: bool = ..., postSmooth: bool = ..., preCache: bool = ..., preDeformers: bool = ..., prePostDeformers: bool = ...) -> str:
    """This command is used to bake sections of the construction history of a shape node
    when possible. A typical usage would be on a shape that has both modelling operations
    and deformers in its history. Using this command with the -prePostDeformers flag will
    bake the modeling portions of the graph, so that only the deformers remain.Note that not all modeling operations can be baked such that they create exactly the
    same effect after baking. For example, imagine the history contains a skinning operation
    followed by a smooth. Before baking, the smooth operation is performed each time
    the skin deforms, so it will smooth differently depending on the output of the skin.
    When the smooth operation is baked into the skinning, the skin will be reweighted
    based on the smooth points to attempt to approximate the original behavior. However,
    the skin node does not perform the smooth operation, it merely performs skinning with
    the newly calculated weights and the result will not be identical to before the bake.In general, modeling operations that occur before deformers can be baked precisely.
    Those which occur after can only be approximated. The -pre and -post flags allow you
    to control whether only the operations before or after the deformers are baked.When the command is used on an object with no deformers, the entire history
    will be deleted.deformers, history, bake
    Args:
        allShapes (bool?): Specifies that the bake operation should be performed on all shapes in the entire scene. By default, only selected objects are baked.
                If this option is specified and there are no shapes in the scene, then this command will do nothing and end successfully.
                Properties: create, query
        postSmooth (bool?): Specifies whether or not a smoothing operation should be done on skin vertices. This
                smoothing is only done on vertices that are found to deviate largely from other
                vertex values.  The default is false.
                Properties: create, query
        preCache (bool?): Specifies baking of any history operations that occur before the caching operation, including deformers. In query mode, returns a list of the nodes that will be baked.
                Properties: create, query
        preDeformers (bool?): Specifies baking of any modeling operations in the history that occur before the deformers. In query mode, returns a list of the nodes that will be baked.
                Properties: create, query
        prePostDeformers (bool?): Specifies baking of all modeling operations in the history whether they are before or after the deformers in the history. If neither the -prePostDeformers nor the -preDeformers flag is specified, prePostDeformers will be used as the default. In query mode, returns a list of the nodes that will be baked.
                Properties: create, query

    Returns:
        str: name of shapes that were baked

    Example:
    """

def bakeResults(*args: str, animation: str = ..., attribute: str = ..., bakeOnOverrideLayer: bool = ..., controlPoints: bool = ..., destinationLayer: str = ..., disableImplicitControl: bool = ..., float: Unknown = ..., hierarchy: str = ..., includeUpperBound: bool = ..., index: Unknown = ..., minimizeRotation: bool = ..., oversamplingRate: Unknown = ..., preserveOutsideKeys: bool = ..., removeBakedAnimFromLayer: bool = ..., removeBakedAttributeFromLayer: bool = ..., resolveWithoutLayer: str = ..., sampleBy: int = ..., shape: bool = ..., simulation: bool = ..., smart: Unknown = ..., sparseAnimCurveBake: bool = ..., time: Unknown = ...) -> int:
    """This command allows the user to replace a chain of dependency nodes
    which define the value for an attribute with a single animation curve.
    Command allows the user to specify the range and frequency of sampling.This command operates on a keyset. A keyset is
    defined as a group of keys within a specified time range on one or
    more animation curves.The animation curves comprising a keyset depend on the value
    of the "-animation" flag:Note that the "-animation" flag can be used to override
    the curves uniquely identified by the multi-use
    "-attribute" flag, which takes an argument of the form
    attributeName, such as "translateX".Keys on animation curves are identified by either
    their time values or their indices. Times and indices should
    be specified as a range, as shown below.
    Args:
        animation (str?): Where this command should get the animation to act
                on. Valid values are "objects," "keys," and
                "keysOrObjects" Default: "keysOrObjects." See
                command description for details.
                Properties: create
        attribute (str?): List of attributes to select
                      In query mode, this flag needs a value.
                Properties: create, multiuse
        bakeOnOverrideLayer (bool?): If true, all layered and baked attribute will be added as a top override layer.
                Properties: create
        controlPoints (bool?): This flag explicitly specifies whether or not to include the
                control points of a shape (see "-s" flag) in the list of attributes.
                Default: false.  (Not valid for "pasteKey" cmd.)
                In query mode, this flag needs a value.
                Properties: create
        destinationLayer (str?): This flag can be used to specify an existing layer where the baked results
                should be stored. Use this flag with caution. If the destination layer already has animation on it
                that contributes to the final result, it will be replaced by the output of the bake. As a result,
                it is possible that the combined animation visible in the scene is different before / after the baking
                process.
                Properties: create
        disableImplicitControl (bool?): Whether to disable implicit control after the anim curves
                are obtained as the result of this command. An implicit control
                to an attribute is some function that affects the attribute
                without using an explicit dependency graph connection. The
                control of IK, via ik handles, is an example.
                Properties: create
        float (Unknown?): value uniquely representing a non-time-based
                key (or key range) on a time-based animCurve. Valid
                floatRange include single values (-f 10) or a
                string with a lower and upper bound, separated by a
                colon (-f "10. 20")
                      In query mode, this flag needs a value.
                Properties: create, multiuse
        hierarchy (str?): Hierarchy expansion options.  Valid values are "above,"
                "below," "both," and "none." (Not valid for "pasteKey" cmd.)
                In query mode, this flag needs a value.
                Properties: create
        includeUpperBound (bool?): When the -t/time or -f/float flags represent a range
                of keys, this flag determines whether the keys at the
                upper bound of the range are included in the keyset.
                Default value: true. This flag is only valid when
                the argument to the -t/time flag is a time range with
                a lower and upper bound. Note: when used with the "pasteKey"
                command, this flag refers only to the time range of the
                target curve that is replaced, when using options such
                as "replace," "fitReplace," or "scaleReplace." This
                flag has no effect on the curve pasted from the clipboard.
                Properties: create
        index (Unknown?): index of a key on an animCurve
                      In query mode, this flag needs a value.
                Properties: create, multiuse
        minimizeRotation (bool?): Specify whether to minimize the local Euler component from key to key during baking of rotation channels.
                Properties: create
        oversamplingRate (Unknown?): Amount of samples per sampleBy period. Default is 1.
                Properties: create
        preserveOutsideKeys (bool?): Whether to preserve keys that are outside the bake range
                when there are directly connected animation curves or a pairBlend node
                which has an animation curve as its direct input. The default
                (false) is to remove frames outside the bake range. If the channel
                that you are baking is not controlled by a single animation curve,
                then a new animation curve will be created with keys only in the
                bake range. In the case of pairBlend-driven channels, setting pok to
                true will retain both the pairBlend and its input animCurve. The
                blended values will be baked onto the animCurve and the weight of the
                pairBlend weight will be keyed to the animCurve during the baked
                range.
                Properties: create
        removeBakedAnimFromLayer (bool?): If true, all baked animation will be removed from the layer.
                Otherwise all layer associated with the baked animation will be muted.
                Properties: create
        removeBakedAttributeFromLayer (bool?): If true, all baked attribute will be removed from the layer.
                Otherwise all layer associated with the baked attribute will be muted.
                Properties: create
        resolveWithoutLayer (str?): This flag can be used to specify a list of layers to be merged together during the bake process. This
                is a multi-use flag. Its name refers to the fact that when solving for the value to key, it determines
                the proper value to key on the destination layer to achieve the same result as the merged layers.
                Properties: create, multiuse
        sampleBy (int?): Amount to sample by. Default is 1.0 in current timeUnit.
                Properties: create
        shape (bool?): Consider attributes of shapes below transforms as well,
                except "controlPoints".  Default: true.  (Not valid for "pasteKey" cmd.)
                In query mode, this flag needs a value.
                Properties: create
        simulation (bool?): Using this flag instructs the command to preform a simulation instead
                of just evaluating each attribute separately over the range of time.
                The simulation flag is required to bake animation that depends on
                the whole scene being evaluated at each time step such as dynamics. The
                default is false.
                Properties: create
        smart (Unknown?): Specify whether to enable smart bake and the optional smart bake tolerance.
                Properties: create
        sparseAnimCurveBake (bool?): When this is true and anim curves are being baked, do not insert
                any keys into areas of the curve where animation is defined. And, use
                as few keys as possible to bake the pre and post infinity behavior.
                When this is false, one key will be inserted at each time step. The
                default is false.
                Properties: create
        time (Unknown?): time uniquely representing a key (or key
                range) on a time-based animCurve. See the code
                examples below on how to format for a single
                frame or frame ranges.
                      In query mode, this flag needs a value.
                Properties: create, multiuse

    Returns:
        int: - The number of channels baked

    Example:
    """

def bakeSimulation(*args: str, animation: str = ..., attribute: str = ..., bakeOnOverrideLayer: bool = ..., controlPoints: bool = ..., destinationLayer: str = ..., disableImplicitControl: bool = ..., float: Unknown = ..., hierarchy: str = ..., includeUpperBound: bool = ..., index: Unknown = ..., minimizeRotation: bool = ..., preserveOutsideKeys: bool = ..., removeBakedAnimFromLayer: bool = ..., removeBakedAttributeFromLayer: bool = ..., resolveWithoutLayer: str = ..., sampleBy: int = ..., shape: bool = ..., simulation: bool = ..., smart: Unknown = ..., sparseAnimCurveBake: bool = ..., time: Unknown = ...) -> bool:
    """This command operates on a keyset.  A keyset is
    defined as a group of keys within a specified time range on one or
    more animation curves.The animation curves comprising a keyset depend on the value
    of the "-animation" flag:Note that the "-animation" flag can be used to override
    the curves uniquely identified by the multi-use
    "-attribute" flag, which takes an argument of the form
    attributeName, such as "translateX".Keys on animation curves are identified by either
    their time values or their indices.  Times and indices can
    be given individually or as part of a list or range (see Examples).The bakeSimulation command is obsolete.  Instead, "bakeResults
    -simulation true" should be used.  The bakeSimulation command has
    retained for backwards compatibility.This command allows the user to replace a chain of dependency
    nodes, or implicit relationship, such as those between joints
    and IK handles, which define the value of an attribute, with a
    single animation curve. Command allows the user to specify the
    range and frequency of sampling. Unlike the bakeResults
    command, this command will actually set the time of the
    current scene to all the times, in sequence, inside the given time
    interval before it sets the time back to when it is started.
    As a result, it may modify the scene.
    Args:
        animation (str?): Where this command should get the animation to act
                on.  Valid values are "objects," "keys," and
                "keysOrObjects" Default: "keysOrObjects."  (See
                Description for details.)
                Properties: create
        attribute (str?): List of attributes to select
                      In query mode, this flag needs a value.
                Properties: create, multiuse
        bakeOnOverrideLayer (bool?): If true, all layered and baked attributes will be added as a top override layer.
                Properties: create
        controlPoints (bool?): This flag explicitly specifies whether or not to include the
                control points of a shape (see "-s" flag) in the list of attributes.
                Default: false.  (Not valid for "pasteKey" cmd.)
                In query mode, this flag needs a value.
                Properties: create
        destinationLayer (str?): This flag can be used to specify an existing layer where the baked results
                should be stored.
                Properties: create
        disableImplicitControl (bool?): Whether to disable implicit control after the anim curves
                are obtained as the result of this command. An implicit control
                to an attribute is some function that affects the attribute
                without using an explicit dependency graph connection. The
                control of IK, via ik handles, is an example.
                Properties: create
        float (Unknown?): value uniquely representing a non-time-based
                key (or key range) on a time-based animCurve.  Valid
                floatRange include single values (-f 10) or a
                string with a lower and upper bound, separated by a
                colon (-f "10. 20")
                      In query mode, this flag needs a value.
                Properties: create, multiuse
        hierarchy (str?): Hierarchy expansion options.  Valid values are "above,"
                "below," "both," and "none." (Not valid for "pasteKey" cmd.)
                In query mode, this flag needs a value.
                Properties: create
        includeUpperBound (bool?): When the -t/time or -f/float flags represent a range
                of keys, this flag determines whether the keys at the
                upper bound of the range are included in the keyset.
                Default value: true.  This flag is only valid when
                the argument to the -t/time flag is a time range with
                a lower and upper bound.  (When used with the "pasteKey"
                command, this flag refers only to the time range of the
                target curve that is replaced, when using options such
                as "replace," "fitReplace," or "scaleReplace."  This
                flag has no effect on the curve pasted from the clipboard.)
                Properties: create
        index (Unknown?): index of a key on an animCurve
                      In query mode, this flag needs a value.
                Properties: create, multiuse
        minimizeRotation (bool?): Specify whether to minimize the local euler component from key to key during baking of rotation channels.
                Properties: create
        preserveOutsideKeys (bool?): Whether to preserve keys that are outside the bake range
                when there are directly connected animation curves.  The default
                (false) is to remove frames outside the bake range.  If the channel
                that you are baking is not controlled by a single animation curve,
                then a new animation curve will be created with keys only in the
                bake range.
                Properties: create
        removeBakedAnimFromLayer (bool?): If true, all baked animation will be removed from the layer.
                Properties: create
        removeBakedAttributeFromLayer (bool?): If true, all baked attributes will be removed from the layer.
                Properties: create
        resolveWithoutLayer (str?): This flag can be used to specify a list of layers to be merged together during the bake process. This
                is a multi-use flag. Its name refers to the fact that when solving for the value to key, it determines
                the proper value to key on the destination layer to achieve the same result as the merged layers.
                Properties: create, multiuse
        sampleBy (int?): Amount to sample by. Default is 1.0 in current timeUnit
                Properties: create
        shape (bool?): Consider attributes of shapes below transforms as well,
                except "controlPoints".  Default: true.  (Not valid for "pasteKey" cmd.)
                In query mode, this flag needs a value.
                Properties: create
        simulation (bool?): Using this flag instructs the command to preform a simulation instead
                of just evaluating each attribute separately over the range of time.
                The simulation flag is required to bake animation that that depends on
                the whole scene being evaluated at each time step such as dynamics. The
                default is true.
                Properties: create
        smart (Unknown?): Specify whether to enable smart bake and the optional smart bake tolerance.
                Properties: create
        sparseAnimCurveBake (bool?): When baking anim curves, do not insert any keys into areas
                of the curve where animation is defined.  And, use as few keys
                as possible to bake the pre and post infinity behaviors.  When
                this is false, one key will be inserted at each time step.  The
                default is false.
                Properties: create
        time (Unknown?): time uniquely representing a key (or key
                range) on a time-based animCurve. See the code
                examples below on how to format for a single
                frame or frame ranges.
                      In query mode, this flag needs a value.
                Properties: create, multiuse

    Returns:
        bool: In query mode, return type is based on queried flag.

    Example:
    """

def baseTemplate(arg0: str, /, exists: bool = ..., fileName: str = ..., force: bool = ..., load: bool = ..., matchFile: str = ..., silent: bool = ..., unload: bool = ..., viewList: str = ...) -> bool:
    """This is the class for the commands that edit and/or query templates.base, template
    Args:
        exists (bool?): Returns true or false depending upon whether the specified template exists.
                When used with the matchFile argument, the query will return true if the
                template exists and the filename it was loaded from matches the filename
                given.
                Properties: query
        fileName (str?): Specifies the filename associated with the template.  This argument can be
                used in conjunction with load, save or query modes. If no filename is
                associated with a template, a default file name based on the template
                name will be used.  It is recommended but not required that the
                filename and template name correspond.
                Properties: create, query
        force (bool?): This flag is used with some actions to allow them to proceed with an
                overwrite or destructive operation.
                When used with load, it will allow an existing template to be reloaded
                from a file.  When used in create mode, it will allow an existing template
                to be recreated (for example when using fromContainer argument to
                regenerate a template).
                Properties: create
        load (bool?): Load an existing template from a file.
                If a filename is specified for the template, the entire file
                (and all templates in it) will be loaded.
                If no file is specified, a default filename will be assumed,
                based on the template name.
        matchFile (str?): Used in query mode in conjunction with other flags this flag specifies
                an optional file name that is to be matched as part of the query operation.
                			In query mode, this flag needs a value.
                Properties: query
        silent (bool?): Silent mode will suppress any error or warning messages that would normally be
                reported from the command execution.  The return values are unaffected.
                Properties: create, query, edit
        unload (bool?): Unload the specified template.  This action will not delete the
                associated template file if one exists, it merely removes the template
                definition from the current session.
                Properties: create
        viewList (str?): Used in query mode, returns a list of all views defined on the template.
                Properties: create, query

    Returns:
        bool: In query mode, return type is based on queried flag.

    Example:
    """

def baseView(arg0: str, /, itemInfo: str = ..., itemList: bool = ..., viewDescription: bool = ..., viewLabel: bool = ..., viewList: bool = ..., viewName: str = ...) -> bool:
    """A view defines the layout information for the attributes of a
    particular node type or container.  Views can be selected from a set of
    built-in views or may be defined on an associated container template.
    This command queries the view-related information for a container node or
    for a given template.  The information returned from this command will be
    based on the view-related settings in force on the container node at the time
    of the query (i.e. the container's view mode, template name, view name
    attributes), when applicable.base, view
    Args:
        itemInfo (str?): Used in query mode in conjunction with the itemList flag.
                The command will return a list of information for each item in the view, the
                information fields returned for each item are determined by this argument value.
                The information fields will be listed in the string array returned.
                The order in which the keyword is specified will determine the order in which
                the data will be returned by the command.
                One or more of the following keywords, separated by colons ':' are used to
                specify the argument value.

                itemIndex  : sequential item number (0. based)
                itemName   : item name (string)
                itemLabel  : item display label (string)
                itemDescription : item description field (string)
                itemLevel  : item hierarchy level (0. n)
                itemIsGroup : (boolean 0 or 1) indicates whether or not this item is a group
                itemIsAttribute : (boolean 0 or 1) indicates whether or not this item is an attribute
                itemNumChildren: number of immediate children (groups or attributes) of this item
                itemAttrType : item attribute type (string)
                itemCallback : item callback field (string)

                In query mode, this flag needs a value.
                Properties: query
        itemList (bool?): Used in query mode, the command will return a list of information for each item in
                the view.  The viewName flag is used to select the view to query.
                The information returned about each item is determined by the itemInfo argument value.
                For efficiency, it is best to query all necessary item information at one time
                (to avoid recomputing the view information on each call).
                Properties: query
        viewDescription (bool?): Used in query mode, returns the description field associated with the
                selected view.
                If no description was defined for this view, the value will be empty.
                Properties: query
        viewLabel (bool?): Used in query mode, returns the display label associated with the view.
                An appropriate label suitable for the user interface will be
                returned based on the selected view.  Use of the view label
                is usually more suitable than the view name for display purposes.
                Properties: query
        viewList (bool?): Used in query mode, command will return a list of all views defined for the
                given target (container or template).
                Properties: query
        viewName (str?): Used in query mode, specifies the name of the queried view when used in
                conjunction with a template target. When used in conjunction with a container
                target, it requires no string argument, and returns the name of the currently
                active view associated with the container; this value may be empty if the
                current view is not a valid template view or is generated by one of the
                built-in views modes. For this reason, the view label is generally more
                suitable for display purposes.
                			In query mode, this flag can accept a value.
                Properties: query

    Returns:
        bool: In query mode, return type is based on queried flag.

    Example:
    """

def batchRender(arg0: str, arg1: str, arg2: str, arg3: str, arg4: str, /, filename: str = ..., melCommand: str = ..., numProcs: int = ..., preRenderCommand: str = ..., remoteRenderMachine: str = ..., renderCommandOptions: str = ..., showImage: bool = ..., status: str = ..., useRemoteRender: bool = ..., useStandalone: bool = ..., verbosity: int = ...) -> bool:
    """The batchRender command is used to spawn off a separate
    rendering session of the current maya file. If no
    mayaFile is specified, it'll ask you whether you want the
    current job killed.The batchRender will spawn a separate maya process in which
    commands will be communicated to it through a commandPort. If Maya
    is unable to find an available port an error will be
    produced. Maya will attempt to use ports 7835 through 7844.
    Args:
        filename (str?): Filename to be rendered; if empty, a temporary filename will be created.
                Properties: create
        melCommand (str?): Mel command to execute to run a renderer other than the software renderer.
                Properties: create
        numProcs (int?): Number of processors to use (0 means use all available processors).
                Properties: create
        preRenderCommand (str?): Command to be run prior to invoking a batch render.
                Properties: create
        remoteRenderMachine (str?): Name of remote render machine. Not available on Windows.
                Properties: create
        renderCommandOptions (str?): Arguments to the render command for batch rendering.
                Properties: create
        showImage (bool?): Show progress of the current rendering job.
                Properties: create
        status (str?): Status string for displaying the batch render status.
                Properties: create
        useRemoteRender (bool?): If remote rendering is desired. Not available on Windows.
                Properties: create
        useStandalone (bool?): Batch rendering is to be done by exporting the scene and rendering with a standalone renderer.
                Properties: create
        verbosity (int?): Defines the verbosity level to report the batch rendering
                status:
                1. display only one start message, then one message when all
                frames are rendered.
                2. display only start and end frame messages.
                3. display all messages (default).
                Properties: create

    Returns:
        bool:

    Example:
    """

def bevel(arg0: str, arg1: str, /, bevelShapeType: int = ..., caching: bool = ..., cornerType: int = ..., depth: Unknown = ..., extrudeDepth: Unknown = ..., nodeState: int = ..., tolerance: Unknown = ..., width: Unknown = ..., constructionHistory: bool = ..., joinSurfaces: bool = ..., name: str = ..., numberOfSides: int = ..., object: bool = ..., polygon: int = ..., range: bool = ...) -> List[str]:
    """The bevel command creates a new bevel surface for the specified curve.
    The curve can be any nurbs curves.
    Args:
        bevelShapeType (int?): Shape type: 1. straight cut, 2. curve out, 3. curve in
                Default: 1
                Properties: create, query, edit
        caching (bool?): Toggle caching for all attributes so that no recomputation is needed
                Properties: create, query, edit
        cornerType (int?): Corner type: 1. linear, 2. circular
                Default: 2
                Properties: create, query, edit
        depth (Unknown?): The depth for bevel
                Default: 0.5
                Properties: create, query, edit
        extrudeDepth (Unknown?): The extrude depth for bevel
                Default: 1.0
                Properties: create, query, edit
        nodeState (int?): Maya dependency nodes have 6 possible states.
                The Normal (0), HasNoEffect (1), and Blocking (2) states can be
                used to alter how the graph is evaluated.



                The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)
                are for internal use only. They temporarily shut off parts of the graph during interaction
                (e.g., manipulation). The understanding is that once the operation is done,
                the state will be reset appropriately, e.g. Waiting-Blocking will reset
                back to Blocking.



                The Normal and Blocking cases apply to all nodes, while
                HasNoEffect is node specific; many nodes do not support this option.
                Plug-ins store state in the MPxNode::state attribute. Anyone can set
                it or check this attribute.  Additional details about each of these 3 states follow.




                State
                Description


                Normal
                The normal node state. This is the default.


                HasNoEffect


                The HasNoEffect option (a.k.a. pass-through), is used in cases where
                there is an operation on an input producing an output of the same data type.
                Nearly all deformers support this state, as do a few other nodes.
                As stated earlier, it is not supported by all nodes.


                Itâ€™s typical to implement support for the HasNoEffect state in
                the nodeâ€™s compute method and to perform appropriate operations.
                Plug-ins can also support HasNoEffect.


                The usual implementation of this state is to copy the input directly to the
                matching output without applying the algorithm in the node. For deformers,
                applying this state leaves the input geometry undeformed on the output.




                Blocking


                This is implemented in the depend node base class and applies to all nodes.
                Blocking is applied during the evaluation phase to connections.
                An evaluation request to a blocked connection will return as failures,
                causing the destination plug to retain its current value. Dirty propagation
                is indirectly affected by this state since blocked connections are never cleaned.


                When a node is set to Blocking the behavior is supposed to be the same as
                if all outgoing connections were broken. As long as nobody requests evaluation
                of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked
                node will still respond to getAttr requests but a getAttr on a
                downstream node will not reevaluate the blocked node.


                Setting the root transform of a hierarchy to Blocking wonâ€™t automatically
                influence child transforms in the hierarchy. To do this, youâ€™d need to
                explicitly set all child nodes to the Blocking state.


                For example, to set all child transforms to Blocking, you could use the
                following script.



                import maya.cmds as cmds
                def blockTree(root):
                nodesToBlock = []
                for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys():
                nodesToBlock += cmds.listConnections(node, source=True, destination=True )
                for node in {source:1 for source in nodesToBlock}.keys():
                cmds.setAttr( '%s.nodeState' % node, 2 )



                Applying this script would continue to draw objects but things would not be animated.




                Default: kdnNormal
                Properties: create, query, edit
        tolerance (Unknown?): The tolerance for bevel offsets
                Default: 0.01
                Properties: create, query, edit
        width (Unknown?): The width for bevel
                Default: 0.5
                Properties: create, query, edit
        constructionHistory (bool?): Turn the construction history on or off.
                Properties: create
        joinSurfaces (bool?): Attach bevelled surfaces into one surface for each
                input curve.
                Default:true
                Properties: create, query, edit
        name (str?): Sets the name of the newly-created node. If it contains
                namespace path, the new node will be created under the
                specified namespace; if the namespace does not exist, it
                will be created.
                Properties: create
        numberOfSides (int?): How to apply the bevel.

                1. no bevels
                2. bevel at start only
                3. bevel at end only
                4. bevel at start and end

                Default: 4
                Properties: create, query, edit
        object (bool?): Create the result, or just the dependency node.
                Properties: create
        polygon (int?): The value of this argument controls the type of the object
                created by this operation

                 0. nurbs surface
                 1. polygon (use nurbsToPolygonsPref to set the parameters for the conversion)
                 2. subdivision surface (use nurbsToSubdivPref to set the parameters for the conversion)
                 3. Bezier surface
                 4. subdivision surface solid (use nurbsToSubdivPref to set the
                parameters for the conversion)
                Properties: create
        range (bool?): Force a curve range on complete input curve.
                Properties: create

    Returns:
        List[str]: Object name and node name

    Example:
    """

def bevelPlus(*args: str, bevelInside: bool = ..., capSides: int = ..., constructionHistory: bool = ..., innerStyle: int = ..., joinSurfaces: bool = ..., name: str = ..., normalsOutwards: bool = ..., numberOfSides: int = ..., outerStyle: int = ..., polygon: int = ..., range: bool = ...) -> List[str]:
    """The bevelPlus command creates a new bevel surface for the specified
    curves using a given style curve. The first curve should be the
    "outside" curve, and the (optional) rest of them should be inside of
    the first one. For predictable results, the curves should be planar
    and all in the same plane.
    Args:
        bevelInside (bool?): If true, ensure surface always remains within the original profile curve
                Default: false
                Properties: create, query, edit
        capSides (int?): How to cap the bevel.

                1. no caps
                2. cap at start only
                3. cap at end only
                4. cap at start and end

                Default:4
                Properties: create, query
        constructionHistory (bool?): Turn the construction history on or off.
                Properties: create
        innerStyle (int?): Similar to outerStyle, this style is applied to all
                but the first (outer) curve specified.
                Properties: create, query, edit
        joinSurfaces (bool?): Attach bevelled surfaces into one surface for each
                input curve.
                Default:true
                Properties: create, query, edit
        name (str?): Sets the name of the newly-created node. If it contains
                namespace path, the new node will be created under the
                specified namespace; if the namespace does not exist, it
                will be created.
                Properties: create
        normalsOutwards (bool?): If enabled, the normals point outwards on the
                resulting NURBS or poly surface.
                Properties: create, query, edit
        numberOfSides (int?): How to apply the bevel.

                1. no bevels
                2. bevel at start only
                3. bevel at end only
                4. bevel at start and end

                Default: 4
                Properties: create, query, edit
        outerStyle (int?): Choose a style to use for the bevel of the first (outer)
                curve.  There are 15 predefined styles (values 0 to 14 can be used
                to select them). For those experienced with MEL, you can, after
                the fact, specify a custom curve and use it for the style curve.
                See the documentation for styleCurve node to see what requirements
                a style curve must satisfy.
                Properties: create, query, edit
        polygon (int?): The value of this argument controls the type of the object
                created by this operation

                 0. nurbs surface
                 1. polygon (use nurbsToPolygonsPref to set the parameters for the conversion)
                 2. subdivision surface (use nurbsToSubdivPref to set the parameters for the conversion)
                 3. Bezier surface
                 4. subdivision surface solid (use nurbsToSubdivPref to set the
                parameters for the conversion)
                Properties: create
        range (bool?): Force a curve range on complete input curve.
                Properties: create

    Returns:
        List[str]: Object name(s) and node name

    Example:
    """

def bezierAnchorPreset(preset: int = ...) -> int:
    """This command provides a queryable interface for Bezier curve shapes.
    Args:
        preset (int?): Selects a preset to apply to selected Bezier anchors. Valid arguments are:

                0. Bezier
                1. Bezier Corner
                2. Corner
                Properties: create

    Returns:
        int: (number of modified anchors)

    Example:
    """

def bezierAnchorState(even: bool = ..., smooth: bool = ...) -> int:
    """The bezierAnchorState command provides an easy interface to modify anchor states:- Smooth/Broken anchor tangents
    - Even/Uneven weighted anchor tangents
    Args:
        even (bool?): Sets selected anchors (or attached tangent handles) to even weighting when true, uneven otherwise.
                Properties: create
        smooth (bool?): Sets selected anchors (or attached tangent handles) to smooth when true, broken otherwise.
                Properties: create

    Returns:
        int: (number of modified anchors)

    Example:
    """

def bezierCurveToNurbs() -> List[str]:
    """The bezierCurveToNurbs command attempts to convert an existing NURBS curve
    to a Bezier curve.
    Returns:
        List[str]: (object name and node name)

    Example:
    """

def bezierInfo(anchorFromCV: int = ..., cvFromAnchor: int = ..., isAnchorSelected: bool = ..., isTangentSelected: bool = ..., onlyAnchorsSelected: bool = ..., onlyTangentsSelected: bool = ...) -> int:
    """This command provides a queryable interface for Bezier curve shapes.
    Args:
        anchorFromCV (int?): Returns the Bezier anchor index from a given CV index
                Properties: create
        cvFromAnchor (int?): Returns the CV index for a given Bezier anchor index
                Properties: create
        isAnchorSelected (bool?): Returns 1 if an anchor CV is currently selected. 0, otherwise.
                Properties: create
        isTangentSelected (bool?): Returns 1 if a tangent CV is currently selected. 0, otherwise.
                Properties: create
        onlyAnchorsSelected (bool?): Returns 1 if the only CV components selected are anchor CVs. 0, otherwise.
                Properties: create
        onlyTangentsSelected (bool?): Returns 1 if the only CV components selected are tangent CVs. 0, otherwise.
                Properties: create

    Returns:
        int: Queried value

    Example:
    """

def binMembership(*args: str, addToBin: str = ..., exists: str = ..., inheritBinsFromNodes: str = ..., isValidBinName: str = ..., listBins: bool = ..., makeExclusive: str = ..., notifyChanged: bool = ..., removeFromBin: str = ...) -> bool:
    """Command to assign nodes to bins.binMembership
    Args:
        addToBin (str?): Add the nodes in a node list to a bin.
                Properties: create
        exists (str?): Query if a node exists in a bin.  The exists flag can take only one node.
                Properties: create
        inheritBinsFromNodes (str?): Let the node in the flag's argument inherit bins from nodes
                in the specified node list.  The node list is specified as the
                object of the command.
                Properties: create
        isValidBinName (str?): Query if the specified bin name is valid.  If so, return true.
                Otherwise, return false.
                Properties: create
        listBins (bool?): Query and return a list of bins a list of nodes belong to.
                If a bin contains any of the nodes in the selection list,
                then it should be included
                in the returned bin list.
                Properties: create, query
        makeExclusive (str?): Make the specified nodes belong exclusively in the specified bin.
                Properties: create
        notifyChanged (bool?): This flag is used to notify that binMembership has been changed.
                Properties: create
        removeFromBin (str?): Remove the nodes in a node list from a bin.
                Properties: create

    Returns:
        bool: Command result

    Example:
    """

def bindSkin(*args: str, byClosestPoint: bool = ..., byPartition: bool = ..., colorJoints: bool = ..., delete: bool = ..., doNotDescend: bool = ..., enable: bool = ..., name: str = ..., partition: str = ..., toAll: bool = ..., toSelectedBones: bool = ..., toSkeleton: bool = ..., unbind: bool = ..., unbindKeepHistory: bool = ..., unlock: bool = ...) -> str:
    """This command binds the currently selected objects to the
    currently selected skeletons.  Shapes which can be bound are:
    meshes, nurbs curves, nurbs surfaces, lattices, subdivision
    surfaces, and API shapes. Multiple shapes and multiple skeletons can be
    bound at once by selecting them or specifying them on the command
    line. Selection order is not important.The skin is bound using the so-called "rigid" bind, in which
    the components are rigidly attached to the closest bone in the
    skeleton. Flexors can later be added to the skeleton to
    smooth out the skinning around joints.The skin(s) can be bound either to the entire skeleton hierarchy
    of the selected joint(s), or to only the selected joints. The
    entire hierarchy is the default. The -tsb/-toSelectedBones flag
    allows binding to only the selected bones.This command can also be used to detach the skin from the skeleton.
    Detaching the skin is useful in a variety of situations, such as:
    inserting additional bones, deleting bones, changing the bind
    position of the skeleton or skin, or simply getting rid of the
    skinning nodes altogether. The options to use when detaching the
    skin depend on how much of the skinning info you want to get rid
    of. Namely: (1) -delete or -unbind: remove all skinning nodes, (2) -unbindKeepHistory: remove the skinning sets, but keep the weights, (3) -disable: disable the skinning but keep the skinning sets and the weights.
    Args:
        byClosestPoint (bool?): bind each point in the object to the segment closest to the point.
                The byClosestPoint and byPartition flags are mutually
                exclusive.  The byClosestPoint flag is the default.
                Properties: create
        byPartition (bool?): bind each group in the partition to the segment
                closest to the group's centroid. A partition must be specified
                with the -p/-partition flag
                Properties: create
        colorJoints (bool?): In bind mode, this flag assigns colors to the joints based
                on the colors assigned to the joint's skin set.
                In delete and unlock mode, this flag removes the colors from
                joints that are no longer bound as skin.
                In disable and unbindKeepHistory mode, this flag does nothing.
                Properties: create
        delete (bool?): Detach the skin on the selected skeletons and remove all bind-
                related construction history.
                Properties: create
        doNotDescend (bool?): Do not descend to shapes that are parented below the selected
                object(s).
                Bind only the selected objects.
                Properties: create
        enable (bool?): Enable or disable a bind that has been disabled on the selected
                skeletons.
                To enable the bind on selected bones only, select the bones and
                use the -tsb flag with the -en flag. This flag is used when you
                want to temporarily disable the bind without losing the set
                information or the weight information of the skinning, for example
                if you want to modify the bindPose.
                Properties: create
        name (str?): This flag is obsolete.
                Properties: create
        partition (str?): Specify a partition to bind by. This is only valid when
                used with the -bp/-byPartition flag.
                Properties: create
        toAll (bool?): objects will be bound to the entire selected skeletons. Even bones with zero influence
                will be bound, whereas the toSkeleton will only bind non-zero influences.
                Properties: create
        toSelectedBones (bool?): objects will be bound to the selected bones only.
                Properties: create
        toSkeleton (bool?): objects will be bound to the selected skeletons. The toSkeleton, toAll
                and toSelectedBones flags are mutually exclusive. The toSkeleton flag is the default.
                Properties: create
        unbind (bool?): unbind the selected objects. They will no longer move with
                the skeleton. Any bindSkin history that is no longer used
                will be deleted.
                Properties: create
        unbindKeepHistory (bool?): unbind the selected objects. They will no longer move with
                the skeleton. However, existing weights on the skin
                will be kept for use the next time the skin is bound. This option
                is appropriate if you want to modify the skeleton without losing
                the weighting information on the skin.
                Properties: create
        unlock (bool?): unlock the selected objects. Since bindSkin will no longer give
                normal results if bound objects are moved away from the skeleton,
                bindSkin locks translate, rotate and scale. This command unlocks
                the selected objects translate, rotate and scale.
                Properties: create

    Returns:
        str: Command result

    Example:
    """

def blend(*args: str, edit: bool = ..., query: bool = ..., autoDirection: bool = ..., caching: bool = ..., crvsInFirstRail: int = ..., constructionHistory: bool = ..., flipLeft: bool = ..., flipRight: bool = ..., frozen: bool = ..., leftParameter: float = ..., multipleKnots: bool = ..., name: str = ..., nodeState: int = ..., object: bool = ..., polygon: int = ..., positionTolerance: float = ..., rightParameter: float = ..., tangentTolerance: float = ...) -> None: ...
def blend2(*args: str, autoAnchor: bool = ..., autoNormal: bool = ..., caching: bool = ..., flipLeftNormal: bool = ..., flipRightNormal: bool = ..., leftAnchor: float = ..., leftEnd: float = ..., leftStart: float = ..., multipleKnots: bool = ..., nodeState: int = ..., positionTolerance: float = ..., reverseLeft: bool = ..., reverseRight: bool = ..., rightAnchor: float = ..., rightEnd: float = ..., rightStart: float = ..., tangentTolerance: float = ..., constructionHistory: bool = ..., crvsInFirstRail: int = ..., name: str = ..., object: bool = ..., polygon: int = ...) -> List[str]:
    """This command creates a surface by blending between given curves.
    This is an enhancement (more user control) compared to blend
    which is now obsolete.
    Args:
        autoAnchor (bool?): If true and both paths are closed, automatically determine the value on the right rail so that they match
                Default: true
                Properties: create, query, edit
        autoNormal (bool?): If true, the direction of each starting tangent is computed based on given geometry.
                Default: true
                Properties: create, query, edit
        caching (bool?): Toggle caching for all attributes so that no recomputation is needed
                Properties: create, query, edit
        flipLeftNormal (bool?): If true, flip the starting tangent off the left boundary.
                Default: false
                Properties: create, query, edit
        flipRightNormal (bool?): If true, flip the starting tangent off the right boundary.
                Default: false
                Properties: create, query, edit
        leftAnchor (float?): The reference parameter on the left boundary where the blend surface starts in the case of the closed rail.
                Default: 0.0
                Properties: create, query, edit
        leftEnd (float?): The reference parameter on the left boundary where the blend surface ends.
                Default: 1.0
                Properties: create, query, edit
        leftStart (float?): The reference parameter on the left boundary where the blend surface starts.
                Default: 0.0
                Properties: create, query, edit
        multipleKnots (bool?): If true, use the new blend which produces fully multiple interior knots
                Default: true
                Properties: create, query, edit
        nodeState (int?): Maya dependency nodes have 6 possible states.
                The Normal (0), HasNoEffect (1), and Blocking (2) states can be
                used to alter how the graph is evaluated.



                The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)
                are for internal use only. They temporarily shut off parts of the graph during interaction
                (e.g., manipulation). The understanding is that once the operation is done,
                the state will be reset appropriately, e.g. Waiting-Blocking will reset
                back to Blocking.



                The Normal and Blocking cases apply to all nodes, while
                HasNoEffect is node specific; many nodes do not support this option.
                Plug-ins store state in the MPxNode::state attribute. Anyone can set
                it or check this attribute.  Additional details about each of these 3 states follow.




                State
                Description


                Normal
                The normal node state. This is the default.


                HasNoEffect


                The HasNoEffect option (a.k.a. pass-through), is used in cases where
                there is an operation on an input producing an output of the same data type.
                Nearly all deformers support this state, as do a few other nodes.
                As stated earlier, it is not supported by all nodes.


                Itâ€™s typical to implement support for the HasNoEffect state in
                the nodeâ€™s compute method and to perform appropriate operations.
                Plug-ins can also support HasNoEffect.


                The usual implementation of this state is to copy the input directly to the
                matching output without applying the algorithm in the node. For deformers,
                applying this state leaves the input geometry undeformed on the output.




                Blocking


                This is implemented in the depend node base class and applies to all nodes.
                Blocking is applied during the evaluation phase to connections.
                An evaluation request to a blocked connection will return as failures,
                causing the destination plug to retain its current value. Dirty propagation
                is indirectly affected by this state since blocked connections are never cleaned.


                When a node is set to Blocking the behavior is supposed to be the same as
                if all outgoing connections were broken. As long as nobody requests evaluation
                of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked
                node will still respond to getAttr requests but a getAttr on a
                downstream node will not reevaluate the blocked node.


                Setting the root transform of a hierarchy to Blocking wonâ€™t automatically
                influence child transforms in the hierarchy. To do this, youâ€™d need to
                explicitly set all child nodes to the Blocking state.


                For example, to set all child transforms to Blocking, you could use the
                following script.



                import maya.cmds as cmds
                def blockTree(root):
                nodesToBlock = []
                for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys():
                nodesToBlock += cmds.listConnections(node, source=True, destination=True )
                for node in {source:1 for source in nodesToBlock}.keys():
                cmds.setAttr( '%s.nodeState' % node, 2 )



                Applying this script would continue to draw objects but things would not be animated.




                Default: kdnNormal
                Properties: create, query, edit
        positionTolerance (float?): The positional C(0) tolerance of the blend surface to the adjacent surfaces.
                Default: 0.1
                Properties: create, query, edit
        reverseLeft (bool?): If true, reverse the direction off the left boundary.  autoDirection must be false for this value to be considered.
                Default: false
                Properties: create, query, edit
        reverseRight (bool?): If true, reverse the direction of the right boundary.  autoDirection must be false for this value to be considered.
                Default: false
                Properties: create, query, edit
        rightAnchor (float?): The reference parameter on the right boundary where the blend surface starts in the case of the closed rail.
                Default: 0.0
                Properties: create, query, edit
        rightEnd (float?): The reference parameter on the right boundary where the blend surface ends.
                Default: 1.0
                Properties: create, query, edit
        rightStart (float?): The reference parameter on the right boundary where the blend surface starts.
                Default: 0.0
                Properties: create, query, edit
        tangentTolerance (float?): The tangent G(1) continuity tolerance of the blend surface to the adjacent surfaces.
                Default: 0.1
                Properties: create, query, edit
        constructionHistory (bool?): Turn the construction history on or off.
                Properties: create
        crvsInFirstRail (int?): Number of curves in the first rail of the blend.
                Properties: create, query, edit
        name (str?): Sets the name of the newly-created node. If it contains
                namespace path, the new node will be created under the
                specified namespace; if the namespace does not exist, it
                will be created.
                Properties: create
        object (bool?): Create the result, or just the dependency node.
                Properties: create
        polygon (int?): The value of this argument controls the type of the object
                created by this operation

                 0. nurbs surface
                 1. polygon (use nurbsToPolygonsPref to set the parameters for the conversion)
                 2. subdivision surface (use nurbsToSubdivPref to set the parameters for the conversion)
                 3. Bezier surface
                 4. subdivision surface solid (use nurbsToSubdivPref to set the
                parameters for the conversion)
                Properties: create

    Returns:
        List[str]: Object name and node name

    Example:
    """

def blendCtx(*args: Any, **kwargs: Any) -> None: ...
def blendShape(*args: str, after: bool = ..., afterReference: bool = ..., automatic: bool = ..., before: bool = ..., components: bool = ..., copyDelta: Tuple[Unknown, Unknown, Unknown] = ..., copyInBetweenDelta: Tuple[Unknown, Unknown, Unknown, Unknown] = ..., copyWeights: Tuple[Unknown, Unknown, Unknown] = ..., deformerTools: bool = ..., envelope: float = ..., exclusive: str = ..., export: str = ..., exportTarget: Tuple[int, int] = ..., flipTarget: Tuple[Unknown, Unknown] = ..., frontOfChain: bool = ..., geometry: str = ..., geometryIndices: bool = ..., ignoreSelected: bool = ..., ip: str = ..., inBetween: bool = ..., inBetweenIndex: Unknown = ..., inBetweenType: str = ..., includeHiddenSelections: bool = ..., mergeSource: int = ..., mergeTarget: Unknown = ..., mirrorDirection: Unknown = ..., mirrorTarget: Tuple[Unknown, Unknown] = ..., name: str = ..., normalizationGroups: bool = ..., origin: str = ..., parallel: bool = ..., prune: bool = ..., remove: bool = ..., resetTargetDelta: Tuple[Unknown, Unknown] = ..., selectedComponents: bool = ..., split: bool = ..., suppressDialog: bool = ..., symmetryAxis: str = ..., symmetryEdge: str = ..., symmetrySpace: Unknown = ..., tangentSpace: bool = ..., target: Tuple[str, Unknown, str, float] = ..., topologyCheck: bool = ..., transform: str = ..., useComponentTags: bool = ..., weight: Tuple[Unknown, float] = ..., weightCount: Unknown = ...) -> List[str]:
    """This command creates a blendShape deformer, which blends in specified
    amounts of each target shape to the initial base shape.
    Each base shape is deformed by its own set of target shapes.
    Every target shape has an index that associates it with one of
    the shape weight values.In the create mode the first item on the selection list is treated
    as the base and the remaining inputs as targets. If the first item
    on the list has multiple shapes grouped beneath it, the targets must
    have an identical shape hierarchy. Additional base shapes
    can be added in edit mode using the deformers -g flag.
    Args:
        after (bool?): If the default behavior for insertion/appending into/onto
                the existing chain is not the desired behavior then this flag
                can be used to force the command to place the deformer
                node after the selected node in the chain even if
                a new geometry shape has to be created in order to do so.
                Works in create mode (and edit mode if the deformer has
                no geometry added yet).
                Properties: create, edit
        afterReference (bool?): The -afterReference flag is used to specify deformer ordering in a hybrid way that
                choses between -before and -after automatically. If the geometry being
                deformed is referenced then the -after mode is used when adding the new deformer,
                otherwise the -before mode is used. The net effect when using -afterReference to build
                deformer chains is that internal shape nodes in the deformer chain will only
                appear at reference file boundaries, leading to lightweight deformer networks that
                may be more amicable to reference swapping.
                Properties: create, edit
        automatic (bool?): The -automatic flag is used to specify deformer ordering in a way that
                choses between -frontOfChain and -before automatically. If the geometry being
                deformed is only affected by invertible deformers, the -frontOfChain mode is used, otherwise
                the -before mode is used.
                Properties: create, edit
        before (bool?): If the default behavior for insertion/appending into/onto
                the existing chain is not the desired behavior then this flag
                can be used to force the command to place the deformer
                node before the selected node in the chain even if
                a new geometry shape has to be created in order to do so.
                Works in create mode (and edit mode if the deformer has
                no geometry added yet).
                Properties: create, edit
        components (bool?): Returns the components used by the deformer
                Properties: query
        copyDelta (Tuple[Unknown, Unknown, Unknown]?): Set the base, source, and destination delta index values.
                Properties: edit
        copyInBetweenDelta (Tuple[Unknown, Unknown, Unknown, Unknown]?): Set the base, target, source, and destination delta index values.
                Properties: edit
        copyWeights (Tuple[Unknown, Unknown, Unknown]?): Copy base, source, and destination weight index values.
                Properties: edit
        deformerTools (bool?): Returns the name of the deformer tool objects (if any)
                as string string ...
                Properties: query
        envelope (float?): Set the envelope value for the deformer, controlling
                how much of the total deformation gets applied. Default is 1.0.
                Properties: create, query, edit
        exclusive (str?): Puts the deformation set in a deform partition.
                Properties: create, query
        export (str?): Export the shapes to the named file path.
                Properties: edit
        exportTarget (Tuple[int, int]?): Specify the base and target index pairs for the export.
                Properties: edit, multiuse
        flipTarget (Tuple[Unknown, Unknown]?): Flip the list of base and target pairs.
                Properties: edit, multiuse
        frontOfChain (bool?): This command is used to specify that the new deformer
                node should be placed ahead (upstream) of existing deformer
                and skin nodes in the shape's history (but not ahead of
                existing tweak nodes). The input to the
                deformer will be the upstream shape rather than the visible
                downstream shape, so the behavior of this flag is the most
                intuitive if the downstream deformers are in their reset
                (hasNoEffect) position when the new deformer is added.
                Works in create mode (and edit mode if the deformer has
                no geometry added yet).
                Properties: create, edit
        geometry (str?): The specified object will be added to the list of
                objects being deformed by this deformer object, unless
                the -rm flag is also specified. When queried, this flag
                returns string string string ...
                Properties: query, edit, multiuse
        geometryIndices (bool?): Complements the -geometry flag in query mode. Returns
                the multi index of each geometry.
                Properties: query
        ignoreSelected (bool?): Tells the command to not deform objects on the
                current selection list
                Properties: create
        ip (str?): Import the shapes from the named file path.
                Properties: edit
        inBetween (bool?): Indicate that the specified target should serve as
                an inbetween. An inbetween target is one that serves as an
                intermediate target between the base shape and another target.
                Properties: create, edit
        inBetweenIndex (Unknown?): Only used with the -rtd/-resetTargetDelta flag to remove delta values
                for points in the inbetween target geometry defined by this index.
                Properties: edit
        inBetweenType (str?): Specify if the in-between target to be created is relative to the hero
                target or if it is absolute.
                If it is relative to hero targets, the in-between target will get any changes made to the hero target.
                Valid values are "relative" and "absolute".
                This flag should always be used with the -ib/-inBetween and -t/-target flags.
                Properties: create, edit
        includeHiddenSelections (bool?): Apply the deformer to any visible and hidden objects in the selection list.
                Default is false.
                Properties: create
        mergeSource (int?): List of source indexes for a merge.
                Properties: edit, multiuse
        mergeTarget (Unknown?): Target index of a merge
                Properties: edit
        mirrorDirection (Unknown?): Mirror direction; 0 = negative, 1 = positive
                Properties: edit
        mirrorTarget (Tuple[Unknown, Unknown]?): Mirror the list of base and target pairs.
                Properties: edit, multiuse
        name (str?): Used to specify the name of the node being created.
                Properties: create
        normalizationGroups (bool?): Returns a list of the used normalization group IDs.
                Properties: query
        origin (str?): blendShape will be performed with respect to the
                world by default. Valid values are "world" and "local". The local flag will cause the blend
                shape to be performed with respect to the shape's local
                origin.
                Properties: create
        parallel (bool?): Inserts the new deformer in a parallel chain to any existing deformers in
                the history of the object. A blendShape is inserted to blend the parallel
                results together.
                Works in create mode (and edit mode if the deformer has
                no geometry added yet).
                Properties: create, edit
        prune (bool?): Removes any points not being deformed by the deformer in
                its current configuration from the deformer set.
                Properties: edit
        remove (bool?): Specifies that objects listed after the -g flag should
                be removed from this deformer.
                Properties: edit, multiuse
        resetTargetDelta (Tuple[Unknown, Unknown]?): Remove all delta values for points in the target geometry,
                including all sequential targets defined by target index.
                Parameter list:

                uint: the base object index
                uint: the target index
                Properties: edit, multiuse
        selectedComponents (bool?): Returns the components used by the deformer that are currently selected.
                This intersects the current selection with the components affected by the deformer.
                Properties: query
        split (bool?): Branches off a new chain in the dependency graph instead
                of inserting/appending the deformer into/onto an
                existing chain.
                Works in create mode (and edit mode if the deformer has
                no geometry added yet).
                Properties: create, edit
        suppressDialog (bool?): Suppress dialog box and run the command as defined by the user.
                Properties: create, edit
        symmetryAxis (str?): Axis for symmetry. Valid values are "X", "Y", and "Z".
                Properties: query, edit
        symmetryEdge (str?): One or two symmetry edge names, separated by a ".". See the blendShape node's
                symmetryEdge attribute for legal values.
                Properties: query, edit, multiuse
        symmetrySpace (Unknown?): Space for symmetry. 0 = Topological, 1 = Object, 2 = UV
                Properties: query, edit
        tangentSpace (bool?): Indicate that the delta of the specified target should be relative to
                the tangent space of the surface.
                Properties: create, edit
        target (Tuple[str, Unknown, str, float]?): Set target object as the index target shape for the base shape base
                object. The full influence of target shape takes effect when its shape
                weight is targetValue.
                Parameter list:

                string: the base object
                int: index
                string: the target object
                double: target value
                Properties: create, query, edit, multiuse
        topologyCheck (bool?): Set the state of checking for a topology match between the
                shapes being blended. Default is on.
                Properties: create
        transform (str?): Set transform for target, then the deltas will become relative to a post transform. Typically the
                best workflow for this option is to choose a joint that is related to the fix you have introduced.
                This flag should be used only if the "Deformation order" of blendShape node is "Before".
                Properties: query, edit
        useComponentTags (bool?): When this flag is specified a setup using componentTags will be created.
                This means no groupId, groupParts, tweak or objectSet nodes will be
                created and connected to the new deformer.
                Properties: create
        weight (Tuple[Unknown, float]?): Set the weight value (second parameter) at index (first parameter).
                Properties: create, query, edit, multiuse
        weightCount (Unknown?): Set the number of shape weight values.
                Properties: create, query, edit

    Returns:
        List[str]: (the blendShape node name)

    Example:
    """

def blendShapeEditor(*args: Any, control: bool = ..., defineTemplate: str = ..., docTag: str = ..., exists: bool = ..., filter: str = ..., forceMainConnection: str = ..., highlightConnection: str = ..., lockMainConnection: bool = ..., mainListConnection: str = ..., panel: str = ..., parent: str = ..., selectionConnection: str = ..., stateString: bool = ..., targetControlList: bool = ..., targetList: bool = ..., unParent: bool = ..., unlockMainConnection: bool = ..., updateMainConnection: bool = ..., useTemplate: str = ..., verticalSliders: bool = ...) -> str:
    """This command creates an editor that derives from the base editor
    class that has controls for blendShape, control nodes.
    Args:
        control (bool?): Query only. Returns the top level control for this editor.
                Usually used for getting a parent to attach popup menus.
                Caution: It is possible for an editor to exist without a
                control. The query will return "NONE" if no control is present.
                Properties: query
        defineTemplate (str?): Puts the command in a mode where any other flags and arguments are
                parsed and added to the command template specified in the argument.
                They will be used as default arguments in any subsequent
                invocations of the command when templateName is set as the
                current template.
                Properties: create
        docTag (str?): Attaches a tag to the editor.
                Properties: create, query, edit
        exists (bool?): Returns whether the
                specified object exists or not. Other flags are ignored.
                Properties: create
        filter (str?): Specifies the name of an itemFilter object to be used with this editor.
                This filters the information coming onto the main list
                of the editor.
                Properties: create, query, edit
        forceMainConnection (str?): Specifies the name of a selectionConnection object that the
                editor will use as its source of content. The editor will only
                display items contained in the selectionConnection object. This is
                a variant of the -mainListConnection flag in that it will force a
                change even when the connection is locked. This flag is used to
                reduce the overhead when using the -unlockMainConnection
                , -mainListConnection, -lockMainConnection flags in immediate
                succession.
                Properties: create, query, edit
        highlightConnection (str?): Specifies the name of a selectionConnection object that
                the editor will synchronize with its highlight list. Not all
                editors have a highlight list. For those that do, it is a secondary
                selection list.
                Properties: create, query, edit
        lockMainConnection (bool?): Locks the current list of objects within the mainConnection,
                so that only those objects are displayed within the editor.
                Further changes to the original mainConnection are ignored.
                Properties: create, edit
        mainListConnection (str?): Specifies the name of a selectionConnection object that the
                editor will use as its source of content. The editor will
                only display items contained in the selectionConnection object.
                Properties: create, query, edit
        panel (str?): Specifies the panel for this editor. By default if
                an editor is created in the create callback of a scripted panel it
                will belong to that panel. If an editor does not belong to a panel
                it will be deleted when the window that it is in is deleted.
                Properties: create, query
        parent (str?): Specifies the parent layout for this editor. This flag will only
                have an effect if the editor is currently un-parented.
                Properties: create, query, edit
        selectionConnection (str?): Specifies the name of a selectionConnection object that the
                editor will synchronize with its own selection list. As the user
                selects things in this editor, they will be selected in the
                selectionConnection object. If the object undergoes changes, the
                editor updates to show the changes.
                Properties: create, query, edit
        stateString (bool?): Query only flag. Returns the MEL command that will create an
                editor to match the current editor state. The returned command string
                uses the string variable $editorName in place of a specific name.
                Properties: query
        targetControlList (bool?):
                Properties: query
        targetList (bool?):
                Properties: query
        unParent (bool?): Specifies that the editor should be removed from its layout.
                This cannot be used in query mode.
                Properties: create, edit
        unlockMainConnection (bool?): Unlocks the mainConnection, effectively restoring the original
                mainConnection (if it is still available), and dynamic updates.
                Properties: create, edit
        updateMainConnection (bool?): Causes a locked mainConnection to be updated from the orginal
                mainConnection, but preserves the lock state.
                Properties: create, edit
        useTemplate (str?): Forces the command to use a command template other than
                the current one.
                Properties: create
        verticalSliders (bool?):
                Properties: create, query, edit

    Returns:
        str: The name of the editor

    Example:
    """

def blendShapePanel(*args: Any, blendShapeEditor: bool = ..., control: bool = ..., copy: str = ..., createString: bool = ..., defineTemplate: str = ..., docTag: str = ..., editString: bool = ..., exists: bool = ..., init: bool = ..., isUnique: bool = ..., label: str = ..., menuBarRepeatLast: bool = ..., menuBarVisible: bool = ..., needsInit: bool = ..., parent: str = ..., popupMenuProcedure: Callable = ..., replacePanel: str = ..., tearOff: bool = ..., tearOffCopy: str = ..., tearOffRestore: bool = ..., unParent: bool = ..., useTemplate: str = ...) -> str:
    """This command creates a panel that derives from the base panel
    class that houses a blendShapeEditor.
    Args:
        blendShapeEditor (bool?): Query only flag that returns the name of an editor to be associated with the panel.
                Properties: query
        control (bool?): Returns the top level control for this panel.
                Usually used for getting a parent to attach popup menus.
                CAUTION: panels may not have controls at times.  This
                flag can return "" if no control is present.
                Properties: query
        copy (str?): Makes this panel a copy of the specified panel.  Both
                panels must be of the same type.
                Properties: edit
        createString (bool?): Command string used to create a panel
                Properties: edit
        defineTemplate (str?): Puts the command in a mode where any other flags and arguments are
                parsed and added to the command template specified in the argument.
                They will be used as default arguments in any subsequent
                invocations of the command when templateName is set as the
                current template.
                Properties: create
        docTag (str?): Attaches a tag to the Maya panel.
                Properties: create, query, edit
        editString (bool?): Command string used to edit a panel
                Properties: edit
        exists (bool?): Returns whether the
                specified object exists or not. Other flags are ignored.
                Properties: create
        init (bool?): Initializes the panel's default state.  This is usually done
                automatically on file -new and file -open.
                Properties: create, edit
        isUnique (bool?): Returns true if only one instance of this panel type is allowed.
                Properties: query
        label (str?): Specifies the user readable label for the panel.
                Properties: query, edit
        menuBarRepeatLast (bool?): Controls whether clicking on the menu header with the middle mouse button would repeat the last selected menu item.
                Properties: create, query, edit
        menuBarVisible (bool?): Controls whether the menu bar for the panel is displayed.
                Properties: create, query, edit
        needsInit (bool?): (Internal) On Edit will mark the panel as requiring initialization.
                Query will return whether the panel is marked for initialization.  Used
                during file -new and file -open.
                Properties: query, edit
        parent (str?): Specifies the parent layout for this panel.
                Properties: create
        popupMenuProcedure (Callable?): Specifies the procedure called for building the panel's popup menu(s).
                The default value is "buildPanelPopupMenu".  The procedure should take
                one string argument which is the panel's name.
                Properties: query, edit
        replacePanel (str?): Will replace the specified panel with this panel.  If the
                target panel is within the same layout it will perform a swap.
                Properties: edit
        tearOff (bool?): Will tear off this panel into a separate window with a paneLayout
                as the parent of the panel. When queried this flag will return if the
                panel has been torn off into its own window.
                Properties: query, edit
        tearOffCopy (str?): Will create this panel as a torn of copy of the specified source panel.
                Properties: create
        tearOffRestore (bool?): Restores panel if it is torn off and focus is given to it.
                If docked, becomes the active panel in the docked window.
                This should be the default flag that is added to all panels
                instead of -to/-tearOff flag which should only be used to tear off the panel.
                Properties: create, edit
        unParent (bool?): Specifies that the panel should be removed from its layout.
                This (obviously) cannot be used with query.
                Properties: edit
        useTemplate (str?): Forces the command to use a command template other than
                the current one.
                Properties: create

    Returns:
        str: The name of the panel

    Example:
    """

def blendTwoAttr(*args: str, attribute: str = ..., attribute0: str = ..., attribute1: str = ..., blender: str = ..., controlPoints: bool = ..., driver: int = ..., name: str = ..., shape: bool = ..., time: Unknown = ...) -> List[str]:
    """A blendTwoAttr nodes takes two inputs, and blends the values of the inputs
    from one to the other, into an output value. The blending of the two
    inputs uses a blending function, and the following formula:The blendTwoAttr command can be used to blend the animation of an
    object to transition smoothly between the animation of two other
    objects.When the blendTwoAttr command is issued, it creates a blendTwoAttr
    node on the specified attributes, and reconnects whatever was previously
    connected to the attributes to the new blend nodes. You may also
    specify which two attributes should be used to blend together.The driver is used when you want to keyframe an object after it is
    being animated by a blend node. The current driver index specifies
    which of the two blended attributes should be keyframed.
    Args:
        attribute (str?): A list of attributes for the selected nodes for which a
                blendTwoAttr node will be created.
                      In query mode, this flag needs a value.
                Properties: create, multiuse
        attribute0 (str?): The attribute that should be connected to the first input
                of the new blendTwoAttr node.
                When queried, it returns a string.
                Properties: create, query, edit
        attribute1 (str?): The attribute that should be connected to the second input
                of the new blendTwoAttr node.
                When queried, it returns a string.
                Properties: create, query, edit
        blender (str?): The blender attribute. This is the attribute that will be
                connected to the newly created blendTwoAttr node(s) blender attribute.
                This attribute controls how much of each of the two attributes
                to use in the blend. If this flag is not specified, a new
                animation curve is created whose value goes from 1 to 0
                throughout the time range specified by the -t flag. If -t is not
                specified, an abrupt change from the value of the first to the
                value of the second attribute will occur at the current time
                when this command is issued.
                Properties: create, query, edit
        controlPoints (bool?): Explicitly specify whether or not to include the
                control points of a shape (see "-s" flag) in the list of attributes.
                Default: false.
                Properties: create
        driver (int?): The index of the driver attribute for this blend node (0 or 1)
                When queried, it returns an integer.
                Properties: create, query, edit
        name (str?): name for the new blend node(s)
                Properties: create, query
        shape (bool?): Consider all attributes of shapes below transforms as well,
                except "controlPoints". Default: true
                Properties: create
        time (Unknown?): The time range between which the blending between the 2 attributes
                should occur. If a single time is specified, then the blend will
                cause an abrupt change from the first to the second attribute at
                that time.  If a range is specified, a smooth blending will occur
                over that time range. The default is to make a sudden transition
                at the current time.
                Properties: create

    Returns:
        List[str]: The names of the blendTwoAttr dependency nodes that were created.

    Example:
    """

def blindDataType(dataType: str = ..., longDataName: str = ..., longNames: bool = ..., query: bool = ..., shortDataName: str = ..., shortNames: bool = ..., typeId: int = ..., typeNames: bool = ...) -> str:
    """This command creates a blind data type, which is represented by a
    blindDataTemplate node in the DG. A blind data type can have one
    or more attributes. On the command line, the attributes should be
    ordered by type for best memory utilization, largest first:
    string, binary, double, float, int, and finally boolean.
    Once a blind data type is created, blind data of that type may
    be assigned using the polyBlindData command. Note that as well
    as polygon components, blind data may be assigned to objects
    and to NURBS patches. A blind data type may not be modified
    after it is created: in order to do so it must be deleted and
    recreated. Any existing blind data of that type would also need
    to be deleted and recreated.
    When used with the query flag, this command will return information
    about the attributes of the specified blind data type.create, blinddata, type
    Args:
        dataType (str?): Specifies the dataTypes that are part of BlindData node being created.
                Allowable strings are "int", "float", "double", "string", "boolean" and "binary".
                Must be used togeter with the -ldn and -sdn flags to specify each attribute.
                Properties: create, multiuse
        longDataName (str?): Specifies the long names of the datas that are part of BlindData node being
                created. Must be used togeter with the -dt and -sdn flags to specify each attribute.
                Properties: create, multiuse
        longNames (bool?): Specifies that for a query command the long attributes names be listed.
                Properties: create
        query (bool?): Specifies that this is a special query type command.
                Properties: create
        shortDataName (str?): Specifies the short names of the data that are part of BlindData node being
                created. Must be used togeter with the -dt and -ldn flags to specify each attribute.
                Properties: create, multiuse
        shortNames (bool?): Specifies that for a query command the short attribute names be listed.
                Properties: create
        typeId (int?): Specifies the typeId of the BlindData type being created.
                Properties: create
        typeNames (bool?): Specifies that for a query command the data types be listed.
                Properties: create

    Returns:
        str: Name of nodes created

    Example:
    """

def boneLattice(*args: str, after: bool = ..., afterReference: bool = ..., before: bool = ..., bicep: float = ..., components: bool = ..., deformerTools: bool = ..., exclusive: str = ..., frontOfChain: bool = ..., geometry: str = ..., geometryIndices: bool = ..., ignoreSelected: bool = ..., includeHiddenSelections: bool = ..., joint: str = ..., lengthIn: float = ..., lengthOut: float = ..., name: str = ..., parallel: bool = ..., prune: bool = ..., remove: bool = ..., selectedComponents: bool = ..., split: bool = ..., transform: str = ..., tricep: float = ..., useComponentTags: bool = ..., widthLeft: float = ..., widthRight: float = ...) -> str:
    """This command creates/edits/queries a boneLattice deformer. The name of
    the created/edited object is returned. Usually you would make use of
    this functionality through the higher level flexor command.
    Args:
        after (bool?): If the default behavior for insertion/appending into/onto
                the existing chain is not the desired behavior then this flag
                can be used to force the command to place the deformer
                node after the selected node in the chain even if
                a new geometry shape has to be created in order to do so.
                Works in create mode (and edit mode if the deformer has
                no geometry added yet).
                Properties: create, edit
        afterReference (bool?): The -afterReference flag is used to specify deformer ordering in a hybrid way that
                choses between -before and -after automatically. If the geometry being
                deformed is referenced then the -after mode is used when adding the new deformer,
                otherwise the -before mode is used. The net effect when using -afterReference to build
                deformer chains is that internal shape nodes in the deformer chain will only
                appear at reference file boundaries, leading to lightweight deformer networks that
                may be more amicable to reference swapping.
                Properties: create, edit
        before (bool?): If the default behavior for insertion/appending into/onto
                the existing chain is not the desired behavior then this flag
                can be used to force the command to place the deformer
                node before the selected node in the chain even if
                a new geometry shape has to be created in order to do so.
                Works in create mode (and edit mode if the deformer has
                no geometry added yet).
                Properties: create, edit
        bicep (float?): Affects the bulging of lattice points on the inside of
                the bend. Positive/negative values cause the points to bulge
                outwards/inwards. Default value is 0.0. When queried, this flag
                returns a float.
                Properties: create, query, edit
        components (bool?): Returns the components used by the deformer
                Properties: query
        deformerTools (bool?): Returns the name of the deformer tool objects (if any)
                as string string ...
                Properties: query
        exclusive (str?): Puts the deformation set in a deform partition.
                Properties: create, query
        frontOfChain (bool?): This command is used to specify that the new deformer
                node should be placed ahead (upstream) of existing deformer
                and skin nodes in the shape's history (but not ahead of
                existing tweak nodes). The input to the
                deformer will be the upstream shape rather than the visible
                downstream shape, so the behavior of this flag is the most
                intuitive if the downstream deformers are in their reset
                (hasNoEffect) position when the new deformer is added.
                Works in create mode (and edit mode if the deformer has
                no geometry added yet).
                Properties: create, edit
        geometry (str?): The specified object will be added to the list of
                objects being deformed by this deformer object, unless
                the -rm flag is also specified. When queried, this flag
                returns string string string ...
                Properties: query, edit, multiuse
        geometryIndices (bool?): Complements the -geometry flag in query mode. Returns
                the multi index of each geometry.
                Properties: query
        ignoreSelected (bool?): Tells the command to not deform objects on the
                current selection list
                Properties: create
        includeHiddenSelections (bool?): Apply the deformer to any visible and hidden objects in the selection list.
                Default is false.
                Properties: create
        joint (str?): Specifies which joint will be used to drive the bulging
                behaviors.
                Properties: create, query, edit
        lengthIn (float?): Affects the location of lattice points along the upper
                half of the bone. Positive/negative values cause the points
                to move away/towards the center of the bone.  Changing this
                parameter also modifies the regions affected by the creasing,
                rounding and width parameters. Default value is 0.0. When
                queried, this flag returns a float.
                Properties: create, query, edit
        lengthOut (float?): Affects the location of lattice points along the lower
                half of the bone. Positive/negative values cause the points
                to move away/towards the center of the bone.  Changing this
                parameter also modifies the regions affected by the creasing,
                rounding and width parameters. Default value is 0.0. When
                queried, this flag returns a float.
                Properties: create, query, edit
        name (str?): Used to specify the name of the node being created.
                Properties: create
        parallel (bool?): Inserts the new deformer in a parallel chain to any existing deformers in
                the history of the object. A blendShape is inserted to blend the parallel
                results together.
                Works in create mode (and edit mode if the deformer has
                no geometry added yet).
                Properties: create, edit
        prune (bool?): Removes any points not being deformed by the deformer in
                its current configuration from the deformer set.
                Properties: edit
        remove (bool?): Specifies that objects listed after the -g flag should
                be removed from this deformer.
                Properties: edit, multiuse
        selectedComponents (bool?): Returns the components used by the deformer that are currently selected.
                This intersects the current selection with the components affected by the deformer.
                Properties: query
        split (bool?): Branches off a new chain in the dependency graph instead
                of inserting/appending the deformer into/onto an
                existing chain.
                Works in create mode (and edit mode if the deformer has
                no geometry added yet).
                Properties: create, edit
        transform (str?): Specifies which dag node is being used to rigidly transform
                the lattice which this node is going to deform.  If this flag is
                not specified an identity matrix will be assumed.
                Properties: create
        tricep (float?): Affects the bulging of lattice points on the outside
                of the bend. Positive/negative values cause the points to bulge
                outwards/inwards. Default value is 0.0. When queried, this flag
                returns a float.
                Properties: create, query, edit
        useComponentTags (bool?): When this flag is specified a setup using componentTags will be created.
                This means no groupId, groupParts, tweak or objectSet nodes will be
                created and connected to the new deformer.
                Properties: create
        widthLeft (float?): Affects the bulging of lattice points on the left side
                of the bend. Positive/negative values cause the points to bulge
                outwards/inwards. Default value is 0.0. When queried, this flag
                returns a float.
                Properties: create, query, edit
        widthRight (float?): Affects the bulging of lattice points on the right
                side of the bend. Positive/negative values cause the points to
                bulge outwards/inwards. Default value is 0.0. When queried, this
                flag returns a float.
                Properties: create, query, edit

    Returns:
        str: Name of bone lattice algorithm node created/edited.

    Example:
    """

def boundary(arg0: str, arg1: str, arg2: str, arg3: str, /, caching: bool = ..., endPoint: bool = ..., endPointTolerance: Unknown = ..., nodeState: int = ..., order: bool = ..., constructionHistory: bool = ..., name: str = ..., object: bool = ..., polygon: int = ..., range: bool = ...) -> List[str]:
    """This command produces a boundary surface given 3 or 4 curves.
    This resulting boundary surface passes through two of the given curves
    in one direction, while in the other direction the shape is
    defined by the remaining curve(s).  If the "endPoint" option
    is on, then the curve endpoints must touch before a surface
    will be created.   This is the usual situation where a boundary
    surface is useful.Note that there is no tangent continuity option with this command.
    Unless all the curve end points are touching, the resulting
    surface will not pass through all curves.  Instead, use the birail
    command.
    Args:
        caching (bool?): Toggle caching for all attributes so that no recomputation is needed
                Properties: create, query, edit
        endPoint (bool?): True means the curve ends must touch before a surface will be created.
                Default: false
                Properties: create, query, edit
        endPointTolerance (Unknown?): Tolerance for end points, only used if endPoint attribute is true.
                Default: 0.1
                Properties: create, query, edit
        nodeState (int?): Maya dependency nodes have 6 possible states.
                The Normal (0), HasNoEffect (1), and Blocking (2) states can be
                used to alter how the graph is evaluated.



                The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)
                are for internal use only. They temporarily shut off parts of the graph during interaction
                (e.g., manipulation). The understanding is that once the operation is done,
                the state will be reset appropriately, e.g. Waiting-Blocking will reset
                back to Blocking.



                The Normal and Blocking cases apply to all nodes, while
                HasNoEffect is node specific; many nodes do not support this option.
                Plug-ins store state in the MPxNode::state attribute. Anyone can set
                it or check this attribute.  Additional details about each of these 3 states follow.




                State
                Description


                Normal
                The normal node state. This is the default.


                HasNoEffect


                The HasNoEffect option (a.k.a. pass-through), is used in cases where
                there is an operation on an input producing an output of the same data type.
                Nearly all deformers support this state, as do a few other nodes.
                As stated earlier, it is not supported by all nodes.


                Itâ€™s typical to implement support for the HasNoEffect state in
                the nodeâ€™s compute method and to perform appropriate operations.
                Plug-ins can also support HasNoEffect.


                The usual implementation of this state is to copy the input directly to the
                matching output without applying the algorithm in the node. For deformers,
                applying this state leaves the input geometry undeformed on the output.




                Blocking


                This is implemented in the depend node base class and applies to all nodes.
                Blocking is applied during the evaluation phase to connections.
                An evaluation request to a blocked connection will return as failures,
                causing the destination plug to retain its current value. Dirty propagation
                is indirectly affected by this state since blocked connections are never cleaned.


                When a node is set to Blocking the behavior is supposed to be the same as
                if all outgoing connections were broken. As long as nobody requests evaluation
                of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked
                node will still respond to getAttr requests but a getAttr on a
                downstream node will not reevaluate the blocked node.


                Setting the root transform of a hierarchy to Blocking wonâ€™t automatically
                influence child transforms in the hierarchy. To do this, youâ€™d need to
                explicitly set all child nodes to the Blocking state.


                For example, to set all child transforms to Blocking, you could use the
                following script.



                import maya.cmds as cmds
                def blockTree(root):
                nodesToBlock = []
                for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys():
                nodesToBlock += cmds.listConnections(node, source=True, destination=True )
                for node in {source:1 for source in nodesToBlock}.keys():
                cmds.setAttr( '%s.nodeState' % node, 2 )



                Applying this script would continue to draw objects but things would not be animated.




                Default: kdnNormal
                Properties: create, query, edit
        order (bool?): True if the curve order is important.
                Default: true
                Properties: create, query, edit
        constructionHistory (bool?): Turn the construction history on or off.
                Properties: create
        name (str?): Sets the name of the newly-created node. If it contains
                namespace path, the new node will be created under the
                specified namespace; if the namespace does not exist, it
                will be created.
                Properties: create
        object (bool?): Create the result, or just the dependency node.
                Properties: create
        polygon (int?): The value of this argument controls the type of the object
                created by this operation

                 0. nurbs surface
                 1. polygon (use nurbsToPolygonsPref to set the parameters for the conversion)
                 2. subdivision surface (use nurbsToSubdivPref to set the parameters for the conversion)
                 3. Bezier surface
                 4. subdivision surface solid (use nurbsToSubdivPref to set the
                parameters for the conversion)
                Properties: create
        range (bool?): Force a curve range on complete input curve.
                Properties: create

    Returns:
        List[str]: Object name and node name

    Example:
    """

def boxDollyCtx(arg0: str, /, alternateContext: bool = ..., exists: bool = ..., history: bool = ..., image1: str = ..., image2: str = ..., image3: str = ..., name: str = ..., toolName: str = ...) -> str:
    """This command can be used to create, edit, or query a dolly
    context.
    Args:
        alternateContext (bool?): Set the ALT+MMB and ALT+SHIFT+MMB to refer to this context.
                Properties: create, query
        exists (bool?): Returns true or false depending upon whether the
                specified object exists. Other flags are ignored.
                Properties: create
        history (bool?): If this is a tool command, turn the construction history on
                for the tool in question.
                Properties: create
        image1 (str?): First of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        image2 (str?): Second of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        image3 (str?): Third of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        name (str?): If this is a tool command, name the tool appropriately.
                Properties: create
        toolName (str?): Name of the specific tool to which this command refers.
                Properties: create, query

    Returns:
        str: The name of the context

    Example:
    """

def boxZoomCtx(arg0: str, /, exists: bool = ..., history: bool = ..., image1: str = ..., image2: str = ..., image3: str = ..., name: str = ..., zoomScale: float = ...) -> str:
    """This command can be used to create, edit, or query a box zoom
    context. If this context is used on a perspective camera, the
    field of view and view direction are changed. If the camera is
    orthographic, the orthographic width and eye point are
    changed. The left and middle mouse interactively zoom the
    view. The control key can be used to enable box zoom. A box
    starting from left to right will zoom in, and a box starting from
    right to left will zoom out.
    Args:
        exists (bool?): Returns true or false depending upon whether the
                specified object exists. Other flags are ignored.
                Properties: create
        history (bool?): If this is a tool command, turn the construction history on
                for the tool in question.
                Properties: create
        image1 (str?): First of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        image2 (str?): Second of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        image3 (str?): Third of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        name (str?): If this is a tool command, name the tool appropriately.
                Properties: create
        zoomScale (float?): Scale the zoom.
                Properties: create, query, edit

    Returns:
        str: The name of the context

    Example:
    """

def bufferCurve(*args: str, animation: str = ..., attribute: str = ..., controlPoints: bool = ..., exists: bool = ..., float: Unknown = ..., hierarchy: str = ..., includeUpperBound: bool = ..., index: Unknown = ..., overwrite: bool = ..., shape: bool = ..., swap: bool = ..., time: Unknown = ..., useReferencedCurve: bool = ...) -> int:
    """This command operates on a keyset.  A keyset is
    defined as a group of keys within a specified time range on one or
    more animation curves.The animation curves comprising a keyset depend on the value
    of the "-animation" flag:Note that the "-animation" flag can be used to override
    the curves uniquely identified by the multi-use
    "-attribute" flag, which takes an argument of the form
    attributeName, such as "translateX".Keys on animation curves are identified by either
    their time values or their indices.  Times and indices can
    be given individually or as part of a list or range (see Examples).This command helps manage buffer curve for animated objects
    Args:
        animation (str?): Where this command should get the animation to act
                on.  Valid values are "objects," "keys," and
                "keysOrObjects" Default: "keysOrObjects."  (See
                Description for details.)
                Properties: create
        attribute (str?): List of attributes to select
                      In query mode, this flag needs a value.
                Properties: create, multiuse
        controlPoints (bool?): This flag explicitly specifies whether or not to include the
                control points of a shape (see "-s" flag) in the list of attributes.
                Default: false.  (Not valid for "pasteKey" cmd.)
                In query mode, this flag needs a value.
                Properties: create
        exists (bool?): Returns true if a buffer curve currently exists on the
                specified attribute; false otherwise.
                Properties: query
        float (Unknown?): value uniquely representing a non-time-based
                key (or key range) on a time-based animCurve.  Valid
                floatRange include single values (-f 10) or a
                string with a lower and upper bound, separated by a
                colon (-f "10. 20")
                      In query mode, this flag needs a value.
                Properties: create, multiuse
        hierarchy (str?): Hierarchy expansion options.  Valid values are "above,"
                "below," "both," and "none." (Not valid for "pasteKey" cmd.)
                In query mode, this flag needs a value.
                Properties: create
        includeUpperBound (bool?): When the -t/time or -f/float flags represent a range
                of keys, this flag determines whether the keys at the
                upper bound of the range are included in the keyset.
                Default value: true.  This flag is only valid when
                the argument to the -t/time flag is a time range with
                a lower and upper bound.  (When used with the "pasteKey"
                command, this flag refers only to the time range of the
                target curve that is replaced, when using options such
                as "replace," "fitReplace," or "scaleReplace."  This
                flag has no effect on the curve pasted from the clipboard.)
                Properties: create
        index (Unknown?): index of a key on an animCurve
                      In query mode, this flag needs a value.
                Properties: create, multiuse
        overwrite (bool?): Create a buffer curve.  "true" means create a buffer curve
                whether or not one already existed.  "false" means if a
                buffer curve exists already then leave it alone.  If no
                flag is specified, then the command defaults to -overwrite false
                Properties: create
        shape (bool?): Consider attributes of shapes below transforms as well,
                except "controlPoints".  Default: true.  (Not valid for "pasteKey" cmd.)
                In query mode, this flag needs a value.
                Properties: create
        swap (bool?): For animated attributes which have buffer curves, swap
                the buffer curve with the current animation curve
                Properties: create
        time (Unknown?): time uniquely representing a key (or key
                range) on a time-based animCurve. See the code
                examples below on how to format for a single
                frame or frame ranges.
                      In query mode, this flag needs a value.
                Properties: create, multiuse
        useReferencedCurve (bool?): In create mode, sets the buffer curve to the referenced curve.
                Curves which are not from file references will ignore this flag.
                In query mode, returns true if the selected keys are displaying their
                referenced curve as the buffer curve, and false if they are not.
                Properties: create, query

    Returns:
        int: Number of buffer curves

    Example:
    """

def buildBookmarkMenu(arg0: str, /, editor: str = ..., type: str = ...) -> bool:
    """This command handles building the "dynamic" Bookmark
    menu, to show all bookmarks ("sets") of a specified
    type ("sets -text")menuName is the string returned by the "menu" command.
    Args:
        editor (str?): Name of the editor which this menu belongs to
                Properties: create
        type (str?): Type of bookmark (sets -text) to display
                Properties: create

    Returns:
        bool:

    Example:
    """

def buildKeyframeMenu(arg0: str, /) -> bool:
    """This command handles building the "dynamic" Keyframe
    menu, to show attributes of currently selected objects,
    filtered by the current manipulator.menuName is the string returned by the "menu" command.
    The target menu will entries appended to it (and deleted from it) to always
    show what's currently keyframable.
    Returns:
        bool:

    Example:
    """

def buildSendToBackburnerDialog() -> None: ...
def button(arg0: str, /, actOnPress: bool = ..., actionIsSubstitute: bool = ..., align: str = ..., annotation: str = ..., backgroundColor: Tuple[float, float, float] = ..., command: Callable = ..., defineTemplate: str = ..., docTag: str = ..., dragCallback: Callable = ..., dropCallback: Callable = ..., enable: bool = ..., enableBackground: bool = ..., enableKeyboardFocus: bool = ..., exists: bool = ..., fullPathName: bool = ..., height: int = ..., highlightColor: Tuple[float, float, float] = ..., isObscured: bool = ..., label: str = ..., manage: bool = ..., noBackground: bool = ..., numberOfPopupMenus: bool = ..., parent: str = ..., popupMenuArray: bool = ..., preventOverride: bool = ..., recomputeSize: bool = ..., statusBarMessage: str = ..., useTemplate: str = ..., visible: bool = ..., visibleChangeCommand: Callable = ..., width: int = ...) -> str:
    """Create a button control capable of displaying a textual label and
    executing a command when selected by the user.
    Args:
        actOnPress (bool?): If true then the command specified by the command flag
                will be executed when a mouse button is pressed.  If false then
                that command will be executed after the mouse button is released.
                The default value is false.
                Properties: create, query, edit
        actionIsSubstitute (bool?): This flag is obsolete and should no longer be used.
                Properties: create, query, edit
        align (str?): This flag is obsolete and should no longer be used.
                The button label will always be center-aligned.
                Properties: create, query, edit
        annotation (str?): Annotate the control with an extra string value.
                Properties: create, query, edit
        backgroundColor (Tuple[float, float, float]?): The background color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                When setting backgroundColor, the background is automatically
                enabled, unless enableBackground is also specified with a false
                value.
                Properties: create, query, edit
        command (Callable?): Command executed when the control is pressed.
                Properties: create, query, edit
        defineTemplate (str?): Puts the command in a mode where any other flags and arguments are
                parsed and added to the command template specified in the argument.
                They will be used as default arguments in any subsequent
                invocations of the command when templateName is set as the
                current template.
                Properties: create
        docTag (str?): Add a documentation flag to the control.  The documentation flag
                has a directory structure.
                (e.g., -dt render/multiLister/createNode/material)
                Properties: create, query, edit
        dragCallback (Callable?): Adds a callback that is called when the middle mouse button
                is pressed.  The MEL version of the callback is of the form:

                global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods)

                The proc returns a string array that is transferred to the drop site.
                By convention the first string in the array describes the user settable
                message type.  Controls that are application defined drag sources may
                ignore the callback. $mods allows testing for the key modifiers CTRL and
                SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL,
                3 == CTRL + SHIFT.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def callbackName( dragControl, x, y, modifiers ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "x", "y", "modifiers".  The
                "dragControl" value is a string and the other values are integers (eg the
                callback string could be "print '%(dragControl)s %(x)d %(y)d %(modifiers)d'")
                Properties: create, edit
        dropCallback (Callable?): Adds a callback that is called when a drag and drop
                operation is released above the drop site.  The MEL version of the callback is
                of the form:

                global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type)

                The proc receives a string array that is transferred from the drag source.
                The first string in the msgs array describes the user defined message type.
                Controls that are application defined drop sites may ignore the
                callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "dropControl", "messages", "x", "y",
                "type".  The "dragControl" value is a string and the other values are integers
                (eg the callback string could be
                "print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'")
                Properties: create, edit
        enable (bool?): The enable state of the control.  By default, this flag is
                set to true and the control is enabled.  Specify false and the control
                will appear dimmed or greyed-out indicating it is disabled.
                Properties: create, query, edit
        enableBackground (bool?): Enables the background color of the control.
                Properties: create, query, edit
        enableKeyboardFocus (bool?): If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse.
                This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls.
                If disabled, text in text fields can still be selected with the mouse but cannot be copied (except on Linux when "Middle Click Paste" is enabled).
                Properties: create, query, edit
        exists (bool?): Returns whether the
                specified object exists or not. Other flags are ignored.
                Properties: create
        fullPathName (bool?): Return the full path name of the widget, which includes all the parents.
                Properties: query
        height (int?): The height of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit
        highlightColor (Tuple[float, float, float]?): The highlight color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                Properties: create, query, edit
        isObscured (bool?): Return whether the control can actually be seen by the user.
                The control will be obscured if its state is invisible, if it is
                blocked (entirely or partially) by some other control, if it or a
                parent layout is unmanaged, or if the control's window is
                invisible or iconified.
                Properties: query
        label (str?): The label text.  The default label is the name of
                the control.
                Properties: create, query, edit
        manage (bool?): Manage state of the control.  An unmanaged control is
                not visible, nor does it take up any screen real estate.  All
                controls are created managed by default.
                Properties: create, query, edit
        noBackground (bool?): Clear/reset the control's background.
                Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.
                Properties: create, edit
        numberOfPopupMenus (bool?): Return the number of popup menus attached to this control.
                Properties: query
        parent (str?): The parent layout for this control.
                Properties: create, query
        popupMenuArray (bool?): Return the names of all the popup menus attached to this
                control.
                Properties: query
        preventOverride (bool?): If true, this flag prevents overriding the control's
                attribute via the control's right mouse button menu.
                Properties: create, query, edit
        recomputeSize (bool?): If true then the control will recompute it's size to
                just fit the size of the label.  If false then the control size
                will remain fixed as you change the size of the label.  The
                default value of this flag is true.
                Properties: create, query, edit
        statusBarMessage (str?): Extra string to display in the status bar when the mouse is over the control.
                Properties: create, edit
        useTemplate (str?): Forces the command to use a command template other than
                the current one.
                Properties: create
        visible (bool?): The visible state of the control.  A control is created
                visible by default.  Note that a control's actual appearance is
                also dependent on the visible state of its parent layout(s).
                Properties: create, query, edit
        visibleChangeCommand (Callable?): Command that gets executed when visible state of the control changes.
                Properties: create, query, edit
        width (int?): The width of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit

    Returns:
        str: Full path name to the control.

    Example:
    """

def buttonManip(arg0: Callable, arg1: str, /, icon: str = ...) -> bool:
    """This creates a button manipulator. This manipulator has a position in
    space and a triad manip for positioning. When you click on the top
    part of the manip, the command defined by the first argument is
    executed. The command is associated with the manipulator when it is
    created.If a dag object is included on the command line, the manip will be
    parented to the object. This means moving the object will move the
    manip. You can move the manip independently of the object using its
    triad.Note that a buttonManip may not be parented to more than one object.
    Args:
        icon (str?): Specify an icon to represent the manipulator.
                Properties: create

    Returns:
        bool:

    Example:
    """

def cacheAppend() -> None: ...
def cacheAppendOpt() -> None: ...
def cacheEvaluator(*args: str, cacheFillMode: str = ..., cacheFillOrder: str = ..., cacheInvalidate: Unknown = ..., cacheName: str = ..., cachedFrames: bool = ..., cachingPoints: bool = ..., creationParameters: bool = ..., delegateEvaluation: bool = ..., dynamicsAsyncRefresh: bool = ..., dynamicsSupportActive: bool = ..., dynamicsSupportEnabled: bool = ..., flushCache: str = ..., flushCacheRange: Tuple[Unknown, bool] = ..., flushCacheSync: bool = ..., flushCacheWait: bool = ..., hybridCacheMode: str = ..., layeredEvaluationActive: bool = ..., layeredEvaluationCachingPoints: bool = ..., layeredEvaluationEnabled: bool = ..., listCacheNames: bool = ..., listCachedNodes: bool = ..., listValueNames: bool = ..., newAction: str = ..., newActionParam: str = ..., newFilter: str = ..., newFilterParam: str = ..., newRule: str = ..., newRuleParam: str = ..., pauseInvalidation: bool = ..., preventFrameSkip: bool = ..., resetRules: bool = ..., resourceUsage: bool = ..., resumeInvalidation: bool = ..., safeMode: bool = ..., safeModeMessages: bool = ..., safeModeTriggered: bool = ..., valueName: str = ..., waitForCache: float = ...) -> str:
    """This command controls caching configuration.  It allows interaction with the
    caching system.Caching configuration is done through a set of rules.  Most rules are composed
    of a "filter", which is the test to be perform in order to determine if the rule
    should be applied, and an "action", which is the effect that the rule application
    should have on nodes that satisfy the criteria.A caching mode is therefore a set of rules that determines which nodes are
    being cached.  This mode can be serialized to a JSON string using the
    "creationParameters" flag in query mode.A few cache configuration rules, filters and actions are provided in order to
    support the built-in default caching modes.Note that any combination of cache configuration rules other than the default modes
    is considered unsupported and to be used at one's own risk.  The default modes
    are "Evaluation cache", "VP2 software cache" and "VP2 hardware cache".  The sets
    of rules used to enable each mode are listed in the code examples.In order to get a cache configuration value for a given node or list of nodes,
    theflag can be used in query mode.  Without any additional
    parameters, this query is the same as if theflag was set to
    "active", i.e. it queries whether the given cache is active or not.If the queried node is not a caching point, there will be no caching
    configuration information associated with it and the query will return an
    empty string (which is basically the same as all cache modes being inactive).
    If the queried node is a caching point, the returned string will be the
    requested information from the given cache.  For example, querying the
    "active" value can return "0" or "1".Caching
    Args:
        cacheFillMode (str?): Specifies the cache fill mode. Valid values are: "syncOnly" to fill cache
                during playback, "syncAsync" to cache during playback and in background,
                 and "asyncOnly" to fill cache only in background. Query returns current mode.
                Properties: create, query
        cacheFillOrder (str?): Specifies in which order the cache fills the timeline. Valid values are:
                "forward" to fill cache in forward direction, "backward" to fill cache backwards,
                "bidirectional" to fill cache in forward and backward directions simultaneously,
                 and "forwardFromBegin" to fill cache in forward direction from animation start.
                 Query returns current cache fill mode.
                Properties: create, query
        cacheInvalidate (Unknown?): Specifies the frame range in which cache should be invalidated. The range
                should be specified as a pair of positive integers.

                    Usage examples:

                 -ci "10. 20"{Python equivalent: ('10','20')} means all frames
                        in the range from 10 to 20, inclusive, in the current time unit.


                    Omitting one end of a range means using either end of the animation range
                     (or both), as in the following examples:

                 -ci "10. " means all frames from time 10 (in the current time unit)
                        onwards to the maximum time in the animation range (on the timeline).
                 -ci ":10" means all frames from the minimum time on the animation range
                        (on the timeline) up to (and including) time 10 (in the current time unit).
                 -ci ":" is a short form to specify all frames, from minimum to
                        maximum time on the current animation range.
                Properties: create
        cacheName (str?): Specifies the name of the cache from which to query a value.
                			In query mode, this flag needs a value.
                Properties: query
        cachedFrames (bool?): Get the list of frames with valid cache data.
                The result is an integer array containing multiple triplets of (cache-status, begin-frame, end-frame)
                For example,
                The result is an array of 9 integers [(0b01, 1, 3), (0b10, 7, 10), (0b11, 13, 15)].
                In MEL, the result is typed as "int[9]".
                In Python, the result is typed as "Tuple[int,int,int][3]".
                The result suggests frames 1. 3 (1,2,3), 7. 10 (7,8,9,19), and 13. 15 (13,14,15) are cached.
                No other frames contain valid cache data.
                The cache-status numbers are always 1 if "layeredEvaluationActive" is false.
                The cache-status can be one of {1,2,3}, when "layeredEvaluationActive" is true.
                It represents whether the frame is valid on animation cache or dynamics cache, the encoding is:

                1 (0b01) : only animation cache is valid
                2 (0b10) : only dynamics cache is valid
                3 (0b11) : both animation and dynamics cache are valid

                In the above example, it suggests:
                frames 1. 3 are only valid in animation cache.
                frames 7. 10 are only valid in dynamics cache.
                frames 13. 15 are valid in both and considered as 'fully-cached'.
                Properties: query
        cachingPoints (bool?): Get list of nodes marked as caching points, i.e. nodes with at least one
                type of cache active.
                Properties: query
        creationParameters (bool?): Get the current mode creation parameters.  The result is a JSON string which
                represents an array with an element for each rule.  Each element is an
                association between the parameter name and its value when creating the rule.
                Properties: query
        delegateEvaluation (bool?): Returns whether the specified node(s) are delegating to evaluation.
                Properties: query
        dynamicsAsyncRefresh (bool?): Enable / Disable Asynchronous Refresh in Dynamics Support mode.
                Traditionally, edits related to the simulation system require the user to re-playback the scene to see the result.
                When Asynchronous Refresh is active, Maya will process the simulation in the background and refresh the viewport once the result is ready.
                Note, the automatic refresh will not happen if the frame contains temproary edits. For example, an object is moved without setting the keyframe.
                Properties: create, query
        dynamicsSupportActive (bool?): Query if the Dynamics Support mode is active.
                Dynamics Support mode is used to support Physics Simulation, such as Hair, or Fluid.
                It will be activated if such nodes are detected in the scene, and "enableDynamicsSupport" is set to true.
                When Dynamics Support mode is active, you will notice the following behavior:

                Dynamics nodes will be frozen for uncached frame
                A separate dynamics cache line will appear on the Time Slider
                Dynamics cache starts after the animation cache was filled
                Dynamics cache only fills in the background
                Dynamics cache always fills forward from the beginning
                Dynamics cache evaluation may refresh foreground dynamics nodes (see the flag "dynamicsAsyncRefresh")
                Properties: query
        dynamicsSupportEnabled (bool?): Specifies if Dynamics nodes are allowed to participate in Cached Playback
                When disabled, Dynamics nodes will trigger "Safe mode" and prevent caching.
                When enabled, Dynamics nodes will participate in caching and trigger "Dynamics support mode".
                For more information check flag "dynamicsSupportActive".
                Properties: create, query
        flushCache (str?): Specifies to flush the current cache. Valid values are: "keep" to store the existing
                cache as backup, and "destroy" to delete the current cache.
                Properties: create
        flushCacheRange (Tuple[Unknown, bool]?): Specifies the frame range in which cache should be flushed. By default it will
                destroy the cache - if the 'flushCache' is also set then it will define what
                to do with the cache range being flushed.
                The range should be specified as a pair of positive integers and a boolean.

                    Usage examples:

                 -flushCacheRange "10. 20" on {Python equivalent: ('10','20',True)}
                                means all frames in the range from 10 to 20, inclusive, in the current time unit.
                 -flushCacheRange "12. 18" off {Python equivalent: ('12','18',False)}
                                means all frames before 12 and after 18, not inclusive, in the current time unit.


                    Omitting one end of a range means using either end of the animation range
                     (or both), as in the following examples:

                 -flushCacheRange "10. " on means all frames from time 10 (in the current time unit)
                        onwards to the maximum time in the animation range (on the timeline).
                 -flushCacheRange ":10" on means all frames from the minimum time on the animation range
                        (on the timeline) up to (and including) time 10 (in the current time unit).
                 -flushCacheRange ":" on is a short form to specify all frames, from minimum to
                        maximum time on the current animation range.
                Properties: create
        flushCacheSync (bool?): Specifies how to flush the cache: synchronously or asynchronously. True for synchronous, False for asynchronous.
                Properties: create, query
        flushCacheWait (bool?): Wait for the cache destruction to be completed.
                Properties: create
        hybridCacheMode (str?): Specifies the hybrid cache mode. Valid values are: "disabled", not to use
                hybrid cache; "smp", to evaluate on the GPU meshes with GPU-supported deformation
                stacks if they use Smooth Mesh Preview (instead of caching them);
                "all", to evaluate on the GPU all meshes with PU-supported deformation stacks
                (instead of caching them). Query returns current mode.
                Properties: create, query
        layeredEvaluationActive (bool?): Query if the Layered Evaluation mode is active.
                When Layered Evaluation is active, the background cache fill process will be split into multiple passes for different contents (evaluation nodes).
                These contents are referred as different 'evaluation layers', representing different level of details (LoD) in animation evaluation.
                For example:

                The first layer contains regular animations like a character motion.
                The second layer contains dynamics simulations like a character's hair and cloth.

                Maya will create separated cache and cache fill pass for each of the layers.
                Additional cache bars will be added to the Time Slider UI to represent these layers.
                The background cache fill pass for each of the layer will start in order.
                In the above example, two passes of background cache fill will be observed.
                In the first pass of background-cache-fill or playback-fill, only Character motions will be evaluated and filled, Hair and Clothes are frozen in-place.
                After the cache for first layer have been filled for all the frames,
                the second pass of cache fill will start to simulate Hairs and Clothes physics and fill the cache for the 2nd layer.
                Once the cache for the 2nd layer is filled for a frame, users can scrub the timeline to view the fully updated effects.
                Note, when layered evaluation is active, any foreground playback or manipulation will only evaluate the first evaluation layer,
                and all the FX contents will be frozen in the viewport until the background simulation is complete.
                For example, when rotating a characterâ€™s head, its hair will not follow in real time.
                If the flag "dynamicsAsyncRefresh" is enabled, the FX contents will be updated automatically after simulation cached up. Please refer to the flag for more detail.
                Properties: query
        layeredEvaluationCachingPoints (bool?): Get the list of nodes marked as caching points because of layered evaluation.
                Properties: query
        layeredEvaluationEnabled (bool?): Enable / Disable Layered Evaluation in Dynamics Support mode.
                Refering to flags "dynamicsSupportActive" and "layeredEvaluationActive" for details about layered evaluation enabled behavior.
                This flag is provided to support plugin developers for testing purpose.
                Disabling this option in production is not recommended.
                When disabled, dynamics nodes will share the same cache with regular animation.
                Allows dynamics nodes to be evaluated and stored to cache in the foreground.
                Background "cacheFillOrder" option will be locked to "forwardFromBegin".
                When used with cacheFillMode="syncOnly", it can also be used to support legacy dynamics nodes that cannot evaluate in the background.
                Properties: create, query
        listCacheNames (bool?): Return the list of existing cache names.
                Properties: query
        listCachedNodes (bool?): Returns the list of cached nodes.
                Properties: query
        listValueNames (bool?): Return the list of value names that can be queried for the given cache.
                Properties: query
        newAction (str?): Specifies the name of the new action to create in the new filter/action rule.
                Properties: create
        newActionParam (str?): Specifies the parameter string to pass to the new action to create in the new filter/action rule.
                Properties: create
        newFilter (str?): Specifies the name of the new filter to create in the new filter/action rule.
                Properties: create
        newFilterParam (str?): Specifies the parameter string to pass to the new filter to create in the new filter/action rule.
                Properties: create
        newRule (str?): Specifies the name of the new rule to create.
                Properties: create
        newRuleParam (str?): Specifies the parameter string to pass to the new rule to create.
                Properties: create
        pauseInvalidation (bool?): Pause all incoming invalidation of the cache. Work in symmetry with resumeInvalidation flag.
                PauseInvalidation can be called several time, useful in nesting situation. The same number of resume need to be called to resume the invalidation.
                If queried it will return how much time caching is paused, 0 means it is resumed.
                Properties: create, query
        preventFrameSkip (bool?): Specifies if frame skipping is enabled. Following behavior is seen when frame
                skipping is enabled, and playback is set to play in real-time.

                If cache can't be filled at real-time frame rate, frames will NOT be skipped.
                Once all frames have been looped over(and therefore all frames are cached), and if
                    playing back from cache still can't be done at real-time frame rate; frames WILL be skipped.
                If memory limit is reached before all frames are cached, frames WILL be skipped.
                If cache is invalidated will playing(like flushing it), frames will NOT
                    be skipped(until the cache is full again).
                Properties: create, query
        resetRules (bool?): Reset the cache configuration rules to an empty set of rules.
                Properties: create
        resourceUsage (bool?): Returns the current state of the resource usage as a string. 'unlimited' = the resource limits
                are being ignored, 'out' = the memory limit has been reached, 'low' = the memory usage is at
                90% of the specified limit, 'okay' = memory usage is under 90% of the specified limit.
                Properties: query
        resumeInvalidation (bool?): Resume all incoming invalidation of the cache. Work in symmetry with pauseInvalidation flag.
                PauseInvalidation can be called several time, useful in nesting situation. The same number of resume need to be called to resume the invalidation.
                If queried it will return true if cache is resumed, false otherwise.
                Properties: create, query
        safeMode (bool?): Turns safe mode on or off. In query mode, it returns the status of the safe mode for cache evaluator.
                Properties: create, query
        safeModeMessages (bool?): Prints the safe mode messages to the console.
                Properties: query
        safeModeTriggered (bool?): Returns if the safe mode was triggered for cache evaluator.
                Properties: query
        valueName (str?): Specifies the name of the parameter for which to query the value.
                			In query mode, this flag needs a value.
                Properties: query
        waitForCache (float?): Specifies to wait for cache to fill in background, with [Time to wait in seconds] timeout.
                Properties: create

    Returns:
        str: The state of whether the memory limit has been reached or not ('out', 'okay', 'low', or 'unlimited' with the 'resourceUsage' flag)

    Example:
    """

def cacheFile(*args: str, appendFrame: bool = ..., attachFile: bool = ..., cacheFileNode: str = ..., cacheFormat: str = ..., cacheInfo: str = ..., cacheableAttrs: str = ..., cacheableNode: str = ..., channelIndex: bool = ..., channelName: str = ..., convertPc2: bool = ..., createCacheNode: bool = ..., creationChannelName: str = ..., dataSize: bool = ..., deleteCachedFrame: bool = ..., descriptionFileName: bool = ..., directory: str = ..., doubleToFloat: bool = ..., endTime: int = ..., fileName: str = ..., format: str = ..., geometry: bool = ..., inAttr: str = ..., inTangent: str = ..., interpEndTime: int = ..., interpStartTime: int = ..., noBackup: bool = ..., outAttr: str = ..., outTangent: str = ..., pc2File: str = ..., pointCount: bool = ..., points: str = ..., pointsAndNormals: str = ..., prefix: bool = ..., refresh: bool = ..., replaceCachedFrame: bool = ..., replaceWithoutSimulating: bool = ..., runupFrames: int = ..., sampleMultiplier: int = ..., simulationRate: int = ..., singleCache: bool = ..., startTime: int = ..., staticCache: bool = ..., worldSpace: bool = ...) -> str:
    """Creates one or more cache files on disk to store attribute data for a span of
    frames. The caches can be created for points/normals on a geometry (using
    the pts/points or pan/pointsAndNormals flag), for vectorArray output data
    (using the oa/outAttr flag), or for additional node specific data (using the
    cnd/cacheableNode flag for those nodes that support it).When the ia/inAttr flag is used, connects a cacheFile node that
    associates the data file on disk with the attribute.Frames can be replaced/appended to an existing cache with the
    rcf/replaceCachedFrame and apf/appendFrame flag.  Replaced frames are never deleted.
    They are stored in the same directory as the original cache files with the
    name provided by the f/fileName flag. If no file name is provided,
    the cacheFile name is prefixed with "backup" followed by a unique number.Single file caches are backed up in their entirety. To revert to an older
    version, simply attach to this cache. One file per frame caches only backup
    the description file and the frames that were replaced. To recover these
    types of caches, the user must rename these files to the original name.cache, file, disk
    Args:
        appendFrame (bool?): Appends data to the cache for the times specified by the startTime and endTime flags. If no
                time is provided, appends the current time. Must be used in conjunction
                with the pts/points or cnd/cacheableNode flag. Any overwritten frames will not be
                deleted, but renamed as specified by the f/fileName flag.
                Properties: create
        attachFile (bool?): Used to indicate that rather than creating a cache file, that an
                existing cache file on disk should be attached to an attribute in the scene.
                The inAttr flag is used to specify the attribute.
                Properties: create
        cacheFileNode (str?): Specifies the name of the cache file node(s) we are appending/replacing to
                if more than one cache is attached to the specified geometries.
                			In query mode, this flag needs a value.
                Properties: create, multiuse
        cacheFormat (str?): Cache file format, default is Maya's .mcx format, but others available via plugin
                Properties: create, query
        cacheInfo (str?): In create mode, used to specify a mel script returning a string array. When
                creating the cache, this mel script will be executed and the returned strings
                will be written to the .xml description file of the cache.
                In query mode, returns descriptive info stored in the cacheFile such as
                the user name, Maya scene name and maya version number.
                Properties: create, query, multiuse
        cacheableAttrs (str?): Returns the list of cacheable attributes defined on the accompanying cache node.
                This argument requires the use of the cacheableNode flag.
                Properties: query
        cacheableNode (str?): Specifies the name of a cacheable node whose contents will be cached.
                A cacheable node is a node that is specially designed to work with
                the caching mechanism.  An example of a cacheable node is a nCloth node.
                			In query mode, this flag needs a value.
                Properties: create, multiuse
        channelIndex (bool?): A query-only flag which returns the channel index for the selected geometry
                for the cacheFile node specified using the cacheFileNode flag.
                Properties: create, query
        channelName (str?): When attachFile is used, used to indicate the channel in the file that
                should be attached to inAttr.  If not specified, the first channel in
                the file is used. In query mode, allows user to query the channels associated
                with a description file.
                Properties: create, query, multiuse
        convertPc2 (bool?): Convert a PC2 file to the Maya cache format (true), or convert Maya cache to pc2 format (false)
                Properties: create
        createCacheNode (bool?): Used to indicate that rather than creating a cache file, that a cacheFile
                node should be created related to an existing cache file on disk.
                Properties: create
        creationChannelName (str?): When creating a new cache, this multi-use flag specifies the channels to be cached.
                The names come from the cacheable channel names defined by the object being cached.
                If this flag is not used when creating a cache, then all cacheable channels are cached.
                Properties: create, multiuse
        dataSize (bool?): This is a query-only flag that returns the size of the data being cached per frame.
                This flag is to be used in conjunction with the cacheableNode, points,
                pointsAndNormals and outAttr flags.
                Properties: query
        deleteCachedFrame (bool?): Deletes cached data for the times specified by the startTime/endTime flags.
                If no time is provided, deletes the current frame. Must be used in conjunction
                with the pts/points or cnd/cacheableNode flag. Deleted frames will not be
                removed from disk, but renamed as specified by the f/fileName flag.
                Properties: create
        descriptionFileName (bool?): This is a query-only flag that returns the name of the description file
                for an existing cacheFile node. Or if no cacheFile node is specified, it
                returns the description file name that would be created based on the other
                flags specified.
                Properties: query
        directory (str?): Specifies the directory where the cache files will be located. If the
                directory flag is not specified, the cache files will be placed in the
                project data directory.
                Properties: create, query
        doubleToFloat (bool?): During cache creation, double data is stored in the file as floats.  This helps cut down
                file size.
                Properties: create
        endTime (int?): Specifies the end frame of the cache range.
                Properties: create
        fileName (str?): Specifies the base file name for the cache files. If more than one object is
                being cached and the format is OneFilePerFrame, each cache file will be
                prefixed with this base file name. In query mode, returns the files
                associated with the specified cacheFile node.
                When used with rpf/replaceCachedFrame or apf/appendFrame specifies the name of the backup files.
                If not specified, replaced frames will be stored with a default name.
                			In query mode, this flag can accept a value.
                Properties: create, query
        format (str?): Specifies the distribution format of the cache.  Valid values are "OneFile" and "OneFilePerFrame"
                Properties: create
        geometry (bool?): A query flag which returns the geometry controlled by the specified cache node
                Properties: query
        inAttr (str?): Specifies the name of the attribute that the cache file will drive.
                This file is optional when creating cache files.
                If this flag is not used during create mode, the cache files will
                be created on disk, but will not be driving anything in the scene.
                This flag is required when the attachFile flag is used.
                Properties: create, multiuse
        inTangent (str?): Specifies the in-tangent type when interpolating frames before the replaced
                frame(s). Must be used with the ist/interpStartTime and iet/interpEndTime flags.
                Valid values are "linear", "smooth" and "step".
                Properties: create
        interpEndTime (int?): Specifies the frame until which there will be linear interpolation, beginning
                at endTime. Must be used with the rpf/replaceCachedFrame or apf/appendFrame flag.
                Interpolation is achieved by removing frames between endTime and
                interpEndTime from the cache. Removed frames will be renamed as specified
                by the f/fileName flag.
                Properties: create
        interpStartTime (int?): Specifies the frame from which to begin linear interpolation, ending at
                startTime. Must be used with the rpf/replaceCachedFrame or apf/appendFrame flags.
                Interpolation is achieved by removing  frames between interpStartTime and
                startTime from the cache. These removed frames will will be renamed as
                specified by the f/fileName flag.
                Properties: create
        noBackup (bool?): Specifies that backup files should not be created for any files that may be over-written during
                append, replace or delete cache frames. Can only be used with the apf/appendFrame,
                rpf/replaceCachedFrame or dcf/deleteCachedFrame flags.
                Properties: create
        outAttr (str?): Specifies the name of the attribute that will be cached to disk.
                			In query mode, this flag needs a value.
                Properties: create, multiuse
        outTangent (str?): Specifies the out-tangent type when interpolating frames after the replaced
                frame(s). Must be used with the ist/interpStartTime and iet/interpEndTime flags.
                Valid values are "linear", "smooth" and "step".
                Properties: create
        pc2File (str?): Specifies the full path to the pc2 file.  Must be used in conjunction with the pc2 flag.
                Properties: create
        pointCount (bool?): A query flag which returns the number of points stored in the cache file.
                The channelName flag should be used to specify the channel to be queried.
                Properties: query
        points (str?): Specifies the name of a geometry whose points will be cached.
                			In query mode, this flag needs a value.
                Properties: create, multiuse
        pointsAndNormals (str?): Specifies the name of a geometry whose points and normals will be cached.
                The normals is per-vertex per-polygon. The normals cache cannot be imported
                back to geometry.
                This flag can only be used to export cache file. It cannot be used with
                the apf/appendFrame, dcf/deleteCachedFrame and rpf/replaceCachedFrame flags.
                			In query mode, this flag needs a value.
                Properties: create, multiuse
        prefix (bool?): Indicates that the specified fileName should be used as a prefix for the
                cacheName.
                Properties: create
        refresh (bool?): When used during cache creation, forces a screen refresh during caching.
                This causes the cache creation to be slower but allows you to see how the
                simulation is progressing during the cache.
                Properties: create
        replaceCachedFrame (bool?): Replaces cached data for the times specified by the startTime/endTime
                flags. If no time is provided, replaces cache file for the current time.
                Must be used in conjunction with the pts/points or cnd/cacheableNode flag.
                Replaced frames will not be deleted, but renamed as specified by the
                f/fileName flag.
                Properties: create
        replaceWithoutSimulating (bool?): When replacing cached frames, this flag specifies whether the replacement should
                come from the cached node without simulating or from advancing time and letting
                the simulation run.  This flag is valid only when neither the startTime nor endTime flags
                are used or when both the startTime and endTime flags specify the same time value.
                Properties: edit
        runupFrames (int?): Specifies the number of frames of runup to simulate ahead of the starting frame.
                The value must be greater than or equal to 0.  The default is 2.
                Properties: create, query, edit
        sampleMultiplier (int?): Specifies the sample rate when caches are being created as a multiple of
                simulation Rate. If the value is 1, then a sample will be cached everytime
                the time is advanced.  If the value
                is 2, then every other sample will be cached, and so on.  The default is 1.
                Properties: create, query, edit
        simulationRate (int?): Specifies the simulation rate when caches are being created.  During cache
                creation, the time will be advanced by the simulation rate, until the end
                time of the cache is reached or surpassed.  The value is given in frames.
                The default value is 1 frame.
                Properties: create, query, edit
        singleCache (bool?): When used in conjunction with the points, pointsAndNormal or cacheableNode
                flag, specifies whether multiple geometries should be put into a single
                cache or to create one cache per geometry (default).
                Properties: create
        startTime (int?): Specifies the start frame of the cache range.
                Properties: create
        staticCache (bool?): If false, during cache creation, do not save a cache for the object if it
                appears to have no animation or deformation. If true, save a cache even if
                the object appears to have no animation or deformation. Default is true. In
                query mode, when supplied a shape, the flag returns true if the shape appears
                to have no animation or deformation.
                Properties: create, query
        worldSpace (bool?): If the points flag is used, turning on this flag will result in the world
                space positions of the points being written. The expected use of this
                flag is for cache export.
                Properties: create

    Returns:
        str: name of created cache description file(s)

    Example:
    """

def cacheFileCombine(*args: str, cacheIndex: bool = ..., channelName: str = ..., connectCache: str = ..., keepWeights: bool = ..., layerNode: bool = ..., nextAvailable: bool = ..., object: str = ..., objectIndex: int = ...) -> str:
    """Creates a cacheBlend node that can be used to combine, layer or blend multiple cacheFiles for a given object.cache, file, disk, blend
    Args:
        cacheIndex (bool?): A query only flag that returns the index related to the
                cache specified with the connectCache flag.
                Properties: query
        channelName (str?): Used in conjunction with the connectCache flag to indicate the channel(s) that
                should be connected.  If not specified, the first channel in the file is used.
                Properties: edit, multiuse
        connectCache (str?): An edit flag that specifies a cacheFile node that should be connected to the next available index on the specified cacheBlend node. As a query flag, it returns a string array containing the cacheFiles that feed into the specified cacheBlend node.
                			In query mode, this flag can accept a value.
                Properties: query, edit
        keepWeights (bool?): This is a flag for use in combination with the connectCache flag only. By default, the connectCache flag will set all weights other than the newly added cacheWeight to 0 so that the new cache gets complete control. This flag disables that behavior so that all existing blend weights are retained.
                Properties: edit
        layerNode (bool?): A query flag that returns a string array of the existing cacheBlends on the selected object(s). Returns an empty string array if no cacheBlends are found.
                Properties: query
        nextAvailable (bool?): A query flag that returns the next available index on the selected cacheBlend node.
                Properties: query
        object (str?): This flag is used in combination with the objectIndex flag. It is
                used to specify the object whose index you wish to query.
                			In query mode, this flag needs a value.
                Properties: query
        objectIndex (int?): In edit mode, used in conjunction with the connectCache flag to indicate
                the objectIndex to be connected.
                In query mode, returns the index related to the object specified with
                the object flag.
                Properties: query, edit

    Returns:
        str: Name of created cache layer node(s)

    Example:
    """

def cacheFileMerge(*args: str, endTime: int = ..., geometry: bool = ..., startTime: int = ...) -> List[float]:
    """If selected/specified caches can be successfully merged, will return the start/end frames of the new cache followed by the
    start/end frames of any gaps in the merged cache for which no data should be written to file. In query mode, will return
    the names of geometry associated with the specified cache file nodes.cache, file, merge, disk
    Args:
        endTime (int?): Specifies the end frame of the merge range. If not specified, will figure
                out range from times of caches being merged.
                Properties: create
        geometry (bool?): Query-only flag used to find the geometry nodes associated with the specified cache files.
                Properties: query
        startTime (int?): Specifies the start frame of the merge range. If not specified, will figure
                out range from the times of the caches being merged.
                Properties: create

    Returns:
        List[float]: The start and end times of merged cache followed by start/end of any gaps

    Example:
    """

def cacheFileTrack(*args: str, insertTrack: Unknown = ..., lock: bool = ..., mute: bool = ..., removeEmptyTracks: bool = ..., removeTrack: Unknown = ..., solo: bool = ..., track: Unknown = ...) -> bool:
    """This command is used for inserting and removing tracks related to the caches displayed in the trax editor. It can also be used to modify the track state, for example, to lock or mute a track.cache, file, disk, blend, trax, track
    Args:
        insertTrack (Unknown?): This flag is used to insert a new empty track at the track index
                specified.
                Properties: create
        lock (bool?): This flag specifies whether clips on a track are to be locked or not.
                Properties: create, query, edit
        mute (bool?): This flag specifies whether clips on a track are to be muted or not.
                Properties: create, query, edit
        removeEmptyTracks (bool?): This flag is used to remove all tracks that have no clips.
                Properties: create
        removeTrack (Unknown?): This flag is used to remove the track with the specified index.  The
                track must have no clips on it before it can be removed.
                Properties: create
        solo (bool?): This flag specifies whether clips on a track are to be soloed or not.
                Properties: create, query, edit
        track (Unknown?): Used to specify a new track index for a cache to be displayed. Track-indices are 1. based.
                Properties: create, query, edit

    Returns:
        bool: In query mode, return type is based on queried flag.

    Example:
    """

def caddyManip(*args: Any, **kwargs: Any) -> None: ...
def callbacks(*args: str, addCallback: Callable = ..., clearAllCallbacks: bool = ..., clearCallbacks: bool = ..., describeHooks: bool = ..., dumpCallbacks: bool = ..., executeCallbacks: bool = ..., hook: str = ..., listCallbacks: bool = ..., owner: str = ..., removeCallback: Callable = ...) -> List[str]:
    """This command allows you to add callbacks at key times during UI creation so
    that the Maya UI can be extended.
    The list of standard Maya hooks, as well as the arguments which will be passed
    to the callback based on the context are enumerated in thesection below.
    Custom hooks can also be added if third parties want to add UI extensibility to
    their plugins.ui, callback
    Args:
        addCallback (Callable?): Add a callback for the specified hook. The owner must also be specified
                when adding callbacks.
                Properties: create
        clearAllCallbacks (bool?): Clear all the callbacks for all hooks and owners. This is generally
                only used during plugin development and testing as it affects all callbacks
                registered by Maya and other third parties.
                Properties: create
        clearCallbacks (bool?): Clear all the callbacks for the specified owner. If a hook is specified,
                only the callbacks for that hook and owner will be cleared.
                Properties: create
        describeHooks (bool?): List the standard Maya hooks. Below is a list of the hooks and their associated arguments
                and return values. Custom hooks added by third parties are not listed.


                hyperShadePanelBuildCreateMenu

                This hook is called to add content to the Hypershade panel create menu. It will
                be called after the standard Maya node entries have been created.

                This callback does not have any arguments or return values. In order to preserve
                the desired look in the Maya UI, these callbacks should add a menu item divider just
                before returning using: menuItem -divider true.

                hyperShadePanelBuildCreateSubMenu

                This hook is called to get a classification string for the custom renderer
                shading nodes, to prevent them from being listed with the standard Maya nodes.

                This callback does not have any arguments.

                returns: a classification string, such as rendernode/myrenderer


                hyperShadePanelPluginChange

                This hook is called when a plugin change event (loading / unloading) has occurred to inform Maya whether the
                Hypershade panel needs to be rebuilt.

                classification (string): classification string belonging to a plugin node,
                    possibly from another plugin
                changeType (string): either loadPlugin or unloadPlugin
                returns: (int) non-zero if your plugin is responsible for nodes of this classification,
                    and a Hypershade rebuild is required


                createRenderNodeSelectNodeCategories

                This hook is called when the Create Render Node dialog is being constructed, and allows
                a third party to have their nodes selected by default. A flag of the form -allWithMyRendererUp
                is the standard form, and the selection can be set up in the tree lister in the callback.

                There is no return value for this callback.

                flag (string): flag passed to the Create Render Node dialog command with the leading minus (-) removed
                treeLister (string): the tree lister widget which should be affected


                For example, your callback might look like:


                global proc myRendererCreateRenderNodeSelectNodeCategoriesCallback(string $flag, string $treeLister){
                    if($flag == "allWithMyRendererUp") {
                        treeLister -e -selectPath "myrenderer" $treeLister;
                    }
                }


                createRenderNodePluginChange

                This hook is called when a plugin change event has occurred to decide if the
                Create Render Node dialog needs to be closed.

                classification (string): classification string belonging to a plugin node,
                    possibly from another plugin
                returns: (int) non-zero if your plugin is responsible for nodes of this classification,
                    and the Create Render Node dialog needs to be closed


                renderNodeClassification

                This hook is called to get a classification string for the custom renderer
                shading nodes.  This is used to determine if a given node type belongs to
                a plugin renderer.

                This callback does not have any arguments.

                returns: a classification string, such as rendernode/myrenderer


                createRenderNodeCommand

                This hook is called to give plugin renderers the chance to register their own command for
                creating their nodes from the render node treeLister and Node Editor. The callback should
                determine from the classification of the node type in question if it is theirs, and if so,
                return the appropriate command for creating new nodes of that type.


                postCommand (string): command to be run after the create command
                type (string): nodeType
                returns: (string) MEL create command


                buildRenderNodeTreeListerContent

                This hook is called to give plugin renderers the chance to add their content to the render node
                tree lister.


                renderNodeTreeLister (string): the render node tree lister
                postCommand (string): command to be run post-creation
                filterString (string): a space delimited list of filters


                AETemplateCustomContent

                This hook is called to give plugins a chance to add content to the Attribute Editor for nodes which source AEdependNodeTemplate.


                nodeName (string): the name of the node for which the Attribute Editor is being constructed


                firstConnectedShader

                This hook is called to determine the primary custom shader connected to the given Shading Engine.


                nodeName (string): the name of the Shading Engine
                returns (string): the name of the custom shader if applicable


                allConnectedShaders

                This hook is called to determine all the shaders connected to the given Shading Engine.


                nodeName (string): the name of the Shading Engine
                returns (string): a colon separated list of the connected custom shaders (shader1. shader2. shader3)


                renderLayerPresetMenu

                This hook is called to give plugins a chance to add presets to a renderLayer node.


                nodeName (string): the name of the renderLayer node


                addBakingMenuItems

                This hook is called to give plugins a chance to add baking menu items to the global Render - Lighting/Shading menu.


                menuItemAnchor (string): the name of the menuItem which the new baking menu items should be inserted after.


                addVertexBakingMenuItems

                This hook is called to give plugins a chance to add baking menu items to the global Polygon - Color menu.


                addPrelightMenuItems

                This hook is called to give plugins a chance to add pre-lighting menu items to the global Polygon - Color Set Editor menu.


                addRMBBakingMenuItems

                This hook is called to give plugins a chance to add baking menu items to the RMB menu.


                objectName (string): the name of the object the right mouse button event occured on.


                addMayaRenderingPreferences

                This hook is called to give plugins a chance to add custom preferences to the Maya's Rendering Preferences section.


                updateMayaRenderingPreferences

                This hook is called to give plugins a chance to update custom preferences of the Maya's Rendering Preferences section.


                addMayaMuscleMenuItems

                This hook is called to give plugins a chance to add menu items to the Maya muscle Displace menu.


                menuItemAnchor (string): the name of the menuItem which the new Maya muscle menu items should be inserted after.


                addMayaMuscleShelfButtons

                This hook is called to give plugins a chance to add items to the Maya muscle shelves.


                addBackburnerRendererMenuItems

                This hook is called to give plugins a chance to add items to Maya's Backburner list of available renderers. Note: The menuItem added must be named with the short name equivalent of the renderer. eg: The Maya software renderer adds a menuItem named 'sw'.


                provideAETemplateForNodeType

                This hook is called to give plugins a chance to provide a UI template for nodes which do not have a corresponding AE'nodeType'Template procedure.


                nodeType (string): the type of the node for which the AE is being constructed.
                returns (string): the name of a MEL command or procedure to use as the AETemplate for the requested node type.


                AEnewMultiHandler

                This hook is called to give plugins a chance to provide a UI creation handler for multi attributes.


                nodeName (string): the name of the node for which the AE is being constructed.
                atributeName (string): the name of the multi attribute.
                uiName (string): the UI name of the attribute.
                changedCommand (string): the MEL command or procedure to be executed when the value of the multi attribute is changed.
                elementIndexString (string): a colon separated list of indices at which the elements of the multi attribute live.
                returns (string): if the callback handled the attribute then it should return the full name of the topmost UI element that it created, otherwise it should return an empty string.


                AEreplaceMultiHandler

                This hook is called to give plugins a chance to provide an update handler for multi attributes.


                layoutName (string): the well defined name of the Maya UI component which represents the multi attribute (.
                nodeName (string): the name of the node for which the AE is being constructed.
                atributeName (string): the name of the multi attribute.
                changedCommand (string): the MEL command or procedure to be executed when the value of the multi attribute is changed.
                elementIndexString (string): a colon separated list of indices at which the elements of the multi attribute live.
                returns (int): Return 1 if the callback handled the multi attribute, Return 0 if Maya should provide its default handling.


                AEnewAttributeHandler

                This hook is called to give plugins a chance to provide a UI creation handler for attributes.


                nodeName (string): the name of the node for which the AE is being constructed.
                atributeName (string): the name of the attribute.
                uiName (string): the UI name of the attribute.
                changedCommand (string): the MEL command or procedure to be executed when the value of the attribute is changed.
                returns (string): if the callback handled the attribute then it should return the full name of the topmost UI element that it created, otherwise it should return an empty string.


                AEreplaceAttributeHandler

                This hook is called to give plugins a chance to provide an update handler for attributes.


                nodeName (string): the name of the node for which the AE is being constructed.
                atributeName (string): the name of the attribute.
                changedCommand (string): the MEL command or procedure to be executed when the value of the attribute is changed.
                returns (int): Return 1 if the callback handled the attribute, Return 0 if Maya should provide its default handling.


                provideClassificationStrings

                This hook must be supplied by all third parties that add nodes to the 'shader/surface' classification namespace.


                returns (string): a colon separated list representing the different plugin node classifications.


                provideClassificationExclusionStrings

                This hook is called to give plugins a chance to provide a list of classifications which should be filtered out from a nodeTreeLister category. For example a plugin might want to filter out nodes classified as both 'material' and 'legacy' out of the 'material' category.


                classification (string): the classification the nodeTreeBuilder is inquiring about.
                returns (string): a colon separated list representing the different classifications that should be excluded from the classification the nodeTreeBuilder is inquiring about.


                provideClassificationStringsForFilteredTreeLister

                This hook is called by 'createAssignNewMaterialTreeLister' and gives plugins a chance to append to the classification filter passed to the Tree Lister builder. It must return a string where each new classification is separated by a white space.


                currentFilterString (string): a white-space-separated string representing the current classifications.


                nodeCanBeUsedAsMaterial

                The hook is used by the RMB 'Assign Favorite Material' menu to determine which shading nodes can be used as materials. It must return 1 if the node can be used as a material node and 0 otherwise.


                nodeId (string): the node Id of the shading node being queried.
                nodeOwner (string): the name of the plugin the node belongs to.


                addHeaderContentToMayaLambertianShadersAE

                This hook is called to give plugins a chance to add content to the header of the Attribute Editor of Maya's Lambertian-â€‹derived shaders.


                nodeName (string): the name of the node for which the Attribute Editor is being constructed.


                provideNodeToAttrConnection

                This hook is called to give plugins a chance to provide which output attribute should be used when a node is connected to an input attribute.
                If an input attribute type is given an output attribute of matching type should be returned. If no attribute type is specified (empty string)
                a preferred output attribute of any type can be returned. If no output attribute of matching type is available an empty string should be returned.


                nodeType (string): the node type of the node queried.
                attributeType (string): the data type of the input attribute.
                returns (string): the name of the output attribute to use.


                provideNodeToNodeConnection

                This hook is called to give plugins a chance to provide which attributes should be connected when a node to node connection is made.
                Both the source and destination attributes should be returned in a colon separated list, e.g. "src1. dst1. src2. dst2. src3. dst3"


                srcType (string): the node type of the source node.
                dstType (string): the node type of the destination node.
                returns (string): A colon separated list of source and destination attribute names.


                provideOutputAttributeNameForTextureNode

                This hook is called to give plugins a chance to provide a different output attribute name for Texture nodes. If this hook isn't provided 'outColor' is used.


                nodeName (string): the name of the texture node queried.
                returns (string): the output attribute name of the Texture node.


                addItemsToHypergraphNodePopupMenu

                This hook is called to give plugins a chance to add items to the Hypergraph node popup menu.
                Plugins should add a menu item divider (using: menuItem -divider true) before adding any more items to the popup menu.


                nodeName (string): the name of the node for which the Hypergraph node menu is being constructed.


                addItemsToOutlinerNodePopupMenu

                This hook is called to give plugins a chance to add items to the Outliner node popup menu.
                Plugins should add a menu item divider (using: menuItem -divider true) before adding any more items to the popup menu.


                nodeName (string): the name of the node or Ufe path string for which the Outliner node menu is being constructed.


                addItemsToRenderLayerEditorPopupMenu

                This hook is called to give plugins a chance to add items to the Render Layer Editor popup menu.
                Plugins should add a menu item divider (using: menuItem -divider true) before adding any more items to the popup menu.


                layerName (string): the name of the render layer for which the popup menu is being constructed.


                preventMaterialDeletionFromCleanUpSceneCommand

                This hook is called by the cleanUpScene command and gives the plugin a chance to communicate that a material node is still in use and shouldn't be deleted. The hook is called once per plug/connection pair of each shader instance.


                shader (string): the name of the shader node being deleted.
                plug (string): the name of the plug queried.
                connection (string): the name of the connection queried.


                connectNodeToNodeOverrideCallback

                This hook is called to give plugins a chance to redefine the behavior of drag and drop.


                srcNode (string): the name of the source node (the dragged node).
                dstNode (string): the name of the destination node (the dropped-on node).
                returns (int): Return 1 if Maya should perform the operation that would normally result from this connection. Return 0 to override and provide custom behavior.


                prepareRenderChanged

                This hook is called after an edit on a traversal set with the prepareRender command.


                enableRenderPassMenuOfRenderView

                This hook is called to give plugins a chance to tell Maya it should enable the render pass menu of the render view (under File->Load Render Pass). 'addRenderPassMenuItemsToRenderView' can be used to add items to this menu.


                returns (int): Return 1 if the plugin wants the render pass menu of the render view to be enabled. Return 0 otherwise.


                addItemsToRenderPassMenuOfRenderView

                This hook is called to give plugins a chance to add menu items to the 'render pass' menu of the render view (under File->Load Render Pass). 'enableRenderPassMenuOfRenderView' can be used to enable the render pass menu of the render view.


                addItemsToRMBMenuOfTreeLister

                This hook is called to give plugins a chance to populate the RMB menu of nodes listed in a tree lister. Plugins should add a menu item divider (using: menuItem -divider true) before adding any more items to the RMB menu.


                nodeType (string): The node type of the tree lister node for which the RMB menu is being built.
                scriptCommand (string): The script command associated with the tree lister node for which the RMB menu is being built.
                returns (int): Return 0 if Maya should append its own items to the menu of the current node type. This should be the return value for all node types a plugin isn't explicitly interested in. Return 1 if Maya shouldn't add any of its items to the menu of the current node type. Note: All menu items related to managing the 'Favorites' section of the tree lister will always be added to the RMB menu regardless of the return value (those are treated as special cases).


                saveCustomNodePresetAttributes

                This hook is called to give plugins a chance to store extra commands in the node preset file being saved.


                presetNodeToSave (string): The name of the preset node being saved.
                returns (string): The custom procedure to use to generate the mel script to be appended to the nodePreset -custom flag of the current presetNode save event (see the documentation of the nodePreset command for more information on the format of the -custom flag).


                addItemToFileMenu

                This hook is called to give plugins a chance to add menu items to the main File menu.


                addItemToCreateLightMenu

                This hook is called to give plugins a chance to add menu items to the create light menu.

                textureReload

                This hook is called to give plugins a chance to update all nodes that reference the texture file.


                file (string): the file path of the texture to reload.


                renderSettingsBuilt

                This hook is called after the render settings window has been built.

                rendererAddOneTabToGlobalsWindowCreateProc

                This hook is called to allow renderers the opportunity to add renderer specific tabs to the unified render globals window (render settings window).


                createProc (string): the name of the procedure used to create the content of the tab.


                shouldEarlyReturnFromUpdateMultiCameraBufferNamingMenu

                This hook is called to allow users to early return from the updateMultiCameraBufferNamingMenu() function by returning "true" in the callback handler.


                returns (string): Returns "true" if the caller wishes to early return from the updateMultiCameraBufferNamingMenu() function.


                shouldEarlyReturnFromUpdateMayaSoftwareImageFormatControl

                This hook is called to allow users to early return from the updateMayaSoftwareImageFormatControl() function by returning "true" in the callback handler.


                returns (string): Returns "true" if the caller wishes to early return from the updateMayaSoftwareImageFormatControl() function.


                shouldEarlyReturnFromUpdateDefaultTraversalSetMenu

                This hook is called to allow users to early return from the updateDefaultTraversalSetMenu() function by returning "true" in the callback handler.


                returns (string): Returns "true" if the caller wishes to early return from the updateDefaultTraversalSetMenu() function.


                shouldEarlyReturnFromShouldAppearInNodeCreateUI

                This hook is called to allow users to early return from the shouldAppearInNodeCreateUI() function by returning "true" in the callback handler.


                returns (string): Returns "true" if the caller wishes to early return from the shouldAppearInNodeCreateUI() function.


                updateAE

                This hook is called at the end of the updateAE() function.
                Properties: create
        dumpCallbacks (bool?): Gives a list of all the registered callbacks for all hooks and owners. Can be
                useful for debugging.
                Properties: create
        executeCallbacks (bool?): Execute the callbacks for the specified hook, passing the extra arguments to
                each callback when it is executed.  Returns an array (MEL) or list (Python)
                containing the return values from each callback that was executed.
                If a callback returns no value, the array will contain an empty string (MEL)
                or None (Python).
                Properties: create
        hook (str?): The name of the hook for which the callback should be registered.
                Properties: create
        listCallbacks (bool?): Get the list of callbacks for the specified hook name. If the owner is
                specified, only callbacks for the specified hook and owner will be listed.
                Properties: create
        owner (str?): The name of the owner registering the callback. This is typically a plugin name.
                Properties: create
        removeCallback (Callable?): Remove an existing callback for the specified hook name. The owner must
                also be specified when removing a callback.
                Properties: create

    Returns:
        List[str]: Command result

    Example:
    """

def camera(arg0: str, /, aspectRatio: float = ..., cameraScale: float = ..., centerOfInterest: Unknown = ..., clippingPlanes: bool = ..., depthOfField: bool = ..., displayFieldChart: bool = ..., displayFilmGate: bool = ..., displayFilmOrigin: bool = ..., displayFilmPivot: bool = ..., displayGateMask: bool = ..., displayResolution: bool = ..., displaySafeAction: bool = ..., displaySafeTitle: bool = ..., fStop: float = ..., farClipPlane: Unknown = ..., farFocusDistance: Unknown = ..., filmFit: str = ..., filmFitOffset: float = ..., filmRollOrder: str = ..., filmRollValue: float = ..., filmTranslateH: float = ..., filmTranslateV: float = ..., focalLength: float = ..., focusDistance: Unknown = ..., homeCommand: str = ..., horizontalFieldOfView: float = ..., horizontalFilmAperture: float = ..., horizontalFilmOffset: float = ..., horizontalPan: float = ..., horizontalRollPivot: float = ..., horizontalShake: float = ..., journalCommand: bool = ..., lensSqueezeRatio: float = ..., lockTransform: bool = ..., motionBlur: bool = ..., name: str = ..., nearClipPlane: Unknown = ..., nearFocusDistance: Unknown = ..., orthographic: bool = ..., orthographicWidth: Unknown = ..., overscan: float = ..., panZoomEnabled: bool = ..., position: Tuple[Unknown, Unknown, Unknown] = ..., postScale: float = ..., preScale: float = ..., renderPanZoom: bool = ..., rotation: Tuple[float, float, float] = ..., shakeEnabled: bool = ..., shakeOverscan: float = ..., shakeOverscanEnabled: bool = ..., shutterAngle: float = ..., startupCamera: bool = ..., stereoHorizontalImageTranslate: float = ..., stereoHorizontalImageTranslateEnabled: bool = ..., verticalFieldOfView: float = ..., verticalFilmAperture: float = ..., verticalFilmOffset: float = ..., verticalLock: bool = ..., verticalPan: float = ..., verticalRollPivot: float = ..., verticalShake: float = ..., worldCenterOfInterest: Tuple[Unknown, Unknown, Unknown] = ..., worldUp: Tuple[Unknown, Unknown, Unknown] = ..., zoom: float = ...) -> List[str]:
    """Create, edit, or query a camera with the specified properties.The resulting camera can be repositioned using the viewPlace
    command. Many of the camera settings only affect the resulting
    rendered image. E.g. the F/Stop, shutter speed, the film related
    options, etc. Scaling the camera icon does not change any camera
    properties.
    Args:
        aspectRatio (float?): The ratio of the film back width to the film back height.
                Properties: create, query, edit
        cameraScale (float?): Scale the camera.
                Properties: create, query, edit
        centerOfInterest (Unknown?): Set the linear distance from the camera's eye point to the
                center of interest.
                Properties: create, query, edit
        clippingPlanes (bool?): Activate manual clipping planes.
                Properties: create, query, edit
        depthOfField (bool?): Determines whether a depth of field calculation is performed
                to give varying focus depending on the distance of the
                objects.
                Properties: create, query, edit
        displayFieldChart (bool?): Activate display of the video field chart when looking through
                the camera.
                Properties: create, query, edit
        displayFilmGate (bool?): Activate display of the film gate icons when looking through
                the camera.
                Properties: create, query, edit
        displayFilmOrigin (bool?): Activate the display of the film origin guide when
                looking through the camera.
                Properties: create, query, edit
        displayFilmPivot (bool?): Activate display of the film pivot guide when looking
                through the camera.
                Properties: create, query, edit
        displayGateMask (bool?): Display the gate mask, file or resolution, as a shaded area
                to the edge of the viewport.
                Properties: create, query, edit
        displayResolution (bool?): Activate display of the current rendering resolution (as
                defined in the render globals) when looking through the
                camera.
                Properties: create, query, edit
        displaySafeAction (bool?): Activate display of the video Safe Action guide
                when looking through the camera.
                Properties: create, query, edit
        displaySafeTitle (bool?): Activate display of the video Safe Title guide
                when looking through the camera.
                Properties: create, query, edit
        fStop (float?): A real lens normally contains a diaphragm or other stop which
                blocks some of the light that would otherwise pass through
                it. This stop is usually approximately round, and its diameter
                as seen from the front of the lens is called the lens
                diameter. The lens diameter is often described by its relation
                to the focal length of the lens. A lens whose diameter is
                one-eighth its local length is said to have an F-stop of
                8. This is an optical property of the lens.
                Properties: create, query, edit
        farClipPlane (Unknown?): Specify the distance to the far clipping plane.
                Properties: create, query, edit
        farFocusDistance (Unknown?): Linear distance to the far focus plane.
                Properties: create, query, edit
        filmFit (str?): This describes how the digital image (in pixels) relates to
                the film back. Since the film back is defined in terms of real
                numbers with some arbitrary film aspect, and the digital image
                is defined in integer pixels with an equally arbitrary (and
                different) resolution, relating the two can get
                complicated. There are 4 choices:

                horizontal
                In this case the digital image is made to fit the film
                back exactly in the horizontal direction. This then gives each
                pixel a horizontal size = (film back width) / (horizontal
                resolution). The pixel height is then = (pixel width) / (pixel
                aspect ratio). Now that the pixel has a size, resolution gives
                us a complete image. That image will match the film back
                exactly in width. It will almost never match in height, either
                being too tall or too short. By playing with the numbers you
                can get it pretty close though.
                vertical
                This is the same idea as horizontal fit, only applied
                vertically. Thus the digital image will match the film back
                exactly in height, but miss in width.
                fill
                This is a convenience item. The system calculates both
                horizontal and vertical fits and then applies the one that
                makes the digital image larger than the film back.
                overscan
                Overscanning the film gate in the camera view allows us
                to choreograph action outside of the frustum from within the
                camera view without having to resort to a dolly or zoom. This
                feature is also essential for animating image planes.
                Properties: create, query, edit
        filmFitOffset (float?): Since we know from the above that the digital image may not
                match the film back exactly, we now have the question of how
                to position one relative to the other. Thus fit
                offset. Normally the centers are aligned. Fit offset lets you
                move the smaller image within the larger one. Specify the
                distance for film offset (inches).
                Properties: create, query, edit
        filmRollOrder (str?): Specifies how the roll is applied with respect to the
                pivot value.

                Rotate-Translate
                The film back is first rotated then translated by the
                pivot point value.
                Translate-Rotate
                The film back is first translated then rotated by the
                film roll value.
                Properties: create, query, edit
        filmRollValue (float?): This specifies that amount of rotation around the film back.
                The roll value is specified in degrees. The rotation occurs around
                the specified pivot point. This value is used to compute a film
                roll matrix, which is a component of the post-projection matrix.
                Properties: create, query, edit
        filmTranslateH (float?): The horizontal film translation. Values are normalized to
                the viewing area.
                Properties: create, query, edit
        filmTranslateV (float?): The vertical film translation. Values are normalized to the
                viewing area.
                Properties: create, query, edit
        focalLength (float?): This is the distance along the lens axis between the lens and
                the film plane when "focal distance" is infinitely large. This
                is an optical property of the lens. This double precision
                parameter is always specified in millimeters.
                Properties: create, query, edit
        focusDistance (Unknown?): Set the focus at a certain distance in front of the camera.
                Properties: create, query, edit
        homeCommand (str?): Specify the command to execute when "viewSet -home" is applied
                to this camera. All occurances of "%camera" will be replaced
                with the cameras name before viewSet runs the command.
                Properties: create, query, edit
        horizontalFieldOfView (float?): This is the film back width as seen by the lens when focused
                at infinity (ie., focal length away) measured as an
                angle. Note that it has nothing to do with pixels or the
                digital image or any aspects. Angle of view is a derived
                field, that is, it is not used internally by Alias and can be
                completely determined from other information. It is included
                as a convenience for the user. Its derivation is aov = 2 *
                atan( fbw / (2 * f) ) where "aov" is the angle of view, "fbw"
                is the film back width and "f" is the focal length.
                Properties: create, query, edit
        horizontalFilmAperture (float?): The horizontal width of the camera's film plane. The camera's
                film is located on the film plane. The extent of the film
                which will be exposed to an image of the scene in front of the
                lens is limited to a rectangular area described by the film
                back. This double precision parameter is always specified in
                inches.
                Properties: create, query, edit
        horizontalFilmOffset (float?): Horizontal offset from the center of the film back. Normally
                the film back will be centered on the lens axis. However, this
                need not be so. Film offset is the displacement of the center
                of the film back from the lens axis, also measured in
                inches. Note that offsetting the film back will distort the
                image, but will not alter the focus. This double precision
                parameter is always specified in inches.
                Properties: create, query, edit
        horizontalPan (float?): Horizontal 2D camera pan (inches)
                Properties: create, query, edit
        horizontalRollPivot (float?): The horizontal pivot point from the center of the film back.
                The pivot point is used during rotation of the film back.  The pivot
                is the point where the rotation occurs around. This double precision
                parameter corresponds to the normalized viewport. This value is a
                part of the post projection matrix.
                Properties: create, query, edit
        horizontalShake (float?): Another horizontal offset from the center of the film back,
                which can be used and stored on the camera in addition to the
                horizonal film offset attribute.  This allows for film-based
                camera shake internal to the camera.  This works in exactly the same
                units and coordinates that the film offset attribute does.
                The effect of this attribute is toggled by the shake enabled attribute.
                Properties: create, query, edit
        journalCommand (bool?): Journal interactive camera commands. Commands can be undone
                when a camera is journaled.
                Properties: create, query, edit
        lensSqueezeRatio (float?): This is presently just an information field in the camera
                editor is meant to convey the horizontal distortion of the
                anamorphic lens normally used with some film formats. If it
                were used, it would do something like pixel aspect. Remember
                however that lens distortion (intentional or not) is slightly
                different than the output hardware's quantization. The fact
                that a "net" distortion parameter could be used for both may
                or may not confuse the issue.
                Properties: create, query, edit
        lockTransform (bool?): Lock the camera. When a camera is locked, its transformation information,
                that is, its Translate and Rotate properties cannot be adjusted, and the
                center of interest point cannot be moved.
                For orthographic cameras, Orthographic Width is also locked.
                For camera groups, Aim and Up locator's translate is also locked.
                For stereo cameras, the root camera is locked.
                Properties: create, query, edit
        motionBlur (bool?): Determines whether the camera's image is motion blured (as
                opposed to an object's image). For example, if you want to
                blur the camera movement when you are performing a flyby.
                Properties: create, query, edit
        name (str?): Name of the camera.
                Properties: create, query, edit
        nearClipPlane (Unknown?): Specify the distance to the NEAR clipping plane.
                Properties: create, query, edit
        nearFocusDistance (Unknown?): Linear distance to the near focus plane.
                Properties: create, query, edit
        orthographic (bool?): Activate the orthographic camera.
                Properties: create, query, edit
        orthographicWidth (Unknown?): Set the orthographic projection width.
                Properties: create, query, edit
        overscan (float?): Set the percent of overscan.
                Properties: create, query, edit
        panZoomEnabled (bool?): Toggle camera 2D pan and zoom
                Properties: create, query, edit
        position (Tuple[Unknown, Unknown, Unknown]?): Three linear values can be specified to translate the camera.
                Properties: create, query, edit
        postScale (float?): The post-scale value.  This value multiplied against
                the computed projection matrix. It is applied after the
                the film roll.
                Properties: create, query, edit
        preScale (float?): The pre-scale value. The value is multiplied against
                the computed projection matrix. It is applied before the film
                roll.
                Properties: create, query, edit
        renderPanZoom (bool?): Toggle camera 2D pan and zoom in render
                Properties: create, query, edit
        rotation (Tuple[float, float, float]?): Three angular values can be specified to rotate the camera.
                Properties: create, query, edit
        shakeEnabled (bool?): Toggles the effect of the horizontal and vertical shake
                attributes.
                Properties: create, query, edit
        shakeOverscan (float?): Controls the amount of overscan in the output rendered image.
                For use when adding film-based camera shake.  Acts as a multiplier
                to the film aperture on the camera.
                Properties: create, query, edit
        shakeOverscanEnabled (bool?): Toggles the effect of the shake overscan attribute.
                Properties: create, query, edit
        shutterAngle (float?): Specify the shutter angle (degrees).
                Properties: create, query, edit
        startupCamera (bool?): A startup camera is marked undeletable and implicit. This flag
                can be used to set or query the startup state of a
                camera. There must always be at least one startup camera.
                Properties: create, query, edit
        stereoHorizontalImageTranslate (float?): A film-back offset for use in stereo camera rigs.
                Properties: create, query, edit
        stereoHorizontalImageTranslateEnabled (bool?): Toggles the effect of the stereo HIT attribute.
                Properties: create, query, edit
        verticalFieldOfView (float?): Set the vertical field of view.
                Properties: create, query, edit
        verticalFilmAperture (float?): The vertical height of the camera's film plane. This double
                precision parameter is always specified in inches.
                Properties: create, query, edit
        verticalFilmOffset (float?): Vertical offset from the center of the film back. This double
                precision parameter is always specified in inches.
                Properties: create, query, edit
        verticalLock (bool?): Lock the size of the vertical film aperture.
                Properties: create, query, edit
        verticalPan (float?): Vertical 2D camera pan (inches)
                Properties: create, query, edit
        verticalRollPivot (float?): Vertical pivot point used for rotating the film back. This
                double precision parameter corresponds to the normalized viewport.
                This value is used to compute the film roll matrix, which is a
                component of the post projection matrix.
                Properties: create, query, edit
        verticalShake (float?): Vertical offset from the center of the film back.  See horizontal
                shake attribute description.  This is toggled by the shake enabled
                attribute.
                Properties: create, query, edit
        worldCenterOfInterest (Tuple[Unknown, Unknown, Unknown]?): Camera world center of interest point.
                Properties: create, query, edit
        worldUp (Tuple[Unknown, Unknown, Unknown]?): Camera world up vector.
                Properties: create, query, edit
        zoom (float?): The percent over the film viewable frustum to display
                Properties: create, query, edit

    Returns:
        List[str]: (transform name and shape name)

    Example:
    """

def cameraSet(arg0: str, /, active: bool = ..., appendTo: bool = ..., camera: str = ..., clearDepth: bool = ..., deleteAll: bool = ..., deleteLayer: bool = ..., insertAt: bool = ..., layer: int = ..., name: str = ..., numLayers: bool = ..., objectSet: str = ..., order: int = ...) -> str:
    """This command manages camera set nodes. Camera sets allow the users to
    break a single camera shot into layers. Instead of drawing all objects
    with a single camera, you can isolate the camera to only focus on
    certain objects and layer another camera into the viewport that draws
    the other objects. The situation to use camera sets primarily occurs
    when building stereoscopic scenes.For example, a set of stereo parameters may make the background
    objects divergent beyond the tolerable range of the human perceptual
    system. However, you like the settings because the main focus is in
    the foreground and the depth is important to the visual look of the
    scene.  You can use camera sets to break apart the shot into a
    foreground stereo camera and background stereo camera. The foreground
    stereo camera will retain the original parameters; however, it will
    only focus on the foreground elements.  The background stereo camera
    will have a different set of stereo parameters and will only draw the
    background element.Camera sets can be viewed using the stereo viewer and are currently only
    designed to work with stereo camera rigs.
    Args:
        active (bool?): Gets / sets the active camera layer.
                Properties: create, query, edit
        appendTo (bool?): Append a new camera and/or object set to then end of the cameraSet layer
                list. This flag cannot be used in conjunction with insert flag. Additionally,
                it requires the camera and/or objectSet flag to be used.
                Properties: create, edit
        camera (str?): Set/get the camera for a particular layer. When in query mode, You
                must specify the layer with the layer flag.
                Properties: create, query, edit
        clearDepth (bool?): Specifies if the drawing buffer should be cleared before beginning the draw
                for that layer.
                Properties: create, query, edit
        deleteAll (bool?): Delete all camera layers
                Properties: create, edit
        deleteLayer (bool?): Delete a layer from the camera set. You must specify the layer using the
                layer flag.
                Properties: create, edit
        insertAt (bool?): Inserts the specified camera and/or object set at the specified layer.
                This flag cannot be used in conjunction with the append flag. Additionally,
                this flag requires layer and camera (or objectSet) flag to be used.
                Properties: create, edit
        layer (int?): Specifies the layer index to be used when accessing layer information
                Properties: create, query, edit
        name (str?): Gets or sets the name for the created camera set.
                Properties: create, query
        numLayers (bool?): Returns the number of layers defined in the specified cameraSet
                Properties: create, query
        objectSet (str?): Set/get the objectSet for a particular layer. When in query mode, you must
                specify the layer with the layer flag.
                Properties: create, query, edit
        order (int?): Set the order in which a particular layer is processed. This flag must be
                used in conjunction with the layer flag.
                Properties: create, query, edit

    Returns:
        str: The new cameraSet node (when in create mode)

    Example:
    """

def cameraView(arg0: str, /, addBookmark: bool = ..., animate: bool = ..., bookmarkType: int = ..., camera: str = ..., name: str = ..., removeBookmark: bool = ..., setCamera: bool = ..., setView: bool = ...) -> str:
    """This command creates a preset view for a camera which is then
    independent of the camera. The view stores a camera's eye point,
    center of interest point, up vector, tumble pivot, horizontal
    aperture, vertical aperature, focal length, orthographic width,
    and whether the camera is orthographic or perspective by default.
    Or you can only store 2D pan/zoom attributes by setting the
    bookmarkType to 1. These settings can be applied to any other
    camera through the set camera flag.This command can be used for creation or edit of camera view
    objects.  This command can only be executed with one of the add
    bookmark, or remove bookmark and one of set camera, or the set
    view flags set.
    Args:
        addBookmark (bool?): Associate this view with the camera specified or the camera in
                the active model panel. This flag can be used for creation or
                edit.
                Properties: create, edit
        animate (bool?): Set the animation capability for view switches.
                Properties: create, edit
        bookmarkType (int?): Specify the bookmark type, which can be: 0. 3D bookmark; 1. 2D
                Pan/Zoom bookmark.
                Properties: create
        camera (str?): Specify the camera to use. This flag should be used in
                conjunction with the add bookmark, remove bookmark, set
                camera, or set view flags. If this flag is not specified the
                camera in the active model panel will be used.
                Properties: edit
        name (str?): Set the name of the view. This flag can only be used for
                creation.
                Properties: create
        removeBookmark (bool?): Remove the association of this view with the camera specified
                or the camera in the active model panel. This can only be used
                with edit.
                Properties: edit
        setCamera (bool?): Set this view into a camera specified by the camera flag or the
                camera in the active model panel. This flag can only be used
                with edit.
                Properties: edit
        setView (bool?): Set the camera view to match a camera specified or the active
                model panel. This flag can only be used with edit.
                Properties: edit

    Returns:
        str: (name of the camera view)

    Example:
    """

def canCreateCaddyManip(*args: Any) -> bool:
    """This command returns true if there can be a manipulator made for
    the specified selection, false otherwise.
    Returns:
        bool: The queried value

    Example:
    """

def canCreateManip(*args: str) -> bool:
    """This command returns true if there can be a manipulator made for
    the specified selection, false otherwise.
    Returns:
        bool: Command result

    Example:
    """

def canvas(arg0: str, /, annotation: str = ..., backgroundColor: Tuple[float, float, float] = ..., defineTemplate: str = ..., docTag: str = ..., dragCallback: Callable = ..., dropCallback: Callable = ..., enable: bool = ..., enableBackground: bool = ..., enableKeyboardFocus: bool = ..., exists: bool = ..., fullPathName: bool = ..., height: int = ..., highlightColor: Tuple[float, float, float] = ..., hsvValue: Tuple[float, float, float] = ..., isObscured: bool = ..., manage: bool = ..., noBackground: bool = ..., numberOfPopupMenus: bool = ..., parent: str = ..., popupMenuArray: bool = ..., pressCommand: Callable = ..., preventOverride: bool = ..., rgbValue: Tuple[float, float, float] = ..., statusBarMessage: str = ..., useTemplate: str = ..., visible: bool = ..., visibleChangeCommand: Callable = ..., width: int = ...) -> str:
    """Creates a control capable of displaying a color swatch. This control can
    also accept a command to be called when the colour swatch is pressed by
    the user.Note: The -dgc/dragCallback and -dpc/dropCallback are not available
    for this control.
    Args:
        annotation (str?): Annotate the control with an extra string value.
                Properties: create, query, edit
        backgroundColor (Tuple[float, float, float]?): The background color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                When setting backgroundColor, the background is automatically
                enabled, unless enableBackground is also specified with a false
                value.
                Properties: create, query, edit
        defineTemplate (str?): Puts the command in a mode where any other flags and arguments are
                parsed and added to the command template specified in the argument.
                They will be used as default arguments in any subsequent
                invocations of the command when templateName is set as the
                current template.
                Properties: create
        docTag (str?): Add a documentation flag to the control.  The documentation flag
                has a directory structure.
                (e.g., -dt render/multiLister/createNode/material)
                Properties: create, query, edit
        dragCallback (Callable?): Adds a callback that is called when the middle mouse button
                is pressed.  The MEL version of the callback is of the form:

                global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods)

                The proc returns a string array that is transferred to the drop site.
                By convention the first string in the array describes the user settable
                message type.  Controls that are application defined drag sources may
                ignore the callback. $mods allows testing for the key modifiers CTRL and
                SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL,
                3 == CTRL + SHIFT.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def callbackName( dragControl, x, y, modifiers ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "x", "y", "modifiers".  The
                "dragControl" value is a string and the other values are integers (eg the
                callback string could be "print '%(dragControl)s %(x)d %(y)d %(modifiers)d'")
                Properties: create, edit
        dropCallback (Callable?): Adds a callback that is called when a drag and drop
                operation is released above the drop site.  The MEL version of the callback is
                of the form:

                global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type)

                The proc receives a string array that is transferred from the drag source.
                The first string in the msgs array describes the user defined message type.
                Controls that are application defined drop sites may ignore the
                callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "dropControl", "messages", "x", "y",
                "type".  The "dragControl" value is a string and the other values are integers
                (eg the callback string could be
                "print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'")
                Properties: create, edit
        enable (bool?): The enable state of the control.  By default, this flag is
                set to true and the control is enabled.  Specify false and the control
                will appear dimmed or greyed-out indicating it is disabled.
                Properties: create, query, edit
        enableBackground (bool?): Enables the background color of the control.
                Properties: create, query, edit
        enableKeyboardFocus (bool?): If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse.
                This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls.
                If disabled, text in text fields can still be selected with the mouse but cannot be copied (except on Linux when "Middle Click Paste" is enabled).
                Properties: create, query, edit
        exists (bool?): Returns whether the
                specified object exists or not. Other flags are ignored.
                Properties: create
        fullPathName (bool?): Return the full path name of the widget, which includes all the parents.
                Properties: query
        height (int?): The height of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit
        highlightColor (Tuple[float, float, float]?): The highlight color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                Properties: create, query, edit
        hsvValue (Tuple[float, float, float]?): Three float values corresponding to the hue, saturation, and
                value color components, where the hue value ranges from 0.0 to 360.0
                and the saturation and value components range from 0.0 to 1.0.
                Properties: create, query, edit
        isObscured (bool?): Return whether the control can actually be seen by the user.
                The control will be obscured if its state is invisible, if it is
                blocked (entirely or partially) by some other control, if it or a
                parent layout is unmanaged, or if the control's window is
                invisible or iconified.
                Properties: query
        manage (bool?): Manage state of the control.  An unmanaged control is
                not visible, nor does it take up any screen real estate.  All
                controls are created managed by default.
                Properties: create, query, edit
        noBackground (bool?): Clear/reset the control's background.
                Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.
                Properties: create, edit
        numberOfPopupMenus (bool?): Return the number of popup menus attached to this control.
                Properties: query
        parent (str?): The parent layout for this control.
                Properties: create, query
        popupMenuArray (bool?): Return the names of all the popup menus attached to this
                control.
                Properties: query
        pressCommand (Callable?): Command to be executed when there is a mouse press.
                Properties: create, edit
        preventOverride (bool?): If true, this flag prevents overriding the control's
                attribute via the control's right mouse button menu.
                Properties: create, query, edit
        rgbValue (Tuple[float, float, float]?): Three float values corresponding to the red, green, and blue
                color components, all of which range from 0.0 to 1.0.
                Properties: create, query, edit
        statusBarMessage (str?): Extra string to display in the status bar when the mouse is over the control.
                Properties: create, edit
        useTemplate (str?): Forces the command to use a command template other than
                the current one.
                Properties: create
        visible (bool?): The visible state of the control.  A control is created
                visible by default.  Note that a control's actual appearance is
                also dependent on the visible state of its parent layout(s).
                Properties: create, query, edit
        visibleChangeCommand (Callable?): Command that gets executed when visible state of the control changes.
                Properties: create, query, edit
        width (int?): The width of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit

    Returns:
        str: The full name of the canvas.

    Example:
    """

def changeSubdivComponentDisplayLevel(*args: Any, level: int = ..., relative: bool = ...) -> int:
    """Explicitly forces the subdivision surface to display components at a
    particular level of refinement.subdivision, surface, display, level, fine, coarse, level
    Args:
        level (int?): Specifies the display level of components.
                Properties: create, query
        relative (bool?): If set, level refers to the relative display level
                Properties: create, query

    Returns:
        int: Command result

    Example:
    """

def changeSubdivRegion(*args: Any, action: int = ..., level: int = ...) -> bool:
    """Changes a subdivision surface region based on the command parameters.
    The command operates on the selected subdivision surfaces.subdivision, surface, select, region
    Args:
        action (int?): Specifies the action to the selection region
                     1 = delete selection region
                     2 = enlarge selection region
                Properties: create
        level (int?): Specify the level of the subdivision surface to perform the operation
                Properties: create

    Returns:
        bool: Command result

    Example:
    """

def channelBox(arg0: str, /, annotation: str = ..., attrBgColor: Tuple[float, float, float] = ..., attrColor: Tuple[float, float, float] = ..., attrFilter: str = ..., attrRegex: str = ..., attributeEditorMode: bool = ..., backgroundColor: Tuple[float, float, float] = ..., containerAtTop: bool = ..., defineTemplate: str = ..., docTag: str = ..., dragCallback: Callable = ..., dropCallback: Callable = ..., enable: bool = ..., enableBackground: bool = ..., enableKeyboardFocus: bool = ..., enableLabelSelection: bool = ..., execute: Tuple[str, bool] = ..., exists: bool = ..., fieldWidth: int = ..., fixedAttrList: List[str] = ..., fullPathName: bool = ..., height: int = ..., highlightColor: Tuple[float, float, float] = ..., historyObjectList: bool = ..., hyperbolic: bool = ..., inputs: bool = ..., isObscured: bool = ..., labelWidth: int = ..., longNames: bool = ..., mainListConnection: str = ..., mainObjectList: bool = ..., manage: bool = ..., maxHeight: int = ..., maxWidth: int = ..., niceNames: bool = ..., noBackground: bool = ..., nodeRegex: str = ..., numberOfPopupMenus: bool = ..., outputObjectList: bool = ..., outputs: bool = ..., parent: str = ..., popupMenuArray: bool = ..., precision: int = ..., preventOverride: bool = ..., select: str = ..., selectedHistoryAttributes: bool = ..., selectedMainAttributes: bool = ..., selectedOutputAttributes: bool = ..., selectedShapeAttributes: bool = ..., shapeObjectList: bool = ..., shapes: bool = ..., showNamespace: bool = ..., showTransforms: bool = ..., speed: float = ..., statusBarMessage: str = ..., takeFocus: bool = ..., ufeFixedAttrList: Unknown = ..., update: bool = ..., useManips: str = ..., useTemplate: str = ..., visible: bool = ..., visibleChangeCommand: Callable = ..., width: int = ...) -> str:
    """This command creates a channel box, which is sensitive to the active
    list.  It displays certain attributes (channels) of the last node on
    the active list, and provides a two-way connection to keep the widget
    up to date.Note: when setting the color of attribute names, that color is only valid
    for its current Maya session; each subsequent session will display the default
    color for the attribute name(s) listed in the Channel Box. Any subsequent
    attributes that are added to the Channel Box will be affected by prior
    regular expressions in their current Maya session.
    Args:
        annotation (str?): Annotate the control with an extra string value.
                Properties: create, query, edit
        attrBgColor (Tuple[float, float, float]?): Controls the background text color of specific attribute names. As with the foreground
                option, this text coloring also depends on the node name choice for the nodeRegex flag.
                Arguments correspond to the red, green, and blue color components.
                Each component ranges in value from 0.0 to 1.0. If attrRegex is
                unspecified then it will assume a value of "*" for a regular expression.
                The same idea simultaneously applies to the flag nodeRegex.
                Note: nodes that are renamed will have their node name coloring be affected
                in the channel box.
                Properties: create, query, edit
        attrColor (Tuple[float, float, float]?): Controls the foreground text color of specific attribute names. This
                text coloring also depends on the node name choice for the nodeRegex flag.
                Arguments correspond to the red, green, and blue color components.
                Each component ranges in value from 0.0 to 1.0. If attrRegex is
                unspecified then it will assume a value of "*" for a regular expression.
                The same idea simultaneously applies to the flag nodeRegex.
                Note: nodes that are renamed will have their node name coloring be affected
                in the channel box.
                Properties: create, query, edit
        attrFilter (str?): Specifies the name of an itemFilter object to be placed on the channel box.
                This filters the attributes displayed. A filter of "0" can be used to reset the
                filter.
                Properties: query, edit
        attrRegex (str?): Specifies a valid regular expression to specify which attribute names
                should be selected for foreground text coloring. If attrRegex is
                unspecified then it will assume a value of "*" for a regular expression.
                The same idea simultaneously applies to the flag nodeRegex.
                The attrColor flag is required to be specified.
                Note: this regular expression will be treated as though it were case-insensitve
                Properties: create, query, edit
        attributeEditorMode (bool?): Modifies what appears in the channel box for use in the
                attribute editor. Default is false. Queried, returns a boolean.
                Properties: query, edit
        backgroundColor (Tuple[float, float, float]?): The background color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                When setting backgroundColor, the background is automatically
                enabled, unless enableBackground is also specified with a false
                value.
                Properties: create, query, edit
        containerAtTop (bool?): This flag can be used to specify whether or not the container is drawn at the
                top of the channel box when a node in the container is selected.
                Properties: query, edit
        defineTemplate (str?): Puts the command in a mode where any other flags and arguments are
                parsed and added to the command template specified in the argument.
                They will be used as default arguments in any subsequent
                invocations of the command when templateName is set as the
                current template.
                Properties: create
        docTag (str?): Add a documentation flag to the control.  The documentation flag
                has a directory structure.
                (e.g., -dt render/multiLister/createNode/material)
                Properties: create, query, edit
        dragCallback (Callable?): Adds a callback that is called when the middle mouse button
                is pressed.  The MEL version of the callback is of the form:

                global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods)

                The proc returns a string array that is transferred to the drop site.
                By convention the first string in the array describes the user settable
                message type.  Controls that are application defined drag sources may
                ignore the callback. $mods allows testing for the key modifiers CTRL and
                SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL,
                3 == CTRL + SHIFT.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def callbackName( dragControl, x, y, modifiers ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "x", "y", "modifiers".  The
                "dragControl" value is a string and the other values are integers (eg the
                callback string could be "print '%(dragControl)s %(x)d %(y)d %(modifiers)d'")
                Properties: create, edit
        dropCallback (Callable?): Adds a callback that is called when a drag and drop
                operation is released above the drop site.  The MEL version of the callback is
                of the form:

                global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type)

                The proc receives a string array that is transferred from the drag source.
                The first string in the msgs array describes the user defined message type.
                Controls that are application defined drop sites may ignore the
                callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "dropControl", "messages", "x", "y",
                "type".  The "dragControl" value is a string and the other values are integers
                (eg the callback string could be
                "print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'")
                Properties: create, edit
        enable (bool?): The enable state of the control.  By default, this flag is
                set to true and the control is enabled.  Specify false and the control
                will appear dimmed or greyed-out indicating it is disabled.
                Properties: create, query, edit
        enableBackground (bool?): Enables the background color of the control.
                Properties: create, query, edit
        enableKeyboardFocus (bool?): If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse.
                This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls.
                If disabled, text in text fields can still be selected with the mouse but cannot be copied (except on Linux when "Middle Click Paste" is enabled).
                Properties: create, query, edit
        enableLabelSelection (bool?): Enables the selection of attributes in the channelBox
                when used in conjunction with -attributeEditorMode.
                Default is false.  Queried, returns a boolean.
                Properties: query, edit
        execute (Tuple[str, bool]?): Immediately executes the command string once for every cell (or every
                selected cell, if the boolean argument is TRUE) in the
                channel box, for every matching selected object (ie, for every object would
                be affected if you changed a cell value.)  Before the command is executed,
                "#A" is substituted with the name of the attribute, and "#N" with the name
                of the node, and "#P" with the full path name of the node.
                Properties: edit
        exists (bool?): Returns whether the
                specified object exists or not. Other flags are ignored.
                Properties: create
        fieldWidth (int?): An optional flag which is used to modify the width assigned
                to fields appearing in the channelBox.
                Properties: query, edit
        fixedAttrList (List[str]?): Forces the channel box to only display attributes with the
                specified names, in the order they are specified.  If an empty
                list is specified, then the channel box will revert to its default
                behaviour of listing all keyable attributes.
                Properties: create, query, edit
        fullPathName (bool?): Return the full path name of the widget, which includes all the parents.
                Properties: query
        height (int?): The height of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit
        highlightColor (Tuple[float, float, float]?): The highlight color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                Properties: create, query, edit
        historyObjectList (bool?): Returns a list of strings, the names of every INPUT node associated with
                an object on the main object list that is of the same type as the node
                displayed in the INPUT section of the channel box.
                Properties: query
        hyperbolic (bool?): Determines whether or not the distance that the mouse has been dragged
                should be interpreted as a linear or hyperbolic function.  The default
                is set to hyperbolic being false.
                Properties: create, query, edit
        inputs (bool?): Returns the items shown under the 'INPUTS' heading in the channel box.
                Properties: query
        isObscured (bool?): Return whether the control can actually be seen by the user.
                The control will be obscured if its state is invisible, if it is
                blocked (entirely or partially) by some other control, if it or a
                parent layout is unmanaged, or if the control's window is
                invisible or iconified.
                Properties: query
        labelWidth (int?): An optional flag which is used to modify the width assigned
                to labels appearing in the channelBox.
                Properties: query, edit
        longNames (bool?): Controls whether long or short attribute names will be used
                in the interface.  Note that this flag is ignored if the -niceNames
                flag is set.  Default is short names. Queried, returns a boolean.
                Properties: query, edit
        mainListConnection (str?): Specifies the name of a selectionConnection object which the
                editor will use as its source of content.  The channel box will
                only display the (last) item contained in the selectionConnection object.
                If a NULL string ("") is specified, then the channel box will revert
                to its default behaviour of working on the active list.
                Properties: create, query, edit
        mainObjectList (bool?): Returns a list of strings, the names of every object on the active
                list that is the same type as the object displayed in the top (main)
                section of the channel box.
                Properties: query
        manage (bool?): Manage state of the control.  An unmanaged control is
                not visible, nor does it take up any screen real estate.  All
                controls are created managed by default.
                Properties: create, query, edit
        maxHeight (int?): An optional flag which is used to limit the height of the
                channelBox.
                Properties: query, edit
        maxWidth (int?): An optional flag which is used to limit the width of the
                channelBox.
                Properties: query, edit
        niceNames (bool?): Controls whether the attribute names will be displayed in
                a more user-friendly, readable way.  When this is on, the longNames
                flag is ignored.  When this is off, attribute names will be displayed
                either long or short, according to the longNames flag.
                Default is on. Queried, returns a boolean.
                Properties: query, edit
        noBackground (bool?): Clear/reset the control's background.
                Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.
                Properties: create, edit
        nodeRegex (str?): Specifies a valid regular expression to specify which node names should
                (potentially) have their attributes selected for foreground text coloring.
                If nodeRegex is unspecified then it will assume a value of "*' for a
                regular expression. The same idea simultaneously applies to the flag
                attrRegex. The attrColor flag is required to be specified.
                Note: this regular expression will be treated as though it were case-insensitve
                Note: nodes in namespaces have regular expressions applied as though those
                nodes weren't in namespaces
                Properties: create, query, edit
        numberOfPopupMenus (bool?): Return the number of popup menus attached to this control.
                Properties: query
        outputObjectList (bool?): Returns a list of strings, the names of every OUTPUT node associated
                an object on the main object list that is of the same type as the node
                displayed in the OUTPUT section of the channel box.
                Properties: query
        outputs (bool?): Returns the items shown under the 'OUTPUTS' heading in the channel box.
                Properties: query
        parent (str?): The parent layout for this control.
                Properties: create, query
        popupMenuArray (bool?): Return the names of all the popup menus attached to this
                control.
                Properties: query
        precision (int?): Controls the number of digits to the right of the decimal
                point that will be displayed for float-valued channels.
                Default is 3.  Queried, returns an int.
                Properties: query, edit
        preventOverride (bool?): If true, this flag prevents overriding the control's
                attribute via the control's right mouse button menu.
                Properties: create, query, edit
        select (str?): Allows programmatic selection of items (nodes or plugs) in the channel box.
                Selection is equivalent to clicking the item with the mouse; therefore
                only items currently shown in the channel box can be selected this way.
                Properties: edit, multiuse
        selectedHistoryAttributes (bool?): Returns a list of strings, the names of all the selected attributes
                in the INPUT section of the channel box.
                Properties: query
        selectedMainAttributes (bool?): Returns a list of strings, the names of all the selected attributes in the
                top section of the channel box.
                Properties: query
        selectedOutputAttributes (bool?): Returns a list of strings, the names of all the selected attributes
                in the OUTPUT section of the channel box.
                Properties: query
        selectedShapeAttributes (bool?): Returns a list of strings, the names of all the selected attributes
                in the middle (shape) section of the channel box.
                Properties: query
        shapeObjectList (bool?): Returns a list of strings, the names of every shape associated with
                an object on the main object list that is of the same type as the object
                displayed in the middle (shape) section of the channel box.
                Properties: query
        shapes (bool?): Returns the items shown under the 'SHAPES' heading in the channel box.
                Properties: query
        showNamespace (bool?): Controls whether or not the namespace of an object is displayed
                if the object is not in the root namespace.
                Properties: create, query, edit
        showTransforms (bool?): Controls whether this control will display transform attributes
                only, or all other attributes. False by default. Queried, returns a
                boolean.
                Properties: query, edit
        speed (float?): Controls the speed at which the attributes are changed based on the
                distance the mouse has been dragged.  Common settings for
                slow/medium/fast are 0.1/1.0/10.0 respectively.  The default is 1.0.
                Properties: create, query, edit
        statusBarMessage (str?): Extra string to display in the status bar when the mouse is over the control.
                Properties: create, edit
        takeFocus (bool?): causes the channel box to take over the keyboard focus, if it can.
                Properties: edit
        ufeFixedAttrList (Unknown?): Forces the channel box to only display attributes for the given
                UFE runtime with the specified names, in the order they are specified.
                The attribute list accepts wildcard ('?' for one char, '*' for many) and
                will use pattern matching for finding attributes to display.
                If an empty list is specified, then the channel box will display no
                attributes for the given UFE runtime (since there is no keyable
                attribute concept in UFE).
                      In query mode, this flag can accept a value.
                Properties: create, query, edit
        update (bool?): This flag can be used to force an update of the channel box display, for
                example after changing a display preference.
                Properties: edit
        useManips (str?): When you click on a field or label in the channel box, the
                tool switches to a manipulator that can change that value if you
                drag in the 3d view.  This flag controls the kind of manips.  Allowed
                values are "none" (self-explanatory), "invisible" (you won't see anything,
                but dragging in the window will adjust any of the selected attributes),
                and "standard" (the same as invisible, except for scale, rotate, and
                translate, which will be represented by their usual manips.)
                Properties: create, query, edit
        useTemplate (str?): Forces the command to use a command template other than
                the current one.
                Properties: create
        visible (bool?): The visible state of the control.  A control is created
                visible by default.  Note that a control's actual appearance is
                also dependent on the visible state of its parent layout(s).
                Properties: create, query, edit
        visibleChangeCommand (Callable?): Command that gets executed when visible state of the control changes.
                Properties: create, query, edit
        width (int?): The width of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit

    Returns:
        str: (the name of the new channel box)

    Example:
    """

def character(*args: str, addElement: str = ..., addOffsetObject: str = ..., anyMember: str = ..., characterPlug: bool = ..., clear: str = ..., empty: bool = ..., excludeDynamic: bool = ..., excludeRotate: bool = ..., excludeScale: bool = ..., excludeTranslate: bool = ..., excludeVisibility: bool = ..., flatten: str = ..., forceElement: str = ..., include: str = ..., intersection: str = ..., isIntersecting: str = ..., isMember: str = ..., library: bool = ..., memberIndex: Unknown = ..., name: str = ..., noWarnings: bool = ..., nodesOnly: bool = ..., offsetNode: bool = ..., remove: str = ..., removeOffsetObject: str = ..., root: str = ..., scheduler: bool = ..., split: str = ..., subtract: str = ..., text: str = ..., union: str = ..., userAlias: str = ...) -> str:
    """This command is used to manage the membership of a character.  Characters
    are a type of set that gathers together the attributes of a node or nodes
    that a user wishes to animate as a single entity.
    Args:
        addElement (str?): Adds the list of items to the given character.  If some of the
                items cannot be added to the character because they are in another
                character, the command will fail.  When another character is passed to
                to -addElement, is is added as a sub character.  When a node is
                passed in, it is expanded into its keyable attributes, which are
                then added to the character.
                Properties: edit
        addOffsetObject (str?): Indicates that the selected character member objects should be used when
                calculating and applying offsets. The flag argument is used to specify the
                character.
                Properties: query, edit
        anyMember (str?): An operation which tests whether any of the given items
                are members of the given set.
                Properties: create
        characterPlug (bool?): Returns the plug on the character that corresponds to the
                specified character member.
                Properties: query
        clear (str?): An operation which removes all items from the given character.
                Properties: edit
        empty (bool?): Indicates that the character to be created should be empty. (i.e.
                it ignores any arguments identifying objects to be added to
                the character.
                Properties: create
        excludeDynamic (bool?): When creating the character, exclude dynamic attributes.
                Properties: create
        excludeRotate (bool?): When creating the character, exclude rotate attributes from
                transform-type nodes.
                Properties: create
        excludeScale (bool?): When creating the character, exclude scale attributes from
                transform-type nodes.
                Properties: create
        excludeTranslate (bool?): When creating the character, exclude translate attributes from
                transform-type nodes. For example, if your character contains
                joints only, perhaps you only want to include rotations in the
                character.
                Properties: create
        excludeVisibility (bool?): When creating the character, exclude visibility attribute from
                transform-type nodes.
                Properties: create
        flatten (str?): An operation that flattens the structure of the given character. That is,
                any characters contained by the given character will be replaced by its
                members so that the character no longer contains other characters but contains
                the other characters' members.
                Properties: edit
        forceElement (str?): For use in edit mode only. Forces addition of the items
                to the character. If the items are in another character which
                is in the character partition, the items will be removed
                from the other character in order to keep the characters in the
                character partition mutually exclusive with respect to membership.
                Properties: edit
        include (str?): Adds the list of items to the given character.  If some of the
                items cannot be added to the character, a warning will be issued.
                This is a less strict version of the -add/addElement operation.
                Properties: edit
        intersection (str?): An operation that returns a list of items which are members of
                all the character in the list.  In general, characters should be
                mutually exclusive.
                Properties: query
        isIntersecting (str?): An operation which tests whether or not the characters in the list have
                common members.  In general, characters should be mutually exclusive, so
                this should always return false.
                Properties: query
        isMember (str?): An operation which tests whether or not all the given items
                are members of the given character.
                Properties: query
        library (bool?): Returns the clip library associated with this character, if there is one. A clip library will only exist if you have created clips on your character.
                Properties: query
        memberIndex (Unknown?): Returns the memberIndex of the specified character member if used after the query flag. Or if used before the query flag, returns the member that corresponds to the specified index.
                Properties: query
        name (str?): Assigns string as the name for a new character. Valid for operations that
                create a new character.
                Properties: create
        noWarnings (bool?): Indicates that warning messages should not be reported such
                as when trying to add an invalid item to a character. (used by UI)
                Properties: create
        nodesOnly (bool?): This flag modifies the results of character membership queries.
                When listing the attributes (e.g. sphere1.tx) contained in the
                character, list only the nodes.  Each node will only be listed
                once, even if more than one attribute or component of the node
                exists in the character.
                Properties: query
        offsetNode (bool?): Returns the name of the characterOffset node used to add offsets to the root of the character.
                Properties: query
        remove (str?): Removes the list of items from the given character.
                Properties: edit
        removeOffsetObject (str?): Indicates that the selected character offset objects should be removed
                as offsets. The flag argument is used to specify the character.
                Properties: edit
        root (str?): Specifies the transform node which will act as the root of the character being created.
                This creates a characterOffset node in addition to the character node, which can be used to add offsets
                to the character to change the direction of the character's animtion without inserting additional nodes
                in its hierarchy.
                Properties: create
        scheduler (bool?): Returns the scheduler associated with this character, if there is one. A scheduler will only exist if you have created clips on your character.
                Properties: query
        split (str?): Produces a new set with the list of items and removes
                each item in the list of items from the given set.
                Properties: create
        subtract (str?): An operation between two characters which returns the members of the
                first character that are not in the second character. In general,
                characters should be mutually exclusive.
                Properties: query
        text (str?): Defines an annotation string to be stored with the character.
                Properties: create, query, edit
        union (str?): An operation that returns a list of all the members of all characters
                listed.
                Properties: query
        userAlias (str?): Returns the user defined alias for the given attribute on
                the character or and empty string if there is not one.  Characters
                automatically alias the attributes where character animation data
                is stored.  A user alias will exist when the automatic aliases are
                overridden using the aliasAttr command.
                Properties: query

    Returns:
        str: For creation operations (name of the character that was created or edited)

    Example:
    """

def characterMap(*args: str, mapAttr: Tuple[str, str] = ..., mapMethod: str = ..., mapNode: Tuple[str, str] = ..., mapping: str = ..., proposedMapping: bool = ..., unmapAttr: Tuple[str, str] = ..., unmapNode: Tuple[str, str] = ...) -> str:
    """This command is used to create a correlation between the attributes of 2 or more characters.character, clip, animation
    Args:
        mapAttr (Tuple[str, str]?): In query mode, this flag can be used to query the mapping stored by the specified map node. It returns an array of strings.
                In non-query mode, this flag can be used to create a mapping between the specified character members. Any previous mapping on the attributes is removed in favor of the newly specified mapping.
                Properties: create, query, edit
        mapMethod (str?): This is is valid in create mode only. It specifies how the mapping should be done. Valid options are: "byNodeName", "byAttrName", and "byAttrOrder". "byAttrOrder" is the default. The flags mean the following: "byAttrOrder" maps using the order that the character stores the attributes internally, "byAttrName" uses the attribute name to find a correspondence, "byNodeName" uses the node name *and* the attribute name to find a correspondence.
                Properties: create
        mapNode (Tuple[str, str]?): This flag can be used to map all the attributes on the source node to their matching attributes on the destination node.
                Properties: create, query
        mapping (str?): This flag is valid in query mode only. It must be used before the query flag with a string argument. It is used for querying the mapping for a particular attribute.  A string array is returned.
                Properties: query
        proposedMapping (bool?): This flag is valid in query mode only. It is used to get an array of the mapping that the character map would prvide if called with the specified characters and the (optional) specified mappingMethod. If a character map exists on the characters, the map is not affected by the query operation.  A string array is returned.
                Properties: query
        unmapAttr (Tuple[str, str]?): This flag can be used to unmap the mapping stored by the specified map node.
                Properties: create, edit
        unmapNode (Tuple[str, str]?): This flag can be used to unmap all the attributes on the source node to their matching attributes on the destination node. Note that mapped attributes which do not have matching names, will not be unmapped.
                Properties: create

    Returns:
        str: characterMap name

    Example:
    """

def characterize(*args: str, activatePivot: bool = ..., addAuxEffector: bool = ..., addFloorContactPlane: bool = ..., addMissingEffectors: bool = ..., attributeFromHIKProperty: str = ..., attributeFromHIKPropertyMode: str = ..., autoActivateBodyPart: bool = ..., changePivotPlacement: bool = ..., effectors: str = ..., fkSkeleton: str = ..., name: str = ..., pinHandFeet: bool = ..., placeNewPivot: bool = ..., posture: str = ..., sourceSkeleton: str = ..., stancePose: str = ..., type: str = ...) -> str:
    """This command is used to scan a joint hierarchy for predefined joint names or
    labels. If the required joints are found, human IK effectors will be created
    to control the skeleton using full-body IK.
    Alternatively, you can manually create all of the components
    required for fullbody IK, and use this command to hook them up.
    Fullbody IK needs 3 major components: the
    user input skeleton (sk), the fk skeleton on which keys are set (fk) and the
    hik effectors (ik).  Together fk and ik provide parameters to the fullbody IK
    engine, which solves for the output and plots it onto sk. This command usage
    is used internally by Maya when importing data from fbx files, but is not generally recommended.Note that a minimum set of required joint names or joint labels  must be
    found in order for the characterize command to succeed. Please refer to the
    Maya documentation for details on properly naming or labeling your skeleton.
    The skeleton should also be z-facing, with its y-axis up, its
    left hand parallel to positive x-axis and right hand parallel to
    negative x-axis.
    END_COMMENTcharacterize, effectors, fullbody, IK
    Args:
        activatePivot (bool?): Activates a pivot that has been properly placed.  After activating this new
                pivot, you will now be able to rotate and translate about this pivot.
                A pivot behaves in all ways the same as an effector (it IS an
                effector, except that it is offset from the normal position of the effector
                to allow one to rotate about a different point.
                Properties: edit
        addAuxEffector (bool?): Adds an auxilliary (secondary) effector to an existing effector.
                Properties: edit
        addFloorContactPlane (bool?): Adds a floor contact plane to one of the hands or feet.  With this plane,
                you will be able to adjust the floor contact height.  Select a hand or foot
                effector and then issue the characterize command with this flag.
                Properties: edit
        addMissingEffectors (bool?): This flag tells the
                characterize command to look for any effectors that can be added to the
                skeleton. For example, if the user has deleted some effectors or added fingers
                to an existing skeleton, "characterize -e -addMissingEffectors" can be used to
                restore them.
                Properties: edit
        attributeFromHIKProperty (str?): Query for the attribute name associated with a MotionBuilder property.
                Properties: query
        attributeFromHIKPropertyMode (str?): Query for the attribute name associated with a MotionBuilder property mode.
                Properties: query
        autoActivateBodyPart (bool?): Query or change whether auto activation of character nodes representing body parts
                should be enabled.
                Properties: query, edit
        changePivotPlacement (bool?): Reverts a pivot back into pivot placement mode.  A pivot that is in placement
                mode will not participate in full body manipulation until it has been activated
                with the -activatePivot flag.
                Properties: edit
        effectors (str?): Specify the effectors to be used by human IK by providing
                2 pieces of information for each effector:  1) the partial path of the
                effector and 2) the name of the full body effector this represents.  1) and
                2) are to be separated by white space, and multiple entries separated by ",".
                Normally, the effectors are automatically created.  This flag is
                for advanced users only.
                Properties: create
        fkSkeleton (str?): Specify the fk skeleton to be used by human IK by providing 2 pieces of
                information for each joint of the FK skeleton:  1) the partial path of the
                joint and 2) the name of the full body joint this represents.  1) and 2) are
                to be separated by white space, and multiple entries separated by ",".
                Normally, the fk control skeleton is automatically created.  This
                flag is for advanced users only.
                Properties: create, edit
        name (str?): At characterization (FBIK creation) time, use this flag to name your FBIK character.
                This will affect the name of the hikHandle node and the control rig will be put
                into a namespace that matches the name of your character.  If you do not specify
                the character name, a default one will be used.
                At the moment edit and query of the character name is not supported.
                Properties: create
        pinHandFeet (bool?): When the character is first being characterized, pin the hands and feet by default.
                Properties: create
        placeNewPivot (bool?): Creates a new pivot and puts it into placement mode.  Note that you will
                not be able to do full body manipulation about this pivot until you have
                activated it with the -activatePivot flag. A pivot behaves in all ways the
                same as an effector (it IS an effector, except that it is offset from the
                normal position of the effector to allow one to rotate about a different
                point). A new pivot created with this flag allow you to adjust the offset
                interactively before activating it.
                Properties: edit
        posture (str?): Specifies the posture of the character. Valid options are "biped" and
                "quadruped". The default is "biped".
                Properties: create
        sourceSkeleton (str?): This flag can be used to characterize a skeleton that has not been named or
                labelled according to the FBIK guidelines. It specifies the association
                between the actual joint names and the expected FBIK joint names. The format
                of the string is as follows: For each
                joint that the user wants to involve in the solve:  1) the partial path of
                the joint and 2) the name of the full body joint this represents.  1) and 2)
                are to be separated by white space, and multiple entries separated by ",".
                Properties: create, edit
        stancePose (str?): Specify the default stance pose to be used by human IK.  The stance pose is
                specified by providing 2 pieces of information for each joint involved in
                the solve:
                1) the partial path to the joint and 2) 9 numbers representing translation
                rotation and scale.
                1) and 2) are to be separated by white space, and multiple entries separated
                by ",".
                Normally, the stance pose is taken from the selected skeleton.  This flag is
                for advanced users only.
                Properties: create, query
        type (str?): Specifies the technique used by the characterization to identify the joint
                type. Valid options are "label" and "name". When "label" is used, the joints
                must be labelled using the guidelines described in the Maya documentation.
                When name is used, the joint names must follow the naming conventions
                described in the Maya documentation. The default is "name". This flag
                cannot be used in conjunction with the sourceSkeleton flag.
                Properties: create

    Returns:
        str: Names of full body IK effectors that were created.

    Example:
    """

def checkBox(arg0: str, /, align: str = ..., annotation: str = ..., backgroundColor: Tuple[float, float, float] = ..., changeCommand: Callable = ..., defineTemplate: str = ..., docTag: str = ..., dragCallback: Callable = ..., dropCallback: Callable = ..., editable: bool = ..., enable: bool = ..., enableBackground: bool = ..., enableKeyboardFocus: bool = ..., exists: bool = ..., fullPathName: bool = ..., height: int = ..., highlightColor: Tuple[float, float, float] = ..., isObscured: bool = ..., label: str = ..., manage: bool = ..., noBackground: bool = ..., numberOfPopupMenus: bool = ..., offCommand: Callable = ..., onCommand: Callable = ..., parent: str = ..., popupMenuArray: bool = ..., preventOverride: bool = ..., recomputeSize: bool = ..., statusBarMessage: str = ..., useTemplate: str = ..., value: bool = ..., visible: bool = ..., visibleChangeCommand: Callable = ..., width: int = ...) -> str:
    """This command creates a check box.  A check box is a simple control
    containing a text label and a state of either on or off.  Commands
    can be attached to any or all of the following events:  when the
    check box is turned on, turned off, or simply when it's state is
    changed.
    Args:
        align (str?): This flag is obsolete and should no longer be used.
                The check box label will always be left-aligned.
                Properties: create, query, edit
        annotation (str?): Annotate the control with an extra string value.
                Properties: create, query, edit
        backgroundColor (Tuple[float, float, float]?): The background color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                When setting backgroundColor, the background is automatically
                enabled, unless enableBackground is also specified with a false
                value.
                Properties: create, query, edit
        changeCommand (Callable?): Command executed when the check box's state is changed.
                Note that this flag should not be used in conjunction with
                onCommand and offCommand. That is, one should either use
                changeCommand and test the state of the check box from inside
                the callback, or use onCommand and offCommand as separate
                callbacks.
                Properties: create, query, edit
        defineTemplate (str?): Puts the command in a mode where any other flags and arguments are
                parsed and added to the command template specified in the argument.
                They will be used as default arguments in any subsequent
                invocations of the command when templateName is set as the
                current template.
                Properties: create
        docTag (str?): Add a documentation flag to the control.  The documentation flag
                has a directory structure.
                (e.g., -dt render/multiLister/createNode/material)
                Properties: create, query, edit
        dragCallback (Callable?): Adds a callback that is called when the middle mouse button
                is pressed.  The MEL version of the callback is of the form:

                global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods)

                The proc returns a string array that is transferred to the drop site.
                By convention the first string in the array describes the user settable
                message type.  Controls that are application defined drag sources may
                ignore the callback. $mods allows testing for the key modifiers CTRL and
                SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL,
                3 == CTRL + SHIFT.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def callbackName( dragControl, x, y, modifiers ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "x", "y", "modifiers".  The
                "dragControl" value is a string and the other values are integers (eg the
                callback string could be "print '%(dragControl)s %(x)d %(y)d %(modifiers)d'")
                Properties: create, edit
        dropCallback (Callable?): Adds a callback that is called when a drag and drop
                operation is released above the drop site.  The MEL version of the callback is
                of the form:

                global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type)

                The proc receives a string array that is transferred from the drag source.
                The first string in the msgs array describes the user defined message type.
                Controls that are application defined drop sites may ignore the
                callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "dropControl", "messages", "x", "y",
                "type".  The "dragControl" value is a string and the other values are integers
                (eg the callback string could be
                "print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'")
                Properties: create, edit
        editable (bool?): The edit state of the check box.  By default, this flag is
                set to true and the check box value may be changed by clicking on
                it.  If false then the check box is 'read only' and can not be
                clicked on. The value of the check box can always be changed with
                the -v/value flag regardless of the state of
                the -ed/editable flag.
                Properties: create, query, edit
        enable (bool?): The enable state of the control.  By default, this flag is
                set to true and the control is enabled.  Specify false and the control
                will appear dimmed or greyed-out indicating it is disabled.
                Properties: create, query, edit
        enableBackground (bool?): Enables the background color of the control.
                Properties: create, query, edit
        enableKeyboardFocus (bool?): If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse.
                This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls.
                If disabled, text in text fields can still be selected with the mouse but cannot be copied (except on Linux when "Middle Click Paste" is enabled).
                Properties: create, query, edit
        exists (bool?): Returns whether the
                specified object exists or not. Other flags are ignored.
                Properties: create
        fullPathName (bool?): Return the full path name of the widget, which includes all the parents.
                Properties: query
        height (int?): The height of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit
        highlightColor (Tuple[float, float, float]?): The highlight color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                Properties: create, query, edit
        isObscured (bool?): Return whether the control can actually be seen by the user.
                The control will be obscured if its state is invisible, if it is
                blocked (entirely or partially) by some other control, if it or a
                parent layout is unmanaged, or if the control's window is
                invisible or iconified.
                Properties: query
        label (str?): The label text. The default label is the name of
                the control.
                Properties: create, query, edit
        manage (bool?): Manage state of the control.  An unmanaged control is
                not visible, nor does it take up any screen real estate.  All
                controls are created managed by default.
                Properties: create, query, edit
        noBackground (bool?): Clear/reset the control's background.
                Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.
                Properties: create, edit
        numberOfPopupMenus (bool?): Return the number of popup menus attached to this control.
                Properties: query
        offCommand (Callable?): Command executed when the check box is turned off.
                Properties: create, query, edit
        onCommand (Callable?): Command executed when the check box is turned on.
                Properties: create, query, edit
        parent (str?): The parent layout for this control.
                Properties: create, query
        popupMenuArray (bool?): Return the names of all the popup menus attached to this
                control.
                Properties: query
        preventOverride (bool?): If true, this flag prevents overriding the control's
                attribute via the control's right mouse button menu.
                Properties: create, query, edit
        recomputeSize (bool?): If true then the control will recompute it's size to
                just fit the size of the label.  If false then the control size
                will remain fixed as you change the size of the label.  The
                default value of this flag is true.
                Properties: create, query, edit
        statusBarMessage (str?): Extra string to display in the status bar when the mouse is over the control.
                Properties: create, edit
        useTemplate (str?): Forces the command to use a command template other than
                the current one.
                Properties: create
        value (bool?): State of the check box.
                Properties: create, query, edit
        visible (bool?): The visible state of the control.  A control is created
                visible by default.  Note that a control's actual appearance is
                also dependent on the visible state of its parent layout(s).
                Properties: create, query, edit
        visibleChangeCommand (Callable?): Command that gets executed when visible state of the control changes.
                Properties: create, query, edit
        width (int?): The width of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit

    Returns:
        str: Full path name to the control.

    Example:
    """

def checkBoxGrp(arg0: str, /, adjustableColumn: int = ..., adjustableColumn2: int = ..., adjustableColumn3: int = ..., adjustableColumn4: int = ..., adjustableColumn5: int = ..., adjustableColumn6: int = ..., annotation: str = ..., backgroundColor: Tuple[float, float, float] = ..., changeCommand: Callable = ..., changeCommand1: Callable = ..., changeCommand2: Callable = ..., changeCommand3: Callable = ..., changeCommand4: Callable = ..., columnAlign: Tuple[int, str] = ..., columnAlign2: Tuple[str, str] = ..., columnAlign3: Tuple[str, str, str] = ..., columnAlign4: Tuple[str, str, str, str] = ..., columnAlign5: Tuple[str, str, str, str, str] = ..., columnAlign6: Tuple[str, str, str, str, str, str] = ..., columnAttach: Tuple[int, str, int] = ..., columnAttach2: Tuple[str, str] = ..., columnAttach3: Tuple[str, str, str] = ..., columnAttach4: Tuple[str, str, str, str] = ..., columnAttach5: Tuple[str, str, str, str, str] = ..., columnAttach6: Tuple[str, str, str, str, str, str] = ..., columnOffset2: Tuple[int, int] = ..., columnOffset3: Tuple[int, int, int] = ..., columnOffset4: Tuple[int, int, int, int] = ..., columnOffset5: Tuple[int, int, int, int, int] = ..., columnOffset6: Tuple[int, int, int, int, int, int] = ..., columnWidth: Tuple[int, int] = ..., columnWidth1: int = ..., columnWidth2: Tuple[int, int] = ..., columnWidth3: Tuple[int, int, int] = ..., columnWidth4: Tuple[int, int, int, int] = ..., columnWidth5: Tuple[int, int, int, int, int] = ..., columnWidth6: Tuple[int, int, int, int, int, int] = ..., defineTemplate: str = ..., docTag: str = ..., dragCallback: Callable = ..., dropCallback: Callable = ..., editable: bool = ..., enable: bool = ..., enable1: bool = ..., enable2: bool = ..., enable3: bool = ..., enable4: bool = ..., enableBackground: bool = ..., enableKeyboardFocus: bool = ..., exists: bool = ..., fullPathName: bool = ..., height: int = ..., highlightColor: Tuple[float, float, float] = ..., isObscured: bool = ..., label: str = ..., label1: str = ..., label2: str = ..., label3: str = ..., label4: str = ..., labelArray2: Tuple[str, str] = ..., labelArray3: Tuple[str, str, str] = ..., labelArray4: Tuple[str, str, str, str] = ..., manage: bool = ..., noBackground: bool = ..., numberOfCheckBoxes: int = ..., numberOfPopupMenus: bool = ..., offCommand: Callable = ..., offCommand1: Callable = ..., offCommand2: Callable = ..., offCommand3: Callable = ..., offCommand4: Callable = ..., onCommand: Callable = ..., onCommand1: Callable = ..., onCommand2: Callable = ..., onCommand3: Callable = ..., onCommand4: Callable = ..., parent: str = ..., popupMenuArray: bool = ..., preventOverride: bool = ..., rowAttach: Tuple[int, str, int] = ..., statusBarMessage: str = ..., useTemplate: str = ..., value1: bool = ..., value2: bool = ..., value3: bool = ..., value4: bool = ..., valueArray2: Tuple[bool, bool] = ..., valueArray3: Tuple[bool, bool, bool] = ..., valueArray4: Tuple[bool, bool, bool, bool] = ..., vertical: bool = ..., visible: bool = ..., visibleChangeCommand: Callable = ..., width: int = ...) -> str:
    """All of the group commands position their individual controls in columns
    starting at column 1.  The layout of each control (ie. column) can be
    customized using the, andflags.  By default, columns are left aligned
    with no offset and are 100 pixels wide.  Only one column in any group can
    be adjustable.This command creates from one to four check boxes in a single row.
    They can have an optional text label.TelfBaseGrpCmd.cpp
    Args:
        adjustableColumn (int?): Specifies which column has an adjustable size that changes with the
                sizing of the layout.  The column value is a 1. based index.
                Passing 0 as argument turns off the previous adjustable column.
                Properties: create, edit
        adjustableColumn2 (int?): Specifies which column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                two columns.
                Properties: create, edit
        adjustableColumn3 (int?): Specifies that the column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                three columns.
                Properties: create, edit
        adjustableColumn4 (int?): Specifies which column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                four columns.
                Properties: create, edit
        adjustableColumn5 (int?): Specifies which column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                five columns.
                Properties: create, edit
        adjustableColumn6 (int?): Specifies which column has an adjustable size that changes with
                the size of the parent layout. Ignored if there are not exactly
                six columns.
                Properties: create, edit
        annotation (str?): Annotate the control with an extra string value.
                Properties: create, query, edit
        backgroundColor (Tuple[float, float, float]?): The background color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                When setting backgroundColor, the background is automatically
                enabled, unless enableBackground is also specified with a false
                value.
                Properties: create, query, edit
        changeCommand (Callable?): Command executed when the group changes state.
                Note that this flag should not be used in conjunction with
                onCommand and offCommand. That is, one should either use
                changeCommand and test the state of a check box from inside
                the callback, or use onCommand and offCommand as separate
                callbacks.
                Properties: create, edit
        changeCommand1 (Callable?):
                Properties: create, edit
        changeCommand2 (Callable?):
                Properties: create, edit
        changeCommand3 (Callable?):
                Properties: create, edit
        changeCommand4 (Callable?): Specify a changed state command for each respective check
                box.
                Properties: create, edit
        columnAlign (Tuple[int, str]?): Arguments are : column number, alignment type.
                Possible alignments are: left | right | center.
                Specifies alignment type for the specified column.
                Properties: create, edit, multiuse
        columnAlign2 (Tuple[str, str]?): Sets the text alignment of both columns.  Ignored if there are not
                exactly two columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAlign3 (Tuple[str, str, str]?): Sets the text alignment for all three columns.  Ignored if there are not
                exactly three columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAlign4 (Tuple[str, str, str, str]?): Sets the text alignment for all four columns.  Ignored if there are not
                exactly four columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAlign5 (Tuple[str, str, str, str, str]?): Sets the text alignment for all five columns.  Ignored if there are not
                exactly five columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAlign6 (Tuple[str, str, str, str, str, str]?): Sets the text alignment for all six columns.  Ignored if there are not
                exactly six columns. Valid values are "left", "right", and "center".
                Properties: create, edit
        columnAttach (Tuple[int, str, int]?): Arguments are : column number, attachment type, and offset.
                Possible attachments are: left | right | both.
                Specifies column attachment types and offets.
                Properties: create, edit, multiuse
        columnAttach2 (Tuple[str, str]?): Sets the attachment type of both columns. Ignored if there are not
                exactly two columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnAttach3 (Tuple[str, str, str]?): Sets the attachment type for all three columns. Ignored if there are not
                exactly three columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnAttach4 (Tuple[str, str, str, str]?): Sets the attachment type for all four columns. Ignored if there are not
                exactly four columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnAttach5 (Tuple[str, str, str, str, str]?): Sets the attachment type for all five columns. Ignored if there are not
                exactly five columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnAttach6 (Tuple[str, str, str, str, str, str]?): Sets the attachment type for all six columns. Ignored if there are not
                exactly six columns. Valid values are "left", "right", and "both".
                Properties: create, edit
        columnOffset2 (Tuple[int, int]?): This flag is used in conjunction with the -columnAttach2 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the two columns.  The offsets applied are based on the attachments
                specified with the -columnAttach2 flag.  Ignored if there are not exactly
                two columns.
                Properties: create, edit
        columnOffset3 (Tuple[int, int, int]?): This flag is used in conjunction with the -columnAttach3 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the three columns.  The offsets applied are based on the attachments
                specified with the -columnAttach3 flag.  Ignored if there are not exactly
                three columns.
                Properties: create, edit
        columnOffset4 (Tuple[int, int, int, int]?): This flag is used in conjunction with the -columnAttach4 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the four columns.  The offsets applied are based on the attachments
                specified with the -columnAttach4 flag.  Ignored if there are not exactly
                four columns.
                Properties: create, edit
        columnOffset5 (Tuple[int, int, int, int, int]?): This flag is used in conjunction with the -columnAttach5 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the five columns.  The offsets applied are based on the attachments
                specified with the -columnAttach5 flag.  Ignored if there are not exactly
                five columns.
                Properties: create, edit
        columnOffset6 (Tuple[int, int, int, int, int, int]?): This flag is used in conjunction with the -columnAttach6 flag.  If that
                flag is not used then this flag will be ignored.  It sets the offset for
                the six columns.  The offsets applied are based on the attachments
                specified with the -columnAttach6 flag.  Ignored if there are not exactly
                six columns.
                Properties: create, edit
        columnWidth (Tuple[int, int]?): Arguments are : column number, column width.
                Sets the width of the specified column where the first parameter specifies
                the column (1 based index) and the second parameter specifies the width.
                Properties: create, edit, multiuse
        columnWidth1 (int?): Sets the width of the first column. Ignored if there is not
                exactly one column.
                Properties: create, edit
        columnWidth2 (Tuple[int, int]?): Sets the column widths of both columns. Ignored if there are not
                exactly two columns.
                Properties: create, edit
        columnWidth3 (Tuple[int, int, int]?): Sets the column widths for all 3 columns. Ignored if there are not
                exactly 3 columns.
                Properties: create, edit
        columnWidth4 (Tuple[int, int, int, int]?): Sets the column widths for all 4 columns. Ignored if there are not
                exactly 4 columns.
                Properties: create, edit
        columnWidth5 (Tuple[int, int, int, int, int]?): Sets the column widths for all 5 columns. Ignored if there are not
                exactly 5 columns.
                Properties: create, edit
        columnWidth6 (Tuple[int, int, int, int, int, int]?): Sets the column widths for all 6 columns. Ignored if there are not
                exactly 6 columns.
                Properties: create, edit
        defineTemplate (str?): Puts the command in a mode where any other flags and arguments are
                parsed and added to the command template specified in the argument.
                They will be used as default arguments in any subsequent
                invocations of the command when templateName is set as the
                current template.
                Properties: create
        docTag (str?): Add a documentation flag to the control.  The documentation flag
                has a directory structure.
                (e.g., -dt render/multiLister/createNode/material)
                Properties: create, query, edit
        dragCallback (Callable?): Adds a callback that is called when the middle mouse button
                is pressed.  The MEL version of the callback is of the form:

                global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods)

                The proc returns a string array that is transferred to the drop site.
                By convention the first string in the array describes the user settable
                message type.  Controls that are application defined drag sources may
                ignore the callback. $mods allows testing for the key modifiers CTRL and
                SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL,
                3 == CTRL + SHIFT.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def callbackName( dragControl, x, y, modifiers ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "x", "y", "modifiers".  The
                "dragControl" value is a string and the other values are integers (eg the
                callback string could be "print '%(dragControl)s %(x)d %(y)d %(modifiers)d'")
                Properties: create, edit
        dropCallback (Callable?): Adds a callback that is called when a drag and drop
                operation is released above the drop site.  The MEL version of the callback is
                of the form:

                global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type)

                The proc receives a string array that is transferred from the drag source.
                The first string in the msgs array describes the user defined message type.
                Controls that are application defined drop sites may ignore the
                callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "dropControl", "messages", "x", "y",
                "type".  The "dragControl" value is a string and the other values are integers
                (eg the callback string could be
                "print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'")
                Properties: create, edit
        editable (bool?): The edit state of the group.  By default, this flag
                is set to true and the check box values may be changed by
                clicking on them.  If false then the check boxes are 'read only'
                and can not be clicked on. The value of the check boxes can
                always be changed with the -v/value flags regardless of
                the state of the -ed/editable flag.
                Properties: create, query, edit
        enable (bool?): The enable state of the control.  By default, this flag is
                set to true and the control is enabled.  Specify false and the control
                will appear dimmed or greyed-out indicating it is disabled.
                Properties: create, query, edit
        enable1 (bool?):
                Properties: create, query, edit
        enable2 (bool?):
                Properties: create, query, edit
        enable3 (bool?):
                Properties: create, query, edit
        enable4 (bool?): Enable state of the individual check boxes.
                Properties: create, query, edit
        enableBackground (bool?): Enables the background color of the control.
                Properties: create, query, edit
        enableKeyboardFocus (bool?): If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse.
                This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls.
                If disabled, text in text fields can still be selected with the mouse but cannot be copied (except on Linux when "Middle Click Paste" is enabled).
                Properties: create, query, edit
        exists (bool?): Returns whether the
                specified object exists or not. Other flags are ignored.
                Properties: create
        fullPathName (bool?): Return the full path name of the widget, which includes all the parents.
                Properties: query
        height (int?): The height of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit
        highlightColor (Tuple[float, float, float]?): The highlight color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                Properties: create, query, edit
        isObscured (bool?): Return whether the control can actually be seen by the user.
                The control will be obscured if its state is invisible, if it is
                blocked (entirely or partially) by some other control, if it or a
                parent layout is unmanaged, or if the control's window is
                invisible or iconified.
                Properties: query
        label (str?): When present on creation an optional text label will be
                built with the group.  The string specifes the label text.
                Properties: create, query, edit
        label1 (str?):
                Properties: create, query, edit
        label2 (str?):
                Properties: create, query, edit
        label3 (str?):
                Properties: create, query, edit
        label4 (str?): Specify label strings for the respective check boxes in
                the group.
                Properties: create, query, edit
        labelArray2 (Tuple[str, str]?):
                Properties: create, query, edit
        labelArray3 (Tuple[str, str, str]?):
                Properties: create, query, edit
        labelArray4 (Tuple[str, str, str, str]?): Specify multiple labels in a single flag.  These flags
                are ignored if the number of radio buttons doesn't match.
                Properties: create, query, edit
        manage (bool?): Manage state of the control.  An unmanaged control is
                not visible, nor does it take up any screen real estate.  All
                controls are created managed by default.
                Properties: create, query, edit
        noBackground (bool?): Clear/reset the control's background.
                Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.
                Properties: create, edit
        numberOfCheckBoxes (int?): Number of check boxes in the group (1. 4).
                Properties: create
        numberOfPopupMenus (bool?): Return the number of popup menus attached to this control.
                Properties: query
        offCommand (Callable?): Command executed when any check box turns off.
                Properties: create, edit
        offCommand1 (Callable?):
                Properties: create, edit
        offCommand2 (Callable?):
                Properties: create, edit
        offCommand3 (Callable?):
                Properties: create, edit
        offCommand4 (Callable?): Off command for each respective check box.
                Properties: create, edit
        onCommand (Callable?): Command executed when any check box turns on.
                Properties: create, edit
        onCommand1 (Callable?):
                Properties: create, edit
        onCommand2 (Callable?):
                Properties: create, edit
        onCommand3 (Callable?):
                Properties: create, edit
        onCommand4 (Callable?): On command for each respective check box.
                Properties: create, edit
        parent (str?): The parent layout for this control.
                Properties: create, query
        popupMenuArray (bool?): Return the names of all the popup menus attached to this
                control.
                Properties: query
        preventOverride (bool?): If true, this flag prevents overriding the control's
                attribute via the control's right mouse button menu.
                Properties: create, query, edit
        rowAttach (Tuple[int, str, int]?): Arguments are : column, attachment type, offset.
                Possible attachments are: top | bottom | both.
                Specifies attachment types and offsets for the entire row.
                Properties: create, edit, multiuse
        statusBarMessage (str?): Extra string to display in the status bar when the mouse is over the control.
                Properties: create, edit
        useTemplate (str?): Forces the command to use a command template other than
                the current one.
                Properties: create
        value1 (bool?):
                Properties: create, query, edit
        value2 (bool?):
                Properties: create, query, edit
        value3 (bool?):
                Properties: create, query, edit
        value4 (bool?): Values for the respective check boxes in the group.
                Properties: create, query, edit
        valueArray2 (Tuple[bool, bool]?):
                Properties: create, query, edit
        valueArray3 (Tuple[bool, bool, bool]?):
                Properties: create, query, edit
        valueArray4 (Tuple[bool, bool, bool, bool]?): Specifies multiple values in a single flag.  These flags
                are ignored if the number of check boxes doesn't match.
                Properties: create, query, edit
        vertical (bool?): Whether the orientation of the checkbox controls in this group
                are horizontal (default) or vertical.
                Properties: create, query
        visible (bool?): The visible state of the control.  A control is created
                visible by default.  Note that a control's actual appearance is
                also dependent on the visible state of its parent layout(s).
                Properties: create, query, edit
        visibleChangeCommand (Callable?): Command that gets executed when visible state of the control changes.
                Properties: create, query, edit
        width (int?): The width of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit

    Returns:
        str: Full path name to the control.

    Example:
    """

def checkDefaultRenderGlobals(arg0: str, /) -> bool:
    """To query whether or not the defaultRenderGlobals node has been modified since the last file save, use `ls -modified`. To force the scene to be dirty/clean use `file -modified`checkDefaultRenderGlobals, registration
    Returns:
        bool: In query mode, return type is based on queried flag.

    Example:
    """

def choice(*args: str, attribute: str = ..., controlPoints: bool = ..., index: Unknown = ..., name: str = ..., selector: str = ..., shape: bool = ..., sourceAttribute: str = ..., time: int = ...) -> List[str]:
    """The choice command provides a mechanism for changing the inputs
    to an attribute based on some (usually time-based) criteria.
    For example, an object could be animated from
    frames 1 to 30 by a motion path, then from frames 30 to 50 it
    follows keyframe animation, and after frame 50 it returns to
    the motion path. Or, a revolve surface could change its input
    curve depending on some transform's rotation value.The choice command creates a choice node (if one does not already
    exist) on all specified attributes of the selected objects.
    If the attribute was already connected to something, that something
    is now reconnected to the i'th index of the choice node's input (or
    the next available input if the -in/index flag is not specified).
    If a source attribute is specified, then that attribute is connected
    to the choice node's i'th input instead.The choice node operates by using the value of its selector attribute
    to determine which of its input attributes to pass through to its output.
    The input attributes can be of any type. For example, if the selector
    attribute was connected by an animation curve with keyframes at
    (1,1), (30,2) and (50,1), then that would mean that the choice node
    would pass on the data from input[1] from time 1 to 30, and after time 50,
    and the data from input[2] between times 30 and 50.This command returns the names of the created or modified choice nodes,
    and if a keyframe was added to the animation curve, it specifies the
    index (or value on the animation curve).
    Args:
        attribute (str?): specifies the attributes onto which choice node(s) should
                be created. The default is all keyable attributes of the given
                objects. Note that although this flag is not queryable, it can
                be used to qualify which attributes of the given objects to query.
                      In query mode, this flag needs a value.
                Properties: create, multiuse
        controlPoints (bool?): Explicitly specify whether or not to include the
                control points of a shape (see "-s" flag) in the list of attributes.
                Default: false.
                Properties: create
        index (Unknown?): specifies the multi-input index of the choice node to connect
                the source attribute to. When queried, returns a list of integers
                one per specified -t/time that indicates the multi-index of the
                choice node to use at that time.
                Properties: create, query
        name (str?): the name to give to any newly created choice node(s).
                When queried, returns a list of strings.
                Properties: create, query
        selector (str?): specifies the attribute to be used as the choice node's
                selector. The value of the selector at a given time
                determines which of the choice node's multi-indices should
                be used as the output of the choice node at that time.
                This flag is only editable (it cannot be specified
                at creation time).
                When queried, returns a list of strings.
                Properties: create, query
        shape (bool?): Consider all attributes of shapes below transforms as well,
                except "controlPoints". Default: true
                Properties: create
        sourceAttribute (str?): specifies the attribute to connect to the choice node
                that will be selected at the given time(s) specified by -t/time.
                Properties: create
        time (int?): specifies the time at which the choice should use the given
                source attribute, or the currently connected attribute if
                source attribute is not specified. The default is the curren time.
                Note that although this flag is not queryable, it can be used
                to qualify the times at which to query the other attributes.
                      In query mode, this flag needs a value.
                Properties: create, multiuse

    Returns:
        List[str]: The newly created and/or modified choice nodes, with the attribute
            for which a selector keyframe was created.
            For example: choice1.input[3] choice2.input[3]

    Example:
    """

def circle(*args: str, caching: bool = ..., center: Tuple[Unknown, Unknown, Unknown] = ..., centerX: Unknown = ..., centerY: Unknown = ..., centerZ: Unknown = ..., degree: int = ..., first: Tuple[Unknown, Unknown, Unknown] = ..., firstPointX: Unknown = ..., firstPointY: Unknown = ..., firstPointZ: Unknown = ..., fixCenter: bool = ..., nodeState: int = ..., normal: Tuple[Unknown, Unknown, Unknown] = ..., normalX: Unknown = ..., normalY: Unknown = ..., normalZ: Unknown = ..., radius: Unknown = ..., sections: int = ..., sweep: float = ..., tolerance: Unknown = ..., useTolerance: bool = ..., constructionHistory: bool = ..., name: str = ..., object: bool = ...) -> List[str]:
    """The circle command creates a circle or partial circle (arc)
    Args:
        caching (bool?): Toggle caching for all attributes so that no recomputation is needed
                Properties: create, query, edit
        center (Tuple[Unknown, Unknown, Unknown]?): The center point of the circle.
                Properties: create, query, edit
        centerX (Unknown?): X of the center point.
                Default: 0
                Properties: create, query, edit
        centerY (Unknown?): Y of the center point.
                Default: 0
                Properties: create, query, edit
        centerZ (Unknown?): Z of the center point.
                Default: 0
                Properties: create, query, edit
        degree (int?): The degree of the resulting circle:
                1. linear,
                3. cubic
                Default: 3
                Properties: create, query, edit
        first (Tuple[Unknown, Unknown, Unknown]?): The start point of the circle if fixCenter is false.
                Determines the orientation of the circle if fixCenter is true.
                Properties: create, query, edit
        firstPointX (Unknown?): X of the first point.
                Default: 1
                Properties: create, query, edit
        firstPointY (Unknown?): Y of the first point.
                Default: 0
                Properties: create, query, edit
        firstPointZ (Unknown?): Z of the first point.
                Default: 0
                Properties: create, query, edit
        fixCenter (bool?): Fix the center of the circle to the specified center point.
                Otherwise the circle will start at the specified first point.
                Default: true
                Properties: create, query, edit
        nodeState (int?): Maya dependency nodes have 6 possible states.
                The Normal (0), HasNoEffect (1), and Blocking (2) states can be
                used to alter how the graph is evaluated.



                The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)
                are for internal use only. They temporarily shut off parts of the graph during interaction
                (e.g., manipulation). The understanding is that once the operation is done,
                the state will be reset appropriately, e.g. Waiting-Blocking will reset
                back to Blocking.



                The Normal and Blocking cases apply to all nodes, while
                HasNoEffect is node specific; many nodes do not support this option.
                Plug-ins store state in the MPxNode::state attribute. Anyone can set
                it or check this attribute.  Additional details about each of these 3 states follow.




                State
                Description


                Normal
                The normal node state. This is the default.


                HasNoEffect


                The HasNoEffect option (a.k.a. pass-through), is used in cases where
                there is an operation on an input producing an output of the same data type.
                Nearly all deformers support this state, as do a few other nodes.
                As stated earlier, it is not supported by all nodes.


                Itâ€™s typical to implement support for the HasNoEffect state in
                the nodeâ€™s compute method and to perform appropriate operations.
                Plug-ins can also support HasNoEffect.


                The usual implementation of this state is to copy the input directly to the
                matching output without applying the algorithm in the node. For deformers,
                applying this state leaves the input geometry undeformed on the output.




                Blocking


                This is implemented in the depend node base class and applies to all nodes.
                Blocking is applied during the evaluation phase to connections.
                An evaluation request to a blocked connection will return as failures,
                causing the destination plug to retain its current value. Dirty propagation
                is indirectly affected by this state since blocked connections are never cleaned.


                When a node is set to Blocking the behavior is supposed to be the same as
                if all outgoing connections were broken. As long as nobody requests evaluation
                of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked
                node will still respond to getAttr requests but a getAttr on a
                downstream node will not reevaluate the blocked node.


                Setting the root transform of a hierarchy to Blocking wonâ€™t automatically
                influence child transforms in the hierarchy. To do this, youâ€™d need to
                explicitly set all child nodes to the Blocking state.


                For example, to set all child transforms to Blocking, you could use the
                following script.



                import maya.cmds as cmds
                def blockTree(root):
                nodesToBlock = []
                for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys():
                nodesToBlock += cmds.listConnections(node, source=True, destination=True )
                for node in {source:1 for source in nodesToBlock}.keys():
                cmds.setAttr( '%s.nodeState' % node, 2 )



                Applying this script would continue to draw objects but things would not be animated.




                Default: kdnNormal
                Properties: create, query, edit
        normal (Tuple[Unknown, Unknown, Unknown]?): The normal of the plane in which the circle will lie.
                Properties: create, query, edit
        normalX (Unknown?): X of the normal direction.
                Default: 0
                Properties: create, query, edit
        normalY (Unknown?): Y of the normal direction.
                Default: 0
                Properties: create, query, edit
        normalZ (Unknown?): Z of the normal direction.
                Default: 1
                Properties: create, query, edit
        radius (Unknown?): The radius of the circle.
                Default: 1.0
                Properties: create, query, edit
        sections (int?): The number of sections determines the resolution of the circle.
                Used only if useTolerance is false.
                Default: 8
                Properties: create, query, edit
        sweep (float?): The sweep angle determines the completeness of the circle.
                A full circle is 2Pi radians, or 360 degrees.
                Default: 6.2831853
                Properties: create, query, edit
        tolerance (Unknown?): The tolerance with which to build a circle.
                Used only if useTolerance is true
                Default: 0.01
                Properties: create, query, edit
        useTolerance (bool?): Use the specified tolerance to determine resolution.
                Otherwise number of sections will be used.
                Default: false
                Properties: create, query, edit
        constructionHistory (bool?): Turn the construction history on or off.
                Properties: create
        name (str?): Sets the name of the newly-created node. If it contains
                namespace path, the new node will be created under the
                specified namespace; if the namespace does not exist, it
                will be created.
                Properties: create
        object (bool?): Create the result, or just the dependency node.
                Properties: create

    Returns:
        List[str]: Object name and node name

    Example:
    """

def circularFillet(arg0: str, arg1: str, /, caching: bool = ..., nodeState: int = ..., positionTolerance: float = ..., primaryRadius: Unknown = ..., secondaryRadius: Unknown = ..., tangentTolerance: float = ..., constructionHistory: bool = ..., curveOnSurface: bool = ..., name: str = ..., object: bool = ...) -> List[str]:
    """The cmd is used to compute the rolling ball surface
    fillet ( circular fillet ) between two given NURBS surfaces.
    To generate trim curves on the surfaces, use -cos true.
    Args:
        caching (bool?): Toggle caching for all attributes so that no recomputation is needed
                Properties: create, query, edit
        nodeState (int?): Maya dependency nodes have 6 possible states.
                The Normal (0), HasNoEffect (1), and Blocking (2) states can be
                used to alter how the graph is evaluated.



                The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)
                are for internal use only. They temporarily shut off parts of the graph during interaction
                (e.g., manipulation). The understanding is that once the operation is done,
                the state will be reset appropriately, e.g. Waiting-Blocking will reset
                back to Blocking.



                The Normal and Blocking cases apply to all nodes, while
                HasNoEffect is node specific; many nodes do not support this option.
                Plug-ins store state in the MPxNode::state attribute. Anyone can set
                it or check this attribute.  Additional details about each of these 3 states follow.




                State
                Description


                Normal
                The normal node state. This is the default.


                HasNoEffect


                The HasNoEffect option (a.k.a. pass-through), is used in cases where
                there is an operation on an input producing an output of the same data type.
                Nearly all deformers support this state, as do a few other nodes.
                As stated earlier, it is not supported by all nodes.


                Itâ€™s typical to implement support for the HasNoEffect state in
                the nodeâ€™s compute method and to perform appropriate operations.
                Plug-ins can also support HasNoEffect.


                The usual implementation of this state is to copy the input directly to the
                matching output without applying the algorithm in the node. For deformers,
                applying this state leaves the input geometry undeformed on the output.




                Blocking


                This is implemented in the depend node base class and applies to all nodes.
                Blocking is applied during the evaluation phase to connections.
                An evaluation request to a blocked connection will return as failures,
                causing the destination plug to retain its current value. Dirty propagation
                is indirectly affected by this state since blocked connections are never cleaned.


                When a node is set to Blocking the behavior is supposed to be the same as
                if all outgoing connections were broken. As long as nobody requests evaluation
                of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked
                node will still respond to getAttr requests but a getAttr on a
                downstream node will not reevaluate the blocked node.


                Setting the root transform of a hierarchy to Blocking wonâ€™t automatically
                influence child transforms in the hierarchy. To do this, youâ€™d need to
                explicitly set all child nodes to the Blocking state.


                For example, to set all child transforms to Blocking, you could use the
                following script.



                import maya.cmds as cmds
                def blockTree(root):
                nodesToBlock = []
                for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys():
                nodesToBlock += cmds.listConnections(node, source=True, destination=True )
                for node in {source:1 for source in nodesToBlock}.keys():
                cmds.setAttr( '%s.nodeState' % node, 2 )



                Applying this script would continue to draw objects but things would not be animated.




                Default: kdnNormal
                Properties: create, query, edit
        positionTolerance (float?): C(0) Tolerance For Fillet Surface
                Default: 0.01
                Properties: create, query, edit
        primaryRadius (Unknown?): primary Radius
                Default: 1.0
                Properties: create, query, edit
        secondaryRadius (Unknown?): secondary Radius
                Default: 1.0
                Properties: create, query, edit
        tangentTolerance (float?): G(1) Tolerance For Fillet Surface
                Default: 0.01
                Properties: create, query, edit
        constructionHistory (bool?): Turn the construction history on or off.
                Properties: create
        curveOnSurface (bool?): If possible, create 2D curve as a result.
                Properties: create
        name (str?): Sets the name of the newly-created node. If it contains
                namespace path, the new node will be created under the
                specified namespace; if the namespace does not exist, it
                will be created.
                Properties: create
        object (bool?): Create the result, or just the dependency node.
                Properties: create

    Returns:
        List[str]: Object name, node name.

    Example:
    """

def clearCache(*args: str, allNodes: bool = ..., computed: bool = ..., dirty: bool = ...) -> int:
    """Even though dependency graph values are computed or dirty they may still
    occupy space temporarily within the nodes.  This command goes in to all of
    the data that can be regenerated if required and removes it from the caches (datablocks), thus clearing up space in memory.dependency, graph, cache, optimize, performance, memory
    Args:
        allNodes (bool?): If toggled then all nodes in the graph are cleared.  Otherwise only those
                nodes that are selected are cleared.
                Properties: create
        computed (bool?): If toggled then remove all data that is computable.  (Warning: If the data
                is requested for redraw then the recompute will immediately fill the data
                back in.)
                Properties: create
        dirty (bool?): If toggled then remove all heavy data that is dirty.
                Properties: create

    Returns:
        int: Number of items removed from caches

    Example:
    """

def clearDynStartState() -> None: ...
def clearNClothStartState() -> None: ...
def clearShear(*args: str) -> None: ...
def clip(*args: str, absolute: bool = ..., absoluteRotations: bool = ..., active: str = ..., addTrack: bool = ..., allAbsolute: bool = ..., allClips: bool = ..., allRelative: bool = ..., allSourceClips: bool = ..., animCurveRange: bool = ..., character: bool = ..., constraint: bool = ..., copy: bool = ..., defaultAbsolute: bool = ..., duplicate: bool = ..., endTime: int = ..., expression: bool = ..., ignoreSubcharacters: bool = ..., isolate: bool = ..., leaveOriginal: bool = ..., mapMethod: str = ..., name: str = ..., newName: str = ..., paste: bool = ..., pasteInstance: bool = ..., remove: bool = ..., removeTrack: bool = ..., rotationOffset: Tuple[float, float, float] = ..., rotationsAbsolute: bool = ..., scheduleClip: bool = ..., sourceClipName: bool = ..., split: int = ..., startTime: int = ..., translationOffset: Tuple[float, float, float] = ..., useChannel: str = ...) -> List[str]:
    """This command is used to create, edit and query character clips.character, clip, animation
    Args:
        absolute (bool?): This flag is now deprecated.  Use aa/allAbsolute, ar/allRelative, ra/rotationsAbsolute, or da/defaultAbsolute instead.  This flag controls whether the clip follows its keyframe values or whether they are offset by a value to maintain a smooth path. Default is true.
                Properties: create
        absoluteRotations (bool?): This flag is now deprecated.  Use aa/allAbsolute, ar/allRelative, ra/rotationsAbsolute, or da/defaultAbsolute instead. If true, this overrides the -absolute flag so that rotation channels are always calculated with absolute offsets. This allows you to have absolute offsets on rotations and relative offsets on all other channels.
                Properties: create
        active (str?): Query or edit the active clip. This flag is not valid in create mode. Making a
                clip active causes its animCurves to be hooked directly to the character attributes in addition to being attached to the clip library node. This makes it easier to access the animCurves if you want to edit, delete or add additional animCruves to the clip.
                Properties: query, edit
        addTrack (bool?): This flag is now obsolete. Use the insertTrack flag on the clipSchedule command instead.
        allAbsolute (bool?): Set all channels to be calculated with absolute offsets.  This flag cannot be used in conjunction with the ar/allRelative, ra/rotationsAbsolute or da/defaultAbsolute flags.
                Properties: create
        allClips (bool?): This flag is used to query all the clips in the scene. Nodes of type "animClip" that are storing poses, are not returned by this command.
                Properties: query
        allRelative (bool?): Set all channels to be calculated with relative offsets.  This flag cannot be used in conjunction with the aa/allAbsolute, ra/rotationsAbsolute or da/defaultAbsolute flags.
                Properties: create
        allSourceClips (bool?): This flag is used to query all the source clips in the scene. Nodes of type "animClip" that are storing poses or clip instances, are not returned by this command.
                Properties: query
        animCurveRange (bool?): This flag can be used at the time you create the clip instead of the startTime and endTime flags. It specifies that you want the range of the clip to span the range of keys in the clips associated animCurves.
                Properties: create
        character (bool?): This is a query only flag which operates on the specified clip. It returns the names of any characters that a clip is associated with.
                Properties: query
        constraint (bool?): This creates a clip out of any constraints on the character. The constraint will be moved off of the character and into the clip, so that it is only active for the duration of the clip, and its value can be scaled/offset/cycled according to the clip attributes.
                Properties: create
        copy (bool?): This flag is used to copy a clip or clips to the clipboard. It should be used in conjunction with the name flag to copy the named clips on the specified character and its subcharacters. In query mode, this flag allows you to query what, if anything, has been copied into the clip clipboard.
                Properties: create, query
        defaultAbsolute (bool?): Sets all top-level channels except rotations in the clip to relative, and the remaining channels to absolute. This is the default during clip creation if no offset flag is specified.  This flag cannot be used in conjunction with the aa/allAbsolute, ar/allRelative, or ra/rotationsAbsolute flags.
                Properties: create
        duplicate (bool?): Duplicate the clip specified by the name flag. The start time of the new clip should be specified with the startTime flag.
                Properties: query
        endTime (int?): Specify the clip end
                Properties: create, query, edit
        expression (bool?): This creates a clip out of any expressions on the character. The expression will be moved off of the character and into the clip, so that it is only active for the duration of the clip, and its value can be scaled/offset/cycled according to the clip attributes.
                Properties: create
        ignoreSubcharacters (bool?): During clip creation, duplication and isolation, subcharacters are included by default. If you want to create a clip on the top level character only, or you want to duplicate the clip on the top level character without including subCharacters, use the ignoreSubcharacters flag.
                Properties: create
        isolate (bool?): This flag should be used in conjunction with the name flag to specify that a clip or clips should be copied to a new clip library. The most common use of this flag is for export, when you want to only export certain clips from the character, without exporting all of the clips.
                Properties: create
        leaveOriginal (bool?): This flag is used when creating a clip to specify that the animation curves should be copied to the clip library, and left on the character.
                Properties: create
        mapMethod (str?): This is is valid with the paste and pasteInstance flags only. It specifies how the mapping should be done. Valid options are: "byNodeName", "byAttrName", "byCharacterMap", "byAttrOrder", "byMapOrAttrName" and "byMapOrNodeName". "byAttrName" is the default. The flags mean the following: "byAttrOrder" maps using the order that the character stores the attributes internally, "byAttrName" uses the attribute name to find a correspondence, "byNodeName" uses the node name *and* the attribute name to find a correspondence, "byCharacterMap" uses the existing characterMap node to do the mapping. "byMapOrAttrName" uses a character map if one exists, otherwise uses the attribute name. "byMapOrNodeName" uses a character map if one exists, otherwise uses the attribute name.
                Properties: create
        name (str?): In create mode, specify the clip name. In query mode, return a list of all the clips. In duplicate mode, specify the clip to be duplicated. In copy mode, specify the clip to be copied. This flag is multi-use, but multiple use is only supported with the copy flag. For use during create and with all other flags, only the first instance of the name flag will be utilized.
                			In query mode, this flag can accept a value.
                Properties: create, query, multiuse
        newName (str?): Rename a clip. Must be used in conjunction with the clip name flag, which is used to specify the clip to be renamed.
                Properties: create
        paste (bool?): This flag is used to paste a clip or clips from the clipboard to a character. Clips are added to the clipboard using the c/copy flag.
                Properties: create
        pasteInstance (bool?): This flag is used to paste an instance of a clip or clips from the clipboard to a character. Unlike the p/paste flag, which duplicates the animCurves from the original source clip, the pi/pasteInstance flag shares the animCurves from the source clip.
                Properties: create
        remove (bool?): Remove the clip specified by the name flag. The clip will be
                permanently removed from the library and deleted from any times
                where it has been scheduled.
                Properties: query
        removeTrack (bool?): This flag is now obsolete. Use removeTrack flag on the clipSchedule command instead.
                Properties: create
        rotationOffset (Tuple[float, float, float]?): Return the channel offsets used to modify the clip's rotation.
                Properties: create, query
        rotationsAbsolute (bool?): Set all channels except rotations to be calculated with relative offsets.  Rotation channels will be calculated with absolute offsets.  This flag cannot be used in conjunction with the aa/allAbsolute, ar/allRelative or da/defaultAbsolute flags.
                Properties: create
        scheduleClip (bool?): This flag is used when creating a clip to specify whether or not the clip should immediately be scheduled at the current time. If the clip is not scheduled, the clip will be placed in the library for future use, but will not be placed on the timeline. This flag is for use only when creating a new clip or duplicating an existing. The default is true.
                Properties: create
        sourceClipName (bool?): This flag is for query only. It returns the name of the source clip that controls an instanced clip.
                Properties: query
        split (int?): Split an existing clip into two clips. The split occurs around the specified time.
                Properties: create, edit
        startTime (int?): Specify the clip start
                Properties: create, query, edit
        translationOffset (Tuple[float, float, float]?): Return the channel offsets used to modify the clip's translation.
                Properties: create, query
        useChannel (str?): Specify which channels should be acted on. This flag is valid only in
                conjunction with clip creation, and the isolate flag. The specified channels
                must be members of the character.
                Properties: create, multiuse

    Returns:
        List[str]: clip names

    Example:
    """

def clipEditor(arg0: str, /, allTrackHeights: int = ..., autoFit: str = ..., autoFitTime: str = ..., clipDropCmd: str = ..., clipStyle: int = ..., control: bool = ..., defineTemplate: str = ..., deleteCmd: str = ..., deselectAll: bool = ..., displayActiveKeyTangents: str = ..., displayActiveKeys: str = ..., displayInfinities: str = ..., displayKeys: str = ..., displayTangents: str = ..., displayValues: str = ..., docTag: str = ..., exists: bool = ..., filter: str = ..., forceMainConnection: str = ..., frameAll: bool = ..., frameRange: Tuple[float, float] = ..., highlightConnection: str = ..., highlightedBlend: Tuple[str, str] = ..., highlightedClip: Tuple[str, str] = ..., initialized: bool = ..., listAllCharacters: bool = ..., listCurrentCharacters: bool = ..., lockMainConnection: bool = ..., lookAt: str = ..., mainListConnection: str = ..., manageSequencer: bool = ..., menuContext: str = ..., panel: str = ..., parent: str = ..., selectBlend: Tuple[str, str, str] = ..., selectClip: Tuple[str, str] = ..., selectionConnection: str = ..., snapTime: str = ..., snapValue: str = ..., stateString: bool = ..., unParent: bool = ..., unlockMainConnection: bool = ..., updateMainConnection: bool = ..., useTemplate: str = ...) -> str:
    """Create a clip editor with the given name.
    Args:
        allTrackHeights (int?): OBSOLETE flag. Use clipStyle instead.
        autoFit (str?): on | off | tgl
                Auto fit-to-view.
                Properties: query, edit
        autoFitTime (str?): on | off | tgl
                Auto fit-to-view along the time axis, as well.
                Properties: query, edit
        clipDropCmd (str?): Command executed when clip node is dropped on the TraX editor
                Properties: edit
        clipStyle (int?): Set/return the clip track style in the specified editor. Default is 2. Valid values are 1. 3.
                Properties: query, edit
        control (bool?): Query only. Returns the top level control for this editor.
                Usually used for getting a parent to attach popup menus.
                Caution: It is possible for an editor to exist without a
                control. The query will return "NONE" if no control is present.
                Properties: query
        defineTemplate (str?): Puts the command in a mode where any other flags and arguments are
                parsed and added to the command template specified in the argument.
                They will be used as default arguments in any subsequent
                invocations of the command when templateName is set as the
                current template.
                Properties: create
        deleteCmd (str?): Command executed when backspace key is pressed
                Properties: edit
        deselectAll (bool?): Deselect all clips and blends in the editor.
                Properties: edit
        displayActiveKeyTangents (str?): on | off | tgl
                Display active key tangents in the editor.
                Properties: edit
        displayActiveKeys (str?): on | off | tgl
                Display active keys in the editor.
                Properties: edit
        displayInfinities (str?): on | off | tgl
                Display infinities in the editor.
                Properties: edit
        displayKeys (str?): on | off | tgl
                Display keyframes in the editor.
                Properties: edit
        displayTangents (str?): on | off | tgl
                Display tangents in the editor.
                Properties: edit
        displayValues (str?): on | off | tgl
                Display active keys and tangents values in the editor.
                Properties: edit
        docTag (str?): Attaches a tag to the editor.
                Properties: create, query, edit
        exists (bool?): Returns whether the
                specified object exists or not. Other flags are ignored.
                Properties: create
        filter (str?): Specifies the name of an itemFilter object to be used with this editor.
                This filters the information coming onto the main list
                of the editor.
                Properties: create, query, edit
        forceMainConnection (str?): Specifies the name of a selectionConnection object that the
                editor will use as its source of content. The editor will only
                display items contained in the selectionConnection object. This is
                a variant of the -mainListConnection flag in that it will force a
                change even when the connection is locked. This flag is used to
                reduce the overhead when using the -unlockMainConnection
                , -mainListConnection, -lockMainConnection flags in immediate
                succession.
                Properties: create, query, edit
        frameAll (bool?): Frame view around all clips in the editor.
                Properties: edit
        frameRange (Tuple[float, float]?): The editor's current frame range.
                Properties: query, edit
        highlightConnection (str?): Specifies the name of a selectionConnection object that
                the editor will synchronize with its highlight list. Not all
                editors have a highlight list. For those that do, it is a secondary
                selection list.
                Properties: create, query, edit
        highlightedBlend (Tuple[str, str]?): Returns the highlighted blend, listed as scheduler and index
                Properties: query
        highlightedClip (Tuple[str, str]?): Returns the highlighted clip, listed as scheduler and index
                Properties: query
        initialized (bool?): Returns whether the clip editor is fully initialized, and has a port to draw through.
                If not, the -frameRange and -frameAll flags will fail.
                Properties: query
        listAllCharacters (bool?): List all characters in the editor and outliner.
                Properties: edit
        listCurrentCharacters (bool?): List only the characters in the editor and outliner.
                Properties: edit
        lockMainConnection (bool?): Locks the current list of objects within the mainConnection,
                so that only those objects are displayed within the editor.
                Further changes to the original mainConnection are ignored.
                Properties: create, edit
        lookAt (str?): all | selected | currentTime
                FitView helpers.
                Properties: edit
        mainListConnection (str?): Specifies the name of a selectionConnection object that the
                editor will use as its source of content. The editor will
                only display items contained in the selectionConnection object.
                Properties: create, query, edit
        manageSequencer (bool?): Sets/returns whether the clip editor should manage sequencer nodes.  If so,
                animation clips and characters are not represented.
                Properties: create, query, edit
        menuContext (str?): Returns a string array denoting the type of data object the cursor
                is over.  Returned values are:
                {"timeSlider"}
                {"nothing"}
                {"track", "track index", "character node name", "group name"}
                {"clip", "clip node name"}
                Properties: query
        panel (str?): Specifies the panel for this editor. By default if
                an editor is created in the create callback of a scripted panel it
                will belong to that panel. If an editor does not belong to a panel
                it will be deleted when the window that it is in is deleted.
                Properties: create, query
        parent (str?): Specifies the parent layout for this editor. This flag will only
                have an effect if the editor is currently un-parented.
                Properties: create, query, edit
        selectBlend (Tuple[str, str, str]?): Select the blends specified by the scheduler name and the indicies
                of the two clips used in the blend.
                When queried, a string containing the scheduler name and the
                two clip indicies for all of the selected blends is returned.
                Properties: query, edit
        selectClip (Tuple[str, str]?): Selects the clip specified by the scheduler name and the clip index.
                When queried, a string containing the scheduler and clip index
                of all of the selected clips is returned.
                Properties: query, edit
        selectionConnection (str?): Specifies the name of a selectionConnection object that the
                editor will synchronize with its own selection list. As the user
                selects things in this editor, they will be selected in the
                selectionConnection object. If the object undergoes changes, the
                editor updates to show the changes.
                Properties: create, query, edit
        snapTime (str?): none | integer | keyframe
                Keyframe move snap in time.
                Properties: query, edit
        snapValue (str?): none | integer | keyframe
                Keyframe move snap in values.
                Properties: query, edit
        stateString (bool?): Query only flag. Returns the MEL command that will create an
                editor to match the current editor state. The returned command string
                uses the string variable $editorName in place of a specific name.
                Properties: query
        unParent (bool?): Specifies that the editor should be removed from its layout.
                This cannot be used in query mode.
                Properties: create, edit
        unlockMainConnection (bool?): Unlocks the mainConnection, effectively restoring the original
                mainConnection (if it is still available), and dynamic updates.
                Properties: create, edit
        updateMainConnection (bool?): Causes a locked mainConnection to be updated from the orginal
                mainConnection, but preserves the lock state.
                Properties: create, edit
        useTemplate (str?): Forces the command to use a command template other than
                the current one.
                Properties: create

    Returns:
        str: Editor name

    Example:
    """

def clipEditorCurrentTimeCtx(arg0: str, /, exists: bool = ..., history: bool = ..., image1: str = ..., image2: str = ..., image3: str = ..., name: str = ...) -> str:
    """This command creates a context which may be used to change current time
    within the track area of a clip editor.
    Args:
        exists (bool?): Returns true or false depending upon whether the
                specified object exists. Other flags are ignored.
                Properties: create
        history (bool?): If this is a tool command, turn the construction history on
                for the tool in question.
                Properties: create
        image1 (str?): First of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        image2 (str?): Second of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        image3 (str?): Third of three possible icons representing the tool
                associated with the context.
                Properties: create, query, edit
        name (str?): If this is a tool command, name the tool appropriately.
                Properties: create

    Returns:
        str: Context name

    Example:
    """

def clipMatching(*args: str, clipDst: Tuple[str, float] = ..., clipSrc: Tuple[str, float] = ..., matchRotation: Unknown = ..., matchTranslation: Unknown = ...) -> bool:
    """This command is used to compute an offset to apply on a source clip in order to
    automatically align it to a destination clip at a specified match element.
    For this command to work, offset objects must be specified for the character.character, clip, animation
    Args:
        clipDst (Tuple[str, float]?): The clip to match so that the source clip can be offsetted correctly.  This flag
                takes in a clip name and the percentage value ranging from 0.0 to 1.0 in order
                to have the source clip match at a certain time in the destination clip.
                Properties: create
        clipSrc (Tuple[str, float]?): The clip to offset so that it aligns with the destination clip.  This flag takes
                in a clip name and the percentage value ranging from 0.0 to 1.0 in order to
                have it match at a certain time in the clip.
                Properties: create
        matchRotation (Unknown?): This flag sets the rotation match type. By default, it is set to not match the
                rotation.
                0. None
                1. Match full rotation
                2. Match projected rotation on ground plane
                Properties: create
        matchTranslation (Unknown?): This flag sets the translation match type. By default, it is set to not match
                the translation.
                0. None
                1. Match full translation
                2. Match projected translation on ground plane
                Properties: create

    Returns:
        bool:

    Example:
    """

def clipSchedule(*args: str, allAbsolute: bool = ..., allRelative: bool = ..., blend: Tuple[Unknown, Unknown] = ..., blendNode: Tuple[Unknown, Unknown] = ..., blendUsingNode: str = ..., character: bool = ..., clipIndex: Unknown = ..., cycle: float = ..., defaultAbsolute: bool = ..., enable: bool = ..., group: bool = ..., groupIndex: Unknown = ..., groupName: str = ..., hold: int = ..., insertTrack: Unknown = ..., instance: str = ..., listCurves: bool = ..., listPairs: bool = ..., lock: bool = ..., mute: bool = ..., name: str = ..., postCycle: float = ..., preCycle: float = ..., remove: bool = ..., removeBlend: Tuple[Unknown, Unknown] = ..., removeEmptyTracks: bool = ..., removeTrack: Unknown = ..., rotationsAbsolute: bool = ..., scale: float = ..., shift: int = ..., shiftIndex: Unknown = ..., solo: bool = ..., sourceClipName: bool = ..., sourceEnd: int = ..., sourceStart: int = ..., start: int = ..., track: Unknown = ..., weight: float = ..., weightStyle: Unknown = ...) -> str:
    """This command is used to create, edit and query clips and blends in the Trax editor. It operates on the clipScheduler node attached to the character. In query mode, if no flags are specified, returns an array of strings in this form:
     (clipName,clipIndex,clipStart,clipSourceStart,clipSourceEnd,clipScale,clipPreCycle,clipPostCycle,clipHold)character, clip, animation
    Args:
        allAbsolute (bool?): Set all channels to be calculated with absolute offsets.  This flag cannot be used in conjunction with the ar/allRelative, ra/rotationsAbsolute or da/defaultAbsolute flags.
                Properties: query, edit
        allRelative (bool?): Set all channels to be calculated with relative offsets.  This flag cannot be used in conjunction with the aa/allAbsolute, ra/rotationsAbsolute or da/defaultAbsolute flags.
                Properties: query, edit
        blend (Tuple[Unknown, Unknown]?): This flag is used to blend two clips, whose indices are provided as flag arguments.
                Properties: create, query
        blendNode (Tuple[Unknown, Unknown]?): This query only flag list all of the blend nodes associated with the blend defined by the two clip indices. This flag returns a string array.
                			In query mode, this flag can accept a value.
                Properties: query
        blendUsingNode (str?): This flag is used to blend using an existing blend node. It is used in conjunction with the blend flag. The blend flag specifies the clip indices for the blend. The name of an existing animBlend node should be supplied supplied as an argument for the blendUsingNode flag.
                Properties: create
        character (bool?): This flag is used to query which characters this scheduler controls. It returns an array of strings.
                Properties: query
        clipIndex (Unknown?): Specify the index of the clip to schedule. In query mode, returns
                an array of strings in this form:
                (clipName,index,start,sourceStart,sourceEnd,scale,preCycle,postCycle)
                			In query mode, this flag can accept a value.
                Properties: create, query
        cycle (float?): This flag is now obsolete. Use the postCycle flag instead.
                Properties: create, query
        defaultAbsolute (bool?): Sets all top-level channels except rotations in the clip to relative, and the remaining channels to absolute. This is the default during clip creation if no offset flag is specified.  This flag cannot be used in conjunction with the aa/allAbsolute, ar/allRelative, or ra/rotationsAbsolute flags.
                Properties: query, edit
        enable (bool?): This flag is used to enable or disable a clip. It must be used in conjunction with the ci/clipIndex flag. The specified clip will be enabled or disabled.
                Properties: create, query
        group (bool?): This flag is used to add (true) or remove (false) a list of clips (specified with groupIndex) into a group.
                Properties: create
        groupIndex (Unknown?): This flag specifies a multiple number of clips to be added or removed from a group.
                Properties: create, multiuse
        groupName (str?): This flag is used to specify the group that should be added to.  If no group
                by that name exists and new group is created with that name.  By default if
                this is not specified a new group will be created.
                Properties: create, query
        hold (int?): Specify how long to hold the last value of the clip after its normal or cycled end.
                Properties: create, query
        insertTrack (Unknown?): This flag is used to insert a new empty track at the track index
                specified.
                Properties: create
        instance (str?): Create an instanced copy of the named clip. An instanced clip is one that is linked to an original clip. Thus, changes to the animation curve of the original curve will also modify all instanced clips. The name of the instanced clip is returned
                as a string.
                Properties: create
        listCurves (bool?): This flag is used to list the animation curves associated with a clip. It should be used in conjunction with the clipIndex flag, which specifies the clip of interest.
                Properties: create, query
        listPairs (bool?): This query only flag returns a string array containing the channels
                in a character that are used by a clip and the names of the animation
                curves that drive the channels. Each string in the string array consists
                of the name of a channel, a space, and the name of the animation curve
                animating that channel. This flag must be used with the ci/clipIndex flag.
                Properties: query
        lock (bool?): This flag specifies whether clips on a track are to be locked or not.
                Must be used in conjuction with the track flag.
                Properties: query, edit
        mute (bool?): This flag specifies whether clips on a track are to be muted or not.
                Must be used in conjuction with the track flag.
                Properties: query, edit
        name (str?): This flag is used to query the name of the clip node associated with the specified clip index, or to specify the name of the instanced clip during instancing.
                			In query mode, this flag can accept a value.
                Properties: create, query
        postCycle (float?): Specify the number of times to repeat the clip after its normal end.
                Properties: create, query
        preCycle (float?): Specify the number of times to repeat the clip before its normal start.
                Properties: create, query
        remove (bool?): This flag is used to remove a clip from the timeline. It must be used in conjunction with the ci/clipIndex flag. The specified clip will be removed from the timeline, but will still exist in the library and any instanced clips will remain in the timeline. To permanently remove a clip from the scene, the clip command should be used instead.
                Properties: create
        removeBlend (Tuple[Unknown, Unknown]?): This flag is used to remove an existing blend between two clips, whose indices are provided as flag arguments.
                Properties: create
        removeEmptyTracks (bool?): This flag is used to remove all tracks that have no clips.
                Properties: create
        removeTrack (Unknown?): This flag is used to remove the track with the specified index.  The
                track must have no clips on it before it can be removed.
                Properties: create
        rotationsAbsolute (bool?): Set all channels except rotations to be calculated with relative offsets.  Rotation channels will be calculated with absolute offsets.  This flag cannot be used in conjunction with the aa/allAbsolute, ar/allRelative or da/defaultAbsolute flags.
                Properties: query, edit
        scale (float?): Specify the amount to scale the clip. Values must be greater than 0.
                Properties: create, query
        shift (int?): This flag allows multiple clips to be shifted by a certain number of tracks
                and works in conjunction with the shiftIndex flag.  The flag specifies the
                number of tracks to shift the associated clips.  Positive values shift the
                clips down an negative values shift the clips up.
                Properties: create
        shiftIndex (Unknown?): This flag allows multiple clips to be shifted by a certain number of tracks
                and works in conjunction with the shiftAmount flag.  The flag specifies the
                index of the clip to shift.  This flag can be used multiple times on the command
                line to specify a number of clips to shift.
                Properties: create, multiuse
        solo (bool?): This flag specifies whether clips on a track are to be soloed or not.
                Must be used in conjuction with the track flag.
                Properties: query, edit
        sourceClipName (bool?): This flag is used to query the name of the source clip node associated with the specified clip index.
                Properties: create, query
        sourceEnd (int?): Specify where to end in the source clip's animation curves
                Properties: create, query
        sourceStart (int?): Specify where to start in the source clip's animation curves
                Properties: create, query
        start (int?): Specify the placement of the start of the clip
                Properties: create, query
        track (Unknown?): Specify the track to operate on. For example, which track to place
                a clip on, which track to mute/lock/solo.  In query mode, it may be used
                in conjuction with the clipIndex flag to return the track number of a clip,
                where track 1 is the first track of the character.
                			In query mode, this flag can accept a value.
                Properties: create, query
        weight (float?): This flag is used in to set or query the weight of the clip associated with the specified clip index.
                Properties: create, query
        weightStyle (Unknown?): This flag is used to set or query the weightStyle attribute of the clip associated with the specified clip index.
                Properties: create, query

    Returns:
        str: Clip name

    Example:
    """

def clipSchedulerOutliner(arg0: str, /, annotation: str = ..., backgroundColor: Tuple[float, float, float] = ..., clipScheduler: str = ..., defineTemplate: str = ..., docTag: str = ..., dragCallback: Callable = ..., dropCallback: Callable = ..., enable: bool = ..., enableBackground: bool = ..., enableKeyboardFocus: bool = ..., exists: bool = ..., fullPathName: bool = ..., height: int = ..., highlightColor: Tuple[float, float, float] = ..., isObscured: bool = ..., manage: bool = ..., noBackground: bool = ..., numberOfPopupMenus: bool = ..., parent: str = ..., popupMenuArray: bool = ..., preventOverride: bool = ..., statusBarMessage: str = ..., useTemplate: str = ..., visible: bool = ..., visibleChangeCommand: Callable = ..., width: int = ...) -> str:
    """This command creates/edits/queries a clip scheduler outliner control.
    Args:
        annotation (str?): Annotate the control with an extra string value.
                Properties: create, query, edit
        backgroundColor (Tuple[float, float, float]?): The background color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                When setting backgroundColor, the background is automatically
                enabled, unless enableBackground is also specified with a false
                value.
                Properties: create, query, edit
        clipScheduler (str?): Name of the clip scheduler for which to display information.
                Properties: edit
        defineTemplate (str?): Puts the command in a mode where any other flags and arguments are
                parsed and added to the command template specified in the argument.
                They will be used as default arguments in any subsequent
                invocations of the command when templateName is set as the
                current template.
                Properties: create
        docTag (str?): Add a documentation flag to the control.  The documentation flag
                has a directory structure.
                (e.g., -dt render/multiLister/createNode/material)
                Properties: create, query, edit
        dragCallback (Callable?): Adds a callback that is called when the middle mouse button
                is pressed.  The MEL version of the callback is of the form:

                global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods)

                The proc returns a string array that is transferred to the drop site.
                By convention the first string in the array describes the user settable
                message type.  Controls that are application defined drag sources may
                ignore the callback. $mods allows testing for the key modifiers CTRL and
                SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL,
                3 == CTRL + SHIFT.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def callbackName( dragControl, x, y, modifiers ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "x", "y", "modifiers".  The
                "dragControl" value is a string and the other values are integers (eg the
                callback string could be "print '%(dragControl)s %(x)d %(y)d %(modifiers)d'")
                Properties: create, edit
        dropCallback (Callable?): Adds a callback that is called when a drag and drop
                operation is released above the drop site.  The MEL version of the callback is
                of the form:

                global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type)

                The proc receives a string array that is transferred from the drag source.
                The first string in the msgs array describes the user defined message type.
                Controls that are application defined drop sites may ignore the
                callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "dropControl", "messages", "x", "y",
                "type".  The "dragControl" value is a string and the other values are integers
                (eg the callback string could be
                "print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'")
                Properties: create, edit
        enable (bool?): The enable state of the control.  By default, this flag is
                set to true and the control is enabled.  Specify false and the control
                will appear dimmed or greyed-out indicating it is disabled.
                Properties: create, query, edit
        enableBackground (bool?): Enables the background color of the control.
                Properties: create, query, edit
        enableKeyboardFocus (bool?): If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse.
                This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls.
                If disabled, text in text fields can still be selected with the mouse but cannot be copied (except on Linux when "Middle Click Paste" is enabled).
                Properties: create, query, edit
        exists (bool?): Returns whether the
                specified object exists or not. Other flags are ignored.
                Properties: create
        fullPathName (bool?): Return the full path name of the widget, which includes all the parents.
                Properties: query
        height (int?): The height of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit
        highlightColor (Tuple[float, float, float]?): The highlight color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                Properties: create, query, edit
        isObscured (bool?): Return whether the control can actually be seen by the user.
                The control will be obscured if its state is invisible, if it is
                blocked (entirely or partially) by some other control, if it or a
                parent layout is unmanaged, or if the control's window is
                invisible or iconified.
                Properties: query
        manage (bool?): Manage state of the control.  An unmanaged control is
                not visible, nor does it take up any screen real estate.  All
                controls are created managed by default.
                Properties: create, query, edit
        noBackground (bool?): Clear/reset the control's background.
                Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.
                Properties: create, edit
        numberOfPopupMenus (bool?): Return the number of popup menus attached to this control.
                Properties: query
        parent (str?): The parent layout for this control.
                Properties: create, query
        popupMenuArray (bool?): Return the names of all the popup menus attached to this
                control.
                Properties: query
        preventOverride (bool?): If true, this flag prevents overriding the control's
                attribute via the control's right mouse button menu.
                Properties: create, query, edit
        statusBarMessage (str?): Extra string to display in the status bar when the mouse is over the control.
                Properties: create, edit
        useTemplate (str?): Forces the command to use a command template other than
                the current one.
                Properties: create
        visible (bool?): The visible state of the control.  A control is created
                visible by default.  Note that a control's actual appearance is
                also dependent on the visible state of its parent layout(s).
                Properties: create, query, edit
        visibleChangeCommand (Callable?): Command that gets executed when visible state of the control changes.
                Properties: create, query, edit
        width (int?): The width of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit

    Returns:
        str: The name of the outliner control.

    Example:
    """

def closeCurve(arg0: Tuple[str], /, blendBias: float = ..., blendKnotInsertion: bool = ..., caching: bool = ..., nodeState: int = ..., parameter: float = ..., preserveShape: int = ..., constructionHistory: bool = ..., curveOnSurface: bool = ..., name: str = ..., object: bool = ..., replaceOriginal: bool = ...) -> List[str]:
    """The closeCurve command closes a curve, making it periodic.
    The pathname to the newly closed curve and the name
    of the resulting dependency node are returned.  If a curve
    is not specified in the command, then the first active curve
    will be used.
    Args:
        blendBias (float?): Skew the result toward the first or the second curve depending
                on the blend value being smaller or larger than 0.5.
                Default: 0.5
                Properties: create, query, edit
        blendKnotInsertion (bool?): If set to true, insert a knot in one of the original curves
                (relative position given by the parameter attribute below)
                in order to produce a slightly different effect.
                Default: false
                Properties: create, query, edit
        caching (bool?): Toggle caching for all attributes so that no recomputation is needed
                Properties: create, query, edit
        nodeState (int?): Maya dependency nodes have 6 possible states.
                The Normal (0), HasNoEffect (1), and Blocking (2) states can be
                used to alter how the graph is evaluated.



                The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)
                are for internal use only. They temporarily shut off parts of the graph during interaction
                (e.g., manipulation). The understanding is that once the operation is done,
                the state will be reset appropriately, e.g. Waiting-Blocking will reset
                back to Blocking.



                The Normal and Blocking cases apply to all nodes, while
                HasNoEffect is node specific; many nodes do not support this option.
                Plug-ins store state in the MPxNode::state attribute. Anyone can set
                it or check this attribute.  Additional details about each of these 3 states follow.




                State
                Description


                Normal
                The normal node state. This is the default.


                HasNoEffect


                The HasNoEffect option (a.k.a. pass-through), is used in cases where
                there is an operation on an input producing an output of the same data type.
                Nearly all deformers support this state, as do a few other nodes.
                As stated earlier, it is not supported by all nodes.


                Itâ€™s typical to implement support for the HasNoEffect state in
                the nodeâ€™s compute method and to perform appropriate operations.
                Plug-ins can also support HasNoEffect.


                The usual implementation of this state is to copy the input directly to the
                matching output without applying the algorithm in the node. For deformers,
                applying this state leaves the input geometry undeformed on the output.




                Blocking


                This is implemented in the depend node base class and applies to all nodes.
                Blocking is applied during the evaluation phase to connections.
                An evaluation request to a blocked connection will return as failures,
                causing the destination plug to retain its current value. Dirty propagation
                is indirectly affected by this state since blocked connections are never cleaned.


                When a node is set to Blocking the behavior is supposed to be the same as
                if all outgoing connections were broken. As long as nobody requests evaluation
                of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked
                node will still respond to getAttr requests but a getAttr on a
                downstream node will not reevaluate the blocked node.


                Setting the root transform of a hierarchy to Blocking wonâ€™t automatically
                influence child transforms in the hierarchy. To do this, youâ€™d need to
                explicitly set all child nodes to the Blocking state.


                For example, to set all child transforms to Blocking, you could use the
                following script.



                import maya.cmds as cmds
                def blockTree(root):
                nodesToBlock = []
                for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys():
                nodesToBlock += cmds.listConnections(node, source=True, destination=True )
                for node in {source:1 for source in nodesToBlock}.keys():
                cmds.setAttr( '%s.nodeState' % node, 2 )



                Applying this script would continue to draw objects but things would not be animated.




                Default: kdnNormal
                Properties: create, query, edit
        parameter (float?): The parameter value for the positioning of the newly inserted knot.
                Default: 0.1
                Properties: create, query, edit
        preserveShape (int?): 0. without preserving the shape
                1. preserve shape
                2. blend
                Default: 1
                Properties: create, query, edit
        constructionHistory (bool?): Turn the construction history on or off.
                Properties: create
        curveOnSurface (bool?): If possible, create 2D curve as a result.
                Properties: create
        name (str?): Sets the name of the newly-created node. If it contains
                namespace path, the new node will be created under the
                specified namespace; if the namespace does not exist, it
                will be created.
                Properties: create
        object (bool?): Create the result, or just the dependency node.
                Properties: create
        replaceOriginal (bool?): Create "in place" (i.e., replace).
                Properties: create

    Returns:
        List[str]: Object name and node name

    Example:
    """

def closeSurface(arg0: Tuple[str], /, blendBias: float = ..., blendKnotInsertion: bool = ..., caching: bool = ..., direction: int = ..., nodeState: int = ..., parameter: float = ..., preserveShape: int = ..., constructionHistory: bool = ..., name: str = ..., object: bool = ..., replaceOriginal: bool = ...) -> List[str]:
    """The closeSurface command closes a surface in the U, V, or both
    directions, making it periodic. The close direction is controlled
    by the direction flag. If a surface is not specified in the
    command, then the first selected surface will be used.The pathname to the newly closed surface and the name of the resulting
    dependency node are returned.This command also handles selected surface isoparms. For example, if
    an isoparm is specified, surface1.u[0.33], then the surface will be
    closed in V, regardless of the direction flag.
    Args:
        blendBias (float?): Skew the result toward the first or the second surface depending on the blend value being smaller or larger than 0.5.
                Default: 0.5
                Properties: create, query, edit
        blendKnotInsertion (bool?): If set to true, insert a knot in one of the original surfaces (relative position given by the parameter attribute below) in order to produce a slightly different effect.
                Default: false
                Properties: create, query, edit
        caching (bool?): Toggle caching for all attributes so that no recomputation is needed
                Properties: create, query, edit
        direction (int?): The direction in which to close:
                0. U,
                1. V,
                2. Both U and V
                Default: 0
                Properties: create, query, edit
        nodeState (int?): Maya dependency nodes have 6 possible states.
                The Normal (0), HasNoEffect (1), and Blocking (2) states can be
                used to alter how the graph is evaluated.



                The Waiting-Normal (3), Waiting-HasNoEffect (4), Waiting-Blocking (5)
                are for internal use only. They temporarily shut off parts of the graph during interaction
                (e.g., manipulation). The understanding is that once the operation is done,
                the state will be reset appropriately, e.g. Waiting-Blocking will reset
                back to Blocking.



                The Normal and Blocking cases apply to all nodes, while
                HasNoEffect is node specific; many nodes do not support this option.
                Plug-ins store state in the MPxNode::state attribute. Anyone can set
                it or check this attribute.  Additional details about each of these 3 states follow.




                State
                Description


                Normal
                The normal node state. This is the default.


                HasNoEffect


                The HasNoEffect option (a.k.a. pass-through), is used in cases where
                there is an operation on an input producing an output of the same data type.
                Nearly all deformers support this state, as do a few other nodes.
                As stated earlier, it is not supported by all nodes.


                Itâ€™s typical to implement support for the HasNoEffect state in
                the nodeâ€™s compute method and to perform appropriate operations.
                Plug-ins can also support HasNoEffect.


                The usual implementation of this state is to copy the input directly to the
                matching output without applying the algorithm in the node. For deformers,
                applying this state leaves the input geometry undeformed on the output.




                Blocking


                This is implemented in the depend node base class and applies to all nodes.
                Blocking is applied during the evaluation phase to connections.
                An evaluation request to a blocked connection will return as failures,
                causing the destination plug to retain its current value. Dirty propagation
                is indirectly affected by this state since blocked connections are never cleaned.


                When a node is set to Blocking the behavior is supposed to be the same as
                if all outgoing connections were broken. As long as nobody requests evaluation
                of the blocked node directly it wonâ€™t evaluate after that. Note that a blocked
                node will still respond to getAttr requests but a getAttr on a
                downstream node will not reevaluate the blocked node.


                Setting the root transform of a hierarchy to Blocking wonâ€™t automatically
                influence child transforms in the hierarchy. To do this, youâ€™d need to
                explicitly set all child nodes to the Blocking state.


                For example, to set all child transforms to Blocking, you could use the
                following script.



                import maya.cmds as cmds
                def blockTree(root):
                nodesToBlock = []
                for node in {child:1 for child in cmds.listRelatives( root, path=True, allDescendents=True )}.keys():
                nodesToBlock += cmds.listConnections(node, source=True, destination=True )
                for node in {source:1 for source in nodesToBlock}.keys():
                cmds.setAttr( '%s.nodeState' % node, 2 )



                Applying this script would continue to draw objects but things would not be animated.




                Default: kdnNormal
                Properties: create, query, edit
        parameter (float?): The parameter value for the positioning of the newly inserted knot.
                Default: 0.1
                Properties: create, query, edit
        preserveShape (int?): 0. without preserving the shape
                1. preserve shape
                2. blend
                Default: 1
                Properties: create, query, edit
        constructionHistory (bool?): Turn the construction history on or off.
                Properties: create
        name (str?): Sets the name of the newly-created node. If it contains
                namespace path, the new node will be created under the
                specified namespace; if the namespace does not exist, it
                will be created.
                Properties: create
        object (bool?): Create the result, or just the dependency node.
                Properties: create
        replaceOriginal (bool?): Create "in place" (i.e., replace).
                Properties: create

    Returns:
        List[str]: Object name and node name

    Example:
    """

def cluster(*args: str, after: bool = ..., afterReference: bool = ..., before: bool = ..., bindState: bool = ..., components: bool = ..., deformerTools: bool = ..., envelope: float = ..., exclusive: str = ..., frontOfChain: bool = ..., geometry: str = ..., geometryIndices: bool = ..., ignoreSelected: bool = ..., includeHiddenSelections: bool = ..., name: str = ..., parallel: bool = ..., prune: bool = ..., relative: bool = ..., remove: bool = ..., resetGeometry: bool = ..., selectedComponents: bool = ..., split: bool = ..., useComponentTags: bool = ..., weightedNode: Tuple[str, str] = ...) -> List[str]:
    """The cluster command creates a cluster or edits the membership of
    an existing cluster. The command returns the name of the cluster
    node upon creation of a new cluster.After creating a cluster, the cluster's weights can be modified
    using the percent command or the set editor window.
    Args:
        after (bool?): If the default behavior for insertion/appending into/onto
                the existing chain is not the desired behavior then this flag
                can be used to force the command to place the deformer
                node after the selected node in the chain even if
                a new geometry shape has to be created in order to do so.
                Works in create mode (and edit mode if the deformer has
                no geometry added yet).
                Properties: create, edit
        afterReference (bool?): The -afterReference flag is used to specify deformer ordering in a hybrid way that
                choses between -before and -after automatically. If the geometry being
                deformed is referenced then the -after mode is used when adding the new deformer,
                otherwise the -before mode is used. The net effect when using -afterReference to build
                deformer chains is that internal shape nodes in the deformer chain will only
                appear at reference file boundaries, leading to lightweight deformer networks that
                may be more amicable to reference swapping.
                Properties: create, edit
        before (bool?): If the default behavior for insertion/appending into/onto
                the existing chain is not the desired behavior then this flag
                can be used to force the command to place the deformer
                node before the selected node in the chain even if
                a new geometry shape has to be created in order to do so.
                Works in create mode (and edit mode if the deformer has
                no geometry added yet).
                Properties: create, edit
        bindState (bool?): When turned on, this flag adds in a compensation to ensure
                the clustered objects preserve their spatial position
                when clustered. This is required to prevent the geometry
                from jumping at the time the cluster is created
                in situations when the
                cluster transforms at cluster time are not identity.
                Properties: create
        components (bool?): Returns the components used by the deformer
                Properties: query
        deformerTools (bool?): Returns the name of the deformer tool objects (if any)
                as string string ...
                Properties: query
        envelope (float?): Set the envelope value for the deformer. Default is 1.0
                Properties: create, query, edit
        exclusive (str?): Puts the deformation set in a deform partition.
                Properties: create, query
        frontOfChain (bool?): This command is used to specify that the new deformer
                node should be placed ahead (upstream) of existing deformer
                and skin nodes in the shape's history (but not ahead of
                existing tweak nodes). The input to the
                deformer will be the upstream shape rather than the visible
                downstream shape, so the behavior of this flag is the most
                intuitive if the downstream deformers are in their reset
                (hasNoEffect) position when the new deformer is added.
                Works in create mode (and edit mode if the deformer has
                no geometry added yet).
                Properties: create, edit
        geometry (str?): The specified object will be added to the list of
                objects being deformed by this deformer object, unless
                the -rm flag is also specified. When queried, this flag
                returns string string string ...
                Properties: query, edit, multiuse
        geometryIndices (bool?): Complements the -geometry flag in query mode. Returns
                the multi index of each geometry.
                Properties: query
        ignoreSelected (bool?): Tells the command to not deform objects on the
                current selection list
                Properties: create
        includeHiddenSelections (bool?): Apply the deformer to any visible and hidden objects in the selection list.
                Default is false.
                Properties: create
        name (str?): Used to specify the name of the node being created.
                Properties: create
        parallel (bool?): Inserts the new deformer in a parallel chain to any existing deformers in
                the history of the object. A blendShape is inserted to blend the parallel
                results together.
                Works in create mode (and edit mode if the deformer has
                no geometry added yet).
                Properties: create, edit
        prune (bool?): Removes any points not being deformed by the deformer in
                its current configuration from the deformer set.
                Properties: edit
        relative (bool?): Enable relative mode for the cluster. In relative mode,
                Only the transformations directly above the cluster are used
                by the cluster. Default is off.
                Properties: create
        remove (bool?): Specifies that objects listed after the -g flag should
                be removed from this deformer.
                Properties: edit, multiuse
        resetGeometry (bool?): Reset the geometry matrices for the objects being deformed
                by the cluster. This flag is used to get rid of undesirable
                effects that happen if you scale an object that
                is deformed by a cluster.
                Properties: edit
        selectedComponents (bool?): Returns the components used by the deformer that are currently selected.
                This intersects the current selection with the components affected by the deformer.
                Properties: query
        split (bool?): Branches off a new chain in the dependency graph instead
                of inserting/appending the deformer into/onto an
                existing chain.
                Works in create mode (and edit mode if the deformer has
                no geometry added yet).
                Properties: create, edit
        useComponentTags (bool?): When this flag is specified a setup using componentTags will be created.
                This means no groupId, groupParts, tweak or objectSet nodes will be
                created and connected to the new deformer.
                Properties: create
        weightedNode (Tuple[str, str]?): Transform node in the DAG above the cluster to which all percents are
                applied. The second DAGobject specifies the descendent of the first
                DAGobject from where the transformation matrix is evaluated. Default is
                the cluster handle.
                Properties: create, query, edit

    Returns:
        List[str]: (the cluster node name and the cluster handle name)

    Example:
    """

def cmdFileOutput(close: Unknown = ..., closeAll: bool = ..., open: str = ..., status: Unknown = ...) -> int:
    """This command will open a text file to receive all of the commands
    and results that normally get printed to the Script Editor
    window or console. The file will stay open until an explicit -close
    with the correct file descriptor or a -closeAll, so care should be
    taken not to leave a file open.To enable logging to commence as soon as Maya starts up, the
    environment variable MAYA_CMD_FILE_OUTPUT may be specified prior
    to launching Maya. Setting MAYA_CMD_FILE_OUTPUT to a filename
    will create and output to that given file. To access the descriptor
    after Maya has started, use the -query and -open flags together.
    Args:
        close (Unknown?): Closes the file corresponding to the given descriptor.
                If -3 is returned, the file did not exist. -1 is returned
                on error, 0 is returned on successful close.
                Properties: create
        closeAll (bool?): Closes all open files.
                Properties: create
        open (str?): Opens the given file for writing (will overwrite if it exists
                and is writable). If successful, a value is returned to enable
                status queries and file close. -1 is returned if the file cannot
                be opened for writing. The -open flag can also be specified in
                -query mode. In query mode, if the named file is currently opened,
                the descriptor for the specified file is returned, otherwise -1 is
                returned. This is an easy way to check if a given file is
                currently open.
                      In query mode, this flag needs a value.
                Properties: create, query
        status (Unknown?): Queries the status of the given descriptor. -3 is returned
                if no such file exists, -2 indicates the file is not open,
                -1 indicates an error condition, 0 indicates file is ready
                for writing.
                Properties: create, query

    Returns:
        int: : On open, returns a value (descriptor) that can be used to query
            the status or close the file. Otherwise, a status code
            indicating status of file

    Example:
    """

def cmdScrollFieldExecuter(arg0: str, /, annotation: str = ..., appendText: str = ..., autoCloseBraces: bool = ..., backgroundColor: Tuple[float, float, float] = ..., clear: bool = ..., commandCompletion: bool = ..., copySelection: bool = ..., currentLine: Unknown = ..., cutSelection: bool = ..., defineTemplate: str = ..., docTag: str = ..., dragCallback: Callable = ..., dropCallback: Callable = ..., enable: bool = ..., enableBackground: bool = ..., enableKeyboardFocus: bool = ..., execute: bool = ..., executeAll: bool = ..., exists: bool = ..., fileChangedCommand: Callable = ..., filename: bool = ..., filterKeyPress: Callable = ..., fullPathName: bool = ..., hasFocus: bool = ..., hasSelection: bool = ..., height: int = ..., highlightColor: Tuple[float, float, float] = ..., insertText: str = ..., isObscured: bool = ..., load: bool = ..., loadContents: str = ..., loadFile: str = ..., manage: bool = ..., modificationChangedCommand: Callable = ..., modified: bool = ..., noBackground: bool = ..., numberOfLines: Unknown = ..., numberOfPopupMenus: bool = ..., objectPathCompletion: bool = ..., parent: str = ..., pasteSelection: bool = ..., popupMenuArray: bool = ..., preventOverride: bool = ..., redo: bool = ..., removeStoredContents: str = ..., replaceAll: Tuple[str, str] = ..., saveFile: str = ..., saveSelection: str = ..., saveSelectionToShelf: bool = ..., searchAndSelect: bool = ..., searchDown: bool = ..., searchMatchCase: bool = ..., searchString: str = ..., searchWraps: bool = ..., select: Tuple[Unknown, Unknown] = ..., selectAll: bool = ..., selectedText: bool = ..., showLineNumbers: bool = ..., showTabsAndSpaces: bool = ..., showTooltipHelp: bool = ..., source: bool = ..., sourceType: str = ..., spacesPerTab: Unknown = ..., statusBarMessage: str = ..., storeContents: str = ..., tabsForIndent: bool = ..., text: str = ..., textLength: bool = ..., undo: bool = ..., useTemplate: str = ..., visible: bool = ..., visibleChangeCommand: Callable = ..., width: int = ...) -> str:
    """A script editor executer control used to issue script commands to
    Maya.
    Args:
        annotation (str?): Annotate the control with an extra string value.
                Properties: create, query, edit
        appendText (str?): Appends text to the end of this field.
                Properties: create, edit
        autoCloseBraces (bool?): Specifies whether a closing brace should automatically be added when
                hitting enter after an opening brace. (default on)
                Properties: create, query, edit
        backgroundColor (Tuple[float, float, float]?): The background color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                When setting backgroundColor, the background is automatically
                enabled, unless enableBackground is also specified with a false
                value.
                Properties: create, query, edit
        clear (bool?): Clears the field.
                Properties: create, edit
        commandCompletion (bool?): Enable/disable command completion
                Properties: create, query, edit
        copySelection (bool?): Copies the current selection from this field.
                Properties: create, edit
        currentLine (Unknown?): Sets/returns the current line which the cursor is on.
                Properties: create, query, edit
        cutSelection (bool?): Cuts the current selection from this field.
                Properties: create, edit
        defineTemplate (str?): Puts the command in a mode where any other flags and arguments are
                parsed and added to the command template specified in the argument.
                They will be used as default arguments in any subsequent
                invocations of the command when templateName is set as the
                current template.
                Properties: create
        docTag (str?): Add a documentation flag to the control.  The documentation flag
                has a directory structure.
                (e.g., -dt render/multiLister/createNode/material)
                Properties: create, query, edit
        dragCallback (Callable?): Adds a callback that is called when the middle mouse button
                is pressed.  The MEL version of the callback is of the form:

                global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods)

                The proc returns a string array that is transferred to the drop site.
                By convention the first string in the array describes the user settable
                message type.  Controls that are application defined drag sources may
                ignore the callback. $mods allows testing for the key modifiers CTRL and
                SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL,
                3 == CTRL + SHIFT.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def callbackName( dragControl, x, y, modifiers ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "x", "y", "modifiers".  The
                "dragControl" value is a string and the other values are integers (eg the
                callback string could be "print '%(dragControl)s %(x)d %(y)d %(modifiers)d'")
                Properties: create, edit
        dropCallback (Callable?): Adds a callback that is called when a drag and drop
                operation is released above the drop site.  The MEL version of the callback is
                of the form:

                global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type)

                The proc receives a string array that is transferred from the drag source.
                The first string in the msgs array describes the user defined message type.
                Controls that are application defined drop sites may ignore the
                callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "dropControl", "messages", "x", "y",
                "type".  The "dragControl" value is a string and the other values are integers
                (eg the callback string could be
                "print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'")
                Properties: create, edit
        enable (bool?): The enable state of the control.  By default, this flag is
                set to true and the control is enabled.  Specify false and the control
                will appear dimmed or greyed-out indicating it is disabled.
                Properties: create, query, edit
        enableBackground (bool?): Enables the background color of the control.
                Properties: create, query, edit
        enableKeyboardFocus (bool?): If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse.
                This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls.
                If disabled, text in text fields can still be selected with the mouse but cannot be copied (except on Linux when "Middle Click Paste" is enabled).
                Properties: create, query, edit
        execute (bool?): Executes the current selection.  If there is no selection, all text is executed.
                Properties: create, edit
        executeAll (bool?): Executes all text.
                Properties: create, edit
        exists (bool?): Returns whether the
                specified object exists or not. Other flags are ignored.
                Properties: create
        fileChangedCommand (Callable?): Only valid when this field contains a file.
                Sets a script which will be called whenever the file is externally modified,
                renamed or removed from disk.
                In MEL, the function should have the following signature:

                proc fileChanged(string $file)
                Properties: create, edit
        filename (bool?): Returns the full path + filename of the script which was either loaded or saved.
                If there isn't one returns an empty string.
                Properties: query
        filterKeyPress (Callable?): Sets a script which will be called to handle key-press events.
                The function should have the following signature:

                proc int filterKeyPress(int $modifiers, string $key)

                modifiers: a bit mask where Shift is bit 1, Ctrl is bit 3,
                Alt is bit 4, and bit 5 is the 'Windows' key on Windows keyboards
                and the Command key on Mac keyboards.

                key: Specifies what key was pressed. The key is either a single
                ascii character or one of the keyword strings for the special
                keyboard characters. For example:
                Up, Down, Right, Left,
                Home, End, Page_Up, Page_Down, Insert
                Return, Space
                F1 to F12

                The function should return 1 to indicate that they key event has been
                handled, and 0 to indicate that it has not been handled.
                Properties: create, query, edit
        fullPathName (bool?): Return the full path name of the widget, which includes all the parents.
                Properties: query
        hasFocus (bool?): Whether this control is currently in focus.
                Properties: query
        hasSelection (bool?): Whether this control currently has a selection or not.
                Properties: query
        height (int?): The height of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit
        highlightColor (Tuple[float, float, float]?): The highlight color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                Properties: create, query, edit
        insertText (str?): Inserts the specified text into the position under the cursor,
                replacing any currently selected text. The selection and cursor
                position can be set using the select flag. Appends text to the
                end of this field.
                Properties: create, edit
        isObscured (bool?): Return whether the control can actually be seen by the user.
                The control will be obscured if its state is invisible, if it is
                blocked (entirely or partially) by some other control, if it or a
                parent layout is unmanaged, or if the control's window is
                invisible or iconified.
                Properties: query
        load (bool?): Prompts the user for a script to load into this field.  The loaded filename becomes
                associated with this executer field and saving will save directly to the file.
                Properties: create, edit
        loadContents (str?): Loads the contents of the specified filename into this field.  The path and extension for this filename
                is provided internally.  This command is only intended for loading the contents of this executer field from a previous
                instance of this executer field.
                Properties: create, edit
        loadFile (str?): If the provided string is a fully specified file path, then attempts to load the
                file contents into this field.  If the string is empty or not valid then prompts
                the user for a script to load into this field.  In both cases the filename becomes
                associated with this executer field and saving will save directly to the file.
                Properties: create, edit
        manage (bool?): Manage state of the control.  An unmanaged control is
                not visible, nor does it take up any screen real estate.  All
                controls are created managed by default.
                Properties: create, query, edit
        modificationChangedCommand (Callable?): Sets a script which will be called whenever the content of this field changes in
                a way that affects the modification state.
                In MEL, the function should have the following signature:

                proc modificationChanged(int $m)

                If $m is true, the field has been modified; otherwise it is false.
                Properties: create, edit
        modified (bool?): Sets or returns whether the field has been modified.
                Properties: query, edit
        noBackground (bool?): Clear/reset the control's background.
                Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.
                Properties: create, edit
        numberOfLines (Unknown?): Returns the total number of lines in the document.
                Properties: query
        numberOfPopupMenus (bool?): Return the number of popup menus attached to this control.
                Properties: query
        objectPathCompletion (bool?): Enable/disable path completion
                Properties: create, query, edit
        parent (str?): The parent layout for this control.
                Properties: create, query
        pasteSelection (bool?): Pastes text into this field at the current caret position.
                Properties: create, edit
        popupMenuArray (bool?): Return the names of all the popup menus attached to this
                control.
                Properties: query
        preventOverride (bool?): If true, this flag prevents overriding the control's
                attribute via the control's right mouse button menu.
                Properties: create, query, edit
        redo (bool?): Redo the last operation.
                Properties: create, edit
        removeStoredContents (str?): Removes the stored contents of this field with the specified filename.  The path and extension for the file is
                provided internally.  This command is only intended for removing previously stored contents of this executer field.
                Properties: create, edit
        replaceAll (Tuple[str, str]?): Replaces all instances of the first string in the field text with the
                second string.  The case sensitivity of this operation is set with the
                -searchMatchCase flag.
                Properties: create, edit
        saveFile (str?): Saves the entire script contents of this field directly to the specified file path.
                Properties: create, edit
        saveSelection (str?): Prompts to save the current selection to a file.  The default filename prompt will be prepended with the given string.
                Properties: create, edit
        saveSelectionToShelf (bool?): Prompts to save the current selection to an item in the shelf.
                Properties: create, edit
        searchAndSelect (bool?): Searches for (and selects) the specified search string using the
                specified search options.
                Properties: query
        searchDown (bool?): Specifies whether to search from the cursor down, or up.
                Properties: create, query, edit
        searchMatchCase (bool?): Specifies whether the search is to be case sensitive or not.
                Properties: create, query, edit
        searchString (str?): Specifies the string to search for.
                Properties: create, query, edit
        searchWraps (bool?): Specifies whether the search should wrap around.
                Properties: create, query, edit
        select (Tuple[Unknown, Unknown]?): Selects text within a specified range.
                Properties: create, edit
        selectAll (bool?): Selects all text.
                Properties: create, edit
        selectedText (bool?): The text in the current selection range.
                Properties: query
        showLineNumbers (bool?): Shows/hides the line numbes column.
                Properties: create, query, edit
        showTabsAndSpaces (bool?): Visually show tab and space indicators. (default off)
                Properties: create, query, edit
        showTooltipHelp (bool?): Enable/disable tooltips in the command execution window
                Properties: create, query, edit
        source (bool?): Prompts the user for a script to source (execute without loading).
                Properties: create, edit
        sourceType (str?): Sets the source type for this command executer field.
                Valid values are "mel" (enabled by default)
                and "python".
                Properties: create, query
        spacesPerTab (Unknown?): Specifies the number of spaces equivalent to one tab stop. (default 4)
                Properties: create, query, edit
        statusBarMessage (str?): Extra string to display in the status bar when the mouse is over the control.
                Properties: create, edit
        storeContents (str?): If the provided string is a fully specified file path, then attempts to store the contents of this field
                to that path. Otherwise, uses the provided string as a filename only and uses an internally generated
                path and extension for the file, as used by the -loadContents and -removeStoredContents flags.
                In both cases, a new unique filename will be generated if the specified name exists.
                Returns the filename of the file saved upon completion, and an empty string otherwise.
                Properties: create, edit
        tabsForIndent (bool?): Specifies whether tab characters should be inserted when indenting. (default on)
                Properties: create, query, edit
        text (str?): Replaces the field text with the given string.
                Properties: create, query, edit
        textLength (bool?): The number of characters in this text field.
                Properties: query
        undo (bool?): Undo the last operation.
                Properties: create, edit
        useTemplate (str?): Forces the command to use a command template other than
                the current one.
                Properties: create
        visible (bool?): The visible state of the control.  A control is created
                visible by default.  Note that a control's actual appearance is
                also dependent on the visible state of its parent layout(s).
                Properties: create, query, edit
        visibleChangeCommand (Callable?): Command that gets executed when visible state of the control changes.
                Properties: create, query, edit
        width (int?): The width of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit

    Returns:
        str: The name of the executer control

    Example:
    """

def cmdScrollFieldReporter(arg0: str, /, annotation: str = ..., backgroundColor: Tuple[float, float, float] = ..., clear: bool = ..., copySelection: bool = ..., cutSelection: bool = ..., defineTemplate: str = ..., docTag: str = ..., dragCallback: Callable = ..., dropCallback: Callable = ..., echoAllCommands: bool = ..., enable: bool = ..., enableBackground: bool = ..., enableKeyboardFocus: bool = ..., exists: bool = ..., filterSourceType: str = ..., fullPathName: bool = ..., hasFocus: bool = ..., height: int = ..., highlightColor: Tuple[float, float, float] = ..., isObscured: bool = ..., lineNumbers: bool = ..., manage: bool = ..., noBackground: bool = ..., numberOfPopupMenus: bool = ..., parent: str = ..., pasteSelection: bool = ..., popupMenuArray: bool = ..., preventOverride: bool = ..., receiveFocusCommand: Callable = ..., saveSelection: str = ..., saveSelectionToShelf: bool = ..., select: Tuple[Unknown, Unknown] = ..., selectAll: bool = ..., stackTrace: bool = ..., statusBarMessage: str = ..., suppressErrors: bool = ..., suppressInfo: bool = ..., suppressResults: bool = ..., suppressStackTrace: bool = ..., suppressWarnings: bool = ..., text: str = ..., textLength: bool = ..., useTemplate: str = ..., visible: bool = ..., visibleChangeCommand: Callable = ..., width: int = ...) -> str:
    """A script editor reporter control used to receive and display the history of processed commmands.
    Args:
        annotation (str?): Annotate the control with an extra string value.
                Properties: create, query, edit
        backgroundColor (Tuple[float, float, float]?): The background color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                When setting backgroundColor, the background is automatically
                enabled, unless enableBackground is also specified with a false
                value.
                Properties: create, query, edit
        clear (bool?): Clears the field.
                Properties: create, edit
        copySelection (bool?): Copies the current selection from this field.
                Properties: create, edit
        cutSelection (bool?): Cuts the current selection from this field.
                Properties: create, edit
        defineTemplate (str?): Puts the command in a mode where any other flags and arguments are
                parsed and added to the command template specified in the argument.
                They will be used as default arguments in any subsequent
                invocations of the command when templateName is set as the
                current template.
                Properties: create
        docTag (str?): Add a documentation flag to the control.  The documentation flag
                has a directory structure.
                (e.g., -dt render/multiLister/createNode/material)
                Properties: create, query, edit
        dragCallback (Callable?): Adds a callback that is called when the middle mouse button
                is pressed.  The MEL version of the callback is of the form:

                global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods)

                The proc returns a string array that is transferred to the drop site.
                By convention the first string in the array describes the user settable
                message type.  Controls that are application defined drag sources may
                ignore the callback. $mods allows testing for the key modifiers CTRL and
                SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL,
                3 == CTRL + SHIFT.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def callbackName( dragControl, x, y, modifiers ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "x", "y", "modifiers".  The
                "dragControl" value is a string and the other values are integers (eg the
                callback string could be "print '%(dragControl)s %(x)d %(y)d %(modifiers)d'")
                Properties: create, edit
        dropCallback (Callable?): Adds a callback that is called when a drag and drop
                operation is released above the drop site.  The MEL version of the callback is
                of the form:

                global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type)

                The proc receives a string array that is transferred from the drag source.
                The first string in the msgs array describes the user defined message type.
                Controls that are application defined drop sites may ignore the
                callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "dropControl", "messages", "x", "y",
                "type".  The "dragControl" value is a string and the other values are integers
                (eg the callback string could be
                "print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'")
                Properties: create, edit
        echoAllCommands (bool?): Echo all commands.    (Global parameter, affects all command reporters)
                Properties: create, query, edit
        enable (bool?): The enable state of the control.  By default, this flag is
                set to true and the control is enabled.  Specify false and the control
                will appear dimmed or greyed-out indicating it is disabled.
                Properties: create, query, edit
        enableBackground (bool?): Enables the background color of the control.
                Properties: create, query, edit
        enableKeyboardFocus (bool?): If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse.
                This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls.
                If disabled, text in text fields can still be selected with the mouse but cannot be copied (except on Linux when "Middle Click Paste" is enabled).
                Properties: create, query, edit
        exists (bool?): Returns whether the
                specified object exists or not. Other flags are ignored.
                Properties: create
        filterSourceType (str?): Filters the specified source type from showing in this command reporter.
                Currently supports either "mel", "python", or "" (default).
                Setting the filter to the empty string ("") will remove all filtering and show both "mel" and "python" results.
                Properties: create, query, edit
        fullPathName (bool?): Return the full path name of the widget, which includes all the parents.
                Properties: query
        hasFocus (bool?): Whether this control is currently in focus.
                Properties: query
        height (int?): The height of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit
        highlightColor (Tuple[float, float, float]?): The highlight color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                Properties: create, query, edit
        isObscured (bool?): Return whether the control can actually be seen by the user.
                The control will be obscured if its state is invisible, if it is
                blocked (entirely or partially) by some other control, if it or a
                parent layout is unmanaged, or if the control's window is
                invisible or iconified.
                Properties: query
        lineNumbers (bool?): Show line numbers (in Error/Warning messages).    (Global parameter, affects all command reporters)
                Properties: create, query, edit
        manage (bool?): Manage state of the control.  An unmanaged control is
                not visible, nor does it take up any screen real estate.  All
                controls are created managed by default.
                Properties: create, query, edit
        noBackground (bool?): Clear/reset the control's background.
                Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.
                Properties: create, edit
        numberOfPopupMenus (bool?): Return the number of popup menus attached to this control.
                Properties: query
        parent (str?): The parent layout for this control.
                Properties: create, query
        pasteSelection (bool?): Pastes text into this field at the current caret position.
                Properties: create, edit
        popupMenuArray (bool?): Return the names of all the popup menus attached to this
                control.
                Properties: query
        preventOverride (bool?): If true, this flag prevents overriding the control's
                attribute via the control's right mouse button menu.
                Properties: create, query, edit
        receiveFocusCommand (Callable?): Command executed when the field receives focus.
                Properties: create, edit
        saveSelection (str?): Prompts to save the current selection to a file. The default filename prompt will be prepended with the given string.
                Properties: create, edit
        saveSelectionToShelf (bool?): Prompts to save the current selection to an item in the shelf.
                Properties: create, edit
        select (Tuple[Unknown, Unknown]?): Selects text within a specified range.
                Properties: create, edit
        selectAll (bool?): Selects all text.
                Properties: create, edit
        stackTrace (bool?): Show stack trace.    (Global parameter, affects all command reporters)
                Properties: create, query, edit
        statusBarMessage (str?): Extra string to display in the status bar when the mouse is over the control.
                Properties: create, edit
        suppressErrors (bool?): Suppress errors.
                Properties: create, query, edit
        suppressInfo (bool?): Suppress info.
                Properties: create, query, edit
        suppressResults (bool?): Suppress results.
                Properties: create, query, edit
        suppressStackTrace (bool?): Suppress stack trace.
                Properties: create, query, edit
        suppressWarnings (bool?): Suppress warnings.
                Properties: create, query, edit
        text (str?): Replaces the field text with the given string.
                Properties: create, query, edit
        textLength (bool?): The number of characters in this text field.
                Properties: query
        useTemplate (str?): Forces the command to use a command template other than
                the current one.
                Properties: create
        visible (bool?): The visible state of the control.  A control is created
                visible by default.  Note that a control's actual appearance is
                also dependent on the visible state of its parent layout(s).
                Properties: create, query, edit
        visibleChangeCommand (Callable?): Command that gets executed when visible state of the control changes.
                Properties: create, query, edit
        width (int?): The width of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit

    Returns:
        str: The name of the reporter control

    Example:
    """

def cmdShell(arg0: str, /, annotation: str = ..., backgroundColor: Tuple[float, float, float] = ..., clear: bool = ..., command: str = ..., defineTemplate: str = ..., docTag: str = ..., dragCallback: Callable = ..., dropCallback: Callable = ..., enable: bool = ..., enableBackground: bool = ..., enableKeyboardFocus: bool = ..., exists: bool = ..., fullPathName: bool = ..., height: int = ..., highlightColor: Tuple[float, float, float] = ..., isObscured: bool = ..., manage: bool = ..., noBackground: bool = ..., numberOfHistoryLines: int = ..., numberOfPopupMenus: bool = ..., numberOfSavedLines: int = ..., parent: str = ..., popupMenuArray: bool = ..., preventOverride: bool = ..., prompt: str = ..., statusBarMessage: str = ..., useTemplate: str = ..., visible: bool = ..., visibleChangeCommand: Callable = ..., width: int = ...) -> str:
    """This command creates a scrolling field that behaves similar to
    a unix shell for entering user input.  You may specify the number
    of lines that will be remembered by the field with
    the -nsl/numberOfSavedLines flag.  The default number of lines saved
    is 100.  The shellField also maintains a command history buffer.
    You can specify the number of input lines that will be saved with
    the -hlc/historyLineCount flag.  The default size of this buffer is 10.
    Args:
        annotation (str?): Annotate the control with an extra string value.
                Properties: create, query, edit
        backgroundColor (Tuple[float, float, float]?): The background color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                When setting backgroundColor, the background is automatically
                enabled, unless enableBackground is also specified with a false
                value.
                Properties: create, query, edit
        clear (bool?): Erases all visible text, and also deletes any text that had
                scrolled of the top of the field.  After clearing the field
                it will be blank, and you will not be able to scroll up to
                see previous lines.  This flag does not affect the command
                history buffer, however.
                Properties: create
        command (str?): Command executed when the contents change.
                Properties: create, query, edit
        defineTemplate (str?): Puts the command in a mode where any other flags and arguments are
                parsed and added to the command template specified in the argument.
                They will be used as default arguments in any subsequent
                invocations of the command when templateName is set as the
                current template.
                Properties: create
        docTag (str?): Add a documentation flag to the control.  The documentation flag
                has a directory structure.
                (e.g., -dt render/multiLister/createNode/material)
                Properties: create, query, edit
        dragCallback (Callable?): Adds a callback that is called when the middle mouse button
                is pressed.  The MEL version of the callback is of the form:

                global proc string[] callbackName(string $dragControl, int $x, int $y, int $mods)

                The proc returns a string array that is transferred to the drop site.
                By convention the first string in the array describes the user settable
                message type.  Controls that are application defined drag sources may
                ignore the callback. $mods allows testing for the key modifiers CTRL and
                SHIFT. Possible values are 0 == No modifiers, 1 == SHIFT, 2 == CTRL,
                3 == CTRL + SHIFT.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def callbackName( dragControl, x, y, modifiers ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "x", "y", "modifiers".  The
                "dragControl" value is a string and the other values are integers (eg the
                callback string could be "print '%(dragControl)s %(x)d %(y)d %(modifiers)d'")
                Properties: create, edit
        dropCallback (Callable?): Adds a callback that is called when a drag and drop
                operation is released above the drop site.  The MEL version of the callback is
                of the form:

                global proc callbackName(string $dragControl, string $dropControl, string $msgs[], int $x, int $y, int $type)

                The proc receives a string array that is transferred from the drag source.
                The first string in the msgs array describes the user defined message type.
                Controls that are application defined drop sites may ignore the
                callback. $type can have values of 1 == Move, 2 == Copy, 3 == Link.

                In Python, it is similar, but there are two ways to specify the callback.  The
                recommended way is to pass a Python function object as the argument.  In that
                case, the Python callback should have the form:

                def pythonDropTest( dragControl, dropControl, messages, x, y, dragType ):

                The values of these arguments are the same as those for the MEL version above.

                The other way to specify the callback in Python is to specify a string to be
                executed.  In that case, the string will have the values substituted into it
                via the standard Python format operator.  The format values are passed in a
                dictionary with the keys "dragControl", "dropControl", "messages", "x", "y",
                "type".  The "dragControl" value is a string and the other values are integers
                (eg the callback string could be
                "print '%(dragControl)s %(dropControl)s %(messages)r %(x)d %(y)d %(type)d'")
                Properties: create, edit
        enable (bool?): The enable state of the control.  By default, this flag is
                set to true and the control is enabled.  Specify false and the control
                will appear dimmed or greyed-out indicating it is disabled.
                Properties: create, query, edit
        enableBackground (bool?): Enables the background color of the control.
                Properties: create, query, edit
        enableKeyboardFocus (bool?): If enabled, the user can navigate to the control with the tab key and select values with the keyboard or mouse.
                This flag would typically be used to turn off focus support from controls that get it by default, like Edit and List controls.
                If disabled, text in text fields can still be selected with the mouse but cannot be copied (except on Linux when "Middle Click Paste" is enabled).
                Properties: create, query, edit
        exists (bool?): Returns whether the
                specified object exists or not. Other flags are ignored.
                Properties: create
        fullPathName (bool?): Return the full path name of the widget, which includes all the parents.
                Properties: query
        height (int?): The height of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit
        highlightColor (Tuple[float, float, float]?): The highlight color of the control. The arguments correspond
                to the red, green, and blue color components. Each component ranges
                in value from 0.0 to 1.0.
                Properties: create, query, edit
        isObscured (bool?): Return whether the control can actually be seen by the user.
                The control will be obscured if its state is invisible, if it is
                blocked (entirely or partially) by some other control, if it or a
                parent layout is unmanaged, or if the control's window is
                invisible or iconified.
                Properties: query
        manage (bool?): Manage state of the control.  An unmanaged control is
                not visible, nor does it take up any screen real estate.  All
                controls are created managed by default.
                Properties: create, query, edit
        noBackground (bool?): Clear/reset the control's background.
                Passing true means the background should not be drawn at all, false means the background should be drawn.  The state of this flag is inherited by children of this control.
                Properties: create, edit
        numberOfHistoryLines (int?): The number of input lines to be saved in the
                command history buffer.  You can cycle through this buffer by
                pressing the up and down arrow keys.  Valid values are 0 through
                32767.  Any value less than 0 will be handled as if 0 was
                specified.  Similarly, any value greater than 32767 will be
                handled as if 32767 was specified.
                Properties: create, query, edit
        numberOfPopupMenus (bool?): Return the number of popup menus attached to this control.
                Properties: query
        numberOfSavedLines (int?): The total number of lines (the scrolled lines and
                currently visible lines) that will be remembered by the field.
                Any lines beyond this number will be lost, and the user will not
                be able to review them by scrolling.  Valid values are 1 through
                32767.  Any value less than 1 will be handled as if 1 was
                specified.  Similarly, any value greater than 32767 will be
                handled as if 32767 was specified.
                Properties: create, query, edit
        parent (str?): The parent layout for this control.
                Properties: create, query
        popupMenuArray (bool?): Return the names of all the popup menus attached to this
                control.
                Properties: query
        preventOverride (bool?): If true, this flag prevents overriding the control's
                attribute via the control's right mouse button menu.
                Properties: create, query, edit
        prompt (str?): The text that is used as a prompt.
                Properties: create, query, edit
        statusBarMessage (str?): Extra string to display in the status bar when the mouse is over the control.
                Properties: create, edit
        useTemplate (str?): Forces the command to use a command template other than
                the current one.
                Properties: create
        visible (bool?): The visible state of the control.  A control is created
                visible by default.  Note that a control's actual appearance is
                also dependent on the visible state of its parent layout(s).
                Properties: create, query, edit
        visibleChangeCommand (Callable?): Command that gets executed when visible state of the control changes.
                Properties: create, query, edit
        width (int?): The width of the control.  The control will attempt to
                be this size if it is not overruled by parent layout conditions.
                Properties: create, query, edit

    Returns:
        str: Full path name to the control.

    Example:
    """

def coarsenSubdivSelectionList(*args: Any) -> bool:
    """Coarsens a subdivision surface set of components based on the selection list. The
    selected components are selected at a coarser level.subdivision, surface, select, region, coarsen, level, coarse, fine
    Returns:
        bool: Command result

    Example:
    """

def collision(*args: str, friction: float = ..., name: str = ..., offset: float = ..., resilience: float = ...) -> List[str]:
    """For each listed object, the command creates a new field.
    The field has a shape which lives in the DAG and it has an associated
    dependency node. The field is added to the list of fields owned
    by the object. Use connectDynamic to cause the field to affect a dynamic
    object. Note that if more than one object is listed, a separate field is
    created for each object.If fields are created, this command returns the names of each
    owning shape and of the field shapes themselves. If a field was queried,
    the results of the query are returned. If a field was edited, the field
    name is returned.If no object names are provided but the active selection list is non-empty,
    the command creates a field for every object in the list. If the
    list is empty, the command defaults to -pos 0 0 0.
    The collision command causes particles to collide with geo