# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['simpute_py']

package_data = \
{'': ['*']}

install_requires = \
['pandas>=1.5,<2.0', 'scikit-learn>=1.1,<2.0']

setup_kwargs = {
    'name': 'simpute-py',
    'version': '0.0.4',
    'description': 'A python package for simple data imputation',
    'long_description': '![](logo.png)\n\n### What does it do?\nHave you ever had a time when your missing data was holding you back? Well then this package is for you!\n\nOur python package for simple data imputation will allow you to quickly and seamlessly impute any missing data (be numeric, categorical, date/time or boolean values) using any large datasets.\n\nAll you have to do is follow these simple 4 steps:\n 1. Import the package and the data you wish you impute\n 2. Select the function and method for imputation (this will depend on the data type - read the usage section below for more details)\n 3. Hit run\n 4. Save your newly imputed dataset\n\nOur package will help simplify all your imputation needs so your data is ready when you need it!\n\n## Contributors & Maintainers\n- [Lisa Sequeira](https://github.com/LisaSeq)\n- [Renee Kwon](https://github.com/renee-kwon)\n- [Fujie Sun](https://github.com/Althrun-sun)\n- [Ken Wang](https://github.com/kenuiuc)\n\n## Installation\n\n```bash\n$ pip install simpute_py\n```\n\n## Usage\n\nWe have four main functions dealing with each data type:\n- `Num_imputer`: This function fills in the empty values of a numeric column with values derived from your selected imputation method. Your options for method include _knn_ (autogenerated values based on KNN), _mean_, _median_ and _mode_.\n- `Cat_imputer`: This function fills in the empty values of a categorical column with values derived based on most frequent (mode) category.\n- `Bol_imputer`: This function fills in the empty values of a boolean column with values derived using most frequent (mode) boolean value.\n- `Date_imputer`: This function fills in empty values of a date column with median point of the range of dates in that column.\n\n## Place in the Python Ecosystem\n\nCurrently, there are many other ways you can impute a dataset, using various functions build within Python, but this packages it neatly into one place and simplifies the process. We do have other packages you can use such as [AutoImpute](https://pypi.org/project/autoimpute/) and [MIDASpy](https://github.com/MIDASverse/MIDASpy). However our package aims to provide functionality not provided in either package and for more general audience use.\n\n## Contributing\n\nInterested in contributing? Check out the contributing guidelines. Please note that this project is released with a Code of Conduct. By contributing to this project, you agree to abide by its terms.\n\n## License\n\n`simpute_py` was created by Lisa Sequeira, Renee Kwon, Fujie Sun, and Ken Wang. It is licensed under the terms of the MIT license.\n\n## Credits\n\n`simpute_py` was created with [`cookiecutter`](https://cookiecutter.readthedocs.io/en/latest/) and the `py-pkgs-cookiecutter` [template](https://github.com/py-pkgs/py-pkgs-cookiecutter).\n\n',
    'author': 'Ken Wang',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
