"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomRule = exports.RedirectStatus = exports.App = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_amplify_1 = require("aws-cdk-lib/aws-amplify");
const branch_1 = require("./branch");
const domain_1 = require("./domain");
const utils_1 = require("./utils");
/**
 * An Amplify Console application
 */
class App extends aws_cdk_lib_1.Resource {
    /**
     * Import an existing application
     */
    static fromAppId(scope, id, appId) {
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.appId = appId;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_AppProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, App);
            }
            throw error;
        }
        this.customRules = props.customRules || [];
        this.environmentVariables = props.environmentVariables || {};
        this.autoBranchEnvironmentVariables = props.autoBranchCreation && props.autoBranchCreation.environmentVariables || {};
        const role = props.role || new iam.Role(this, 'Role', {
            assumedBy: new iam.ServicePrincipal('amplify.amazonaws.com'),
        });
        this.grantPrincipal = role;
        const sourceCodeProviderOptions = props.sourceCodeProvider?.bind(this);
        const app = new aws_amplify_1.CfnApp(this, 'Resource', {
            accessToken: sourceCodeProviderOptions?.accessToken?.unsafeUnwrap(),
            autoBranchCreationConfig: props.autoBranchCreation && {
                autoBranchCreationPatterns: props.autoBranchCreation.patterns,
                basicAuthConfig: props.autoBranchCreation.basicAuth
                    ? props.autoBranchCreation.basicAuth.bind(this, 'BranchBasicAuth')
                    : { enableBasicAuth: false },
                buildSpec: props.autoBranchCreation.buildSpec && props.autoBranchCreation.buildSpec.toBuildSpec(),
                enableAutoBranchCreation: true,
                enableAutoBuild: props.autoBranchCreation.autoBuild ?? true,
                environmentVariables: aws_cdk_lib_1.Lazy.any({ produce: () => (0, utils_1.renderEnvironmentVariables)(this.autoBranchEnvironmentVariables) }, { omitEmptyArray: true }),
                enablePullRequestPreview: props.autoBranchCreation.pullRequestPreview ?? true,
                pullRequestEnvironmentName: props.autoBranchCreation.pullRequestEnvironmentName,
                stage: props.autoBranchCreation.stage,
            },
            enableBranchAutoDeletion: props.autoBranchDeletion,
            basicAuthConfig: props.basicAuth
                ? props.basicAuth.bind(this, 'AppBasicAuth')
                : { enableBasicAuth: false },
            buildSpec: props.buildSpec && props.buildSpec.toBuildSpec(),
            customRules: aws_cdk_lib_1.Lazy.any({ produce: () => this.customRules }, { omitEmptyArray: true }),
            description: props.description,
            environmentVariables: aws_cdk_lib_1.Lazy.any({ produce: () => (0, utils_1.renderEnvironmentVariables)(this.environmentVariables) }, { omitEmptyArray: true }),
            iamServiceRole: role.roleArn,
            name: props.appName || this.node.id,
            oauthToken: sourceCodeProviderOptions?.oauthToken?.unsafeUnwrap(),
            repository: sourceCodeProviderOptions?.repository,
            customHeaders: props.customResponseHeaders ? renderCustomResponseHeaders(props.customResponseHeaders) : undefined,
        });
        this.appId = app.attrAppId;
        this.appName = app.attrAppName;
        this.arn = app.attrArn;
        this.defaultDomain = app.attrDefaultDomain;
    }
    /**
     * Adds a custom rewrite/redirect rule to this application
     */
    addCustomRule(rule) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_CustomRule(rule);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addCustomRule);
            }
            throw error;
        }
        this.customRules.push(rule);
        return this;
    }
    /**
     * Adds an environment variable to this application.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     */
    addEnvironment(name, value) {
        this.environmentVariables[name] = value;
        return this;
    }
    /**
     * Adds an environment variable to the auto created branch.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     */
    addAutoBranchEnvironment(name, value) {
        this.autoBranchEnvironmentVariables[name] = value;
        return this;
    }
    /**
     * Adds a branch to this application
     */
    addBranch(id, options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_BranchOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addBranch);
            }
            throw error;
        }
        return new branch_1.Branch(this, id, {
            ...options,
            app: this,
        });
    }
    /**
     * Adds a domain to this application
     */
    addDomain(id, options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_DomainOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addDomain);
            }
            throw error;
        }
        return new domain_1.Domain(this, id, {
            ...options,
            app: this,
            autoSubDomainIamRole: this.grantPrincipal,
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
App[_a] = { fqn: "@aws-cdk/aws-amplify-alpha.App", version: "2.72.1-alpha.0" };
exports.App = App;
/**
 * The status code for a URL rewrite or redirect rule.
 */
var RedirectStatus;
(function (RedirectStatus) {
    /**
     * Rewrite (200)
     */
    RedirectStatus["REWRITE"] = "200";
    /**
     * Permanent redirect (301)
     */
    RedirectStatus["PERMANENT_REDIRECT"] = "301";
    /**
     * Temporary redirect (302)
     */
    RedirectStatus["TEMPORARY_REDIRECT"] = "302";
    /**
     * Not found (404)
     */
    RedirectStatus["NOT_FOUND"] = "404";
    /**
     * Not found rewrite (404)
     */
    RedirectStatus["NOT_FOUND_REWRITE"] = "404-200";
})(RedirectStatus = exports.RedirectStatus || (exports.RedirectStatus = {}));
/**
 * Custom rewrite/redirect rule for an Amplify App.
 *
 * @see https://docs.aws.amazon.com/amplify/latest/userguide/redirects.html
 */
class CustomRule {
    constructor(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_CustomRuleOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CustomRule);
            }
            throw error;
        }
        this.source = options.source;
        this.target = options.target;
        this.status = options.status;
        this.condition = options.condition;
    }
}
_b = JSII_RTTI_SYMBOL_1;
CustomRule[_b] = { fqn: "@aws-cdk/aws-amplify-alpha.CustomRule", version: "2.72.1-alpha.0" };
/**
 * Sets up a 200 rewrite for all paths to `index.html` except for path
 * containing a file extension.
 */
CustomRule.SINGLE_PAGE_APPLICATION_REDIRECT = new CustomRule({
    source: '</^[^.]+$/>',
    target: '/index.html',
    status: RedirectStatus.REWRITE,
});
exports.CustomRule = CustomRule;
function renderCustomResponseHeaders(customHeaders) {
    const yaml = [
        'customHeaders:',
    ];
    for (const customHeader of customHeaders) {
        yaml.push(`  - pattern: "${customHeader.pattern}"`);
        yaml.push('    headers:');
        for (const [key, value] of Object.entries(customHeader.headers)) {
            yaml.push(`      - key: "${key}"`);
            yaml.push(`        value: "${value}"`);
        }
    }
    return `${yaml.join('\n')}\n`;
}
//# sourceMappingURL=data:application/json;base64,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