export interface AmplifyJobId {
    /**
     * If this field is included in an event passed to "IsComplete", it means we
     * initiated an Amplify deployment that should be monitored using
     * amplify:GetJob
     */
    AmplifyJobId?: string;
}
export type ResourceEvent = AWSLambda.CloudFormationCustomResourceEvent & AmplifyJobId;
export interface IsCompleteResponse {
    /**
     * Indicates if the resource operation is complete or should we retry.
     */
    readonly IsComplete: boolean;
    /**
     * Additional/changes to resource attributes.
     */
    readonly Data?: {
        [name: string]: any;
    };
}
export declare abstract class ResourceHandler {
    protected readonly requestId: string;
    protected readonly logicalResourceId: string;
    protected readonly requestType: 'Create' | 'Update' | 'Delete';
    protected readonly physicalResourceId?: string;
    protected readonly event: ResourceEvent;
    constructor(event: ResourceEvent);
    onEvent(): Promise<AmplifyJobId> | Promise<void>;
    isComplete(): Promise<IsCompleteResponse>;
    protected log(x: any): void;
    protected abstract onCreate(): Promise<AmplifyJobId>;
    protected abstract onDelete(): Promise<void>;
    protected abstract onUpdate(): Promise<AmplifyJobId>;
    protected abstract isCreateComplete(): Promise<IsCompleteResponse>;
    protected abstract isDeleteComplete(): Promise<IsCompleteResponse>;
    protected abstract isUpdateComplete(): Promise<IsCompleteResponse>;
}
