"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Branch = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const aws_lambda_nodejs_1 = require("aws-cdk-lib/aws-lambda-nodejs");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const aws_amplify_1 = require("aws-cdk-lib/aws-amplify");
const utils_1 = require("./utils");
/**
 * An Amplify Console branch
 */
class Branch extends aws_cdk_lib_1.Resource {
    /**
     * Import an existing branch
     */
    static fromBranchName(scope, id, branchName) {
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.branchName = branchName;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_BranchProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Branch);
            }
            throw error;
        }
        this.environmentVariables = props.environmentVariables || {};
        const branchName = props.branchName || id;
        const branch = new aws_amplify_1.CfnBranch(this, 'Resource', {
            appId: props.app.appId,
            basicAuthConfig: props.basicAuth && props.basicAuth.bind(this, `${branchName}BasicAuth`),
            branchName,
            buildSpec: props.buildSpec && props.buildSpec.toBuildSpec(),
            description: props.description,
            enableAutoBuild: props.autoBuild ?? true,
            enablePullRequestPreview: props.pullRequestPreview ?? true,
            environmentVariables: aws_cdk_lib_1.Lazy.any({ produce: () => (0, utils_1.renderEnvironmentVariables)(this.environmentVariables) }, { omitEmptyArray: true }),
            pullRequestEnvironmentName: props.pullRequestEnvironmentName,
            stage: props.stage,
            enablePerformanceMode: props.performanceMode,
        });
        this.arn = branch.attrArn;
        this.branchName = branch.attrBranchName;
        if (props.asset) {
            new aws_cdk_lib_1.CustomResource(this, 'DeploymentResource', {
                serviceToken: AmplifyAssetDeploymentProvider.getOrCreate(this),
                resourceType: 'Custom::AmplifyAssetDeployment',
                properties: {
                    AppId: props.app.appId,
                    BranchName: branchName,
                    S3ObjectKey: props.asset.s3ObjectKey,
                    S3BucketName: props.asset.s3BucketName,
                },
            });
        }
    }
    /**
     * Adds an environment variable to this branch.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     */
    addEnvironment(name, value) {
        this.environmentVariables[name] = value;
        return this;
    }
}
_a = JSII_RTTI_SYMBOL_1;
Branch[_a] = { fqn: "@aws-cdk/aws-amplify-alpha.Branch", version: "2.72.1-alpha.0" };
exports.Branch = Branch;
class AmplifyAssetDeploymentProvider extends aws_cdk_lib_1.NestedStack {
    /**
     * Returns the singleton provider.
     */
    static getOrCreate(scope) {
        const providerId = 'com.amazonaws.cdk.custom-resources.amplify-asset-deployment-provider';
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const group = stack.node.tryFindChild(providerId) ?? new AmplifyAssetDeploymentProvider(stack, providerId);
        return group.provider.serviceToken;
    }
    constructor(scope, id) {
        super(scope, id);
        const onEvent = new aws_lambda_nodejs_1.NodejsFunction(this, 'amplify-asset-deployment-on-event', {
            entry: path.join(__dirname, 'asset-deployment-handler/index.js'),
            runtime: lambda.Runtime.NODEJS_14_X,
            handler: 'onEvent',
            initialPolicy: [
                new iam.PolicyStatement({
                    resources: ['*'],
                    actions: [
                        's3:GetObject',
                        's3:GetSignedUrl',
                        'amplify:ListJobs',
                        'amplify:StartDeployment',
                    ],
                }),
            ],
        });
        const isComplete = new aws_lambda_nodejs_1.NodejsFunction(this, 'amplify-asset-deployment-is-complete', {
            entry: path.join(__dirname, 'asset-deployment-handler/index.js'),
            runtime: lambda.Runtime.NODEJS_14_X,
            handler: 'isComplete',
            initialPolicy: [
                new iam.PolicyStatement({
                    resources: ['*'],
                    actions: ['amplify:GetJob*'],
                }),
            ],
        });
        this.provider = new custom_resources_1.Provider(this, 'amplify-asset-deployment-handler-provider', {
            onEventHandler: onEvent,
            isCompleteHandler: isComplete,
            totalTimeout: aws_cdk_lib_1.Duration.minutes(5),
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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