"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Domain = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_amplify_1 = require("aws-cdk-lib/aws-amplify");
/**
 * An Amplify Console domain
 */
class Domain extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_DomainProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Domain);
            }
            throw error;
        }
        this.subDomains = props.subDomains || [];
        const domainName = props.domainName || id;
        const domain = new aws_amplify_1.CfnDomain(this, 'Resource', {
            appId: props.app.appId,
            domainName,
            subDomainSettings: aws_cdk_lib_1.Lazy.any({ produce: () => this.renderSubDomainSettings() }, { omitEmptyArray: true }),
            enableAutoSubDomain: !!props.enableAutoSubdomain,
            autoSubDomainCreationPatterns: props.autoSubdomainCreationPatterns || ['*', 'pr*'],
            autoSubDomainIamRole: props.autoSubDomainIamRole?.roleArn,
        });
        this.arn = domain.attrArn;
        this.certificateRecord = domain.attrCertificateRecord;
        this.domainName = domain.attrDomainName;
        this.domainStatus = domain.attrDomainStatus;
        this.statusReason = domain.attrStatusReason;
        this.domainAutoSubDomainCreationPatterns = domain.attrAutoSubDomainCreationPatterns;
        this.domainAutoSubDomainIamRole = domain.attrAutoSubDomainIamRole;
        this.domainEnableAutoSubDomain = domain.attrEnableAutoSubDomain;
        this.node.addValidation({ validate: () => this.validateDomain() });
    }
    /**
     * Maps a branch to a sub domain
     *
     * @param branch The branch
     * @param prefix The prefix. Use '' to map to the root of the domain. Defaults to branch name.
     */
    mapSubDomain(branch, prefix) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_IBranch(branch);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.mapSubDomain);
            }
            throw error;
        }
        this.subDomains.push({ branch, prefix });
        return this;
    }
    /**
     * Maps a branch to the domain root
     */
    mapRoot(branch) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_IBranch(branch);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.mapRoot);
            }
            throw error;
        }
        return this.mapSubDomain(branch, '');
    }
    validateDomain() {
        if (this.subDomains.length === 0) {
            return ['The domain doesn\'t contain any subdomains'];
        }
        return [];
    }
    renderSubDomainSettings() {
        return this.subDomains.map(s => ({
            branchName: s.branch.branchName,
            prefix: s.prefix ?? s.branch.branchName,
        }));
    }
}
_a = JSII_RTTI_SYMBOL_1;
Domain[_a] = { fqn: "@aws-cdk/aws-amplify-alpha.Domain", version: "2.72.1-alpha.0" };
exports.Domain = Domain;
//# sourceMappingURL=data:application/json;base64,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