"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeCommitSourceCodeProvider = exports.GitLabSourceCodeProvider = exports.GitHubSourceCodeProvider = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * GitHub source code provider
 */
class GitHubSourceCodeProvider {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_GitHubSourceCodeProviderProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GitHubSourceCodeProvider);
            }
            throw error;
        }
    }
    bind(_app) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_App(_app);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            repository: `https://github.com/${this.props.owner}/${this.props.repository}`,
            oauthToken: this.props.oauthToken,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
GitHubSourceCodeProvider[_a] = { fqn: "@aws-cdk/aws-amplify-alpha.GitHubSourceCodeProvider", version: "2.72.1-alpha.0" };
exports.GitHubSourceCodeProvider = GitHubSourceCodeProvider;
/**
 * GitLab source code provider
 */
class GitLabSourceCodeProvider {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_GitLabSourceCodeProviderProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GitLabSourceCodeProvider);
            }
            throw error;
        }
    }
    bind(_app) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_App(_app);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            repository: `https://gitlab.com/${this.props.owner}/${this.props.repository}`,
            oauthToken: this.props.oauthToken,
        };
    }
}
_b = JSII_RTTI_SYMBOL_1;
GitLabSourceCodeProvider[_b] = { fqn: "@aws-cdk/aws-amplify-alpha.GitLabSourceCodeProvider", version: "2.72.1-alpha.0" };
exports.GitLabSourceCodeProvider = GitLabSourceCodeProvider;
/**
 * CodeCommit source code provider
 */
class CodeCommitSourceCodeProvider {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_CodeCommitSourceCodeProviderProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CodeCommitSourceCodeProvider);
            }
            throw error;
        }
    }
    bind(app) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_App(app);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        this.props.repository.grantPull(app);
        return {
            repository: this.props.repository.repositoryCloneUrlHttp,
        };
    }
}
_c = JSII_RTTI_SYMBOL_1;
CodeCommitSourceCodeProvider[_c] = { fqn: "@aws-cdk/aws-amplify-alpha.CodeCommitSourceCodeProvider", version: "2.72.1-alpha.0" };
exports.CodeCommitSourceCodeProvider = CodeCommitSourceCodeProvider;
//# sourceMappingURL=data:application/json;base64,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