"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiDestination = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const connection_1 = require("./connection");
const events_generated_1 = require("./events.generated");
/**
 * Define an EventBridge Api Destination
 *
 * @resource AWS::Events::ApiDestination
 */
class ApiDestination extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.apiDestinationName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_events_ApiDestinationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ApiDestination);
            }
            throw error;
        }
        this.connection = props.connection;
        let apiDestination = new events_generated_1.CfnApiDestination(this, 'ApiDestination', {
            connectionArn: this.connection.connectionArn,
            description: props.description,
            httpMethod: props.httpMethod ?? connection_1.HttpMethod.POST,
            invocationEndpoint: props.endpoint,
            invocationRateLimitPerSecond: props.rateLimitPerSecond,
            name: this.physicalName,
        });
        this.apiDestinationName = this.getResourceNameAttribute(apiDestination.ref);
        this.apiDestinationArn = apiDestination.attrArn;
    }
}
exports.ApiDestination = ApiDestination;
_a = JSII_RTTI_SYMBOL_1;
ApiDestination[_a] = { fqn: "@aws-cdk/aws-events.ApiDestination", version: "1.184.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBpLWRlc3RpbmF0aW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYXBpLWRlc3RpbmF0aW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBLHdDQUFvRDtBQUVwRCw2Q0FBdUQ7QUFDdkQseURBQXVEO0FBNkR2RDs7OztHQUlHO0FBQ0gsTUFBYSxjQUFlLFNBQVEsZUFBUTtJQWtCMUMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUEwQjtRQUNsRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLFlBQVksRUFBRSxLQUFLLENBQUMsa0JBQWtCO1NBQ3ZDLENBQUMsQ0FBQzs7Ozs7OytDQXJCTSxjQUFjOzs7O1FBdUJ2QixJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQyxVQUFVLENBQUM7UUFFbkMsSUFBSSxjQUFjLEdBQUcsSUFBSSxvQ0FBaUIsQ0FBQyxJQUFJLEVBQUUsZ0JBQWdCLEVBQUU7WUFDakUsYUFBYSxFQUFFLElBQUksQ0FBQyxVQUFVLENBQUMsYUFBYTtZQUM1QyxXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7WUFDOUIsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVLElBQUksdUJBQVUsQ0FBQyxJQUFJO1lBQy9DLGtCQUFrQixFQUFFLEtBQUssQ0FBQyxRQUFRO1lBQ2xDLDRCQUE0QixFQUFFLEtBQUssQ0FBQyxrQkFBa0I7WUFDdEQsSUFBSSxFQUFFLElBQUksQ0FBQyxZQUFZO1NBQ3hCLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLENBQUMsd0JBQXdCLENBQUMsY0FBYyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQzVFLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxjQUFjLENBQUMsT0FBTyxDQUFDO0tBQ2pEOztBQXBDSCx3Q0FxQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBJUmVzb3VyY2UsIFJlc291cmNlIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IEh0dHBNZXRob2QsIElDb25uZWN0aW9uIH0gZnJvbSAnLi9jb25uZWN0aW9uJztcbmltcG9ydCB7IENmbkFwaURlc3RpbmF0aW9uIH0gZnJvbSAnLi9ldmVudHMuZ2VuZXJhdGVkJztcblxuLyoqXG4gKiBUaGUgZXZlbnQgQVBJIERlc3RpbmF0aW9uIHByb3BlcnRpZXNcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBBcGlEZXN0aW5hdGlvblByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBuYW1lIGZvciB0aGUgQVBJIGRlc3RpbmF0aW9uLlxuICAgKiBAZGVmYXVsdCAtIEEgdW5pcXVlIG5hbWUgd2lsbCBiZSBnZW5lcmF0ZWRcbiAgICovXG4gIHJlYWRvbmx5IGFwaURlc3RpbmF0aW9uTmFtZT86IHN0cmluZztcblxuICAvKipcbiAgICogQSBkZXNjcmlwdGlvbiBmb3IgdGhlIEFQSSBkZXN0aW5hdGlvbi5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBub25lXG4gICAqL1xuICByZWFkb25seSBkZXNjcmlwdGlvbj86IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIEFSTiBvZiB0aGUgY29ubmVjdGlvbiB0byB1c2UgZm9yIHRoZSBBUEkgZGVzdGluYXRpb25cbiAgICovXG4gIHJlYWRvbmx5IGNvbm5lY3Rpb246IElDb25uZWN0aW9uO1xuXG4gIC8qKlxuICAgKiBUaGUgVVJMIHRvIHRoZSBIVFRQIGludm9jYXRpb24gZW5kcG9pbnQgZm9yIHRoZSBBUEkgZGVzdGluYXRpb24uLlxuICAgKi9cbiAgcmVhZG9ubHkgZW5kcG9pbnQ6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIG1ldGhvZCB0byB1c2UgZm9yIHRoZSByZXF1ZXN0IHRvIHRoZSBIVFRQIGludm9jYXRpb24gZW5kcG9pbnQuXG4gICAqXG4gICAqIEBkZWZhdWx0IEh0dHBNZXRob2QuUE9TVFxuICAgKi9cbiAgcmVhZG9ubHkgaHR0cE1ldGhvZD86IEh0dHBNZXRob2Q7XG5cbiAgLyoqXG4gICAqIFRoZSBtYXhpbXVtIG51bWJlciBvZiByZXF1ZXN0cyBwZXIgc2Vjb25kIHRvIHNlbmQgdG8gdGhlIEhUVFAgaW52b2NhdGlvbiBlbmRwb2ludC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBOb3QgcmF0ZSBsaW1pdGVkXG4gICAqL1xuICByZWFkb25seSByYXRlTGltaXRQZXJTZWNvbmQ/OiBudW1iZXI7XG59XG5cbi8qKlxuICogSW50ZXJmYWNlIGZvciBBUEkgRGVzdGluYXRpb25zXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSUFwaURlc3RpbmF0aW9uIGV4dGVuZHMgSVJlc291cmNlIHtcbiAgLyoqXG4gICAqIFRoZSBOYW1lIG9mIHRoZSBBcGkgRGVzdGluYXRpb24gY3JlYXRlZC5cbiAgICogQGF0dHJpYnV0ZVxuICAgKi9cbiAgcmVhZG9ubHkgYXBpRGVzdGluYXRpb25OYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBBUk4gb2YgdGhlIEFwaSBEZXN0aW5hdGlvbiBjcmVhdGVkLlxuICAgKiBAYXR0cmlidXRlXG4gICAqL1xuICByZWFkb25seSBhcGlEZXN0aW5hdGlvbkFybjogc3RyaW5nO1xufVxuXG4vKipcbiAqIERlZmluZSBhbiBFdmVudEJyaWRnZSBBcGkgRGVzdGluYXRpb25cbiAqXG4gKiBAcmVzb3VyY2UgQVdTOjpFdmVudHM6OkFwaURlc3RpbmF0aW9uXG4gKi9cbmV4cG9ydCBjbGFzcyBBcGlEZXN0aW5hdGlvbiBleHRlbmRzIFJlc291cmNlIGltcGxlbWVudHMgSUFwaURlc3RpbmF0aW9uIHtcbiAgLyoqXG4gICAqIFRoZSBDb25uZWN0aW9uIHRvIGFzc29jaWF0ZSB3aXRoIEFwaSBEZXN0aW5hdGlvblxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGNvbm5lY3Rpb246IElDb25uZWN0aW9uO1xuXG4gIC8qKlxuICAgKiBUaGUgTmFtZSBvZiB0aGUgQXBpIERlc3RpbmF0aW9uIGNyZWF0ZWQuXG4gICAqIEBhdHRyaWJ1dGVcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBhcGlEZXN0aW5hdGlvbk5hbWU6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIEFSTiBvZiB0aGUgQXBpIERlc3RpbmF0aW9uIGNyZWF0ZWQuXG4gICAqIEBhdHRyaWJ1dGVcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBhcGlEZXN0aW5hdGlvbkFybjogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBBcGlEZXN0aW5hdGlvblByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICBwaHlzaWNhbE5hbWU6IHByb3BzLmFwaURlc3RpbmF0aW9uTmFtZSxcbiAgICB9KTtcblxuICAgIHRoaXMuY29ubmVjdGlvbiA9IHByb3BzLmNvbm5lY3Rpb247XG5cbiAgICBsZXQgYXBpRGVzdGluYXRpb24gPSBuZXcgQ2ZuQXBpRGVzdGluYXRpb24odGhpcywgJ0FwaURlc3RpbmF0aW9uJywge1xuICAgICAgY29ubmVjdGlvbkFybjogdGhpcy5jb25uZWN0aW9uLmNvbm5lY3Rpb25Bcm4sXG4gICAgICBkZXNjcmlwdGlvbjogcHJvcHMuZGVzY3JpcHRpb24sXG4gICAgICBodHRwTWV0aG9kOiBwcm9wcy5odHRwTWV0aG9kID8/IEh0dHBNZXRob2QuUE9TVCxcbiAgICAgIGludm9jYXRpb25FbmRwb2ludDogcHJvcHMuZW5kcG9pbnQsXG4gICAgICBpbnZvY2F0aW9uUmF0ZUxpbWl0UGVyU2Vjb25kOiBwcm9wcy5yYXRlTGltaXRQZXJTZWNvbmQsXG4gICAgICBuYW1lOiB0aGlzLnBoeXNpY2FsTmFtZSxcbiAgICB9KTtcblxuICAgIHRoaXMuYXBpRGVzdGluYXRpb25OYW1lID0gdGhpcy5nZXRSZXNvdXJjZU5hbWVBdHRyaWJ1dGUoYXBpRGVzdGluYXRpb24ucmVmKTtcbiAgICB0aGlzLmFwaURlc3RpbmF0aW9uQXJuID0gYXBpRGVzdGluYXRpb24uYXR0ckFybjtcbiAgfVxufVxuIl19