import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudPgClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of your cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/pg_cluster#display_name DataIonoscloudPgCluster#display_name}
    */
    readonly displayName?: string;
    /**
    * The id of your cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/pg_cluster#id DataIonoscloudPgCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/pg_cluster#timeouts DataIonoscloudPgCluster#timeouts}
    */
    readonly timeouts?: DataIonoscloudPgClusterTimeouts;
}
export interface DataIonoscloudPgClusterConnections {
}
export declare function dataIonoscloudPgClusterConnectionsToTerraform(struct?: DataIonoscloudPgClusterConnections): any;
export declare class DataIonoscloudPgClusterConnectionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudPgClusterConnections | undefined;
    set internalValue(value: DataIonoscloudPgClusterConnections | undefined);
    get cidr(): string;
    get datacenterId(): string;
    get lanId(): string;
}
export declare class DataIonoscloudPgClusterConnectionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudPgClusterConnectionsOutputReference;
}
export interface DataIonoscloudPgClusterCredentials {
}
export declare function dataIonoscloudPgClusterCredentialsToTerraform(struct?: DataIonoscloudPgClusterCredentials): any;
export declare class DataIonoscloudPgClusterCredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudPgClusterCredentials | undefined;
    set internalValue(value: DataIonoscloudPgClusterCredentials | undefined);
    get password(): string;
    get username(): string;
}
export declare class DataIonoscloudPgClusterCredentialsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudPgClusterCredentialsOutputReference;
}
export interface DataIonoscloudPgClusterFromBackup {
}
export declare function dataIonoscloudPgClusterFromBackupToTerraform(struct?: DataIonoscloudPgClusterFromBackup): any;
export declare class DataIonoscloudPgClusterFromBackupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudPgClusterFromBackup | undefined;
    set internalValue(value: DataIonoscloudPgClusterFromBackup | undefined);
    get backupId(): string;
    get recoveryTargetTime(): string;
}
export declare class DataIonoscloudPgClusterFromBackupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudPgClusterFromBackupOutputReference;
}
export interface DataIonoscloudPgClusterMaintenanceWindow {
}
export declare function dataIonoscloudPgClusterMaintenanceWindowToTerraform(struct?: DataIonoscloudPgClusterMaintenanceWindow): any;
export declare class DataIonoscloudPgClusterMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudPgClusterMaintenanceWindow | undefined;
    set internalValue(value: DataIonoscloudPgClusterMaintenanceWindow | undefined);
    get dayOfTheWeek(): string;
    get time(): string;
}
export declare class DataIonoscloudPgClusterMaintenanceWindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudPgClusterMaintenanceWindowOutputReference;
}
export interface DataIonoscloudPgClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/pg_cluster#create DataIonoscloudPgCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/pg_cluster#default DataIonoscloudPgCluster#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/pg_cluster#delete DataIonoscloudPgCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/pg_cluster#update DataIonoscloudPgCluster#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudPgClusterTimeoutsToTerraform(struct?: DataIonoscloudPgClusterTimeoutsOutputReference | DataIonoscloudPgClusterTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudPgClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudPgClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataIonoscloudPgClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/pg_cluster ionoscloud_pg_cluster}
*/
export declare class DataIonoscloudPgCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_pg_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/pg_cluster ionoscloud_pg_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudPgClusterConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataIonoscloudPgClusterConfig);
    get backupLocation(): string;
    private _connections;
    get connections(): DataIonoscloudPgClusterConnectionsList;
    get cores(): number;
    private _credentials;
    get credentials(): DataIonoscloudPgClusterCredentialsList;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _fromBackup;
    get fromBackup(): DataIonoscloudPgClusterFromBackupList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get instances(): number;
    get location(): string;
    private _maintenanceWindow;
    get maintenanceWindow(): DataIonoscloudPgClusterMaintenanceWindowList;
    get postgresVersion(): string;
    get ram(): number;
    get storageSize(): number;
    get storageType(): string;
    get synchronizationMode(): string;
    private _timeouts;
    get timeouts(): DataIonoscloudPgClusterTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudPgClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataIonoscloudPgClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
