# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetAppResult',
    'AwaitableGetAppResult',
    'get_app',
    'get_app_output',
]

@pulumi.output_type
class GetAppResult:
    """
    A collection of values returned by getApp.
    """
    def __init__(__self__, active_only=None, groups=None, id=None, label=None, label_prefix=None, links=None, name=None, skip_groups=None, skip_users=None, status=None, users=None):
        if active_only and not isinstance(active_only, bool):
            raise TypeError("Expected argument 'active_only' to be a bool")
        pulumi.set(__self__, "active_only", active_only)
        if groups and not isinstance(groups, list):
            raise TypeError("Expected argument 'groups' to be a list")
        if groups is not None:
            warnings.warn("""The `groups` field is now deprecated for the data source `okta_app`, please replace all uses of this with: `okta_app_group_assignments`""", DeprecationWarning)
            pulumi.log.warn("""groups is deprecated: The `groups` field is now deprecated for the data source `okta_app`, please replace all uses of this with: `okta_app_group_assignments`""")

        pulumi.set(__self__, "groups", groups)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if label and not isinstance(label, str):
            raise TypeError("Expected argument 'label' to be a str")
        pulumi.set(__self__, "label", label)
        if label_prefix and not isinstance(label_prefix, str):
            raise TypeError("Expected argument 'label_prefix' to be a str")
        pulumi.set(__self__, "label_prefix", label_prefix)
        if links and not isinstance(links, str):
            raise TypeError("Expected argument 'links' to be a str")
        pulumi.set(__self__, "links", links)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if skip_groups and not isinstance(skip_groups, bool):
            raise TypeError("Expected argument 'skip_groups' to be a bool")
        pulumi.set(__self__, "skip_groups", skip_groups)
        if skip_users and not isinstance(skip_users, bool):
            raise TypeError("Expected argument 'skip_users' to be a bool")
        pulumi.set(__self__, "skip_users", skip_users)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        if users is not None:
            warnings.warn("""The `users` field is now deprecated for the data source `okta_app`, please replace all uses of this with: `okta_app_user_assignments`""", DeprecationWarning)
            pulumi.log.warn("""users is deprecated: The `users` field is now deprecated for the data source `okta_app`, please replace all uses of this with: `okta_app_user_assignments`""")

        pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="activeOnly")
    def active_only(self) -> Optional[bool]:
        return pulumi.get(self, "active_only")

    @property
    @pulumi.getter
    def groups(self) -> Sequence[str]:
        """
        List of groups IDs assigned to the application.
        - `DEPRECATED`: Please replace all usage of this field with the data source `AppGroupAssignments`.
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Application ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def label(self) -> Optional[str]:
        """
        Application label.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter(name="labelPrefix")
    def label_prefix(self) -> Optional[str]:
        return pulumi.get(self, "label_prefix")

    @property
    @pulumi.getter
    def links(self) -> str:
        """
        Generic JSON containing discoverable resources related to the app.
        """
        return pulumi.get(self, "links")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Application name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="skipGroups")
    def skip_groups(self) -> Optional[bool]:
        return pulumi.get(self, "skip_groups")

    @property
    @pulumi.getter(name="skipUsers")
    def skip_users(self) -> Optional[bool]:
        return pulumi.get(self, "skip_users")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Application status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def users(self) -> Sequence[str]:
        """
        List of users IDs assigned to the application.
        - `DEPRECATED`: Please replace all usage of this field with the data source `get_app_user_assignments`.
        """
        return pulumi.get(self, "users")


class AwaitableGetAppResult(GetAppResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppResult(
            active_only=self.active_only,
            groups=self.groups,
            id=self.id,
            label=self.label,
            label_prefix=self.label_prefix,
            links=self.links,
            name=self.name,
            skip_groups=self.skip_groups,
            skip_users=self.skip_users,
            status=self.status,
            users=self.users)


def get_app(active_only: Optional[bool] = None,
            id: Optional[str] = None,
            label: Optional[str] = None,
            label_prefix: Optional[str] = None,
            skip_groups: Optional[bool] = None,
            skip_users: Optional[bool] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppResult:
    """
    Use this data source to retrieve an application from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.app.get_app(label="Example App")
    ```


    :param bool active_only: tells the provider to query for only `ACTIVE` applications.
    :param str id: `id` of application to retrieve, conflicts with `label` and `label_prefix`.
    :param str label: The label of the app to retrieve, conflicts with `label_prefix` and `id`. Label uses
           the `?q=<label>` query parameter exposed by Okta's API. It should be noted that at this time the API searches both `name`
           and `label` with a [starts with query](https://developer.okta.com/docs/reference/api/apps/#list-applications) which
           may result in multiple apps being returned for the query. The data source further inspects the lables looking for
           an exact match.
    :param str label_prefix: Label prefix of the app to retrieve, conflicts with `label` and `id`. This will tell the
           provider to do a `starts with` query as opposed to an `equals` query.
    :param bool skip_groups: Indicator that allows the app to skip `groups` sync. Default is `false`.
    :param bool skip_users: Indicator that allows the app to skip `users` sync. Default is `false`.
    """
    __args__ = dict()
    __args__['activeOnly'] = active_only
    __args__['id'] = id
    __args__['label'] = label
    __args__['labelPrefix'] = label_prefix
    __args__['skipGroups'] = skip_groups
    __args__['skipUsers'] = skip_users
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('okta:app/getApp:getApp', __args__, opts=opts, typ=GetAppResult).value

    return AwaitableGetAppResult(
        active_only=__ret__.active_only,
        groups=__ret__.groups,
        id=__ret__.id,
        label=__ret__.label,
        label_prefix=__ret__.label_prefix,
        links=__ret__.links,
        name=__ret__.name,
        skip_groups=__ret__.skip_groups,
        skip_users=__ret__.skip_users,
        status=__ret__.status,
        users=__ret__.users)


@_utilities.lift_output_func(get_app)
def get_app_output(active_only: Optional[pulumi.Input[Optional[bool]]] = None,
                   id: Optional[pulumi.Input[Optional[str]]] = None,
                   label: Optional[pulumi.Input[Optional[str]]] = None,
                   label_prefix: Optional[pulumi.Input[Optional[str]]] = None,
                   skip_groups: Optional[pulumi.Input[Optional[bool]]] = None,
                   skip_users: Optional[pulumi.Input[Optional[bool]]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAppResult]:
    """
    Use this data source to retrieve an application from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.app.get_app(label="Example App")
    ```


    :param bool active_only: tells the provider to query for only `ACTIVE` applications.
    :param str id: `id` of application to retrieve, conflicts with `label` and `label_prefix`.
    :param str label: The label of the app to retrieve, conflicts with `label_prefix` and `id`. Label uses
           the `?q=<label>` query parameter exposed by Okta's API. It should be noted that at this time the API searches both `name`
           and `label` with a [starts with query](https://developer.okta.com/docs/reference/api/apps/#list-applications) which
           may result in multiple apps being returned for the query. The data source further inspects the lables looking for
           an exact match.
    :param str label_prefix: Label prefix of the app to retrieve, conflicts with `label` and `id`. This will tell the
           provider to do a `starts with` query as opposed to an `equals` query.
    :param bool skip_groups: Indicator that allows the app to skip `groups` sync. Default is `false`.
    :param bool skip_users: Indicator that allows the app to skip `users` sync. Default is `false`.
    """
    ...
