# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['BehaviourArgs', 'Behaviour']

@pulumi.input_type
class BehaviourArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 location_granularity_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 number_of_authentications: Optional[pulumi.Input[int]] = None,
                 radius_from_location: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 velocity: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Behaviour resource.
        :param pulumi.Input[str] type: Type of the behavior. Can be set to `"ANOMALOUS_LOCATION"`, `"ANOMALOUS_DEVICE"`, `"ANOMALOUS_IP"`
               or `"VELOCITY"`. Resource will be recreated when the type changes.
        :param pulumi.Input[str] location_granularity_type: Determines the method and level of detail used to evaluate the behavior.
               Required for `"ANOMALOUS_LOCATION"` behavior type. Can be set to `"LAT_LONG"`, `"CITY"`, `"COUNTRY"`
               or `"SUBDIVISION"`.
        :param pulumi.Input[str] name: Name of the behavior.
        :param pulumi.Input[int] number_of_authentications: The number of recent authentications used to evaluate the behavior. Required
               for `"ANOMALOUS_LOCATION"`, `"ANOMALOUS_DEVICE"` and `"ANOMALOUS_IP"` behavior types.
        :param pulumi.Input[int] radius_from_location: Radius from location (in kilometers). Should be at least 5. Required
               when `location_granularity_type` is set to `"LAT_LONG"`.
        :param pulumi.Input[str] status: The status of the behavior. By default, it is`"ACTIVE"`.
        :param pulumi.Input[int] velocity: Velocity (in kilometers per hour). Should be at least 1. Required for `"VELOCITY"` behavior
               type.
        """
        pulumi.set(__self__, "type", type)
        if location_granularity_type is not None:
            pulumi.set(__self__, "location_granularity_type", location_granularity_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_authentications is not None:
            pulumi.set(__self__, "number_of_authentications", number_of_authentications)
        if radius_from_location is not None:
            pulumi.set(__self__, "radius_from_location", radius_from_location)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if velocity is not None:
            pulumi.set(__self__, "velocity", velocity)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of the behavior. Can be set to `"ANOMALOUS_LOCATION"`, `"ANOMALOUS_DEVICE"`, `"ANOMALOUS_IP"`
        or `"VELOCITY"`. Resource will be recreated when the type changes.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="locationGranularityType")
    def location_granularity_type(self) -> Optional[pulumi.Input[str]]:
        """
        Determines the method and level of detail used to evaluate the behavior.
        Required for `"ANOMALOUS_LOCATION"` behavior type. Can be set to `"LAT_LONG"`, `"CITY"`, `"COUNTRY"`
        or `"SUBDIVISION"`.
        """
        return pulumi.get(self, "location_granularity_type")

    @location_granularity_type.setter
    def location_granularity_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location_granularity_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the behavior.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numberOfAuthentications")
    def number_of_authentications(self) -> Optional[pulumi.Input[int]]:
        """
        The number of recent authentications used to evaluate the behavior. Required
        for `"ANOMALOUS_LOCATION"`, `"ANOMALOUS_DEVICE"` and `"ANOMALOUS_IP"` behavior types.
        """
        return pulumi.get(self, "number_of_authentications")

    @number_of_authentications.setter
    def number_of_authentications(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_authentications", value)

    @property
    @pulumi.getter(name="radiusFromLocation")
    def radius_from_location(self) -> Optional[pulumi.Input[int]]:
        """
        Radius from location (in kilometers). Should be at least 5. Required
        when `location_granularity_type` is set to `"LAT_LONG"`.
        """
        return pulumi.get(self, "radius_from_location")

    @radius_from_location.setter
    def radius_from_location(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "radius_from_location", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the behavior. By default, it is`"ACTIVE"`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def velocity(self) -> Optional[pulumi.Input[int]]:
        """
        Velocity (in kilometers per hour). Should be at least 1. Required for `"VELOCITY"` behavior
        type.
        """
        return pulumi.get(self, "velocity")

    @velocity.setter
    def velocity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "velocity", value)


@pulumi.input_type
class _BehaviourState:
    def __init__(__self__, *,
                 location_granularity_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 number_of_authentications: Optional[pulumi.Input[int]] = None,
                 radius_from_location: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 velocity: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Behaviour resources.
        :param pulumi.Input[str] location_granularity_type: Determines the method and level of detail used to evaluate the behavior.
               Required for `"ANOMALOUS_LOCATION"` behavior type. Can be set to `"LAT_LONG"`, `"CITY"`, `"COUNTRY"`
               or `"SUBDIVISION"`.
        :param pulumi.Input[str] name: Name of the behavior.
        :param pulumi.Input[int] number_of_authentications: The number of recent authentications used to evaluate the behavior. Required
               for `"ANOMALOUS_LOCATION"`, `"ANOMALOUS_DEVICE"` and `"ANOMALOUS_IP"` behavior types.
        :param pulumi.Input[int] radius_from_location: Radius from location (in kilometers). Should be at least 5. Required
               when `location_granularity_type` is set to `"LAT_LONG"`.
        :param pulumi.Input[str] status: The status of the behavior. By default, it is`"ACTIVE"`.
        :param pulumi.Input[str] type: Type of the behavior. Can be set to `"ANOMALOUS_LOCATION"`, `"ANOMALOUS_DEVICE"`, `"ANOMALOUS_IP"`
               or `"VELOCITY"`. Resource will be recreated when the type changes.
        :param pulumi.Input[int] velocity: Velocity (in kilometers per hour). Should be at least 1. Required for `"VELOCITY"` behavior
               type.
        """
        if location_granularity_type is not None:
            pulumi.set(__self__, "location_granularity_type", location_granularity_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_authentications is not None:
            pulumi.set(__self__, "number_of_authentications", number_of_authentications)
        if radius_from_location is not None:
            pulumi.set(__self__, "radius_from_location", radius_from_location)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if velocity is not None:
            pulumi.set(__self__, "velocity", velocity)

    @property
    @pulumi.getter(name="locationGranularityType")
    def location_granularity_type(self) -> Optional[pulumi.Input[str]]:
        """
        Determines the method and level of detail used to evaluate the behavior.
        Required for `"ANOMALOUS_LOCATION"` behavior type. Can be set to `"LAT_LONG"`, `"CITY"`, `"COUNTRY"`
        or `"SUBDIVISION"`.
        """
        return pulumi.get(self, "location_granularity_type")

    @location_granularity_type.setter
    def location_granularity_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location_granularity_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the behavior.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="numberOfAuthentications")
    def number_of_authentications(self) -> Optional[pulumi.Input[int]]:
        """
        The number of recent authentications used to evaluate the behavior. Required
        for `"ANOMALOUS_LOCATION"`, `"ANOMALOUS_DEVICE"` and `"ANOMALOUS_IP"` behavior types.
        """
        return pulumi.get(self, "number_of_authentications")

    @number_of_authentications.setter
    def number_of_authentications(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number_of_authentications", value)

    @property
    @pulumi.getter(name="radiusFromLocation")
    def radius_from_location(self) -> Optional[pulumi.Input[int]]:
        """
        Radius from location (in kilometers). Should be at least 5. Required
        when `location_granularity_type` is set to `"LAT_LONG"`.
        """
        return pulumi.get(self, "radius_from_location")

    @radius_from_location.setter
    def radius_from_location(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "radius_from_location", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the behavior. By default, it is`"ACTIVE"`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the behavior. Can be set to `"ANOMALOUS_LOCATION"`, `"ANOMALOUS_DEVICE"`, `"ANOMALOUS_IP"`
        or `"VELOCITY"`. Resource will be recreated when the type changes.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def velocity(self) -> Optional[pulumi.Input[int]]:
        """
        Velocity (in kilometers per hour). Should be at least 1. Required for `"VELOCITY"` behavior
        type.
        """
        return pulumi.get(self, "velocity")

    @velocity.setter
    def velocity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "velocity", value)


class Behaviour(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location_granularity_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 number_of_authentications: Optional[pulumi.Input[int]] = None,
                 radius_from_location: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 velocity: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        This resource allows you to create and configure a behavior.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        my_location = okta.Behaviour("myLocation",
            location_granularity_type="LAT_LONG",
            number_of_authentications=50,
            radius_from_location=20,
            type="ANOMALOUS_LOCATION")
        my_city = okta.Behaviour("myCity",
            location_granularity_type="CITY",
            number_of_authentications=50,
            type="ANOMALOUS_LOCATION")
        my_device = okta.Behaviour("myDevice",
            number_of_authentications=50,
            type="ANOMALOUS_DEVICE")
        my_ip = okta.Behaviour("myIp",
            number_of_authentications=50,
            type="ANOMALOUS_IP")
        my_velocity = okta.Behaviour("myVelocity",
            type="VELOCITY",
            velocity=25)
        ```

        ## Import

        Behavior can be imported via the Okta ID.

        ```sh
         $ pulumi import okta:index/behaviour:Behaviour example &#60;behavior id&#62;
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] location_granularity_type: Determines the method and level of detail used to evaluate the behavior.
               Required for `"ANOMALOUS_LOCATION"` behavior type. Can be set to `"LAT_LONG"`, `"CITY"`, `"COUNTRY"`
               or `"SUBDIVISION"`.
        :param pulumi.Input[str] name: Name of the behavior.
        :param pulumi.Input[int] number_of_authentications: The number of recent authentications used to evaluate the behavior. Required
               for `"ANOMALOUS_LOCATION"`, `"ANOMALOUS_DEVICE"` and `"ANOMALOUS_IP"` behavior types.
        :param pulumi.Input[int] radius_from_location: Radius from location (in kilometers). Should be at least 5. Required
               when `location_granularity_type` is set to `"LAT_LONG"`.
        :param pulumi.Input[str] status: The status of the behavior. By default, it is`"ACTIVE"`.
        :param pulumi.Input[str] type: Type of the behavior. Can be set to `"ANOMALOUS_LOCATION"`, `"ANOMALOUS_DEVICE"`, `"ANOMALOUS_IP"`
               or `"VELOCITY"`. Resource will be recreated when the type changes.
        :param pulumi.Input[int] velocity: Velocity (in kilometers per hour). Should be at least 1. Required for `"VELOCITY"` behavior
               type.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BehaviourArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to create and configure a behavior.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        my_location = okta.Behaviour("myLocation",
            location_granularity_type="LAT_LONG",
            number_of_authentications=50,
            radius_from_location=20,
            type="ANOMALOUS_LOCATION")
        my_city = okta.Behaviour("myCity",
            location_granularity_type="CITY",
            number_of_authentications=50,
            type="ANOMALOUS_LOCATION")
        my_device = okta.Behaviour("myDevice",
            number_of_authentications=50,
            type="ANOMALOUS_DEVICE")
        my_ip = okta.Behaviour("myIp",
            number_of_authentications=50,
            type="ANOMALOUS_IP")
        my_velocity = okta.Behaviour("myVelocity",
            type="VELOCITY",
            velocity=25)
        ```

        ## Import

        Behavior can be imported via the Okta ID.

        ```sh
         $ pulumi import okta:index/behaviour:Behaviour example &#60;behavior id&#62;
        ```

        :param str resource_name: The name of the resource.
        :param BehaviourArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BehaviourArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 location_granularity_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 number_of_authentications: Optional[pulumi.Input[int]] = None,
                 radius_from_location: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 velocity: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BehaviourArgs.__new__(BehaviourArgs)

            __props__.__dict__["location_granularity_type"] = location_granularity_type
            __props__.__dict__["name"] = name
            __props__.__dict__["number_of_authentications"] = number_of_authentications
            __props__.__dict__["radius_from_location"] = radius_from_location
            __props__.__dict__["status"] = status
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["velocity"] = velocity
        super(Behaviour, __self__).__init__(
            'okta:index/behaviour:Behaviour',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            location_granularity_type: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            number_of_authentications: Optional[pulumi.Input[int]] = None,
            radius_from_location: Optional[pulumi.Input[int]] = None,
            status: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            velocity: Optional[pulumi.Input[int]] = None) -> 'Behaviour':
        """
        Get an existing Behaviour resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] location_granularity_type: Determines the method and level of detail used to evaluate the behavior.
               Required for `"ANOMALOUS_LOCATION"` behavior type. Can be set to `"LAT_LONG"`, `"CITY"`, `"COUNTRY"`
               or `"SUBDIVISION"`.
        :param pulumi.Input[str] name: Name of the behavior.
        :param pulumi.Input[int] number_of_authentications: The number of recent authentications used to evaluate the behavior. Required
               for `"ANOMALOUS_LOCATION"`, `"ANOMALOUS_DEVICE"` and `"ANOMALOUS_IP"` behavior types.
        :param pulumi.Input[int] radius_from_location: Radius from location (in kilometers). Should be at least 5. Required
               when `location_granularity_type` is set to `"LAT_LONG"`.
        :param pulumi.Input[str] status: The status of the behavior. By default, it is`"ACTIVE"`.
        :param pulumi.Input[str] type: Type of the behavior. Can be set to `"ANOMALOUS_LOCATION"`, `"ANOMALOUS_DEVICE"`, `"ANOMALOUS_IP"`
               or `"VELOCITY"`. Resource will be recreated when the type changes.
        :param pulumi.Input[int] velocity: Velocity (in kilometers per hour). Should be at least 1. Required for `"VELOCITY"` behavior
               type.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BehaviourState.__new__(_BehaviourState)

        __props__.__dict__["location_granularity_type"] = location_granularity_type
        __props__.__dict__["name"] = name
        __props__.__dict__["number_of_authentications"] = number_of_authentications
        __props__.__dict__["radius_from_location"] = radius_from_location
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        __props__.__dict__["velocity"] = velocity
        return Behaviour(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="locationGranularityType")
    def location_granularity_type(self) -> pulumi.Output[Optional[str]]:
        """
        Determines the method and level of detail used to evaluate the behavior.
        Required for `"ANOMALOUS_LOCATION"` behavior type. Can be set to `"LAT_LONG"`, `"CITY"`, `"COUNTRY"`
        or `"SUBDIVISION"`.
        """
        return pulumi.get(self, "location_granularity_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the behavior.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="numberOfAuthentications")
    def number_of_authentications(self) -> pulumi.Output[Optional[int]]:
        """
        The number of recent authentications used to evaluate the behavior. Required
        for `"ANOMALOUS_LOCATION"`, `"ANOMALOUS_DEVICE"` and `"ANOMALOUS_IP"` behavior types.
        """
        return pulumi.get(self, "number_of_authentications")

    @property
    @pulumi.getter(name="radiusFromLocation")
    def radius_from_location(self) -> pulumi.Output[Optional[int]]:
        """
        Radius from location (in kilometers). Should be at least 5. Required
        when `location_granularity_type` is set to `"LAT_LONG"`.
        """
        return pulumi.get(self, "radius_from_location")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[str]]:
        """
        The status of the behavior. By default, it is`"ACTIVE"`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Type of the behavior. Can be set to `"ANOMALOUS_LOCATION"`, `"ANOMALOUS_DEVICE"`, `"ANOMALOUS_IP"`
        or `"VELOCITY"`. Resource will be recreated when the type changes.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def velocity(self) -> pulumi.Output[Optional[int]]:
        """
        Velocity (in kilometers per hour). Should be at least 1. Required for `"VELOCITY"` behavior
        type.
        """
        return pulumi.get(self, "velocity")

