# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetEmailCustomizationResult',
    'AwaitableGetEmailCustomizationResult',
    'get_email_customization',
    'get_email_customization_output',
]

@pulumi.output_type
class GetEmailCustomizationResult:
    """
    A collection of values returned by getEmailCustomization.
    """
    def __init__(__self__, body=None, brand_id=None, customization_id=None, id=None, is_default=None, language=None, links=None, subject=None, template_name=None):
        if body and not isinstance(body, str):
            raise TypeError("Expected argument 'body' to be a str")
        pulumi.set(__self__, "body", body)
        if brand_id and not isinstance(brand_id, str):
            raise TypeError("Expected argument 'brand_id' to be a str")
        pulumi.set(__self__, "brand_id", brand_id)
        if customization_id and not isinstance(customization_id, str):
            raise TypeError("Expected argument 'customization_id' to be a str")
        pulumi.set(__self__, "customization_id", customization_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_default and not isinstance(is_default, bool):
            raise TypeError("Expected argument 'is_default' to be a bool")
        pulumi.set(__self__, "is_default", is_default)
        if language and not isinstance(language, str):
            raise TypeError("Expected argument 'language' to be a str")
        pulumi.set(__self__, "language", language)
        if links and not isinstance(links, str):
            raise TypeError("Expected argument 'links' to be a str")
        pulumi.set(__self__, "links", links)
        if subject and not isinstance(subject, str):
            raise TypeError("Expected argument 'subject' to be a str")
        pulumi.set(__self__, "subject", subject)
        if template_name and not isinstance(template_name, str):
            raise TypeError("Expected argument 'template_name' to be a str")
        pulumi.set(__self__, "template_name", template_name)

    @property
    @pulumi.getter
    def body(self) -> str:
        """
        The body of the customization
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter(name="brandId")
    def brand_id(self) -> str:
        return pulumi.get(self, "brand_id")

    @property
    @pulumi.getter(name="customizationId")
    def customization_id(self) -> str:
        return pulumi.get(self, "customization_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Customization ID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> bool:
        """
        Whether the customization is the default
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter
    def language(self) -> str:
        """
        The language supported by the customization
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter
    def links(self) -> str:
        """
        Link relations for this object - JSON HAL - Discoverable resources related to the email template
        """
        return pulumi.get(self, "links")

    @property
    @pulumi.getter
    def subject(self) -> str:
        """
        The subject of the customization
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> str:
        return pulumi.get(self, "template_name")


class AwaitableGetEmailCustomizationResult(GetEmailCustomizationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEmailCustomizationResult(
            body=self.body,
            brand_id=self.brand_id,
            customization_id=self.customization_id,
            id=self.id,
            is_default=self.is_default,
            language=self.language,
            links=self.links,
            subject=self.subject,
            template_name=self.template_name)


def get_email_customization(brand_id: Optional[str] = None,
                            customization_id: Optional[str] = None,
                            template_name: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEmailCustomizationResult:
    """
    Use this data source to retrieve the [email
    customization](https://developer.okta.com/docs/reference/api/brands/#get-email-customization)
    of an email template belonging to a brand in an Okta organization.


    :param str brand_id: Brand ID
    :param str customization_id: Customization ID
    :param str template_name: Template Name
    """
    __args__ = dict()
    __args__['brandId'] = brand_id
    __args__['customizationId'] = customization_id
    __args__['templateName'] = template_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('okta:index/getEmailCustomization:getEmailCustomization', __args__, opts=opts, typ=GetEmailCustomizationResult).value

    return AwaitableGetEmailCustomizationResult(
        body=__ret__.body,
        brand_id=__ret__.brand_id,
        customization_id=__ret__.customization_id,
        id=__ret__.id,
        is_default=__ret__.is_default,
        language=__ret__.language,
        links=__ret__.links,
        subject=__ret__.subject,
        template_name=__ret__.template_name)


@_utilities.lift_output_func(get_email_customization)
def get_email_customization_output(brand_id: Optional[pulumi.Input[str]] = None,
                                   customization_id: Optional[pulumi.Input[str]] = None,
                                   template_name: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEmailCustomizationResult]:
    """
    Use this data source to retrieve the [email
    customization](https://developer.okta.com/docs/reference/api/brands/#get-email-customization)
    of an email template belonging to a brand in an Okta organization.


    :param str brand_id: Brand ID
    :param str customization_id: Customization ID
    :param str template_name: Template Name
    """
    ...
