import { aws_ec2, aws_iam, Resource } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { BastionInstanceProps } from './instance-props';
export interface LinuxBastionProps extends BastionInstanceProps {
    /**
     * List of packages to be installed as part of the userdata using winget.
     *
     * @default - []
     * @stability experimental
     */
    readonly packages?: string[];
    /**
     * Package manager used for installing packages
     *
     * @default - dnf
     * @stability experimental
     */
    readonly packageManager?: LinuxPackageManager;
}
export declare enum LinuxPackageManager {
    APT = "apt-get",
    YUM = "yum",
    DNF = "dnf"
}
export declare class LinuxBastion extends Resource implements aws_ec2.IInstance {
    readonly securityGroup: aws_ec2.ISecurityGroup;
    readonly instanceId: string;
    readonly instanceAvailabilityZone: string;
    readonly instancePrivateDnsName: string;
    readonly instancePrivateIp: string;
    readonly instancePublicDnsName: string;
    readonly instancePublicIp: string;
    readonly connections: aws_ec2.Connections;
    readonly grantPrincipal: aws_iam.IPrincipal;
    readonly role: aws_iam.IRole;
    constructor(scope: Construct, id: string, props: LinuxBastionProps);
}
