"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LinuxBastion = exports.LinuxPackageManager = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const security_tag_1 = require("./security-tag");
var LinuxPackageManager;
(function (LinuxPackageManager) {
    LinuxPackageManager["APT"] = "apt-get";
    LinuxPackageManager["YUM"] = "yum";
    LinuxPackageManager["DNF"] = "dnf";
})(LinuxPackageManager = exports.LinuxPackageManager || (exports.LinuxPackageManager = {}));
class LinuxBastion extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        const securityTag = props?.securityTag
            ? props.securityTag
            : security_tag_1.DefaultSecurityTag;
        this.securityGroup = new aws_cdk_lib_1.aws_ec2.SecurityGroup(this, 'BastionSecurityGroup', {
            vpc: props.vpc,
            allowAllOutbound: true,
        });
        if (props.machineImage &&
            props.machineImage.getImage(this).osType !=
                aws_cdk_lib_1.aws_ec2.OperatingSystemType.LINUX)
            throw 'machineImage is not Linux based';
        const instanceType = props.instanceType
            ? props.instanceType
            : aws_cdk_lib_1.aws_ec2.InstanceType.of(aws_cdk_lib_1.aws_ec2.InstanceClass.T3A, aws_cdk_lib_1.aws_ec2.InstanceSize.LARGE);
        let amazonLinuxCpuType = aws_cdk_lib_1.aws_ec2.AmazonLinuxCpuType.ARM_64;
        if (instanceType.architecture == 'x86_64')
            amazonLinuxCpuType = aws_cdk_lib_1.aws_ec2.AmazonLinuxCpuType.X86_64;
        const machineImage = props.machineImage
            ? props.machineImage
            : aws_cdk_lib_1.aws_ec2.MachineImage.latestAmazonLinux({
                generation: aws_cdk_lib_1.aws_ec2.AmazonLinuxGeneration.AMAZON_LINUX_2,
                cpuType: amazonLinuxCpuType,
            });
        const instanceProps = {
            ...props,
            propagateTagsToVolumeOnCreation: true,
            userDataCausesReplacement: true,
            machineImage,
            instanceType,
        };
        const bastionInstance = new aws_cdk_lib_1.aws_ec2.Instance(this, 'BastionInstance', instanceProps);
        const packageManager = props.packageManager
            ? props.packageManager
            : LinuxPackageManager.DNF;
        bastionInstance.addUserData(`${packageManager} update -y`, `${packageManager} upgrade -y`);
        if (props.packages)
            bastionInstance.addUserData(`${packageManager} install -y ${props.packages.join(' ')}`);
        aws_cdk_lib_1.Tags.of(bastionInstance.instance).add(securityTag.key, securityTag.value);
        bastionInstance.role.addManagedPolicy(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        this.instanceId = bastionInstance.instanceId;
        this.instanceAvailabilityZone = bastionInstance.instanceAvailabilityZone;
        this.instancePrivateDnsName = bastionInstance.instancePrivateDnsName;
        this.instancePrivateIp = bastionInstance.instancePrivateIp;
        this.grantPrincipal = bastionInstance.grantPrincipal;
        this.instancePublicDnsName = bastionInstance.instancePublicDnsName;
        this.instancePublicIp = bastionInstance.instancePublicIp;
        this.connections = bastionInstance.connections;
        this.role = bastionInstance.role;
    }
}
exports.LinuxBastion = LinuxBastion;
_a = JSII_RTTI_SYMBOL_1;
LinuxBastion[_a] = { fqn: "pwed-cdk.bastion.LinuxBastion", version: "0.0.63" };
//# sourceMappingURL=data:application/json;base64,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