"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BastionPermissionSet = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const access_policy_1 = require("./access-policy");
const security_tag_1 = require("./security-tag");
class BastionPermissionSet extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.securityTag = props.securityTag
            ? props.securityTag
            : security_tag_1.DefaultSecurityTag;
        this.ssoInstanceArn = props.instanceArn;
        const accessPolicy = new access_policy_1.BastionAccessPolicy(this, 'BastionAccessPolicy', {
            securityTag: this.securityTag,
        });
        this.policy = accessPolicy.policy;
        this.permissionSet = new aws_cdk_lib_1.aws_sso.CfnPermissionSet(this, 'BastionAccessPermissionSet', {
            instanceArn: props.instanceArn,
            inlinePolicy: this.policy,
            name: props.name,
            sessionDuration: props.sessionDuration ? props.sessionDuration : 'PT4H',
            relayStateType: 'https://console.aws.amazon.com/systems-manager/managed-instances/rdp-connect',
        });
    }
    assign(accountId, principalId, principalType) {
        new aws_cdk_lib_1.aws_sso.CfnAssignment(this, `Account${accountId}${principalType}${principalId}`, {
            permissionSetArn: this.permissionSet
                .getAtt('PermissionSetArn')
                .toString(),
            principalType,
            principalId,
            instanceArn: this.ssoInstanceArn,
            targetType: 'AWS_ACCOUNT',
            targetId: accountId,
        });
    }
}
exports.BastionPermissionSet = BastionPermissionSet;
_a = JSII_RTTI_SYMBOL_1;
BastionPermissionSet[_a] = { fqn: "pwed-cdk.bastion.BastionPermissionSet", version: "0.0.63" };
//# sourceMappingURL=data:application/json;base64,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