"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StaticSite = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const child_process = require("child_process");
const crypto = require("crypto");
const fs = require("fs");
const path_1 = require("path");
const process = require("process");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const glob_1 = require("glob");
class StaticSite extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const bucket = new aws_cdk_lib_1.aws_s3.Bucket(this, 'Bucket', {
            encryption: aws_cdk_lib_1.aws_s3.BucketEncryption.S3_MANAGED,
            lifecycleRules: [
                {
                    transitions: [
                        {
                            storageClass: aws_cdk_lib_1.aws_s3.StorageClass.INTELLIGENT_TIERING,
                            transitionAfter: aws_cdk_lib_1.Duration.days(7),
                        },
                    ],
                },
            ],
        });
        const hostedZone = props.hostedZone
            ? props.hostedZone
            : aws_cdk_lib_1.aws_route53.HostedZone.fromLookup(this, `HostedZone${props.domain}`, {
                domainName: props.domain,
            });
        const alternativeHostedZones = props.alternativeHostedZones
            ? props.alternativeHostedZones
            : props.alternativeDomains
                ? props.alternativeDomains.map((domain) => {
                    return aws_cdk_lib_1.aws_route53.HostedZone.fromLookup(this, `HostedZone${domain}`, {
                        domainName: domain,
                    });
                })
                : undefined;
        let domainValidation = {
            [props.domain]: hostedZone,
        };
        props.alternativeDomains?.map((domain, index) => {
            domainValidation[domain] = alternativeHostedZones[index];
        });
        const certificate = new aws_cdk_lib_1.aws_certificatemanager.Certificate(this, 'Certificate', {
            domainName: props.domain,
            subjectAlternativeNames: props.alternativeDomains,
            validation: aws_cdk_lib_1.aws_certificatemanager.CertificateValidation.fromDnsMultiZone(domainValidation),
        });
        const originAccessIdentity = new aws_cdk_lib_1.aws_cloudfront.OriginAccessIdentity(this, 'OriginAccessIdentity');
        bucket.grantRead(originAccessIdentity);
        let prettyPathHandler;
        if (props.enablePrettyPaths)
            prettyPathHandler = new aws_cdk_lib_1.aws_cloudfront.Function(this, 'PrettyPathHandler', {
                code: aws_cdk_lib_1.aws_cloudfront.FunctionCode.fromFile({
                    filePath: path_1.join(__dirname, 'prettyPathHandler.js'),
                }),
            });
        this.distribution = new aws_cdk_lib_1.aws_cloudfront.Distribution(this, 'Distribution', {
            defaultBehavior: {
                origin: new aws_cdk_lib_1.aws_cloudfront_origins.S3Origin(bucket, {
                    originAccessIdentity,
                }),
                allowedMethods: aws_cdk_lib_1.aws_cloudfront.AllowedMethods.ALLOW_GET_HEAD_OPTIONS,
                viewerProtocolPolicy: aws_cdk_lib_1.aws_cloudfront.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
                functionAssociations: props.enablePrettyPaths
                    ? [
                        {
                            function: prettyPathHandler,
                            eventType: aws_cdk_lib_1.aws_cloudfront.FunctionEventType.VIEWER_REQUEST,
                        },
                    ]
                    : undefined,
            },
            domainNames: props.alternativeDomains
                ? [props.domain, ...props.alternativeDomains]
                : [props.domain],
            certificate,
            errorResponses: [
                {
                    httpStatus: 404,
                    responseHttpStatus: 404,
                    responsePagePath: '/404.html',
                },
            ],
            defaultRootObject: 'index.html',
            httpVersion: aws_cdk_lib_1.aws_cloudfront.HttpVersion.HTTP2_AND_3,
        });
        new aws_cdk_lib_1.aws_route53.ARecord(this, 'AAliasRecord', {
            recordName: props.domain,
            zone: hostedZone,
            target: aws_cdk_lib_1.aws_route53.RecordTarget.fromAlias(new aws_cdk_lib_1.aws_route53_targets.CloudFrontTarget(this.distribution)),
        });
        new aws_cdk_lib_1.aws_route53.AaaaRecord(this, 'AaaaAliasRecord', {
            recordName: props.domain,
            zone: hostedZone,
            target: aws_cdk_lib_1.aws_route53.RecordTarget.fromAlias(new aws_cdk_lib_1.aws_route53_targets.CloudFrontTarget(this.distribution)),
        });
        props.alternativeDomains?.map((domain, index) => {
            new aws_cdk_lib_1.aws_route53.ARecord(this, `AAliasRecord${domain}`, {
                recordName: domain,
                zone: alternativeHostedZones[index],
                target: aws_cdk_lib_1.aws_route53.RecordTarget.fromAlias(new aws_cdk_lib_1.aws_route53_targets.CloudFrontTarget(this.distribution)),
            });
            new aws_cdk_lib_1.aws_route53.AaaaRecord(this, `AaaaAliasRecord${domain}`, {
                recordName: domain,
                zone: alternativeHostedZones[index],
                target: aws_cdk_lib_1.aws_route53.RecordTarget.fromAlias(new aws_cdk_lib_1.aws_route53_targets.CloudFrontTarget(this.distribution)),
            });
        });
        const hashFile = '/.hashfile.json';
        let invalidations = [hashFile];
        invalidations.push(...compareRemoteToLocal(props.domain, hashFile, props.path));
        new aws_cdk_lib_1.aws_s3_deployment.BucketDeployment(this, 'StaticDeployment', {
            sources: [aws_cdk_lib_1.aws_s3_deployment.Source.asset(props.path)],
            destinationBucket: bucket,
            distribution: this.distribution,
            distributionPaths: invalidations,
        });
    }
}
exports.StaticSite = StaticSite;
_a = JSII_RTTI_SYMBOL_1;
StaticSite[_a] = { fqn: "pwed-cdk.static_site.StaticSite", version: "0.0.63" };
function getHashes(globPattern, dir) {
    let fh = new Map();
    const gs = glob_1.sync(globPattern, { cwd: dir, nodir: true });
    const pwd = process.cwd();
    process.chdir(dir);
    gs.forEach(function (file) {
        const fileBuffer = fs.readFileSync(file, {});
        const hashSum = crypto.createHash('sha256');
        hashSum.update(fileBuffer);
        const hex = hashSum.digest('hex');
        fh.set(file, hex);
    });
    process.chdir(pwd);
    return fh;
}
function getInvalidations(oldHashes, newHashes) {
    let invalidations = [];
    oldHashes.forEach(function (v, k) {
        if (newHashes.get(k) !== v) {
            invalidations.push(`/${k}`);
        }
    });
    return invalidations;
}
function compareRemoteToLocal(domain, hashFile, localFolder) {
    let oldHashesJSON;
    const newHashes = getHashes('**', localFolder);
    fs.writeFileSync(path_1.join(localFolder, hashFile), JSON.stringify(Object.fromEntries(newHashes)));
    try {
        oldHashesJSON = child_process
            .execSync(`curl -s https://${domain}/${hashFile}`)
            .toString();
    }
    catch (e) {
        console.error(e);
        return ['/*'];
    }
    let oldHashes;
    try {
        oldHashes = new Map(Object.entries(JSON.parse(oldHashesJSON)));
    }
    catch (e) {
        return ['/*'];
    }
    return getInvalidations(oldHashes, newHashes);
}
//# sourceMappingURL=data:application/json;base64,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