import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [directconnect](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsdirectconnect.html).
 *
 * @experimental
 */
export declare class Directconnect extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to accept a proposal request to attach a virtual private gateway to a Direct Connect gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_AcceptDirectConnectGatewayAssociationProposal.html
     *
     * @experimental
     */
    toAcceptDirectConnectGatewayAssociationProposal(): this;
    /**
     * (experimental) Grants permission to create a hosted connection on an interconnect.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_AllocateConnectionOnInterconnect.html
     *
     * @experimental
     */
    toAllocateConnectionOnInterconnect(): this;
    /**
     * (experimental) Grants permission to create a new hosted connection between a AWS Direct Connect partner's network and a specific AWS Direct Connect location.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_AllocateHostedConnection.html
     *
     * @experimental
     */
    toAllocateHostedConnection(): this;
    /**
     * (experimental) Grants permission to provision a private virtual interface to be owned by a different customer.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_AllocatePrivateVirtualInterface.html
     *
     * @experimental
     */
    toAllocatePrivateVirtualInterface(): this;
    /**
     * (experimental) Grants permission to provision a public virtual interface to be owned by a different customer.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_AllocatePublicVirtualInterface.html
     *
     * @experimental
     */
    toAllocatePublicVirtualInterface(): this;
    /**
     * (experimental) Grants permission to provision a transit virtual interface to be owned by a different customer.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_AllocateTransitVirtualInterface.html
     *
     * @experimental
     */
    toAllocateTransitVirtualInterface(): this;
    /**
     * (experimental) Grants permission to associate a connection with a LAG.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_AssociateConnectionWithLag.html
     *
     * @experimental
     */
    toAssociateConnectionWithLag(): this;
    /**
     * (experimental) Grants permission to associate a hosted connection and its virtual interfaces with a link aggregation group (LAG) or interconnect.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_AssociateHostedConnection.html
     *
     * @experimental
     */
    toAssociateHostedConnection(): this;
    /**
     * (experimental) Grants permission to associate a MAC Security (MACsec) Connection Key Name (CKN)/ Connectivity Association Key (CAK) pair with an AWS Direct Connect dedicated connection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_AssociateMacSecKey.html
     *
     * @experimental
     */
    toAssociateMacSecKey(): this;
    /**
     * (experimental) Grants permission to associate a virtual interface with a specified link aggregation group (LAG) or connection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_AssociateVirtualInterface.html
     *
     * @experimental
     */
    toAssociateVirtualInterface(): this;
    /**
     * (experimental) Grants permission to confirm the creation of a hosted connection on an interconnect.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_ConfirmConnection.html
     *
     * @experimental
     */
    toConfirmConnection(): this;
    /**
     * (experimental) Grants permission to confirm the the terms of agreement when creating the connection or link aggregation group (LAG).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_ConfirmCustomerAgreement.html
     *
     * @experimental
     */
    toConfirmCustomerAgreement(): this;
    /**
     * (experimental) Grants permission to accept ownership of a private virtual interface created by another customer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_ConfirmPrivateVirtualInterface.html
     *
     * @experimental
     */
    toConfirmPrivateVirtualInterface(): this;
    /**
     * (experimental) Grants permission to accept ownership of a public virtual interface created by another customer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_ConfirmPublicVirtualInterface.html
     *
     * @experimental
     */
    toConfirmPublicVirtualInterface(): this;
    /**
     * (experimental) Grants permission to accept ownership of a transit virtual interface created by another customer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_ConfirmTransitVirtualInterface.html
     *
     * @experimental
     */
    toConfirmTransitVirtualInterface(): this;
    /**
     * (experimental) Grants permission to create a BGP peer on the specified virtual interface.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_CreateBGPPeer.html
     *
     * @experimental
     */
    toCreateBGPPeer(): this;
    /**
     * (experimental) Grants permission to create a new connection between the customer network and a specific AWS Direct Connect location.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_CreateConnection.html
     *
     * @experimental
     */
    toCreateConnection(): this;
    /**
     * (experimental) Grants permission to create a Direct Connect gateway, which is an intermediate object that enables you to connect a set of virtual interfaces and virtual private gateways.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_CreateDirectConnectGateway.html
     *
     * @experimental
     */
    toCreateDirectConnectGateway(): this;
    /**
     * (experimental) Grants permission to create an association between a Direct Connect gateway and a virtual private gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_CreateDirectConnectGatewayAssociation.html
     *
     * @experimental
     */
    toCreateDirectConnectGatewayAssociation(): this;
    /**
     * (experimental) Grants permission to create a proposal to associate the specified virtual private gateway with the specified Direct Connect gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_CreateDirectConnectGatewayAssociationProposal.html
     *
     * @experimental
     */
    toCreateDirectConnectGatewayAssociationProposal(): this;
    /**
     * (experimental) Grants permission to create a new interconnect between a AWS Direct Connect partner's network and a specific AWS Direct Connect location.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_CreateInterconnect.html
     *
     * @experimental
     */
    toCreateInterconnect(): this;
    /**
     * (experimental) Grants permission to create a link aggregation group (LAG) with the specified number of bundled physical connections between the customer network and a specific AWS Direct Connect location.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_CreateLag.html
     *
     * @experimental
     */
    toCreateLag(): this;
    /**
     * (experimental) Grants permission to create a new private virtual interface.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_CreatePrivateVirtualInterface.html
     *
     * @experimental
     */
    toCreatePrivateVirtualInterface(): this;
    /**
     * (experimental) Grants permission to create a new public virtual interface.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_CreatePublicVirtualInterface.html
     *
     * @experimental
     */
    toCreatePublicVirtualInterface(): this;
    /**
     * (experimental) Grants permission to create a new transit virtual interface.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_CreateTransitVirtualInterface.html
     *
     * @experimental
     */
    toCreateTransitVirtualInterface(): this;
    /**
     * (experimental) Grants permission to delete the specified BGP peer on the specified virtual interface with the specified customer address and ASN.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DeleteBGPPeer.html
     *
     * @experimental
     */
    toDeleteBGPPeer(): this;
    /**
     * (experimental) Grants permission to delete the connection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DeleteConnection.html
     *
     * @experimental
     */
    toDeleteConnection(): this;
    /**
     * (experimental) Grants permission to delete the specified Direct Connect gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DeleteDirectConnectGateway.html
     *
     * @experimental
     */
    toDeleteDirectConnectGateway(): this;
    /**
     * (experimental) Grants permission to delete the association between the specified Direct Connect gateway and virtual private gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DeleteDirectConnectGatewayAssociation.html
     *
     * @experimental
     */
    toDeleteDirectConnectGatewayAssociation(): this;
    /**
     * (experimental) Grants permission to delete the association proposal request between the specified Direct Connect gateway and virtual private gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DeleteDirectConnectGatewayAssociationProposal.html
     *
     * @experimental
     */
    toDeleteDirectConnectGatewayAssociationProposal(): this;
    /**
     * (experimental) Grants permission to delete the specified interconnect.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DeleteInterconnect.html
     *
     * @experimental
     */
    toDeleteInterconnect(): this;
    /**
     * (experimental) Grants permission to delete the specified link aggregation group (LAG).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DeleteLag.html
     *
     * @experimental
     */
    toDeleteLag(): this;
    /**
     * (experimental) Grants permission to delete a virtual interface.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DeleteVirtualInterface.html
     *
     * @experimental
     */
    toDeleteVirtualInterface(): this;
    /**
     * (experimental) Grants permission to describe the LOA-CFA for a Connection.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeConnectionLoa.html
     *
     * @experimental
     */
    toDescribeConnectionLoa(): this;
    /**
     * (experimental) Grants permission to describe all connections in this region.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeConnections.html
     *
     * @experimental
     */
    toDescribeConnections(): this;
    /**
     * (experimental) Grants permission to describe a list of connections that have been provisioned on the given interconnect.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeConnectionsOnInterconnect.html
     *
     * @experimental
     */
    toDescribeConnectionsOnInterconnect(): this;
    /**
     * (experimental) Grants permission to view a list of customer agreements, along with their signed status and whether the customer is an NNIPartner, NNIPartnerV2, or a nonPartner.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeCustomerMetadata.html
     *
     * @experimental
     */
    toDescribeCustomerMetadata(): this;
    /**
     * (experimental) Grants permission to describe one or more association proposals for connection between a virtual private gateway and a Direct Connect gateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeDirectConnectGatewayAssociationProposals.html
     *
     * @experimental
     */
    toDescribeDirectConnectGatewayAssociationProposals(): this;
    /**
     * (experimental) Grants permission to describe the associations between your Direct Connect gateways and virtual private gateways.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeDirectConnectGatewayAssociations.html
     *
     * @experimental
     */
    toDescribeDirectConnectGatewayAssociations(): this;
    /**
     * (experimental) Grants permission to describe the attachments between your Direct Connect gateways and virtual interfaces.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeDirectConnectGatewayAttachments.html
     *
     * @experimental
     */
    toDescribeDirectConnectGatewayAttachments(): this;
    /**
     * (experimental) Grants permission to describe all your Direct Connect gateways or only the specified Direct Connect gateway.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeDirectConnectGateways.html
     *
     * @experimental
     */
    toDescribeDirectConnectGateways(): this;
    /**
     * (experimental) Grants permission to describe the hosted connections that have been provisioned on the specified interconnect or link aggregation group (LAG).
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeHostedConnections.html
     *
     * @experimental
     */
    toDescribeHostedConnections(): this;
    /**
     * (experimental) Grants permission to describe the LOA-CFA for an Interconnect.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeInterconnectLoa.html
     *
     * @experimental
     */
    toDescribeInterconnectLoa(): this;
    /**
     * (experimental) Grants permission to describe a list of interconnects owned by the AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeInterconnects.html
     *
     * @experimental
     */
    toDescribeInterconnects(): this;
    /**
     * (experimental) Grants permission to describe all your link aggregation groups (LAG) or the specified LAG.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeLags.html
     *
     * @experimental
     */
    toDescribeLags(): this;
    /**
     * (experimental) Grants permission to describe the LOA-CFA for a connection, interconnect, or link aggregation group (LAG).
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeLoa.html
     *
     * @experimental
     */
    toDescribeLoa(): this;
    /**
     * (experimental) Grants permission to describe the list of AWS Direct Connect locations in the current AWS region.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeLocations.html
     *
     * @experimental
     */
    toDescribeLocations(): this;
    /**
     * (experimental) Grants permission to describe Details about the router for a virtual interface.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeRouterConfiguration.html
     *
     * @experimental
     */
    toDescribeRouterConfiguration(): this;
    /**
     * (experimental) Grants permission to describe the tags associated with the specified AWS Direct Connect resources.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeTags.html
     *
     * @experimental
     */
    toDescribeTags(): this;
    /**
     * (experimental) Grants permission to describe a list of virtual private gateways owned by the AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeVirtualGateways.html
     *
     * @experimental
     */
    toDescribeVirtualGateways(): this;
    /**
     * (experimental) Grants permission to describe all virtual interfaces for an AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeVirtualInterfaces.html
     *
     * @experimental
     */
    toDescribeVirtualInterfaces(): this;
    /**
     * (experimental) Grants permission to disassociate a connection from a link aggregation group (LAG).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DisassociateConnectionFromLag.html
     *
     * @experimental
     */
    toDisassociateConnectionFromLag(): this;
    /**
     * (experimental) Grants permission to remove the association between a MAC Security (MACsec) security key and an AWS Direct Connect dedicated connection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DisassociateMacSecKey.html
     *
     * @experimental
     */
    toDisassociateMacSecKey(): this;
    /**
     * (experimental) Grants permission to list the virtual interface failover test history.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_ListVirtualInterfaceTestHistory.html
     *
     * @experimental
     */
    toListVirtualInterfaceTestHistory(): this;
    /**
     * (experimental) Grants permission to start the virtual interface failover test that verifies your configuration meets your resiliency requirements by placing the BGP peering session in the DOWN state.
     *
     * You can then send traffic to verify that there are no outages
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_StartBgpFailoverTest.html
     *
     * @experimental
     */
    toStartBgpFailoverTest(): this;
    /**
     * (experimental) Grants permission to stop the virtual interface failover test.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_StopBgpFailoverTest.html
     *
     * @experimental
     */
    toStopBgpFailoverTest(): this;
    /**
     * (experimental) Grants permission to add the specified tags to the specified AWS Direct Connect resource.
     *
     * Each resource can have a maximum of 50 tags
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove one or more tags from the specified AWS Direct Connect resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update the AWS Direct Connect dedicated connection configuration.
     *
     * You can update the following parameters for a connection: The connection name or The connection's MAC Security (MACsec) encryption mode
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_UpdateConnection.html
     *
     * @experimental
     */
    toUpdateConnection(): this;
    /**
     * (experimental) Grants permission to update the name of a Direct Connect gateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_UpdateDirectConnectGateway.html
     *
     * @experimental
     */
    toUpdateDirectConnectGateway(): this;
    /**
     * (experimental) Grants permission to update the specified attributes of the Direct Connect gateway association.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_UpdateDirectConnectGatewayAssociation.html
     *
     * @experimental
     */
    toUpdateDirectConnectGatewayAssociation(): this;
    /**
     * (experimental) Grants permission to update the attributes of the specified link aggregation group (LAG).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_UpdateLag.html
     *
     * @experimental
     */
    toUpdateLag(): this;
    /**
     * (experimental) Grants permission to update the specified attributes of the specified virtual private interface.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_UpdateVirtualInterfaceAttributes.html
     *
     * @experimental
     */
    toUpdateVirtualInterfaceAttributes(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type dxcon to the statement.
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_Connection.html
     *
     * @param connectionId - Identifier for the connectionId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDxcon(connectionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type dxlag to the statement.
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_Lag.html
     *
     * @param lagId - Identifier for the lagId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDxlag(lagId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type dxvif to the statement.
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_VirtualInterface.html
     *
     * @param virtualInterfaceId - Identifier for the virtualInterfaceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDxvif(virtualInterfaceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type dx-gateway to the statement.
     *
     * https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DirectConnectGateway.html
     *
     * @param directConnectGatewayId - Identifier for the directConnectGatewayId.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onDxGateway(directConnectGatewayId: string, account?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [directconnect](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsdirectconnect.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
