import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [iot-device-tester](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotdevicetester.html).
 *
 * @experimental
 */
export declare class IotDeviceTester extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission for IoT Device Tester to check if a given set of product, test suite and device tester version are compatible.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     *
     * @experimental
     */
    toCheckVersion(): this;
    /**
     * (experimental) Grants permission for IoT Device Tester to download compatible test suite versions.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     *
     * @experimental
     */
    toDownloadTestSuite(): this;
    /**
     * (experimental) Grants permission for IoT Device Tester to get information on latest version of device tester available.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     *
     * @experimental
     */
    toLatestIdt(): this;
    /**
     * (experimental) Grants permissions for IoT Device Tester to send usage metrics on your behalf.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     *
     * @experimental
     */
    toSendMetrics(): this;
    /**
     * (experimental) Grants permission for IoT Device Tester to get list of supported products and test suite versions.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     *
     * @experimental
     */
    toSupportedVersion(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Statement provider for service [iot-device-tester](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotdevicetester.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
