import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [sms](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsservermigrationservice.html).
 *
 * @experimental
 */
export declare class Sms extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to create an application configuration to migrate on-premise application onto AWS.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_CreateApp.html
     *
     * @experimental
     */
    toCreateApp(): this;
    /**
     * (experimental) Grants permission to create a job to migrate on-premise server onto AWS.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_CreateReplicationJob.html
     *
     * @experimental
     */
    toCreateReplicationJob(): this;
    /**
     * (experimental) Grants permission to delete an existing application configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteApp.html
     *
     * @experimental
     */
    toDeleteApp(): this;
    /**
     * (experimental) Grants permission to delete launch configuration for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteAppLaunchConfiguration.html
     *
     * @experimental
     */
    toDeleteAppLaunchConfiguration(): this;
    /**
     * (experimental) Grants permission to delete replication configuration for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteAppReplicationConfiguration.html
     *
     * @experimental
     */
    toDeleteAppReplicationConfiguration(): this;
    /**
     * (experimental) Grants permission to delete validation configuration for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteAppValidationConfiguration.html
     *
     * @experimental
     */
    toDeleteAppValidationConfiguration(): this;
    /**
     * (experimental) Grants permission to delete an existing job to migrate on-premise server onto AWS.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteReplicationJob.html
     *
     * @experimental
     */
    toDeleteReplicationJob(): this;
    /**
     * (experimental) Grants permission to delete the complete list of on-premise servers gathered into AWS.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DeleteServerCatalog.html
     *
     * @experimental
     */
    toDeleteServerCatalog(): this;
    /**
     * (experimental) Grants permission to disassociate a connector that has been associated.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_DisassociateConnector.html
     *
     * @experimental
     */
    toDisassociateConnector(): this;
    /**
     * (experimental) Grants permission to generate a changeSet for the CloudFormation stack of an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GenerateChangeSet.html
     *
     * @experimental
     */
    toGenerateChangeSet(): this;
    /**
     * (experimental) Grants permission to generate a CloudFormation template for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GenerateTemplate.html
     *
     * @experimental
     */
    toGenerateTemplate(): this;
    /**
     * (experimental) Grants permission to get the configuration and statuses for an existing application.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetApp.html
     *
     * @experimental
     */
    toGetApp(): this;
    /**
     * (experimental) Grants permission to get launch configuration for an existing application.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetAppLaunchConfiguration.html
     *
     * @experimental
     */
    toGetAppLaunchConfiguration(): this;
    /**
     * (experimental) Grants permission to get replication configuration for an existing application.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetAppReplicationConfiguration.html
     *
     * @experimental
     */
    toGetAppReplicationConfiguration(): this;
    /**
     * (experimental) Grants permission to get validation configuration for an existing application.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetAppValidationConfiguration.html
     *
     * @experimental
     */
    toGetAppValidationConfiguration(): this;
    /**
     * (experimental) Grants permission to get notification sent from application validation script.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetAppValidationOutput.html
     *
     * @experimental
     */
    toGetAppValidationOutput(): this;
    /**
     * (experimental) Grants permission to get all connectors that have been associated.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetConnectors.html
     *
     * @experimental
     */
    toGetConnectors(): this;
    /**
     * (experimental) Grants permission to gets messages from AWS Server Migration Service to Server Migration Connector.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetMessages(): this;
    /**
     * (experimental) Grants permission to get all existing jobs to migrate on-premise servers onto AWS.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetReplicationJobs.html
     *
     * @experimental
     */
    toGetReplicationJobs(): this;
    /**
     * (experimental) Grants permission to get all runs for an existing job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetReplicationRuns.html
     *
     * @experimental
     */
    toGetReplicationRuns(): this;
    /**
     * (experimental) Grants permission to get all servers that have been imported.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_GetServers.html
     *
     * @experimental
     */
    toGetServers(): this;
    /**
     * (experimental) Grants permission to import application catalog from AWS Application Discovery Service.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_ImportAppCatalog.html
     *
     * @experimental
     */
    toImportAppCatalog(): this;
    /**
     * (experimental) Grants permission to gather a complete list of on-premise servers.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_ImportServerCatalog.html
     *
     * @experimental
     */
    toImportServerCatalog(): this;
    /**
     * (experimental) Grants permission to create and launch a CloudFormation stack for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_LaunchApp.html
     *
     * @experimental
     */
    toLaunchApp(): this;
    /**
     * (experimental) Grants permission to get a list of summaries for existing applications.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_ListAppss.html
     *
     * @experimental
     */
    toListApps(): this;
    /**
     * (experimental) Grants permission to send notification for application validation script.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_NotifyAppValidationOutput.html
     *
     * @experimental
     */
    toNotifyAppValidationOutput(): this;
    /**
     * (experimental) Grants permission to create or update launch configuration for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_PutAppLaunchConfiguration.html
     *
     * @experimental
     */
    toPutAppLaunchConfiguration(): this;
    /**
     * (experimental) Grants permission to create or update replication configuration for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_PutAppReplicationConfiguration.html
     *
     * @experimental
     */
    toPutAppReplicationConfiguration(): this;
    /**
     * (experimental) Grants permission to put validation configuration for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_PutAppValidationConfiguration.html
     *
     * @experimental
     */
    toPutAppValidationConfiguration(): this;
    /**
     * (experimental) Grants permission to send message from Server Migration Connector to AWS Server Migration Service.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toSendMessage(): this;
    /**
     * (experimental) Grants permission to create and start replication jobs for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_StartAppReplication.html
     *
     * @experimental
     */
    toStartAppReplication(): this;
    /**
     * (experimental) Grants permission to start a replication run for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_StartOnDemandAppReplication.html
     *
     * @experimental
     */
    toStartOnDemandAppReplication(): this;
    /**
     * (experimental) Grants permission to start a replication run for an existing replication job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_StartOnDemandReplicationRun.html
     *
     * @experimental
     */
    toStartOnDemandReplicationRun(): this;
    /**
     * (experimental) Grants permission to stop and delete replication jobs for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_StopAppReplication.html
     *
     * @experimental
     */
    toStopAppReplication(): this;
    /**
     * (experimental) Grants permission to terminate the CloudFormation stack for an existing application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_TerminateApp.html
     *
     * @experimental
     */
    toTerminateApp(): this;
    /**
     * (experimental) Grants permission to update an existing application configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_UpdateApp.html
     *
     * @experimental
     */
    toUpdateApp(): this;
    /**
     * (experimental) Grants permission to update an existing job to migrate on-premise server onto AWS.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/APIReference/API_UpdateReplicationJob.html
     *
     * @experimental
     */
    toUpdateReplicationJob(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Statement provider for service [sms](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsservermigrationservice.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
