"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Snowball = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [snowball](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssnowball.html).
 *
 * @experimental
 */
class Snowball extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [snowball](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssnowball.html).
     *
     * @experimental
     */
    constructor(props) {
        super(props);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'snowball';
        /**
         * @experimental
         */
        this.accessLevelList = {
            Write: [
                'CancelCluster',
                'CancelJob',
                'CreateAddress',
                'CreateCluster',
                'CreateJob',
                'CreateLongTermPricing',
                'CreateReturnShippingLabel',
                'UpdateCluster',
                'UpdateJob',
                'UpdateJobShipmentState',
                'UpdateLongTermPricing'
            ],
            Read: [
                'DescribeAddress',
                'DescribeCluster',
                'DescribeJob',
                'DescribeReturnShippingLabel',
                'GetJobManifest',
                'GetJobUnlockCode',
                'GetSnowballUsage',
                'GetSoftwareUpdates',
                'ListLongTermPricing'
            ],
            List: [
                'DescribeAddresses',
                'ListClusterJobs',
                'ListClusters',
                'ListCompatibleImages',
                'ListJobs'
            ]
        };
    }
    /**
     * (experimental) Cancels a cluster job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CancelCluster.html
     *
     * @experimental
     */
    toCancelCluster() {
        return this.to('CancelCluster');
    }
    /**
     * (experimental) Cancels the specified job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CancelJob.html
     *
     * @experimental
     */
    toCancelJob() {
        return this.to('CancelJob');
    }
    /**
     * (experimental) Creates an address for a Snowball to be shipped to.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CreateAddress.html
     *
     * @experimental
     */
    toCreateAddress() {
        return this.to('CreateAddress');
    }
    /**
     * (experimental) Creates an empty cluster.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CreateCluster.html
     *
     * @experimental
     */
    toCreateCluster() {
        return this.to('CreateCluster');
    }
    /**
     * (experimental) Creates a job to import or export data between Amazon S3 and your on-premises data center.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CreateJob.html
     *
     * @experimental
     */
    toCreateJob() {
        return this.to('CreateJob');
    }
    /**
     * (experimental) Grants permission to creates a LongTermPricingListEntry for allowing customers to add an upfront billing contract for a job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CreateLongTermPricing.html
     *
     * @experimental
     */
    toCreateLongTermPricing() {
        return this.to('CreateLongTermPricing');
    }
    /**
     * (experimental) Creates a shipping label that will be used to return the Snow device to AWS.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CreateReturnShippingLabel.html
     *
     * @experimental
     */
    toCreateReturnShippingLabel() {
        return this.to('CreateReturnShippingLabel');
    }
    /**
     * (experimental) Takes an AddressId and returns specific details about that address in the form of an Address object.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeAddress.html
     *
     * @experimental
     */
    toDescribeAddress() {
        return this.to('DescribeAddress');
    }
    /**
     * (experimental) Returns a specified number of ADDRESS objects.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeAddresses.html
     *
     * @experimental
     */
    toDescribeAddresses() {
        return this.to('DescribeAddresses');
    }
    /**
     * (experimental) Returns information about a specific cluster including shipping information, cluster status, and other important metadata.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeCluster.html
     *
     * @experimental
     */
    toDescribeCluster() {
        return this.to('DescribeCluster');
    }
    /**
     * (experimental) Returns information about a specific job including shipping information, job status, and other important metadata.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeJob.html
     *
     * @experimental
     */
    toDescribeJob() {
        return this.to('DescribeJob');
    }
    /**
     * (experimental) Information on the shipping label of a Snow device that is being returned to AWS.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeReturnShippingLabel.html
     *
     * @experimental
     */
    toDescribeReturnShippingLabel() {
        return this.to('DescribeReturnShippingLabel');
    }
    /**
     * (experimental) Returns a link to an Amazon S3 presigned URL for the manifest file associated with the specified JobId value.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_GetJobManifest.html
     *
     * @experimental
     */
    toGetJobManifest() {
        return this.to('GetJobManifest');
    }
    /**
     * (experimental) Returns the UnlockCode code value for the specified job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_GetJobUnlockCode.html
     *
     * @experimental
     */
    toGetJobUnlockCode() {
        return this.to('GetJobUnlockCode');
    }
    /**
     * (experimental) Returns information about the Snowball service limit for your account, and also the number of Snowballs your account has in use.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_GetSnowballUsage.html
     *
     * @experimental
     */
    toGetSnowballUsage() {
        return this.to('GetSnowballUsage');
    }
    /**
     * (experimental) Returns an Amazon S3 presigned URL for an update file associated with a specified JobId.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_GetSoftwareUpdates.html
     *
     * @experimental
     */
    toGetSoftwareUpdates() {
        return this.to('GetSoftwareUpdates');
    }
    /**
     * (experimental) Returns an array of JobListEntry objects of the specified length.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListClusterJobs.html
     *
     * @experimental
     */
    toListClusterJobs() {
        return this.to('ListClusterJobs');
    }
    /**
     * (experimental) Returns an array of ClusterListEntry objects of the specified length.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListClusters.html
     *
     * @experimental
     */
    toListClusters() {
        return this.to('ListClusters');
    }
    /**
     * (experimental) This action returns a list of the different Amazon EC2 Amazon Machine Images (AMIs) that are owned by your AWS account that would be supported for use on a Snow device.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListCompatibleImages.html
     *
     * @experimental
     */
    toListCompatibleImages() {
        return this.to('ListCompatibleImages');
    }
    /**
     * (experimental) Returns an array of JobListEntry objects of the specified length.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListJobs.html
     *
     * @experimental
     */
    toListJobs() {
        return this.to('ListJobs');
    }
    /**
     * (experimental) Grants permission to list LongTermPricingListEntry objects for the account making the request.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListLongTermPricing.html
     *
     * @experimental
     */
    toListLongTermPricing() {
        return this.to('ListLongTermPricing');
    }
    /**
     * (experimental) While a cluster's ClusterState value is in the AwaitingQuorum state, you can update some of the information associated with a cluster.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_UpdateCluster.html
     *
     * @experimental
     */
    toUpdateCluster() {
        return this.to('UpdateCluster');
    }
    /**
     * (experimental) While a job's JobState value is New, you can update some of the information associated with a job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_UpdateJob.html
     *
     * @experimental
     */
    toUpdateJob() {
        return this.to('UpdateJob');
    }
    /**
     * (experimental) Updates the state when a the shipment states changes to a different state.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_UpdateJobShipmentState.html
     *
     * @experimental
     */
    toUpdateJobShipmentState() {
        return this.to('UpdateJobShipmentState');
    }
    /**
     * (experimental) Grants permission to update a specific upfront billing contract for a job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_UpdateLongTermPricing.html
     *
     * @experimental
     */
    toUpdateLongTermPricing() {
        return this.to('UpdateLongTermPricing');
    }
}
exports.Snowball = Snowball;
_a = JSII_RTTI_SYMBOL_1;
Snowball[_a] = { fqn: "cdk-iam-floyd.Snowball", version: "0.300.0" };
//# sourceMappingURL=data:application/json;base64,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