import * as React from 'react';
import { classes } from 'typestyle';
import { fileIconStyle, fileLabelStyle, folderLabelStyle } from '../style/FilePathStyle';
import { extractFilename, getFileIconClassName } from '../utils';
function getFileIconClass(path) {
    return getFileIconClassName(path);
}
export const FilePath = (props) => {
    const filename = extractFilename(props.filepath);
    const folder = props.filepath
        .slice(0, props.filepath.length - filename.length)
        .replace(/^\/|\/$/g, ''); // Remove leading and trailing '/'
    return (React.createElement(React.Fragment, null,
        React.createElement("span", { className: classes(fileIconStyle, 'jp-git-icon', getFileIconClass(props.filepath), props.selected && 'jp-git-selected') }),
        React.createElement("span", { className: fileLabelStyle },
            filename,
            React.createElement("span", { className: folderLabelStyle }, folder))));
};
//# sourceMappingURL=FilePath.js.map