import { IRenderMimeRegistry } from '@jupyterlab/rendermime';
import { GitExtension } from '../../model';
import { IDiffContext } from './model';
/**
 * Method to open a main menu panel to show the diff of a given Notebook file.
 * If one already exists, just activates the existing one.
 *
 * @param filePath the path relative to the Git repo root.
 * @param shell The JupyterLab shell instance
 * @param diffContext the context in which the diff is being requested
 * @param renderMime the renderMime registry instance from the
 * @param isText Is the file of textual type?
 */
export declare function openDiffView(filePath: string, model: GitExtension, diffContext: IDiffContext, renderMime: IRenderMimeRegistry, isText?: boolean): Promise<void>;
