# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ServiceDictionaryItemsv1Args', 'ServiceDictionaryItemsv1']

@pulumi.input_type
class ServiceDictionaryItemsv1Args:
    def __init__(__self__, *,
                 dictionary_id: pulumi.Input[str],
                 service_id: pulumi.Input[str],
                 items: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a ServiceDictionaryItemsv1 resource.
        :param pulumi.Input[str] dictionary_id: The ID of the dictionary that the items belong to
        :param pulumi.Input[str] service_id: The ID of the service that the dictionary belongs to
        :param pulumi.Input[Mapping[str, Any]] items: A map representing an entry in the dictionary, (key/value)
        """
        pulumi.set(__self__, "dictionary_id", dictionary_id)
        pulumi.set(__self__, "service_id", service_id)
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter(name="dictionaryId")
    def dictionary_id(self) -> pulumi.Input[str]:
        """
        The ID of the dictionary that the items belong to
        """
        return pulumi.get(self, "dictionary_id")

    @dictionary_id.setter
    def dictionary_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "dictionary_id", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Input[str]:
        """
        The ID of the service that the dictionary belongs to
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A map representing an entry in the dictionary, (key/value)
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "items", value)


@pulumi.input_type
class _ServiceDictionaryItemsv1State:
    def __init__(__self__, *,
                 dictionary_id: Optional[pulumi.Input[str]] = None,
                 items: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 service_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ServiceDictionaryItemsv1 resources.
        :param pulumi.Input[str] dictionary_id: The ID of the dictionary that the items belong to
        :param pulumi.Input[Mapping[str, Any]] items: A map representing an entry in the dictionary, (key/value)
        :param pulumi.Input[str] service_id: The ID of the service that the dictionary belongs to
        """
        if dictionary_id is not None:
            pulumi.set(__self__, "dictionary_id", dictionary_id)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)

    @property
    @pulumi.getter(name="dictionaryId")
    def dictionary_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the dictionary that the items belong to
        """
        return pulumi.get(self, "dictionary_id")

    @dictionary_id.setter
    def dictionary_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dictionary_id", value)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A map representing an entry in the dictionary, (key/value)
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the service that the dictionary belongs to
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_id", value)


class ServiceDictionaryItemsv1(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dictionary_id: Optional[pulumi.Input[str]] = None,
                 items: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Defines a map of Fastly dictionary items that can be used to populate a service dictionary.  This resource will populate a dictionary with the items and will track their state.

        > **Warning:** This provider will take precedence over any changes you make in the UI or API. Such changes are likely to be reversed if you run the provider again.

        If this provider is being used to populate the initial content of a dictionary which you intend to manage via API or UI, then the lifecycle `ignore_changes` field can be used with the resource.  An example of this configuration is provided below.

        ## Example Usage
        ### Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        config = pulumi.Config()
        mydict_name = config.get("mydictName")
        if mydict_name is None:
            mydict_name = "My Dictionary"
        myservice = fastly.Servicev1("myservice",
            domains=[fastly.Servicev1DomainArgs(
                name="demo.notexample.com",
                comment="demo",
            )],
            backends=[fastly.Servicev1BackendArgs(
                address="demo.notexample.com.s3-website-us-west-2.amazonaws.com",
                name="AWS S3 hosting",
                port=80,
            )],
            dictionaries=[fastly.Servicev1DictionaryArgs(
                name=mydict_name,
            )],
            force_destroy=True)
        items = []
        for range in [{"key": k, "value": v} for [k, v] in enumerate({d.name: d for d in myservice.dictionaries if d.name == mydict_name})]:
            items.append(fastly.ServiceDictionaryItemsv1(f"items-{range['key']}",
                service_id=myservice.id,
                dictionary_id=range["value"],
                items={
                    "key1": "value1",
                    "key2": "value2",
                }))
        ```
        ### Complex object usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        config = pulumi.Config()
        mydict = config.get_object("mydict")
        if mydict is None:
            mydict = {
                "name": "My Dictionary",
                "items": {
                    "key1": "value1x",
                    "key2": "value2x",
                },
            }
        myservice = fastly.Servicev1("myservice",
            domains=[fastly.Servicev1DomainArgs(
                name="demo.notexample.com",
                comment="demo",
            )],
            backends=[fastly.Servicev1BackendArgs(
                address="demo.notexample.com.s3-website-us-west-2.amazonaws.com",
                name="AWS S3 hosting",
                port=80,
            )],
            dictionaries=[fastly.Servicev1DictionaryArgs(
                name=mydict["name"],
            )],
            force_destroy=True)
        items = []
        for range in [{"key": k, "value": v} for [k, v] in enumerate({d.name: d for d in myservice.dictionaries if d.name == mydict.name})]:
            items.append(fastly.ServiceDictionaryItemsv1(f"items-{range['key']}",
                service_id=myservice.id,
                dictionary_id=range["value"],
                items=mydict["items"]))
        ```

        ## Import

        This is an example of the import command being applied to the resource named `fastly_service_dictionary_items_v1.items` The resource ID is a combined value of the `service_id` and `dictionary_id` separated by a forward slash.

        ```sh
         $ pulumi import fastly:index/serviceDictionaryItemsv1:ServiceDictionaryItemsv1 items xxxxxxxxxxxxxxxxxxxx/xxxxxxxxxxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dictionary_id: The ID of the dictionary that the items belong to
        :param pulumi.Input[Mapping[str, Any]] items: A map representing an entry in the dictionary, (key/value)
        :param pulumi.Input[str] service_id: The ID of the service that the dictionary belongs to
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceDictionaryItemsv1Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Defines a map of Fastly dictionary items that can be used to populate a service dictionary.  This resource will populate a dictionary with the items and will track their state.

        > **Warning:** This provider will take precedence over any changes you make in the UI or API. Such changes are likely to be reversed if you run the provider again.

        If this provider is being used to populate the initial content of a dictionary which you intend to manage via API or UI, then the lifecycle `ignore_changes` field can be used with the resource.  An example of this configuration is provided below.

        ## Example Usage
        ### Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        config = pulumi.Config()
        mydict_name = config.get("mydictName")
        if mydict_name is None:
            mydict_name = "My Dictionary"
        myservice = fastly.Servicev1("myservice",
            domains=[fastly.Servicev1DomainArgs(
                name="demo.notexample.com",
                comment="demo",
            )],
            backends=[fastly.Servicev1BackendArgs(
                address="demo.notexample.com.s3-website-us-west-2.amazonaws.com",
                name="AWS S3 hosting",
                port=80,
            )],
            dictionaries=[fastly.Servicev1DictionaryArgs(
                name=mydict_name,
            )],
            force_destroy=True)
        items = []
        for range in [{"key": k, "value": v} for [k, v] in enumerate({d.name: d for d in myservice.dictionaries if d.name == mydict_name})]:
            items.append(fastly.ServiceDictionaryItemsv1(f"items-{range['key']}",
                service_id=myservice.id,
                dictionary_id=range["value"],
                items={
                    "key1": "value1",
                    "key2": "value2",
                }))
        ```
        ### Complex object usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        config = pulumi.Config()
        mydict = config.get_object("mydict")
        if mydict is None:
            mydict = {
                "name": "My Dictionary",
                "items": {
                    "key1": "value1x",
                    "key2": "value2x",
                },
            }
        myservice = fastly.Servicev1("myservice",
            domains=[fastly.Servicev1DomainArgs(
                name="demo.notexample.com",
                comment="demo",
            )],
            backends=[fastly.Servicev1BackendArgs(
                address="demo.notexample.com.s3-website-us-west-2.amazonaws.com",
                name="AWS S3 hosting",
                port=80,
            )],
            dictionaries=[fastly.Servicev1DictionaryArgs(
                name=mydict["name"],
            )],
            force_destroy=True)
        items = []
        for range in [{"key": k, "value": v} for [k, v] in enumerate({d.name: d for d in myservice.dictionaries if d.name == mydict.name})]:
            items.append(fastly.ServiceDictionaryItemsv1(f"items-{range['key']}",
                service_id=myservice.id,
                dictionary_id=range["value"],
                items=mydict["items"]))
        ```

        ## Import

        This is an example of the import command being applied to the resource named `fastly_service_dictionary_items_v1.items` The resource ID is a combined value of the `service_id` and `dictionary_id` separated by a forward slash.

        ```sh
         $ pulumi import fastly:index/serviceDictionaryItemsv1:ServiceDictionaryItemsv1 items xxxxxxxxxxxxxxxxxxxx/xxxxxxxxxxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param ServiceDictionaryItemsv1Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceDictionaryItemsv1Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dictionary_id: Optional[pulumi.Input[str]] = None,
                 items: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceDictionaryItemsv1Args.__new__(ServiceDictionaryItemsv1Args)

            if dictionary_id is None and not opts.urn:
                raise TypeError("Missing required property 'dictionary_id'")
            __props__.__dict__["dictionary_id"] = dictionary_id
            __props__.__dict__["items"] = items
            if service_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_id'")
            __props__.__dict__["service_id"] = service_id
        super(ServiceDictionaryItemsv1, __self__).__init__(
            'fastly:index/serviceDictionaryItemsv1:ServiceDictionaryItemsv1',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dictionary_id: Optional[pulumi.Input[str]] = None,
            items: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            service_id: Optional[pulumi.Input[str]] = None) -> 'ServiceDictionaryItemsv1':
        """
        Get an existing ServiceDictionaryItemsv1 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dictionary_id: The ID of the dictionary that the items belong to
        :param pulumi.Input[Mapping[str, Any]] items: A map representing an entry in the dictionary, (key/value)
        :param pulumi.Input[str] service_id: The ID of the service that the dictionary belongs to
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceDictionaryItemsv1State.__new__(_ServiceDictionaryItemsv1State)

        __props__.__dict__["dictionary_id"] = dictionary_id
        __props__.__dict__["items"] = items
        __props__.__dict__["service_id"] = service_id
        return ServiceDictionaryItemsv1(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dictionaryId")
    def dictionary_id(self) -> pulumi.Output[str]:
        """
        The ID of the dictionary that the items belong to
        """
        return pulumi.get(self, "dictionary_id")

    @property
    @pulumi.getter
    def items(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A map representing an entry in the dictionary, (key/value)
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[str]:
        """
        The ID of the service that the dictionary belongs to
        """
        return pulumi.get(self, "service_id")

