from setuptools import setup

def readme():
    with open('README.rst') as f:
        return f.read()

setup(
    name='mlgw',
    version='1.1.0',
    author='Stefano Schmidt',
    author_email='stefanoschmidt1995@gmail.com',
    packages=['mlgw'],
    package_dir = {'mlgw':'./mlgw'},
    url="https://github.com/stefanoschmidt1995/MLGW/",
    license='CC by 4.0',
    description='Machine learning modelling of the gravitational waves generated by black-hole binaries',
    long_description=readme(),
    include_package_data = True,
    package_data={'mlgw': ['TD_model/*']},
    install_requires=[
        "numpy >= 1.16.4",
		"scipy >= 1.3.1",
		"lalsuite >= 6.62"
    ],
	long_description_content_type = 'text/x-rst'
)

