# Generated by Django 5.1.1 on 2024-10-06 19:57

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("artd_partner", "0007_position_partner"),
    ]

    operations = [
        migrations.CreateModel(
            name="PriceList",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "status",
                    models.BooleanField(
                        default=True,
                        help_text="Status of the record",
                        verbose_name="Status",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="Date and time when the record was created",
                        verbose_name="Created at",
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="Date and time when the record was updated",
                        verbose_name="Updated at",
                    ),
                ),
                (
                    "siigo_id",
                    models.CharField(
                        help_text="Siigo ID for the price list",
                        max_length=250,
                        verbose_name="Siigo ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Name of the price list",
                        max_length=250,
                        verbose_name="Name",
                    ),
                ),
                (
                    "active",
                    models.BooleanField(
                        default=True,
                        help_text="Active status of the price list",
                        verbose_name="Active",
                    ),
                ),
                (
                    "position",
                    models.IntegerField(
                        help_text="Position of the price list", verbose_name="Position"
                    ),
                ),
                (
                    "partner",
                    models.ForeignKey(
                        help_text="Partner associated with the price list",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_partner.partner",
                        verbose_name="Partner",
                    ),
                ),
            ],
            options={
                "verbose_name": "Price List",
                "verbose_name_plural": "Price Lists",
            },
        ),
        migrations.CreateModel(
            name="SiigoAccountGroup",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "status",
                    models.BooleanField(
                        default=True,
                        help_text="Status of the record",
                        verbose_name="Status",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="Date and time when the record was created",
                        verbose_name="Created at",
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="Date and time when the record was updated",
                        verbose_name="Updated at",
                    ),
                ),
                (
                    "siigo_id",
                    models.CharField(
                        help_text="Siigo ID for the account group",
                        max_length=250,
                        verbose_name="Siigo ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Name of the account group",
                        max_length=250,
                        verbose_name="Name",
                    ),
                ),
                (
                    "active",
                    models.BooleanField(
                        default=True,
                        help_text="Active status of the account group",
                        verbose_name="Active",
                    ),
                ),
                (
                    "json_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        help_text="JSON data for the account group",
                        null=True,
                        verbose_name="JSON Data",
                    ),
                ),
                (
                    "partner",
                    models.ForeignKey(
                        help_text="Partner associated with the account group",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_partner.partner",
                        verbose_name="Partner",
                    ),
                ),
            ],
            options={
                "verbose_name": "Siigo Catalog Account Group",
                "verbose_name_plural": "Siigo Catalog Account Groups",
            },
        ),
        migrations.CreateModel(
            name="SiigoCredential",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "status",
                    models.BooleanField(
                        default=True,
                        help_text="Status of the record",
                        verbose_name="Status",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="Date and time when the record was created",
                        verbose_name="Created at",
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="Date and time when the record was updated",
                        verbose_name="Updated at",
                    ),
                ),
                (
                    "siigo_partner_id",
                    models.CharField(
                        help_text="Partner ID for Siigo",
                        max_length=250,
                        verbose_name="Partner ID",
                    ),
                ),
                (
                    "api_url",
                    models.CharField(
                        help_text="API URL for Siigo",
                        max_length=250,
                        verbose_name="API URL",
                    ),
                ),
                (
                    "sandbox_username",
                    models.CharField(
                        help_text="Sandbox username for Siigo",
                        max_length=150,
                        verbose_name="Sandbox Username",
                    ),
                ),
                (
                    "sandbox_access_key",
                    models.CharField(
                        help_text="Sand Box Access Key for Siigo",
                        max_length=150,
                        verbose_name="Sand Box Access Key",
                    ),
                ),
                (
                    "production_username",
                    models.CharField(
                        blank=True,
                        help_text="Production username for Siigo",
                        max_length=150,
                        null=True,
                        verbose_name="Production Username",
                    ),
                ),
                (
                    "production_access_key",
                    models.CharField(
                        blank=True,
                        help_text="Production Access Key for Siigo",
                        max_length=150,
                        null=True,
                        verbose_name="Production Access Key",
                    ),
                ),
                (
                    "is_in_sandbox",
                    models.BooleanField(
                        default=True,
                        help_text="Is in sandbox",
                        verbose_name="Is in sandbox",
                    ),
                ),
                (
                    "siigo_credential_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        help_text="Siigo Credential Data",
                        null=True,
                        verbose_name="Siigo Credential Data",
                    ),
                ),
                (
                    "partner",
                    models.OneToOneField(
                        help_text="Partner associated with the Siigo credential",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_partner.partner",
                        verbose_name="Partner",
                    ),
                ),
            ],
            options={
                "verbose_name": "Siigo Credential",
                "verbose_name_plural": "Siigo Credentials",
            },
        ),
        migrations.CreateModel(
            name="SiigoTax",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "status",
                    models.BooleanField(
                        default=True,
                        help_text="Status of the record",
                        verbose_name="Status",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="Date and time when the record was created",
                        verbose_name="Created at",
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="Date and time when the record was updated",
                        verbose_name="Updated at",
                    ),
                ),
                (
                    "siigo_id",
                    models.CharField(
                        help_text="Siigo ID for the tax",
                        max_length=250,
                        verbose_name="Siigo ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Name of the tax", max_length=250, verbose_name="Name"
                    ),
                ),
                (
                    "type",
                    models.CharField(
                        help_text="Type of the tax", max_length=250, verbose_name="Type"
                    ),
                ),
                (
                    "percentage",
                    models.FloatField(
                        help_text="Percentage of the tax", verbose_name="Percentage"
                    ),
                ),
                (
                    "active",
                    models.BooleanField(
                        default=True,
                        help_text="Active status of the tax",
                        verbose_name="Active",
                    ),
                ),
                (
                    "json_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        help_text="JSON data for the tax",
                        null=True,
                        verbose_name="JSON Data",
                    ),
                ),
                (
                    "partner",
                    models.ForeignKey(
                        help_text="Partner associated with the tax",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_partner.partner",
                        verbose_name="Partner",
                    ),
                ),
            ],
            options={
                "verbose_name": "Siigo Catalog Tax",
                "verbose_name_plural": "Siigo Catalog Taxes",
            },
        ),
    ]
