# Generated by Django 5.1.1 on 2024-10-06 20:42

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("artd_partner", "0007_position_partner"),
        ("artd_siigo", "0003_siigopricelist_json_data"),
    ]

    operations = [
        migrations.CreateModel(
            name="Warehouse",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "status",
                    models.BooleanField(
                        default=True,
                        help_text="Status of the record",
                        verbose_name="Status",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="Date and time when the record was created",
                        verbose_name="Created at",
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="Date and time when the record was updated",
                        verbose_name="Updated at",
                    ),
                ),
                (
                    "siigo_id",
                    models.CharField(
                        help_text="Siigo ID for the warehouse",
                        max_length=250,
                        verbose_name="Siigo ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Name of the warehouse",
                        max_length=250,
                        verbose_name="Name",
                    ),
                ),
                (
                    "active",
                    models.BooleanField(
                        default=True,
                        help_text="Active status of the warehouse",
                        verbose_name="Active",
                    ),
                ),
                (
                    "has_movements",
                    models.BooleanField(
                        default=False,
                        help_text="Whether the warehouse has movements or not",
                        verbose_name="Has Movements",
                    ),
                ),
                (
                    "json_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        help_text="JSON data for the warehouse",
                        null=True,
                        verbose_name="JSON Data",
                    ),
                ),
                (
                    "partner",
                    models.ForeignKey(
                        help_text="Partner associated with the warehouse",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_partner.partner",
                        verbose_name="Partner",
                    ),
                ),
            ],
            options={
                "verbose_name": "Warehouse",
                "verbose_name_plural": "Warehouses",
            },
        ),
    ]
