# Generated by Django 5.1.1 on 2024-10-06 21:42

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("artd_partner", "0007_position_partner"),
        ("artd_siigo", "0008_siigouser_identification"),
    ]

    operations = [
        migrations.CreateModel(
            name="SiigoDocumentType",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "siigo_id",
                    models.CharField(
                        help_text="Siigo ID for the document type",
                        max_length=250,
                        verbose_name="Siigo ID",
                    ),
                ),
                (
                    "code",
                    models.CharField(
                        help_text="Code of the document type",
                        max_length=250,
                        verbose_name="Code",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Name of the document type",
                        max_length=250,
                        verbose_name="Name",
                    ),
                ),
                (
                    "description",
                    models.CharField(
                        help_text="Description of the document type",
                        max_length=250,
                        verbose_name="Description",
                    ),
                ),
                (
                    "type",
                    models.CharField(
                        help_text="Type of the document type",
                        max_length=250,
                        verbose_name="Type",
                    ),
                ),
                (
                    "active",
                    models.BooleanField(
                        default=True,
                        help_text="Active status of the document type",
                        verbose_name="Active",
                    ),
                ),
                (
                    "seller_by_item",
                    models.BooleanField(
                        default=False,
                        help_text="Whether the document type is seller by item or not",
                        verbose_name="Seller By Item",
                    ),
                ),
                (
                    "cost_center",
                    models.BooleanField(
                        default=False,
                        help_text="Whether the document type has a cost center or not",
                        verbose_name="Cost Center",
                    ),
                ),
                (
                    "cost_center_mandatory",
                    models.BooleanField(
                        default=False,
                        help_text="Whether the cost center is mandatory or not",
                        verbose_name="Cost Center Mandatory",
                    ),
                ),
                (
                    "automatic_number",
                    models.BooleanField(
                        default=False,
                        help_text="Whether the document type has an automatic number or not",
                        verbose_name="Automatic Number",
                    ),
                ),
                (
                    "consecutive",
                    models.IntegerField(
                        help_text="Consecutive of the document type",
                        verbose_name="Consecutive",
                    ),
                ),
                (
                    "discount_type",
                    models.CharField(
                        help_text="Discount type of the document type",
                        max_length=250,
                        verbose_name="Discount Type",
                    ),
                ),
                (
                    "decimals",
                    models.BooleanField(
                        default=False,
                        help_text="Whether the document type has decimals or not",
                        verbose_name="Decimals",
                    ),
                ),
                (
                    "advance_payment",
                    models.BooleanField(
                        default=False,
                        help_text="Whether the document type has advance payment or not",
                        verbose_name="Advance Payment",
                    ),
                ),
                (
                    "reteiva",
                    models.BooleanField(
                        default=False,
                        help_text="Whether the document type has rete IVA or not",
                        verbose_name="Rete IVA",
                    ),
                ),
                (
                    "reteica",
                    models.BooleanField(
                        default=False,
                        help_text="Whether the document type has rete ICA or not",
                        verbose_name="Rete ICA",
                    ),
                ),
                (
                    "self_withholding",
                    models.BooleanField(
                        default=False,
                        help_text="Whether the document type has self withholding or not",
                        verbose_name="Self Withholding",
                    ),
                ),
                (
                    "self_withholding_limit",
                    models.FloatField(
                        help_text="Self withholding limit of the document type",
                        verbose_name="Self Withholding Limit",
                    ),
                ),
                (
                    "electronic_type",
                    models.CharField(
                        help_text="Electronic type of the document type",
                        max_length=250,
                        verbose_name="Electronic Type",
                    ),
                ),
                (
                    "cargo_transportation",
                    models.BooleanField(
                        default=False,
                        help_text="Whether the document type has cargo transportation or not",
                        verbose_name="Cargo Transportation",
                    ),
                ),
                (
                    "healthcare_company",
                    models.BooleanField(
                        default=False,
                        help_text="Whether the document type has a healthcare company or not",
                        verbose_name="Healthcare Company",
                    ),
                ),
                (
                    "customer_by_item",
                    models.BooleanField(
                        default=False,
                        help_text="Whether the document type is customer by item or not",
                        verbose_name="Customer By Item",
                    ),
                ),
                (
                    "json_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        help_text="JSON data for the document type",
                        null=True,
                        verbose_name="JSON Data",
                    ),
                ),
                (
                    "partner",
                    models.ForeignKey(
                        help_text="Partner associated with the document type",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_partner.partner",
                        verbose_name="Partner",
                    ),
                ),
            ],
            options={
                "verbose_name": "Siigo CAtalog Document Type",
                "verbose_name_plural": "Siigo CAtalog Document Types",
            },
        ),
    ]
