# Generated by Django 5.1.1 on 2024-10-06 22:27

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("artd_partner", "0007_position_partner"),
        ("artd_siigo", "0010_siigodocumenttype_created_at_and_more"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="siigodocumenttype",
            options={
                "verbose_name": "Siigo Catalog Document Type",
                "verbose_name_plural": "Siigo Catalog Document Types",
            },
        ),
        migrations.CreateModel(
            name="SiigoPaymentType",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "status",
                    models.BooleanField(
                        default=True,
                        help_text="Status of the record",
                        verbose_name="Status",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="Date and time when the record was created",
                        verbose_name="Created at",
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="Date and time when the record was updated",
                        verbose_name="Updated at",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Name of the payment type",
                        max_length=250,
                        verbose_name="Name",
                    ),
                ),
                (
                    "type",
                    models.CharField(
                        help_text="Type of the payment type",
                        max_length=250,
                        verbose_name="Type",
                    ),
                ),
                (
                    "active",
                    models.BooleanField(
                        default=True,
                        help_text="Active status of the payment type",
                        verbose_name="Active",
                    ),
                ),
                (
                    "due_date",
                    models.BooleanField(
                        default=False,
                        help_text="Whether the payment type has a due date or not",
                        verbose_name="Due Date",
                    ),
                ),
                (
                    "json_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        help_text="JSON data for the payment type",
                        null=True,
                        verbose_name="JSON Data",
                    ),
                ),
                (
                    "partner",
                    models.ForeignKey(
                        help_text="Partner associated with the payment type",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_partner.partner",
                        verbose_name="Partner",
                    ),
                ),
            ],
            options={
                "verbose_name": "Siigo Catalog Payment Type",
                "verbose_name_plural": "Siigo Catalog Payment Types",
            },
        ),
    ]
