# Generated by Django 5.1.1 on 2024-10-07 02:30

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("artd_partner", "0007_position_partner"),
        ("artd_siigo", "0014_siigofixedasset"),
    ]

    operations = [
        migrations.CreateModel(
            name="SiigoProductPriceList",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "position",
                    models.PositiveIntegerField(
                        help_text="Position of the product price list",
                        verbose_name="Position",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Name of the product price list",
                        max_length=250,
                        verbose_name="Name",
                    ),
                ),
                (
                    "value",
                    models.FloatField(
                        help_text="Value of the product price list",
                        verbose_name="Value",
                    ),
                ),
                (
                    "partner",
                    models.ForeignKey(
                        help_text="Partner associated with the product",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_partner.partner",
                        verbose_name="Partner",
                    ),
                ),
            ],
            options={
                "verbose_name": "Siigo Product Price List",
                "verbose_name_plural": "Siigo Product Price Lists",
            },
        ),
        migrations.CreateModel(
            name="SiigoProductPrice",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "status",
                    models.BooleanField(
                        default=True,
                        help_text="Status of the record",
                        verbose_name="Status",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="Date and time when the record was created",
                        verbose_name="Created at",
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="Date and time when the record was updated",
                        verbose_name="Updated at",
                    ),
                ),
                (
                    "currency_code",
                    models.CharField(
                        help_text="Currency code of the product price",
                        max_length=250,
                        verbose_name="Currency Code",
                    ),
                ),
                (
                    "partner",
                    models.ForeignKey(
                        help_text="Partner associated with the product",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_partner.partner",
                        verbose_name="Partner",
                    ),
                ),
                (
                    "price_lists",
                    models.ManyToManyField(
                        help_text="Price lists for the product",
                        to="artd_siigo.siigoproductpricelist",
                        verbose_name="Price Lists",
                    ),
                ),
            ],
            options={
                "verbose_name": "Siigo Product Price",
                "verbose_name_plural": "Siigo Product Prices",
            },
        ),
        migrations.CreateModel(
            name="SiigoProductUnit",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "status",
                    models.BooleanField(
                        default=True,
                        help_text="Status of the record",
                        verbose_name="Status",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="Date and time when the record was created",
                        verbose_name="Created at",
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="Date and time when the record was updated",
                        verbose_name="Updated at",
                    ),
                ),
                (
                    "code",
                    models.CharField(
                        help_text="Code of the product unit",
                        max_length=250,
                        verbose_name="Code",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Name of the product unit",
                        max_length=250,
                        verbose_name="Name",
                    ),
                ),
                (
                    "partner",
                    models.ForeignKey(
                        help_text="Partner associated with the product",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_partner.partner",
                        verbose_name="Partner",
                    ),
                ),
            ],
            options={
                "verbose_name": "Siigo Product Unit",
                "verbose_name_plural": "Siigo Product Units",
            },
        ),
        migrations.CreateModel(
            name="SiigoProduct",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "status",
                    models.BooleanField(
                        default=True,
                        help_text="Status of the record",
                        verbose_name="Status",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(
                        auto_now_add=True,
                        help_text="Date and time when the record was created",
                        verbose_name="Created at",
                    ),
                ),
                (
                    "updated_at",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="Date and time when the record was updated",
                        verbose_name="Updated at",
                    ),
                ),
                (
                    "siigo_id",
                    models.CharField(
                        help_text="Siigo ID for the product",
                        max_length=250,
                        verbose_name="Siigo ID",
                    ),
                ),
                (
                    "code",
                    models.CharField(
                        help_text="Code of the product",
                        max_length=250,
                        verbose_name="Code",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Name of the product",
                        max_length=250,
                        verbose_name="Name",
                    ),
                ),
                (
                    "type",
                    models.CharField(
                        help_text="Type of the product",
                        max_length=250,
                        verbose_name="Type",
                    ),
                ),
                (
                    "stock_control",
                    models.BooleanField(
                        default=False,
                        help_text="Whether the product has stock control or not",
                        verbose_name="Stock Control",
                    ),
                ),
                (
                    "active",
                    models.BooleanField(
                        default=True,
                        help_text="Whether the product is active or not",
                        verbose_name="Active",
                    ),
                ),
                (
                    "tax_classification",
                    models.CharField(
                        help_text="Tax classification of the product",
                        max_length=250,
                        verbose_name="Tax Classification",
                    ),
                ),
                (
                    "tax_included",
                    models.BooleanField(
                        default=False,
                        help_text="Whether the product has tax included or not",
                        verbose_name="Tax Included",
                    ),
                ),
                (
                    "tax_consumption_value",
                    models.FloatField(
                        help_text="Tax consumption value of the product",
                        verbose_name="Tax Consumption Value",
                    ),
                ),
                (
                    "unit_label",
                    models.CharField(
                        help_text="Unit label of the product",
                        max_length=250,
                        verbose_name="Unit Label",
                    ),
                ),
                (
                    "reference",
                    models.CharField(
                        help_text="Reference of the product",
                        max_length=250,
                        verbose_name="Reference",
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        help_text="Description of the product",
                        verbose_name="Description",
                    ),
                ),
                (
                    "additional_fields",
                    models.JSONField(
                        blank=True,
                        help_text="Additional fields for the product",
                        null=True,
                        verbose_name="Additional Fields",
                    ),
                ),
                (
                    "available_quantity",
                    models.FloatField(
                        help_text="Available quantity of the product",
                        verbose_name="Available Quantity",
                    ),
                ),
                (
                    "metadata",
                    models.JSONField(
                        blank=True,
                        help_text="Metadata for the product",
                        null=True,
                        verbose_name="Metadata",
                    ),
                ),
                (
                    "account_group",
                    models.ForeignKey(
                        help_text="Account group for the product",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_siigo.siigoaccountgroup",
                        verbose_name="Account Group",
                    ),
                ),
                (
                    "partner",
                    models.ForeignKey(
                        help_text="Partner associated with the product",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_partner.partner",
                        verbose_name="Partner",
                    ),
                ),
                (
                    "taxes",
                    models.ManyToManyField(
                        help_text="Taxes for the product",
                        to="artd_siigo.siigotax",
                        verbose_name="Taxes",
                    ),
                ),
                (
                    "warehouse",
                    models.ForeignKey(
                        help_text="Warehouse for the product",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_siigo.siigowarehouse",
                        verbose_name="Warehouse",
                    ),
                ),
                (
                    "prices",
                    models.ManyToManyField(
                        help_text="Prices for the product",
                        to="artd_siigo.siigoproductprice",
                        verbose_name="Prices",
                    ),
                ),
                (
                    "unit",
                    models.ForeignKey(
                        help_text="Unit of the product",
                        on_delete=django.db.models.deletion.CASCADE,
                        to="artd_siigo.siigoproductunit",
                        verbose_name="Unit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Siigo Product",
                "verbose_name_plural": "Siigo Products",
            },
        ),
    ]
